<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Examen extends CI_Controller {
    
    
    public function __construct()
    {
        parent::__construct();                
        $this->load->helper(array('download', 'file'));  
        $this->load->library('pdf');
        $this->load->helper(array('url'));
        $this->load->library('Datatables'); 
    }

    public function detallecontroles()
    {
        $this->load->model('examen_model');

        $cons_examen                =   $this->input->post('cons_examen', true);              
        $id_paciente                =   $this->input->post('id_paciente', true);
        $datos['id_paciente']       =   $id_paciente;
        $datos['examen']            =   $this->examen_model->detallesexamen($cons_examen, $id_paciente);        
        $datos['cie']               =   $this->examen_model->ciexamencie($id_paciente, $cons_examen);
        $datos['cups']              =   $this->examen_model->cicups($id_paciente, $cons_examen);
        
        $this->load->view('front_end/historias/hexamen_de_v', $datos);
    }
   
     function ingresoexamen() 
    {

        //$this->load->library('imagenes');

        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen = $this->examen_model->consultaconsecutivo(7);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);

        $fechan      = $this->input->post('fechanacimiento', true);
        $datos['nconsulta'] =  $this->input->post('nconsulta', true);
        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /**
         * Subir firmas y foto
         */

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'               =>  $id_paciente,
            'cons_examen'               =>  $n_conexamen,
            'fechaactual'               =>  $fechaactual,
            'horaactual'                =>  $horaactual,
            'nconsulta'                 =>  $this->input->post('nconsulta', true),
            'login_ing'                 =>  $this->input->post('login', true),
            'edad'                      =>  $edad,
            'ume'                       =>  $ume,
            'cod_cons'                  =>  $this->input->post('codconsulta', true),
            'observacionescups'         =>  $this->input->post('observacionescups', true),
            'firmapaci'                 =>  $this->input->post('firmapaciente1'),
            'cod_medi'                  =>  $this->input->post('medico', true),
            'id_admi'                   =>  $this->input->post('convenios', true),
            'num_oftalmologia'          =>  $this->input->post('num_oftalmologia', true),
            'motivo_control'            =>  $this->input->post('motivo_control', true),
            'antecedentes_personales'   =>  $this->input->post('antecedentes_personales', true),
            'krimsky'                   =>  $this->input->post('krimsky', true),
            'parpados'                  =>  $this->input->post('parpados', true),
            'conjuntiva'                =>  $this->input->post('conjuntiva', true),
            'viaslagrimales'            =>  $this->input->post('viaslagrimales', true),
            'cornea'                    =>  $this->input->post('cornea', true),
            'camara'                    =>  $this->input->post('camara', true),
            'iris'                      =>  $this->input->post('iris', true),
            'pupila'                    =>  $this->input->post('pupila', true),
            'cristalino'                =>  $this->input->post('cristalino', true),
            'excavacion'                =>  $this->input->post('excavacion', true),
            'retina'                    =>  $this->input->post('retina', true),
            'fo'                        =>  $this->input->post('fo', true),
            'tension'                   =>  $this->input->post('tension', true),
            'tipo_co'                   =>  $this->input->post('tipo_co', true),
            'abierta'                   =>  'SI',
            'planotratamiento'          =>  $this->input->post('planotratamiento', true),
            'id_agenda'                 =>  $this->input->post('id_agenda', true),
            'incapacidades'             =>  $this->input->post('incapacidades', true),
            'obs_medicamentos_oft'      =>  $this->input->post('obs_medicamentos_oft', true),
            'enf_actual_oft'            =>  $this->input->post('enf_actual_oft', true),
            'agud_visula_oft'           =>  $this->input->post('agud_visula_oft', true)
        );

        $insertExa = $this->examen_model->insertExa($examen, $n_conexamen);

        $vcod_cier = $this->input->post('cod_cier', true);

        if (!$vcod_cier || $vcod_cier === '') {
            $cod_cier       =   '';
            $nombre_cier    =   '';
        } else {
            $cod_cier       =   $vcod_cier;
            $nombre_cier    =   $this->input->post('nombre_cier');
        };

        $vcod_ciers = $this->input->post('cod_ciers', true);

        if (!$vcod_ciers || $vcod_ciers === '') {
            $cod_ciers      =   '';
            $nombre_ciers   =   '';
        } else {
            $cod_ciers      =   $vcod_ciers;
            $nombre_ciers   =   $this->input->post('nombre_ciers');
        };

        $vcod_cierr = $this->input->post('cod_cierr', true);

        if (!$vcod_cierr || $vcod_cierr === '') {
            $cod_cierr      =   '';
            $nombre_cierr   =   '';
        } else {
            $cod_cierr      =   $vcod_cierr;
            $nombre_cierr   =   $this->input->post('nombre_cierr');
        };

        $ciecups = array(
            'id_paciente'        => $id_paciente,
            'cons_examen'        => $n_conexamen,
            'nconsulta'          => $this->input->post('nconsulta', true),
            //'tipo_docu'          => $tipo_docu,
            //'identificacion'     => $identificacion,
            'edad'               => $edad,
            'ume'                => $ume,
            'cod_cie'            => $this->input->post('cod_cie'),
            'nombre_cie'         => $this->input->post('nombre_cie'),
            'cod_causa_dia'      => $this->input->post('causa', true),
            'cod_fina_cie'       => $this->input->post('finalidad2', true),
            'cod_tipo'           => $this->input->post('tipoo', true),
            'observacionescie'   => $this->input->post('observacionescie', true),
            'cod_cier'           => $cod_cier,      
            'nombre_cier'        => $nombre_cier,          
            'observacionescier'  => $this->input->post('observacionescier', true),
            'cod_ciers'          => $cod_ciers,
            'nombre_ciers'       => $nombre_ciers,
            'observacionesciers' => $this->input->post('observacionesciers', true),
            'cod_cierr'          => $cod_cierr,
            'nombre_cierr'       => $nombre_cierr,
            'observacionescierr' => $this->input->post('observacionescierr', true),
            'fechaactual'        => $fechaactual,
            'horaactual'         => $horaactual,
            'cod_medi'           => '110010756401',
            'cod_cons'           => $this->input->post('codconsulta'),
            'login_ing'          => $this->input->post('login', true),
            'id_admi'            => $this->input->post('convenios', true),
            'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
            //'revolucion'         => 'SI',
            //'nevolucion'         => $this->input->post('version', true),
            'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
            'activo'             => 'SI'
        );

        $this->examen_model->insertCieCups($ciecups);

        $cod_cups = $this->input->post('cod_cups');

        if ($cod_cups) {

            for ($i = 0; $i < count($this->input->post('cod_cups')); $i++) {

                if (!$this->input->post('actoqcupso', true)[$i] && $this->input->post('actoqcupso', true)[$i] === '') {
                    $actoQuirirgico = '';
                } else {
                    $actoQuirirgico = $this->input->post('actoqcupso', true)[$i];
                }

                $cups = [
                    'id_paciente'    => $id_paciente,
                    'cons_examen'    => $n_conexamen,
                    'nconsulta'      => $this->input->post('nconsulta', true),
                    'edad'           => $edad,
                    'ume'            => $ume,
                    'cod_cups'       => $this->input->post('cod_cups')[$i],
                    'nombre_cups'    => $this->input->post('nombre_cups')[$i],
                    'id_finalidad'   => $this->input->post('finalidadcupso', true)[$i],
                    'cod_ambi'       => $this->input->post('ambitocupso', true)[$i],
                    'cod_actoq'      => $actoQuirirgico,
                    'lateralidad'    => $this->input->post('lateralidad', true)[$i],
                    'autorizacion'   => $this->input->post('autorizacion', true)[$i],
                    'cantidad'       => $this->input->post('cantidad_cups_oft', true)[$i],
                    'valor_cups'     => $this->input->post('valor_cups')[$i],
                    'fechaactual'    => $fechaactual,
                    'horaactual'     => $horaactual,
                    'cod_medi'       => '110010756401',
                    'cod_cons'       => $this->input->post('codconsulta'),
                    'login_ing'      => $this->input->post('login', true),
                    'id_admi'        => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
                    'activo'             => 'SI'
                ];
                $this->examen_model->insertCieCups($cups);
            }

        }

        // mas cie diagnosticos
        $mas_cups = $this->input->post('cod_cierr_mop');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cierr_mop')); $i++) 
            {
                $mciecups = array(
                    'id_paciente'        => $id_paciente,
                    'cons_examen'        => $n_conexamen,
                    'nconsulta'          => $this->input->post('nconsulta', true),
                    'edad'               => $edad,
                    'ume'                => $ume,
                    'cod_causa_dia'      => $this->input->post('causa', true),
                    'cod_fina_cie'       => $this->input->post('finalidad2', true),
                    'cod_tipo'           => $this->input->post('tipoo', true),
                    'fechaactual'        => $fechaactual,
                    'horaactual'         => $horaactual,
                    'cod_medi'           => '110010756401',
                    'cod_cons'           => $this->input->post('codconsulta'),
                    'login_ing'          => $this->input->post('login', true),
                    'id_admi'            => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
                    'cod_ciemas'         => $this->input->post('cod_cierr_mop', true)[$i],
                    'nombre_ciemas'      => $this->input->post('nombre_cierr_mop', true)[$i],
                    'observaciones_ciemas'   => $this->input->post('observaciones_cierr_mop', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertCieCups($mciecups);
            }
        }

        // medicamentos oftalmologia
        $mas_cups = $this->input->post('id_medicamento');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('id_medicamento')); $i++) 
            {
                $m_medicamentos = array(
                    'id_paciente'               =>  $id_paciente,
                    'cons_examen'               =>  $n_conexamen,
                    'fechaactual'               =>  $fechaactual,
                    'horaactual'                =>  $horaactual,
                    'nconsulta'                 =>  $this->input->post('nconsulta', true),
                    'login_ing'                 =>  $this->input->post('login', true),
                    'cod_medi'                  =>  $this->input->post('medico', true),
                    'id_admi'                   =>  $this->input->post('convenios', true),
                    'tipo_historia'             =>  'OFTALMOLOGIA',
                    'id_medicamento'            =>  $this->input->post('id_medicamento', true)[$i],
                    'nombre_medicamento'        =>  $this->input->post('nombre_medicamento', true)[$i],
                    'concentracion'             =>  $this->input->post('concentracion', true)[$i],
                    'prescripcion'              =>  $this->input->post('prescripcion', true)[$i],
                    'cantidad'                  =>  $this->input->post('cantidad', true)[$i],
                    'tiempo'                    =>  $this->input->post('tiempo', true)[$i],
                    'activo'                    => 'SI'
                );
                $this->examen_model->insertMedicamentos($m_medicamentos);
            }
        }

        // paraclinicos
        $cod_para = $this->input->post('cod_para');
        if ($cod_para) 
        {
            for ($i = 0; $i < count($this->input->post('cod_para')); $i++) 
            { 
                $m_para = array(
                    'id_paciente'        => $this->input->post('id_paciente'),
                    'cons_examen'        => $n_conexamen,
                    'cons_paraclinico'   => $n_conparaclinico,
                    'login_ing'          => $this->input->post('login', true),
                    'cod_para'           => $this->input->post('cod_para', true)[$i],
                    'nombre_para'        => $this->input->post('nombre_para', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertPara($m_para, $n_conparaclinico);
            }
        }


        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            'ultimocontrol'         =>  $fechaactual,
            'version'               =>  $this->input->post('version', true),
            'num_oftalmologia'      => $this->input->post('num_oftalmologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // actualiza agenda color y evento
        $id_agenda          =    $this->input->post('id_agenda', true);
        if($id_agenda === '')
        {

        }else
        {
            $m_agenda   =   array(
                'estado'        =>   'Atendio',
                'color'         =>   '#5cb85c',
                'fecha_atendio' =>   $fechaactual,
                'hora_atendio'  =>   $horaactual,
                'login_atendio' =>   $this->input->post('login', true)
            );
            $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
        }    

        // CONSULTA DE PACIENTE NUEVO
        //$this->load->library('s3');

        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
        $datos['num_oftalmologia']      =  $this->input->post('num_oftalmologia', true);
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['cons_examen']           =   $n_conexamen;

        // consulta de la firma del medico
        $f_med          =   $this->input->post('medico', true);
        $datos['firma_medico_img']     =   $this->examen_model->firma_medi_exa($f_med);

        $examen_oft                     =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        if($examen_oft)
        {
            foreach($examen_oft as $fmedi)
            {
                $f_med                          =   $fmedi->cod_medi;
                $firma_medico_img               =   $this->examen_model->firma_medi_exa($f_med);
                if($firma_medico_img)
                {
                    foreach($firma_medico_img as $fmedi)
                    {
                        $datos['f_medico']  =   $fmedi['firmamedi'];
                    }
                }else
                {
                    $datos['f_medico']  =   '';
                }
            }
        }

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    // actualizar oftalmologia
    // actualizando historia oftalmologica
    public function actualizaexamen() 
    {
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->input->post('ofatlmologia_abierta', true);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);
        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        $id_paciente                =   $this->input->post('id_paciente', true);
        //$tipo_docu                  =   $this->input->post('tipo_docu', true);
        //$identificacion             =   $this->input->post('identificacion', true);

        $examen = array(

            'id_paciente'               =>  $id_paciente,
            'cons_examen'               =>  $n_conexamen,
            'fechaactual'               =>  $fechaactual,
            'horaactual'                =>  $horaactual,
            'nconsulta'                 =>  $this->input->post('nconsulta', true),
            'login_ing'                 =>  $this->input->post('login', true),
            'edad'                      =>  $edad,
            'ume'                       =>  $ume,
            'cod_cons'                  =>  $this->input->post('codconsulta', true),
            'observacionescups'         =>  $this->input->post('observacionescups', true),
            'firmapaci'                 =>  $this->input->post('firmapaciente1'),
            'cod_medi'                  =>  $this->input->post('medico', true),
            'id_admi'                   =>  $this->input->post('convenios', true),
            'num_oftalmologia'          =>  $this->input->post('num_oftalmologia', true),
            'motivo_control'            =>  $this->input->post('motivo_control', true),
            'antecedentes_personales'   =>  $this->input->post('antecedentes_personales', true),
            'krimsky'                   =>  $this->input->post('krimsky', true),
            'parpados'                  =>  $this->input->post('parpados', true),
            'conjuntiva'                =>  $this->input->post('conjuntiva', true),
            'viaslagrimales'            =>  $this->input->post('viaslagrimales', true),
            'cornea'                    =>  $this->input->post('cornea', true),
            'camara'                    =>  $this->input->post('camara', true),
            'iris'                      =>  $this->input->post('iris', true),
            'pupila'                    =>  $this->input->post('pupila', true),
            'cristalino'                =>  $this->input->post('cristalino', true),
            'excavacion'                =>  $this->input->post('excavacion', true),
            'retina'                    =>  $this->input->post('retina', true),
            'fo'                        =>  $this->input->post('fo', true),
            'tension'                   =>  $this->input->post('tension', true),
            'tipo_co'                   =>  $this->input->post('tipo_co', true),
            'abierta'                   =>  'SI',
            'planotratamiento'          =>  $this->input->post('planotratamiento', true),
            'id_agenda'                 =>  $this->input->post('id_agenda', true),
            'incapacidades'          =>  $this->input->post('incapacidades', true),
            'obs_medicamentos_oft'      =>  $this->input->post('obs_medicamentos_oft', true),
            'enf_actual_oft'            =>  $this->input->post('enf_actual_oft', true),
            'agud_visula_oft'           =>  $this->input->post('agud_visula_oft', true)
        );

        $updateExa = $this->examen_model->updateExa($examen, $n_conexamen);

        // colocar inactivo los cie en ciecups
        $m_cie_activo   =    array(
            'activo'    => 'NO');

        $update_cie_activo  =   $this->examen_model->updateCIEActivo($m_cie_activo, $n_conexamen);

        // proceso del cie
        $vcod_cier = $this->input->post('cod_cier', true);

        if (!$vcod_cier || $vcod_cier === '') {
            $cod_cier       =   '';
            $nombre_cier    =   '';
        } else {
            $cod_cier       =   $vcod_cier;
            $nombre_cier    =   $this->input->post('nombre_cier');
        };

        $vcod_ciers = $this->input->post('cod_ciers', true);

        if (!$vcod_ciers || $vcod_ciers === '') {
            $cod_ciers      =   '';
            $nombre_ciers   =   '';
        } else {
            $cod_ciers      =   $vcod_ciers;
            $nombre_ciers   =   $this->input->post('nombre_ciers');
        };

        $vcod_cierr = $this->input->post('cod_cierr', true);

        if (!$vcod_cierr || $vcod_cierr === '') {
            $cod_cierr      =   '';
            $nombre_cierr   =   '';
        } else {
            $cod_cierr      =   $vcod_cierr;
            $nombre_cierr   =   $this->input->post('nombre_cierr');
        };

        $ciecups = array(
            'id_paciente'        => $id_paciente,
            'cons_examen'        => $n_conexamen,
            'nconsulta'          => $this->input->post('nconsulta', true),
            'edad'               => $edad,
            'ume'                => $ume,
            'cod_cie'            => $this->input->post('cod_cie'),
            'nombre_cie'         => $this->input->post('nombre_cie'),
            'cod_causa_dia'      => $this->input->post('causa', true),
            'cod_fina_cie'       => $this->input->post('finalidad2', true),
            'cod_tipo'           => $this->input->post('tipoo', true),
            'observacionescie'   => $this->input->post('observacionescie', true),
            'cod_cier'           => $cod_cier,      
            'nombre_cier'        => $nombre_cier,          
            'observacionescier'  => $this->input->post('observacionescier', true),
            'cod_ciers'          => $cod_ciers,
            'nombre_ciers'       => $nombre_ciers,
            'observacionesciers' => $this->input->post('observacionesciers', true),
            'cod_cierr'          => $cod_cierr,
            'nombre_cierr'       => $nombre_cierr,
            'observacionescierr' => $this->input->post('observacionescierr', true),
            'fechaactual'        => $fechaactual,
            'horaactual'         => $horaactual,
            'cod_medi'           => '110010756401',
            'cod_cons'           => $this->input->post('codconsulta'),
            'login_ing'          => $this->input->post('login', true),
            'id_admi'            => $this->input->post('convenios', true),
            'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
            'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
            'activo'             => 'SI'
        );

        $this->examen_model->insertCieCups($ciecups);

        $cod_cups = $this->input->post('cod_cups');

        if ($cod_cups) {

            for ($i = 0; $i < count($this->input->post('cod_cups')); $i++) {

                if (!$this->input->post('actoqcupso', true)[$i] && $this->input->post('actoqcupso', true)[$i] === '') {
                    $actoQuirirgico = '';
                } else {
                    $actoQuirirgico = $this->input->post('actoqcupso', true)[$i];
                }

                $cups = [
                    'id_paciente'    => $id_paciente,
                    'cons_examen'    => $n_conexamen,
                    'nconsulta'      => $this->input->post('nconsulta', true),
                    'edad'           => $edad,
                    'ume'            => $ume,
                    'cod_cups'       => $this->input->post('cod_cups')[$i],
                    'nombre_cups'    => $this->input->post('nombre_cups')[$i],
                    'id_finalidad'   => $this->input->post('finalidadcupso', true)[$i],
                    'cod_ambi'       => $this->input->post('ambitocupso', true)[$i],
                    'cod_actoq'      => $actoQuirirgico,
                    'lateralidad'    => $this->input->post('lateralidad', true)[$i],
                    'cantidad'       => $this->input->post('cantidad_cups_oft', true)[$i],
                    'autorizacion'   => $this->input->post('autorizacion', true)[$i],
                    'valor_cups'     => $this->input->post('valor_cups')[$i],
                    'fechaactual'    => $fechaactual,
                    'horaactual'     => $horaactual,
                    'cod_medi'       => '110010756401',
                    'cod_cons'       => $this->input->post('codconsulta'),
                    'login_ing'      => $this->input->post('login', true),
                    'id_admi'        => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
                    'activo'             => 'SI'
                ];
                $this->examen_model->insertCieCups($cups);
            }
        }

        // mas cie diagnosticos
        $mas_cups = $this->input->post('cod_cierr_mop');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cierr_mop')); $i++) 
            {
                $mciecups = array(
                    'id_paciente'        => $id_paciente,
                    'cons_examen'        => $n_conexamen,
                    'nconsulta'          => $this->input->post('nconsulta', true),
                    'edad'               => $edad,
                    'ume'                => $ume,
                    'cod_causa_dia'      => $this->input->post('causa', true),
                    'cod_fina_cie'       => $this->input->post('finalidad2', true),
                    'cod_tipo'           => $this->input->post('tipoo', true),
                    'fechaactual'        => $fechaactual,
                    'horaactual'         => $horaactual,
                    'cod_medi'           => '110010756401',
                    'cod_cons'           => $this->input->post('codconsulta'),
                    'login_ing'          => $this->input->post('login', true),
                    'id_admi'            => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
                    'cod_ciemas'         => $this->input->post('cod_cierr_mop', true)[$i],
                    'nombre_ciemas'      => $this->input->post('nombre_cierr_mop', true)[$i],
                    'observaciones_ciemas'   => $this->input->post('observaciones_cierr_mop', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertCieCups($mciecups);
            }
        }

        // medicamentos oftalmologia
        // colocar inactivo los medicamentos en ciecups
        $m_med_activo   =    array(
            'activo'    => 'NO');

        $update_med_activo  =   $this->examen_model->updateMEDActivo($m_med_activo, $n_conexamen);
        
        $mas_medicamento = $this->input->post('id_medicamento');
        if ($mas_medicamento) 
        {
            for ($i = 0; $i < count($this->input->post('id_medicamento')); $i++) 
            {
                $m_medicamentos = array(
                    'id_paciente'               =>  $id_paciente,
                    'cons_examen'               =>  $n_conexamen,
                    'fechaactual'               =>  $fechaactual,
                    'horaactual'                =>  $horaactual,
                    'nconsulta'                 =>  $this->input->post('nconsulta', true),
                    'login_ing'                 =>  $this->input->post('login', true),
                    'cod_medi'                  =>  $this->input->post('medico', true),
                    'id_admi'                   =>  $this->input->post('convenios', true),
                    'tipo_historia'             =>  'OFTALMOLOGIA',
                    'id_medicamento'            =>  $this->input->post('id_medicamento', true)[$i],
                    'nombre_medicamento'        =>  $this->input->post('nombre_medicamento', true)[$i],
                    'concentracion'             =>  $this->input->post('concentracion', true)[$i],
                    'prescripcion'              =>  $this->input->post('prescripcion', true)[$i],
                    'cantidad'                  =>  $this->input->post('cantidad', true)[$i],
                    'tiempo'                    =>  $this->input->post('tiempo', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertMedicamentos($m_medicamentos);
            }
        }

        // paraclinicos
        $m_para_activo   =    array(
            'activo'    => 'NO');

        $update_para_activo  =   $this->examen_model->updatePARAActivo($m_para_activo, $n_conexamen);

        $cod_para = $this->input->post('cod_para');
        if ($cod_para) 
        {
            for ($i = 0; $i < count($this->input->post('cod_para')); $i++) 
            { 
                $m_para = array(
                    'id_paciente'        => $this->input->post('id_paciente'),
                    'cons_examen'        => $n_conexamen,
                    'cons_paraclinico'   => $n_conparaclinico,
                    'login_ing'          => $this->input->post('login', true),
                    'cod_para'           => $this->input->post('cod_para', true)[$i],
                    'nombre_para'        => $this->input->post('nombre_para', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertPara($m_para, $n_conparaclinico);
            }
        }

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            'ultimocontrol'         =>  $fechaactual,
            //'version'               =>  $this->input->post('version', true),
            //'num_oftalmologia'      =>  $this->input->post('num_oftalmologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // CONSULTA DE PACIENTE NUEVO

        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['id_paciente']           =   $id_paciente;
        //$datos['identificacion']        =   $identificacion;
        //$datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        //$datos['n_conparaclinico']      =   $n_conparaclinico;

        $f_med          =   $this->input->post('medico', true);
        $datos['firma_medico_img']     =   $this->examen_model->firma_medi_exa($f_med);

        $examen_oft                     =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        if($examen_oft)
        {
            foreach($examen_oft as $fmedi)
            {
                $f_med                          =   $fmedi->cod_medi;
                $firma_medico_img               =   $this->examen_model->firma_medi_exa($f_med);
                if($firma_medico_img)
                {
                    foreach($firma_medico_img as $fmedi)
                    {
                        $datos['f_medico']  =   $fmedi['firmamedi'];
                    }
                }else
                {
                    $datos['f_medico']  =   '';
                }
            }
        }

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    // cerrar historia clinica
    public function cerrar_examen_oft() 
    {
        $this->load->model('examen_model');
        $n_conexamen            =   $this->input->post('ofatlmologia_abierta', true);
        $id_paciente            =   $this->input->post('id_paciente', true);

        $m_cerrar_oft           =   array(
            'abierta'           =>  'NO');

        $cerrar_oftalmologia    =   $this->examen_model->cerrar_oftalmologia($m_cerrar_oft, $n_conexamen);

        // CONSULTA DE PACIENTE NUEVO
        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['id_paciente']           =   $id_paciente;
        //$datos['identificacion']        =   $identificacion;
        //$datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        //$datos['n_conparaclinico']      =   $n_conparaclinico;
        $f_med          =   $this->input->post('medico', true);
        $datos['firma_medico_img']     =   $this->examen_model->firma_medi_exa($f_med);

        $examen_oft                     =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        if($examen_oft)
        {
            foreach($examen_oft as $fmedi)
            {
                $f_med                          =   $fmedi->cod_medi;
                $firma_medico_img               =   $this->examen_model->firma_medi_exa($f_med);
                if($firma_medico_img)
                {
                    foreach($firma_medico_img as $fmedi)
                    {
                        $datos['f_medico']  =   $fmedi['firmamedi'];
                    }
                }else
                {
                    $datos['f_medico']  =   '';
                }
            }
        }

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    public function rep_historia()
    {
        $this->load->model('examen_model');
        //$this->load->library('s3');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('n_conexamen');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);

        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
        

        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // PRESTADOR
        //$prestador          =   $this->examen_model->prestador();
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto     =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $nombre_admi    =   $pac->nombre_admi;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        foreach($examen as $exa)
        {
            $fecha_consulta  =   $exa->fechaactual;
            $hora_consulta   =   $exa->horaactual;
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $incapacidades                  =   $exa->incapacidades;
            $cod_medi       =   $exa->cod_medi;

        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 

        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        /////
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();

        foreach($examen as $exa)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('EXAMEN BIOMICROSCOPICO'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());  

            // MEDICO, TIPO CONSULTA
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
            $this->pdf->SetX(45);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi),0,0,'L');
            
            $this->pdf->SetX(165);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(25,4,utf8_decode('Número Control:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(40,4,utf8_decode($exa->num_oftalmologia),0,0,'L');
            $this->pdf->Ln();

            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
            $this->pdf->SetX(45);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa->nombre_listap),0,0,'L');
            $this->pdf->Ln();

            if($exa->motivo_control)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Motivo Consulta:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->motivo_control),0,'J');
            }

            if($exa->antecedentes_personales)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Antecedentes personales:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->antecedentes_personales),0,'J');
            }

            if($exa->enf_actual_oft)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Enfermedad Actual:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->enf_actual_oft),0,'J');
            }

            if($exa->agud_visula_oft)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Agudeza Visual:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->agud_visula_oft),0,'J');
            }

            if($exa->krimsky)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Examen KRIMSKY:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->krimsky),0,'J');
            }

            if($exa->parpados)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Parpados:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->parpados),0,'J');
            }

            if($exa->conjuntiva)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Conjuntiva:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->conjuntiva),0,'J');
            }

            if($exa->viaslagrimales)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Vías Lagrimales:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->viaslagrimales),0,'J');
            }
            
            if($exa->cornea)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Cornea:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->cornea),0,'J');
            }

            if($exa->iris)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Iris:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->iris),0,'J');
            }

            if($exa->pupila)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Pupila:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->pupila),0,'J');
            }

            if($exa->cristalino)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Cristalino:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->cristalino),0,'J');
            }

            if($exa->excavacion)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Excavación:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->excavacion),0,'J');
            }

            if($exa->fo)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Fondo de Ojo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->fo),0,'J');
            }

            if($exa->tension)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tensión:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->tension),0,'J');
            }
        }

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());   
                

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');    
                }
                

                if($ci['cod_cier'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                    if($ci['observacionescier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                    }
                    
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                    if($ci['observacionesciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                    if($ci['observacionescierr'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                    }
                }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }

        // paraclinicos
        if($paraclinicos)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('PREQUIRURGICOS'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
            $this->pdf->Ln();

            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(150));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($paraclinicos)
            {
                foreach ($paraclinicos as $para) 
                {   
                    $nombre_para            =   utf8_decode($para['nombre_para']);
                    
                    
                    $this->pdf->Row(array($nombre_para));
                }
            }    
        }

        // ordenes medicas
        if($cups)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('ORDENES MÉDICAS'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
            $this->pdf->Ln();
            
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(150,20,20));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','R'));

            if($cups)
            {
                foreach ($cups as $row) 
                {   
                    $cod_cups            =   utf8_decode($row['cod_cups'].'-'.$row['nombre_cups']);
                    $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                    $cantidad            =   utf8_decode($row['cantidad']);
                    
                    
                    $this->pdf->Row(array($cod_cups, $nombre_lateralidad, $cantidad));
                }
            }    
        }

        // observaciones cups
        if($exa->observacionescups)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($exa->observacionescups),0,'J');
            $this->pdf->Ln();
        }
        
        // medicamentos
        if($medicamentos)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('MEDICAMENTOS'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
            $this->pdf->Ln();

            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(68,38,38,15,30));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','L','L','L'));

            if($medicamentos)
            {
                foreach ($medicamentos as $med) 
                {   
                    $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                    $concentracion              =   utf8_decode($med['concentracion']);
                    $prescripcion               =   utf8_decode($med['prescripcion']);
                    $cantidad                   =   utf8_decode($med['cantidad']);
                    $tiempo                     =   utf8_decode($med['tiempo']);
                    
                    $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                }
            }    
        }

        // incapacidades
        if($incapacidades)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('INCAPACIDAD'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
            $this->pdf->Ln();

            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
        }

        // observaciones medicamentos
        if($exa->obs_medicamentos_oft)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones medicamentos:'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($exa->obs_medicamentos_oft),0,'J');
            $this->pdf->Ln();   
        }

        // recomendaciones
        if($exa->planotratamiento)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Recomendaciones:'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($exa->planotratamiento),0,'J');
            $this->pdf->Ln();   
        }

        
        // FIRMAS X EVOLUCION
        if($c_firma_medico)
        {
            //$this->pdf->Cell(15,4,$c_firma_medico,0,0,'L');
            $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);
        
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        
        $this->pdf->Output("Reporte historia.pdf", 'I');
    }

    public function ingresoexamen_opt() 
    {
        //var_dump($this->input->post());
        //exit();
        //$this->load->library('imagenes');

        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->examen_model->consultaconsecutivo(7);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);

        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso       =   date("Y-m-d");
        $horaingreso        =   date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /**
         * Subir firmas y foto
         */

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1_op'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1_op'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'                   =>  $id_paciente,
            'cons_examen'                   =>  $n_conexamen,
            'fechaactual'                   =>  $fechaactual,
            'horaactual'                    =>  $horaactual,
            'nconsulta'                     =>  $this->input->post('nconsulta', true),
            'login_ing'                     =>  $this->input->post('login', true),
            'edad'                          =>  $edad,
            'ume'                           =>  $ume,
            'cod_cons'                      =>  $this->input->post('codconsulta_op', true),
            'observacionescups'             =>  $this->input->post('observacionescups_op', true),
            'firmapaci'                     =>  $this->input->post('firmapaciente1_op'),
            'firmamedi'                     =>  $this->input->post('firmamedico1_op'),
            'cod_medi'                      =>  $this->input->post('medico_op', true),
            'num_optometria'                =>  $this->input->post('num_optometria', true),
            'cod_consultorio'               =>  $this->input->post('consultorios_op', true),
            'id_admi'                       =>  $this->input->post('convenios_op', true),
            'motivo_consulta'               =>  $this->input->post('motivo_consulta', true),
            'ant_personales'                =>  $this->input->post('ant_personales', true),
            'ant_familiares'                =>  $this->input->post('ant_familiares', true),
            'ant_ocupacionales'             =>  $this->input->post('ant_ocupacionales', true),
            'ant_usa_anteojos'              =>  $this->input->post('ant_usa_anteojos', true),
            'ant_lentes_cont'               =>  $this->input->post('ant_lentes_cont', true),
            'ant_tipo_uso'                  =>  $this->input->post('ant_tipo_uso', true),
            'sintomatologia'                =>  $this->input->post('sintomatologia', true),
            'avsc_od_vl'                    =>  $this->input->post('avsc_od_vl', true),
            'avsc_od_vp'                    =>  $this->input->post('avsc_od_vp', true),
            'avsc_od_ph'                    =>  $this->input->post('avsc_od_ph', true),
            'avcc_od'                       =>  $this->input->post('avcc_od', true),
            'avcc_od_vl'                    =>  $this->input->post('avcc_od_vl', true),
            'avcc_od_vp'                    =>  $this->input->post('avcc_od_vp', true),
            'avsc_oi_vl'                    =>  $this->input->post('avsc_oi_vl', true),
            'avsc_oi_vp'                    =>  $this->input->post('avsc_oi_vp', true),
            'avsc_oi_ph'                    =>  $this->input->post('avsc_oi_ph', true),
            'avcc_oi'                       =>  $this->input->post('avcc_oi', true),
            'avcc_oi_vl'                    =>  $this->input->post('avcc_oi_vl', true),
            'avcc_oi_vp'                    =>  $this->input->post('avcc_oi_vp', true),
            'avsc_ao_vl'                    =>  $this->input->post('avsc_ao_vl', true),
            'avsc_ao_vp'                    =>  $this->input->post('avsc_ao_vp', true),
            'avsc_ao_ph'                    =>  $this->input->post('avsc_ao_ph', true),
            'avcc_ao'                       =>  $this->input->post('avcc_ao', true),
            'avcc_ao_vl'                    =>  $this->input->post('avcc_ao_vl', true),
            'avcc_ao_vp'                    =>  $this->input->post('avcc_ao_vp', true),
            'exa_ext_od'                    =>  $this->input->post('exa_ext_od', true),
            'exa_ext_oi'                    =>  $this->input->post('exa_ext_oi', true),
            'reflejos_obs'                  =>  $this->input->post('reflejos_obs', true),
            'ct_vl'                         =>  $this->input->post('ct_vl', true),
            'ct_vp'                         =>  $this->input->post('ct_vp', true),
            'motilidad_ocular'              =>  $this->input->post('motilidad_ocular', true),
            'observaciones_opt'             =>  $this->input->post('observaciones_opt', true),
            'ppc_observacion'               =>  $this->input->post('ppc_observacion', true),
            'oftalmoscopia_od'              =>  $this->input->post('oftalmoscopia_od', true),
            'oftalmoscopia_oi'              =>  $this->input->post('oftalmoscopia_oi', true),
            'queratrometria_od'             =>  $this->input->post('queratrometria_od', true),
            'queratrometria_oi'             =>  $this->input->post('queratrometria_oi', true),
            'refraccion_od'                 =>  $this->input->post('refraccion_od', true),
            'refraccion_av_od'              =>  $this->input->post('refraccion_av_od', true),
            'refraccion_oi'                 =>  $this->input->post('refraccion_oi', true),
            'refraccion_av_oi'              =>  $this->input->post('refraccion_av_oi', true),
            'subjetivo_od   '               =>  $this->input->post('subjetivo_od', true),
            'subjetivo_vl_od'               =>  $this->input->post('subjetivo_vl_od', true),
            'subjetivo_vp_od'               =>  $this->input->post('subjetivo_vp_od', true),
            'subjetivo_add_od'              =>  $this->input->post('subjetivo_add_od', true),
            'subjetivo_oi'                  =>  $this->input->post('subjetivo_oi', true),
            'subjetivo_vl_oi'               =>  $this->input->post('subjetivo_vl_oi', true),
            'subjetivo_vp_oi'               =>  $this->input->post('subjetivo_vp_oi', true),
            'subjetivo_add_oi'              =>  $this->input->post('subjetivo_add_oi', true),
            'rx_final_od'                   =>  $this->input->post('rx_final_od', true),
            'rx_final_vl_od'                =>  $this->input->post('rx_final_vl_od', true),
            'rx_final_vp_od'                =>  $this->input->post('rx_final_vp_od', true),
            'rx_final_add_od'               =>  $this->input->post('rx_final_add_od', true),
            'rx_final_npd_od'               =>  $this->input->post('rx_final_npd_od', true),
            'rx_final_alt_od'               =>  $this->input->post('rx_final_alt_od', true),
            'rx_final_oi'                   =>  $this->input->post('rx_final_oi', true),
            'rx_final_vl_oi'                =>  $this->input->post('rx_final_vl_oi', true),
            'rx_final_vp_oi'                =>  $this->input->post('rx_final_vp_oi', true),
            'rx_final_add_oi'               =>  $this->input->post('rx_final_add_oi', true),
            'rx_final_npd_oi'               =>  $this->input->post('rx_final_npd_oi', true),
            'rx_final_alt_oi'               =>  $this->input->post('rx_final_alt_oi', true),
            'rx_final_tl'                   =>  $this->input->post('rx_final_tl', true),
            'vision_color_od'               =>  $this->input->post('vision_color_od', true),
            'vision_color_oi'               =>  $this->input->post('vision_color_oi', true),
            'estereopsis_od'                =>  $this->input->post('estereopsis_od', true),
            'estereopsis_oi'                =>  $this->input->post('estereopsis_oi', true),
            'c_corr_opt_perm'               =>  $this->input->post('c_corr_opt_perm', true),
            'c_corr_opt_vp'                 =>  $this->input->post('c_corr_opt_vp', true),
            'c_corr_opt_vl'                 =>  $this->input->post('c_corr_opt_vl', true),
            'c_corr_opt_o'                  =>  $this->input->post('c_corr_opt_o', true),
            'rem_val_or'                    =>  $this->input->post('rem_val_or', true),
            'rem_val_op'                    =>  $this->input->post('rem_val_op', true),
            'rem_rea_topo'                  =>  $this->input->post('rem_rea_topo', true),
            'rem_val_oft'                   =>  $this->input->post('rem_val_oft', true),
            'rem_otras'                     =>  $this->input->post('rem_otras', true),
            'comentarios'                   =>  $this->input->post('comentarios', true),
            'tipo_co'                       =>  $this->input->post('tipo_co_op', true),
            'abierta'                       =>  'SI',
            'planotratamiento'              =>  $this->input->post('planotratamiento_op', true),
            'id_agenda'                     =>  $this->input->post('id_agenda_op', true),
            'incapacidades'                 =>  $this->input->post('incapacidades_op', true),
            'obs_medicamentos_opt'          =>  $this->input->post('obs_medicamentos_opt', true)
        );

            $insertExa = $this->examen_model->insertExa_opt($examen, $n_conexamen);

            $vcod_cier = $this->input->post('cod_cier_op', true);

            if (!$vcod_cier || $vcod_cier === '') {
                $cod_cier       =   '';
                $nombre_cier    =   '';
            } else {
                $cod_cier       =   $vcod_cier;
                $nombre_cier    =   $this->input->post('nombre_cier_op');
            };

            $vcod_ciers = $this->input->post('cod_ciers_op', true);

            if (!$vcod_ciers || $vcod_ciers === '') {
                $cod_ciers      =   '';
                $nombre_ciers   =   '';
            } else {
                $cod_ciers      =   $vcod_ciers;
                $nombre_ciers   =   $this->input->post('nombre_ciers_op');
            };

            $vcod_cierr = $this->input->post('cod_cierr_op', true);

            if (!$vcod_cierr || $vcod_cierr === '') {
                $cod_cierr      =   '';
                $nombre_cierr   =   '';
            } else {
                $cod_cierr      =   $vcod_cierr;
                $nombre_cierr   =   $this->input->post('nombre_cierr_op');
            };

            $ciecups = array(
                'id_paciente'        => $id_paciente,
                'cons_examen'        => $n_conexamen,
                'nconsulta'          => $this->input->post('nconsulta', true),
                //'tipo_docu'          => $tipo_docu,
                //'identificacion'     => $identificacion,
                'edad'               => $edad,
                'ume'                => $ume,
                'cod_cie'            => $this->input->post('cod_cie_op'),
                'nombre_cie'         => $this->input->post('nombre_cie_op'),
                'cod_causa_dia'      => $this->input->post('causa_op', true),
                'cod_fina_cie'       => $this->input->post('finalidad2_op', true),
                'cod_tipo'           => $this->input->post('tipoo_op', true),
                'observacionescie'   => $this->input->post('observacionescie_op', true),
                'cod_cier'           => $cod_cier,      
                'nombre_cier'        => $nombre_cier,          
                'observacionescier'  => $this->input->post('observacionescier_op', true),
                'cod_ciers'          => $cod_ciers,
                'nombre_ciers'       => $nombre_ciers,
                'observacionesciers' => $this->input->post('observacionesciers_op', true),
                'cod_cierr'          => $cod_cierr,
                'nombre_cierr'       => $nombre_cierr,
                'observacionescierr' => $this->input->post('observacionescierr_op', true),
                'fechaactual'        => $fechaactual,
                'horaactual'         => $horaactual,
                'cod_medi'           => '110010756401',
                'cod_cons'           => $this->input->post('codconsulta_op'),
                'login_ing'          => $this->input->post('login', true),
                'id_admi'            => $this->input->post('convenios_op', true),
                'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                //'revolucion'         => 'SI',
                //'nevolucion'         => $this->input->post('version', true),
                'num_optometria'     =>  $this->input->post('num_optometria', true),
                'activo'             => 'SI'
            );

            $this->examen_model->insertCieCups($ciecups);

            /////////////// *** inicio de cie +cie cups prequ medi incap
            $cod_cups = $this->input->post('cod_cups_op');

            if ($cod_cups) {

                for ($i = 0; $i < count($this->input->post('cod_cups_op')); $i++) {

                    if (!$this->input->post('actoqcupso_op', true)[$i] && $this->input->post('actoqcupso_op', true)[$i] === '') {
                        $actoQuirirgico = '';
                    } else {
                        $actoQuirirgico = $this->input->post('actoqcupso_op', true)[$i];
                    }

                    $cups = [
                        'id_paciente'    => $id_paciente,
                        'cons_examen'    => $n_conexamen,
                        'nconsulta'      => $this->input->post('nconsulta', true),
                        //'tipo_docu'      => $tipo_docu,
                        //'identificacion' => $identificacion,
                        'edad'           => $edad,
                        'ume'            => $ume,
                        'cod_cups'       => $this->input->post('cod_cups_op')[$i],
                        'nombre_cups'    => $this->input->post('nombre_cups_op')[$i],
                        'id_finalidad'   => $this->input->post('finalidadcupso_op', true)[$i],
                        'cod_ambi'       => $this->input->post('ambitocupso_op', true)[$i],
                        'cod_actoq'      => $actoQuirirgico,
                        'lateralidad'    => $this->input->post('lateralidad_op', true)[$i],
                        'cantidad'       => $this->input->post('cantidad_op_cups', true)[$i],
                        'autorizacion'   => $this->input->post('autorizacion_op', true)[$i],
                        'valor_cups'     => $this->input->post('valor_cups_op')[$i],
                        'fechaactual'    => $fechaactual,
                        'horaactual'     => $horaactual,
                        'cod_medi'       => '110010756401',
                        'cod_cons'       => $this->input->post('codconsulta_op'),
                        'login_ing'      => $this->input->post('login', true),
                        'id_admi'        => $this->input->post('convenios_op', true),
                        'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                        //'revolucion'     => 'SI',
                        //'nevolucion'     => $this->input->post('version', true)
                        'num_optometria' => $this->input->post('num_optometria', true),
                        'activo'             => 'SI'
                    ];
                    $this->examen_model->insertCieCups($cups);
                }

            }

            // mas cie diagnosticos
            $mas_cups = $this->input->post('cod_cierr_mop_op');
            if ($mas_cups) 
            {
                for ($i = 0; $i < count($this->input->post('cod_cierr_mop_op')); $i++) 
                {
                    $mciecups = array(
                        'id_paciente'        => $id_paciente,
                        'cons_examen'        => $n_conexamen,
                        'nconsulta'          => $this->input->post('nconsulta', true),
                        //'tipo_docu'          => $tipo_docu,
                        //'identificacion'     => $identificacion,
                        'edad'               => $edad,
                        'ume'                => $ume,
                        'cod_causa_dia'      => $this->input->post('causa_op', true),
                        'cod_fina_cie'       => $this->input->post('finalidad2_op', true),
                        'cod_tipo'           => $this->input->post('tipoo_op', true),
                        'fechaactual'        => $fechaactual,
                        'horaactual'         => $horaactual,
                        'cod_medi'           => '110010756401',
                        'cod_cons'           => $this->input->post('codconsulta_op'),
                        'login_ing'          => $this->input->post('login', true),
                        'id_admi'            => $this->input->post('convenios_op', true),
                        'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                        //'revolucion'         => 'SI',
                        //'nevolucion'         => $this->input->post('version', true),
                        'num_optometria'     => $this->input->post('num_optometria', true),
                        'cod_ciemas'         => $this->input->post('cod_cierr_mop_op', true)[$i],
                        'nombre_ciemas'      => $this->input->post('nombre_cierr_mop_op', true)[$i],
                        'observaciones_ciemas'   => $this->input->post('observaciones_cierr_mop_op', true)[$i],
                        'activo'             => 'SI'
                    );
                    $this->examen_model->insertCieCups($mciecups);
                }
            }

            // medicamentos oftalmologia
            $mas_cups = $this->input->post('id_medicamento_op');
            if ($mas_cups) 
            {
                for ($i = 0; $i < count($this->input->post('id_medicamento_op')); $i++) 
                {
                    $m_medicamentos = array(
                        'id_paciente'               =>  $id_paciente,
                        'cons_examen'               =>  $n_conexamen,
                        'fechaactual'               =>  $fechaactual,
                        'horaactual'                =>  $horaactual,
                        'nconsulta'                 =>  $this->input->post('nconsulta', true),
                        'login_ing'                 =>  $this->input->post('login', true),
                        'cod_medi'                  =>  $this->input->post('medico', true),
                        'id_admi'                   =>  $this->input->post('convenios', true),
                        'tipo_historia'             =>  'OPTOMETRIA',
                        'id_medicamento'            =>  $this->input->post('id_medicamento_op', true)[$i],
                        'nombre_medicamento'        =>  $this->input->post('nombre_medicamento_op', true)[$i],
                        'concentracion'             =>  $this->input->post('concentracion_op', true)[$i],
                        'prescripcion'              =>  $this->input->post('prescripcion_op', true)[$i],
                        'cantidad'                  =>  $this->input->post('cantidad_op', true)[$i],
                        'tiempo'                    =>  $this->input->post('tiempo_op', true)[$i],
                        'activo'                    => 'SI'
                    );
                    $this->examen_model->insertMedicamentos($m_medicamentos);
                }
            }

            // paraclinicos
            $cod_para = $this->input->post('cod_para_op');
            if ($cod_para) 
            {
                for ($i = 0; $i < count($this->input->post('cod_para_op')); $i++) 
                { 
                    $m_para = array(
                        'id_paciente'        => $this->input->post('id_paciente'),
                        'cons_examen'        => $n_conexamen,
                        'cons_paraclinico'   => $n_conparaclinico,
                        'login_ing'          => $this->input->post('login', true),
                        'cod_para'           => $this->input->post('cod_para_op', true)[$i],
                        'nombre_para'        => $this->input->post('nombre_para_op', true)[$i],
                        'activo'             => 'SI'
                    );
                    $this->examen_model->insertPara($m_para, $n_conparaclinico);
                }
            }

            // actualiza agenda color y evento
            $id_agenda          =    $this->input->post('id_agenda_op', true);
            if($id_agenda === '')
            {

            }else
            {
                $m_agenda   =   array(
                    'estado'    =>   'Atendio',
                    'color'     =>   '#5cb85c'
                );
                $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
            }              
            /////////////// *** cierre de cie +cie cups prequ medi incap 


        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            
            'ultimocontrol'         =>  $fechaactual,
            'version'               =>  $this->input->post('version', true),
            'num_optometria'        =>  $this->input->post('num_optometria', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        

        // CONSULTA DE PACIENTE NUEVO
        //$this->load->library('s3');

        $datos['examen_opt']            =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_optometria']      =  $this->input->post('num_optometria', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen;        

        $this->load->view('front_end/historias/hexamen_opt_v', $datos);
    }

    // actualizando historia oftalmologica
    public function actualizaexamen_opt() 
    {
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->input->post('optometria_abierta', true);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);
        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        $id_paciente                =   $this->input->post('id_paciente', true);
        //$tipo_docu                  =   $this->input->post('tipo_docu', true);
        //$identificacion             =   $this->input->post('identificacion', true);

       

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'                   =>  $id_paciente,
            'cons_examen'                   =>  $n_conexamen,
            'fechaactual'                   =>  $fechaactual,
            'horaactual'                    =>  $horaactual,
            'nconsulta'                     =>  $this->input->post('nconsulta', true),
            'login_ing'                     =>  $this->input->post('login', true),
            'edad'                          =>  $edad,
            'ume'                           =>  $ume,
            'cod_cons'                      =>  $this->input->post('codconsulta_op', true),
            'observacionescups'             => $this->input->post('observacionescups_op', true),
            'firmapaci'                     =>  $this->input->post('firmapaciente1_op'),
            'firmamedi'                     =>  $this->input->post('firmamedico1_op'),
            'cod_medi'                      =>  $this->input->post('medico_op', true),
            'num_optometria'                =>  $this->input->post('num_optometria', true),
            //'cod_consultorio'               =>  $this->input->post('consultorios_op', true),
            'id_admi'                       =>  $this->input->post('convenios_op', true),
            'motivo_consulta'               =>  $this->input->post('motivo_consulta', true),
            'ant_personales'                =>  $this->input->post('ant_personales', true),
            'ant_familiares'                =>  $this->input->post('ant_familiares', true),
            'ant_ocupacionales'             =>  $this->input->post('ant_ocupacionales', true),
            'ant_usa_anteojos'              =>  $this->input->post('ant_usa_anteojos', true),
            'ant_lentes_cont'               =>  $this->input->post('ant_lentes_cont', true),
            'ant_tipo_uso'                  =>  $this->input->post('ant_tipo_uso', true),
            'sintomatologia'                =>  $this->input->post('sintomatologia', true),
            'avsc_od_vl'                    =>  $this->input->post('avsc_od_vl', true),
            'avsc_od_vp'                    =>  $this->input->post('avsc_od_vp', true),
            'avsc_od_ph'                    =>  $this->input->post('avsc_od_ph', true),
            'avcc_od'                       =>  $this->input->post('avcc_od', true),
            'avcc_od_vl'                    =>  $this->input->post('avcc_od_vl', true),
            'avcc_od_vp'                    =>  $this->input->post('avcc_od_vp', true),
            'avsc_oi_vl'                    =>  $this->input->post('avsc_oi_vl', true),
            'avsc_oi_vp'                    =>  $this->input->post('avsc_oi_vp', true),
            'avsc_oi_ph'                    =>  $this->input->post('avsc_oi_ph', true),
            'avcc_oi'                       =>  $this->input->post('avcc_oi', true),
            'avcc_oi_vl'                    =>  $this->input->post('avcc_oi_vl', true),
            'avcc_oi_vp'                    =>  $this->input->post('avcc_oi_vp', true),
            'avsc_ao_vl'                    =>  $this->input->post('avsc_ao_vl', true),
            'avsc_ao_vp'                    =>  $this->input->post('avsc_ao_vp', true),
            'avsc_ao_ph'                    =>  $this->input->post('avsc_ao_ph', true),
            'avcc_ao'                       =>  $this->input->post('avcc_ao', true),
            'avcc_ao_vl'                    =>  $this->input->post('avcc_ao_vl', true),
            'avcc_ao_vp'                    =>  $this->input->post('avcc_ao_vp', true),
            'exa_ext_od'                    =>  $this->input->post('exa_ext_od', true),
            'exa_ext_oi'                    =>  $this->input->post('exa_ext_oi', true),
            'reflejos_obs'                  =>  $this->input->post('reflejos_obs', true),
            'ct_vl'                         =>  $this->input->post('ct_vl', true),
            'ct_vp'                         =>  $this->input->post('ct_vp', true),
            'motilidad_ocular'              =>  $this->input->post('motilidad_ocular', true),
            'observaciones_opt'             =>  $this->input->post('observaciones_opt', true),
            'ppc_observacion'               =>  $this->input->post('ppc_observacion', true),
            'oftalmoscopia_od'              =>  $this->input->post('oftalmoscopia_od', true),
            'oftalmoscopia_oi'              =>  $this->input->post('oftalmoscopia_oi', true),
            'queratrometria_od'             =>  $this->input->post('queratrometria_od', true),
            'queratrometria_oi'             =>  $this->input->post('queratrometria_oi', true),
            'refraccion_od'                 =>  $this->input->post('refraccion_od', true),
            'refraccion_av_od'              =>  $this->input->post('refraccion_av_od', true),
            'refraccion_oi'                 =>  $this->input->post('refraccion_oi', true),
            'refraccion_av_oi'              =>  $this->input->post('refraccion_av_oi', true),
            'subjetivo_od   '               =>  $this->input->post('subjetivo_od    ', true),
            'subjetivo_vl_od'               =>  $this->input->post('subjetivo_vl_od', true),
            'subjetivo_vp_od'               =>  $this->input->post('subjetivo_vp_od', true),
            'subjetivo_add_od'              =>  $this->input->post('subjetivo_add_od', true),
            'subjetivo_oi'                  =>  $this->input->post('subjetivo_oi', true),
            'subjetivo_vl_oi'               =>  $this->input->post('subjetivo_vl_oi', true),
            'subjetivo_vp_oi'               =>  $this->input->post('subjetivo_vp_oi', true),
            'subjetivo_add_oi'              =>  $this->input->post('subjetivo_add_oi', true),
            'rx_final_od'                   =>  $this->input->post('rx_final_od', true),
            'rx_final_vl_od'                =>  $this->input->post('rx_final_vl_od', true),
            'rx_final_vp_od'                =>  $this->input->post('rx_final_vp_od', true),
            'rx_final_add_od'               =>  $this->input->post('rx_final_add_od', true),
            'rx_final_npd_od'               =>  $this->input->post('rx_final_npd_od', true),
            'rx_final_alt_od'               =>  $this->input->post('rx_final_alt_od', true),
            'rx_final_oi'                   =>  $this->input->post('rx_final_oi', true),
            'rx_final_vl_oi'                =>  $this->input->post('rx_final_vl_oi', true),
            'rx_final_vp_oi'                =>  $this->input->post('rx_final_vp_oi', true),
            'rx_final_add_oi'               =>  $this->input->post('rx_final_add_oi', true),
            'rx_final_npd_oi'               =>  $this->input->post('rx_final_npd_oi', true),
            'rx_final_alt_oi'               =>  $this->input->post('rx_final_alt_oi', true),
            'rx_final_tl'                   =>  $this->input->post('rx_final_tl', true),
            'vision_color_od'               =>  $this->input->post('vision_color_od', true),
            'vision_color_oi'               =>  $this->input->post('vision_color_oi', true),
            'estereopsis_od'                =>  $this->input->post('estereopsis_od', true),
            'estereopsis_oi'                =>  $this->input->post('estereopsis_oi', true),
            'c_corr_opt_perm'               =>  $this->input->post('c_corr_opt_perm', true),
            'c_corr_opt_vp'                 =>  $this->input->post('c_corr_opt_vp', true),
            'c_corr_opt_vl'                 =>  $this->input->post('c_corr_opt_vl', true),
            'c_corr_opt_o'                  =>  $this->input->post('c_corr_opt_o', true),
            'rem_val_or'                    =>  $this->input->post('rem_val_or', true),
            'rem_val_op'                    =>  $this->input->post('rem_val_op', true),
            'rem_rea_topo'                  =>  $this->input->post('rem_rea_topo', true),
            'rem_val_oft'                   =>  $this->input->post('rem_val_oft', true),
            'rem_otras'                     =>  $this->input->post('rem_otras', true),
            'comentarios'                   =>  $this->input->post('comentarios', true),
            'tipo_co'                       =>  $this->input->post('tipo_co_op', true),
            'abierta'                       =>  'SI',
            'planotratamiento'              =>  $this->input->post('planotratamiento_op', true),
            'id_agenda'                     =>  $this->input->post('id_agenda_op', true),
            'incapacidades'                 =>  $this->input->post('incapacidades_op', true),
            'obs_medicamentos_opt'          =>  $this->input->post('obs_medicamentos_opt', true)
        );

        //var_dump($this->input->post());
        //exit();

        $updateExa = $this->examen_model->updateExa_opt($examen, $n_conexamen);

        // colocar inactivo los cie en ciecups
        $m_cie_activo   =    array(
            'activo'    => 'NO');

        $update_cie_activo  =   $this->examen_model->updateCIEActivo($m_cie_activo, $n_conexamen);

        $vcod_cier = $this->input->post('cod_cier_op', true);

        if (!$vcod_cier || $vcod_cier === '') {
            $cod_cier       =   '';
            $nombre_cier    =   '';
        } else {
            $cod_cier       =   $vcod_cier;
            $nombre_cier    =   $this->input->post('nombre_cier_op');
        };

        $vcod_ciers = $this->input->post('cod_ciers_op', true);

        if (!$vcod_ciers || $vcod_ciers === '') {
            $cod_ciers      =   '';
            $nombre_ciers   =   '';
        } else {
            $cod_ciers      =   $vcod_ciers;
            $nombre_ciers   =   $this->input->post('nombre_ciers_op');
        };

        $vcod_cierr = $this->input->post('cod_cierr_op', true);

        if (!$vcod_cierr || $vcod_cierr === '') {
            $cod_cierr      =   '';
            $nombre_cierr   =   '';
        } else {
            $cod_cierr      =   $vcod_cierr;
            $nombre_cierr   =   $this->input->post('nombre_cierr_op');
        };

        $ciecups = array(
            'id_paciente'        => $id_paciente,
            'cons_examen'        => $n_conexamen,
            'nconsulta'          => $this->input->post('nconsulta', true),
            //'tipo_docu'          => $tipo_docu,
            //'identificacion'     => $identificacion,
            'edad'               => $edad,
            'ume'                => $ume,
            'cod_cie'            => $this->input->post('cod_cie_op'),
            'nombre_cie'         => $this->input->post('nombre_cie_op'),
            'cod_causa_dia'      => $this->input->post('causa_op', true),
            'cod_fina_cie'       => $this->input->post('finalidad2_op', true),
            'cod_tipo'           => $this->input->post('tipoo_op', true),
            'observacionescie'   => $this->input->post('observacionescie_op', true),
            'cod_cier'           => $cod_cier,      
            'nombre_cier'        => $nombre_cier,          
            'observacionescier'  => $this->input->post('observacionescier_op', true),
            'cod_ciers'          => $cod_ciers,
            'nombre_ciers'       => $nombre_ciers,
            'observacionesciers' => $this->input->post('observacionesciers_op', true),
            'cod_cierr'          => $cod_cierr,
            'nombre_cierr'       => $nombre_cierr,
            'observacionescierr' => $this->input->post('observacionescierr_op', true),
            'fechaactual'        => $fechaactual,
            'horaactual'         => $horaactual,
            'cod_medi'           => '110010756401',
            'cod_cons'           => $this->input->post('codconsulta_op'),
            'login_ing'          => $this->input->post('login', true),
            'id_admi'            => $this->input->post('convenios_op', true),
            'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
            //'revolucion'         => 'SI',
            //'nevolucion'         => $this->input->post('version', true),
            'num_optometria'     =>  $this->input->post('num_optometria', true),
            'activo'             => 'SI'
        );

        $this->examen_model->insertCieCups($ciecups);

        $cod_cups = $this->input->post('cod_cups_op');

        if ($cod_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cups_op')); $i++) 
            {
                if (!$this->input->post('actoqcupso_op', true)[$i] && $this->input->post('actoqcupso_op', true)[$i] === '') 
                {
                    $actoQuirirgico = '';
                }else 
                {
                    $actoQuirirgico = $this->input->post('actoqcupso_op', true)[$i];
                }

                $cups = [
                    'id_paciente'    => $id_paciente,
                    'cons_examen'    => $n_conexamen,
                    'nconsulta'      => $this->input->post('nconsulta', true),
                    //'tipo_docu'      => $tipo_docu,
                    //'identificacion' => $identificacion,
                    'edad'           => $edad,
                    'ume'            => $ume,
                    'cod_cups'       => $this->input->post('cod_cups_op')[$i],
                    'nombre_cups'    => $this->input->post('nombre_cups_op')[$i],
                    'id_finalidad'   => $this->input->post('finalidadcupso_op', true)[$i],
                    'cod_ambi'       => $this->input->post('ambitocupso_op', true)[$i],
                    'cod_actoq'      => $actoQuirirgico,
                    'lateralidad'    => $this->input->post('lateralidad_op', true)[$i],
                    'cantidad'       => $this->input->post('cantidad_op_cups', true)[$i],
                    'autorizacion'   => $this->input->post('autorizacion_op', true)[$i],
                    'valor_cups'     => $this->input->post('valor_cups_op')[$i],
                    'fechaactual'    => $fechaactual,
                    'horaactual'     => $horaactual,
                    'cod_medi'       => '110010756401',
                    'cod_cons'       => $this->input->post('codconsulta_op'),
                    'login_ing'      => $this->input->post('login', true),
                    'id_admi'        => $this->input->post('convenios_op', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'     => 'SI',
                    //'nevolucion'     => $this->input->post('version', true)
                    'num_optometria' => $this->input->post('num_optometria', true),
                    'activo'             => 'SI'
                ];
                $this->examen_model->insertCieCups($cups);
            }
        }

        // mas cie diagnosticos
        $mas_cups = $this->input->post('cod_cierr_mop');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cierr_mop')); $i++) 
            {
                $mciecups = array(
                    'id_paciente'        => $id_paciente,
                    'cons_examen'        => $n_conexamen,
                    'nconsulta'          => $this->input->post('nconsulta', true),
                    //'tipo_docu'          => $tipo_docu,
                    //'identificacion'     => $identificacion,
                    'edad'               => $edad,
                    'ume'                => $ume,
                    'cod_causa_dia'      => $this->input->post('causa', true),
                    'cod_fina_cie'       => $this->input->post('finalidad2', true),
                    'cod_tipo'           => $this->input->post('tipoo', true),
                    'fechaactual'        => $fechaactual,
                    'horaactual'         => $horaactual,
                    'cod_medi'           => '110010756401',
                    'cod_cons'           => $this->input->post('codconsulta'),
                    'login_ing'          => $this->input->post('login', true),
                    'id_admi'            => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'         => 'SI',
                    //'nevolucion'         => $this->input->post('version', true),
                    'num_optometria'     =>  $this->input->post('num_optometria', true),
                    'cod_ciemas'         => $this->input->post('cod_cierr_mop', true)[$i],
                    'nombre_ciemas'      => $this->input->post('nombre_cierr_mop', true)[$i],
                    'observaciones_ciemas'   => $this->input->post('observaciones_cierr_mop', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertCieCups($mciecups);
            }
        }

        // medicamentos oftalmologia
        // colocar inactivo los medicamentos en ciecups
        $m_med_activo   =    array(
            'activo'    => 'NO');

        $update_med_activo  =   $this->examen_model->updateMEDActivo($m_med_activo, $n_conexamen);
        
        $mas_medicamento = $this->input->post('id_medicamento_op');
        if ($mas_medicamento) 
        {
            for ($i = 0; $i < count($this->input->post('id_medicamento_op')); $i++) 
            {
                $m_medicamentos = array(
                    'id_paciente'               =>  $id_paciente,
                    'cons_examen'               =>  $n_conexamen,
                    'fechaactual'               =>  $fechaactual,
                    'horaactual'                =>  $horaactual,
                    'nconsulta'                 =>  $this->input->post('nconsulta', true),
                    'login_ing'                 =>  $this->input->post('login', true),
                    'cod_medi'                  =>  $this->input->post('medico', true),
                    'id_admi'                   =>  $this->input->post('convenios', true),
                    'tipo_historia'             =>  'OPTOMETRIA',
                    'id_medicamento'            =>  $this->input->post('id_medicamento_op', true)[$i],
                    'nombre_medicamento'        =>  $this->input->post('nombre_medicamento_op', true)[$i],
                    'concentracion'             =>  $this->input->post('concentracion_op', true)[$i],
                    'prescripcion'              =>  $this->input->post('prescripcion_op', true)[$i],
                    'cantidad'                  =>  $this->input->post('cantidad_op', true)[$i],
                    'tiempo'                    =>  $this->input->post('tiempo_op', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertMedicamentos($m_medicamentos);
            }
        }

        // paraclinicos
        $m_para_activo   =    array(
            'activo'    => 'NO');

        $update_para_activo  =   $this->examen_model->updatePARAActivo($m_para_activo, $n_conexamen);

        $cod_para = $this->input->post('cod_para_op');
        if ($cod_para) 
        {
            for ($i = 0; $i < count($this->input->post('cod_para_op')); $i++) 
            { 
                $m_para = array(
                    'id_paciente'        => $this->input->post('id_paciente'),
                    'cons_examen'        => $n_conexamen,
                    'cons_paraclinico'   => $n_conparaclinico,
                    'login_ing'          => $this->input->post('login', true),
                    'cod_para'           => $this->input->post('cod_para_op', true)[$i],
                    'nombre_para'        => $this->input->post('nombre_para_op', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertPara($m_para, $n_conparaclinico);
            }
        }

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            'ultimocontrol'         =>  $fechaactual,
            //'version'               =>  $this->input->post('version', true),
            //'num_oftalmologia'      =>  $this->input->post('num_oftalmologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // actualiza agenda color y evento
        /*$id_agenda          =    $this->input->post('id_agenda', true);
        if($id_agenda === '')
        {

        }else
        {
            $m_agenda   =   array(
                'estado'    =>   'Atendio',
                'color'     =>   '#5cb85c'
            );
            $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
        }*/

        // CONSULTA DE PACIENTE NUEVO

        $datos['examen_opt']            =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_optometria']      =  $this->input->post('num_optometria', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen;        

        $this->load->view('front_end/historias/hexamen_opt_v', $datos);
    }

    public function rep_historia_opt()
    {
        $this->load->model('examen_model');
        //$this->load->library('s3');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('n_conexamen');

        $examen             =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        //$ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        

        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // PRESTADOR
        //$prestador          =   $this->examen_model->prestador();
        
        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto     =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $nombre_admi    =   $pac->nombre_admi;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        foreach($examen as $exa)
        {
            $fecha_consulta  =   $exa['fechaactual'];
            $hora_consulta   =   $exa['horaactual'];
            $medico                         =   $exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi'];
            $incapacidades                  =   $exa['incapacidades'];
            $n_cod_medi     =   $exa['cod_medi'];
        }

        
        /*$imgextension   =   substr($imagenfoto, -3);
        $contarpunto    =   substr_count($imagenfoto, ".");

        $porciones  =   explode(".", $imagenfoto);
        $extfoto    =   $porciones[$contarpunto]; 
        //echo $extfoto;

        if($imagenfoto)
        {            
            $datos['imagenfoto']  =   $this->pdf->Image(S3::getAuthenticatedURL('histocol', $imagenfoto, 600), 170,5, 26, 26, $extfoto);
        }else 
        {
            $datos['imagenfoto']  =   '';
        }*/

        // consulta de la firma del medico desde la tabla medicos
        $c_f_medico     =   $this->examen_model->c_f_medico($n_cod_medi);
        foreach($c_f_medico as $f_med)
        {
            $firma_med  =   $f_med['firmamedi'];
        }


        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 

        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        /////
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();

        foreach($examen as $exa)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Examen Optométrico'),0,0,'L');
            
            // MEDICO, TIPO CONSULTA
            $this->pdf->SetX(55);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi']),0,0,'L');
            $this->pdf->SetX(120);
            
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(25,4,utf8_decode('Número Control:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(40,4,utf8_decode($exa['num_optometria']),0,0,'L');
            $this->pdf->Ln();

            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());
            $this->pdf->Ln();

            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['nombre_cons']),0,0,'L');
            $this->pdf->Ln();            


            if($exa['motivo_consulta'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Motivo Consulta  :'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['motivo_consulta']),0,'J');
            }

            if($exa['ant_personales'] || $exa['ant_familiares'] || $exa['ant_ocupacionales'] || $exa['ant_usa_anteojos'] || $exa['ant_lentes_cont'] || $exa['ant_tipo_uso'])
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Historial Antecedentes'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                if($exa['ant_personales'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Personales:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['ant_personales']),0,'J');
                }

                if($exa['ant_familiares'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Familiares:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['ant_familiares']),0,'J');
                }

                if($exa['ant_ocupacionales'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Ocupacionales:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['ant_ocupacionales']),0,'J');
                }

                if($exa['ant_usa_anteojos'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Usa Anteojos:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['ant_usa_anteojos']),0,'J');
                }

                if($exa['ant_lentes_cont'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Lentes de contacto   :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['ant_lentes_cont']),0,'J');
                }

                if($exa['ant_tipo_uso'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Tipo de uso:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['ant_tipo_uso']),0,'J');
                }
                
            }

            // pruebas realizadas
            if($exa['sintomatologia'] || $exa['avsc_od_vl'] || $exa['avsc_od_vp'] || $exa['avsc_od_ph'] || $exa['ant_lentes_cont'] || $exa['avsc_oi_vp'] || $exa['avsc_oi_ph'] || $exa['avsc_ao_vl'] || $exa['avsc_ao_vp'] || $exa['avsc_ao_ph'] || $exa['avcc_od'] || $exa['avcc_od_vl'] || $exa['avcc_od_vp'] || $exa['avcc_oi'] || $exa['avcc_oi_vl'] || $exa['avcc_oi_vp'] || $exa['avcc_ao'] || $exa['avcc_ao_vl'] || $exa['avcc_ao_vp'] || $exa['exa_ext_od'] || $exa['exa_ext_oi'] || $exa['reflejos_obs'] || $exa['ct_vl'] || $exa['ct_vp'] || $exa['motilidad_ocular'] || $exa['observaciones_opt'] || $exa['ppc_observacion'] || $exa['oftalmoscopia_od'] || $exa['oftalmoscopia_oi'] || $exa['queratrometria_od'] || $exa['queratrometria_oi'] || $exa['refraccion_od'] || $exa['refraccion_av_od'] || $exa['refraccion_oi'] || $exa['refraccion_av_oi']
                || $exa['subjetivo_od'] || $exa['subjetivo_vl_od'] || $exa['subjetivo_vp_od'] || $exa['subjetivo_add_od'] || $exa['subjetivo_oi'] || $exa['subjetivo_vl_oi'] || $exa['subjetivo_vp_oi'] || $exa['subjetivo_add_oi']
                || $exa['rx_final_od'] || $exa['rx_final_vl_od'] || $exa['rx_final_vp_od'] || $exa['rx_final_add_od'] || $exa['rx_final_npd_od'] || $exa['rx_final_alt_od'] || $exa['rx_final_oi'] || $exa['rx_final_vl_oi'] || $exa['rx_final_vp_oi'] || $exa['rx_final_add_oi'] || $exa['rx_final_npd_oi'] || $exa['rx_final_alt_oi'] || $exa['rx_final_tl']
                || $exa['vision_color_od'] || $exa['vision_color_oi'] || $exa['estereopsis_od'] || $exa['estereopsis_oi']
                )
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Pruebas realizadas'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                if($exa['sintomatologia'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Sintomatología:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['sintomatologia']),0,'J');
                }

                if($exa['avsc_od_vl'] || $exa['avsc_od_vp'] || $exa['avsc_od_ph'] || $exa['ant_lentes_cont'] || $exa['avsc_oi_vp'] || $exa['avsc_oi_ph'] || $exa['avsc_ao_vl'] || $exa['avsc_ao_vp'] || $exa['avsc_ao_ph'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Agudeza Visual Sin Corrección'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                    $this->pdf->Ln();

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,27,15,27,15,27));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L'));
                      
                    $avsc_od            =   utf8_decode('Ojo Derecho');
                    $avsc_od_vl_t       =   utf8_decode('VL 20/');
                    $avsc_od_vl         =   utf8_decode($exa['avsc_od_vl']);
                    $avsc_od_vp_t       =   utf8_decode('VL 20/');
                    $avsc_od_vp         =   utf8_decode($exa['avsc_od_vp']);
                    $avsc_od_ph_t       =   utf8_decode('PH');
                    $avsc_od_ph         =   utf8_decode($exa['avsc_od_ph']);
                    
                    $this->pdf->Row(array($avsc_od, $avsc_od_vl_t, $avsc_od_vl, $avsc_od_vp_t, $avsc_od_vp, $avsc_od_ph_t, $avsc_od_ph));

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,27,15,27,15,27));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L'));
                      
                    $avsc_oi            =   utf8_decode('Ojo Izquierdo');
                    $avsc_oi_vl_t       =   utf8_decode('VL 20/');
                    $avsc_oi_vl         =   utf8_decode($exa['avsc_oi_vl']);
                    $avsc_oi_vp_t       =   utf8_decode('VL 20/');
                    $avsc_oi_vp         =   utf8_decode($exa['avsc_oi_vp']);
                    $avsc_oi_ph_t       =   utf8_decode('PH');
                    $avsc_oi_ph         =   utf8_decode($exa['avsc_oi_ph']);
                    
                    $this->pdf->Row(array($avsc_oi, $avsc_oi_vl_t, $avsc_oi_vl, $avsc_oi_vp_t, $avsc_oi_vp, $avsc_oi_ph_t, $avsc_oi_ph));

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,27,15,27,15,27));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L'));
                      
                    $avsc_ao            =   utf8_decode('Ambos Ojos ');
                    $avsc_ao_vl_t       =   utf8_decode('VL 20/');
                    $avsc_ao_vl         =   utf8_decode($exa['avsc_ao_vl']);
                    $avsc_ao_vp_t       =   utf8_decode('VL 20/');
                    $avsc_ao_vp         =   utf8_decode($exa['avsc_ao_vp']);
                    $avsc_ao_ph_t       =   utf8_decode('PH');
                    $avsc_ao_ph         =   utf8_decode($exa['avsc_ao_ph']);
                    
                    $this->pdf->Row(array($avsc_ao, $avsc_ao_vl_t, $avsc_ao_vl, $avsc_ao_vp_t, $avsc_ao_vp, $avsc_ao_ph_t, $avsc_ao_ph));
                }

                if($exa['avcc_od'] || $exa['avcc_od_vl'] || $exa['avcc_od_vp'] || $exa['avcc_oi'] || $exa['avcc_oi_vl'] || $exa['avcc_oi_vp'] || $exa['avcc_ao'] || $exa['avcc_ao_vl'] || $exa['avcc_ao_vp'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Agudeza Visual Con Corrección'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                    $this->pdf->Ln();

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,27,15,27,15,27));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L'));
                      
                    $avcc_od_t          =   utf8_decode('Ojo Derecho');
                    $avcc_od            =   utf8_decode($exa['avcc_od']);
                    $avcc_od_vl_t       =   utf8_decode('VL 20/');
                    $avcc_od_vl         =   utf8_decode($exa['avcc_od_vl']);
                    $avcc_od_vp_t       =   utf8_decode('VP');
                    $avcc_od_vp         =   utf8_decode($exa['avcc_od_vp']);
                    
                    $this->pdf->Row(array($avcc_od_t, $avcc_od, $avcc_od_vl_t, $avcc_od_vl, $avcc_od_vp_t, $avcc_od_vp));

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,27,15,27,15,27));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L'));
                      
                    $avcc_oi_t          =   utf8_decode('Ojo Izquierdo');
                    $avcc_oi            =   utf8_decode($exa['avcc_oi']);
                    $avcc_oi_vl_t       =   utf8_decode('VL 20/');
                    $avcc_oi_vl         =   utf8_decode($exa['avcc_oi_vl']);
                    $avcc_oi_vp_t       =   utf8_decode('VP');
                    $avcc_oi_vp         =   utf8_decode($exa['avcc_oi_vp']);
                    
                    $this->pdf->Row(array($avcc_oi_t, $avcc_oi, $avcc_oi_vl_t, $avcc_oi_vl, $avcc_oi_vp_t, $avcc_oi_vp));

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,27,15,27,15,27));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L'));
                      
                    $avcc_ao_t          =   utf8_decode('Ambos Ojos');
                    $avcc_ao            =   utf8_decode($exa['avcc_ao']);
                    $avcc_ao_vl_t       =   utf8_decode('VL 20/');
                    $avcc_ao_vl         =   utf8_decode($exa['avcc_ao_vl']);
                    $avcc_ao_vp_t       =   utf8_decode('VP');
                    $avcc_ao_vp         =   utf8_decode($exa['avcc_ao_vp']);
                    
                    $this->pdf->Row(array($avcc_ao_t, $avcc_ao, $avcc_ao_vl_t, $avcc_ao_vl, $avcc_ao_vp_t, $avcc_ao_vp));
                }

                if($exa['exa_ext_od']  || $exa['exa_ext_oi'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Examen Externo'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['exa_ext_od'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['exa_ext_od']),0,'J');
                    }

                    if($exa['exa_ext_oi'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['exa_ext_oi']),0,'J');
                    }
                }

                if($exa['reflejos_obs'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Reflejos'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['reflejos_obs'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observación:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['reflejos_obs']),0,'J');
                    }
                }

                if($exa['ct_vl'] || $exa['ct_vp'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Cover test'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['ct_vl'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Visión Lejana:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['ct_vl']),0,'J');
                    }

                    if($exa['ct_vp'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Visión Próxima:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['ct_vp']),0,'J');
                    }
                }

                if($exa['motilidad_ocular'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Motilidad Ocular'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['motilidad_ocular'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observación:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['motilidad_ocular']),0,'J');
                    }
                }

                if($exa['observaciones_opt'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['observaciones_opt'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode(''),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['observaciones_opt']),0,'J');
                    }
                }

                if($exa['ppc_observacion'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Punto Próximo de Convergencia'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['ppc_observacion'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observación:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['ppc_observacion']),0,'J');
                    }
                }

                if($exa['oftalmoscopia_od'] || $exa['oftalmoscopia_oi'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Oftalmoscopía'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['oftalmoscopia_od'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['oftalmoscopia_od']),0,'J');
                    }

                    if($exa['oftalmoscopia_oi'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['oftalmoscopia_oi']),0,'J');
                    }
                }

                if($exa['queratrometria_od'] || $exa['queratrometria_oi'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Queratometría'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['queratrometria_od'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['queratrometria_od']),0,'J');
                    }

                    if($exa['queratrometria_oi'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['queratrometria_oi']),0,'J');
                    }
                }

                if($exa['refraccion_od'] || $exa['refraccion_av_od'] || $exa['refraccion_oi'] || $exa['refraccion_av_oi'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Refracción'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                    $this->pdf->Ln();

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,15,15));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L'));
                      
                    $refraccion_t       =   utf8_decode('Ojo Derecho');
                    $refraccion_od      =   utf8_decode($exa['refraccion_od']);
                    $refraccion_av_od_t =   utf8_decode('A.V.20/');
                    $refraccion_av_od   =   utf8_decode($exa['refraccion_av_od']);
                    
                    $this->pdf->Row(array($refraccion_t, $refraccion_od, $refraccion_av_od_t, $refraccion_av_od));

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,15,15));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L'));
                      
                    $refraccion_t       =   utf8_decode('Ojo Izquierdo');
                    $refraccion_oi      =   utf8_decode($exa['refraccion_oi']);
                    $refraccion_av_oi_t =   utf8_decode('A.V.20/');
                    $refraccion_av_oi   =   utf8_decode($exa['refraccion_av_oi']);
                    
                    $this->pdf->Row(array($refraccion_t, $refraccion_oi, $refraccion_av_oi_t, $refraccion_av_oi));
                }

                // subjetivo
                if($exa['subjetivo_od'] || $exa['subjetivo_vl_od'] || $exa['subjetivo_vp_od'] || $exa['subjetivo_add_od']  
                    || $exa['subjetivo_oi']  || $exa['subjetivo_vl_oi']  || $exa['subjetivo_vp_oi']  || $exa['subjetivo_add_oi'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Subjetivo'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                    $this->pdf->Ln();

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,15,15,15,15,15,15));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L','L'));
                      
                    $subjetivo_od_t         =   utf8_decode('Ojo Derecho');
                    $subjetivo_od           =   utf8_decode($exa['subjetivo_od']);
                    $subjetivo_vl_od_t      =   utf8_decode('A.V.20/');
                    $subjetivo_vl_od        =   utf8_decode($exa['subjetivo_vl_od']);
                    $subjetivo_vp_od_t      =   utf8_decode('V.P.');
                    $subjetivo_vp_od        =   utf8_decode($exa['subjetivo_vp_od']);
                    $subjetivo_add_od_t      =   utf8_decode('ADD');
                    $subjetivo_add_od        =   utf8_decode($exa['subjetivo_add_od']);
                    
                    $this->pdf->Row(array($subjetivo_od_t, $subjetivo_od, $subjetivo_vl_od_t,        $subjetivo_vl_od, $subjetivo_vp_od_t, $subjetivo_vp_od, $subjetivo_add_od_t, $subjetivo_add_od));

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(35,15,15,15,15,15,15,15));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L','L'));
                      
                    $subjetivo_oi_t         =   utf8_decode('Ojo Izquierdo');
                    $subjetivo_oi           =   utf8_decode($exa['subjetivo_oi']);
                    $subjetivo_vl_oi_t      =   utf8_decode('A.V.20/');
                    $subjetivo_vl_oi        =   utf8_decode($exa['subjetivo_vl_oi']);
                    $subjetivo_vp_oi_t      =   utf8_decode('V.P.');
                    $subjetivo_vp_oi        =   utf8_decode($exa['subjetivo_vp_oi']);
                    $subjetivo_add_oi_t      =   utf8_decode('ADD');
                    $subjetivo_add_oi        =   utf8_decode($exa['subjetivo_add_oi']);
                    
                    $this->pdf->Row(array($subjetivo_oi_t, $subjetivo_oi, $subjetivo_vl_oi_t,        $subjetivo_vl_oi, $subjetivo_vp_oi_t, $subjetivo_vp_oi, $subjetivo_add_oi_t, $subjetivo_add_oi));

                    
                }

                if($exa['rx_final_od'] || $exa['rx_final_vl_od'] || $exa['rx_final_vp_od'] || $exa['rx_final_add_od'] || $exa['rx_final_npd_od'] || $exa['rx_final_alt_od'] || $exa['rx_final_oi'] || $exa['rx_final_vl_oi'] || $exa['rx_final_vp_oi'] || $exa['rx_final_add_oi'] || $exa['rx_final_npd_oi'] || $exa['rx_final_alt_oi'] ||  $exa['rx_final_tl'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('RX Final'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                    $this->pdf->Ln();

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(30,15,15,15,15,15,15,15,15,15,15,15));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L','L','L','L','L','L'));
                      
                    $rx_final_od_t      =   utf8_decode('Ojo Derecho');
                    $rx_final_od        =   utf8_decode($exa['rx_final_od']);
                    $rx_final_vl_od_t   =   utf8_decode('A.V.20/');
                    $rx_final_vl_od     =   utf8_decode($exa['rx_final_vl_od']);
                    $rx_final_vp_od_t   =   utf8_decode('V.P.');
                    $rx_final_vp_od     =   utf8_decode($exa['rx_final_vp_od']);
                    $rx_final_add_od_t  =   utf8_decode('ADD');
                    $rx_final_add_od    =   utf8_decode($exa['rx_final_add_od']);
                    $rx_final_npd_od_t  =   utf8_decode('NPD');
                    $rx_final_npd_od    =   utf8_decode($exa['rx_final_npd_od']);
                    $rx_final_alt_od_t  =   utf8_decode('ALT');
                    $rx_final_alt_od    =   utf8_decode($exa['rx_final_alt_od']);
                    
                    $this->pdf->Row(array($rx_final_od_t, $rx_final_od, $rx_final_vl_od_t, $rx_final_vl_od, $rx_final_vp_od_t, $rx_final_vp_od, $rx_final_add_od_t, $rx_final_add_od, $rx_final_npd_od_t, $rx_final_npd_od, $rx_final_alt_od_t, $rx_final_alt_od));

                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(30,15,15,15,15,15,15,15,15,15,15,15));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L','L','L','L','L','L','L','L','L','L','L'));
                      
                    $rx_final_oi_t      =   utf8_decode('Ojo Izquierdo');
                    $rx_final_oi        =   utf8_decode($exa['rx_final_oi']);
                    $rx_final_vl_oi_t   =   utf8_decode('A.V.20/');
                    $rx_final_vl_oi     =   utf8_decode($exa['rx_final_vl_oi']);
                    $rx_final_vp_oi_t   =   utf8_decode('V.P.');
                    $rx_final_vp_oi     =   utf8_decode($exa['rx_final_vp_oi']);
                    $rx_final_add_oi_t  =   utf8_decode('ADD');
                    $rx_final_add_oi    =   utf8_decode($exa['rx_final_add_oi']);
                    $rx_final_npd_oi_t  =   utf8_decode('NPI');
                    $rx_final_npd_oi    =   utf8_decode($exa['rx_final_npd_oi']);
                    $rx_final_alt_oi_t  =   utf8_decode('ALT');
                    $rx_final_alt_oi    =   utf8_decode($exa['rx_final_alt_oi']);
                    
                    $this->pdf->Row(array($rx_final_oi_t, $rx_final_oi, $rx_final_vl_oi_t, $rx_final_vl_oi, $rx_final_vp_oi_t, $rx_final_vp_oi, $rx_final_add_oi_t, $rx_final_add_oi, $rx_final_npd_oi_t, $rx_final_npd_oi, $rx_final_alt_oi_t, $rx_final_alt_oi ));

                    // tipo de lente
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->SetWidths(array(30,165));
                    srand(microtime()*1000000);
                    $this->pdf->SetAligns(array('L','L'));
                      
                    $rx_final_tl_t      =   utf8_decode('Tipo de lente');
                    $rx_final_tl        =   utf8_decode($exa['rx_final_tl']);
                    
                    $this->pdf->Row(array($rx_final_tl_t, $rx_final_tl));
                }

                if($exa['vision_color_od'] || $exa['vision_color_oi'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Visión Color'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['vision_color_od'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['vision_color_od']),0,'J');
                    }

                    if($exa['vision_color_oi'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['vision_color_oi']),0,'J');
                    }
                }

                if($exa['estereopsis_od'] || $exa['estereopsis_oi'])
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Estereopsis'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                    if($exa['estereopsis_od'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['estereopsis_od']),0,'J');
                    }

                    if($exa['estereopsis_oi'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($exa['estereopsis_oi']),0,'J');
                    }
                }

            }

            if($exa['c_corr_opt_perm'] == 'SI' || $exa['c_corr_opt_vp'] == 'SI' || $exa['c_corr_opt_vl'] == 'SI' || $exa['c_corr_opt_o'] == 'SI' )
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Conducta y/o Recomendaciones'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                if($exa['c_corr_opt_perm'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Usar corrección óptica permanente'),0,0,'L');
                    $this->pdf->Ln();
                }

                if($exa['c_corr_opt_vp'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Usar corrección óptica para visión próxima'),0,0,'L');
                    $this->pdf->Ln();
                }

                if($exa['c_corr_opt_vl'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Usar corrección óptica para visión lejana'),0,0,'L');
                    $this->pdf->Ln();
                }

                if($exa['c_corr_opt_o'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Usar corrección óptica ocasional'),0,0,'L');
                    $this->pdf->Ln();
                }

            }

            if($exa['rem_val_or'] == 'SI' || $exa['rem_val_op'] == 'SI' || $exa['rem_rea_topo'] == 'SI' || $exa['rem_val_oft'] == 'SI'  || $exa['rem_otras'] == 'SI' )
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Remisiones'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY()); 

                if($exa['rem_val_or'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Valoración por ortóptica'),0,0,'L');
                    $this->pdf->Ln();
                }

                if($exa['rem_val_op'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Valoración por optometría bajo cicloplejia'),0,0,'L');
                    $this->pdf->Ln();
                }

                if($exa['rem_rea_topo'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Realización de topografía corneal'),0,0,'L');
                    $this->pdf->Ln();
                }

                if($exa['rem_val_oft'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Valoración por oftalmología'),0,0,'L');
                    $this->pdf->Ln();
                }

                if($exa['rem_otras'] == 'SI')
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Otras'),0,0,'L');
                    $this->pdf->Ln();
                }

            }

            // COMENTARIOS
            if($exa['comentarios'])
            {
                $this->pdf->Ln();
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['comentarios']),0,'J');
            } 

            // DIAGNOSTICOS
            if($cie)
            {
                foreach($cie as $ci)
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());   
                    

                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','BU',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                    

                    if($ci['observacionescie'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');    
                    }
                    

                    if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                    if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                    if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
                }
            }

            // MAS DIAGNOSTICOS
            if($ciemas)
            {
                $this->pdf->Ln(5);
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
                $this->pdf->Ln(5);
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(90,90));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($ciemas)
                {
                    foreach ($ciemas as $cmas) 
                    {   
                        $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                        $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                        
                        
                        $this->pdf->Row(array($cod_ciemas, $cod_observ));
                    }
                }    
            }

            // paraclinicos
            if($paraclinicos)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('PREQUIRURGICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',7);
                $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',7);
                $this->pdf->SetWidths(array(150));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($paraclinicos)
                {
                    foreach ($paraclinicos as $para) 
                    {   
                        $nombre_para            =   utf8_decode($para['nombre_para']);
                        
                        
                        $this->pdf->Row(array($nombre_para));
                    }
                }    
            }

            // ordenes medicas
            if($cups)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('ORDENES MÉDICAS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();
                
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
                $this->pdf->Cell(20, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(150,20,20));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L', 'R'));

                if($cups)
                {
                    foreach ($cups as $row) 
                    {   
                        $cod_cups            =   utf8_decode($row['cod_cups'].'-'.$row['nombre_cups']);
                        $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                        $cantidad            =   utf8_decode($row['cantidad']);
                        
                        
                        $this->pdf->Row(array($cod_cups, $nombre_lateralidad, $cantidad));
                    }
                }    
            }

            // observaciones cups
            if($exa['observacionescups'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['observacionescups']),0,'J');
                $this->pdf->Ln();
            }

            // medicamentos
            if($medicamentos)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('MEDICAMENTOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
                $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
                $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
                $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
                $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(68,38,38,15,30));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L','L','L','L'));

                if($medicamentos)
                {
                    foreach ($medicamentos as $med) 
                    {   
                        $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                        $concentracion              =   utf8_decode($med['concentracion']);
                        $prescripcion               =   utf8_decode($med['prescripcion']);
                        $cantidad                   =   utf8_decode($med['cantidad']);
                        $tiempo                     =   utf8_decode($med['tiempo']);
                        
                        $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                    }
                }    
            }

            // incapacidades
            if($incapacidades)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('INCAPACIDAD'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',7);
                $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',7);
                $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
            }

            // observaicones medicamentos
            if($exa['obs_medicamentos_opt'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observaciones medicamentos:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['obs_medicamentos_opt']),0,'J');
                $this->pdf->Ln();   
            }

            // recomendaciones
            if($exa['planotratamiento'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Recomendaciones:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['planotratamiento']),0,'J');
                $this->pdf->Ln();   
            }
            

            $this->pdf->Ln();  

            // FIRMAS X EVOLUCION
            if($firma_med)
            {
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
                //$this->pdf->Image($firma_med,20, $this->pdf->GetY(), 50, 25, 'png');
                $imgextension   =   substr($firma_med, -3);
                $this->pdf->Image($firma_med,20, $this->pdf->GetY(), 50, 25, 'png');
                //$this->pdf->Image($firma_med,20, $this->pdf->GetY(), 50, 25);
            }else
            {
            }

            if($exa['firmapaci'])
            {
                $this->pdf->SetX(80);
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
                $this->pdf->Image('data://image/png;base64,'.$exa['firmapaci'],110, $this->pdf->GetY(), 50, 25, 'png');
            }
            else
            {
            } 

            $this->pdf->ln(20);
        

            // NOMBRES PACIENTE Y MEDICO EN FIRMAS
            $this->pdf->SetX(25);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

            $this->pdf->SetX(110);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
            
            
        }

        $this->pdf->Ln();
        $this->pdf->Output("Reporte historia .pdf", 'I');
    }

    public function rep_historia_opt_formula()
    {
        $this->load->model('examen_model');
        //$this->load->library('s3');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('n_conexamen');

        $examen             =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        //$ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        

        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // PRESTADOR
        //$prestador          =   $this->examen_model->prestador();
        
        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto     =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $nombre_admi    =   $pac->nombre_admi;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        foreach($examen as $exa)
        {
            $fecha_consulta  =   $exa['fechaactual'];
            $hora_consulta   =   $exa['horaactual'];
            $medico                         =   $exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi'];
            $n_cod_medi     =   $exa['cod_medi'];
        }

        $c_f_medico     =   $this->examen_model->c_f_medico($n_cod_medi);
        foreach($c_f_medico as $f_med)
        {
            $firma_med  =   $f_med['firmamedi'];
        }
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 

        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        /////
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();

        foreach($examen as $exa)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Examen Optométrico'),0,0,'L');
            
            // MEDICO, TIPO CONSULTA
            $this->pdf->SetX(55);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi']),0,0,'L');
            $this->pdf->SetX(120);
            
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(25,4,utf8_decode('Número Control:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(40,4,utf8_decode($exa['num_optometria']),0,0,'L');
            $this->pdf->Ln();

            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());
            $this->pdf->Ln();

            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['nombre_cons']),0,0,'L');
            $this->pdf->Ln();            


            if($exa['motivo_consulta'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Motivo Consulta  :'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['motivo_consulta']),0,'J');
            }

            

            // DIAGNOSTICOS
            if($cie)
            {
                foreach($cie as $ci)
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                    //$this->pdf->Ln(2);

                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','BU',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                    /*$this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                    if($ci['observacionescie'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                    }

                    if($ci['cod_cier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                            if($ci['observacionescier'])
                            {
                                $this->pdf->SetX(10);
                                $this->pdf->SetFont('Arial','B',8);
                                $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                                $this->pdf->SetX(45);
                                $this->pdf->SetFont('Arial','',8);
                                $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                            }
                            
                        }

                    if($ci['cod_ciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                            if($ci['observacionesciers'])
                            {
                                $this->pdf->SetX(10);
                                $this->pdf->SetFont('Arial','B',8);
                                $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                                $this->pdf->SetX(45);
                                $this->pdf->SetFont('Arial','',8);
                                $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                            }
                            
                        }

                    if($ci['cod_ciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                            if($ci['observacionescierr'])
                            {
                                $this->pdf->SetX(10);
                                $this->pdf->SetFont('Arial','B',8);
                                $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                                $this->pdf->SetX(45);
                                $this->pdf->SetFont('Arial','',8);
                                $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                            }
                        }
                }
            }

            // MAS DIAGNOSTICOS
            if($ciemas)
            {
                $this->pdf->Ln(5);
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
                $this->pdf->Ln(5);
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(90,90));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($ciemas)
                {
                    foreach ($ciemas as $cmas) 
                    {   
                        $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                        $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                        
                        
                        $this->pdf->Row(array($cod_ciemas, $cod_observ));
                    }
                }    
            }

            // rx final
            if($exa['rx_final_od'] || $exa['rx_final_vl_od'] || $exa['rx_final_vp_od'] || $exa['rx_final_add_od'] || $exa['rx_final_npd_od'] || $exa['rx_final_alt_od'] || $exa['rx_final_oi'] || $exa['rx_final_vl_oi'] || $exa['rx_final_vp_oi'] || $exa['rx_final_add_oi'] || $exa['rx_final_npd_oi'] || $exa['rx_final_alt_oi'] ||  $exa['rx_final_tl'])
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('RX Final'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(30,15,15,15,15,15,15,15,15,15,15,15));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L','L','L','L','L','L','L','L','L','L','L'));
                  
                $rx_final_od_t      =   utf8_decode('Ojo Derecho');
                $rx_final_od        =   utf8_decode($exa['rx_final_od']);
                $rx_final_vl_od_t   =   utf8_decode('A.V.20/');
                $rx_final_vl_od     =   utf8_decode($exa['rx_final_vl_od']);
                $rx_final_vp_od_t   =   utf8_decode('V.P.');
                $rx_final_vp_od     =   utf8_decode($exa['rx_final_vp_od']);
                $rx_final_add_od_t  =   utf8_decode('ADD');
                $rx_final_add_od    =   utf8_decode($exa['rx_final_add_od']);
                $rx_final_npd_od_t  =   utf8_decode('NPD');
                $rx_final_npd_od    =   utf8_decode($exa['rx_final_npd_od']);
                $rx_final_alt_od_t  =   utf8_decode('ALT');
                $rx_final_alt_od    =   utf8_decode($exa['rx_final_alt_od']);
                
                $this->pdf->Row(array($rx_final_od_t, $rx_final_od, $rx_final_vl_od_t, $rx_final_vl_od, $rx_final_vp_od_t, $rx_final_vp_od, $rx_final_add_od_t, $rx_final_add_od, $rx_final_npd_od_t, $rx_final_npd_od, $rx_final_alt_od_t, $rx_final_alt_od));

                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(30,15,15,15,15,15,15,15,15,15,15,15));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L','L','L','L','L','L','L','L','L','L','L'));
                  
                $rx_final_oi_t      =   utf8_decode('Ojo Izquierdo');
                $rx_final_oi        =   utf8_decode($exa['rx_final_oi']);
                $rx_final_vl_oi_t   =   utf8_decode('A.V.20/');
                $rx_final_vl_oi     =   utf8_decode($exa['rx_final_vl_oi']);
                $rx_final_vp_oi_t   =   utf8_decode('V.P.');
                $rx_final_vp_oi     =   utf8_decode($exa['rx_final_vp_oi']);
                $rx_final_add_oi_t  =   utf8_decode('ADD');
                $rx_final_add_oi    =   utf8_decode($exa['rx_final_add_oi']);
                $rx_final_npd_oi_t  =   utf8_decode('NPI');
                $rx_final_npd_oi    =   utf8_decode($exa['rx_final_npd_oi']);
                $rx_final_alt_oi_t  =   utf8_decode('ALT');
                $rx_final_alt_oi    =   utf8_decode($exa['rx_final_alt_oi']);
                
                $this->pdf->Row(array($rx_final_oi_t, $rx_final_oi, $rx_final_vl_oi_t, $rx_final_vl_oi, $rx_final_vp_oi_t, $rx_final_vp_oi, $rx_final_add_oi_t, $rx_final_add_oi, $rx_final_npd_oi_t, $rx_final_npd_oi, $rx_final_alt_oi_t, $rx_final_alt_oi ));

                // tipo de lente
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(30,165));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));
                  
                $rx_final_tl_t      =   utf8_decode('Tipo de lente');
                $rx_final_tl        =   utf8_decode($exa['rx_final_tl']);
                
                $this->pdf->Row(array($rx_final_tl_t, $rx_final_tl));
            }
            

            $this->pdf->Ln();  

            // FIRMAS X EVOLUCION
            if($firma_med)
            {
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
                $this->pdf->Image($firma_med,20, $this->pdf->GetY(), 50, 25 ,'png');
                //$this->pdf->Image($firma_med,20, $this->pdf->GetY(), 50, 25);
            }else
            {
            }

            if($exa['firmapaci'])
            {
                $this->pdf->SetX(80);
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
                $this->pdf->Image('data://image/png;base64,'.$exa['firmapaci'],110, $this->pdf->GetY(), 50, 25, 'png');
            }
            else
            {
            } 

            $this->pdf->ln(20);
        

            // NOMBRES PACIENTE Y MEDICO EN FIRMAS
            $this->pdf->SetX(25);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

            $this->pdf->SetX(110);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
            
            
        }

        $this->pdf->Ln();
        $this->pdf->Output("Reporte historia .pdf", 'I');
    }

    public function ingresoexamen_ne() 
    {


        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        = $this->examen_model->consultaconsecutivo(7);
        $num_formula        = $this->historia_model->consultaconsecutivo(16);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        

        $id_paciente                =   $this->input->post('id_paciente', true);
        //$tipo_docu                  =   $this->input->post('tipo_docu', true);
        //$identificacion             =   $this->input->post('identificacion', true);

        $m_ne = array(
            'id_paciente'               => $id_paciente,
            'cons_examen'               => $n_conexamen,
            'fechaactual'               => $fechaactual,
            'horaactual'                => $horaactual,
            'nconsulta'                 => $this->input->post('nconsulta', true),
            'login_ing'                 => $this->input->post('login', true),
            //'firmapaci'                 => $up_firma_paciente,
            //'firmamedi'                 => $up_firma_medico,
            //'cod_medi'                  => $this->input->post('medico', true),
            'neferm_alergico'           =>  $this->input->post('neferm_alergico', true),
            'neferm_procedimiento'      =>  $this->input->post('neferm_procedimiento', true),
            'nenferm_tipo'              =>  $this->input->post('nenferm_tipo'),
            'neferm_horanota'           =>  $this->input->post('neferm_horanota'),
        );

            $insertExa_ne = $this->examen_model->insertExa_ne($m_ne, $n_conexamen);

            

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            
            'ultimocontrol'         =>  $fechaactual,
            //'version'               =>  $this->input->post('version', true),
            'num_ne'                => $this->input->post('num_ne', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // AGREGANDO MEDICAMENTOS
        $id_medicamento = $this->input->post('id_medicamento');

        if ($id_medicamento) 
        {
            // encabezado
            $m_enc_medicamentos = array(                    
                'num_formula'           =>  $num_formula,
                'id_paciente'           =>  $id_paciente,
                //'cod_medi'              =>  $cod_medi,
                'fechaactual'           =>  $fechaactual,
                'horaactual'            =>  $horaactual,                            
                'login_ing'             =>  $login_ing,
                'cons_examen'           =>  $n_conexamen
            );
            // INSERTAR DATOS ENCABEZADO  medicamento            
            $this->historia_model->ingresoencmed($m_enc_medicamentos, $num_formula);

            for ($i = 0; $i < count($this->input->post('id_medicamento')); $i++) 
            {
                // ingresar detalles
                $m_det_medicamentos = array(
                'num_formula'       =>  $num_formula,
                'id_paciente'       =>  $id_paciente,
                'id_medicamento'    =>  $this->input->post('id_medicamento', true)[$i], 
                'medicamento'       =>  $this->input->post('medicamento', true)[$i], 
                'cantidad'          =>  $this->input->post('cantidad', true)[$i],
                'prescripcion'      =>  $this->input->post('prescripcion', true)[$i],
                'viamedicamento'    =>  $this->input->post('viamedicamento', true)[$i],
                'fechaactual'       =>  $fechaactual,
                'horaactual'        =>  $horaactual,                            
                'login_ing'         =>  $login_ing,
                'cons_examen'       =>  $n_conexamen
                ); 

                // INSERTAR DATOS detalles medicamento            
                $this->historia_model->ingresodetmed($m_det_medicamentos);
            }

        } 
        
        // ENCABEZADO
        $encabezado                     =   $this->historia_model->conencaformula($num_formula, $id_paciente);
        // DETALLES
        $datos['detalles']              =   $this->historia_model->condetaformula($num_formula);
        //$datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        //$datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;

        //$this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    public function validacups()
    {
        $this->load->model('examen_model');

        $cod_cups           =   trim($this->input->post('bd_cod_cups', true));
        
        $cons_cups         =   $this->examen_model->cons_cups($cod_cups);
        echo $cons_cups;
    }

    // prequirurgicos
    public function busqueda_para()
    {
        $paraclinico         =   trim($this->input->post('paraclinico', true));
        
        $this->datatables->select("cod_listap, nombre_listap")
        ->from('listaprecios');
        $this->db->like('nombre_listap', $paraclinico);       
        $this->db->where_in('cod_lptipo', '4');    
        echo $this->datatables->generate(); 
    }  

    // consulta prequirurgicos
    public function consulta_prequirurgicos()
    {
        $this->load->model('examen_model');
        $datos['cons_prequirurgicos']         =   $this->examen_model->cons_prequirurgicos();
        $this->load->view('front_end/historias/hexamen_preq_v', $datos);
    }

    // consulta prequirurgicos
    public function consulta_prequirurgicos_op()
    {
        $this->load->model('examen_model');
        $datos['cons_prequirurgicos']         =   $this->examen_model->cons_prequirurgicos();
        $this->load->view('front_end/historias/hexamen_preq_op_v', $datos);
    }

    public function nuevocups()
    {   
        $this->load->model('examen_model');

        $cod_cups               =   strtoupper($this->input->post('codigo_cups', true));
        $nombre_cups            =   strtoupper($this->input->post('nombre_cups', true));
        $sexo                   =   'A';
        $limite_inferior        =   0;
        $limite_superior        =   599;
        $cupsmaxvecesdia        =   '1';
        $cupsmaxvecesvida       =   '';
        $cupstiempolimitedias   =   '';
        $cupsconcie             =   'S';
        $cupstipoatencion       =   'AP';
        $cupstipoprocedimiento  =   'Cirugía';
        $cod_cups_tipopro       =   '1';
        $valor                  =   0;
        $nuevo_manual           =   'SI';

        $m_nuevo_cups           =   array(
            'cod_cups'              =>   $cod_cups,
            'nombre_cups'           =>   $nombre_cups,
            'sexo'                  =>   $sexo,
            'limite_inferior'       =>   $limite_inferior,
            'limite_superior'       =>   $limite_superior,
            'cupsmaxvecesdia'       =>   $cupsmaxvecesdia,
            'cupsmaxvecesvida'      =>   $cupsmaxvecesvida,
            'cupstiempolimitedias'  =>   $cupstiempolimitedias,
            'cupsconcie'            =>   $cupsconcie,
            'cupstipoatencion'      =>   $cupstipoatencion,
            'cupstipoprocedimiento' =>   $cupstipoprocedimiento,
            'cod_cups_tipopro'      =>   $cod_cups_tipopro,
            'valor'                 =>   $valor,
            'nuevo_manual'          =>   $nuevo_manual
        );

        $insertNewCups  =   $this->examen_model->insertNewCups($m_nuevo_cups);
        $cons_id        =   $this->examen_model->cons_id($cod_cups);
        
        echo $cons_id;
    }

    public function siluetas() {
        $vista = $this->input->post('vista');

        if ($this->input->post('identificacion') && $this->input->post('tipo_docu')) {

            $this->load->model('examen_model');
            $datos["notes"] = $this->examen_model->silueta($this->input->post('identificacion'), $this->input->post('tipo_docu'), $this->input->post('n_conexamen'));
            $this->load->view('front_end/historias/' . $vista . ".php", $datos);

        } else {
            $this->load->view('front_end/historias/' . $vista . ".php");
        }

    }

    public function csiluetas() {
        $vista = $this->input->post('vista');
        $vnotes= $this->input->post('vnotes');
        $datos['vnotes'] =  $vnotes;
        if ($this->input->post('id_paciente')) {

            $this->load->model('historia_model');
            $datos["notes"] = $this->historia_model->silueta($this->input->post('id_paciente'));
            $this->load->view('front_end/historias/' . $vista . ".php", $datos);

        } else {
            $this->load->view('front_end/historias/' . $vista . ".php");
        }

    }

    public function consulta_hist_oft()
    {
        $this->load->model('examen_model');

        $id_paciente        =   $this->input->post('bd_id_paciente_oft', true);
        $n_conexamen        =   $this->input->post('bd_cons_examen_oft', true);

        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   '';
        $datos['tipo_identificacion']   =   '';
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);   
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);     

        $this->load->view('front_end/historias/hexamen_r_v', $datos);

    }

    public function consulta_hist_opt()
    {
        $this->load->model('examen_model');
        //$this->load->library('imagenes');

        $id_paciente        =   $this->input->post('bd_id_paciente_opt', true);
        $n_conexamen        =   $this->input->post('bd_cons_examen_opt', true);



        //$this->load->library('s3');

        $datos['examen_opt']            =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        

        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_optometria']      =  $this->input->post('num_optometria', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   '';
        $datos['tipo_identificacion']   =   '';
        $datos['n_conexamen']           =   $n_conexamen;

        
        $datos['cons_examen']           =   $n_conexamen;  


        $this->load->view('front_end/historias/hexamen_opt_v', $datos);
    }

    // consentimientos anestesia
    public function ing_cons_anestesia()
    {
        $this->load->library('imagenes');
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        
        $n_conexamen = $this->examen_model->consultaconsecutivo(7);
        $fechaingreso   = date("Y-m-d");
        $horaingreso    = date("H:i:s");
        $id_paciente    =   $this->input->post('id_paciente', true);

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1_cons_ane'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $m_cons_anestesia = [
            'cons_examen'       =>  $n_conexamen,
            'id_paciente'       =>  $id_paciente,
            'descripcion'       =>  $this->input->post('descripcioncons_ane'),
            'fechaactual'       =>  $fechaingreso,
            'horaactual'        =>  $horaingreso,
            'tipo'              =>  'DILATACIÓN',
            'firmamedi'         =>  $up_firma_medico
        ];

        $inserConsOdon = $this->examen_model->ingresoConsAne($m_cons_anestesia, $n_conexamen);

        // CONSULTA DE consentimiento anestesia
        $this->load->library('s3');
        $datos['cons_cons_ane']         =   $this->examen_model->cons_cons_ane($id_paciente,$n_conexamen);
        $this->load->view('front_end/historias/hexamen_cons_ane_v', $datos);
    } 

    public function rep_cons_ane()
    {
        
        $this->load->library('s3');
        $this->load->model('examen_model');
        
        $bd_id_con_asig         =   trim($this->input->post('bd_id_con_asig'));
        
        
        $con_cons_ane           =   $this->examen_model->con_cons_ane($bd_id_con_asig);  
        if($con_cons_ane)
        {
            foreach($con_cons_ane as $cpac)
            {
                $texto          =   $cpac['descripcion'];
                //$firmapaci      =   $cpac['firmapaci'];
            }    
        }
        

        //if ($a->firmapaci !== '0') 
        //{
            
        //    $fpac   =   "<img src='". S3::getAuthenticatedURL('histocol', $a->firmapaci, 3600). "' style='width: 300px; height: 150px' />";
        //} else {
            $fpac   =   "";
        //}

        $html = 
        "<style>@page {
                margin-top: 0.5cm;
                margin-bottom: 0.5cm;
                margin-left: 0.5cm;
                margin-right: 0.5cm;
            }
            </style>".
        "<body>
            <div style='color:#006699;'><b>".$texto."<b></div>".
                "<div style='width:50px; height:50px; background-color:red;'>asdf</div>

                <div >".$fpac."</div>

        </body>";


        $this->load->library('M_pdf');
        $mpdf = new mPDF('c', 'A4-L'); 
        $mpdf->WriteHTML($texto);
        $mpdf->Output("Reporte consentimiento odontologia.pdf", "I");
    }

    public function cons_firma_med()
    {
        $this->load->model('examen_model');
        $cod_medi   =   $this->input->post('cod_medi');
        $cons_f     =   $this->examen_model->firma_medi($cod_medi);


    }
    
    public function rep_medicamentos()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);

        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);
        
        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }
        }

        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           =   $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
            $obs_medicamentos_oft           =   $exa->obs_medicamentos_oft;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }            
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        /////
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(0,4,utf8_decode('FORMULACIÓN DE MEDICAMENTOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }

        if($medicamentos)
        {
            //$this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Medicamentos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(26, 5, utf8_decode('Código'), 1, 0, 'C', 0);
            $this->pdf->Cell(64, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
            $this->pdf->Cell(22, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(26,64,22,38,15,30));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('C','L','L','L','L','L'));

            if($medicamentos)
            {
                foreach ($medicamentos as $med) 
                {   
                    $cod_medicamento            =   utf8_decode($med['cod_medicamento']);
                    $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                    $concentracion              =   utf8_decode($med['concentracion']);
                    $prescripcion               =   utf8_decode($med['prescripcion']);
                    $cantidad                   =   utf8_decode($med['cantidad']);
                    $tiempo                     =   utf8_decode($med['tiempo']);
                    
                    $this->pdf->Row(array($cod_medicamento,$nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                }
            }    
        }

        if($obs_medicamentos_oft)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(22,4,utf8_decode('Observaciones:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            //$this->pdf->Cell(35,4,utf8_decode($obs_medicamentos_oft),0,0,'L');
            $this->pdf->MultiCell(0,4,utf8_decode($obs_medicamentos_oft),0,'J');    
        }

        $this->pdf->Ln(2);
        $this->pdf->SetX(10);

        // FIRMAS
        
        
        if($c_firma_medico)
        {
            $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
        

        $this->pdf->Output("Reporte medicamentos .pdf", 'I');

    }

    public function rep_medicamentos_op()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen_op($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);

        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);
        
        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }
        }

        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           =   $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
            $obs_medicamentos_opt           =   $exa->obs_medicamentos_opt;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }            
        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        
        
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(0,4,utf8_decode('FORMULACIÓN DE MEDICAMENTOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');


                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }

        if($medicamentos)
        {
            //$this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Medicamentos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(26, 5, utf8_decode('Código'), 1, 0, 'C', 0);
            $this->pdf->Cell(64, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
            $this->pdf->Cell(22, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(26,64,22,38,15,30));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('C','L','L','L','L','L'));

            if($medicamentos)
            {
                foreach ($medicamentos as $med) 
                {   
                    $cod_medicamento            =   utf8_decode($med['cod_medicamento']);
                    $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                    $concentracion              =   utf8_decode($med['concentracion']);
                    $prescripcion               =   utf8_decode($med['prescripcion']);
                    $cantidad                   =   utf8_decode($med['cantidad']);
                    $tiempo                     =   utf8_decode($med['tiempo']);
                    
                    $this->pdf->Row(array($cod_medicamento, $nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                }
            }    
        }

        // observaciones medicamentos
        if($obs_medicamentos_opt)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Observaciones medicamentos:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($obs_medicamentos_opt),0,0,'L');
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($c_firma_medico)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image($c_firma_medico,110, $this->pdf->GetY(), 50, 25);
        }else
        {
        }
        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,20, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }
        
        

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);


        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte medicamentos .pdf", 'I');

    }

    public function rep_prequirurgico()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('PREQUIRURGICOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }
        
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();         
        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // paraclinicos
        if($paraclinicos)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(25, 5, utf8_decode('Código'), 1, 0, 'C', 0);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(25,150));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('C','L'));

            if($paraclinicos)
            {
                foreach ($paraclinicos as $para) 
                {   
                    $codigo_para            =   utf8_decode($para['detalle']);
                    $nombre_para            =   utf8_decode($para['nombre_para']);
                    
                    $this->pdf->Row(array($codigo_para, $nombre_para));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($c_firma_medico)
        {
            $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
        

        $this->pdf->Output("Reporte prequirurgico.pdf", 'I');
    }

    public function rep_prequirurgico_op()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen_op($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('PREQUIRURGICOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();         
        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // paraclinicos
        if($paraclinicos)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(25, 5, utf8_decode('Código'), 1, 0, 'C', 0);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(25,150));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('C','L'));

            if($paraclinicos)
            {
                foreach ($paraclinicos as $para) 
                {   
                    $codigo_para            =   utf8_decode($para['detalle']);
                    $nombre_para            =   utf8_decode($para['nombre_para']);
                    
                    $this->pdf->Row(array($codigo_para, $nombre_para));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }
        
        $this->pdf->ln(20);
        
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte prequirurgico.pdf", 'I');
    }

    // reporte incapacidades
    public function rep_incapacidades()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            
            $nombre_admi                    =   $exa->nombre_admi;
            

            $incapacidades                  =   $exa->incapacidades;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('INCAPACIDAD'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // incapacidades
        if($incapacidades)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($c_firma_medico)
        {
            $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte incapacidad.pdf", 'I');
    }

    public function rep_incapacidades_op()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen_op($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            
            $nombre_admi                    =   $exa->nombre_admi;
            

            $incapacidades                  =   $exa->incapacidades;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('INCAPACIDAD'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // incapacidades
        if($incapacidades)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte incapacidad.pdf", 'I');
    }

    // reporte ordenes medicas oftalmologicas
    public function rep_ordenes_medicas()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }
        
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta              =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $tipo                           = $exa->nombre_listap;
            $tipoconsulta                   = $exa->nombre_cons;
            $firmapaci                      =   $exa->firmapaci;
            $firmamedi                      =   $exa->firmamedi;

            $observacionescups              =   $exa->observacionescups;
            $nombre_admi                    =   $exa->nombre_admi;
            $nombre_listap                  =   $exa->nombre_listap;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('ORDEN MÉDICA'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                    if($ci['observacionescier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                    if($ci['observacionesciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                    if($ci['observacionescierr'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                    }
                }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }
        $this->pdf->Ln();

        // CUPS
        if($cups)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15, 5, utf8_decode('CUPS'), 1, 0, 'C', 0);
            $this->pdf->Cell(140, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(15,140,20,15));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','L','R'));

            if($cups)
            {
                foreach ($cups as $row) 
                {   
                    $cod_cups            =   utf8_decode($row['cod_cups']);
                    $descripcion         =   utf8_decode($row['nombre_cups']);
                    $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                    $cantidad            =   utf8_decode($row['cantidad']);
                    
                    
                    $this->pdf->Row(array($cod_cups, $descripcion, $nombre_lateralidad, $cantidad));
                }
            }    
        }

        if($observacionescups)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($observacionescups),0,'J');
            //$this->pdf->Ln(3);
        }
        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($c_firma_medico)
        {
            //$this->pdf->Cell(15,4,$c_firma_medico,0,0,'L');
            $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($firmapaci)
        {
            $this->pdf->SetX(80);
            $this->pdf->Image('data://image/png;base64,'.$firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
            
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte Orden Medica .pdf", 'I');
    }

    // reporte ordenes medicas oftalmologicas
    public function rep_ordenes_medicas_op()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen_op($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);


        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }
        
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;

            $tipo                           =   $exa->nombre_listap;
            $tipoconsulta                   =   $exa->nombre_cons;
            $firmapaci                      =   $exa->firmapaci;
            $firmamedi                      =   $exa->firmamedi;

            $observacionescups              =   $exa->observacionescups;
            $nombre_admi                    =   $exa->nombre_admi;
            $nombre_listap                  =   $exa->nombre_listap;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('ORDEN MÉDICA'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                    if($ci['observacionescier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                    if($ci['observacionesciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                    if($ci['observacionescierr'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                    }
                }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }
        $this->pdf->Ln();

        // CUPS
        if($cups)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15, 5, utf8_decode('CUPS'), 1, 0, 'C', 0);
            $this->pdf->Cell(130, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(15,130,20,20));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','L','R'));

            if($cups)
            {
                foreach ($cups as $row) 
                {   
                    $cod_cups            =   utf8_decode($row['cod_cups']);
                    $descripcion         =   utf8_decode($row['nombre_cups']);
                    $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                    $cantidad            =   utf8_decode($row['cantidad']);
                    
                    $this->pdf->Row(array($cod_cups, $descripcion, $nombre_lateralidad, $cantidad));
                }
            }    
        }

        if($observacionescups)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($observacionescups),0,'J');
            //$this->pdf->Ln(3);
        }
        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($firmapaci)
        {
          $this->pdf->Image('data://image/png;base64,'.$c_firma_medico,30, $this->pdf->GetY(), 50, 25, 'png');
            
        }
        
        // FIRMAS
        if($c_firma_medico)
        {
            //$this->pdf->Image($c_firma_medico,20, $this->pdf->GetY(), 30, 20);
            $this->pdf->Image($c_firma_medico,20, $this->pdf->GetY(), 30, 20, 'png');
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte Orden Medica .pdf", 'I');
    }

    // optometria
    // nuevo cups optometria
    public function nuevocups_op()
    {   
        
        
        $this->load->model('examen_model');

        $cod_cups               =   strtoupper($this->input->post('codigo_cups_op', true));
        $nombre_cups            =   strtoupper($this->input->post('nombre_cups_op', true));
        $sexo                   =   'A';
        $limite_inferior        =   0;
        $limite_superior        =   599;
        $cupsmaxvecesdia        =   '1';
        $cupsmaxvecesvida       =   '';
        $cupstiempolimitedias   =   '';
        $cupsconcie             =   'S';
        $cupstipoatencion       =   'AP';
        $cupstipoprocedimiento  =   'Cirugía';
        $cod_cups_tipopro       =   '1';
        $valor                  =   0;
        $nuevo_manual           =   'SI';

        $m_nuevo_cups           =   array(
            'cod_cups'              =>   $cod_cups,
            'nombre_cups'           =>   $nombre_cups,
            'sexo'                  =>   $sexo,
            'limite_inferior'       =>   $limite_inferior,
            'limite_superior'       =>   $limite_superior,
            'cupsmaxvecesdia'       =>   $cupsmaxvecesdia,
            'cupsmaxvecesvida'      =>   $cupsmaxvecesvida,
            'cupstiempolimitedias'  =>   $cupstiempolimitedias,
            'cupsconcie'            =>   $cupsconcie,
            'cupstipoatencion'      =>   $cupstipoatencion,
            'cupstipoprocedimiento' =>   $cupstipoprocedimiento,
            'cod_cups_tipopro'      =>   $cod_cups_tipopro,
            'valor'                 =>   $valor,
            'nuevo_manual'          =>   $nuevo_manual
        );

        $insertNewCups  =   $this->examen_model->insertNewCups($m_nuevo_cups);
        $cons_id        =   $this->examen_model->cons_id($cod_cups);
        
        echo $cons_id;

    }

    // retinologia
    public function ingresoexamen_ret() 
    {
        //$this->load->library('imagenes');
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->examen_model->consultaconsecutivo(7);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);

        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso       =   date("Y-m-d");
        $horaingreso        =   date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /**
         * Subir firmas y foto
         */

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1_op'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1_op'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'                   =>  $id_paciente,
            'cons_examen'                   =>  $n_conexamen,
            'fechaactual'                   =>  $fechaactual,
            'horaactual'                    =>  $horaactual,
            'nconsulta'                     =>  $this->input->post('nconsulta', true),
            'login_ing'                     =>  $this->input->post('login', true),
            'edad'                          =>  $edad,
            'ume'                           =>  $ume,
            'cod_cons'                      =>  $this->input->post('codconsulta_ret', true),
            'observacionescups'             =>  $this->input->post('observacionescups_opret', true),
            'firmapaci'                     =>  $this->input->post('firmapaciente1_opret'),
            'cod_medi'                      =>  $this->input->post('medico_opret', true),
            'num_retinologia'               =>  $this->input->post('num_retinologia', true),
            //'cod_consultorio'               =>  $this->input->post('consultorios_op', true),
            'id_admi'                       =>  $this->input->post('convenios_opret', true),
            'mc_retin'                      =>  $this->input->post('mc_retin', true),
            'ea_retin'                      =>  $this->input->post('ea_retin', true),
            'ap_retin'                      =>  $this->input->post('ap_retin', true),
            'av_retin'                      =>  $this->input->post('av_retin', true),
            'bio_retin'                     =>  $this->input->post('bio_retin', true),
            'moe_retin'                     =>  $this->input->post('moe_retin', true),
            'pio_retin'                     =>  $this->input->post('pio_retin', true),
            'fo_retin'                      =>  $this->input->post('fo_retin', true),
            'reco_retin'                    =>  $this->input->post('reco_retin', true),
            'tipo_co'                       =>  $this->input->post('tipo_co_op_ret', true),
            'abierta'                       =>  'SI',
            'planotratamiento'              =>  $this->input->post('planotratamiento_opret', true),
            'id_agenda'                     =>  $this->input->post('id_agenda_opret', true),
            'incapacidades'                 =>  $this->input->post('incapacidades_opret', true),
            'obs_medicamentos_ret'          =>  $this->input->post('obs_medicamentos_ret', true),
            'tratamiento'                   =>  $this->input->post('tratamiento_opret', true)
        );

            $insertExa = $this->examen_model->insertExa_optret($examen, $n_conexamen);

            $vcod_cier = $this->input->post('cod_cier_opret', true);

            if (!$vcod_cier || $vcod_cier === '') {
                $cod_cier       =   '';
                $nombre_cier    =   '';
            } else {
                $cod_cier       =   $vcod_cier;
                $nombre_cier    =   $this->input->post('nombre_cier_opret');
            };

            $vcod_ciers = $this->input->post('cod_ciers_opret', true);

            if (!$vcod_ciers || $vcod_ciers === '') {
                $cod_ciers      =   '';
                $nombre_ciers   =   '';
            } else {
                $cod_ciers      =   $vcod_ciers;
                $nombre_ciers   =   $this->input->post('nombre_ciers_opret');
            };

            $vcod_cierr = $this->input->post('cod_cierr_opret', true);

            if (!$vcod_cierr || $vcod_cierr === '') {
                $cod_cierr      =   '';
                $nombre_cierr   =   '';
            } else {
                $cod_cierr      =   $vcod_cierr;
                $nombre_cierr   =   $this->input->post('nombre_cierr_opret');
            };

            $ciecups = array(
                'id_paciente'        => $id_paciente,
                'cons_examen'        => $n_conexamen,
                'nconsulta'          => $this->input->post('nconsulta', true),
                //'tipo_docu'          => $tipo_docu,
                //'identificacion'     => $identificacion,
                'edad'               => $edad,
                'ume'                => $ume,
                'cod_cie'            => $this->input->post('cod_cie_opret'),
                'nombre_cie'         => $this->input->post('nombre_cie_opret'),
                'cod_causa_dia'      => $this->input->post('causa_opret', true),
                'cod_fina_cie'       => $this->input->post('finalidad2_opret', true),
                'cod_tipo'           => $this->input->post('tipoo_opret', true),
                'observacionescie'   => $this->input->post('observacionescie_opret', true),
                'cod_cier'           => $cod_cier,      
                'nombre_cier'        => $nombre_cier,          
                'observacionescier'  => $this->input->post('observacionescier_opret', true),
                'cod_ciers'          => $cod_ciers,
                'nombre_ciers'       => $nombre_ciers,
                'observacionesciers' => $this->input->post('observacionesciers_opret', true),
                'cod_cierr'          => $cod_cierr,
                'nombre_cierr'       => $nombre_cierr,
                'observacionescierr' => $this->input->post('observacionescierr_opret', true),
                'fechaactual'        => $fechaactual,
                'horaactual'         => $horaactual,
                'cod_medi'           => '110010756401',
                'cod_cons'           => $this->input->post('codconsulta_ret'),
                'login_ing'          => $this->input->post('login', true),
                'id_admi'            => $this->input->post('convenios_opret', true),
                'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                //'revolucion'         => 'SI',
                //'nevolucion'         => $this->input->post('version', true),
                'num_retinologia'     =>  $this->input->post('num_retinologia', true),
                'activo'             => 'SI'
            );

            $this->examen_model->insertCieCups($ciecups);

            /////////////// *** inicio de cie +cie cups prequ medi incap
            $cod_cups = $this->input->post('cod_cups_opret');

            if ($cod_cups) {

                for ($i = 0; $i < count($this->input->post('cod_cups_opret')); $i++) {

                    if (!$this->input->post('actoqcupso_opret', true)[$i] && $this->input->post('actoqcupso_opret', true)[$i] === '') {
                        $actoQuirirgico = '';
                    } else {
                        $actoQuirirgico = $this->input->post('actoqcupso_opret', true)[$i];
                    }

                    $cups = [
                        'id_paciente'    => $id_paciente,
                        'cons_examen'    => $n_conexamen,
                        'nconsulta'      => $this->input->post('nconsulta', true),
                        //'tipo_docu'      => $tipo_docu,
                        //'identificacion' => $identificacion,
                        'edad'           => $edad,
                        'ume'            => $ume,
                        'cod_cups'       => $this->input->post('cod_cups_opret')[$i],
                        'nombre_cups'    => $this->input->post('nombre_cups_opret')[$i],
                        'id_finalidad'   => $this->input->post('finalidadcupso_opret', true)[$i],
                        'cod_ambi'       => $this->input->post('ambitocupso_opret', true)[$i],
                        'cod_actoq'      => $actoQuirirgico,
                        'lateralidad'    => $this->input->post('lateralidad_opret', true)[$i],
                        'cantidad'       => $this->input->post('cantidad_ret', true)[$i],
                        'autorizacion'   => $this->input->post('autorizacion_opret', true)[$i],
                        'valor_cups'     => $this->input->post('valor_cups_opret')[$i],
                        'fechaactual'    => $fechaactual,
                        'horaactual'     => $horaactual,
                        'cod_medi'       => '110010756401',
                        'cod_cons'       => $this->input->post('codconsulta_ret'),
                        'login_ing'      => $this->input->post('login', true),
                        'id_admi'        => $this->input->post('convenios_opret', true),
                        'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                        //'revolucion'     => 'SI',
                        //'nevolucion'     => $this->input->post('version', true)
                        'num_retinologia' => $this->input->post('num_retinologia', true),
                        'activo'             => 'SI'
                    ];
                    $this->examen_model->insertCieCups($cups);
                }

            }

            // mas cie diagnosticos
            $mas_cups = $this->input->post('cod_cierr_mop_opret');
            if ($mas_cups) 
            {
                for ($i = 0; $i < count($this->input->post('cod_cierr_mop_opret')); $i++) 
                {
                    $mciecups = array(
                        'id_paciente'           => $id_paciente,
                        'cons_examen'           => $n_conexamen,
                        'nconsulta'             => $this->input->post('nconsulta', true),
                        //'tipo_docu'          => $tipo_docu,
                        //'identificacion'     => $identificacion,
                        'edad'                  => $edad,
                        'ume'                   => $ume,
                        'cod_causa_dia'         => $this->input->post('causa_opret', true),
                        'cod_fina_cie'          => $this->input->post('finalidad2_opret', true),
                        'cod_tipo'              => $this->input->post('tipoo_opret', true),
                        'fechaactual'           => $fechaactual,
                        'horaactual'            => $horaactual,
                        'cod_medi'              => '110010756401',
                        'cod_cons'              => $this->input->post('codconsulta_ret'),
                        'login_ing'             => $this->input->post('login', true),
                        'id_admi'               => $this->input->post('convenios_opret', true),
                        'cod_persona_atie'      => $this->input->post('cod_persona_atie', true),
                        //'revolucion'         => 'SI',
                        //'nevolucion'         => $this->input->post('version', true),
                        'num_retinologia'       => $this->input->post('num_retinologia', true),
                        'cod_ciemas'            => $this->input->post('cod_cierr_mop_opret', true)[$i],
                        'nombre_ciemas'         => $this->input->post('nombre_cierr_mop_opret', true)[$i],
                        'observaciones_ciemas'  => $this->input->post('observaciones_cierr_mop_opret', true)[$i],
                        'activo'                => 'SI'
                    );
                    $this->examen_model->insertCieCups($mciecups);
                }
            }

            // medicamentos retinologia
            $medicamentos = $this->input->post('id_medicamento_opret');
            if ($medicamentos) 
            {
                for ($i = 0; $i < count($this->input->post('id_medicamento_opret')); $i++) 
                {
                    $m_medicamentos = array(
                        'id_paciente'               =>  $id_paciente,
                        'cons_examen'               =>  $n_conexamen,
                        'fechaactual'               =>  $fechaactual,
                        'horaactual'                =>  $horaactual,
                        'nconsulta'                 =>  $this->input->post('nconsulta', true),
                        'login_ing'                 =>  $this->input->post('login', true),
                        'cod_medi'                  =>  $this->input->post('medico', true),
                        'id_admi'                   =>  $this->input->post('convenios_opret', true),
                        'tipo_historia'             =>  'RETINOLOGIA',
                        'id_medicamento'            =>  $this->input->post('id_medicamento_opret', true)[$i],
                        'nombre_medicamento'        =>  $this->input->post('nombre_medicamento_opret', true)[$i],
                        'concentracion'             =>  $this->input->post('concentracion_opret', true)[$i],
                        'prescripcion'              =>  $this->input->post('prescripcion_opret', true)[$i],
                        'cantidad'                  =>  $this->input->post('cantidad_opret', true)[$i],
                        'tiempo'                    =>  $this->input->post('tiempo_opret', true)[$i],
                        'activo'                    => 'SI'
                    );
                    $this->examen_model->insertMedicamentos($m_medicamentos);
                }
            }

            // paraclinicos
            $cod_para = $this->input->post('cod_para_opret');
            if ($cod_para) 
            {
                for ($i = 0; $i < count($this->input->post('cod_para_opret')); $i++) 
                { 
                    $m_para = array(
                        'id_paciente'        => $this->input->post('id_paciente'),
                        'cons_examen'        => $n_conexamen,
                        'cons_paraclinico'   => $n_conparaclinico,
                        'login_ing'          => $this->input->post('login', true),
                        'cod_para'           => $this->input->post('cod_para_opret', true)[$i],
                        'nombre_para'        => $this->input->post('nombre_para_opret', true)[$i],
                        'activo'             => 'SI'
                    );
                    $this->examen_model->insertPara($m_para, $n_conparaclinico);
                }
            }

            // actualiza agenda color y evento
            $id_agenda          =    $this->input->post('id_agenda_opret', true);
            if($id_agenda === '')
            {

            }else
            {
                $m_agenda   =   array(
                    'estado'    =>   'Atendio',
                    'color'     =>   '#5cb85c'
                );
                $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
            }              
            /////////////// *** cierre de cie +cie cups prequ medi incap 

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            
            'ultimocontrol'         =>  $fechaactual,
            'version'               =>  $this->input->post('version', true),
            'num_retinologia'        =>  $this->input->post('num_retinologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // CONSULTA DE PACIENTE NUEVO
        $datos['examen_optret']         =   $this->examen_model->ciexamen_optret($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
        $datos['num_retinologia']       =  $this->input->post('num_retinologia', true);
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen;        
        $f_med          =   $this->input->post('medico_opret', true);
        $datos['firma_medico_img']     =   $this->examen_model->firma_medi_exa($f_med);
        $examen_oft                     =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        if($examen_oft)
        {
            foreach($examen_oft as $fmedi)
            {
                $f_med                          =   $fmedi->cod_medi;
                $firma_medico_img               =   $this->examen_model->firma_medi_exa($f_med);
                if($firma_medico_img)
                {
                    foreach($firma_medico_img as $fmedi)
                    {
                        $datos['f_medico']  =   $fmedi['firmamedi'];
                    }
                }else
                {
                    $datos['f_medico']  =   '';
                }
            }
        }
        $this->load->view('front_end/historias/hexamen_opt_ret_v', $datos);
    }

    // actualizando historia oftalmologica
    public function actualizaexamen_optret() 
    {
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->input->post('retinologia_abierta', true);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);
        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'                   =>  $id_paciente,
            'cons_examen'                   =>  $n_conexamen,
            'fechaactual'                   =>  $fechaactual,
            'horaactual'                    =>  $horaactual,
            'nconsulta'                     =>  $this->input->post('nconsulta', true),
            'login_ing'                     =>  $this->input->post('login', true),
            'edad'                          =>  $edad,
            'ume'                           =>  $ume,
            'cod_cons'                      =>  $this->input->post('codconsulta_ret', true),
            'observacionescups'             =>  $this->input->post('observacionescups_opret', true),
            'firmapaci'                     =>  $this->input->post('firmapaciente1_opret'),
            'cod_medi'                      =>  $this->input->post('medico_opret', true),
            'num_retinologia'               =>  $this->input->post('num_retinologia', true),
            'id_admi'                       =>  $this->input->post('convenios_opret', true),
            'mc_retin'                      =>  $this->input->post('mc_retin', true),
            'ea_retin'                      =>  $this->input->post('ea_retin', true),
            'ap_retin'                      =>  $this->input->post('ap_retin', true),
            'av_retin'                      =>  $this->input->post('av_retin', true),
            'bio_retin'                     =>  $this->input->post('bio_retin', true),
            'moe_retin'                     =>  $this->input->post('moe_retin', true),
            'pio_retin'                     =>  $this->input->post('pio_retin', true),
            'fo_retin'                      =>  $this->input->post('fo_retin', true),
            'reco_retin'                    =>  $this->input->post('reco_retin', true),
            'tipo_co'                       =>  $this->input->post('tipo_co_op_ret', true),
            'abierta'                       =>  'SI',
            'planotratamiento'              =>  $this->input->post('planotratamiento_opret', true),
            'id_agenda'                     =>  $this->input->post('id_agenda_opret', true),
            'incapacidades'                 =>  $this->input->post('incapacidades_opret', true),
            'obs_medicamentos_ret'          =>  $this->input->post('obs_medicamentos_ret', true),
            'tratamiento'                   =>  $this->input->post('tratamiento_opret', true)
        );

        $updateExa = $this->examen_model->updateExa_optret($examen, $n_conexamen);

        // colocar inactivo los cie en ciecups
        $m_cie_activo   =    array(
            'activo'    => 'NO');

        $update_cie_activo  =   $this->examen_model->updateCIEActivo($m_cie_activo, $n_conexamen);

        $vcod_cier = $this->input->post('cod_cier_opret', true);

        if (!$vcod_cier || $vcod_cier === '') {
            $cod_cier       =   '';
            $nombre_cier    =   '';
        } else {
            $cod_cier       =   $vcod_cier;
            $nombre_cier    =   $this->input->post('nombre_cier_opret');
        };

        $vcod_ciers = $this->input->post('cod_ciers_opret', true);

        if (!$vcod_ciers || $vcod_ciers === '') {
            $cod_ciers      =   '';
            $nombre_ciers   =   '';
        } else {
            $cod_ciers      =   $vcod_ciers;
            $nombre_ciers   =   $this->input->post('nombre_ciers_opret');
        };

        $vcod_cierr = $this->input->post('cod_cierr_opret', true);

        if (!$vcod_cierr || $vcod_cierr === '') {
            $cod_cierr      =   '';
            $nombre_cierr   =   '';
        } else {
            $cod_cierr      =   $vcod_cierr;
            $nombre_cierr   =   $this->input->post('nombre_cierr_opret');
        };

        $ciecups = array(
            'id_paciente'        => $id_paciente,
            'cons_examen'        => $n_conexamen,
            'nconsulta'          => $this->input->post('nconsulta', true),
            'edad'               => $edad,
            'ume'                => $ume,
            'cod_cie'            => $this->input->post('cod_cie_opret'),
            'nombre_cie'         => $this->input->post('nombre_cie_opret'),
            'cod_causa_dia'      => $this->input->post('causa_opret', true),
            'cod_fina_cie'       => $this->input->post('finalidad2_opret', true),
            'cod_tipo'           => $this->input->post('tipoo_opret', true),
            'observacionescie'   => $this->input->post('observacionescie_opret', true),
            'cod_cier'           => $cod_cier,      
            'nombre_cier'        => $nombre_cier,          
            'observacionescier'  => $this->input->post('observacionescier_opret', true),
            'cod_ciers'          => $cod_ciers,
            'nombre_ciers'       => $nombre_ciers,
            'observacionesciers' => $this->input->post('observacionesciers_opret', true),
            'cod_cierr'          => $cod_cierr,
            'nombre_cierr'       => $nombre_cierr,
            'observacionescierr' => $this->input->post('observacionescierr_opret', true),
            'fechaactual'        => $fechaactual,
            'horaactual'         => $horaactual,
            'cod_medi'           => '110010756401',
            'cod_cons'           => $this->input->post('codconsulta_ret'),
            'login_ing'          => $this->input->post('login', true),
            'id_admi'            => $this->input->post('convenios_opret', true),
            'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
            'num_retinologia'     =>  $this->input->post('num_retinologia', true),
            'activo'             => 'SI'
        );

        $this->examen_model->insertCieCups($ciecups);

        $cod_cups = $this->input->post('cod_cups_opret');

        if ($cod_cups) {

            for ($i = 0; $i < count($this->input->post('cod_cups_opret')); $i++) {

                if (!$this->input->post('actoqcupso_opret', true)[$i] && $this->input->post('actoqcupso_opret', true)[$i] === '') {
                    $actoQuirirgico = '';
                } else {
                    $actoQuirirgico = $this->input->post('actoqcupso_opret', true)[$i];
                }

                $cups = [
                    'id_paciente'    => $id_paciente,
                    'cons_examen'    => $n_conexamen,
                    'nconsulta'      => $this->input->post('nconsulta', true),
                    'edad'           => $edad,
                    'ume'            => $ume,
                    'cod_cups'       => $this->input->post('cod_cups_opret')[$i],
                    'nombre_cups'    => $this->input->post('nombre_cups_opret')[$i],
                    'id_finalidad'   => $this->input->post('finalidadcupso_opret', true)[$i],
                    'cod_ambi'       => $this->input->post('ambitocupso_opret', true)[$i],
                    'cod_actoq'      => $actoQuirirgico,
                    'lateralidad'    => $this->input->post('lateralidad_opret', true)[$i],
                    'cantidad'       => $this->input->post('cantidad_ret', true)[$i],
                    'autorizacion'   => $this->input->post('autorizacion_opret', true)[$i],
                    'valor_cups'     => $this->input->post('valor_cups_opret')[$i],
                    'fechaactual'    => $fechaactual,
                    'horaactual'     => $horaactual,
                    'cod_medi'       => '110010756401',
                    'cod_cons'       => $this->input->post('codconsulta_ret'),
                    'login_ing'      => $this->input->post('login', true),
                    'id_admi'        => $this->input->post('convenios_opret', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    'num_retinologia' => $this->input->post('num_retinologia', true),
                    'activo'             => 'SI'
                ];
                $this->examen_model->insertCieCups($cups);
            }

        }

        // mas cie diagnosticos
        $mas_cups = $this->input->post('cod_cierr_mop_opret');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cierr_mop_opret')); $i++) 
            {
                $mciecups = array(
                    'id_paciente'           => $id_paciente,
                    'cons_examen'           => $n_conexamen,
                    'nconsulta'             => $this->input->post('nconsulta', true),
                    'edad'                  => $edad,
                    'ume'                   => $ume,
                    'cod_causa_dia'         => $this->input->post('causa_opret', true),
                    'cod_fina_cie'          => $this->input->post('finalidad2_opret', true),
                    'cod_tipo'              => $this->input->post('tipoo_opret', true),
                    'fechaactual'           => $fechaactual,
                    'horaactual'            => $horaactual,
                    'cod_medi'              => '110010756401',
                    'cod_cons'              => $this->input->post('codconsulta_ret'),
                    'login_ing'             => $this->input->post('login', true),
                    'id_admi'               => $this->input->post('convenios_opret', true),
                    'cod_persona_atie'      => $this->input->post('cod_persona_atie', true),
                    'num_retinologia'       => $this->input->post('num_retinologia', true),
                    'cod_ciemas'            => $this->input->post('cod_cierr_mop_opret', true)[$i],
                    'nombre_ciemas'         => $this->input->post('nombre_cierr_mop_opret', true)[$i],
                    'observaciones_ciemas'  => $this->input->post('observaciones_cierr_mop_opret', true)[$i],
                    'activo'                => 'SI'
                );
                $this->examen_model->insertCieCups($mciecups);
            }
        }

        // colocar inactivo los medicamentos
        $m_med_activo   =    array(
            'activo'    => 'NO');

        $update_med_activo  =   $this->examen_model->updateMEDActivo($m_med_activo, $n_conexamen);
        
        // medicamentos retinologia
        $medicamentos = $this->input->post('id_medicamento_opret');
        if ($medicamentos) 
        {
            for ($i = 0; $i < count($this->input->post('id_medicamento_opret')); $i++) 
            {
                $m_medicamentos = array(
                    'id_paciente'               =>  $id_paciente,
                    'cons_examen'               =>  $n_conexamen,
                    'fechaactual'               =>  $fechaactual,
                    'horaactual'                =>  $horaactual,
                    'nconsulta'                 =>  $this->input->post('nconsulta', true),
                    'login_ing'                 =>  $this->input->post('login', true),
                    'cod_medi'                  =>  $this->input->post('medico', true),
                    'id_admi'                   =>  $this->input->post('convenios_opret', true),
                    'tipo_historia'             =>  'RETINOLOGIA',
                    'id_medicamento'            =>  $this->input->post('id_medicamento_opret', true)[$i],
                    'nombre_medicamento'        =>  $this->input->post('nombre_medicamento_opret', true)[$i],
                    'concentracion'             =>  $this->input->post('concentracion_opret', true)[$i],
                    'prescripcion'              =>  $this->input->post('prescripcion_opret', true)[$i],
                    'cantidad'                  =>  $this->input->post('cantidad_opret', true)[$i],
                    'tiempo'                    =>  $this->input->post('tiempo_opret', true)[$i],
                    'activo'                    => 'SI'
                );
                $this->examen_model->insertMedicamentos($m_medicamentos);
            }
        }

        // paraclinicos
        $m_para_activo   =    array(
            'activo'    => 'NO');

        $update_para_activo  =   $this->examen_model->updatePARAActivo($m_para_activo, $n_conexamen);

        // paraclinicos
        $cod_para = $this->input->post('cod_para_opret');
        if ($cod_para) 
        {
            for ($i = 0; $i < count($this->input->post('cod_para_opret')); $i++) 
            { 
                $m_para = array(
                    'id_paciente'        => $this->input->post('id_paciente'),
                    'cons_examen'        => $n_conexamen,
                    'cons_paraclinico'   => $n_conparaclinico,
                    'login_ing'          => $this->input->post('login', true),
                    'cod_para'           => $this->input->post('cod_para_opret', true)[$i],
                    'nombre_para'        => $this->input->post('nombre_para_opret', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertPara($m_para, $n_conparaclinico);
            }
        }

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            'ultimocontrol'         =>  $fechaactual,
            //'version'               =>  $this->input->post('version', true),
            //'num_oftalmologia'      =>  $this->input->post('num_oftalmologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // CONSULTA DE PACIENTE NUEVO
        $datos['examen_optret']         =   $this->examen_model->ciexamen_optret($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
        $datos['num_retinologia']       =  $this->input->post('num_retinologia', true);
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen; 
        $f_med          =   $this->input->post('medico_opret', true);
        $datos['firma_medico_img']     =   $this->examen_model->firma_medi_exa($f_med);
        $examen_oft                     =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        if($examen_oft)
        {
            foreach($examen_oft as $fmedi)
            {
                $f_med                          =   $fmedi->cod_medi;
                $firma_medico_img               =   $this->examen_model->firma_medi_exa($f_med);
                if($firma_medico_img)
                {
                    foreach($firma_medico_img as $fmedi)
                    {
                        $datos['f_medico']  =   $fmedi['firmamedi'];
                    }
                }else
                {
                    $datos['f_medico']  =   '';
                }
            }
        }       
        $this->load->view('front_end/historias/hexamen_opt_ret_v', $datos);
    }

    public function rep_historia_optret()
    {
        $this->load->model('examen_model');
        //$this->load->library('s3');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('n_conexamen');

        $examen             =   $this->examen_model->ciexamen_optret($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        //$ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        

        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // PRESTADOR
        //$prestador          =   $this->examen_model->prestador();
        
        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto     =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $nombre_admi    =   $pac->nombre_admi;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        foreach($examen as $exa)
        {
            $fecha_consulta  =   $exa['fechaactual'];
            $hora_consulta   =   $exa['horaactual'];
            $medico          =   $exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi'];
            $incapacidades                  =   $exa['incapacidades'];
            $cod_medi       =    $exa['cod_medi'];
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 

        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        /////
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();

        foreach($examen as $exa)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Examen Retinología'),0,0,'L');
            
            // MEDICO, TIPO CONSULTA
            $this->pdf->SetX(55);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi']),0,0,'L');
            $this->pdf->SetX(120);
            
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(25,4,utf8_decode('Número Control:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(40,4,utf8_decode($exa['num_retinologia']),0,0,'L');
            $this->pdf->Ln();

            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());
            $this->pdf->Ln();

            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['nombre_listap']),0,0,'L');
            $this->pdf->Ln();            


            if($exa['mc_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('MC:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['mc_retin']),0,'J');
            }

            if($exa['ea_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('EA:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['ea_retin']),0,'J');
            }

            if($exa['ap_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('AP:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['ap_retin']),0,'J');
            }


            if($exa['av_retin'] || $exa['bio_retin'] || $exa['moe_retin'] || $exa['pio_retin'] || $exa['fo_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Examen'),0,0,'L');    
                $this->pdf->Ln();

                if($exa['av_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('AV:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['av_retin']),0,'J');
                }

                if($exa['bio_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('BIO:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['bio_retin']),0,'J');
                }

                if($exa['moe_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('MOE:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['moe_retin']),0,'J');
                }

                if($exa['pio_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('PIO:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['pio_retin']),0,'J');
                }

                if($exa['fo_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('FO:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['fo_retin']),0,'J');
                }
            }

            // observaciones cups
            if($exa['tratamiento'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tratamiento :'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['tratamiento']),0,'J');
                $this->pdf->Ln();
            }

            if($exa['reco_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Recomendaciones:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['reco_retin']),0,'J');
            }
            
            // DIAGNOSTICOS
            if($cie)
            {
                foreach($cie as $ci)
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());   
                    
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','BU',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                    if($ci['observacionescie'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');    
                    }
                    
                    if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                    }

                    if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                    if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
                }
            }

            // MAS DIAGNOSTICOS
            if($ciemas)
            {
                $this->pdf->Ln(5);
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
                $this->pdf->Ln(5);
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(90,90));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($ciemas)
                {
                    foreach ($ciemas as $cmas) 
                    {   
                        $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                        $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                        
                        
                        $this->pdf->Row(array($cod_ciemas, $cod_observ));
                    }
                }    
            }

            // paraclinicos
            if($paraclinicos)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('PREQUIRURGICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',7);
                $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',7);
                $this->pdf->SetWidths(array(150));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($paraclinicos)
                {
                    foreach ($paraclinicos as $para) 
                    {   
                        $nombre_para            =   utf8_decode($para['nombre_para']);
                        
                        
                        $this->pdf->Row(array($nombre_para));
                    }
                }    
            }

            // ordenes medicas
            if($cups)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('ORDENES MÉDICAS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();
                
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
                $this->pdf->Cell(20, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(150,20,20));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L','R'));

                if($cups)
                {
                    foreach ($cups as $row) 
                    {   
                        $cod_cups            =   utf8_decode($row['cod_cups'].'-'.$row['nombre_cups']);
                        $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                        $cantidad            =   utf8_decode($row['cantidad']);
                        
                        
                        $this->pdf->Row(array($cod_cups, $nombre_lateralidad, $cantidad));
                    }
                }    
            }

            // observaciones cups
            if($exa['observacionescups'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['observacionescups']),0,'J');
                $this->pdf->Ln();
            }

            // medicamentos
            if($medicamentos)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('MEDICAMENTOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
                $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
                $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
                $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
                $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(68,38,38,15,30));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L','L','L','L'));

                if($medicamentos)
                {
                    foreach ($medicamentos as $med) 
                    {   
                        $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                        $concentracion              =   utf8_decode($med['concentracion']);
                        $prescripcion               =   utf8_decode($med['prescripcion']);
                        $cantidad                   =   utf8_decode($med['cantidad']);
                        $tiempo                     =   utf8_decode($med['tiempo']);
                        
                        $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                    }
                }    
            }

            // incapacidades
            if($incapacidades)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('INCAPACIDAD'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',7);
                $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',7);
                $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
            }

            // plan de tratamiento
            if($exa['planotratamiento'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Recomendaciones:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['planotratamiento']),0,'J');
                $this->pdf->Ln();   
            }


            $this->pdf->Ln();  

            // FIRMAS X EVOLUCION
            if($c_firma_medico)
            {
                $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25,'png');
            }else
            {
            }

            if($exa['firmapaci'])
            {
                
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
                $this->pdf->Image('data://image/png;base64,'.$exa['firmapaci'],110, $this->pdf->GetY(), 50, 25, 'png');
            }
            else
            {
            }

            $this->pdf->ln(20);

            // NOMBRES PACIENTE Y MEDICO EN FIRMAS
            $this->pdf->SetX(25);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

            $this->pdf->SetX(110);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
            
            
        }

        $this->pdf->Ln();
        $this->pdf->Output("Reporte historia .pdf", 'I');
    }

    // retinologia reporte medicamentos
    public function rep_medicamentos_opret()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_retinologia   =   $this->input->post('num_retinologia');

        $examen             =   $this->examen_model->ciexamen_opret($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);

        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);
        
        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }
        }

        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           =   $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
            $obs_medicamentos_ret           =   $exa->obs_medicamentos_ret;
            $firmapaci                      =   $exa->firmapaci;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }            
        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        
        
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(0,4,utf8_decode('FORMULACIÓN DE MEDICAMENTOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }

        if($medicamentos)
        {
            //$this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Medicamentos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(26, 5, utf8_decode('Código'), 1, 0, 'C', 0);
            $this->pdf->Cell(64, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
            $this->pdf->Cell(22, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(26,64,22,38,15,30));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('C','L','L','L','L','L'));

            if($medicamentos)
            {
                foreach ($medicamentos as $med) 
                {   
                    $cod_medicamento            =   utf8_decode($med['cod_medicamento']);
                    $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                    $concentracion              =   utf8_decode($med['concentracion']);
                    $prescripcion               =   utf8_decode($med['prescripcion']);
                    $cantidad                   =   utf8_decode($med['cantidad']);
                    $tiempo                     =   utf8_decode($med['tiempo']);
                    
                    $this->pdf->Row(array($cod_medicamento, $nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                }
            }    
        }

        if($obs_medicamentos_ret)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Observaciones:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            //$this->pdf->Cell(35,4,utf8_decode($obs_medicamentos_ret),0,0,'L');
            $this->pdf->MultiCell(0,4,utf8_decode($obs_medicamentos_ret),0,'J');
        }

        $this->pdf->Ln(5);
        $this->pdf->SetX(10);

        // FIRMAS
        if($c_firma_medico)
        {
            $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmapaci =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            //$this->pdf->Ln(5);
            $this->pdf->Image('data://image/png;base64,'.$firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }
        
        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);


        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte medicamentos .pdf", 'I');

    }

    // retinologia reporte ordenes medicas
    public function rep_ordenes_medicas_opret()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_retinologia    =   $this->input->post('num_retinologia');
        $examen             =   $this->examen_model->ciexamen_opret($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);
        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }
        
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;

            $tipo                           =   $exa->nombre_listap;
            $tipoconsulta                   =   $exa->nombre_cons;
            $firmapaci                      =   $exa->firmapaci;
            $firmamedi                      =   $exa->firmamedi;

            $observacionescups              =   $exa->observacionescups;
            $nombre_admi                    =   $exa->nombre_admi;
            $nombre_listap                  =   $exa->nombre_listap;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);

        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        //for($num_linea=1;$num_linea<=185;$num_linea++)
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('ORDEN MÉDICA'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                    if($ci['observacionescier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                    if($ci['observacionesciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                    if($ci['observacionescierr'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                    }
                }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }
        $this->pdf->Ln();

        // CUPS
        if($cups)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15, 5, utf8_decode('CUPS'), 1, 0, 'C', 0);
            $this->pdf->Cell(140, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(15,140,20,15));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','L','R'));

            if($cups)
            {
                foreach ($cups as $row) 
                {   
                    $cod_cups            =   utf8_decode($row['cod_cups']);
                    $descripcion         =   utf8_decode($row['nombre_cups']);
                    $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                    $cantidad            =   utf8_decode($row['cantidad']);
                    
                    $this->pdf->Row(array($cod_cups, $descripcion, $nombre_lateralidad, $cantidad));
                }
            }    
        }

        if($observacionescups)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($observacionescups),0,'J');
            //$this->pdf->Ln(3);
        }
        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($firmapaci)
        {
          $this->pdf->Image('data://image/png;base64,'.$firmapaci,30, $this->pdf->GetY(), 50, 25, 'png');
            
        }
        if($c_firma_medico)
        {
            $this->pdf->SetX(80);
            $this->pdf->Image(base_url().$c_firma_medico,110, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte Orden Medica .pdf", 'I');
    }

    // retinologia reporte prequirurgicos
    public function rep_prequirurgico_opret()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_retinologia    =   $this->input->post('num_retinologia');

        $examen             =   $this->examen_model->ciexamen_opret($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('PREQUIRURGICOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();         
        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }
        // paraclinicos
        if($paraclinicos)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(25, 5, utf8_decode('Código'), 1, 0, 'C', 0);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(25,150));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('C','L'));

            if($paraclinicos)
            {
                foreach ($paraclinicos as $para) 
                {   
                    $codigo_para            =   utf8_decode($para['detalle']);
                    $nombre_para            =   utf8_decode($para['nombre_para']);
                    
                    $this->pdf->Row(array($codigo_para, $nombre_para));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($c_firma_medico)
            {
                $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
            }else
            {
            }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }
        
        $this->pdf->ln(20);
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte prequirurgico.pdf", 'I');
    }

    // retinologia reporte de incapacidades
    public function rep_incapacidades_opret()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_retinologia    =   $this->input->post('num_retinologia');

        $examen             =   $this->examen_model->ciexamen_opret($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            
            $nombre_admi                    =   $exa->nombre_admi;
            

            $incapacidades                  =   $exa->incapacidades;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Dirección:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('Calle 46 No. 13 - 13'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Teléfonos:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('245 54 28 / 245 66 23 / 232 78 87'),0,0,'L');

        $this->pdf->Ln();
        $this->pdf->SetX(130);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(28,4,utf8_decode('icop.palermo@gmail.com'),0,0,'L');

        $this->pdf->Ln(8);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('INCAPACIDAD'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // incapacidades
        if($incapacidades)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        
        
        if($c_firma_medico)
        {
            $this->pdf->Image(base_url().$c_firma_medico,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte incapacidad.pdf", 'I');
    }
    
    // optometria
    // cerrar historia clinica
    public function cerrar_examen_op() 
    {
        $this->load->model('examen_model');
        $n_conexamen            =   $this->input->post('optometria_abierta', true);
        $id_paciente            =   $this->input->post('id_paciente', true);

        $m_cerrar_opt           =   array(
            'abierta'           =>  'NO');

        $cerrar_optometria      =   $this->examen_model->cerrar_optometria($m_cerrar_opt, $n_conexamen);

        // CONSULTA DE PACIENTE NUEVO
        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['id_paciente']           =   $id_paciente;
        //$datos['identificacion']        =   $identificacion;
        //$datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        //$datos['n_conparaclinico']      =   $n_conparaclinico;

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    // retinologia
    // cerrar historia clinica
    public function cerrar_examen_opret() 
    {
        $this->load->model('examen_model');
        $n_conexamen            =   $this->input->post('retinologia_abierta', true);
        $id_paciente            =   $this->input->post('id_paciente', true);

        $m_cerrar_optret           =   array(
            'abierta'           =>  'NO');

        $cerrar_optometria      =   $this->examen_model->cerrar_retinologia($m_cerrar_optret, $n_conexamen);

        // CONSULTA DE PACIENTE NUEVO
        $datos['examen_optret']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
        $datos['id_paciente']           =   $id_paciente;
        $datos['n_conexamen']           =   $n_conexamen;
        $f_med          =   $this->input->post('medico_opret', true);
        $datos['firma_medico_img']     =   $this->examen_model->firma_medi_exa($f_med);
        $examen_oft                     =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        if($examen_oft)
        {
            foreach($examen_oft as $fmedi)
            {
                $f_med                          =   $fmedi->cod_medi;
                $firma_medico_img               =   $this->examen_model->firma_medi_exa($f_med);
                if($firma_medico_img)
                {
                    foreach($firma_medico_img as $fmedi)
                    {
                        $datos['f_medico']  =   $fmedi['firmamedi'];
                    }
                }else
                {
                    $datos['f_medico']  =   '';
                }
            }
        }
        
        $this->load->view('front_end/historias/hexamen_opt_ret_v', $datos);
    }

    /// retinologia historico
    public function consulta_hist_ret()
    {
        $this->load->model('examen_model');
        $id_paciente        =   $this->input->post('bd_id_paciente_ret', true);
        $n_conexamen        =   $this->input->post('bd_cons_examen_ret', true);
        $datos['examen_optret']         =   $this->examen_model->ciexamen_optret($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
        $datos['num_retinologia']       =  $this->input->post('num_retinologia', true);
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   '';
        $datos['tipo_identificacion']   =   '';
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen;  
        $this->load->view('front_end/historias/hexamen_opt_ret_v', $datos);
    }

    // clon de examen
    public function clon_exa()
    {
        $this->load->model('examen_model');
        $this->load->model('historia_model');

        $c_num_oftalmologia             =   $this->input->post('c_num_oftalmologia', true);
        $id_paciente                    =   $this->input->post('clon_exa_id_paciente', true);
        // consulta el n_conexamen de la tabla pacientes_exa
        $clon_paciente_exa              =   $this->examen_model->clon_paciente_exa($id_paciente, $c_num_oftalmologia);
        foreach($clon_paciente_exa as $cpe)
        {
            $n_conexamen                    =   $cpe['cons_examen'];
        }

        

        $datos['sexo']                  =   $this->input->post('clon_exa_sexo', true);
        $datos['nconsulta']             =   $this->input->post('clon_exa_nconsulta', true);
        $datos['fecha_de_nacimiento']   =   $this->input->post('clon_exa_fechanacimiento', true);
        $datos['cod_persona_atie']      =   $this->input->post('clon_exa_cod_persona_atie', true);
        $datos['id_paciente']           =   $this->input->post('clon_exa_id_paciente', true);
        $datos['tipodocu']              =   $this->input->post('clon_exa_tipo_docu', true);
        $datos['identificacion']        =   $this->input->post('clon_exa_identificacion', true);
        $datos['version']               =   $this->input->post('clon_exa_version', true);
        $datos['histlogin']             =   $this->input->post('clon_exa_login', true);
        $datos['id_agenda']             =   $this->input->post('clon_exa_id_agenda', true);


        
        // consulta del examen de todos los datos por medio de cons_examen
        $datos['cons_abierta']           =   $this->examen_model->cons_abierta($id_paciente, $n_conexamen);

        // datos de historia abierta cie, cups , medicamentos
        $abierta    =   $this->examen_model->cons_abierta($id_paciente, $n_conexamen);
        if($abierta)
        {
            foreach($abierta as $abi)
            {
                $datos['historia_abierta']      =   $abi['cons_examen'];
                
                $n_conexamen                    =   $abi['cons_examen'];
                $datos['c_cie']                 =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
                $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
                $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
                $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
                $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
            }
        }

        // datos desde el modelo de historias clinicas
        $id_usuario                     =   $this->input->post('clon_exa_id_usuario', true);
        $login                          =   $this->input->post('clon_exa_login', true);
        $cod_persona_atie               =   $this->input->post('clon_exa_cod_persona_atie', true);
        $cod_medi                       =   $this->input->post('clon_exa_bd_cod_medi', true);

        $datos['codmedico']             =   $this->input->post('clon_exa_codmedico', true);
        $datos['consmedico']            =   $this->historia_model->consmedico($cod_persona_atie, $id_usuario, $login);
        $datos['especialidad_bd']       =   $this->historia_model->especialidad_bd();
        $datos['id_convenio']           =   $this->input->post('clon_exa_convenios', true);
        $datos['nom_convenio']          =   $this->input->post('clon_exa_convenios_texto', true);
        $datos['codconsulta']           =   $this->historia_model->codigoconsulta_gen($cod_medi);
        $datos['finalidad_gen']         =   $this->historia_model->finalidad_gen();
        $datos['ambito_gen']            =   $this->historia_model->ambito_gen();
        $datos['actoq_gen']             =   $this->historia_model->actoq_gen();
        $datos['lateralidad']           =   $this->historia_model->lateralidad();


        //var_dump($this->input->post('clon_exa_convenios', true));
        $this->load->view('front_end/historias/hexamen_clon_exa_v', $datos);
    } 

      // clon de retinologia
    public function clon_ret()
    {
        $this->load->model('examen_model');
        $this->load->model('historia_model');

        $c_num_retinologia              =   $this->input->post('c_num_retinologia', true);
        $id_paciente                    =   $this->input->post('clon_ret_id_paciente', true);
        $clon_paciente_ret              =   $this->examen_model->clon_paciente_ret($id_paciente, $c_num_retinologia);
        foreach($clon_paciente_ret as $cpr)
        {
            $n_conexamen                    =   $cpr['cons_examen'];
        }
        
        $datos['sexo']                  =   $this->input->post('clon_ret_sexo', true);
        $datos['nconsulta']             =   $this->input->post('clon_ret_nconsulta', true);
        $datos['fecha_de_nacimiento']   =   $this->input->post('clon_ret_fechanacimiento', true);
        $datos['cod_persona_atie']      =   $this->input->post('clon_ret_cod_persona_atie', true);
        $datos['id_paciente']           =   $this->input->post('clon_ret_id_paciente', true);
        $datos['tipodocu']              =   $this->input->post('clon_ret_tipo_docu', true);
        $datos['identificacion']        =   $this->input->post('clon_ret_identificacion', true);
        $datos['version']               =   $this->input->post('clon_ret_version', true);
        $datos['histlogin']             =   $this->input->post('clon_ret_login', true);
        $datos['id_agenda']             =   $this->input->post('clon_ret_id_agenda', true);


        
        // consulta del examen de todos los datos por medio de cons_examen
        $datos['cons_abierta_optret']   =   $this->examen_model->cons_abierta_retinologia($id_paciente, $n_conexamen);
        $abierta_ret                    =   $this->examen_model->cons_abierta_retinologia($id_paciente, $n_conexamen);
        if($abierta_ret)
        {
            foreach($abierta_ret as $abi_opt)
            {
                $datos['historia_abierta_ret']      =   $abi_opt['cons_examen'];
                
                $n_conexamen                        =   $abi_opt['cons_examen'];
                $datos['c_cie_optret']                 =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
                $datos['ciemas_optret']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
                $datos['cups_optret']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
                $datos['medicamentos_optret']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
                $datos['paraclinicos_optret']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
            }
        }

        // datos desde el modelo de historias clinicas
        $id_usuario                     =   $this->input->post('clon_ret_id_usuario', true);
        $login                          =   $this->input->post('clon_ret_login', true);
        $cod_persona_atie               =   $this->input->post('clon_ret_cod_persona_atie', true);
        $cod_medi                       =   $this->input->post('clon_ret_bd_cod_medi', true);

        $datos['codmedico']             =   $this->input->post('clon_ret_codmedico', true);
        $datos['consmedico']            =   $this->historia_model->consmedico($cod_persona_atie, $id_usuario, $login);
        $datos['especialidad_bd']       =   $this->historia_model->especialidad_bd();
        $datos['id_convenio']           =   $this->input->post('clon_ret_convenios', true);
        $datos['nom_convenio']          =   $this->input->post('clon_ret_convenios_texto', true);
        $datos['codconsulta']           =   $this->historia_model->codigoconsulta_gen($cod_medi);
        $datos['finalidad_gen']         =   $this->historia_model->finalidad_gen();
        $datos['ambito_gen']            =   $this->historia_model->ambito_gen();
        $datos['actoq_gen']             =   $this->historia_model->actoq_gen();
        $datos['lateralidad']           =   $this->historia_model->lateralidad();


        //var_dump($this->input->post('clon_exa_convenios', true));
        $this->load->view('front_end/historias/hexamen_clon_ret_v', $datos);
    } 

    // consulta la firma
    public function carga_firma_oftalmologia()
    {
        $this->load->model('examen_model', 'em');
        $cod_medi   =   $this->input->post('codmedico', true);
        $c_firma    =   $this->em->c_firma($cod_medi);
        foreach($c_firma as $cf)
        {
            echo base_url().$cf['firmamedi'];
        }
    }

}