<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Hmconsulta extends CI_Controller {
         
    public function __construct()
    {
        parent::__construct();
        $this->load->library('Session');
        //$this->session_id               = $this->session->userdata('login');    
//        $this->session_nombre           = $this->session->userdata('nombre'); 
//        $this->session_nivel_usuario    = $this->session->userdata('nivel_usuario');
//        $this->session_idusuario        = $this->session->userdata('id');
//        $this->session_gempnumero       = $this->session->userdata('gempnumero');
//        $this->session_gempnombre       = $this->session->userdata('gempnombre'); 
//        $this->session_gempanoc         = $this->session->userdata('gempanoc');  
        $this->load->library('consecutivo');
        $this->load->library('Datatables');
    }
   
    public function index()
    {                  
        $this->load->view('front_end/historias/hcpconsultacon_v', 301);
        
    }
    
    public function consecutivo()
    {
        $consecutivo = intval($this->input->post('consecutivo', true));        
        $consultarconsecutivo = $this->consecutivo->consultamedicaingcon($consecutivo);
    }
    
    public function consultamodificar()
    {
        $this->load->model('historia_model');
        $id_paciente                        =   $this->input->post('id_paciente', true);
        $sigla_sexo                         =   $this->input->post('sigla_sexo', true);
        $limiteedad                         =   $this->input->post('limiteedad', true);
        
        $datos['cod_persona_atie']          =   $this->input->post('cod_persona_atie', true);
        $datos['id_usuario']                =   $this->input->post('id_usuario', true);     
        //$datos['consultageneralhm']         =   $this->hmedica_model->consultageneralhm($id_paciente);  
        $datos['tipoempresaspromotoras']    =   $this->historia_model->tipoempresaspromotoras(); 
        $datos['cie10_linea']               =   $this->historia_model->cie10_linea($sigla_sexo,$limiteedad);
        $datos['id_paciente']               =   $id_paciente;         
        $datos['convencion']                =   $this->odontograma_model->convencion();
        $this->load->view('front_end/historias/hcpconsultamod_v_r',$datos);
    }
    
    public function consultageneralhm()
    {
        $this->db->trans_start();
        $identificacion             =   $this->input->post('identificacion', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $cod_medi                   =   $this->input->post('cod_medi', true);    
        $this->datatables->select("c.nconsulta, c.fechaactual, ci.nombre_cie, c.valor_cie, c.valor_cups, c.valor_cuota, c.valor_total")
        ->where('c.identificacion', $identificacion)
        ->where('c.tipo_docu', $tipo_docu)
        ->where('c.cod_medi', $cod_medi)
        ->join('cie10 ci', 'ci.id_cie = c.id_cie')        
        ->from('consulta_medica c');
        
        $this->db->trans_complete();
        echo $this->datatables->generate();
    }
    
    public function conmodificar()
    {
        $this->load->model('historia_model');
        // VARIABLES DE POST
        $nconsulta          =   trim($this->input->post('nconsulta', true));   
        $persona            =   trim($this->input->post('cod_persona_atie', true));
        $id_usuario         =   trim($this->input->post('id_usuario', true));
        
        // CREACION DE LA MATRIZ CONSULTA
        $datos  =   array();
        $cnconsulta     =   $this->historia_model->cmedica($nconsulta);
        foreach($cnconsulta as $cn)
        {
            $datos['id_cons_medica']    =   $cn['id_cons_medica'];
            $datos['nconsulta']         =   $cn['nconsulta'];
            $datos['id_paciente']       =   $cn['id_paciente'];
            $datos['identificacion']    =   $cn['identificacion'];            
            $datos['sist']              =   $cn['sist'];
            $datos['diast']             =   $cn['diast'];
            $datos['ppm']               =   $cn['ppm'];
            $datos['rpm']               =   $cn['rpm'];
            $datos['grados']            =   $cn['grados'];
            $datos['altura']            =   $cn['altura'];
            $datos['peso']              =   $cn['peso'];
            $datos['imc']               =   $cn['imc'];
            $datos['autorizacion']      =   $cn['autorizacion'];            
            $datos['observacionescie']  =   $cn['observacionescie'];
            $datos['valor_cie']         =   $cn['valor_cie'];
            $datos['valor_cuota']       =   $cn['valor_cuota'];
            $datos['valor_subtotal']    =   $cn['valor_subtotal'];
            $datos['observacionescups'] =   $cn['observacionescups'];
            $datos['valor_cups']        =   $cn['valor_cups'];
            $datos['valor_total']       =   $cn['valor_total'];            
            $datos['id_cie']            =   $cn['id_cie'];
            $datos['id_cie1']           =   $cn['id_cie1'];
            $datos['id_cie2']           =   $cn['id_cie2'];
            $datos['cod_cie']           =   $cn['cod_cie'];
            $datos['cod_cie1']          =   $cn['cod_cie1'];
            $datos['cod_cie2']          =   $cn['cod_cie2'];
            $datos['cod_cielinea1']     =   $cn['cod_cielinea1'];
            $datos['cod_cielinea2']     =   $cn['cod_cielinea2'];
            $datos['cod_ciesublinea1']  =   $cn['cod_ciesublinea1'];
            $datos['cod_ciesublinea2']  =   $cn['cod_ciesublinea2'];
            $datos['cod_cielinea']      =   $cn['cod_cielinea'];
            $datos['cod_ciesublinea']   =   $cn['cod_ciesublinea'];
            $datos['rciecodigo']        =   $cn['rciecodigo'];
            $datos['rciecodigo1']       =   $cn['rciecodigo1'];
            $datos['rciecodigo2']       =   $cn['rciecodigo2'];
            $datos['cotizacion']        =   $cn['cotizacion'];
            
            $idfinalidad            =   $cn['id_finalidad'];
            $datos['cfinalidad']    =   $this->historia_model->cfinalidad($idfinalidad);
            
            $codcausadia            =   $cn['cod_causa_dia'];
            $datos['ccausa']        =   $this->historia_model->ccausa($codcausadia);
            
            $codtipo                =   $cn['cod_tipo'];
            $datos['ctipo']         =   $this->historia_model->ctipo($codtipo);
            
            $codmedi                =   $cn['cod_medi'];
            $datos['cmedico']       =   $this->historia_model->cmedico($persona, $id_usuario, $codmedi);
            
            $idadmi                 =   $cn['id_admi'];
            $cidadmi                =   $this->historia_model->cidadmi($idadmi);
            foreach($cidadmi as $cid)
            {
                $datos['id_admi']           =   $cid['id_admi'];
                $datos['id_administradora'] =   $cid['id_administradora'];
                $datos['nombre_admi']       =   $cid['nombre_admi']; 
           }
           $codcons                 =   $cn['cod_cons'];
           $datos['ccod_cons']      =   $this->historia_model->ccod_cons($codcons, $codmedi);
           $codconsultav            =   $this->historia_model->ccodconsultav($codcons, $codmedi);
           foreach($codconsultav as $codcon)   
           {
                $datos['ccodconsultav'] =   $codcon['cod_cons'];
           }
            
        }
        // CONSULTA DEL MEDICO.
        
           
        $datos['cdconsulta']    =   $this->historia_model->cmtratamiento($nconsulta);
        
        echo json_encode($datos);        
    }
    
    public function medicosel()
    {
        $this->load->model('historia_model');
        $id_usuario     =   $this->input->post('id_usuario', true);
        $persona        =   $this->input->post('cod_persona_atie', true);
        $login          =   $this->input->post('login', true); 
        $datos          =   $this->historia_model->medicosel($persona, $id_usuario, $login);
    }
    
    public function medicoselsub()
    {
        $this->load->model('historia_model');
        $id_usuario     =   $this->input->post('id_usuario', true);
        $persona        =   $this->input->post('cod_persona_atie', true);
        $login          =   $this->input->post('login', true); 
        $codmedico      =   $this->input->post('codmedico', true);
        $datos          =   $this->historia_model->medicoselsub($persona, $id_usuario, $login, $codmedico);
    }
    
    public function imc()
    {
        $this->load->model('historia_model');
        $imc        =   $this->input->post('vimc', true);
        $resultado  =   $this->historia_model->imc($imc);
    }
    
    public function contexturacorporal()
    {
        $this->load->model('historia_model');
        $contextura =   $this->input->post('contextura', true);
        $sexo       =   $this->input->post('sexo', true);
        $resultadoc =   $this->historia_model->contexturac($contextura, $sexo);
    }
    
    public function porcentajegrasa()
    {
        $this->load->model('historia_model');
        $sexo       =   $this->input->post('sexo', true);
        $diametromu =   $this->input->post('diametromu', true);
        $caderas    =   $this->input->post('caderas', true);
        $adbomen    =   $this->input->post('adbomen', true);
        $altura     =   $this->input->post('altura', true);
        $peso       =   $this->input->post('peso', true);
        $resultadocp=   $this->historia_model->porcentajegrasa($sexo, $diametromu, $caderas, $adbomen, $altura, $peso);
        
    }
    
    public function resumenevolucion()
    {
        $this->load->model('historia_model');
        $tipodocu                       =   trim($this->input->post('tipodocu', true));
        $identificacion                 =   trim($this->input->post('identificacion', true));
        
        $this->datatables->select("nevolucion, fechaingreso, horaingreso, plandetratamiento")
        ->where('tipo_docu', $tipodocu)
        ->where('identificacion', $identificacion)
        ->from('consulta_medica_evolucion');
        
        echo $this->datatables->generate(); 
    }
    
    public function ingresoevolucion()
    {
        $this->load->model('historia_model');
        $data               =   $this->historia_model->ingresoevolucion();        
        $tipo_docu          =   $data['tipo_docu'];
        $identificacion     =   $data['identificacion'];
        $nevolucion         =   $data['nevolucion'];
        
        // CONSULTA EVOLCION CREADA
        $datos['evolucionelaborada']    =   $this->historia_model->evolucionelaborada($tipo_docu, $identificacion, $nevolucion);   
        $datos['rtipodocu']             =   $tipo_docu;
        $datos['ridentificacion']       =   $identificacion;
        $this->load->view('front_end/historias/hcpconsultas_medicas_r_v', $datos);
    }
    
    public function cotizacioning()
    {
        $this->load->model('historia_model');
        $data               =   $this->historia_model->cotizacioning();    
    }
    
    public function firmamedico()
    {
        $this->load->model('historia_model');
        $medico         =   $this->input->post('medico', true);
        $consultafm     =   $this->historia_model->consultafm($medico);
        if($consultafm)
        {
            foreach($consultafm as $cfm)
            {
                $firmam     =   $cfm['firmamedi'];
            }
        }else
        {
            $firmam     =   $cfm['firmamedi'];
        }
        echo $firmam;   
    }
    
    public function medicamentos()
    {
        $this->load->model('historia_model');        
        $this->load->view('front_end/historias/medicamentos_v',301);
    }
    
    public function mmedicamentos()
    {
        $abuscar    =   trim($this->input->post('abuscar'));
        
        $this->datatables->select("id_medicamento,cod_medicamento,nombre_medicamento,und_medicamento,concentracion")
        ->from('medicamentos');

        $this->db->like('nombre_medicamento', $abuscar);

        echo $this->datatables->generate();
    }
    
    public function tpresentacion()
    {
        $this->datatables->select("id_med_pres,und_medicamento")
        ->from('medicamentos_pres');
        
        echo $this->datatables->generate();
    }
    
    public function actualizarpresentacion()
    {
        $this->load->model('historia_model');
        $id_med_pres          =   trim($this->input->post('mmid_med_pres', true));
        $und_medicamento      =   trim($this->input->post('mmund_medicamento', true));
        
        $actualizarpresentacion =   $this->historia_model->actualizarpresentacion($id_med_pres,$und_medicamento);        
    }
    
    public function modificarmedicamento()
    {

        $this->load->model('historia_model');
        $id_medicamento         =   trim($this->input->post('nidmedicamento', true));
        $cod_medicamento        =   trim($this->input->post('mcodigo', true));
        $nombre_medicamento     =   trim($this->input->post('mdescripcion', true));
        $und_medicamento        =   trim($this->input->post('mpresentacion', true));
        $concentracion          =   trim($this->input->post('mconcentracion', true));
        $valor                  =   trim($this->input->post('mvalor', true));
         
        $modificarmedicamento    =   $this->historia_model->modificarmedicamento($id_medicamento, $cod_medicamento, $nombre_medicamento, $und_medicamento, $concentracion, $valor);
    }
    
    public function insertarpresentacion()
    {
        $this->load->model('historia_model');
        $und_medicamento        =   trim($this->input->post('und_medicamento', true));
        
        $insertarpresentacion    =   $this->historia_model->insertarpresentacion($und_medicamento);
    }
    
    public function insertamedicamento()
    {        
        $this->load->model('historia_model');
        $cod_medicamento        =   trim($this->input->post('ncodigo', true));
        $nombre_medicamento     =   trim($this->input->post('ndescripcion', true));
        $und_medicamento        =   trim($this->input->post('nuepresentacion', true));
        $nueconcentracion          =   trim($this->input->post('nueconcentracion', true));
        $valor                  =   trim($this->input->post('nvalor', true));


        $data = array(
            'cod_medicamento'       =>  $cod_medicamento,                                
            'nombre_medicamento'    =>  $nombre_medicamento,
            'und_medicamento'       =>  $und_medicamento,
            'concentracion'         =>  $nueconcentracion,
            'valor'                 =>  $valor
            );
        
        $insertarmedicamento    =   $this->historia_model->insertarmedicamento($data);
    }
    
    public function esterilizacion()
    {
        $this->load->view('front_end/historias/esterilizacion_v',301);
    }
    
    public function testerilizacion()
    {
        $this->db->trans_start();
        $this->datatables->select("id_esterilizacion, fecha_at, fecha_es, carga, paquetes, instrumental, rotacion, temperatura")
        ->from('p_esterilizacion');
        
        $this->db->trans_complete();
        echo $this->datatables->generate();       
    }
    
    public function tconesterilizacion()
    {
        $fechainicial    =   $this->input->post('fechainicial', true);
        $fechafinal      =   $this->input->post('fechafinal', true);
        
        $this->db->trans_start();
        $this->datatables->select("id_esterilizacion, fecha_at, fecha_es, carga, paquetes, instrumental, rotacion, temperatura")
        ->where('fecha_at >=', $fechainicial)
        ->where('fecha_at <=', $fechafinal)
        ->from('p_esterilizacion');
        
        $this->db->trans_complete();
        echo $this->datatables->generate();       
    }
    
     public function insertaresterilizacion()
    {
        $this->load->model('historia_model');
        
        $fecha_at           =   trim($this->input->post('fecha_at', true));
        $fecha_es           =   trim($this->input->post('fecha_es', true));
        $instrumental       =   trim($this->input->post('instrumental', true));
        $paquetes           =   trim($this->input->post('paquetes', true));
        $carga              =   trim($this->input->post('carga', true));
        $rotacion           =   trim($this->input->post('rotacion', true));
        $temperatura        =   trim($this->input->post('temperatura', true));
        $histlogin          =   trim($this->input->post('histlogin', true));
        $fechaactual        =   trim($this->input->post('fechaactual', true));
        
        $insertareste       =   $this->historia_model->insertareste($fecha_at,$fecha_es,$instrumental,$paquetes,$carga,$rotacion,$temperatura,$histlogin,$fechaactual);                
    }
    
    public function modificaresterilizacion()
    {
        $this->load->model('historia_model');
        
        $mid_esterilizacion =   trim($this->input->post('mid_esterilizacion', true));
        $fecha_es           =   trim($this->input->post('mfecha_es', true));
        $instrumental       =   trim($this->input->post('minstrumental', true));
        $paquetes           =   trim($this->input->post('mpaquetes', true));
        $carga              =   trim($this->input->post('mcarga', true));
        $rotacion           =   trim($this->input->post('mrotacion', true));
        $temperatura        =   trim($this->input->post('mtemperatura', true));
        $histlogin          =   trim($this->input->post('mhistlogin', true));
        $fechaactual        =   trim($this->input->post('mfechaactual', true));
        
        $insertareste       =   $this->historia_model->modificareste($mid_esterilizacion,$fecha_es,$instrumental,$paquetes,$carga,$rotacion,$temperatura,$histlogin,$fechaactual);        
    }
    
    public function repesterilizacion()
    {
        $this->load->model('historia_model');
        $this->load->library('pdfesterilizacion');
        // POST
        $fechainicial     =   trim($this->input->post('fechainicial', true));
        $fechafinal       =   trim($this->input->post('fechafinal', true));
                
        // BUSQUEDA POR FECHA_AT
        $bfecha_at        =   $this->historia_model->bfecha_at($fechainicial, $fechafinal);
        
        // PRESTADOR
        $prestador      =   $this->historia_model->consultaprestador();
        foreach($prestador as $pres)
        {
            $nombre         =   $pres['nombre'];
            $direccion      =   $pres['direccion'];
            $telefono       =   $pres['telefono1'];
            $celular        =   $pres['celular1'];
            $email          =   $pres['email'];
            $sitioweb       =   $pres['sitioweb'];
        }
        
        // GENERACION DEL REPORTE
        $this->pdf = new PDFESTERILIZACION();        
        
        $this->pdf->AliasNbPages();                
        $this->pdf->AddPage();
        
        $this->pdf->SetFillColor(200,200,200);
        $this->pdf->SetMargins(10, 15 , 15);
        $this->pdf->SetAutoPageBreak(true,175);  
        
        $this->pdf->SetFont('arial', '', 8);
        $this->pdf->SetTitle(utf8_decode('Reporte esterilizacion'), false);

        $this->pdf->cuerpo($bfecha_at);
        $this->pdf->Output("Reporte esterilizacion.pdf", 'I');
        $this->pdf->Close();       
    }
    
    public function arqueo()
    {
        $this->load->view('front_end/historias/arqueocaja_v', 301);       
    }
    
    public function tconarqueo()
    {
        $fechainicial               =   $this->input->post('fechainicial', true);
        $fechafinal                 =   $this->input->post('fechafinal', true);
        $efectivo          =   $this->historia_model->efectivo($fechainicial, $fechafinal);
        if($efectivo)
        {
            foreach($efectivo as $efec)
            {
                $datos['vefectivo']  =   $efec['valor_abono'];
                $vefectivo           =   $efec['valor_abono'];                        
            }
        }else
        {
            $datos['vefectivo']      =   '0';
            $vefectivo               =   '0';
        }        
        $cheque             =   $this->historia_model->cheque($fechainicial, $fechafinal);
        if($cheque)
        {
            foreach($cheque as $che)
            {
                $datos['vcheque']    =   $che['valor_abono'];
                $vcheque             =   $che['valor_abono'];
            }
        }else
        {
            $datos['vcheque']        =   '0';
            $vcheque                 =   $che['valor_abono'];
        }
        $tarjetadebito      =   $this->historia_model->tarjetadebito($fechainicial, $fechafinal);
        if($tarjetadebito)
        {
            foreach($tarjetadebito as $tabd)
            {
                $datos['vtabd']      =   $tabd['valor_abono'];
                $vtarjetadebito      =   $tabd['valor_abono'];
            }
        }else
        {
            $datos['vtabd']          =   '0';
            $vtarjetadebito          =   '0';
        }
        $tarjetacredito     =   $this->historia_model->tarjetacredito($fechainicial, $fechafinal);
        if($tarjetacredito)
        {
            foreach($tarjetacredito as $tacd)
            {
                $datos['vtacd']      =   $tacd['valor_abono'];
                $vtarjetacredito     =   $tacd['valor_abono'];
            }
        }else
        {
            $datos['vtacd']          =   '0';
            $vtarjetacredito         =   '0';
        }        
        $consignacion       =   $this->historia_model->consignacion($fechainicial, $fechafinal);
        if($consignacion)
        {
            foreach($consignacion as $cons)
            {
                $datos['vcons']      =   $cons['valor_abono'];
                $vconsignacion       =   $cons['valor_abono'];
            }
        }else
        {
            $datos['vcons']          =   '0';
            $vconsignacion           =   '0';
        }
        
        $datos['vtotal']        =   $vefectivo + $vcheque + $vtarjetadebito + $vtarjetacredito + $vconsignacion;
        $this->load->view('front_end/historias/arqueocaja_t_v', $datos);             
    }
    
    public function repconsentimiento()
    {
        $this->load->model('historia_model');
        $this->load->library('pdfconsentimiento');
        // POST
        $id_con_asig    =   trim($this->input->post('id_con_asig', true));
        
        $nconsent       =   $this->historia_model->repconsentimiento($id_con_asig);
        // PRESTADOR
        $prestador      =   $this->historia_model->consultaprestador();
        // CONSULTA BASE DE DATOS PACIENTE
        
        foreach($prestador as $pres)
        {
            $nombre         =   $pres['nombre'];
            $direccion      =   $pres['direccion'];
            $telefono       =   $pres['telefono1'];
            $celular        =   $pres['celular1'];
            $email          =   $pres['email'];
            $sitioweb       =   $pres['sitioweb'];
        }
        foreach($nconsent as $row)
        {
            $titulo             =   $row['titulo'];
            $parrafouno         =   $row['parrafouno'];            
            $descripcion        =   $row['descripcion'];
            $tipo_docu          =   $row['tipo_docu']; 
            $identificacion     =   $row['identificacion'];  
            $fechaactual        =   $row['fechaactual'];
            $horaactual         =   $row['horaactual'];
            $firmapaci          =   $row['firmapaci'];
            $firmamedi          =   $row['firmamedi'];
        }
        
        // GENERACION DEL REPORTE
        $this->pdf = new PDFCONSENTIMIENTO();
        
        
        
        
        date_default_timezone_set('America/Bogota');
        //$zonahoraria = date_default_timezone_get();
        //echo 'Zona horaria predeterminada: ' . $zonahoraria;
        $dias = array("Domingo","Lunes","Martes","Miércoles","Jueves","Viernes","Sábado");
        $meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
 
        $fechadia   = $dias[date('w',strtotime($fechaactual))]." ".date('d',strtotime($fechaactual))." de ".$meses[date('n',strtotime($fechaactual))-1]. " de ".date('Y',strtotime($fechaactual)) ; 
        
        $this->pdf->fechadia            =   $fechadia;
        $this->pdf->horaactual          =   $horaactual;
        $this->pdf->titulo              =   $titulo;
        $this->pdf->parrafouno          =   $parrafouno;
        $this->pdf->descripcion         =   $descripcion;
        
        $this->pdf->AliasNbPages();                
        $this->pdf->AddPage();
        
        $this->pdf->SetFillColor(200,200,200);
        $this->pdf->SetMargins(10, 15 , 15);
        $this->pdf->SetAutoPageBreak(true,15);  
        
        $this->pdf->SetFont('helvetica', '', 9);
        $this->pdf->SetTitle('Reporte consentimiento', false);

        
        $this->pdf->consentimiento($fechadia, $horaactual, $titulo, $parrafouno, $descripcion);
        
        $this->pdf->Ln(5);
        
        $this->pdf->Cell(25,5,'Firma paciente',0,0,'C');
        if($firmapaci)
        {
            $this->pdf->Image('data://image/png;base64,'.$firmapaci,15, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
            //$this->pdf->Ln(10);
//            $this->pdf->Cell(10,4, 'No se encuentra registrada firma');
        }
        $this->pdf->SetX(125);
        // FIRMA MEDICO
        $this->pdf->Cell(25,5,utf8_decode('Firma médico'),0,0,'C');
        if($firmamedi)
        {
            $this->pdf->Image('data://image/png;base64,'.$firmamedi,120, $this->pdf->GetY(), 50, 25, 'png');
        }
        
        $npaciente  =   '';
        
                       
        //$this->pdf->Close();
        //$this->pdf->Output("CT odontograma No. ".$num_odon.".pdf", 'D');
        $this->pdf->Output("consentimiento informado.pdf", 'I');
        
        
        
        //$filename="c://facturas/";
        //$this->pdf->Output("CT odontograma No. ".$num_odon.".pdf", 'D');
        $this->pdf->Close();
    }
    
    public function formulacion()
    {
        $this->load->view('front_end/historias/formulacion_v',301);       
    }
    
    public function cargaformulas()
    {
        $id_paciente          =   $this->input->post('id_paciente', true);
        
        $this->datatables->select("id_paciente,num_formula, fechaactual, horaactual, cod_medi")
        ->where('id_paciente', $id_paciente)
        ->from('medicamentos_form');
        
        echo $this->datatables->generate();    
    }
    
    
    
    public function resumenformula()
    {
        $this->load->model('historia_model');
        
        $tipo_docu      =   $this->input->post('tipo_docu', true);
        $identificacion =   $this->input->post('identificacion', true);
        $num_formula    =   $this->input->post('num_formula', true);
        $cod_medi       =   $this->input->post('cod_medi', true);
        
        // NUMERO DE FORMULA
        $datos['num_formula']   =   $num_formula;
        //  CODIGO DEL MEDICO
        $datos['cod_medi']      =   $cod_medi;
        // PACIENTE
        $paciente       =   $this->historia_model->conpaciente($tipo_docu, $identificacion);
        if($paciente)
        {
            foreach($paciente as $paci)
            {
                $datos['npaciente']  = $paci['primer_nombre'].' '.$paci['segundo_nombre'].' '.$paci['primer_apellido'].' '.$paci['segundo_apellido'];   
            }
        }else
        {
            $datos['npaciente']  =  '';
        }
        // ENCABEZADO
        $encabezado     =   $this->historia_model->conencaformula($num_formula, $tipo_docu, $identificacion);
        if($encabezado)
        {
            foreach($encabezado as $encf)
            {
                $datos['fechaactual']    =   $encf['fechaactual'];
                $datos['nmedico']        =   $encf['primer_nombre_medi'].' '.$encf['segundo_nombre_medi'].' '.$encf['primer_apellido_medi'].' '.$encf['segundo_apellido_medi'];
            }
        }else
        {
            $datos['fechaactual']    =   '';
            $datos['nmedico']        =   '';
        }
        // DETALLES
        $datos['detalles']       =   $this->historia_model->condetaformula($num_formula);
        $this->load->view('front_end/historias/formulacion_r_v',$datos);
    }
    
    public function repformula()
    {
        $this->load->model('historia_model');
        $fecha              =   trim($this->input->post('nfecha', true));
        $formula            =   trim($this->input->post('nformula', true));
        $npaciente          =   trim($this->input->post('npaciente', true));
        $cod_medi           =   trim($this->input->post('ncod_medi', true));   
        $id_paciente          =   trim($this->input->post('id_paciente', true));   

        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";
        // PACIENTE
        $paciente       =   $this->historia_model->consultapaciente($id_paciente);

        // DETALLES
        $detalles       =   $this->historia_model->condetaformula($formula);

        // MEDICO
        $medico         =   $this->historia_model->consultamedicof($cod_medi);

        foreach($paciente as $pac)
        {
            $nom_paciente   =   $pac['primer_nombre'].' '.$pac['segundo_nombre'].' '.$pac['primer_apellido'].' '.$pac['segundo_apellido'];
            $pacdireccion   =   $pac['direccion_paci'];
            $pactelefono    =   $pac['telefono_paciente'].' '.$pac['celular_paciente'];
            $pacemail       =   $pac['email_paciente'];
            $idhistoria     =   $pac['id_historia'];
        }

        if($medico)
        {
            foreach($medico as $medi)
            {
                $firmamedi     =   $medi['firmamedi'];
            }
        }else
        {
            $firmamedi =   '';
        }

        // PRESTADOR
        $prestador      =   $this->historia_model->consultaprestador();
        foreach($prestador as $pres)
        {
            $nombre         =   $pres['nombre'];
            $direccion      =   $pres['direccion'];
            $telefono       =   $pres['telefono1'];
            $celular        =   $pres['celular1'];
            $email          =   $pres['email'];
            $sitioweb       =   $pres['sitioweb'];
        }
        // GENERACION DEL REPORTE
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,5,5,0,25);
        
        $this->pdf->SetXY(110,5);
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,'Paciente:',0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->Cell(20,4,utf8_decode($nom_paciente),0,0,'L');
        
        $this->pdf->SetX(184);
        $this->pdf->Cell(10,4,utf8_decode('Historia:'),0,0,'L');
        $this->pdf->SetX(198);
        $this->pdf->Cell(10,4,$idhistoria,0,0,'L');
    
        $this->pdf->Ln(4);
            
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,utf8_decode('Dir.:'),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->Cell(20,4,utf8_decode($pacdireccion),0,0,'L');
        
        $this->pdf->Ln(4);
        
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,utf8_decode('Tel.:'),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->Cell(20,4,utf8_decode($pactelefono),0,0,'L');
        $this->pdf->SetX(175);

        $this->pdf->SetX(184);
        $this->pdf->Cell(10,4,$fecha,0,0,'L');
        
        $this->pdf->Ln(4);
        
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,utf8_decode('email:'),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->Cell(20,4,utf8_decode($pacemail),0,0,'L');
        $this->pdf->SetX(175);

        $this->pdf->SetX(184);
        $this->pdf->Cell(0,10,utf8_decode('Página ').$this->pdf->PageNo().'/{nb}',0,0,'C');
        $this->pdf->Ln(20);


        //$this->pdf->SetXY(110,30);
        $this->pdf->SetX(5);
        $this->pdf->Cell(35,4,utf8_decode('Medicamentos formulados'),0,0,'L');
        
        $this->pdf->Ln();
        
        $this->pdf->Ln(5);
        $this->pdf->Cell(80, 5, 'Medicamento', 1, 0, 'C', 0);
        $this->pdf->Cell(15, 5, 'Cant', 1, 0, 'C', 0);
        $this->pdf->Cell(75, 5, utf8_decode('Prescripción'), 1, 0, 'C', 0);
        $this->pdf->Cell(20, 5, utf8_decode('Valor'), 1, 0, 'C', 0);
        
        $this->pdf->Ln();
        
        // DETALLES
        $this->pdf->SetWidths(array(80,15,75,20));
        srand(microtime()*1000000);
        $this->pdf->SetAligns(array('J','R','J', 'R'));
        
        
        if($detalles)
        {
            foreach ($detalles as $row) 
            {   
                $medicamento    =   utf8_decode($row['medicamento']);
                $cantidad       =   number_format($row['cantidad']);                
                $prescripcion   =   utf8_decode($row['prescripcion']);
                $valor          =   number_format($row['valor']);
                
                
                $this->pdf->Row(array($medicamento,$cantidad,$prescripcion, $valor));
            }
        }    
        

        
           
        
        $this->pdf->Output("formulacion No ".$formula.".pdf", 'I');

    }
    
    public function remisiones()
    {
        $this->load->view('front_end/historias/remisiones_v',301);
    }
    
    public function tremisiones()
    {
        $tipo_docu          =   $this->input->post('tipo_docu', true);
        $identificacion     =   $this->input->post('identificacion', true);
        
        $this->datatables->select("tipo_docu, identificacion, fecha_re, observaciones, centromedico, num_remision, cod_medi, firmapaci, firmamedi")        
        ->where('tipo_docu', $tipo_docu)
        ->where('identificacion', $identificacion)
        ->from('p_remisiones');
        
        echo $this->datatables->generate();    
    }
    
    public function ingresoremision()
    {
        $this->load->model('historia_model');
        $ingresoremision        =   $this->historia_model->ingresoremision();
        
    }
    
    public function modificarremision()
    {
        $this->load->model('historia_model');
        $data           =   $this->historia_model->modificarremision();
        $num_remision   =   $data['num_remision'];
        
        // CONSULTANDO LA INFORMACION ALMACENADA
        $encabezado     =   $this->historia_model->ceremisiones($num_remision);
        foreach($encabezado as $enc)
        {
            $datos['fecha_re']       =   $enc['fecha_re'];
            $datos['observaciones']  =   $enc['observaciones'];
            $datos['centromedico']   =   $enc['centromedico'];
            $datos['num_remision']   =   $enc['num_remision'];
        } 
        
        
        $cfirmapac              =   $this->historia_model->cfirmapac($num_remision);
        
            foreach($cfirmapac as $fpac)
            {
                $datos['firmapaci']      =   $fpac['firmapaci'];
            }
                        
        $cfirmamed              =   $this->historia_model->cfirmamed($num_remision);
        if($cfirmamed)
        {
            foreach($cfirmamed as $fmed)
            {
                $datos['firmamedi']      =   $fmed['firmamedi'];
            }
        }else
        {
            $datos['firmamedi']      =   '';            
        } 
        
        $datos['num_remision']      =   $num_remision;
        $this->load->view('front_end/historias/remisiones_a_v',$datos);
    } 
    
    public function firmasmod()
    {
        $this->load->model('historia_model');
        $mnum_remision      =   $this->input->post('mnum_remision', true);
        $firmas             =   $this->historia_model->firmasmod($mnum_remision);        
    }
    
    public function repremision1()
    {
        echo 'vboy';
        exit();
    }
    
    public function repremision()
    {
        $this->load->model('historia_model');        
        $this->load->library('pdfremision');
        
        
        $num_odon       =   trim($this->input->post('numremision', true));
        
        // CONSULTA REMISION EN P_REMISION
        $cpremision     =   $this->historia_model->cpremision($num_odon);        
        foreach($cpremision as $prem)
        {   
            $tipo_docu          =   $prem['tipo_docu'];
            $identificacion     =   $prem['identificacion'];
            $rfecha             =   $prem['fecha_re'];
            $rcentromed         =   $prem['centromedico'];
            $obsremision        =   $prem['observaciones'];
        }
        
        // PRESTADOR
        $prestador      =   $this->historia_model->prestador();
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente       =   $this->historia_model->consultapaciente($identificacion, $tipo_docu);                
                
        // ODONTOGRAMA REMISIONES
        $rhora          =   '';
        
        
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac['primer_nombre'].' '.$pac['segundo_nombre'].' '.$pac['primer_apellido'].' '.$pac['segundo_apellido'];
            $pacdireccion   =   $pac['direccion_paci'];
            $pactelefono    =   $pac['telefono_paciente'];
            $paccelular     =   $pac['celular_paciente'];
            $pacemail       =   $pac['email_paciente'];
        }
        foreach($prestador as $pres)
        {
            $nombre         =   $pres['nombre'];
            $direccion      =   $pres['direccion'];
            $telefono       =   $pres['telefono1'];
            $celular        =   $pres['celular1'];
            $email          =   $pres['email'];
            $sitioweb       =   $pres['sitioweb'];
        }
        
        $cfirmapac              =   $this->historia_model->cfirmapac($num_odon);        
        foreach($cfirmapac as $fpac)
        {
            $firmapaci      =   $fpac['firmapaci'];
        }
                        
        $cfirmamed              =   $this->historia_model->cfirmamed($num_odon);
        if($cfirmamed)
        {
            foreach($cfirmamed as $fmed)
            {
                $firmamedi      =   $fmed['firmamedi'];
            }
        }else
        {
            $firmamedi      =   '';            
        } 
        
        // GENERACION DEL REPORTE
        $this->pdf = new PDFREMISION();
        $npaciente  =   $pacnombre;
        
        $this->pdf->SetY(105);
               
        $this->pdf->npaciente           =   $npaciente;
        $this->pdf->numero_docu         =   $num_odon;
        $this->pdf->cdireccion_paci     =   $pacdireccion;
        $this->pdf->ctelefonop          =   $pactelefono;
        $this->pdf->cfechaingreso       =   $rfecha;
        $this->pdf->cemail_paciente     =   $email;
        $this->pdf->choraingreso        =   '';
        $this->pdf->rcentromed          =   $rcentromed;        
        $this->pdf->cpremision          =   $cpremision;
        
        $this->pdf->AliasNbPages();                
        $this->pdf->AddPage();
        
        $this->pdf->SetFillColor(200,200,200);
        $this->pdf->SetMargins(10, 15 , 15);
        $this->pdf->SetAutoPageBreak(true,175);  
        
        $this->pdf->SetFont('helvetica', '', 9);
        $this->pdf->SetTitle('Reporte Remision', false);

        $this->pdf->datospaciente($npaciente, $num_odon, $pacdireccion, $pactelefono, $rfecha, $email, $rhora, $cpremision);


        //$this->pdf->Ln(30);
        //$this->pdf->Cell(10,4,utf8_decode('   '),0,0,'L');  
        //$this->pdf->Ln(10);
        $this->pdf->SetX(10);
        $this->pdf->Cell(10,4,utf8_decode('Observaciones:'),0,1,'L');
        $this->pdf->Ln(5);
        $this->pdf->SetX(10);
        $this->pdf->MultiCell(0, 4, utf8_decode($obsremision), 0, 'J', false);
        $this->pdf->Ln(5);
        
        // FIRMA PACIENTE
        if($firmapaci)
        {
            $this->pdf->Image('data://image/png;base64,'.$firmapaci,$this->pdf->GetX(), $this->pdf->GetY(), 50, 25, 'png');                    
            $this->pdf->Cell(25,5,'Firma paciente',0,0,'C');
        }
        // FIRMA MEDICO
        if($firmamedi)
        {
            $this->pdf->Image('data://image/png;base64,'.$firmamedi,$this->pdf->GetX(), $this->pdf->GetY(), 50, 25, 'png');    
            $this->pdf->Cell(25,5,utf8_decode('Firma médico'),0,0,'C');
        }
        
        
        $this->pdf->Close();
        $this->pdf->Output("Remision No. ".$num_odon.".pdf", 'I');
    }      
    
    public function tlistap()
    {
        $this->datatables->select("cod_listap, nombre_listap, valor")
        ->from('listaprecios');
        
        echo $this->datatables->generate();       
    }

    public function ingresomedicamento()
    {
        date_default_timezone_set('America/Bogota');

        $this->load->model('historia_model');
        $num_formula     = $this->historia_model->consultaconsecutivo(16);

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");
        $id_paciente    =   $this->input->post('id_paciente', true);
        $cod_medi       =   $this->input->post('medico', true);
        $login_ing      =   $this->input->post('login', true);

        // encabezado
        $m_enc_medicamentos = array(                    
            'num_formula'           =>  $num_formula,
            'id_paciente'           =>  $id_paciente,
            'cod_medi'              =>  $cod_medi,
            'fechaactual'           =>  $fechaactual,
            'horaactual'            =>  $horaactual,                            
            'login_ing'             =>  $login_ing
        );
        
        // INSERTAR DATOS ENCABEZADO  medicamento            
        $this->historia_model->ingresoencmed($m_enc_medicamentos, $num_formula);

        for ($i = 0; $i < count($this->input->post('id_medicamento')); $i++) 
        {
            // ingresar detalles
            $m_det_medicamentos = array(
            'num_formula'       =>  $num_formula,
            'id_paciente'       =>  $id_paciente,
            'id_medicamento'    =>  $this->input->post('id_medicamento', true)[$i], 
            'medicamento'       =>  $this->input->post('medicamento', true)[$i], 
            'cantidad'          =>  $this->input->post('cantidad', true)[$i],
            'prescripcion'      =>  $this->input->post('prescripcion', true)[$i],
            'valor'             =>  $this->input->post('valor', true)[$i],
            'fechaactual'       =>  $fechaactual,
            'horaactual'        =>  $horaactual,                            
            'login_ing'         =>  $login_ing                                               
            ); 

            // INSERTAR DATOS detalles medicamento            
            $this->historia_model->ingresodetmed($m_det_medicamentos);
        }

        // NUMERO DE FORMULA
        $datos['num_formula']   =   $num_formula;
        //  CODIGO DEL MEDICO
        $datos['cod_medi']      =   $cod_medi;
        // PACIENTE
        $paciente       =   $this->historia_model->conpaciente($id_paciente);
        if($paciente)
        {
            foreach($paciente as $paci)
            {
                $datos['npaciente']  = $paci['primer_nombre'].' '.$paci['segundo_nombre'].' '.$paci['primer_apellido'].' '.$paci['segundo_apellido'];   
            }
        }else
        {
            $datos['npaciente']  =  '';
        }
        // ENCABEZADO
        $encabezado     =   $this->historia_model->conencaformula($num_formula, $id_paciente);
        if($encabezado)
        {
            foreach($encabezado as $encf)
            {
                $datos['fechaactual']    =   $encf['fechaactual'];
                $datos['nmedico']        =   $encf['primer_nombre_medi'].' '.$encf['segundo_nombre_medi'].' '.$encf['primer_apellido_medi'].' '.$encf['segundo_apellido_medi'];
            }
        }else
        {
            $datos['fechaactual']    =   '';
            $datos['nmedico']        =   '';
        }
        $datos['id_paciente']   =   $id_paciente;
        $datos['fechaactual']   =   $fechaactual;
        // DETALLES
        $datos['detalles']       =   $this->historia_model->condetaformula($num_formula);
        $this->load->view('front_end/historias/formulacion_r_v',$datos);
    }


    /// PROCESO DE ESENCIAS
    public function esencias()
    {
        $this->load->model('historia_model');        
        $this->load->view('front_end/historias/esencia_v',301);
    }

    public function mmesencias()
    {
        $abuscar    =   trim($this->input->post('abuscar'));
        
        $this->datatables->select("id_esencia,nombre,sintomas,cualidades,usos, afirmacion, valor")
        ->from('esencias');

        $this->db->like('nombre', $abuscar);

        echo $this->datatables->generate();
    }

    public function insertaesencia()
    {        
        $this->load->model('historia_model');
           
        $nombre         =   trim($this->input->post('nnombre', true));
        $sintomas       =   trim($this->input->post('nsintomas', true));
        $cualidades     =   trim($this->input->post('ncualidades', true));
        $usos           =   trim($this->input->post('nusos', true));
        $afirmacion     =   trim($this->input->post('nafirmacion', true));
        $valor          =   trim($this->input->post('nvalor', true));
        
        $insertaresencia    =   $this->historia_model->insertaresencia($nombre, $sintomas, $cualidades, $usos, $afirmacion, $valor);

    }

    public function modificaresencia()
    {

        $this->load->model('historia_model');

        

        $id_esencia     =   trim($this->input->post('mid_esencia', true));
        $nombre         =   trim($this->input->post('mnombre', true));
        $sintomas       =   trim($this->input->post('msintomas', true));
        $cualidades     =   trim($this->input->post('mcualidades', true));
        $usos           =   trim($this->input->post('musos', true));
        $afirmacion     =   trim($this->input->post('mafirmacion', true));
        $valor          =   trim($this->input->post('mvalor', true));
         
        $modificarmedicamento    =   $this->historia_model->modificaresencia($id_esencia, $nombre, $sintomas, $cualidades, $usos, $afirmacion, $valor);
    }
    
}