<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Reportes extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		//$this->load->library('pdf');
        $this->load->library('pdf_report');
	}

    //  reporte general total
    public function rep_general_todo()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $datos['c_oftalmologia']    =   $this->rm->c_oftalmologia($id_paciente);
        $datos['c_optometria']      =   $this->rm->c_optometria($id_paciente);
        $datos['c_retinologia']     =   $this->rm->c_retinologia($id_paciente);
        $datos['cie']               =   $this->rm->ciexamencie($id_paciente);
        $datos['cups']              =   $this->rm->cicups($id_paciente);
        $datos['ciemas']            =   $this->rm->ciexamenciemas($id_paciente);
        $datos['paraclinicos']      =   $this->rm->paraclinicos($id_paciente);
        $datos['medicamentos']      =   $this->rm->cimedicamentos($id_paciente);
        $datos['si_obs_cups']       =   'NO';

        $datos['f_medico'] = $this->rm->c_f_medico();
        
        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $logo_eps = 'logoempresa_vision.png';
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Total:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/rep_general_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        //$pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' total.pdf', 'I');
    }  

    //  reporte general total
    public function rep_general_fecha()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente       =   $this->input->post('id_paciente');
        $c_oftalmologia    =   $this->rm->c_oftalmologia($id_paciente);
        $c_optometria      =   $this->rm->c_optometria($id_paciente);
        $c_retinologia     =   $this->rm->c_retinologia($id_paciente);

        $m_registros        =   array();
        if($c_oftalmologia)
        {
            foreach($c_oftalmologia as $exa)
            {
                $m_oft = array(
                    'oft_fecha'              =>   $exa->fechaactual,
                    'oft_cons_examen'        =>   $exa->cons_examen,
                    'tipo'                   =>   'Oftalmologia');
                array_push($m_registros, $m_oft);
            }
        }

        if($c_optometria)
        {
            foreach($c_optometria as $opt)
            {
                $m_opt = array(
                    'oft_fecha'              =>   $opt->fechaactual,
                    'oft_cons_examen'        =>   $opt->cons_examen,
                    'tipo'                   =>   'Optometria');
                array_push($m_registros, $m_opt);
            }
        }

        if($c_retinologia)
        {
            foreach($c_retinologia as $ret)
            {
                $m_ret = array(
                    'oft_fecha'              =>   $ret->fechaactual,
                    'oft_cons_examen'        =>   $ret->cons_examen,
                    'tipo'                   =>   'Retinologia');
                array_push($m_registros, $m_ret);
            }
        }
        sort($m_registros);
        $datos['m_registros'] =  $m_registros;

        //print_r($m_registros);
        //var_dump($m_registros);
        /*foreach($m_registros as $reg)
        {
           echo "Fecha: " . $reg['oft_fecha'] ." Cons_examen: " . $reg['oft_cons_examen'] . " tipo: ". $reg['tipo'] ." <br>";
        }
        exit();*/

        $datos['c_oftalmologia']    =   $this->rm->c_oftalmologia($id_paciente);
        $datos['c_optometria']      =   $this->rm->c_optometria($id_paciente);
        $datos['c_retinologia']     =   $this->rm->c_retinologia($id_paciente);
        $datos['cie']               =   $this->rm->ciexamencie($id_paciente);
        $datos['cups']              =   $this->rm->cicups($id_paciente);
        $datos['ciemas']            =   $this->rm->ciexamenciemas($id_paciente);
        $datos['paraclinicos']      =   $this->rm->paraclinicos($id_paciente);
        $datos['medicamentos']      =   $this->rm->cimedicamentos($id_paciente);
        $datos['si_obs_cups']       =   'NO';

        $datos['f_medico'] = $this->rm->c_f_medico();
        
        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $logo_eps = 'logoempresa_vision.png';
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Total:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/rep_fechas_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        //$pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' total.pdf', 'I');
    } 

    //  reporte optometria total
    public function rep_oft_parte()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $datos['c_oftalmologia']    =   $this->rm->c_oftalmologia($id_paciente);
        //$datos['c_optometria']      =   $this->rm->c_optometria($id_paciente);
        //$datos['c_retinologia']     =   $this->rm->c_retinologia($id_paciente);
        $datos['cie']               =   $this->rm->ciexamencie($id_paciente);
        //$datos['cups']              =   $this->rm->cicups($id_paciente);
        $datos['ciemas']            =   $this->rm->ciexamenciemas($id_paciente);
        $datos['paraclinicos']      =   $this->rm->paraclinicos($id_paciente);
        //$datos['medicamentos']      =   $this->rm->cimedicamentos($id_paciente);
        $datos['si_obs_cups']       =   'SI';

        $datos['f_medico'] = $this->rm->c_f_medico();
        
        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $logo_eps = 'logoempresa_vision.png';
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Oftalmologia:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/rep_general_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        //$pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' oftalmologia.pdf', 'I');
    }  

    //  reporte optometria total
    public function rep_opt_parte()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        //$datos['c_oftalmologia']    =   $this->rm->c_oftalmologia($id_paciente);
        $datos['c_optometria']      =   $this->rm->c_optometria($id_paciente);
        //$datos['c_retinologia']     =   $this->rm->c_retinologia($id_paciente);
        $datos['cie']               =   $this->rm->ciexamencie($id_paciente);
        //$datos['cups']              =   $this->rm->cicups($id_paciente);
        $datos['ciemas']            =   $this->rm->ciexamenciemas($id_paciente);
        $datos['paraclinicos']      =   $this->rm->paraclinicos($id_paciente);
        //$datos['medicamentos']      =   $this->rm->cimedicamentos($id_paciente);
        $datos['si_obs_cups']       =   'SI';

        $datos['f_medico'] = $this->rm->c_f_medico();
        
        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $logo_eps = 'logoempresa_vision.png';
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Optometria:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/rep_general_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        //$pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' optometria.pdf', 'I');
    }  

    //  reporte optometria total
    public function rep_ret_parte()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        //$datos['c_oftalmologia']    =   $this->rm->c_oftalmologia($id_paciente);
        //$datos['c_optometria']      =   $this->rm->c_optometria($id_paciente);
        $datos['c_retinologia']     =   $this->rm->c_retinologia($id_paciente);
        $datos['cie']               =   $this->rm->ciexamencie($id_paciente);
        //$datos['cups']              =   $this->rm->cicups($id_paciente);
        $datos['ciemas']            =   $this->rm->ciexamenciemas($id_paciente);
        $datos['paraclinicos']      =   $this->rm->paraclinicos($id_paciente);
        //$datos['medicamentos']      =   $this->rm->cimedicamentos($id_paciente);
        $datos['si_obs_cups']       =   'SI';

        $datos['f_medico'] = $this->rm->c_f_medico();
        
        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $logo_eps = 'logoempresa_vision.png';
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Retinologia:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/rep_general_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        //$pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' retinologia.pdf', 'I');
    }  
	

	public function rep_consentimiento()
	{
		//$this->load->library('mydompdf');
		//require_once APPPATH."/third_party/Html2Pdf-master/html2pdf.php";

		//Load the library
	    $this->load->library('html2pdf');
	    
	    //Set folder to save PDF to
	    $this->html2pdf->folder('./assets/pdfs/');
	    
	    //Set the filename to save/download as
	    $this->html2pdf->filename('test.pdf');
	    
	    //Set the paper defaults
	    $this->html2pdf->paper('a4', 'portrait');
	    
	    /*$data = array(
	    	'title' => 'PDF Created',
	    	'message' => 'Hello World!'
	    );
	    
	    //Load html view
	    $this->html2pdf->html($this->load->view('pdf', $data, true));
	    
	    if($this->html2pdf->create('save')) {
	    	//PDF was successfully saved or downloaded
	    	echo 'PDF saved';
	    }
	    ////*********************/////
		$this->load->model('reportes_model','rm');

		$cons_examen                =   $this->input->post('cons_examen', true);              
        $id_paciente                =   $this->input->post('id_paciente', true);


        // consulta en la base de datos
        $datos['examen'] 			=	$this->rm->consulta_consent($id_paciente, $cons_examen);

	    

	    $prestador					=	$this->rm->consulta_global();
        foreach($prestador as $pr)
        {
        	$datos['pres_nombre'] 		= 	$pr['nombre'];
        	$datos['pres_direccion'] 	= 	$pr['direccion'];
        	$datos['pres_telefono1'] 	= 	$pr['telefono1'];
        	$datos['pres_telefono2'] 	=	$pr['telefono2'];
        	$datos['pres_celular1']		=	$pr['celular1'];
        	$datos['pres_email'] 		= 	$pr['email'];
        	$datos['pres_sitioweb'] 	= 	$pr['sitioweb'];
        }

        //$html= $this->load->view('front_end/historias/hexamen_reporte_consent_v.php', $datos, true);

        $this->html2pdf->html($this->load->view('front_end/historias/hexamen_reporte_consent_v', $datos, true));

        $this->html2pdf->create('save');
	    /*$this->mydompdf->load_html($html);
	    //$this->mydompdf->set_paper("A5", "landscape");
	    $this->mydompdf->set_paper("letter", "portrait");
	    $this->mydompdf->render();
	    $this->mydompdf->canvas = $this->mydompdf->get_canvas();
	    $this->mydompdf->canvas->page_text(505, 65, "Pag. {PAGE_NUM} de {PAGE_COUNT}", $font, 8, array(0, 0, 0));
	    $this->mydompdf->set_base_path('assets/css/dompdf.css'); //agregar de nuevo el css
	    $this->mydompdf->stream("consentimiento.pdf", array("Attachment" => false));*/

	    /*$this->pdf=new createPDF();
		$this->pdf->AddPage();
		$this->pdf->SetFont('Arial');
		$this->pdf->WriteHTML('You can<br><p align="center">center a line</p>and add a horizontal rule:<br><hr>');
		$this->pdf->Output();*/
		
		
	}

	public function rep_consentimiento_pantalla()
	{
		$this->load->model('reportes_model','rm');
		$cons_examen                =   $this->input->post('cons_examen', true);              
        $id_paciente                =   $this->input->post('id_paciente', true);
        $datos['examen'] 			=	$this->rm->consulta_consent($id_paciente, $cons_examen);
        $prestador					=	$this->rm->consulta_global();
        foreach($prestador as $pr)
        {
        	$datos['pres_nombre'] 		= 	$pr['nombre'];
        	$datos['pres_direccion'] 	= 	$pr['direccion'];
        	$datos['pres_telefono1'] 	= 	$pr['telefono1'];
        	$datos['pres_telefono2'] 	=	$pr['telefono2'];
        	$datos['pres_celular1']		=	$pr['celular1'];
        	$datos['pres_email'] 		= 	$pr['email'];
        	$datos['pres_sitioweb'] 	= 	$pr['sitioweb'];
        }
	    $this->load->view('front_end/historias/hexamen_reporte_consent_v', $datos);
	}

	public function rep_laser()
	{
		$this->load->model('reportes_model','rm');

		$id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_laser          =   $this->input->post('num_laser');

        $datos['examen']    =   $this->rm->ciexamen_las($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci =	$this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
        	$fecha_naci    =   $pa->fecha_de_nacimiento;
    	    $dia=date("j");
    	    $mes=date("n");
    	    $anno=date("Y");
    	    $dia_nac=substr($fecha_naci, 8, 2);
    	    $mes_nac=substr($fecha_naci, 5, 2);
    	    $anno_nac=substr($fecha_naci, 0, 4);
    	    if($mes_nac>$mes){
    	    $datos['calc_edad']= $anno-$anno_nac-1;
    	    }else{
    	        if($mes==$mes_nac AND $dia_nac>$dia)
    	        {
    	            $datos['calc_edad']= $anno-$anno_nac-1;
    	        }else
    	        {
    	            $datos['calc_edad']= $anno-$anno_nac;
    	        }
    	    }	
        }

        // consulta en la base de datos
        $prestador					=	$this->rm->consulta_global();
        foreach($prestador as $pr)
        {
        	$datos['pres_nombre'] 		= 	$pr['nombre'];
        	$datos['pres_direccion'] 	= 	$pr['direccion'];
        	$datos['pres_telefono1'] 	= 	$pr['telefono1'];
        	$datos['pres_telefono2'] 	=	$pr['telefono2'];
        	$datos['pres_celular1']		=	$pr['celular1'];
        	$datos['pres_email'] 		= 	$pr['email'];
        	$datos['pres_sitioweb'] 	= 	$pr['sitioweb'];
        }
	    $this->load->view('front_end/historias/hexamen_reporte_laser_v', $datos);
	}

    

    public function rep_prea()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_prea           =   $this->input->post('num_prea');

        $datos['examen']                =   $this->rm->ciexamen_prea($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->rm->cicups($id_paciente,$n_conexamen);

        $datos['id_paciente']           =   $id_paciente;

        $examen             =   $this->rm->ciexamen_prea($id_paciente,$n_conexamen);
        foreach($examen as $exa)
        {
            $datos['fechaactual']               =   $exa->fechaactual;
            $datos['horaactual']                =   $exa->horaactual;
            $datos['medico']                    =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $datos['tipo']                      =   $exa->nombre_listap;
            $datos['nombre_admi']               =   $exa->nombre_admi;
            $datos['firmapaci']                 =   $exa->firmapaci;
            $datos['firmamedi']                 =   $exa->firmamedi;
            
            $datos['general']                   =   $exa->general;
            $datos['regional']                  =   $exa->regional;
            $datos['ultima']                    =   $exa->ultima;
            $datos['complicaciones']            =   $exa->complicaciones;
            $datos['alergicos']                 =   $exa->alergicos;
            $datos['farmacologicos']            =   $exa->farmacologicos;
            $datos['hemorragicos']              =   $exa->hemorragicos;
            $datos['patologicos']               =   $exa->patologicos;
            $datos['quirurgicos']               =   $exa->quirurgicos;
            $datos['toxicos']                   =   $exa->toxicos;
            $datos['transfuncionales']          =   $exa->transfuncionales;
            $datos['otros']                     =   $exa->otros;
            $datos['disnea']                    =   $exa->disnea;
            $datos['disnea_grado']              =   $exa->disnea_grado;
            $datos['angina']                    =   $exa->angina;
            $datos['angina_grado']              =   $exa->angina_grado;
            $datos['palpitaciones']             =   $exa->palpitaciones;
            $datos['precipitados']              =   $exa->precipitados;
            $datos['pulmonar']                  =   $exa->pulmonar;
            $datos['tos']                       =   $exa->tos;
            $datos['snc']                       =   $exa->snc;
            $datos['otros_sintomas']            =   $exa->otros_sintomas;
            $datos['pa']                        =   $exa->pa;
            $datos['tipo_pa']                   =   $exa->tipo_pa;
            $datos['fc']                        =   $exa->fc;
            $datos['fr']                        =   $exa->fr;
            $datos['temperatura']               =   $exa->temperatura;
            $datos['pulsoximetria']             =   $exa->pulsoximetria;
            $datos['peso']                      =   $exa->peso;
            $datos['talla']                     =   $exa->talla;
            $datos['imc']                       =   $exa->imc;
            $datos['lentes']                    =   $exa->lentes;
            $datos['protesis']                  =   $exa->protesis;
            $datos['ruidos_cardiacos']          =   $exa->ruidos_cardiacos;
            $datos['cuello']                    =   $exa->cuello;
            $datos['removible']                 =   $exa->removible;
            $datos['soplos']                    =   $exa->soplos;
            $datos['masas']                     =   $exa->masas;
            $datos['dientes_flojos']            =   $exa->dientes_flojos;
            $datos['carac_soplo']               =   $exa->carac_soplo;
            $datos['pulsos']                    =   $exa->pulsos;
            $datos['apertura']                  =   $exa->apertura;
            $datos['auscultacion']              =   $exa->auscultacion;
            $datos['prob_aerea']                =   $exa->prob_aerea;
            $datos['prob_aerea_otros']          =   $exa->prob_aerea_otros;
            $datos['especifique']               =   $exa->especifique;
            $datos['abdomen']                   =   $exa->abdomen;
            $datos['extremidades']              =   $exa->extremidades;
            $datos['otros_hallazgos']           =   $exa->otros_hallazgos;
            $datos['hematocrito']               =   $exa->hematocrito;
            $datos['electrocardiograma']        =   $exa->electrocardiograma;
            $datos['fecha_electrocardiograma']  =   $exa->fecha_electrocardiograma;
            $datos['creatinina']                =   $exa->creatinina;
            $datos['tx_torax']                  =   $exa->tx_torax;
            $datos['fecha_rx_torax']            =   $exa->fecha_rx_torax;
            $datos['nitrogeno']                 =   $exa->nitrogeno;
            $datos['otros_estudio_uno']         =   $exa->otros_estudio_uno;
            $datos['fecha_otros_uno']           =   $exa->fecha_otros_uno;
            $datos['glicemia']                  =   $exa->glicemia;
            $datos['otros_estudio_dos']         =   $exa->otros_estudio_dos;
            $datos['fecha_otros_dos']           =   $exa->fecha_otros_dos;
            $datos['albumina']                  =   $exa->albumina;
            $datos['otros_estudio_tres']        =   $exa->otros_estudio_tres;
            $datos['fecha_otros_tres']          =   $exa->fecha_otros_tres;
            $datos['plaquetas']                 =   $exa->plaquetas;
            $datos['otros_estudio_cuatro']      =   $exa->otros_estudio_cuatro;
            $datos['fecha_otros_cuatro']        =   $exa->fecha_otros_cuatro;
            $datos['clasificacion']             =   $exa->clasificacion;
            $datos['recomendaciones']           =   $exa->recomendaciones;
        }

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        $this->load->view('front_end/historias/hexamen_reporte_prea_v', $datos);
    }


    public function rep_ane()
    {
        $this->load->model('reportes_model','rm');


        $id_paciente                    =   $this->input->post('id_paciente', true);
        $n_conexamen                    =   $this->input->post('cons_examen', true);
        $datos['examen']                =   $this->rm->consulta_ane_enc($id_paciente,$n_conexamen);
        $datos['consulta_ane_lin']      =   $this->rm->consulta_ane_lin($id_paciente,$n_conexamen);
        $datos['consulta_ane_tec']      =   $this->rm->consulta_ane_tec($id_paciente,$n_conexamen);
        // TIEMPO EN SALA
        $datos['c_ane_tiempo']          =   $this->rm->c_ane_tiempo($n_conexamen, $id_paciente);
        $datos['c_ane_tiempo_v']        =   $this->rm->c_ane_tiempo_v($n_conexamen, $id_paciente);
        $datos['c_escala']              =   $this->rm->c_escala($n_conexamen, $id_paciente);
        $datos['c_anexhora']            =   $this->rm->c_conv_hora($n_conexamen, $id_paciente);
        $datos['contar_tiempo']         =   $this->rm->c_ane_contar_tiempo($n_conexamen, $id_paciente);
        $datos['c_txco']                =   $this->rm->c_txco($n_conexamen, $id_paciente);
        // MEDICAMENTOS
        $datos['r_medicamentos_ane']    =   $this->rm->r_medicamentos_ane($n_conexamen, $id_paciente);
        $datos['c_horas_solas']         =   $this->rm->c_horas_solas($n_conexamen, $id_paciente);
        // LÍQUIDOS ADMINISTRADOS
        $datos['r_liq_adm_ane']         =   $this->rm->r_liq_adm_ane($n_conexamen, $id_paciente);
        // LÍQUIDOS ELIMINADOS
        $datos['r_liq_eli_ane']         =   $this->rm->r_liq_eli_ane($n_conexamen, $id_paciente);
        // MONITORIAS
        $datos['r_liq_moni']            =   $this->rm->r_liq_moni($n_conexamen, $id_paciente);

        // datos unicos por cada proceso
        $datos['r_medi_unico_ane']      =   $this->rm->r_medi_unico_ane($n_conexamen, $id_paciente);
        $datos['r_liq_a_unico_ane']     =   $this->rm->r_liq_a_unico_ane($n_conexamen, $id_paciente);
        $datos['r_liq_e_unico_ane']     =   $this->rm->r_liq_e_unico_ane($n_conexamen, $id_paciente);
        $datos['r_moni_unico_ane']      =   $this->rm->r_moni_unico_ane($n_conexamen, $id_paciente);

        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }

        // logo personalizado del medico prestador
        $examen    =   $this->rm->consulta_ane_enc($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex['id_admi'];
                $cod_medi  =    $ex['cod_medi'];

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }

        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";
        
        //$this->load->view('front_end/historias/hexamen_reporte_ane_v', $datos);

        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        //$pdf = new Pdf_report('L', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Record Anestesia:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_ane_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Record Anestesia.pdf', 'I');
    }

    
    public function rep_notas()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        

        $datos['examen']            =   $this->rm->ciexamen_ne_enc($id_paciente,$n_conexamen);
        $datos['detalles']          =   $this->rm->cons_cerrada_ne_det($n_conexamen, $id_paciente);
        $datos['suministros']       =   $this->rm->ver_suministros_ne($n_conexamen, $id_paciente);
        $datos['medicamentos']      =   $this->rm->ver_medicamentos_ne($n_conexamen, $id_paciente);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        

        // logo personalizado del medico prestador
        /*$examen    =   $this->rm->ciexamen_ne_enc($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }*/

        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $logo_eps = 'logoempresa_vision.png';

        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Notas de enfermeria:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_ne_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Notas de enfermeria.pdf', 'I');
    }

    public function rep_oftalmologia()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');
        $datos['examen']    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);

        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']  =   $this->rm->paraclinicos($id_paciente, $n_conexamen);
        $cons_img           =   $this->rm->ciexamen($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Oftalmologia:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_oftalmologia_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' oftalmologia.pdf', 'I');
    }  

    // reporte medicamentos
    public function rep_medicamentos()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $datos['examen']    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']      =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }
        
        
        

        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }

        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Medicamentos:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_medicamentos_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Medicamentos.pdf', 'I');
    }

    // reporte medicamentos
    public function rep_medicamentos_dqx()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_laser          =   $this->input->post('num_laser');

        $datos['examen']    =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']      =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }
        
        
        

        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }

        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Medicamentos:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_medicamentos_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Medicamentos.pdf', 'I');
    }

    public function rep_ordenes_medicas()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');
        $datos['examen']    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']  =   $this->rm->paraclinicos($id_paciente, $n_conexamen);
        $cons_img           =   $this->rm->ciexamen($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Ordenes Medicas:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_ordenes_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Ordenes Medicas.pdf', 'I');
    } 

    public function rep_prequirurgico()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');
        $datos['examen']    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']  =   $this->rm->paraclinicos($id_paciente, $n_conexamen);
        $cons_img           =   $this->rm->ciexamen($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Prequirurgico:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_prequirurgico_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Prequirurgico.pdf', 'I');
    } 

    public function rep_incapacidades()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');
        $datos['examen']    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']  =   $this->rm->paraclinicos($id_paciente, $n_conexamen);
        $cons_img           =   $this->rm->ciexamen($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Incapacidad:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_incapacidad_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Incapacidad.pdf', 'I');
    }

    public function rep_incapacidades_dqx()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_laser          =   $this->input->post('num_laser');
        $datos['examen']    =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']  =   $this->rm->paraclinicos($id_paciente, $n_conexamen);
        $cons_img           =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Incapacidad:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_incapacidad_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Incapacidad.pdf', 'I');
    } 


    // reportes de optometria
    public function rep_optometria()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_optometria     =   $this->input->post('num_optometria');

        $datos['examen']    =   $this->rm->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        //$datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        //$datos['paraclinicos']  =   $this->rm->paraclinicos($id_paciente, $n_conexamen);
        

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen_opt($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Optometria:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_optometria_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Optometria.pdf', 'I');
    }  

    public function rep_dqx_new()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_dqx            =   $this->input->post('num_dqx');

        $datos['examen']             =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);
        $datos['cie']                =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']               =   $this->rm->cicups($id_paciente,$n_conexamen);

        $examen             =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);
        foreach($examen as $exa)
        {
            $datos['fecha_consulta']                 =   $exa->fechaactual;
            $datos['hora_consulta']                  =   $exa->horaactual;
            $datos['cod_medi']                       =   $exa->cod_medi;
            $datos['medico']                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $datos['tipo']                           =   $exa->nombre_listap;
            
            $datos['ojo_operar']                     =   $exa->ojo_operar;
            $datos['cirujano']                       =   $exa->ciru_pri_nombre .' '. $exa->ciru_seg_nombre.' '.$exa->ciru_pri_apellido.' '.$exa->ciru_seg_apellido;

            $datos['anestesiologo']                  =   $exa->ane_pri_nombre.' '.$exa->ane_seg_nombre.' '.$exa->ane_pri_apellido.' '.$exa->ane_seg_apellido;

            $datos['instrumentadora']                =   $exa->ins_pri_nombre.' '.$exa->ins_seg_nombre.' '.$exa->ins_pri_apellido.' '.$exa->ins_seg_apellido;

            $datos['id_tipo_anestesia']              =   $exa->nombre_anestesia;

            $datos['circulante']                     =   $exa->ci_pri_nombre.' '.$exa->ci_seg_nombre.' '.$exa->ci_pri_apellido.' '.$exa->ci_seg_apellido;

            $datos['ayudante']                       =   $exa->ayu_pri_nombre.' '.$exa->ayu_seg_nombre.' '.$exa->ayu_pri_apellido.' '.$exa->ayu_seg_apellido;

            $datos['hora_inicio']                    =   $exa->hora_inicio;
            $datos['hora_final']                     =   $exa->hora_final;
            $datos['descripcion']                    =   $exa->descripcion;
            $datos['complicion']                     =   $exa->complicion;
            $datos['planpos']                        =   $exa->planpos;
            $datos['recomendaciones']                =   $exa->recomendaciones;
            $datos['estadofinal']                    =   $exa->estadofinal;

            $datos['nombre_admi']                    =   $exa->nombre_admi;
            $datos['firmapaci']                      =   $exa->firmapaci;
            $datos['firmamedi']                      =   $exa->firmamedi;
            $datos['fecha_cirugia']                  =   $exa->fecha_cirugia;
            $datos['tiempo']                         =   $exa->tiempo;

            $datos['hora_inicio_anes']               =   $exa->hora_inicio_anes;
            $datos['sala']                           =   $exa->sala;
            $datos['envio_patologia']                =   $exa->envio_patologia;
            $datos['tipo_patologia']                 =   $exa->tipo_patologia;
            $datos['destino']                        =   $exa->destino;

            $l_id_admi =    $exa->id_admi;
            $cod_medi  =    $exa->cod_medi;

            // busqueda del logo en la tabla contratistas
            $b_logo = $this->rm->b_logo($l_id_admi);
            if($b_logo)
            {
                foreach($b_logo as $bl)
                {
                    $v_logo = $bl['logo'];
                    if($v_logo)
                    {
                        $logo_eps = $bl['logo'];    
                    }else
                    {
                        $logo_eps = 'logoempresa_vision.png';
                    }
                    
                }
            }

            // buscar la firma del medico
            $f_medico = $this->rm->f_medico($cod_medi);
            if($f_medico)
            {
                foreach($f_medico as $fm)
                {
                    $datos['firma_medico'] = $fm['firmamedi'];
                }
            }else
            {
                $datos['firma_medico'] = '';
            }
        }

        $cons_img           =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }  
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido; 
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        //$this->load->view('front_end/historias/hexamen_reporte_dx_v', $datos);

        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Descricion quirurgica:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_dq_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Descricion quirurgica.pdf', 'I');
    }
    public function rep_dqx()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_dqx            =   $this->input->post('num_dqx');

        $datos['examen']             =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);
        $datos['cie']                =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']               =   $this->rm->cicups($id_paciente,$n_conexamen);

        $examen             =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);
        foreach($examen as $exa)
        {
            $datos['fecha_consulta']                 =   $exa->fechaactual;
            $datos['hora_consulta']                  =   $exa->horaactual;
            $datos['cod_medi']                       =   $exa->cod_medi;
            $datos['medico']                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $datos['tipo']                           =   $exa->nombre_listap;
            
            $datos['ojo_operar']                     =   $exa->ojo_operar;
            $datos['cirujano']                       =   $exa->ciru_pri_nombre .' '. $exa->ciru_seg_nombre.' '.$exa->ciru_pri_apellido.' '.$exa->ciru_seg_apellido;

            $datos['anestesiologo']                  =   $exa->ane_pri_nombre.' '.$exa->ane_seg_nombre.' '.$exa->ane_pri_apellido.' '.$exa->ane_seg_apellido;

            $datos['instrumentadora']                =   $exa->ins_pri_nombre.' '.$exa->ins_seg_nombre.' '.$exa->ins_pri_apellido.' '.$exa->ins_seg_apellido;

            $datos['id_tipo_anestesia']              =   $exa->nombre_anestesia;

            $datos['circulante']                     =   $exa->ci_pri_nombre.' '.$exa->ci_seg_nombre.' '.$exa->ci_pri_apellido.' '.$exa->ci_seg_apellido;

            $datos['ayudante']                       =   $exa->ayu_pri_nombre.' '.$exa->ayu_seg_nombre.' '.$exa->ayu_pri_apellido.' '.$exa->ayu_seg_apellido;

            $datos['hora_inicio']                    =   $exa->hora_inicio;
            $datos['hora_final']                     =   $exa->hora_final;
            $datos['descripcion']                    =   $exa->descripcion;
            $datos['complicion']                     =   $exa->complicion;
            $datos['planpos']                        =   $exa->planpos;
            $datos['recomendaciones']                =   $exa->recomendaciones;
            $datos['estadofinal']                    =   $exa->estadofinal;

            $datos['nombre_admi']                    =   $exa->nombre_admi;
            $datos['firmapaci']                      =   $exa->firmapaci;
            $datos['firmamedi']                      =   $exa->firmamedi;
            $datos['fecha_cirugia']                  =   $exa->fecha_cirugia;
            $datos['tiempo']                         =   $exa->tiempo;

            $datos['hora_inicio_anes']               =   $exa->hora_inicio_anes;
            $datos['sala']                           =   $exa->sala;
            $datos['envio_patologia']                =   $exa->envio_patologia;
            $datos['tipo_patologia']                 =   $exa->tipo_patologia;
            $datos['destino']                        =   $exa->destino;
        }

        $cons_img           =   $this->rm->ciexamen_dqx($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        $this->load->view('front_end/historias/hexamen_reporte_dx_v', $datos);
    }

    public function rep_laser_new()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_laser          =   $this->input->post('num_laser');

        $datos['examen']    =   $this->rm->ciexamen_las($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido; 
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }

        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $examen    =   $this->rm->ciexamen_las($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }

        //$this->load->view('front_end/historias/hexamen_reporte_laser_v', $datos);
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Procedimiento laser:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_ls_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Procedimiento laser.pdf', 'I');
    }

    public function rep_prea_new()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_prea           =   $this->input->post('num_prea');

        $datos['examen']                =   $this->rm->ciexamen_prea($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->rm->cicups($id_paciente,$n_conexamen);

        $datos['id_paciente']           =   $id_paciente;

        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        $examen             =   $this->rm->ciexamen_prea($id_paciente,$n_conexamen);
        foreach($examen as $exa)
        {
            $datos['fechaactual']               =   $exa->fechaactual;
            $datos['horaactual']                =   $exa->horaactual;
            $datos['medico']                    =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $datos['tipo']                      =   $exa->nombre_listap;
            $datos['nombre_admi']               =   $exa->nombre_admi;
            $datos['firmapaci']                 =   $exa->firmapaci;
            $datos['firmamedi']                 =   $exa->firmamedi;
            
            $datos['general']                   =   $exa->general;
            $datos['regional']                  =   $exa->regional;
            $datos['ultima']                    =   $exa->ultima;
            $datos['complicaciones']            =   $exa->complicaciones;
            $datos['alergicos']                 =   $exa->alergicos;
            $datos['farmacologicos']            =   $exa->farmacologicos;
            $datos['hemorragicos']              =   $exa->hemorragicos;
            $datos['patologicos']               =   $exa->patologicos;
            $datos['quirurgicos']               =   $exa->quirurgicos;
            $datos['toxicos']                   =   $exa->toxicos;
            $datos['transfuncionales']          =   $exa->transfuncionales;
            $datos['otros']                     =   $exa->otros;
            $datos['disnea']                    =   $exa->disnea;
            $datos['disnea_grado']              =   $exa->disnea_grado;
            $datos['angina']                    =   $exa->angina;
            $datos['angina_grado']              =   $exa->angina_grado;
            $datos['palpitaciones']             =   $exa->palpitaciones;
            $datos['precipitados']              =   $exa->precipitados;
            $datos['pulmonar']                  =   $exa->pulmonar;
            $datos['tos']                       =   $exa->tos;
            $datos['snc']                       =   $exa->snc;
            $datos['otros_sintomas']            =   $exa->otros_sintomas;
            $datos['pa']                        =   $exa->pa;
            $datos['tipo_pa']                   =   $exa->tipo_pa;
            $datos['fc']                        =   $exa->fc;
            $datos['fr']                        =   $exa->fr;
            $datos['temperatura']               =   $exa->temperatura;
            $datos['pulsoximetria']             =   $exa->pulsoximetria;
            $datos['peso']                      =   $exa->peso;
            $datos['talla']                     =   $exa->talla;
            $datos['imc']                       =   $exa->imc;
            $datos['lentes']                    =   $exa->lentes;
            $datos['protesis']                  =   $exa->protesis;
            $datos['ruidos_cardiacos']          =   $exa->ruidos_cardiacos;
            $datos['cuello']                    =   $exa->cuello;
            $datos['removible']                 =   $exa->removible;
            $datos['soplos']                    =   $exa->soplos;
            $datos['masas']                     =   $exa->masas;
            $datos['dientes_flojos']            =   $exa->dientes_flojos;
            $datos['carac_soplo']               =   $exa->carac_soplo;
            $datos['pulsos']                    =   $exa->pulsos;
            $datos['apertura']                  =   $exa->apertura;
            $datos['auscultacion']              =   $exa->auscultacion;
            $datos['prob_aerea']                =   $exa->prob_aerea;
            $datos['prob_aerea_otros']          =   $exa->prob_aerea_otros;
            $datos['especifique']               =   $exa->especifique;
            $datos['abdomen']                   =   $exa->abdomen;
            $datos['extremidades']              =   $exa->extremidades;
            $datos['otros_hallazgos']           =   $exa->otros_hallazgos;
            $datos['hematocrito']               =   $exa->hematocrito;
            $datos['electrocardiograma']        =   $exa->electrocardiograma;
            $datos['fecha_electrocardiograma']  =   $exa->fecha_electrocardiograma;
            $datos['creatinina']                =   $exa->creatinina;
            $datos['tx_torax']                  =   $exa->tx_torax;
            $datos['fecha_rx_torax']            =   $exa->fecha_rx_torax;
            $datos['nitrogeno']                 =   $exa->nitrogeno;
            $datos['otros_estudio_uno']         =   $exa->otros_estudio_uno;
            $datos['fecha_otros_uno']           =   $exa->fecha_otros_uno;
            $datos['glicemia']                  =   $exa->glicemia;
            $datos['otros_estudio_dos']         =   $exa->otros_estudio_dos;
            $datos['fecha_otros_dos']           =   $exa->fecha_otros_dos;
            $datos['albumina']                  =   $exa->albumina;
            $datos['otros_estudio_tres']        =   $exa->otros_estudio_tres;
            $datos['fecha_otros_tres']          =   $exa->fecha_otros_tres;
            $datos['plaquetas']                 =   $exa->plaquetas;
            $datos['otros_estudio_cuatro']      =   $exa->otros_estudio_cuatro;
            $datos['fecha_otros_cuatro']        =   $exa->fecha_otros_cuatro;
            $datos['clasificacion']             =   $exa->clasificacion;
            $datos['recomendaciones']           =   $exa->recomendaciones;

            $l_id_admi =    $exa->id_admi;
            $cod_medi  =    $exa->cod_medi;

            // busqueda del logo en la tabla contratistas
            $b_logo = $this->rm->b_logo($l_id_admi);
            if($b_logo)
            {
                foreach($b_logo as $bl)
                {
                    $v_logo = $bl['logo'];
                    if($v_logo)
                    {
                        $logo_eps = $bl['logo'];    
                    }else
                    {
                        $logo_eps = 'logoempresa_vision.png';
                    }
                    
                }
            }

            // buscar la firma del medico
            $f_medico = $this->rm->f_medico($cod_medi);
            if($f_medico)
            {
                foreach($f_medico as $fm)
                {
                    $datos['firma_medico'] = $fm['firmamedi'];
                }
            }else
            {
                $datos['firma_medico'] = '';
            }
        }

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido; 
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        //$this->load->view('front_end/historias/hexamen_reporte_prea_v', $datos);

        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Preanestesia:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_pre_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Preanestesia.pdf', 'I');
    }

    public function rep_ane_new()
    {
        $this->load->model('reportes_model','rm');

        $id_paciente                    =   $this->input->post('id_paciente', true);
        $n_conexamen                    =   $this->input->post('cons_examen', true);
        $datos['consulta_ane_enc']      =   $this->rm->consulta_ane_enc($id_paciente,$n_conexamen);
        $datos['consulta_ane_det']      =   $this->rm->consulta_ane_det($id_paciente,$n_conexamen);
        $datos['consulta_ane_maq']      =   $this->rm->consulta_ane_maq($id_paciente,$n_conexamen);

        
        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido; 
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }

        
        //$this->load->view('front_end/historias/hexamen_reporte_ane_v', $datos);

        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Preanestesia:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_ane_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Preanestesia.pdf', 'I');
    }

    // reporte formula optometria gafas
    public function rep_formula()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_optometria     =   $this->input->post('num_optometria');

        $datos['examen']    =   $this->rm->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        //$datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        //$datos['paraclinicos']  =   $this->rm->paraclinicos($id_paciente, $n_conexamen);
        

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen_opt($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Formula final:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_formula_final_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Formula final.pdf', 'I');
    }  

    // reporte formula optometria gafas
    public function rep_ordenes_medicas_opt()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_optometria     =   $this->input->post('num_optometria');

        $datos['examen']    =   $this->rm->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']       =   $this->rm->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']      =   $this->rm->cicups($id_paciente,$n_conexamen);
        $datos['ciemas']    =   $this->rm->ciexamenciemas($id_paciente,$n_conexamen);
        //$datos['medicamentos']  =   $this->rm->cimedicamentos($id_paciente,$n_conexamen);
        //$datos['paraclinicos']  =   $this->rm->paraclinicos($id_paciente, $n_conexamen);
        

        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        $examen    =   $this->rm->ciexamen_opt($id_paciente,$n_conexamen);
        if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {
                            $logo_eps = 'logoempresa_vision.png';
                        }
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Orden medica optometria:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_orden_med_opt_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Orden medica optometria.pdf', 'I');
    } 

    // reporte lista de chequeo
    public function rep_lista_chequeo()
    {
        $this->load->model('reportes_model','rm');
        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');

        $datos['examen']       =   $this->rm->c_historico_lch($id_paciente,$n_conexamen);
        $c_cirujano                     =   $this->rm->c_cirujano_lch($id_paciente,$n_conexamen);
        foreach($c_cirujano as $cr)
        {
            $datos['c_cirujano_lch']    =   $cr['pnom_cirujano'].$cr['snom_cirujano'].$cr['pape_cirujano'].$cr['sape_cirujano'];
        }
        $c_anestesiologo                =   $this->rm->c_anestesiologo_lch($id_paciente,$n_conexamen);
        foreach($c_anestesiologo as $ca)
        {
            $datos['c_anestesiologo_lch']   =   $ca['pnom_anestesiologo'].$ca['snom_anestesiologo'].$ca['pape_anestesiologo'].$ca['sape_anestesiologo'];
        }

        // consulta de fecha y de persona que ingreso.
        $c_fecha_login_ingreso          =   $this->rm->c_fecha_login_ingreso($id_paciente, $n_conexamen);
        foreach($c_fecha_login_ingreso as $fli)
        {
            $datos['i_fecha']           =   $fli['fechaactual'];
            $datos['i_hora']            =   $fli['horaactual'];
            $datos['i_login']           =   $fli['nombre'].$fli['nombre2'].$fli['apellido1'].$fli['apellido2'];
        }

        $c_fecha_login_entrada          =   $this->rm->c_fecha_login_entrada($id_paciente, $n_conexamen);
        foreach($c_fecha_login_entrada as $fle)
        {
            $datos['e_fecha']           =   $fle['fecha_intra_entrada'];
            $datos['e_hora']            =   $fle['hora_intra_entrada'];
            $datos['e_login']           =   $fle['nombre'].$fle['nombre2'].$fle['apellido1'].$fle['apellido2'];
        }

        $c_fecha_login_pausa            =   $this->rm->c_fecha_login_pausa($id_paciente, $n_conexamen);
        foreach($c_fecha_login_pausa as $flp)
        {
            $datos['p_fecha']           =   $flp['fecha_intra_pausa'];
            $datos['p_hora']            =   $flp['hora_intra_pausa'];
            $datos['p_login']           =   $flp['nombre'].$flp['nombre2'].$flp['apellido1'].$flp['apellido2'];
        }

        $c_fecha_login_recuperacion     =   $this->rm->c_fecha_login_recuperacion($id_paciente, $n_conexamen);
        foreach($c_fecha_login_recuperacion as $flr)
        {
            $datos['r_fecha']           =   $flr['fecha_intra_recu'];
            $datos['r_hora']            =   $flr['hora_intra_recu'];
            $datos['r_login']           =   $flr['nombre'].$flr['nombre2'].$flr['apellido1'].$flr['apellido2'];
        }
        
        // PRESTADOR
        $datos['prestador'] =   $this->rm->prestador();
        
        // CONSULTA BASE DE DATOS PACIENTE
        $datos['paciente']  =   $this->rm->cipaciente_v($id_paciente);
        $paci = $this->rm->cipaciente_v($id_paciente);
        foreach($paci as $pa)
        {
            $fecha_naci    =   $pa->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $datos['calc_edad']= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $datos['calc_edad']= $anno-$anno_nac-1;
                }else
                {
                    $datos['calc_edad']= $anno-$anno_nac;
                }
            }   
            $paciente_resultado = $pa->primer_nombre.' '.$pa->segundo_nombre.' '.$pa->primer_apellido.' '.$pa->segundo_apellido;
        }

        // consulta de eps contrato
        $c_eps_paciente  =   $this->rm->cipaciente_eps($id_paciente);
        foreach($c_eps_paciente as $eps)
        {
            $datos['eps_paciente']  =   $eps->nombre_admi;
        }

        // consulta en la base de datos
        $prestador                  =   $this->rm->consulta_global();
        foreach($prestador as $pr)
        {
            $datos['pres_nombre']       =   $pr['nombre'];
            $datos['pres_direccion']    =   $pr['direccion'];
            $datos['pres_telefono1']    =   $pr['telefono1'];
            $datos['pres_telefono2']    =   $pr['telefono2'];
            $datos['pres_celular1']     =   $pr['celular1'];
            $datos['pres_email']        =   $pr['email'];
            $datos['pres_sitioweb']     =   $pr['sitioweb'];
        }
        
        $datos['base_dominio'] = base_url();
        $datos['espacio4']     = "colspan='4'";

        // logo personalizado del medico prestador
        //$examen    =   $this->rm->ciexamen_opt($id_paciente,$n_conexamen);
        /*if($examen)
        {
            foreach($examen as $ex)
            {
                $l_id_admi =    $ex->id_admi;
                $cod_medi  =    $ex->cod_medi;

                // busqueda del logo en la tabla contratistas
                $b_logo = $this->rm->b_logo($l_id_admi);
                if($b_logo)
                {
                    foreach($b_logo as $bl)
                    {
                        $v_logo = $bl['logo'];
                        if($v_logo)
                        {
                            $logo_eps = $bl['logo'];    
                        }else
                        {*/
                            $logo_eps = 'logoempresa_vision.png';
                        /*}
                        
                    }
                }

                // buscar la firma del medico
                $f_medico = $this->rm->f_medico($cod_medi);
                if($f_medico)
                {
                    foreach($f_medico as $fm)
                    {
                        $datos['firma_medico'] = $fm['firmamedi'];
                    }
                }else
                {
                    $datos['firma_medico'] = '';
                }
                
            }
        }*/
        
        $pdf = new Pdf_report('P', 'mm','LETTER','true','UTF-8',false);
        $pdf->SetTitle('Lista chequeo:'.$paciente_resultado);
        $pdf->SetAuthor('HCL- RentarHosting SAS');
        $this->load->vars($datos);
        $html = $this->load->view('front_end/historias/hexamen_reporte_lch_v', false, true);
        $PDF_HEADER_TITLE="";
        $PDF_HEADER_STRING="";
        $PDF_HEADER_LOGO=$logo_eps; //Solo me funciona si esta dentro de la carpeta images de la libreria
        $pdf->SetHeaderData($PDF_HEADER_LOGO, '180', $PDF_HEADER_TITLE, $PDF_HEADER_STRING);
        $pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
        $pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));
        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins('5', PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        $pdf->SetFont('helvetica', '', 10);
        $pdf->AddPage('P', 'LETTER', false);
        $pdf->writeHTML($html);
        $pdf->Output($paciente_resultado.' Lista chequeo.pdf', 'I');
    } 

}

?>
