<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Medico extends CI_Controller {
    
    //private $session_id, $session_nombre, $nivel_usuario;     
    public function __construct()
    {
        parent::__construct();
        $this->session_id               =   $this->session->userdata('login');    
        $this->session_nombre           =   $this->session->userdata('nombre'); 
        $this->session_nivel_usuario    =   $this->session->userdata('nivel_usuario');
        $this->session_idusuario        =   $this->session->userdata('id');
        $this->session_gempnumero       =   $this->session->userdata('gempnumero');
        $this->session_gempnombre       =   $this->session->userdata('gempnombre'); 
        $this->session_gempanoc         =   $this->session->userdata('gempanoc'); 
        $this->load->library('Datatables');                
    }
   
    public function index()
    {            
        $this->load->view('front_end/tecnico/menut_f_v', 301);
    }
    
    public function pantallainicio()
    {
        $this->load->view('front_end/tecnico/pantallainicio_v', 301);
    }
    
    public function ingreso()
    {
        $this->load->model('admon_model');
        $usuario            =   $this->session_id;
        $consultausu        =   $this->admon_model->consultausu($usuario);
        foreach($consultausu as $conu)
        {
            $datos['login']             =   $conu['login'];
            $datos['cod_persona_atie']  =   $conu['cod_persona_atie'];
        }
        $datos['titulo']    =   'Ingreso de médico';
        $this->load->view('front_end/tecnico/admmeding_v', $datos);
    }
    
    public function resumen()
    {
        $this->db->trans_start();
        $abuscar    =   $this->input->post('abuscar');        
        $vlogin     =   $this->input->post('vloging');
        $codpersona =   $this->input->post('codpersona');
        
        if($codpersona == '20')
        {
            $this->datatables->select('m.tipo_docu, m.primer_nombre_medi,m.segundo_nombre_medi, m.primer_apellido_medi,m.segundo_apellido_medi,m.identificacion_medi, m.cod_medi, p.nombre_persona_atie, m.activo, m.id_medi')            
            ->where('loginasistente', $vlogin)
            ->join('persona_atiende p','m.cod_persona_atie = p.cod_persona_atie')                  
            ->from('medicos m');
        }else
        {
            $this->datatables->select('m.tipo_docu, m.primer_nombre_medi,m.segundo_nombre_medi, m.primer_apellido_medi,m.segundo_apellido_medi,m.identificacion_medi, m.cod_medi, p.nombre_persona_atie, m.activo, m.id_medi')
            ->where('loginasistente', '')            
            ->join('persona_atiende p','m.cod_persona_atie = p.cod_persona_atie')                  
            ->from('medicos m');
        }
        echo $this->datatables->generate();
        $this->db->trans_complete();
    }
    
    public function modificacion()
    {
        $this->load->model('admon_model');
        $usuario            =   $this->session_id;
        $consultausu        =   $this->admon_model->consultausu($usuario);
        foreach($consultausu as $conu)
        {
            $datos['login']             =   $conu['login'];
            $datos['cod_persona_atie']  =   $conu['cod_persona_atie'];
        }
        $datos['titulo']    =   'Modificación de médico';
        $datos['consulta']  =   $this->admon_model->consultamedicos();
        $this->load->view('front_end/tecnico/admmedmod_v', $datos);
    }
    
    public function consulta()
    {
        $this->load->model('admon_model');
        $datos['titulo']    =   'Consulta de médico';
        $datos['consulta']  =   $this->admon_model->consultamedicos();
        $this->load->view('front_end/tecnico/admmedcon_v', $datos);
    }
    
    public function tipodocumento()
    {
        $this->load->model('admon_model');
        $tipodocumento  =   $this->admon_model->tipodocumento();
    }
    
    public function consultaridentificacion()
    {
        $this->load->model('admon_model');
        $tipodocu                   =   $this->input->post('vtipo_docu');
        $identificacion             =   $this->input->post('videntificacion');
        $consultaridentificacion    =   $this->admon_model->consultaridentificacionmed($tipodocu, $identificacion);
    }
    
    public function nuevomedico()
    {
        $this->load->model('admon_model');
        $nuevomedico   =   $this->admon_model->nuevomedico();
    }  
    
    public function medicoamodificar()
    {
        $this->load->model('admon_model');
        $medico             =   $this->input->post('idmedi');
        $usuario            =   $this->session_id;
        $consultausu        =   $this->admon_model->consultausu($usuario);
        foreach($consultausu as $conu)
        {
            $datos['login']             =   $conu['login'];
            $datos['cod_persona_atie']  =   $conu['cod_persona_atie'];
        }
        $datos['cmedico']  =   $this->admon_model->consultamedico($medico);
        $datos['titulo']   =   'Modificación de médico';
        $datos['id_medi']  =   $medico;          
        $this->load->view('front_end/tecnico/admmedmod_t_v', $datos);
    }
    
    public function modconsultarcodigomedicomed()
    {
        $this->load->model('admon_model');
        $codigomedico           =   $this->input->post('codigomedico');   
        $idmedico               =   $this->input->post('idmedico');     
        $consultarcodigomedico  =   $this->admon_model->modconsultarcodigomedicomed($codigomedico, $idmedico);
    }  
    
    public function modconsultaridentificacionmed()
    {
        $this->load->model('admon_model');
        $tipodocu                   =   $this->input->post('vtipo_docu');
        $identificacion             =   $this->input->post('videntificacion');
        $idmedico                   =   $this->input->post('idmedico');
        $consultaridentificacion    =   $this->admon_model->modconsultaridentificacionmed($tipodocu, $identificacion, $idmedico);
    }
    
    public function modificarmedico()
    {
        $this->load->model('admon_model');
        $nuevousuario   =   $this->admon_model->modificarmedico();
    }
    
    public function modificarmedicob()
    {
        $this->load->model('admon_model');
        $idmedico       =   $this->input->post('idmedico');
        $activo         =   $this->input->post('activo');
        $fechamod       =   $this->input->post('fechamod');
        $horamod        =   $this->input->post('horamod');
        
        $nuevousuario   =   $this->admon_model->modificarmedicob($idmedico, $activo, $fechamod, $horamod);
    }
    
    public function medicoaconsultar()
    {
        $this->load->model('admon_model');
        $medico            =   $this->input->post('idmedi');
        $datos['cmedico']  =   $this->admon_model->consultamedico($medico);
        $datos['titulo']   =   'Consulta de médico';
        $datos['id_medi']  =   $medico;          
        $this->load->view('front_end/tecnico/admmedcon_t_v', $datos);
    }
    
    public function consultarprofesion()
    {
        $this->load->model('admon_model');
        $profesion      =   $this->input->post('cod_persona_atie');
        $consultarprof  =   $this->admon_model->profesion($profesion);
    }
           
}