<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Examen_model extends CI_Model
{    
	public function __construct()
    {
        parent::__construct();       
    }

    public function consultaconsecutivo($numero) {
        $data = array();
        $this->db->select('numero_consecutivo');
        $this->db->where('cod_consecutivo', $numero);
        $query = $this->db->get('consecutivos');

        if ($query->num_rows() > 0) {
            $n    = $query->result();
            $data = (int) $n[0]->numero_consecutivo + 1;
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    // OFTALMOLOGIA
    public function insertExa($data, $n_conexamen) {
        // ACTUALIZA EL EXAMEN EN CONSECUTIVOS
        $cexamen = array(
            'numero_consecutivo' => $n_conexamen,
        );
        $this->db->where('cod_consecutivo', 7);
        $this->db->update('consecutivos', $cexamen);
        return $this->db->insert('pacientes_exa', $data);
    }

    // OPTOMETRIA
    public function insertExa_opt($data, $n_conexamen){
        // ACTUALIZA EL EXAMEN EN CONSECUTIVOS
        $cexamen = array(
            'numero_consecutivo' => $n_conexamen,
        );
        $this->db->where('cod_consecutivo', 7);
        $this->db->update('consecutivos', $cexamen);
        return $this->db->insert('pacientes_opt', $data);
    }

    public function insertCieCups($data) {
        return $this->db->insert('ciecups', $data);
    }

    public function updateEncabezadoGN($datencabezadogn, $id_paciente)
    {                            
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('ref_procesos', 'GN');
        $this->db->update('encabezado', $datencabezadogn); 
    }

    public function update_agenda($id_agenda, $m_agenda)
    {                            
        $this->db->where('id_agenda', $id_agenda);
        $this->db->update('agenda', $m_agenda); 
    }
    
    public function ciexamen($id_paciente, $n_conexamen) 
    {

        $this->db->select('e.*, co.nombre_cons, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi, con.nom_consultorio, ct.nombre_admi, lp.nombre_listap');
        $this->db->from('pacientes_exa e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons', 'left outer');   
        $this->db->join('medicos m', 'm.cod_medi = e.cod_medi', 'left outer');         
        $this->db->join('consultorios con', 'con.cod_consultorio = e.cod_consultorio', 'left outer');  
        $this->db->join('contratistas ct', 'ct.id_contratistas = e.id_admi', 'left outer');  
        $this->db->join('listaprecios lp', 'lp.cod_listap = e.tipo_co', 'left outer');  
        $this->db->where('e.id_paciente', $id_paciente);
        $this->db->where('e.cons_examen', $n_conexamen);  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function ciexamen_opt($id_paciente, $n_conexamen) 
    {

        $this->db->select('e.*, co.nombre_cons, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi, con.nom_consultorio, ct.nombre_admi,
            lp.nombre_listap');
        $this->db->from('pacientes_opt e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons', 'left outer');   
        $this->db->join('medicos m', 'm.cod_medi = e.cod_medi', 'left outer');         
        $this->db->join('consultorios con', 'con.cod_consultorio = e.cod_consultorio', 'left outer');  
        $this->db->join('contratistas ct', 'ct.id_contratistas = e.id_admi', 'left outer');  
        $this->db->join('listaprecios lp', 'lp.cod_listap = e.tipo_co', 'left outer');  
        $this->db->where('e.id_paciente', $id_paciente);
        $this->db->where('e.cons_examen', $n_conexamen);  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function ciexamen_op($id_paciente, $n_conexamen) 
    {

        $this->db->select('e.*, co.nombre_cons, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi, con.nom_consultorio, ct.nombre_admi, lp.nombre_listap');
        $this->db->from('pacientes_opt e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons', 'left outer');   
        $this->db->join('medicos m', 'm.cod_medi = e.cod_medi', 'left outer');         
        $this->db->join('consultorios con', 'con.cod_consultorio = e.cod_consultorio', 'left outer');  
        $this->db->join('contratistas ct', 'ct.id_contratistas = e.id_admi', 'left outer');  
        $this->db->join('listaprecios lp', 'lp.cod_listap = e.tipo_co', 'left outer'); 
        $this->db->where('e.id_paciente', $id_paciente);
        $this->db->where('e.cons_examen', $n_conexamen);  

        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function ciexamencie($id_paciente, $n_conexamen) {
        $this->db->select('c.*, cie.nombre_cie, cd.nombre_causa_dia, fi.nombre_fina, co.nombre_cons, ti.nombre_tipo, cier.nombre_cie as nombre_cier, ciers.nombre_cie as nombre_ciers, cierr.nombre_cie as nombre_cierr');
        $this->db->from('ciecups c');
        $this->db->join('cie10 cie', 'cie.cod_cie = c.cod_cie ');
        $this->db->join('cie10 cier', 'cier.cod_cie = c.cod_cier', 'left outer');
        $this->db->join('cie10 ciers', 'ciers.cod_cie = c.cod_ciers', 'left outer');
        $this->db->join('cie10 cierr', 'cierr.cod_cie = c.cod_cierr', 'left outer');
        $this->db->join('causa_diagnostico cd', 'cd.cod_causa_dia = c.cod_causa_dia');
        $this->db->join('finalidad  fi', 'fi.cod_fina = c.cod_fina_cie AND fi.cod_tipo_fina = "1" ');
        $this->db->join('consulta co', 'co.cod_cons = c.cod_cons');
        $this->db->join('tipo ti', 'ti.cod_tipo = c.cod_tipo');
        $this->db->where('c.id_paciente', $id_paciente);
        $this->db->where('c.cons_examen', $n_conexamen);
        $this->db->where('c.activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function ciexamenciemas($id_paciente, $n_conexamen) 
    {
        $this->db->select('c.*, cie.nombre_cie as nombre_ciemas');
        $this->db->from('ciecups c');
        $this->db->join('cie10 cie', 'cie.cod_cie = c.cod_ciemas');
        $this->db->join('causa_diagnostico cd', 'cd.cod_causa_dia = c.cod_causa_dia');
        $this->db->join('finalidad  fi', 'fi.cod_fina = c.cod_fina_cie AND fi.cod_tipo_fina = "1" ');
        $this->db->join('consulta co', 'co.cod_cons = c.cod_cons');
        $this->db->join('tipo ti', 'ti.cod_tipo = c.cod_tipo');
        $this->db->where('c.id_paciente', $id_paciente);
        $this->db->where('c.cons_examen', $n_conexamen);
        $this->db->where('c.activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function cicups($id_paciente, $n_conexamen) {
        $this->db->select('c.*, cu.nombre_cups, ac.nombre_actoq, fi.nombre_fina, am.nombre_ambi, tl.nombre_lateralidad');
        $this->db->from('ciecups c');
        $this->db->join('cups cu', 'cu.cod_cups = c.cod_cups');
        $this->db->join('actoquirurgico ac', 'ac.cod_actoq = c.cod_actoq', 'left outer');
        $this->db->join('finalidad fi', 'fi.id_finalidad = c.id_finalidad and fi.cod_tipo_fina = "2"');
        $this->db->join('tipo_lateralidad tl', 'tl.id_lateralidad = c.lateralidad');
        $this->db->join('ambito am', 'am.cod_ambi = c.cod_ambi');
        $this->db->where('c.id_paciente', $id_paciente);
        $this->db->where('c.cons_examen', $n_conexamen);
        $this->db->where('c.activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    
    public function silueta($identificacion, $tipo_docu, $cons_examen) {
        $data = array();
        $this->db->select('notes');
        $this->db->where('identificacion', $identificacion);
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('cons_examen', $cons_examen);
        $query = $this->db->get('pacientes_exa');

        if ($query->num_rows() > 0) {
            $res  = $query->row();
            $data = $res->notes;
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }
    
    public function pacienteconsulta()
    {
        $query = $this->db->get('pacientes');
        return $query;
    }  
    
    public function pacienteconsultatotal()
    {
        $this->db->count_all('pacientes');
        $query = $this->db->get();
        return $query;
        $query->free_result();
    }  
    
    public function pacienteconsulta1($limit, $offset)
    {
        $bnombre = $this->input->post('bnombre');
        $this->session->set_userdata('bnombre', $bnombre);
        $bnombre = $this->bnombre;
        $this->db->select();       
        $this->db->like('primer_nombre',$bnombre);
        $this->db->or_like('segundo_nombre',$bnombre);
        $this->db->or_like('primer_apellido',$bnombre);
        $this->db->or_like('segundo_apellido',$bnombre);
        $this->db->or_like('identificacion',$bnombre);
        $this->db->order_by('id_paciente');
        $query = $this->db->get('pacientes',$limit, $offset);
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }

    public function detallesexamen($cons_examen, $id_paciente) {

        $this->db->select('e.*, co.nombre_cons');
        $this->db->from('pacientes_exa e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons');    
        $this->db->where('e.id_paciente', $id_paciente);
        $this->db->where('e.cons_examen', $cons_examen);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    // notas de enfermeria
    public function insertExa_ne($m_ne, $n_conexamen)
    {
        // ACTUALIZA EL EXAMEN EN CONSECUTIVOS
        $cexamen = array(
            'numero_consecutivo' => $n_conexamen,
        );
        $this->db->where('cod_consecutivo', 7);
        $this->db->update('consecutivos', $cexamen);
        return $this->db->insert('pacientes_ne', $m_ne);
    } 

    public function ingresoConsAne($m_cons_anestesia, $n_conexamen)
    {
        // ACTUALIZA EL EXAMEN EN CONSECUTIVOS
        $cexamen = array(
            'numero_consecutivo' => $n_conexamen,
        );
        $this->db->where('cod_consecutivo', 7);
        $this->db->update('consecutivos', $cexamen);

        return $this->db->insert('consentimientos_asignados', $m_cons_anestesia);  
    }

    public function cons_cons_ane($id_paciente, $n_conexamen) 
    {

        $this->db->select();
        $this->db->from('consentimientos_asignados');    
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('cons_examen', $n_conexamen);  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function con_cons_ane($bd_id_con_asig) 
    {

        $this->db->select();
        $this->db->from('consentimientos_asignados');    
        $this->db->where('id_con_asig', $bd_id_con_asig);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function firma_medi($cod_medi)
    {
        $cadena = '';
        $this->db->select('firmamedi');
        $this->db->from('medicos');        
        $this->db->where('cod_medi', $cod_medi);
        $query = $this->db->get();
        //$cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena = $row['firmamedi'];            
        }
        echo $cadena; 
        $query->free_result(); 
    }

    public function firma_medi_exa($cod_medi)
    {
        $this->db->select('firmamedi');
        $this->db->from('medicos');        
        $this->db->where('cod_medi', $cod_medi);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    // consulta paciente con todos los campos en nombres largos no variablese
    public function cipaciente_v($id_paciente)
    {
        $this->db->select('p.*, td.nombre_tipo_docu, sx.nombre_sexo, pa.nombre_pais, de.nombre_depa, mu.nombre_muni,  
        ec.nombre_estado_civi, zr.nombre_zona_resi, tu.nombre_tipo_usua, c.nombre_admi');
        $this->db->from('pacientes p');
        $this->db->join('tipo_documento td', 'td.tipo_docu = p.tipo_docu');  
        $this->db->join('sexo sx', 'sx.sigla_sexo = p.sigla_sexo');
        $this->db->join('paises pa', 'pa.cod_pais = p.cod_pais');
        $this->db->join('departamento de', 'de.cod_pais = p.cod_pais AND de.id_depa = p.id_depa');
        $this->db->join('municipio mu', 'mu.cod_pais = p.cod_pais AND mu.id_depa = p.id_depa AND mu.id_muni = p.id_muni');
        $this->db->join('estadocivil ec', 'ec.cod_estado_civi = p.cod_estado_civi');
        $this->db->join('zona_residencia zr', 'zr.cod_zona_resi = p.cod_zona_resi');
        $this->db->join('tipo_usuario tu', 'tu.cod_tipo_usua = p.cod_tipo_usua');
        $this->db->join('contratistas c', 'c.id_contratistas = p.id_admi');
        
        $this->db->where('p.id_paciente', $id_paciente);              
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }

    public function prestador() {
        $this->db->select();
        $this->db->from('global');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function cons_cups($cod_cups)
    {
        $this->db->select();
        $this->db->from('cups');        
        $this->db->where('cod_cups', $cod_cups);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return false;
        }
        $query->free_result();      
    }

    public function insertNewCups($m_nuevo_cups)
    {
        // ingreso nuevo cups a la bd de cups
        return $this->db->insert('cups', $m_nuevo_cups);
        $this->db->close();
    }

    public function cons_id($cod_cups)
    {
        $this->db->select('id_cups');
        $this->db->from('cups');        
        $this->db->where('cod_cups', $cod_cups);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $row = $query->row();
            return $row->id_cups;
        }else
        {
            return false;
        }
        $query->free_result();
    }

    public function cimedicamentos($id_paciente, $n_conexamen) 
    {
        $this->db->select('p.*, m.cod_medicamento');
        $this->db->from('pacientes_med p');
        $this->db->join('medicamentos m', 'm.id_medicamento = p.id_medicamento', 'left outer');    
        $this->db->where('p.id_paciente', $id_paciente);
        $this->db->where('p.cons_examen', $n_conexamen);
        $this->db->where('p.activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function paraclinicos($id_paciente, $n_conexamen)
    {
        $this->db->select('p.*, l.detalle');
        $this->db->from('pacientes_para p');   
        $this->db->join('listaprecios l', 'l.cod_listap = p.cod_para', 'left outer');    
        $this->db->where('p.id_paciente', $id_paciente);
        $this->db->where('p.cons_examen', $n_conexamen);
        $this->db->where('p.activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function cons_medico($cod_medi)
    {
        $this->db->select('firmamedi');
        $this->db->from('medicos');
        $this->db->where('cod_medi', $cod_medi);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    // insertar medicamentos
    public function insertMedicamentos($data) 
    {
        return $this->db->insert('pacientes_med', $data);
    }

    // insertar paraclinicos
    public function insertPara($m_para, $n_conparaclinico)
    {
        // ACTUALIZA EL EXAMEN EN CONSECUTIVOS
        $cpara = array(
            'numero_consecutivo' => $n_conparaclinico,
        );

        $this->db->where('cod_consecutivo', 21);
        $this->db->update('consecutivos', $cpara);

        return $this->db->insert('pacientes_para', $m_para);
    }

    // actualizar historia clinica
    public function updateExa($examen, $n_conexamen)
    {                            
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('pacientes_exa', $examen); 
    }

    // actualiza los cie en cups activo = NO
    public function updateCIEActivo($m_cie_activo, $n_conexamen)
    {
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('ciecups', $m_cie_activo);    
    }

    // actualiza los medicamentos en cups activo = NO
    public function updateMEDActivo($m_med_activo, $n_conexamen)
    {
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('pacientes_med', $m_med_activo);    
    }

    // actualiza los medicamentos en cups activo = NO
    public function updatePARAActivo($m_para_activo, $n_conexamen)
    {
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('pacientes_para', $m_para_activo);    
    }

    

    // prequirurgicos carga todo
    public function cons_prequirurgicos()
    {
        $this->db->select("cod_listap, nombre_listap");
        $this->db->from('listaprecios');
        $this->db->where('cod_lptipo', '4');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    //  retina guardar
    public function insertExa_optret($data, $n_conexamen){
        // ACTUALIZA EL EXAMEN EN CONSECUTIVOS
        $cexamen = array(
            'numero_consecutivo' => $n_conexamen,
        );
        $this->db->where('cod_consecutivo', 7);
        $this->db->update('consecutivos', $cexamen);
        return $this->db->insert('pacientes_ret', $data);
    }

    // retina consultar
    public function ciexamen_optret($id_paciente, $n_conexamen) 
    {

        $this->db->select('e.*, co.nombre_cons, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi, con.nom_consultorio, ct.nombre_admi,
            lp.nombre_listap');
        $this->db->from('pacientes_ret e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons', 'left outer');   
        $this->db->join('medicos m', 'm.cod_medi = e.cod_medi', 'left outer');         
        $this->db->join('consultorios con', 'con.cod_consultorio = e.cod_consultorio', 'left outer');  
        $this->db->join('contratistas ct', 'ct.id_contratistas = e.id_admi', 'left outer');  
        $this->db->join('listaprecios lp', 'lp.cod_listap = e.tipo_co', 'left outer');  
        $this->db->where('e.id_paciente', $id_paciente);
        $this->db->where('e.cons_examen', $n_conexamen);  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    // retina consultar informes
    public function ciexamen_opret($id_paciente, $n_conexamen) 
    {

        $this->db->select('e.*, co.nombre_cons, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi, con.nom_consultorio, ct.nombre_admi,
            lp.nombre_listap');
        $this->db->from('pacientes_ret e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons', 'left outer');   
        $this->db->join('medicos m', 'm.cod_medi = e.cod_medi', 'left outer');         
        $this->db->join('consultorios con', 'con.cod_consultorio = e.cod_consultorio', 'left outer');  
        $this->db->join('contratistas ct', 'ct.id_contratistas = e.id_admi', 'left outer');  
        $this->db->join('listaprecios lp', 'lp.cod_listap = e.tipo_co', 'left outer');  
        $this->db->where('e.id_paciente', $id_paciente);
        $this->db->where('e.cons_examen', $n_conexamen);  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    // optometria cerrar
    public function cerrar_optometria($m_cerrar_opt, $n_conexamen)
    {
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('pacientes_opt', $m_cerrar_opt);   
    }
    
    // oftalmologia cerrar
    public function cerrar_oftalmologia($m_cerrar_oft, $n_conexamen)
    {
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('pacientes_exa', $m_cerrar_oft);   
    }

    // retinologia cerrar
    public function cerrar_retinologia($m_cerrar_optret, $n_conexamen)
    {
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('pacientes_ret', $m_cerrar_optret);   
    }

    // actualizar optometria
    public function updateExa_opt($examen, $n_conexamen)
    {
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('pacientes_opt', $examen);  
    }

    // actualizar optometria
    public function updateExa_optret($examen, $n_conexamen)
    {
        $this->db->where('cons_examen', $n_conexamen);
        $this->db->update('pacientes_ret', $examen);  
    }

    // consulta el medico de la cita 
    public function c_f_medico($n_cod_medi)
    {
        $this->db->select();
        $this->db->from('medicos');    
        $this->db->where('cod_medi', $n_cod_medi);  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    // consulta de informacion del clon de examen
    public function cons_abierta($id_paciente, $n_conexamen)
    {
        $this->db->select();
        $this->db->from('pacientes_exa');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('cons_examen', $n_conexamen);

        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();           
    }

    // retinologia abierta
    // consulta abierta optometria
    public function cons_abierta_retinologia($id_paciente, $n_conexamen)
    {
        $this->db->select();
        $this->db->from('pacientes_ret');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('cons_examen', $n_conexamen);

        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();           
    }

    // consulta de firma medico
    public function c_firma($cod_medi)
    {
        $this->db->select("firmamedi");
        $this->db->from('medicos');
        $this->db->where('cod_medi', $cod_medi);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result(); 
    }

    // consulta el con_examen de la tabla pacientes_exa
    function clon_paciente_exa($id_paciente, $c_num_oftalmologia)
    {
        $this->db->select("cons_examen");
        $this->db->from('pacientes_exa');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('num_oftalmologia', $c_num_oftalmologia);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();    
    }

    // consulta el con_examen de la tabla pacientes_exa
    function clon_paciente_ret($id_paciente, $c_num_retinologia)
    {
        $this->db->select("cons_examen");
        $this->db->from('pacientes_ret');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('num_retinologia', $c_num_retinologia);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();    
    }

}