<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Listaprecios_model extends CI_Model {
    public function __construct() {
        parent::__construct();        
    }

    public function consultaconsecutivo($numero) {
        $data = [];
        $this->db->select('numero_consecutivo');
        $this->db->where('cod_consecutivo', $numero);
        $query = $this->db->get('consecutivos');

        if ($query->num_rows() > 0) {
            $n    = $query->result();
            $data = (int) $n[0]->numero_consecutivo + 1;
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }    

    public function insertarprocedimiento ($nuevoitem, $numeroc)
    {
        // ACTUALIZA LA HISTORIA EN CONSECUTIVOS
        $chistoria = [
            'numero_consecutivo' => $numeroc,
        ];
        $this->db->where('cod_consecutivo', 11);
        $this->db->update('consecutivos', $chistoria);

        // INSERTA PACIENTE
        return $this->db->insert('listaprecios', $nuevoitem);
    }

    public function constipo() 
    {
        $this->db->select();
        $this->db->from('listaprecios_tipo');
        //$this->db->order_by('nombre_lptipo');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function consindice() 
    {
        $this->db->select();
        $this->db->from('listaprecios_indice');
        $this->db->order_by('nombre_lpindice');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function vmodificarprocedimiento($cod_listapm, $modificaritem) 
    {
        $this->db->where('cod_listap', $cod_listapm);
        $this->db->update('listaprecios', $modificaritem);
    }

    public function indicenuevo($nuevoindice, $numeroindice)
    {
        // ACTUALIZA LA HISTORIA EN CONSECUTIVOS
        $cindice = [
            'numero_consecutivo' => $numeroindice,
        ];
        $this->db->where('cod_consecutivo', 18);
        $this->db->update('consecutivos', $cindice);
        // INSERTA INDICE
        return $this->db->insert('listaprecios_indice', $nuevoindice);
    }

    public function modificarindice($cod_lpindice, $modindice)
    {
        $this->db->where('cod_lpindice', $cod_lpindice);
        $this->db->update('listaprecios_indice', $modindice);
    }

    public function tiponuevo($nuevotipo, $numerotipo)
    {
        // ACTUALIZA LA HISTORIA EN CONSECUTIVOS
        $ctipo = [
            'numero_consecutivo' => $numerotipo,
        ];
        $this->db->where('cod_consecutivo', 19);
        $this->db->update('consecutivos', $ctipo);

        // INSERTA INDICE
        return $this->db->insert('listaprecios_tipo', $nuevotipo);  
    }

    public function modificartipo($cod_lptipo, $modtipo)
    {
        $this->db->where('cod_lptipo', $cod_lptipo);
        $this->db->update('listaprecios_tipo', $modtipo);
    }

    public function paqueteencabezado($nuevopaquete)
    {
        // INSERTA ENCABEZADO PAQUETE
        return $this->db->insert('listaprecios_paquetes_e', $nuevopaquete);  
    }

    public function paqueactualizar($modpaquete, $mcod_listap)
    {
        $this->db->where('cod_listap', $mcod_listap);
        $this->db->update('listaprecios', $modpaquete);
    }

    public function paquetedetalles($nuevopaquetedetalles)
    {
        // INSERTA ENCABEZADO PAQUETE
        return $this->db->insert('listaprecios_paquetes', $nuevopaquetedetalles);     
    }

    public function consultapaquete($cod_listap)
    {
        $this->db->select('p.cod_listap, p.frecuencia, p.valor, lp.nombre_listap, t.nombre_lptipo');
        $this->db->from('listaprecios_paquetes p');
        $this->db->join('listaprecios lp', 'lp.cod_listap = p.cod_listap');
        $this->db->join('listaprecios_tipo t', 't.cod_lptipo = lp.cod_lptipo');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }   

    public function actuepaquete($codpaquete, $epaquete)
    {
        $this->db->where('cod_listap', $codpaquete);
        return $this->db->update('listaprecios_paquetes_e', $epaquete);
    }

    public function actudpaquete($codpaquete)
    {
        $this->db->where('cod_listapaquete', $codpaquete);
        $this->db->delete('listaprecios_paquetes'); 
    }

    // contratistas
    public function contratistas()
    {
        $this->db->select();
        $this->db->from('contratistas');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }
}