<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Odontograma_model extends CI_Model
{    
	public function __construct()
    {
        parent::__construct();
        $this->load->library('Session');
        $this->session_id = $this->session->userdata('login');
        $this->bnombre    = $this->session->userdata('bnombre');
             
    }	
    
    public function cielinea($sigla_sexo, $limiteedad)
    {
        $cadena = '';
        $this->db->distinct();
        $this->db->select('cl.*');
        $this->db->from('cie10_linea cl');
        $this->db->join("cie10 c","c.cod_cielinea = cl.cod_cielinea and (c.sexo = 'A' or c.sexo='$sigla_sexo') and (c.limite_inferior = '0' or c.limite_inferior = '000' or c.limite_inferior<='$limiteedad') and (c.limite_superior = '0' or c.limite_superior = '000' or c.limite_superior >= '$limiteedad') AND c.especialidad = 'ODO'");
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_cielinea']}'>{$row['cod_cielinea']} - {$row['nombre_cielinea']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
    }
    
    public function ciesublinea($cielinea, $sigla_sexo, $limiteedad)
    {
        $cadena = '';
        $this->db->distinct();
        $this->db->select('cs.*');
        $this->db->from('cie10_sublinea cs'); 
        $this->db->join("cie10 c", "c.cod_cielinea = cs.cod_cielinea and c.cod_ciesublinea = cs.cod_ciesublinea and (c.sexo = 'A' or c.sexo='$sigla_sexo') and (c.limite_inferior = '0' or c.limite_inferior = '000' or c.limite_inferior<='$limiteedad') and (c.limite_superior = '0' or c.limite_superior = '000' or c.limite_superior >= '$limiteedad') AND c.especialidad = 'ODO'");
        $this->db->where('cs.cod_cielinea', $cielinea);   
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_ciesublinea']}'>{$row['cod_ciesublinea']} - {$row['nombre_ciesublinea']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
    }
    
    public function ciecodigo($cielinea, $ciesublinea, $sigla_sexo, $limiteedad)
    {
        $cadena = '';
        $this->db->select('');
        $this->db->from('cie10');
        $this->db->where('cod_cielinea', $cielinea);
        $this->db->where('cod_ciesublinea', $ciesublinea);        
        $sexo = array('A', $sigla_sexo);
        $this->db->where_in('sexo', $sexo);
        $ledad = "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad) ";
        $this->db->where($ledad);
        $this->db->where('especialidad', 'ODO'); 
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_cie']}' cod_cie='{$row['cod_cie']}'>{$row['cod_cie']} - {$row['nombre_cie']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
    }
    
    public function ciecodigo1($ciesublinea)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('cie10');       
        $this->db->where('cod_ciesublinea', $ciesublinea);        
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_cie']}' cod_cie='{$row['cod_cie']}'>{$row['cod_cie']} - {$row['nombre_cie']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
    }
    
    public function ciecodigo2()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('cie10');
        $this->db->where('cod_ciesublinea', 'S02');
        $this->db->where('cod_cie', 'S025');        
        $this->db->or_where('cod_cie', 'S026');
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_cie']}' cod_cie='{$row['cod_cie']}'>{$row['cod_cie']} - {$row['nombre_cie']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
    }
    
    public function cupslinea()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('cups_linea');
        $this->db->where('cod_cupslinea', 'L6');
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione ...</option>";
        foreach($query->result_array() as $row)
        {
            $cadena.="<option value='{$row['cod_cupslinea']}'>{$row['cod_cupslinea']} - {$row['nombre_cupslinea']}</option>";
        }
        echo $cadena;
        $query->free_result();
    }
    
    public function cupssublinea($cupslinea)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('cups_sublinea');
        $this->db->where('cod_cupslinea', trim($cupslinea));
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione ...</option>";
        foreach($query->result_array() as $row)
        {
            $cadena.="<option value='{$row['cod_cupsublinea']}'>{$row['cod_cupsublinea']} - {$row['nombre_cupsublinea']}</option>";
        }
        echo $cadena;
        $query->free_result();
    }
    
    public function cupsgrupo($cupsublinea)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('cups_grupo');
        $this->db->where('cod_cupsublinea', $cupsublinea);
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione ...</option>";
        foreach($query->result_array() as $row)
        {
            $cadena.="<option value='{$row['cod_cupsgrupo']}'>{$row['cod_cupsgrupo']} - {$row['nombre_cupsgrupo']}</option>";
        }
        echo $cadena;
        $query->free_result();
    }
    
    public function cupscodigo($cupsgrupo)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('cups');
        $this->db->where('cod_cupsgrupo', $cupsgrupo);
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione ...</option>";
        foreach($query->result_array() as $row)
        {
            $cadena.="<option value='{$row['id_cups']}' cod_cupslinea='{$row['cod_cupslinea']}' cod_cupsublinea='{$row['cod_cupsublinea']}' cod_cupsgrupo='{$row['cod_cupsgrupo']}' cod_cups='{$row['cod_cups']}' cupsconcie='{$row['cupsconcie']}'>{$row['cod_cups']} - {$row['nombre_cups']}</option>";
        }
        echo $cadena;
        $query->free_result();
    }
    
    public function convencion()
    {        
        $this->db->select();
        $this->db->from('odontograma_convenciones');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();        
    }
    
    public function odon_proce()
    {
        $this->db->select();
        $this->db->from('odontograma_procedimiento');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function odoningreso1()
    {
        print_r($_POST['encabezado']);
        print_r($_POST['detalles']);
    }
    
    public function odoningreso()
    {
        //if(!empty($this->session_id))  
//		{
            if($this->input->post())
            {   
                //CONSECUTIVO DE ODONTOGRAMA
                $this->db->select();
                $this->db->from('consecutivos');
                $this->db->where('cod_consecutivo', 9);   
                $query1 = $this->db->get();
                $consodon = '';        
                foreach ($query1->result_array() as $row)
                {
                    $consodon = $row['numero_consecutivo'];
                    $consodon = $consodon + 1;
                }
                $consodon   =   $consodon;
                
                // CONSULTA DE COTIZACION EN CONSECUTIVOS
                $this->db->select();
                $this->db->from('consecutivos');
                $this->db->where('cod_consecutivo', 8);   
                $query2 = $this->db->get();
                $conscot = '';        
                foreach ($query2->result_array() as $row)
                {
                $conscot = $row['numero_consecutivo'];
                $conscot = $conscot + 1;
                }
                $conscot = $conscot;
                $num_odon   =   $consodon;
                    
                        
                    // RECORRER MATRIZ INFORMO QUE VIENE DE JSON
                    $dat = $this->input->post('encabezado');         
                    $dat = json_decode($dat);
                    if (is_array($dat)) 
                    {
                        foreach ($dat as $row => $val) 
                        { 
                            // VERIFICA SESSION
                            $histid                 =   trim($val->histid);
                            $histnombre             =   trim($val->histnombre);
                            $histlogin              =   trim($val->histlogin);
                            $histnivel              =   trim($val->histnivel);
                            $histcodpersona         =   trim($val->histcodpersona);
                            $gempnumero             =   trim($val->gempnumero);
                            $gempnombre             =   trim($val->gempnombre);
                            
                            
                            $vlogin =   $histlogin;
                            $this->db->select();
                            $this->db->from('usuarios');
                            $this->db->where('login', $vlogin);   
                            $query = $this->db->get();
                            if ($query->num_rows() <= 0)
                            {
                                $datos['error'] =   'Falta login';
                                $this->load->view('front_end/salidaerror', $datos); 
                            }
                            else
                            {
                                $identificacion     = trim($val->identificacion);    
                                $tipo_docu          = trim($val->tipo_docu);                                                   
                                $this->db->select();
                                $this->db->from('pacientes');
                                $this->db->where('identificacion', $identificacion);
                                $this->db->where('tipo_docu', $tipo_docu);
                                $query1 = $this->db->get();
                                foreach($query1->result_array() as $pac)
                                {                    
                                    //$identificacion         = $pac['identificacion']; 
                                    $fechan                 = $pac['fecha_de_nacimiento'];                   
                                }
                                //generando edad y unidad medida de la edad
                                date_default_timezone_set('America/Bogota');
                                $ma                     = 12;
                                //$fechan                 = $paci['fecha_de_nacimiento'];
                                $edadpaciente           = '';
                                $totaldiasmes           = '';
                                list($Y,$m,$d)          = explode("-",$fechan);            
                                $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
                                $edadpaciente           = intval($edadpaciente);
                                $mn                     = intval($m);  
                                $dn                     = intval($d);
                                $mesactual              = intval(date("m"));
                                $diaactual              = intval(date("d"));            
                                $mesanterior            = '';     
                                $anocomp                = '';     
                                $anoactual              = intval(date("Y")); 
                                $anon                   = $Y;
                                $ume                    = '';
                                          
                                if($mn == 2)
                                {
                                    $totaldiasmes = 28;
                                }
                                if($dn == 31)
                                {
                                    $dn = $dn - 1;
                                }
                                if($mn == 2 && $dn >= 29)
                                {
                                    $dn = 28;
                                }
                                //$edad = $edadpaciente;
                                
                                if($edadpaciente == 0)
                                {             
                                    //MESES ACTUALES DEL PACIENTE               
                                   
                                    if($mesactual == 1)
                                    {
                                        $mesanterior = 12;
                                    }                
                                    else
                                    {
                                        $mesanterior = $mesactual - 1;
                                    }
                                    
                                    if($mesanterior == $mn || $mn == $mesactual)
                                    {
                                        if($mn == $mesactual)
                                        {
                                            $edadresultado = $diaactual - $dn;
                                        }
                                        else
                                        {
                                            $edadresultado = $diaactual + 30 - $dn;
                                            
                                        }
                                        
                                        if($edadresultado >= 31)
                                        {
                                            $edad   = $mesactual - $mn;
                                            $ume    = 2;  
                                        }
                                        else
                                        {
                                            $edad = $edadresultado;
                                            $ume    = 3;
                                        }                    
                                    }
                                    else
                                    {
                                        $anocomp        = $anoactual - 1;
                                        if($anocomp == $anon)
                                        {
                                            $edad  = 12 - $mn + $mesactual;
                                            $ume    = 2;
                                        }
                                        else
                                        {
                                            $edad  = $mesactual - $mn;
                                            $ume    = 2;
                                        }
                                    }
                                }
                                else
                                {
                                    $edad   = $edadpaciente;
                                    $ume    = 1;
                                }
                                
                                $ref_procesos   =   trim($val->ref_procesos);
                                $identificacion =   trim($val->identificacion);
                                $valor_bruto    =   trim($val->valor_bruto);                    
                                $valor_total    =   trim($val->valor_total);
                                $fechaingreso   =   trim($val->fechaingreso);
                                $horaingreso    =   trim($val->horaingreso);
                                $version        =   trim($val->version);
                                $proceso_ref    =   trim($val->proceso_ref);
                                $cod_medi       =   trim($val->cod_medi);
                                $id_admi        =   trim($val->id_admi);
                                $cod_cons       =   trim($val->cod_cons);
                                
                                
                                if($ref_procesos == '')
                                {
                                    $datos['error'] =   'Falta el tipo de documento CT';
                                    $this->load->view('front_end/salidaerror', $datos); 
                                }else if($identificacion == '')
                                {
                                    $datos['error'] =   'Falta la identificación del paciente';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($valor_bruto == '')
                                {
                                    $datos['error'] =   'Falta el valor bruto de la cotización';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($valor_total == '')
                                {
                                    $datos['error'] =   'Falta el valor total de la cotización';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($fechaingreso == '')
                                {
                                    $datos['error'] =   'Falta la fecha de ingreso de la cotización';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($horaingreso == '')
                                {
                                    $datos['error'] =   'Falta la hora de ingreso de la cotización';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($version == '')
                                {
                                    $datos['error'] =   'Falta la versión de la cotización';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($proceso_ref == '')
                                {
                                    $datos['error'] =   'Falta el proceso referente OD de la cotización';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($cod_medi == '')
                                {
                                    $datos['error'] =   'Falta el código del prestador';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($id_admi == '')
                                {
                                    $datos['error'] =   'Falta la administradora';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($cod_cons == '')
                                {
                                    $datos['error'] =   'Falta el código de la consulta';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($conscot == '')
                                {
                                    $datos['error'] =   'Falta el número de la cotizacion';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($consodon == '')
                                {
                                    $datos['error'] =   'Falta el número del odontograma';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($tipo_docu == '')
                                {
                                    $datos['error'] =   'Falta el tipo de documento';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else
                                {
                                    // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: encabezado como cotizacion
                                    $coti = array(                    
                                    'ref_procesos'          =>  $ref_procesos,
                                    'numero_docu'           =>  $conscot,
                                    'identificacion_paci'   =>  $identificacion,
                                    'valor_bruto'           =>  $valor_bruto,
                                    'valor_total'           =>  $valor_total,
                                    'documento_ref'         =>  $consodon,
                                    'fechaingreso'          =>  $fechaingreso,
                                    'horaingreso'           =>  $horaingreso,
                                    'version'               =>  $version,
                                    'login_ing'             =>  $vlogin,
                                    'proceso_ref'           =>  $proceso_ref,
                                    'cod_medi'              =>  $cod_medi,
                                    'id_admi'               =>  $id_admi,
                                    'cod_cons'              =>  $cod_cons,   
                                    'tipo_docu'             =>  $tipo_docu             
                                    );
                                    
                                   // INSERTAR DATOS ENCABEZADO               
                                    $this->db->insert('encabezado', $coti);  
                                    
                                    // INSERTANDO DATOS EN ODONTOGRAMA
                                    $odon   =   array(
                                    'num_odon'          =>  $consodon,
                                    'num_cotizacion'    =>  $conscot,
                                    'identificacion'    =>  $identificacion,
                                    'id_admi'           =>  $id_admi,
                                    'cod_cons'          =>  $cod_cons,
                                    'login_ing'         =>  $vlogin,
                                    'fechaactual'       =>  $fechaingreso,
                                    'horaactual'        =>  $horaingreso,
                                    'edad'              =>  $edad,
                                    'ume'               =>  $ume,
                                    'tipo_docu'         =>  $tipo_docu,
                                    'cotizacion'        =>  $conscot,
                                    'cod_medi'          =>  $cod_medi,
                                    'valortotal'        =>  $valor_total,
                                    'version'           =>  $version,
                                    'tipo_docu'         =>  $tipo_docu     
                                    );
                                    // INSERTAR DATOS ENCABEZADO               
                                    $this->db->insert('odontograma_encabezado', $odon); 
                                    
                                    // INSERTANDO VERSIONES
                                    $versi= array(
                                    'version'       =>  $version,
                                    'num_odon'      =>  $consodon,
                                    'valortotal'    =>  $valor_total,
                                    'fecha'         =>  $fechaingreso,
                                    'hora'          =>  $horaingreso,
                                    'login_ing'     =>  $vlogin,
                                    'identificacion'=>  $identificacion,
                                    'cotizacion'    =>  $conscot,
                                    'cod_medi'      =>  $cod_medi, 
                                    'tipo_docu'     =>  $tipo_docu  
                                    );                        
                                     
                                    // INSERTAR DATOS odontograma_versiones               
                                    $this->db->insert('odontograma_versiones', $versi);
                                }    
                            }
                        }
                        
                        $datmv = $this->input->post('detalles'); // not 'items'        
                        $datmv = json_decode($datmv);
                        if (is_array($datmv)) 
                        {
                            foreach ($datmv as $key => $value) 
                            {            
                                $cod_pieza              =   trim($value->cod_pieza);
                                $cod_cara               =   trim($value->cod_cara);
                                $cod_convencion_odon    =   trim($value->cod_convencion_odon);
                                $nom_convencion_odon    =   trim($value->nom_convencion_odon);
                                $imagen_convencion_odon =   trim($value->imagen_convencion_odon);
                                $estado                 =   trim($value->estado);
                                $valorlistap            =   trim($value->valorlistap);
                                $fechaingreso           =   trim($value->fechaingreso);
                                $horaingreso            =   trim($value->horaingreso);
                                $version                =   trim($value->version);
                                $ref_procesos           =   trim($value->ref_procesos);
                                $proceso_ref            =   trim($value->proceso_ref);
                                $vcod_medi              =   trim($value->cod_medi);
                                $vid_admi               =   trim($value->id_admi);
                                $vcod_cons              =   trim($value->cod_cons);
                                $videntificacion        =   trim($value->identificacion);
                                $vtipo_docu             =   trim($value->tipo_docu); 
                                $histlogin              =   trim($value->histlogin);
                                
                                $vlogin                 =    $histlogin;
                                if($cod_pieza == '')
                                {
                                    $datos['error'] =   'Falta el código de la pieza';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($cod_cara == '')
                                {
                                    $datos['error'] =   'Falta el código de la cara';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($cod_convencion_odon == '')
                                {
                                    $datos['error'] =   'Falta el código de la convención';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($nom_convencion_odon == '')
                                {
                                    $datos['error'] =   'Falta el nombre de la convención';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($imagen_convencion_odon == '')
                                {
                                    $datos['error'] =   'Falta la imagen de la convención';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($estado == '')
                                {
                                    $datos['error'] =   'Falta el estado de la pieza';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($valorlistap == '')
                                {
                                    $datos['error'] =   'Falta el valor de la pieza';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($fechaingreso == '')
                                {
                                    $datos['error'] =   'Falta la fecha de ingreso';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($horaingreso == '')
                                {
                                    $datos['error'] =   'Falta la hora de ingreso';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($version == '')
                                {
                                    $datos['error'] =   'Falta la version';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($ref_procesos == '')
                                {
                                    $datos['error'] =   'Falta la referencia CT';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($proceso_ref == '')
                                {
                                    $datos['error'] =   'Falta el proceso OD';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($vcod_medi == '')
                                {
                                    $datos['error'] =   'Falta el código del médico';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($vid_admi == '')
                                {
                                    $datos['error'] =   'Falta la administradora';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($vcod_cons == '')
                                {
                                    $datos['error'] =   'Falta la consulta';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else if($videntificacion == '')
                                {
                                    $datos['error'] =   'Falta la identificación del paciente';
                                    $this->load->view('front_end/salidaerror', $datos);
                                }else
                                {
                                    // CREAR MATRIZ DE DATOS PARA INSERTAR EN TABLA : detalles                    
                                    $deta = array(
                                    'numero_docu'               =>  $conscot,
                                    'documento_ref'             =>  $consodon,
                                    'cod_pieza'                 =>  $cod_pieza,
                                    'cod_cara'                  =>  $cod_cara,
                                    'valorlistap'               =>  $valorlistap,   
                                    'nom_convencion_odon'       =>  $nom_convencion_odon,
                                    'fechaingreso'              =>  $fechaingreso,                    
                                    'horaingreso'               =>  $horaingreso,                    
                                    'version'                   =>  $version,
                                    'ref_procesos'              =>  $ref_procesos,
                                    'login_ing'                 =>  $vlogin,                    
                                    'proceso_ref'               =>  $proceso_ref,                    
                                    'cod_convencion_odon'       =>  $cod_convencion_odon,                    
                                    'imagen_convencion_odon'    =>  $imagen_convencion_odon,
                                    'estado'                    =>  $estado,                    
                                    'cod_medi'                  =>  $vcod_medi,                    
                                    'id_admi'                   =>  $vid_admi,                    
                                    'cod_cons'                  =>  $vcod_cons
                                    );
                                    
                                    // INSERTAR DATOS DETALLES ODONTOGRAMA
                                    $this->db->insert('detalles', $deta);                    
                                    
                                    //// CREAR MATRIZ DE DATOS PARA INSERTAR EN TABLA : odontograma_detalles                    
                                    $ododeta = array(
                                    'num_odon'                  =>  $consodon,                    
                                    'cod_pieza'                 =>  $cod_pieza,
                                    'cod_cara'                  =>  $cod_cara,                    
                                    'cod_cielinea'              =>  '',
                                    'cod_ciesublinea'           =>  '',
                                    'id_cie'                    =>  '',
                                    'cod_cie'                   =>  '',
                                    'nombre_cie'                =>  '',
                                    'cod_cupslinea'             =>  '',
                                    'cod_cupsublinea'           =>  '',
                                    'cod_cupsgrupo'             =>  '',
                                    'cod_cups'                  =>  '',
                                    'id_cups'                   =>  '',
                                    'nombre_cups'               =>  '',
                                    'valor_cie'                 =>  '',                    
                                    'valorlistap'               =>  $valorlistap,
                                    'observacionescie'          =>  '',
                                    'observacionescups'         =>  '',
                                    'cod_cielinear'             =>  '',
                                    'cod_ciesublinear'          =>  '',
                                    'id_cier'                   =>  '',
                                    'cod_cier'                  =>  '',
                                    'cod_fina_cie'              =>  '10',
                                    'cod_fina_cups'             =>  '12',
                                    'valor_total'               =>  $valorlistap,
                                    'cod_causa_dia'             =>  '13',
                                    'cod_tipo'                  =>  '2',
                                    'valor_cuota'               =>  '',
                                    'valor_subtotal'            =>  '',
                                    'cod_ambi'                  =>  '1', 
                                    'cod_actoq'                 =>  '1',
                                    'autorizacion'              =>  '',                    
                                    'texto_cielinea'            =>  '',
                                    'texto_ciesublinea'         =>  '',
                                    'texto_ciecodigo'           =>  '',
                                    'texto_cielinear'           =>  '',
                                    'texto_ciesublinear'        =>  '',
                                    'texto_ciecodigor'          =>  '',
                                    'texto_cupslinea'           =>  '',
                                    'texto_cupsublinea'         =>  '',
                                    'texto_cupsgrupo'           =>  '',
                                    'texto_cupscodigo'          =>  '',
                                    'nombre_cier'               =>  '',
                                    'cod_convencion_odon'       =>  $cod_convencion_odon,
                                    'nom_convencion_odon'       =>  $nom_convencion_odon,
                                    'ima_convencion_odon'       =>  $imagen_convencion_odon,
                                    'version'                   =>  $version,
                                    'estado'                    =>  $estado,                         
                                    'fechaingreso'              =>  $fechaingreso,                    
                                    'horaingreso'               =>  $horaingreso,                    
                                    'identificacion'            =>  $videntificacion,
                                    'num_cotizacion'            =>  $conscot,
                                    'id_admi'                   =>  $vid_admi,                    
                                    'cod_cons'                  =>  $vcod_cons,
                                    'login_ing'                 =>  $vlogin,
                                    'edad'                      =>  '',
                                    'ume'                       =>  '',
                                    'cotizacion'                =>  $conscot,
                                    'cod_medi'                  =>  $vcod_medi,
                                    'numfac'                    =>  '',
                                    'tipo_docu'                 =>  $vtipo_docu
                                    );
                                    
                                    // INSERTAR DATOS DETALLES ODONTOGRAMA
                                    $this->db->insert('odontograma_detalles', $ododeta);
                                }
                            }
                        }                        
                    }                            
                    // ACTUALIZANDO CONSECUTIVOS DE ODONTOGRAMA
                    $nconsodon = array(
                    'numero_consecutivo'    => $consodon
                    );
                    $this->db->where('cod_consecutivo', 9);
                    $this->db->update('consecutivos', $nconsodon);  
                    
                    // ACTUALIZANDO CONSECUTIVOS DE COTIZACIONES
                    $nconscoti = array(
                    'numero_consecutivo'    => $conscot
                    );
                    
                    $this->db->where('cod_consecutivo', 8);
                    $this->db->update('consecutivos', $nconscoti);                      
                    
                    $datos['conscot']       =   $conscot;
                    $datos['consodon']      =   $consodon;
                    $datos['ref_procesos']  =   $coti['ref_procesos'];
                    $datos['tipo_docu']     =   $coti['tipo_docu'];
                    $datos['cod_medi']      =   $coti['cod_medi'];
                    $datos['id_admi']       =   $coti['id_admi'];
                    $datos['cod_cons']      =   $coti['cod_cons'];     
                    $datos['identificacion']=   $coti['identificacion_paci'];
                    return $datos;   
          
                
                //else
//                {
//                    redirect(base_url().'usuarios/avisosesion', 301);	 
//                }
            }
            //else
//            {
//                redirect(base_url().'usuarios/avisosesion', 301);	 
//            }
        //}
        //else
//        {
//            redirect(base_url().'usuarios/avisosesion', 301);	 
//        }
        
        
    }
    
    public function cencabezado($numodon, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_encabezado');
        $this->db->where('num_odon', $numodon);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function cdetalles($numodon, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_detalles');
        $this->db->where('num_odon', $numodon);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    
    public function odonactualizar1()
    {
        //print_r($_POST['encabezado']);
//        print_r($_POST['detalles']);
    }
    
    public function odonactualizar()
    {        
        if($this->input->post())
        {                  
            $dat = $this->input->post('encabezado');         
            $dat = json_decode($dat);
            if (is_array($dat)) 
            {
                foreach ($dat as $row => $val) 
                {     
                    // VERIFICA SESSION
                    $vlogin         =   trim($val->histlogin);
                                        
                    $this->db->select();
                    $this->db->from('usuarios');
                    $this->db->where('login', $vlogin);   
                    $query = $this->db->get();
                    if ($query->num_rows() <= 0)
                    {
                        $datos['error'] =   'Falta login';
                        $this->load->view('front_end/salidaerror', $datos); 
                    }
                    else
                    {                        
                        $num_odon       =   trim($val->num_odon);                    
                        $identificacion =   trim($val->identificacion); 
                        $tipo_docu      =   trim($val->tipo_docu);
                        $this->db->select();
                        $this->db->from('pacientes');
                        $this->db->where('identificacion', $identificacion);
                        $this->db->where('tipo_docu', $tipo_docu);
                        $query1 = $this->db->get();
                        foreach($query1->result_array() as $pac)
                        {    
                            $fechan     =   $pac['fecha_de_nacimiento'];                   
                        }
                        //generando edad y unidad medida de la edad
                        date_default_timezone_set('America/Bogota');
                        $ma                     = 12;
                        //$fechan                 = $paci['fecha_de_nacimiento'];
                        $edadpaciente           = '';
                        $totaldiasmes           = '';
                        list($Y,$m,$d)          = explode("-",$fechan);            
                        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
                        $edadpaciente           = intval($edadpaciente);
                        $mn                     = intval($m);  
                        $dn                     = intval($d);
                        $mesactual              = intval(date("m"));
                        $diaactual              = intval(date("d"));            
                        $mesanterior            = '';     
                        $anocomp                = '';     
                        $anoactual              = intval(date("Y")); 
                        $anon                   = $Y;
                        $ume                    = '';
                                  
                        if($mn == 2)
                        {
                            $totaldiasmes = 28;
                        }
                        if($dn == 31)
                        {
                            $dn = $dn - 1;
                        }
                        if($mn == 2 && $dn >= 29)
                        {
                            $dn = 28;
                        }
                        //$edad = $edadpaciente;
                        
                        if($edadpaciente == 0)
                        {             
                            //MESES ACTUALES DEL PACIENTE               
                           
                            if($mesactual == 1)
                            {
                                $mesanterior = 12;
                            }                
                            else
                            {
                                $mesanterior = $mesactual - 1;
                            }
                            
                            if($mesanterior == $mn || $mn == $mesactual)
                            {
                                if($mn == $mesactual)
                                {
                                    $edadresultado = $diaactual - $dn;
                                }
                                else
                                {
                                    $edadresultado = $diaactual + 30 - $dn;
                                    
                                }
                                
                                if($edadresultado >= 31)
                                {
                                    $edad   = $mesactual - $mn;
                                    $ume    = 2;  
                                }
                                else
                                {
                                    $edad = $edadresultado;
                                    $ume    = 3;
                                }                    
                            }
                            else
                            {
                                $anocomp        = $anoactual - 1;
                                if($anocomp == $anon)
                                {
                                    $edad  = 12 - $mn + $mesactual;
                                    $ume    = 2;
                                }
                                else
                                {
                                    $edad  = $mesactual - $mn;
                                    $ume    = 2;
                                }
                            }
                        }
                        else
                        {
                            $edad   = $edadpaciente;
                            $ume    = 1;
                        }
                        
                        // VARIABLES
                        $cod_medi       =   trim($val->cod_medi);
                        $id_admi        =   trim($val->id_admi);
                        $cod_cons       =   trim($val->cod_cons);
                        $sist           =   trim($val->sist);
                        $diast          =   trim($val->diast);
                        $ppm            =   trim($val->ppm);
                        $rpm            =   trim($val->rpm);
                        $grados         =   trim($val->grados);
                        $altura         =   trim($val->altura);
                        $peso           =   trim($val->peso);
                        $imc            =   trim($val->imc);
                        $valortotal     =   trim($val->valortotal);
                        $version        =   trim($val->version);
                        $horamod        =   trim($val->horaactual);
                        $fechamod       =   trim($val->fechaactual);
                        $numero_docu    =   trim($val->numero_docu);
                        
                        
                        if($cod_medi == '')
                        {
                            $datos['error'] =   'Falta el código del médico';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($id_admi == '')
                        {
                            $datos['error'] =   'Falta la administradora';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_cons == '')
                        {
                            $datos['error'] =   'Falta el código de la consulta';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($valortotal == '')
                        {
                            $datos['error'] =   'Falta el valor total';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($version == '')
                        {
                            $datos['error'] =   'Falta la versión';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($num_odon == '')
                        {
                            $datos['error'] =   'Falta el número de odontograma';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($horamod == '')
                        {
                            $datos['error'] =   'Falta la hora de modificación';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($fechamod == '')
                        {
                            $datos['error'] =   'Falta la fecha de modificación';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($numero_docu == '')
                        {
                            $datos['error'] =   'Falta la cotización';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($tipo_docu == '')
                        {
                            $datos['error'] =   'Falta el tipo de documento';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else
                        {
                            // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: consulta_medica
                            $data = array(
                            'num_odon'          =>  $num_odon,
                            'num_cotizacion'    =>  $numero_docu,
                            'identificacion'    =>  $identificacion,
                            'id_admi'           =>  $id_admi,
                            'cod_cons'          =>  $cod_cons,
                            'sist'              =>  $sist,
                            'diast'             =>  $diast,
                            'ppm'               =>  $ppm,
                            'rpm'               =>  $rpm,
                            'grados'            =>  $grados,
                            'altura'            =>  $altura,
                            'peso'              =>  $peso,
                            'imc'               =>  $imc,
                            'edad'              =>  trim($edad),
                            'ume'               =>  trim($ume),
                            'version'           =>  $version,
                            'valortotal'        =>  $valortotal,
                            'horamod'           =>  $horamod,
                            'fechamod'          =>  $fechamod,
                            'loginmod'          =>  $vlogin,                     
                            'cotizacion'        =>  $numero_docu,
                            'cod_medi'          =>  $cod_medi,
                            'tipo_docu'         =>  $tipo_docu
                            );
                            
                           // ACTUALIZANDO DATOS ENCABEZADO               
                            $this->db->where('num_odon', $num_odon);
                            $this->db->update('odontograma_encabezado', $data); 
                            
                        
                            // AGREGANDO VERSION DE ODONTOGRAMA MODIFICADO
                            $dversion = array(
                            'version'           =>  $version,
                            'num_odon'          =>  $num_odon,
                            'valortotal'        =>  $valortotal,
                            'fecha'             =>  $fechamod,
                            'hora'              =>  $horamod,                    
                            'login_ing'         =>  $vlogin,
                            'identificacion'    =>  $identificacion,                
                            'cotizacion'        =>  $numero_docu,
                            'cod_medi'          =>  $cod_medi,
                            'tipo_docu'         =>  $tipo_docu  
                            ); 
                            
                            // INSERTAR DATOS VERSION               
                            $this->db->insert('odontograma_versiones', $dversion);
                            
                            // ACTUALIZANDO COTIZACIONES                
                            $datcotizacionenc = array(
                            'valor_bruto'       =>  $valortotal,
                            'valor_total'       =>  $valortotal,
                            'fechamodi'         =>  $fechamod,
                            'horamodi'          =>  $horamod,
                            'version'           =>  $version,   
                            'loginmod'          =>  $vlogin,
                            'cod_medi'          =>  $cod_medi,
                            'id_admi'           =>  $id_admi,
                            'cod_cons'          =>  $cod_cons,
                            'ref_procesos'      =>  'CT'                                 
                            );
                            
                           // ACTUALIZANDO DATOS ENCABEZADO               
                            $this->db->where('ref_procesos', 'CT');
                            $this->db->where('proceso_ref', 'OD');
                            $this->db->where('numero_docu', $numero_docu);
                            $this->db->where('documento_ref', $num_odon);
                            $this->db->update('encabezado', $datcotizacionenc); 
                            
                            // ELIMINANDO DATOS DE COTIZACIONES EN TABLA DETALLES
                            $this->db->where('ref_procesos', 'CT');
                            $this->db->where('proceso_ref', 'OD');
                            $this->db->where('numero_docu', $numero_docu);
                            $this->db->where('documento_ref', $num_odon);
                            $this->db->delete('detalles');
                        }
                    }
                }
                $this->db->select();
                $this->db->from('consecutivos');
                $this->db->where('cod_consecutivo', 2);   
                $query1 = $this->db->get();
                $consfact = '';        
                foreach ($query1->result_array() as $row)
                {
                    $consfact = $row['numero_consecutivo'];
                    $consfact = $consfact + 1;
                }
                $consfact   =   $consfact;
                
                $datmv = $this->input->post('detalles');         
                $datmv = json_decode($datmv);
                if (is_array($datmv)) 
                {
                    foreach ($datmv as $key => $value) 
                    {   
                        // CREAR MATRIZ DE DATOS PARA INSERTAR EN TABLA : consulta_medicaxtratamiento
                        $numodon                    =   trim($value->num_odon);                    
                        $cod_pieza                  =   trim($value->cod_pieza);                    
                        $cod_cara                   =   trim($value->cod_cara);
                        $cod_cielinea               =   trim($value->cod_cielinea);                    
                        $cod_ciesublinea            =   trim($value->cod_ciesublinea);                    
                        $id_cie                     =   trim($value->id_cie);                                     
                        $cod_cie                    =   trim($value->cod_cie);                      
                        $nombre_cie                 =   trim($value->nombre_cie); 
                        $cod_cupslinea              =   trim($value->cod_cupslinea);                    
                        $cod_cupsublinea            =   trim($value->cod_cupsublinea);                    
                        $cod_cupsgrupo              =   trim($value->cod_cupsgrupo);                    
                        $cod_cups                   =   trim($value->cod_cups);                    
                        $id_cups                    =   trim($value->id_cups);                    
                        $nombre_cups                =   trim($value->nombre_cups);                    
                        $valor_cie                  =   trim($value->valor_cie);                    
                        $valor_cups                 =   trim($value->valor_cups);                                        
                        $observacionescie           =   trim($value->observacionescie);                    
                        $observacionescups          =   trim($value->observacionescups);                    
                        $cod_cielinear              =   trim($value->cod_cielinear);                    
                        $cod_ciesublinear           =   trim($value->cod_ciesublinear);                                        
                        $id_cier                    =   trim($value->id_cier);                    
                        $cod_cier                   =   trim($value->cod_cier);                    
                        $cod_fina_cie               =   trim($value->cod_fina_cie);                    
                        $cod_fina_cups              =   trim($value->cod_fina_cups);                    
                        $valor_total                =   trim($value->valor_total);
                        $valorlistap                =   trim($value->valorlistap);                    
                        $cod_causa_dia              =   trim($value->cod_causa_dia);                    
                        $cod_tipo                   =   trim($value->cod_tipo);                    
                        $valor_cuota                =   trim($value->valor_cuota);                    
                        $valor_subtotal             =   trim($value->valor_subtotal);                    
                        $cod_ambi                   =   trim($value->cod_ambi);                    
                        $cod_actoq                  =   trim($value->cod_actoq);                    
                        $autorizacion               =   trim($value->autorizacion);                    
                        $texto_cielinea             =   trim($value->texto_cielinea);                    
                        $texto_ciesublinea          =   trim($value->texto_ciesublinea);                    
                        $texto_ciecodigo            =   trim($value->texto_ciecodigo);                    
                        $texto_cielinear            =   trim($value->texto_cielinear);                    
                        $texto_ciesublinear         =   trim($value->texto_ciesublinear);                    
                        $texto_ciecodigor           =   trim($value->texto_ciecodigor);                    
                        $texto_cupslinea            =   trim($value->texto_cupslinea);                    
                        $texto_cupsublinea          =   trim($value->texto_cupsublinea);                    
                        $texto_cupsgrupo            =   trim($value->texto_cupsgrupo);                    
                        $texto_cupscodigo           =   trim($value->texto_cupscodigo);                    
                        $nombre_cier                =   trim($value->nombre_cier);                                                    
                        $cod_convencion_odon        =   trim($value->cod_convencion_odon);                    
                        $nom_convencion_odon        =   trim($value->nom_convencion_odon);                    
                        $ima_convencion_odon        =   trim($value->ima_convencion_odon);                    
                        $version                    =   trim($value->version);
                        $fechaingreso               =   trim($value->fechaingreso);                            
                        $horaingreso                =   trim($value->horaingreso);                                        
                        $identificacion             =   trim($value->identificacion);                    
                        $num_cotizacion             =   trim($value->numero_docu);                    
                        $id_admi                    =   trim($value->id_admi);                    
                        $cod_cons                   =   trim($value->cod_cons);                    
                        $login_ing                  =   trim($value->histlogin);                    
                        $edad                       =   trim($edad);                    
                        $ume                        =   trim($ume);
                        $cotizacion                 =   trim($value->numero_docu);                    
                        $cod_medi                   =   trim($value->cod_medi);                    
                        $numfac                     =   trim($value->numfac);                    
                        $tipo_docu                  =   trim($value->tipo_docu);
                        
                        if($numodon == '')
                        {
                            $datos['error'] =   'Falta el número de odontograma';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_pieza == '')
                        {
                            $datos['error'] =   'Falta el código de la pieza';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_cara == '')
                        {
                            $datos['error'] =   'Falta el código de la cara';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_convencion_odon == '')
                        {
                            $datos['error'] =   'Falta el código de la convención';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($nom_convencion_odon == '')
                        {
                            $datos['error'] =   'Falta el nombre de la convención';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($ima_convencion_odon == '')
                        {
                            $datos['error'] =   'Falta la imagen de la convención';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($fechaingreso == '')
                        {
                            $datos['error'] =   'Falta la fecha de la evolución';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($horaingreso == '')
                        {
                            $datos['error'] =   'Falta la hora de la evolución';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($identificacion == '')
                        {
                            $datos['error'] =   'Falta la identificacion del paciente';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($num_cotizacion == '')
                        {
                            $datos['error'] =   'Falta el número de cotización';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($id_admi == '')
                        {
                            $datos['error'] =   'Falta el código de la administradora';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_cons == '')
                        {
                            $datos['error'] =   'Falta el código de la consulta';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($tipo_docu == '')
                        {
                            $datos['error'] =   'Falta el tipo de documento del paciente';
                            $this->load->view('front_end/salidaerror', $datos);
                        }
                        
                        if($cod_cups && $numfac == '')
                        {
                            $numfac         =   $consfact;                        
                            $consfact       =   $consfact + 1; 
                            $fechafactura   =   $fechaingreso;
                            $horafactura    =   $horaingreso;
                            // ACTUALIZANDO LA TABLA CONSECUTIVOS SECCION FACTURAS
                            $nconsfact = array(
                                'numero_consecutivo'    => $numfac
                            );
                            $this->db->where('cod_consecutivo', 2);
                            $this->db->update('consecutivos', $nconsfact);  
    //                        
    //                         //pendiente agregar la informacion a los rips
                        }
                        else
                        {
                            $numfac =   $numfac;
                            $fechafactura   =   '';
                            $horafactura    =   '';
                        }
                        
                        // ARRAY CON LOS DATOS DE LA TABLA ODONTOGRAMA_DETALLES
                        $datamv = array(
                        'num_odon'                  =>  $numodon,
                        'cod_pieza'                 =>  $cod_pieza,                    
                        'cod_cara'                  =>  $cod_cara,                                           
                        'cod_cielinea'              =>  $cod_cielinea,
                        'cod_ciesublinea'           =>  $cod_ciesublinea,
                        'id_cie'                    =>  $id_cie,
                        'cod_cie'                   =>  $cod_cie,
                        'nombre_cie'                =>  $nombre_cie,
                        'cod_cupslinea'             =>  $cod_cupslinea,
                        'cod_cupsublinea'           =>  $cod_cupsublinea,
                        'cod_cupsgrupo'             =>  $cod_cupsgrupo,
                        'cod_cups'                  =>  $cod_cups,
                        'id_cups'                   =>  $id_cups,
                        'nombre_cups'               =>  $nombre_cups,
                        'valor_cie'                 =>  $valor_cie,
                        'valor_cups'                =>  $valor_cups,
                        'observacionescie'          =>  $observacionescie,
                        'observacionescups'         =>  $observacionescups,
                        'cod_cielinear'             =>  $cod_cielinear,
                        'cod_ciesublinear'          =>  $cod_ciesublinear,
                        'id_cier'                   =>  $id_cier,
                        'cod_cier'                  =>  $cod_cier,
                        'cod_fina_cie'              =>  $cod_fina_cie,
                        'cod_fina_cups'             =>  $cod_fina_cups,
                        'valor_total'               =>  $valor_total,
                        'valorlistap'               =>  $valorlistap,
                        'cod_causa_dia'             =>  $cod_causa_dia,
                        'cod_tipo'                  =>  $cod_tipo,
                        'valor_cuota'               =>  $valor_cuota,
                        'valor_subtotal'            =>  $valor_subtotal,
                        'cod_ambi'                  =>  $cod_ambi, 
                        'cod_actoq'                 =>  $cod_actoq,
                        'autorizacion'              =>  $autorizacion,                    
                        'texto_cielinea'            =>  $texto_cielinea,
                        'texto_ciesublinea'         =>  $texto_ciesublinea,
                        'texto_ciecodigo'           =>  $texto_ciecodigo,
                        'texto_cielinear'           =>  $texto_cielinear,
                        'texto_ciesublinear'        =>  $texto_ciesublinear,
                        'texto_ciecodigor'          =>  $texto_ciecodigor,
                        'texto_cupslinea'           =>  $texto_cupslinea,
                        'texto_cupsublinea'         =>  $texto_cupsublinea,
                        'texto_cupsgrupo'           =>  $texto_cupsgrupo,
                        'texto_cupscodigo'          =>  $texto_cupscodigo,
                        'nombre_cier'               =>  $nombre_cier,
                        'cod_convencion_odon'       =>  $cod_convencion_odon,
                        'nom_convencion_odon'       =>  $nom_convencion_odon,
                        'ima_convencion_odon'       =>  $ima_convencion_odon,
                        'version'                   =>  $version,
                        'fechaingreso'              =>  $fechaingreso,
                        'horaingreso'               =>  $horaingreso,                    
                        'identificacion'            =>  $identificacion,
                        'num_cotizacion'            =>  $num_cotizacion,
                        'id_admi'                   =>  $id_admi,
                        'cod_cons'                  =>  $cod_cons,
                        'login_ing'                 =>  $login_ing,
                        'edad'                      =>  trim($edad),
                        'ume'                       =>  trim($ume),
                        'cotizacion'                =>  $cotizacion,                    
                        'cod_medi'                  =>  $cod_medi,
                        'numfac'                    =>  $numfac,
                        'fechafactura'              =>  $fechafactura,
                        'horafactura'               =>  $horafactura,
                        'tipo_docu'                 =>  $tipo_docu
                        );
                        
                        // INSERTAR DATOS DETALLES ODONTOGRAMA
                        $this->db->insert('odontograma_detalles', $datamv);
                        
                        // DATOS RETORNADOS AL CONTROLADOR
                        //$datos['version'] = $data['version'];
        //                $datos['numodon'] = $datamv['num_odon'];
        //                return $datos;
        
                          
                        
                        $datcotidetalles    =   array(
                        'numero_docu'               =>  $cotizacion,
                        'documento_ref'             =>  $numodon,                    
                        'cod_pieza'                 =>  $cod_pieza,
                        'cod_cara'                  =>  $cod_cara,
                        'nombre_cie'                =>  $nombre_cie,
                        'nombre_cups'               =>  $nombre_cups,
                        'valor_cie'                 =>  $valor_cie,
                        'valor_cups'                =>  $valor_cups,
                        'nom_convencion_odon'       =>  $nom_convencion_odon,
                        'fechaingreso'              =>  $fechaingreso,
                        'horaingreso'               =>  $horaingreso,
                        'login_ing'                 =>  $login_ing,
                        'version'                   =>  $version,
                        'ref_procesos'              =>  'CT',
                        'proceso_ref'               =>  'OD',
                        'cod_cups'                  =>  $cod_cups,
                        'cod_cupslinea'             =>  $cod_cupslinea,
                        'cod_cupsublinea'           =>  $cod_cupsublinea,
                        'cod_cupsgrupo'             =>  $cod_cupsgrupo,
                        'cod_convencion_odon'       =>  $cod_convencion_odon,
                        'imagen_convencion_odon'    =>  $ima_convencion_odon,
                        'cod_medi'                  =>  $cod_medi,
                        'id_admi'                   =>  $id_admi,
                        'cod_cons'                  =>  $cod_cons,
                        'numfac'                    =>  $numfac,
                        'valorlistap'               =>  $valorlistap
                        );   
                        
                        // INSERTAR EN TABLA DETALLES LOS DATOS DE LA COTIZACION
                        $this->db->insert('detalles', $datcotidetalles);
                    }        
                }
                
                $datos['num_odon']          =   $data['num_odon'];
                $datos['num_cotizacion']    =   $data['num_cotizacion'];
                $datos['version']           =   $data['version'];            
                $datos['fechamod']          =   $data['fechamod'];
                $datos['horamod']           =   $data['horamod'];
                $datos['valortotal']        =   $data['valortotal'];
                $datos['identificacion']    =   $data['identificacion'];
                $datos['cod_medi']          =   $data['cod_medi'];
                $datos['id_admi']           =   $data['id_admi'];
                $datos['cod_cons']          =   $data['cod_cons'];
                $datos['tipo_docu']         =   $data['tipo_docu'];
                $datos['ref_procesos']      =   $datcotizacionenc['ref_procesos'];
                return $datos;                          
                $query->free_result();
            }
            
            //else
//                {
//                    redirect(base_url().'usuarios/avisosesion', 301);	 
//                }
        }                            
            //else
//            {   
//                redirect(base_url().'usuarios/avisosesion', 301);	 
//            }
        //}
//        else
//        {
//            redirect(base_url().'usuarios/avisosesion', 301);	 
//        }
    }
    
    public function versionodontograma($id_paciente)
    {
        $this->db->select('v.*');
        $this->db->from('odontograma_versiones v');        
        $this->db->where('v.id_paciente', $id_paciente);
        $this->db->join('odontograma_encabezado o', 'o.version = v.version AND o.num_odon = v.num_odon');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();       
    }
    
    public function consultarodontograma($num_odon, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_detalles');
        $this->db->where('num_odon', $num_odon);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }
    
    public function consultarodontogramae($num_odon, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_detalles');
        $this->db->where('num_odon', $num_odon);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }
    
    public function consultaodontograma($num_odon)
    {
        $this->db->select();
        $this->db->from('odontograma_encabezado');
        $this->db->where('num_odon', $num_odon);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }
    
    public function consultodontograma($num_odon, $version)
    {        
        $this->db->select('od.*, me.primer_nombre_medi, me.segundo_nombre_medi, me.primer_apellido_medi, me.segundo_apellido_medi, co.nombre_cons');
        $this->db->from('odontograma_detalles od');
        $this->db->join('medicos me', 'od.cod_medi = me.cod_medi');
        $this->db->join('consulta co', 'co.cod_cons = od.cod_cons');
        $this->db->where('od.num_odon', $num_odon);
        $this->db->where('od.version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }
    
    public function verificarencabezado($num_odon, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_encabezado');        
        $this->db->where('num_odon', $num_odon);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
     
    public function verificardetalles($num_odon, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_detalles');        
        $this->db->where('num_odon', $num_odon);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function verificarversion($num_odon, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_versiones');        
        $this->db->where('num_odon', $num_odon);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function cpacienteodon($identificacion)
    {
        $this->db->select();
        $this->db->from('pacientes');        
        $this->db->where('identificacion', $identificacion);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function prestador()
    {
        $this->db->select();
        $this->db->from('global');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consulversion($numodon, $version) 
    {        
        $this->db->select();
        $this->db->from('odontograma_versiones');        
        $this->db->where('num_odon', $numodon);        
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }       
    
    public function consulpaciente($identificacion) 
    {        
        $this->db->select();
        $this->db->from('pacientes');        
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }  

    public function cotizacionenc($num_odon, $version)
    {
        $this->db->select();
        $this->db->from('encabezado');        
        $this->db->where('documento_ref', $num_odon);
        $this->db->where('version', $version);
        $this->db->where('ref_procesos', 'CT');
        $this->db->where('proceso_ref', 'OD');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function cotizaciondet($numodon, $version)
    {
        $this->db->select('cod_pieza, cod_cara, nombre_cups, nombre_cie, nom_convencion_odon, (valor_cie+valor_cups) as valor');
        $this->db->from('detalles');        
        $this->db->where('documento_ref', $numodon);
        $this->db->where('version', $version);
        $this->db->where('ref_procesos', 'CT');
        $this->db->where('proceso_ref', 'OD');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function datmedicos($cod_medi)
    {            
        $cadena = '';
        if($persona == 20)
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora');
            $this->db->from('medicos m');             
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');                  
            $query = $this->db->get();
            $cadena.="<option value=''>Seleccione Médico . . .</option>";
            foreach ($query->result_array() as $row)
            {
               $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }
            echo $cadena;
        }
        else
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora');
            $this->db->from('medicos m');            
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');     
            $this->db->where('m.id_usuario', $id_usuario);                 
            $query = $this->db->get();
            $cadena.="";
            foreach ($query->result_array() as $row)
            {
               $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }
            echo $cadena;     
        }
        $query->free_result(); 
    
    }
    
    public function consultacot($conscot, $consodon, $ref_procesos)
    {
        $this->db->select();
        $this->db->from('encabezado');
        $this->db->where('ref_procesos', $ref_procesos); 
        $this->db->where('numero_docu', $conscot)  ;     
        $this->db->where('documento_ref', $consodon);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }  
    
    public function consultadet($conscot, $consodon, $ref_procesos)
    {
        $this->db->select();
        $this->db->from('encabezado');
        $this->db->where('ref_procesos', $ref_procesos); 
        $this->db->where('numero_docu', $conscot)  ;     
        $this->db->where('documento_ref', $consodon);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }  
    
    public function consultaprestador()
    {
        $this->db->select();
        $this->db->from('global');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consultamedico($cod_medi)
    {
        $this->db->select();
        $this->db->from('medicos');  
        $this->db->where('cod_medi', $cod_medi);      
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consultaadmin($id_admi)
    {
        $this->db->select();
        $this->db->from('administradoras');  
        $this->db->where('id_admi', $id_admi);      
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consultacod_cons($cod_cons)
    {
        $this->db->select();
        $this->db->from('consulta');        
        $this->db->where('cod_cons', $cod_cons);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consultapaciente($identificacion, $tipo_docu)
    {
        $this->db->select();
        $this->db->from('pacientes'); 
        $this->db->where('identificacion', $identificacion);
        $this->db->where('tipo_docu', $tipo_docu);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function confinalidadcie($cod_fina, $cod_tipo_fina)
    {
        $nombre_fina    =   '';
        $this->db->select('nombre_fina');
        $this->db->from('finalidad'); 
        $this->db->where('id_finalidad', $cod_fina);       
        $this->db->where('cod_tipo_fina', $cod_tipo_fina);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $nombre_fina = "{$row['nombre_fina']}";
        }
        echo $nombre_fina;
        $query->free_result();
    }
    
    public function concausacie($cod_causa_dia)
    {
        $nombre_causa_dia    =   '';
        $this->db->select('nombre_causa_dia');
        $this->db->from('causa_diagnostico'); 
        $this->db->where('cod_causa_dia', $cod_causa_dia);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $nombre_causa_dia = "{$row['nombre_causa_dia']}";
        }
        echo $nombre_causa_dia;
        $query->free_result();
    }
    
    public function contipo($cod_tipo)
    {
        $nombre_tipo    =   '';
        $this->db->select('nombre_tipo');
        $this->db->from('tipo'); 
        $this->db->where('cod_tipo', $cod_tipo);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $nombre_tipo = "{$row['nombre_tipo']}";
        }
        echo $nombre_tipo;
        $query->free_result();
    }  
    
    public function confinalidadcups($ccod_fina_cups, $cod_tipo_fina_cups)
    {
        $nombre_fina    =   '';
        $this->db->select('nombre_fina');
        $this->db->from('finalidad'); 
        $this->db->where('id_finalidad', $ccod_fina_cups);       
        $this->db->where('cod_tipo_fina', $cod_tipo_fina_cups);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $nombre_fina = "{$row['nombre_fina']}";
        }
        echo $nombre_fina;
        $query->free_result();
    }
    
    public function conambitocups($cambitocupso)
    {
        $nombre_ambi    =   '';
        $this->db->select('nombre_ambi');
        $this->db->from('ambito'); 
        $this->db->where('cod_ambi', $cambitocupso);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $nombre_ambi = "{$row['nombre_ambi']}";
        }
        echo $nombre_ambi;
        $query->free_result();
    }  
    
    public function conactoq($cactoqcupso)
    {
        $nombre_actoq    =   '';
        $this->db->select('nombre_actoq');
        $this->db->from('actoquirurgico'); 
        $this->db->where('cod_actoq', $cactoqcupso);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $nombre_actoq = "{$row['nombre_actoq']}";
        }
        echo $nombre_actoq;
        $query->free_result();
    }
    
    public function regconsulta($tipo_docu, $numconsulta, $cotizacion, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_detalles');  
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('num_odon', $numconsulta);      
        $this->db->where('cotizacion', $cotizacion);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function regversion($tipo_docu, $numconsulta, $cotizacion, $version)
    {
        $this->db->select();
        $this->db->from('odontograma_versiones');  
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('num_odon', $numconsulta);      
        $this->db->where('cotizacion', $cotizacion);
        $this->db->where('version', $version);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    public function vinsertarprocedimiento($procedimiento, $nombre_convencion_odon, $valor)
    {   
        //if(!empty($this->session_id))  
		//{
            if($this->input->post())
            {       
                // CONSULTA CONSECUTIVO DE CONVENCIONES
                $this->db->select();
                $this->db->from('consecutivos');
                $this->db->where('cod_consecutivo', 11);   
                $query = $this->db->get();
                $conscon = '';        
                foreach ($query->result_array() as $row)
                {
                $conscon = $row['numero_consecutivo'];
                $conscon = $conscon + 1;
                } 
          
        
                
                if($procedimiento == '')
                {
                    $datos['error'] =   'Falta el código de procedimiento';
                    $this->load->view('front_end/salidaerror', $datos); 
                }else if($nombre_convencion_odon == '')
                {
                    $datos['error'] =   'Falta el nombre';
                    $this->load->view('front_end/salidaerror', $datos);
                }
                else if($valor == '')
                {
                    $datos['error'] =   'Falta el valor';
                    $this->load->view('front_end/salidaerror', $datos);
                }else
                {
                    $coti = array(                    
                    'cod_convencion_odon'       =>  $conscon,
                    'nombre_convencion_odon'    =>  $nombre_convencion_odon,
                    'imagen_convencion_odon'    =>  'img/muellita.png',
                    'valor'                     =>  $valor,
                    'tipo'                      =>  '2',
                    'procedimiento'             =>  $procedimiento
                    );
                    
                   // INSERTAR DATOS ENCABEZADO               
                    $this->db->insert('odontograma_convenciones', $coti);
                    
                    // ACTUALIZANDO CONSECUTIVOS DE PROCEDIMIENTOS
                    $nconscon = array(
                    'numero_consecutivo'    => $conscon
                    );
                    $this->db->where('cod_consecutivo', 11);
                    $this->db->update('consecutivos', $nconscon);  
                                        
                    $this->db->select();
                    $this->db->from('odontograma_convenciones');        
                    $this->db->where('cod_convencion_odon', $conscon);
                    $query2 = $this->db->get();
                    if($query2->num_rows() > 0)
                    {
                        return $query2->result_array();
                    }else
                    {
                        return false;
                    }
                    $query2->free_result();
                                        
                }
            $query->free_result();
            }
        //}    
    }   
    
    public function actualizarfirma($tipo_docu, $identificacion, $num_odon, $version, $cotizacion)
    {
        //if(!empty($this->session_id))  
		//{
            if($this->input->post())
            { 
                //$firma          =   'image/jsignature;base30'.','. $firma;
            
                $nfirma = array(
                'signature'    => '222'
                );
                
                $this->db->where('tipo_docu', $tipo_docu);
                $this->db->where('identificacion', $identificacion);
                $this->db->where('num_odon', $num_odon);
                $this->db->where('version', $version);
                $this->db->where('cotizacion', $cotizacion);
                $this->db->update('odontograma_versiones', $nfirma);
            }
        //}
    }   
    
    public function generarp($tipo_docu, $identificacion, $num_odon, $version, $cotizacion, $rutafirma)
    {
       // if(!empty($this->session_id))  
		//{
            if($this->input->post())
            { 
                $rfirma = array(
                'rutafirma'    => $rutafirma
                );
                
                $this->db->where('tipo_docu', $tipo_docu);
                $this->db->where('identificacion', $identificacion);
                $this->db->where('num_odon', $num_odon);
                $this->db->where('version', $version);
                $this->db->where('cotizacion', $cotizacion);
                $this->db->update('odontograma_versiones', $rfirma);
            }
        //}
    }
    
    public function resumenevolucion($tipo_docu,$identificacion,$num_cotizacion,$num_odon,$version)
    {
        $this->db->select('od.*, me.primer_nombre_medi, me.segundo_nombre_medi, me.primer_apellido_medi, me.segundo_apellido_medi, co.nombre_cons');
        $this->db->from('odontograma_detalles od');
        $this->db->join('medicos me', 'od.cod_medi = me.cod_medi');
        $this->db->join('consulta co', 'co.cod_cons = od.cod_cons');
        $this->db->where('od.num_odon', $num_odon);
        $this->db->where('od.version', $version);
        $this->db->where('od.tipo_docu', $tipo_docu);
        $this->db->where('od.identificacion', $identificacion);
        $this->db->where('od.num_cotizacion', $num_cotizacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();        
    }
    
    public function resumenversion($tipo_docu,$identificacion,$num_cotizacion,$num_odon,$version)
    {
        $this->db->select();
        $this->db->from('odontograma_versiones');
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion', $identificacion);
        $this->db->where('num_odon', $num_odon);
        $this->db->where('version', $version);
        $this->db->where('cotizacion', $num_cotizacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();        
    }  
}