<!-- TITULO -->
<div class="well well-sm text-center titulo">
    <h4><strong class="text-info">Consulta abonos</strong></h4>
</div>

<!-- TABLA COTIZACIONES -->
<div class="consultacotizaciones" id="consultacotizaciones">
        <div class="table-responsive">
            <table class="table table-bordered" cellspacing="0" width="100%" id="tabonos">
                <thead> 
                    <tr>
                        <th class="text-center">Doc.</th>
                        <th class="text-center"># Abono</th>
                        <th class="hide text-center">Identificación</th>
                        <th class="text-center">Cotización</th>
                        <th class="text-center">Valor Total</th>   
                        <th class="text-center">Fecha</th><strong></strong>
                        <th class="hide text-center">codmedi</th>
                    </tr>
                  </thead>
                
                <tbody>
                
                </tbody>
            </table>    
        </div>
        <div class="clearfix"></div>
</div>
<div class="detalleabono"></div>

<script type = "text/javascript">
$(function() 
{ 
    //$('.detalleabono').hide();

// CARGANDO INFORMACION A LA CONSULTA DE COTIZACIONES
    var identificacion      =   $('.identificacion').val();
    var cod_medi            =   $('.medico').find('option:selected').attr('cod_medi');
    
    var oTable = $('#tabonos').dataTable            
    ({
        "sServerMethod": "POST",  
        "bProcessing": true,
        "bServerSide": false, 
        "sAjaxSource": '<?php echo base_url();?>1historias/abono/consultaabonocan',
        "bJQueryUI": true,
        "searching":  false,                
        "sPaginationType": "full_numbers",
        "iDisplayStart ": 20,
        "columns": [  
               { "sClass": "text-center","data": "ref_procesos" },  
               { "sClass": "text-center","data": "numero_docu" },
               { "sClass": "hide text-center","data": "identificacion_paci" },
               { "sClass": "text-center","data": "documento_ref" },
               { "sClass": "text-right","data": "valor_total" },
               { "sClass": "text-right","data": "fechaingreso" },
               { "sClass": "hide text-right","data": "cod_medi" }                                                                            
           ],
       "columnDefs": [ 
            {
                "aTargets": [4],
                "fnCreatedCell": function (nTd, sData, oData, iRow, iCol) 
                {
                    var $currencyCell = $(nTd);
                    var commaValue = $currencyCell.text().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1.");
                    $currencyCell.text(commaValue);
                }
            }],
        "oLanguage": {
            "sProcessing": "<img src='<?php echo base_url('img/leyendo.gif');?>'>"                   
        },
        "fnInitComplete": function () {
            //oTable.fnAdjustColumnSizing();
        },        
        'fnServerData': function (sSource, aoData, fnCallback) {
            $.ajax
            ({
                'dataType': 'json',
                'type': 'POST',
                'url': sSource,
                'data': {identificacion:identificacion, cod_medi:cod_medi},
                'success': fnCallback
            });
        },
        "bRetrieve": true
    });
    
    // SELECCIÓN DE UN REGISTRO EN LA TABLA
    $('#tabonos tbody').on('click', 'tr', function () 
    {
        var numero_docu     =   $('td', this).eq(1).text();
        var documento_ref   =   $('td', this).eq(3).text();
        var ref_procesos    =   $('td', this).eq(0).text();
        var fechaabo        =   $('td', this).eq(5).text();
        var valort          =   $('td', this).eq(4).text().replace(/\./g,'');
        var proceso         =   '2';
        
        
        if(ref_procesos == 'No se han encontrado datos')
        {
            return false;
        }else
        {
            $.ajax(
            {
                url: '<?php echo base_url();?>1historias/abono/consuldetallesabo',       
                type: 'POST',                    
                data: {numero_docu:numero_docu, documento_ref:documento_ref, ref_procesos:ref_procesos, fechaabo:fechaabo, valort:valort, proceso:proceso},
                success: function(data)
                {
                    $(".detalleabono").html(data);
                    $('.consultacotizaciones').hide();
                }
            });
        }
    } );
    
    // MOUSE SOBRE UN REGISTRO DE LA TABLA
    $('#tabonos tbody').on('mouseover', 'tr', function () {
        $(this).css('background-color','yellow');
    } );
    
    // MOUSE SALIENDO DEL REGISTRO EN LA TABLA
    $('#tabonos tbody').on('mouseout', 'tr', function () {
        $(this).css('background-color','white');
    } );
});



</script>