<label>Modulo de rips</label>
<div class="table-responsive">
    <table class="table table-bordered">
        <tbody>
            <tr>
                <td>
                    <label>Periodo a procesar</label>
                </td>
                <td>
                    <label>Fecha inicial</label>
                </td>
                <td>
                    <div id="datetimepicker1" class="input-append date">
                        <h5>Fecha inicial (AAAA-MM-DD)
                            <input  size="10" data-format="yyyy-MM-dd" type="text" class="input-sm fechainicial" id="fechainicial" name="fechainicial" value="" />
                        </h5>
                    </div>                                        
                </td>
                <td>
                    <label>Fecha final</label>
                </td>
                <td>
                    <div id="datetimepicker2" class="input-append date">
                        <h5>Fecha final (AAAA-MM-DD)                
                            <input  size="10" data-format="yyyy-MM-dd" type="text" class="input-sm fechafinal" id="fechafinal" name="fechafinal" value=""  />
                        </h5>
                    </div>                                    
                </td>
                <td>
                    <a href="#" class="btn btn-info btnconsultar">Generar proceso</a>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<div class="clearfix"></div>
<div class="consultagenerada"></div>

        



<script type = "text/javascript">
$(function() 
{  
    $('.mensajeespera').hide();
    
    // FECHA INCIAL
    jQuery.datetimepicker.setLocale('es');
    $('#fechainicial').datetimepicker(
    {
    	timepicker:false,
    	format:'Y-m-d',
    	formatDate:'Y-m-d',
    	formatDate:'d.m.Y',	
    	defaultDate:'+01.01.1970',
        i18n: {es: { // Spanish
				months: [
					"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
				],
				dayOfWeekShort: [
					"Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"
				],
				dayOfWeek: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"]
			}}
    })
    
    // FECHA FINAL
    jQuery.datetimepicker.setLocale('es');
    $('#fechafinal').datetimepicker(
    {
    	timepicker:false,
    	format:'Y-m-d',
    	formatDate:'Y-m-d',
    	formatDate:'d.m.Y',	
    	defaultDate:'+01.01.1970',
        i18n: {es: { // Spanish
				months: [
					"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
				],
				dayOfWeekShort: [
					"Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"
				],
				dayOfWeek: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"]
			}}
    })
    
    // GENERAR CONSULTA DE ESTERILIZACION
    $('.btnconsultar').on('click', function()
    {
        var fechainicial    =   $('.fechainicial').val()
        var fechafinal      =   $('.fechafinal').val()
        if(!fechainicial)
        {
            $('.errorconsulta').html('<div class="alert alert-danger" id="alerta" role="alert"><img src="<?php echo base_url('img/mensaje_error_dato.png');?>" /> <strong>Error en campo fecha inicial</strong><p>no puede estar vacio, por favor verifique</p></div>');
            return false;
        }else
        {
            $('.errorconsulta').html('');
            if(!fechafinal)
            {
                $('.errorconsulta').html('<div class="alert alert-danger" id="alerta" role="alert"><img src="<?php echo base_url('img/mensaje_error_dato.png');?>" /> <strong>Error en campo fecha final</strong><p>no puede estar vacio, por favor verifique</p></div>');
                return false;
            }else
            {
                $('.errorconsulta').html('');
                cargaconsulta(fechainicial, fechafinal)                
            }
        }    
    });
});

function cargaconsulta(fechainicial, fechafinal)
{   
    $.ajax(
    {
        url: '<?php echo base_url();?>3rips/rips/consulta',
        type: 'POST',                    
        data:{fechainicial:fechainicial, fechafinal:fechafinal},                                       
        success: function(data)
        {   
            $('.consultagenerada').html(data);                            
        } 
    });
}
</script>