<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Contratista extends CI_Controller {
    
    //private $session_id, $session_nombre, $nivel_usuario;     
    public function __construct()
    {
        parent::__construct();        
        $this->load->library('Datatables');        
    }
   
    public function index()
    {   
        $this->load->model('contratista_model');
        $datos['administradoras']   =   $this->contratista_model->administradoras();
        $datos['contratistas']      =   $this->contratista_model->contratistas();
        $datos['convenio']          =   $this->contratista_model->convenio();

        $this->load->view('front_end/historias/contratista_v', $datos);
    }
    
    
    public function nuevocontratista()
    {
        $this->load->model('contratista_model');

        $contratista = array(
            'id_admi'       => $this->input->post('codigo', true),
            'nombre_admi'   => strtoupper($this->input->post('nombre', true)),
            'nit'           => $this->input->post('nit', true),
            'aplica_copago' => $this->input->post('aplica_copago', true),
            'porc_copago'   => $this->input->post('porc_copago', true),
            'activo'        => 'SI' 
        );

        $inserContratista = $this->contratista_model->ingresocontratista($contratista);
       
        $datos['administradoras']   =   $this->contratista_model->administradoras();
        $datos['contratistas']      =   $this->contratista_model->contratistas();
        $datos['convenio']          =   $this->contratista_model->convenio();

        $this->load->view('front_end/historias/contratista_v', $datos);
        
    }

    public function actualizandocontratista()
    {
        $this->load->model('contratista_model');
        $id_contratistas    =   $this->input->post('nbd_id_contratistas');

        $contratista = array(
            'id_admi'       => $this->input->post('ncodigo', true),
            'nombre_admi'   => strtoupper($this->input->post('nnombre', true)),
            'nit'           => $this->input->post('nnit', true),
            'activo'        => $this->input->post('activo', true)
        );

        $inserContratista = $this->contratista_model->actualizarcontratista($id_contratistas, $contratista);

        $datos['administradoras']   =   $this->contratista_model->administradoras();
        $datos['contratistas']      =   $this->contratista_model->contratistas();
        $datos['convenio']          =   $this->contratista_model->convenio();

        $this->load->view('front_end/historias/contratista_v', $datos);
    }

    public function c_id_cups()
    {
        $this->load->model('contratista_model');
        $id_contratistas        =   $this->input->post('c_id_contratistas');
        $datos['con_cups']      =   $this->contratista_model->con_cups($id_contratistas);

        $this->load->view('front_end/historias/contratista_c_v', $datos);
    }

    public function busquedacups()
    {        
        $opbuscarcups       =   trim($this->input->post('opbuscarcups', true));
        $abuscar            =   trim($this->input->post('abuscar', true));
        
        if($opbuscarcups == 'codigo')
        {
            $this->datatables->select("cod_cups, nombre_cups, sexo, limite_inferior,limite_superior, cupsmaxvecesdia,cupsmaxvecesvida,cupstiempolimitedias,cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
            ->from('cups');
             
            $this->db->like("cod_cups", $abuscar);                                            

        }else if($opbuscarcups == 'descripcion')
        {
            $this->datatables->select("cod_cups, nombre_cups, sexo, limite_inferior,limite_superior, cupsmaxvecesdia,cupsmaxvecesvida,cupstiempolimitedias,cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
            ->from('cups');
            
            $this->db->like("nombre_cups", $abuscar);                    
        }    
        
        echo $this->datatables->generate();         
    }

    public function cups_contrato()
    {
        $this->load->model('contratista_model');

        // id del contratista
        $id_contratistas            =   $this->input->post('id_contratistas');
        
        // matriz de los cups de los contratos
        for ($i = 0; $i < count($this->input->post('id_contratistas')); $i++) 
        {
            $v_id_cups  =               $this->input->post('id_cups')[$i];
            if($v_id_cups == 0)
            {
                $o_detalles_n = array(
                    'id_contratistas'       =>  $this->input->post('id_contratistas')[$i],
                    'cod_cups'              =>  $this->input->post('cod_cups', true)[$i],
                    'nombre_cups'           =>  strtoupper($this->input->post('nombre_cups', true)[$i]),
                    'sexo'                  =>  $this->input->post('sexo', true)[$i],                    
                    'limite_inferior'       =>  $this->input->post('limite_inferior', true)[$i],
                    'limite_superior'       =>  $this->input->post('limite_superior', true)[$i],
                    'cupsmaxvecesdia'       =>  $this->input->post('cupsmaxvecesdia', true)[$i],
                    'cupsmaxvecesvida'      =>  $this->input->post('cupsmaxvecesvida', true)[$i],
                    'cupstiempolimitedias'  =>  $this->input->post('cupstiempolimitedias', true)[$i],
                    'cupsconcie'            =>  $this->input->post('cupsconcie', true)[$i],
                    'cupstipoatencion'      =>  $this->input->post('cupstipoatencion', true)[$i],
                    'cupstipoprocedimiento' =>  $this->input->post('cupstipoprocedimiento', true)[$i],
                    'cod_cups_tipopro'      =>  $this->input->post('cod_cups_tipopro', true)[$i],
                    'valor'                 =>  $this->input->post('valor', true)[$i],
                    'activo'                =>  $this->input->post('activo', true)[$i]
                );
                //var_dump($o_detalles_n);
                //exit();

                $this->contratista_model->insertDetalles($o_detalles_n);
            }else
            {
                $id_cups                    =   $this->input->post('id_cups', true)[$i];
                $o_detalles = array(
                    'cod_cups'              =>  $this->input->post('cod_cups', true)[$i],
                    'nombre_cups'           =>  strtoupper($this->input->post('nombre_cups', true)[$i]),
                    'sexo'                  =>  $this->input->post('sexo', true)[$i],                    
                    'limite_inferior'       =>  $this->input->post('limite_inferior', true)[$i],
                    'limite_superior'       =>  $this->input->post('limite_superior', true)[$i],
                    'cupsmaxvecesdia'       =>  $this->input->post('cupsmaxvecesdia', true)[$i],
                    'cupsmaxvecesvida'      =>  $this->input->post('cupsmaxvecesvida', true)[$i],
                    'cupstiempolimitedias'  =>  $this->input->post('cupstiempolimitedias', true)[$i],
                    'cupsconcie'            =>  $this->input->post('cupsconcie', true)[$i],
                    'cupstipoatencion'      =>  $this->input->post('cupstipoatencion', true)[$i],
                    'cupstipoprocedimiento' =>  $this->input->post('cupstipoprocedimiento', true)[$i],
                    'cod_cups_tipopro'      =>  $this->input->post('cod_cups_tipopro', true)[$i],
                    'valor'                 =>  $this->input->post('valor', true)[$i],
                    'activo'                =>  $this->input->post('activo', true)[$i]
                );
                //var_dump($o_detalles);
                //exit();

                $this->contratista_model->updateDetalles($o_detalles, $id_cups);
            }
            
        }

        //$datos['administradoras']   =   $this->contratista_model->administradoras();
        //$datos['contratistas']      =   $this->contratista_model->contratistas();
        //$datos['convenio']          =   $this->contratista_model->convenio();
        //$this->load->view('front_end/historias/contratista_v', $datos);

    }

    public function resumengenbusqueda() 
    {
        $this->db->trans_start();
        $id_contratistas        =   $this->input->post('id_contratistas');
        $this->datatables->select('id_cups, id_contratistas, cod_cups, nombre_cups, sexo, limite_inferior, limite_superior, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias, cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor ')
            ->from('contratistas_cups');
        $this->db->where('id_contratistas', $id_contratistas);
        $this->db->where('activo', 'SI');

        echo $this->datatables->generate();
        $this->db->trans_complete();
    }

    public function nuevocups()
    {
        $this->load->model('contratista_model');

        $cod_cups               =   $this->input->post('codigo_cups', true);
        $nombre_cups            =   strtoupper($this->input->post('nombre_cups', true));
        $sexo                   =   'A';
        $limite_inferior        =   0;
        $limite_superior        =   599;
        $cupsmaxvecesdia        =   '1';
        $cupsmaxvecesvida       =   '';
        $cupstiempolimitedias   =   '';
        $cupsconcie             =   'S';
        $cupstipoatencion       =   'AP';
        $cupstipoprocedimiento  =   'Cirugía';
        $cod_cups_tipopro       =   '1';
        $valor                  =   0;
        $nuevo_manual           =   'SI';

        $m_nuevo_cups           =   array(
            'cod_cups'              =>   $cod_cups,
            'nombre_cups'           =>   $nombre_cups,
            'sexo'                  =>   $sexo,
            'limite_inferior'       =>   $limite_inferior,
            'limite_superior'       =>   $limite_superior,
            'cupsmaxvecesdia'       =>   $cupsmaxvecesdia,
            'cupsmaxvecesvida'      =>   $cupsmaxvecesvida,
            'cupstiempolimitedias'  =>   $cupstiempolimitedias,
            'cupsconcie'            =>   $cupsconcie,
            'cupstipoatencion'      =>   $cupstipoatencion,
            'cupstipoprocedimiento' =>   $cupstipoprocedimiento,
            'cod_cups_tipopro'      =>   $cod_cups_tipopro,
            'valor'                 =>   $valor,
            'nuevo_manual'          =>   $nuevo_manual
        );

        $insertNewCups  =   $this->contratista_model->insertNewCups($m_nuevo_cups);
        $cons_id        =   $this->contratista_model->cons_id($cod_cups);
        
        echo $cons_id;

    }

    public function validacups()
    {
        $this->load->model('contratista_model');

        $cod_cups           =   trim($this->input->post('bd_cod_cups', true));
        $id_contratista     =   trim($this->input->post('v_id_contratista', true));
        
        $cons_cups         =   $this->contratista_model->cons_cups($cod_cups, $id_contratista);
        echo $cons_cups;
    }

    public function validacups_general()
    {
        $this->load->model('contratista_model');

        $cod_cups           =   trim($this->input->post('bd_cod_cups', true));
        
        $cons_cups         =   $this->contratista_model->cons_cups_general($cod_cups);
        echo $cons_cups;
    }

}  