<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');
class Pacienteconsulta extends CI_Controller 
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper(array('download', 'file')); 
        $this->load->library('pdf');
        $this->load->helper(array('url'));
        $this->load->library('Datatables');        
    }
    public function index()
    {
        $this->load->model('historia_model');
        $modulo                 =   $this->input->post('modulo', true);
        $histid                 =   $this->input->post('histid', true);
        $histnombre             =   $this->input->post('histnombre', true);
        $histlogin              =   $this->input->post('histlogin', true);
        $histnivel              =   $this->input->post('histnivel', true);
        $histcodpersona         =   $this->input->post('histcodpersona', true);
        $gempnumero             =   $this->input->post('gempnumero', true);
        $gempnombre             =   $this->input->post('gempnombre', true);
         
        $session_nivel_usuario  =   $histnivel;
        $xdef                   =   $this->historia_model->xdef($modulo, $histnivel);
        foreach($xdef as $row)
        {
            $id             =   $row['codprograma'];
            $codseccion     =   $row['codseccion'];
            $descripcion    =   $row['descripcion'];
            $vistav         =   $row['vistav'];
            $vistafv        =   $row['vistafv'];
            $ruta           =   $row['ruta'];
            $nombre         =   $row['nombre'];
            $controlador    =   $row['ruta']+$row['nombre'];
        }
        $datos['codseccion']            =   $codseccion;
        $datos['modulo']                =   $modulo;
        $datos['nmodulo']               =   $this->input->post('nmodulo', true);        
        $datos['descripcion']           =   $descripcion; 
        $datos['id']                    =   $id;              
        $datos['session_id']            =   $histnombre;
        $datos['session_nivel_usuario'] =   $session_nivel_usuario;        
        $datos['gempanoc']              =   '';
        $datos['histid']                =   $histid;
        $datos['histnombre']            =   $histnombre;
        $datos['histlogin']             =   $histlogin;
        $datos['histnivel']             =   $histnivel;
        $datos['histcodpersona']        =   $histcodpersona;
        $datos['gempnumero']            =   $gempnumero;
        $datos['gempnombre']            =   $gempnombre;
        $this->load->view('front_end/historias/'.$vistav, $datos);
    }
   
    public function resumenpacientes()
    {  
        $this->load->model('historia_model');
        $histid                 =   $this->input->post('histid', true);
        $histnombre             =   $this->input->post('histnombre', true);
        $histlogin              =   $this->input->post('histlogin', true);
        $histnivel              =   $this->input->post('histnivel', true);
        $histcodpersona         =   $this->input->post('histcodpersona', true);
        $gempnumero             =   $this->input->post('gempnumero', true);
        $gempnombre             =   $this->input->post('gempnombre', true);
        
        $id_usuario             =   $histid;
        $persona_atiende        =   $this->historia_model->persona_atiende($id_usuario);
        foreach($persona_atiende as $persona)
        {
            $datos['cod_persona_atie']      =   $persona['cod_persona_atie'];
            $nombre_persona_atie            =   $persona['nombre_persona_atie'];
            $datos['login']                 =   $persona['login'];
            $datos['medico']                =   $persona['medico'];
            $c_medico                       =   $persona['medico'];
            if($c_medico == 'SI')
            {
                $c_cod_medi         =   $this->historia_model->c_cod_medi($id_usuario);
                if($c_cod_medi)
                {
                    foreach($c_cod_medi as $cmedi)
                        $datos['con_cod_medi']  =   $cmedi['cod_medi'];
                        $datos['con_id_medi']   =   $cmedi['id_medi'];
                }
            }else
            {
                $datos['con_cod_medi']  =   '';
                $datos['con_id_medi']   =   '';
            }
        }
        $datos['id_usuario']                =   $histid;  
        
        $this->load->view('front_end/historias/resumenpacientes_v', $datos);
    }
    
    public function resumen()
    {
        $this->db->trans_start();
              
        $this->datatables->select('id_paciente,primer_apellido,segundo_apellido,primer_nombre,segundo_nombre,tipo_docu,identificacion')
            
            ->unset_column('id_paciente')
            ->from('pacientes');
            
        
        $this->db->trans_complete();
        echo $this->datatables->generate();    
    }
    
    public function resumengen()
    {
        $this->db->trans_start();
        $cod_medi   =   $this->input->post('cod_medi', true);     
        $this->datatables->select('p.id_paciente,p.primer_apellido,p.segundo_apellido,p.primer_nombre,p.segundo_nombre,p.tipo_docu,p.identificacion, p.telefono_paciente, p.celular_paciente, e.ultimocontrol, e.proximocontrol')
            ->join('encabezado e',"e.tipo_docu = p.tipo_docu AND e.identificacion_paci = p.identificacion AND ref_procesos = 'GN' ", 'left outer')
            ->where('p.cod_medi', $cod_medi)            
            //->group_by('e.nconsulta') 
            ->unset_column('p.id_paciente')
            ->from('pacientes p');
            
        
        
        echo $this->datatables->generate();
        $this->db->trans_complete();
    }
    public function buscarpaciente()
    {
        $this->db->trans_start();
        $cod_medi   =   $this->input->post('cod_medi');     
        $paciente   =   $this->input->post('paciente');
        $this->datatables
            ->select('p.id_paciente,p.primer_apellido,p.segundo_apellido,p.primer_nombre,p.segundo_nombre,p.tipo_docu,p.identificacion, p.telefono_paciente, p.celular_paciente, MAX(e.fechaactual) as fechacontrol')            
            ->join('pacientes_exa e','e.tipo_docu = p.tipo_docu AND e.identificacion = p.identificacion', 'left outer')            
            ->where('p.cod_medi', $cod_medi)            
            ->from('pacientes p');
                
        $this->db->like('p.identificacion', $paciente);
        $this->db->or_like('p.primer_nombre', $paciente);
        $this->db->or_like('p.segundo_nombre', $paciente);
        $this->db->or_like('p.primer_apellido', $paciente);
        $this->db->or_like('p.segundo_apellido', $paciente);
        echo $this->datatables->generate();
        $this->db->trans_complete();
    }
    
    
    public function historiaconsulta()
    {
        $this->load->model('usuarios_model');
        $this->load->model('modulos_model');
        $this->load->model('historia_model');
        
        $codprograma            =   $this->input->post('id', true);        
        $modulo                 =   $this->input->post('modulo', true);
        $nmodulo                =   $this->input->post('nmodulo', true);
        $id_paciente            =   $this->input->post('bconsulta', true);        
        $codseccion             =   $this->input->post('codseccion', true);
        $codmedico              =   $this->input->post('codmedico', true);
        $conmedico              =   $this->historia_model->consulmedico($codmedico);
        
        $histid                 =   $this->input->post('histid', true);
        $histnombre             =   $this->input->post('histnombre', true);
        $histlogin              =   $this->input->post('histlogin', true);
        $histnivel              =   $this->input->post('histnivel', true);
        $histcodpersona         =   $this->input->post('histcodpersona', true);
        $gempnumero             =   $this->input->post('gempnumero', true);
        $gempnombre             =   $this->input->post('gempnombre', true);
        $id_agenda              =   $this->input->post('id_agenda', true);
        $datos['id_agenda']     =   $id_agenda;
        
        foreach($conmedico as $conmed)
        {
            $datos['cod_medi']  =   $conmed['cod_medi'];
            $datos['nommedico'] =   $conmed['primer_nombre_medi'].' '.$conmed['segundo_nombre_medi'].' '.$conmed['primer_apellido_medi'].' '.$conmed['segundo_apellido_medi'];
        }
        $dpaciente      =   $this->historia_model->cpaciente($id_paciente);
        foreach($dpaciente as $pac)
        {
            $tipodocu       =   $pac['tipo_docu'];
            $nombre         =   $pac['primer_nombre'].' '.$pac['segundo_nombre'].' '.$pac['primer_apellido'].' '.$pac['segundo_apellido']; 
            $identificacion =   $pac['identificacion'];          
        }
        
        $contenido              =   'historias/historiaconsulta_v';
        $datos['codprograma']   =   $codprograma;
        $datos['codseccion']    =   $codseccion;               
        $datos['modulo']        =   $modulo;
        $datos['nmodulo']       =   $nmodulo;
        //$datos['raiz']          =   $this->historia_model->raiz($codprograma);
        $datos['nombre']        =   $nombre;
        $datos['titulo']        =   'Historia Clínica - HCL'; 
        $datos['session_id']    =   $histnombre;
        $datos['gempnumero']    =   $gempnumero;
        $datos['gempnombre']    =   $gempnombre;
        $datos['gempanoc']      =   '';
        $datos['msecciones']    =   $this->modulos_model->msecciones($histnivel, $modulo);
        $datos['mprogramas']    =   $this->modulos_model->menumodelo($histnivel, $modulo);  
        //$datos['empresas']      =   $this->usuarios_model->empresas($histid);
        //$datos['bodegas']       =   $this->usuarios_model->bodegas($histid); 
        $datos['tipodocu']      =   $tipodocu;       
        $datos['id_paciente']   =   $id_paciente;      
        $datos['identificacion']=   $identificacion;  
        $this->load->view('front_end/'.$contenido, $datos);
    }  
    
    public function general()
    {   
        if($this->input->post())  
		{
            $this->load->model('usuarios_model');
            $this->load->model('modulos_model');
            $this->load->model('historia_model');
            $this->load->model('examen_model');
            
            $modulo                 =   trim($this->input->post('modulo', true));
            $nmodulo                =   trim($this->input->post('nmodulo', true));
            $codprograma            =   trim($this->input->post('codprograma', true));
            $codseccion             =   $this->input->post('codseccion', true);
            $id_paciente            =   $this->input->post('id_paciente', true);
            $codmedico              =   $this->input->post('codmedico', true);
            
            $histid                 =   $this->input->post('histid', true);
            $histnombre             =   $this->input->post('histnombre', true);
            $histlogin              =   $this->input->post('histlogin', true);
            $histnivel              =   $this->input->post('histnivel', true);
            $histcodpersona         =   $this->input->post('histcodpersona', true);
            $gempnumero             =   $this->input->post('gempnumero', true);
            $gempnombre             =   $this->input->post('gempnombre', true);
            $id_agenda              =   $this->input->post('id_agenda', true);
            $datos['id_agenda']     =   $id_agenda;
            
            $conmedico              =   $this->historia_model->consulmedico($codmedico);
            foreach($conmedico as $conmed)
            {
                $datos['id_medi']           =   $conmed['id_medi'];
                $datos['codmedico']         =   $conmed['cod_medi'];
                $datos['nommedico']         =   $conmed['primer_nombre_medi'].' '.$conmed['segundo_nombre_medi'].' '.$conmed['primer_apellido_medi'].' '.$conmed['segundo_apellido_medi'];
                $datos['vcod_persona_atie'] =   $conmed['cod_persona_atie'];            
                $datos['id_admi']           =   $conmed['id_admi'];
                $datos['idadministradora']  =   $conmed['id_administradora'];
                $datos['nombre_admi']       =   $conmed['nombre_admi'];
                $datos['verificacups']      =   $conmed['cups'];
                $cod_medi                   =   $conmed['cod_medi'];
                $datos['bd_cod_medi']       =   $conmed['cod_medi'];
            }
        
            $id_usuario             =   $histid;
            $session_nombre         =   $histnombre;
            $session_gempnumero     =   $gempnumero;
            $session_gempnombre     =   $gempnombre;
            $session_gempanoc       =   '';
            $session_nivel_usuario  =   $histnivel;
            //$this->personaatiende->general($modulo,$nmodulo,$codprograma,$id_paciente,$id_usuario, $session_nombre, $session_gempnumero, $session_gempnombre, $session_gempanoc,$session_nivel_usuario, $codseccion);
        
            $persona_atiende = $this->historia_model->persona_atiende($id_usuario);
            foreach($persona_atiende as $persona)
            {
                $cod_persona_atie       =   $persona['cod_persona_atie'];
                $nombre_persona_atie    =   $persona['nombre_persona_atie'];
                $datos['login']         =   $persona['login'];
                $datos['v_medico']      =   $persona['medico'];
                $login                  =   $persona['login'];
            }
            
            
            $datos['consmedico']     =   $this->historia_model->consmedico($cod_persona_atie, $id_usuario, $login);
            
            //DATOS DEL CLIENTE
            //$consultap = $this->historia_model->cpaciente($id_paciente);
            $consultap = $this->historia_model->con_paciente($id_paciente);
            foreach($consultap as $paci)
            {
                date_default_timezone_set('America/Bogota');
                $ma                     = 12;
                $fechan                 = $paci['fecha_de_nacimiento'];
                $edadpaciente           = '';
                $totaldiasmes           = '';
                list($Y,$m,$d)          = explode("-",$fechan);            
                $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
                $edadpaciente           = intval($edadpaciente);
                $mn                     = intval($m);  
                $dn                     = intval($d);
                $mesactual              = intval(date("m"));
                $diaactual              = intval(date("d"));            
                $mesanterior            = '';     
                $anocomp                = '';     
                $anoactual              = intval(date("Y")); 
                $anon                   = $Y;
                          
                if($mn == 2)
                {
                    $totaldiasmes       = 28;
                }
                if($dn == 31)
                {
                    $dn = $dn - 1;
                }
                if($mn == 2 && $dn >= 29)
                {
                    $dn = 28;
                }
                //$edad = $edadpaciente;
                
                if($edadpaciente == 0)
                {             
                    //MESES ACTUALES DEL PACIENTE               
                   
                    if($mesactual == 1)
                    {
                        $mesanterior = 12;
                    }                
                    else
                    {
                        $mesanterior = $mesactual - 1;
                    }
                    
                    if($mesanterior == $mn || $mn == $mesactual)
                    {
                        if($mn == $mesactual)
                        {
                            $edadresultado = $diaactual - $dn;
                        }
                        else
                        {
                            $edadresultado = $diaactual + 30 - $dn;
                            
                        }
                        
                        if($edadresultado >= 31)
                        {
                            $edad                   =   $mesactual - $mn.' '.'meses';
                            $redadpaciente          =   $mesactual - $mn;
                            $vl                     =   $redadpaciente;
                            $rl                     =   3;                        
                            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                            $datos['limiteedad']    =   $rl.$vl;
                            $pcara                  =   $rl.$vl;
                            $datos['pcara']         =   substr($pcara, 0, 1);                            
                            $datos['scara']         =   substr($pcara, 1, 2);
                        }
                        else
                        {
                            if($edadresultado > 1)
                            {
                                $edad = $edadresultado.' '.'días';
                                $redadpaciente          =   $edadresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   2;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $datos['limiteedad']    =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $datos['pcara']         =   substr($pcara, 0, 1);                            
                                $datos['scara']         =   substr($pcara, 1, 2);
                            }  
                            else
                            {
                                if($edadresultado <= 1)
                                {
                                    $horanacimiento         =   $paci['hora_nacimiento'];
                                    list($hor,$min,$seg)    =   explode(":",$horanacimiento);
                                    $horaactual             =   date("h");
                                    $minutosactuales        =   intval(date("i"));
                                    
                                    if(intval($diaactual) == intval($d))
                                    {
                                        $horaresultado          =   $horaactual - intval($hor);
                                        $edad                   =   $horaresultado.' '.'horas';
                                        $redadpaciente          =   $horaresultado;
                                        $vl                     =   $redadpaciente;
                                        $rl                     =   1;                        
                                        $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                        $datos['limiteedad']    =   $rl.$vl;
                                        $pcara                  =   $rl.$vl;
                                        $datos['pcara']         =   substr($pcara, 0, 1);                            
                                        $datos['scara']         =   substr($pcara, 1, 2);
                                    }
                                    else
                                    {
                                        $horav                  =   24;
                                        $horaresultado          =   $horav - $hor + $horaactual;                                    
                                        $edad                   =   $horaresultado.' '.'horas';
                                        $redadpaciente          =   $horaresultado;
                                        $vl                     =   $redadpaciente;
                                        $rl                     =   1;                        
                                        $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                        $datos['limiteedad']    =   $rl.$vl;
                                        $pcara                  =   $rl.$vl;
                                        $datos['pcara']         =   substr($pcara, 0, 1);                            
                                        $datos['scara']         =   substr($pcara, 1, 2);
                                        if($horaresultado > 24)
                                        {
                                            $horaresultado = '1 días';                                        
                                            $edad                   =   '1 días';
                                            $redadpaciente          =   1;
                                            $vl                     =   $redadpaciente;
                                            $rl                     =   2;                        
                                            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                            $datos['limiteedad']    =   $rl.$vl;
                                            $pcara                  =   $rl.$vl;
                                            $datos['pcara']         =   substr($pcara, 0, 1);                            
                                            $datos['scara']         =   substr($pcara, 1, 2);
                                        }
                                        else
                                        {
                                            
                                        }
                                        
                                    }
                                    
                                }
                            }                  
                        }
                    }
                    else
                    {
                        $anocomp        = $anoactual - 1;
                        if($anocomp == $anon)
                        {
                            $edad                   =   12 - $mn + $mesactual.' '.'meses';
                            $redadpaciente          =   12 - $mn + $mesactual;
                            $vl                     =   $redadpaciente;
                            $rl                     =   3;
                            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                            $datos['limiteedad']    =   $rl.$vl;
                            $pcara                  =   $rl.$vl;
                            $datos['pcara']         =   substr($pcara, 0, 1);                            
                            $datos['scara']         =   substr($pcara, 1, 2);
                        }
                        else
                        {
                            $edad                   =   $mesactual - $mn.' '.'meses';
                            $redadpaciente          =   $mesactual - $mn;       
                            $vl                     =   $redadpaciente;
                            $rl                     =   3;
                            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                            $datos['limiteedad']    =   $rl.$vl;
                            $pcara                  =   $rl.$vl;
                            $datos['pcara']         =   substr($pcara, 0, 1);                            
                            $datos['scara']         =   substr($pcara, 1, 2);
                        }
                    }
                }
                else
                {
                    $edad                   =   $edadpaciente .' '.'años';
                    $redadpaciente          =   $edadpaciente;
                    $vl                     =   $redadpaciente;
                    $rl                     =   4;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $datos['limiteedad']    =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $datos['pcara']         =   substr($pcara, 0, 1);                            
                    $datos['scara']         =   substr($pcara, 1, 2);
                }
                $datos['tipodocu']              =   $paci['tipo_docu'];
                $tipo_docu                      =   $paci['tipo_docu'];
                $datos['ntipodocu']             =   $paci['nombre_tipo_docu'];
                $identificacion                 =   $paci['identificacion'];
                $nombrepaciente                 =   $paci['primer_nombre'].' '.$paci['segundo_nombre'].' '.$paci['primer_apellido'].' '.$paci['segundo_apellido'].' '.$paci['razon_social'].' '.' / '.$paci['tipo_docu'].' '.' # '.$paci['identificacion'];
                $datos['nombrepac']             =   $paci['primer_nombre'].' '.$paci['segundo_nombre'].' '.$paci['primer_apellido'].' '.$paci['segundo_apellido'];
                $npaciente                 =   $paci['primer_nombre'].' '.$paci['segundo_nombre'].' '.$paci['primer_apellido'].' '.$paci['segundo_apellido'].' '.$paci['razon_social'];
                $nombrep                        =   $paci['primer_nombre'].' '.$paci['segundo_nombre'].' '.$paci['primer_apellido'].' '.$paci['segundo_apellido'];
                $id_admi                        =   $paci['id_admi'];    
                $direccion                      =   $paci['direccion_paci'];
                $email                          =   $paci['email_paciente'];
                $remitidopor                    =   $paci['referidopor'];
                $datos['fecha_de_nacimiento']   =   $paci['fecha_de_nacimiento'];
                $datos['hora_nacimiento']       =   $paci['hora_nacimiento']; 
                $datos['id_historia']           =   $paci['id_historia']; 
                $telefono                       =   $paci['telefono_paciente'];
                $celular                        =   $paci['celular_paciente'];
                $sigla_sexo                     =   $paci['sigla_sexo'];
                $sexo                           =   $paci['sigla_sexo'];
                $datos['primer_nombre']         =   $paci['primer_nombre'];
                $datos['segundo_nombre']        =   $paci['segundo_nombre'];
                $datos['primer_apellido']       =   $paci['primer_apellido'];
                $datos['segundo_apellido']      =   $paci['segundo_apellido'];
                $datos['telefono_paci']         =   $paci['telefono_paciente'];
                $datos['celular_paci']          =   $paci['celular_paciente'];
                $datos['cod_grupo_sang']        =   $paci['cod_grupo_sang'];
                
                $tipodocu           =   $paci['tipo_docu'];
                //$conscotodontograma =   $this->historia_model->consultacotodontogramav($tipodocu, $identificacion);        
                //$datos['consultacotodontograma']    =   $conscotodontograma;
                $nconsulta          =   $paci['nconsulta'];
                $datos['nconsulta'] =   $nconsulta;
                
            }  
            //DATOS DE FINALIDAD
            $finalidadxdefecto = $this->historia_model->finalidadxdefecto();
            foreach($finalidadxdefecto as $fxd)
            {
                $codfinalidadxdefecto   = $fxd['cod_fina'];
                $nomfinalidadxdefecto   = $fxd['nombre_fina'];
            }
            //DATOS CAUSA EFECTO
            $causaxdefecto = $this->historia_model->causaxdefecto();
            foreach($causaxdefecto as $cxd)
            {
                $codcausaxdefecto       = $cxd['cod_causa_dia'];
                $nomcausaxdefecto       = $cxd['nombre_causa_dia'];
            }
            //DATOS TIPO DE EFECTO
            $tipoxdefecto = $this->historia_model->tipoxdefecto();
            foreach($tipoxdefecto as $tipo)
            {
                $codtipoxdefecto        = $tipo['cod_tipo'];
                $nomtipoxdefecto        = $tipo['nombre_tipo'];
            }
            //DATOS DE FINALIDAD X DEFECTO
            $finalidad1xdefecto = $this->historia_model->finalidad1xdefecto();
            foreach($finalidad1xdefecto as $fin1)
            {
                $codfina1               = $fin1['cod_fina'];
                $nomfina1               = $fin1['nombre_fina'];    
            }
            //DATOS DEL PROGRAMA        
            $codsubprograma = $this->input->post('codsubprograma', true);
            if($codsubprograma)
            {
                $codsup = $this->historia_model->codsubprograma($codsubprograma,$session_nivel_usuario);
                foreach($codsup as $cods)
                {
                    
                    $codprograma            = $cods['id'];
                    $programa               = $cods['programa'];
                    $nombre                 = $cods['nombre'];
                    $descripcion            = $cods['descripcion'];
                    $vistav                 = $cods['vistav'];
                    $vistafv                = $cods['vistafv'];
                    $ruta                   = $cods['ruta'].$cods['nombre'];
                }    
            }else
            {
                $terprograma = $this->input->post('terprograma', true);
                if($terprograma)
                {                
                    $codsubprograma             = $terprograma;
                    $codsup = $this->historia_model->codsubprograma($codsubprograma,$session_nivel_usuario);
                    foreach($codsup as $cods)
                    {  
                        $codprograma            = $this->input->post('tercodsubprograma', true);
                        $programa               = $cods['programa'];
                        $nombre                 = $cods['nombre'];
                        $descripcion            = $cods['descripcion'];
                        $vistav                 = $cods['vistav'];
                        $vistafv                = $cods['vistafv'];
                        $ruta                   = $cods['ruta'].$cods['nombre'];
                    }
                }else
                {
                    $bseccion = $this->historia_model->modxsub($codprograma, $session_nivel_usuario);
                    foreach($bseccion as $bsec)
                    {
                        $codprograma            = $bsec['id'];
                        $programa               = $bsec['programa'];
                        $nombre                 = $bsec['nombre'];
                        $descripcion            = $bsec['descripcion'];
                        $vistav                 = $bsec['vistav'];
                        $vistafv                = $bsec['vistafv'];
                        $ruta                   = $bsec['ruta'].$bsec['nombre'];
                    }    
                }
            }
            
            $datos['paciente']          =   $this->historia_model->cipaciente($id_paciente);
            $datos['resumencitas']      =   $this->historia_model->resumenagenda($id_paciente);
            $datos['antecedentes']      =   $this->historia_model->ciantecedentes($id_paciente);   
            $datos['examen']            =   $this->historia_model->ciexamenn($id_paciente);
            //$datos['cie']           =   $this->historia_model->ciexamencien($tipo_docu, $identificacion);
            //$datos['cups']          =   $this->historia_model->cicupsn($tipo_docu, $identificacion);     
            $cons_paciente              =   $this->historia_model->cipaciente($id_paciente);
            foreach($cons_paciente as $cpac)
            {
                $datos['id_convenio']   =   $cpac->id_admi;
                $datos['nom_convenio']  =   $cpac->nombre_admi;
            }
            
            // CONSULTA GLOBAL
            $datosglobales                  =   $this->historia_model->consultaprestador();
            foreach($datosglobales as $cglo)
            {
                $datos['espacioimg']        =   $cglo['espacioimg'];
            }  
            
            //CREACION DE LA MATRIZ A LA VISTA
            $datos['bseccion']              =   $this->historia_model->modxsub($codprograma, $session_nivel_usuario);
            $datos['titulo']                =   'Historia Clínica - HCL';        
            $datos['raiz']                  =   $this->historia_model->raiz($codprograma, $session_nivel_usuario);
            $datos['session_id']            =   $histnombre;
            $datos['gempnumero']            =   $gempnumero;
            $datos['gempnombre']            =   $gempnombre;
            $datos['gempanoc']              =   '';
            $datos['msecciones']            =   $this->modulos_model->msecciones($session_nivel_usuario, $modulo);
            $datos['mprogramas']            =   $this->modulos_model->menumodelo($session_nivel_usuario, $modulo);  
            $datos['empresas']              =   $this->usuarios_model->empresas($id_usuario);
            $datos['bodegas']               =   $this->usuarios_model->bodegas($id_usuario);              
            $datos['modulo']                =   $modulo;
            $datos['nmodulo']               =   $nmodulo;
            $datos['descripcion']           =   $descripcion;
            
            //$datos['acompanante']           =   $this->historia_model->acompanante($id_paciente);
            $datos['imagenes']              =   $this->historia_model->imagenes($id_paciente);        
            $datos['edad']                  =   $edad;        
            $datos['id_paciente']           =   $id_paciente;        
            $datos['nombrepaciente']        =   $nombrepaciente;
            $datos['npaciente']             =   $npaciente;
            $datos['id_admi']               =   $id_admi;
            $datos['codprograma']           =   $codprograma;
            $datos['codsubprograma']        =   $codsubprograma;
            $datos['programa']              =   $programa;
            $datos['id_usuario']            =   $id_usuario;
            $datos['cod_persona_atie']      =   $cod_persona_atie;
            //$datos['nombre_persona_atie'] =   $nombre_persona_atie;
            $datos['medicos']               =   $this->historia_model->medicos();
            
            $datos['codfinalidadxdefecto']  =   $codfinalidadxdefecto;
            $datos['nomfinalidadxdefecto']  =   $nomfinalidadxdefecto;
            $datos['finalidad']             =   $this->historia_model->finalidad();
            $datos['codcausaxdefecto']      =   $codcausaxdefecto;
            $datos['nomcausaxdefecto']      =   $nomcausaxdefecto;
            $datos['causa']                 =   $this->historia_model->causa();
            $datos['codtipoxdefecto']       =   $codtipoxdefecto;
            $datos['nomtipoxdefecto']       =   $nomtipoxdefecto;
            $datos['tipo']                  =   $this->historia_model->tipo();
            $datos['codfina1']              =   $codfina1;
            $datos['nomfina1']              =   $nomfina1;
            
            $datos['tipoempresaspromotoras']=   $this->historia_model->tipoempresaspromotoras();         
            //$datos['convencion']            =   $this->odontograma_model->convencion(); 
            $datos['pacientes']             =   $this->historia_model->pacienteconsulta();
            $datos['nivel_usuario']         =   $session_nivel_usuario;   
            $datos['identificacion']        =   $identificacion;
            
            $datos['histid']                =   $histid;
            $datos['histnombre']            =   $histnombre;
            $datos['histlogin']             =   $histlogin;
            $datos['histnivel']             =   $histnivel;
            $datos['histcodpersona']        =   $histcodpersona;
            $datos['gempnumero']            =   $gempnumero;
            $datos['gempnombre']            =   $gempnombre;
            $datos['sexo']                  =   $sexo;
            $datos['direccion']             =   $direccion;
            $datos['email']                 =   $email;
            $datos['remitidopor']           =   $remitidopor;
            $datos['nombrep']               =   $nombrep;
            $datos['telefono']              =   $telefono;
            $datos['celular']               =   $celular;
            $datos['consultorios']          =   $this->historia_model->consultorios();
            $datos['convenios']             =   $this->historia_model->convenios();             
            $datos['consmedico']            =   $this->historia_model->consmedico($histcodpersona, $histid, $histlogin);
        
            $datos['fechaingreso']   = date("Y-m-d");
            $datos['horaingreso']    = date("H:i:s");
            // CONSULTA GN EN ENCABEZADO
            $consultagn                     =   $this->historia_model->consultagn($id_paciente);
            foreach($consultagn as $cgn)
            {
                $version                  =   $cgn['version'];
                $datos['version']         =   (int)$version + 1;
                // numwero oftalmologia
                $num_oftalmologia           =   $cgn['num_oftalmologia'];  
                $datos['num_oftalmologia']  =   (int)$num_oftalmologia + 1;
                // numeero optometria
                $num_optometria             =   $cgn['num_optometria'];  
                $datos['num_optometria']    =   (int)$num_optometria + 1;

                // numeero retinologia
                $num_retinologia            =   $cgn['num_retinologia'];  
                $datos['num_retinologia']   =   (int)$num_retinologia + 1;


            }
            // codigo consulta
            $datos['codconsulta']           =   $this->historia_model->codigoconsulta_gen($cod_medi);
            // consulta de historico oftalmologia
            $datos['cons_hist_oft']         =   $this->historia_model->cons_hist_oft($id_paciente);
            // consulta de historico optometria
            $datos['cons_hist_opt']         =   $this->historia_model->cons_hist_opt($id_paciente);
            // consulta de historico retinologia
            $datos['cons_hist_optret']      =   $this->historia_model->cons_hist_optret($id_paciente);
            // CONSULTA DE CONSENTIMIENTO ANESTESIA
            $datos['cons_cons_ane']         =   $this->historia_model->cons_cons_ane($id_paciente);
            // causa general cie
            $datos['causa_gen']              =   $this->historia_model->causa_gen();
            // finalidad general cie
            $datos['finalidad_gen_cie']      =   $this->historia_model->finalidad_gen_cie();
            // finalidad tipo cie
            $datos['tipo_gen']               =   $this->historia_model->tipo_gen();
            // finalidad general cups
            $datos['finalidad_gen']          =   $this->historia_model->finalidad_gen();
            // ambito general cups
            $datos['ambito_gen']             =   $this->historia_model->ambito_gen();
            // acto quirurgico general cups
            $datos['actoq_gen']              =   $this->historia_model->actoq_gen();
            // consulta de historias abiertas
            $datos['cons_abierta']           =   $this->historia_model->cons_abierta($id_paciente);
            $datos['especialidad_bd']        =   $this->historia_model->especialidad_bd();

            // datos de historia abierta cie, cups , medicamentos
            $abierta    =   $this->historia_model->cons_abierta($id_paciente);
            //var_dump($abierta);
            if($abierta)
            {
                foreach($abierta as $abi)
                {
                    $datos['historia_abierta']      =   $abi['cons_examen'];
                    
                    $n_conexamen                    =   $abi['cons_examen'];
                    $datos['c_cie']                 =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
                    $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
                    $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
                    $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
                    $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
                }
            }

            // datos de historia abierta cie, cups , medicamentos : OPTOMETRIA
            $datos['cons_abierta_opt']           =   $this->historia_model->cons_abierta_optometria($id_paciente);
            $abierta_opt    =   $this->historia_model->cons_abierta_optometria($id_paciente);
            if($abierta_opt)
            {
                foreach($abierta_opt as $abi_opt)
                {
                    $datos['historia_abierta_opt']      =   $abi_opt['cons_examen'];
                    
                    $n_conexamen                        =   $abi_opt['cons_examen'];
                    $datos['c_cie_opt']                 =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
                    $datos['ciemas_opt']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
                    $datos['cups_opt']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
                    $datos['medicamentos_opt']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
                    $datos['paraclinicos_opt']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
                }
            }

            // datos de historia abierta cie, cups , medicamentos : OPTOMETRIA
            $datos['cons_abierta_optret']           =   $this->historia_model->cons_abierta_retinologia($id_paciente);
            $abierta_ret    =   $this->historia_model->cons_abierta_retinologia($id_paciente);
            if($abierta_ret)
            {
                foreach($abierta_ret as $abi_opt)
                {
                    $datos['historia_abierta_ret']      =   $abi_opt['cons_examen'];
                    
                    $n_conexamen                        =   $abi_opt['cons_examen'];
                    $datos['c_cie_optret']                 =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
                    $datos['ciemas_optret']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
                    $datos['cups_optret']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
                    $datos['medicamentos_optret']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
                    $datos['paraclinicos_optret']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
                }
            }

            $datos['lateralidad']            =   $this->historia_model->lateralidad();  

            // permisos sobre las opciones de programas
            $datos['permisos']              =   $this->historia_model->permisos($id_usuario, $codprograma);

            // consulta del ultimo control para cargar  exa
            $c_ult_control_exa      =   $this->historia_model->c_ult_control_exa($id_paciente);
            if($c_ult_control_exa)
            {
                foreach($c_ult_control_exa as $vclon_exa)
                {
                    $datos['clon_exa'] = $vclon_exa['cons_examen'];
                }
            }else
            {
                $datos['clon_exa'] = '';
            }
            
            $datos['c_ult_control_ret']      =   $this->historia_model->c_ult_control_ret($id_paciente);

            // consulta del ultimo control para cargar ret
            $c_ult_control_ret      =   $this->historia_model->c_ult_control_ret($id_paciente);
            if($c_ult_control_ret)
            {
                foreach($c_ult_control_ret as $vclon_exa)
                {
                    $datos['clon_ret'] = $vclon_exa['cons_examen'];
                }
            }else
            {
                $datos['clon_ret'] = '';
            }
            
            $datos['c_ult_control_ret']      =   $this->historia_model->c_ult_control_ret($id_paciente);
            

            //$this->load->library('imagenes');
            //$this->load->library('s3');
            if(empty($datos['descripcion']) || empty($datos['programa']) || empty($datos['cod_persona_atie']))
            {
                $this->load->view('front_end/usuarios/index');
            }
            else
            {
                $this->load->view('front_end/historias/'.$vistav, $datos);    
            }
        }else
        {
            $datos['instruccion']   =   'Volver a registrar los datos del usuario';
            redirect(base_url().'usuarios/avisosesion', 301);
        }   
    }
    
    public function descarga($des)
    {   
		$folder = base_url('img/paciente/'.$des);
        $data = file_get_contents($folder);
        return force_download($des,$data);
    }
    
    public function reporteimagen($imagen)
    {        
        $this->load->model('historia_model');
        $rimagen    = $this->historia_model->datoimagen($imagen);        
        $this->pdf  = new Pdf();
        $this->pdf->AddPage();        
        $this->pdf->cabecerav($rimagen);
        $this->pdf->AliasNbPages();
        $this->pdf->SetTitle("Reporte Imagen por paciente");
        $this->pdf->cuerpo($rimagen);
        $nit        = $this->session_gempnumero;
        $empresa    = $this->session_gempnombre;
        $this->pdf->ultimo($nit, $empresa);
        $this->pdf->Output("informe imagen.pdf",'I');
    }
    
    public function masistente()
    {
        $this->load->model('historia_model');
        $this->load->model('odontograma_model');
        $nivel_usuario              =   $this->input->post('nivel_usuario', true);
        $masistente                 =   $this->historia_model->masistente($nivel_usuario);
        $id_paciente                =   $this->input->post('id_paciente', true);
        foreach($masistente as $mas)
        {
            $vistav     =   $mas['vistav'];
        }
        $datos['cod_persona_atie']      =   $this->input->post('cod_persona_atie', true);
        $datos['id_admi']               =   $this->input->post('id_admi', true);
        $datos['id_usuario']            =   $this->input->post('id_usuario', true);
        $datos['id_paciente']           =   $this->input->post('id_paciente', true);
        $datos['codprograma']           =   $this->input->post('codprograma', true);
        $datos['nivel_usuario']         =   $this->input->post('nivel_usuario', true);
        $datos['paciente']              =   $this->historia_model->cpacienteb($id_paciente);
        $datos['cie10_linea']           =   $this->historia_model->cie10_linea();
        $datos['convencion']            =   $this->odontograma_model->convencion();
        $datos['tipoempresaspromotoras']=   $this->historia_model->tipoempresaspromotoras(); 
        $this->load->view('front_end/historias/'.$vistav, $datos);  
    }
    
    public function cmingreso()
    {
        $this->load->model('historia_model');
        $this->load->model('odontograma_model');
        $nivel_usuario                  =   $this->input->post('nivel_usuario', true);        
        $id_paciente                    =   $this->input->post('id_paciente', true);
        $sigla_sexo                     =   $this->input->post('sigla_sexo', true);
        $limiteedad                     =   $this->input->post('limiteedad', true);
        
        $datos['cod_persona_atie']      =   $this->input->post('cod_persona_atie', true);
        $datos['id_admi']               =   $this->input->post('id_admi', true);
        $datos['id_usuario']            =   $this->input->post('id_usuario', true);
        $datos['id_paciente']           =   $this->input->post('id_paciente', true);
        $datos['codprograma']           =   $this->input->post('codprograma', true);
        $datos['nivel_usuario']         =   $this->input->post('nivel_usuario', true);
        $datos['paciente']              =   $this->historia_model->cpacienteb($id_paciente);
        $datos['cie10_linea']           =   $this->historia_model->cie10_linea($sigla_sexo, $limiteedad);        
        $datos['convencion']            =   $this->odontograma_model->convencion();
        $datos['tipoempresaspromotoras']=   $this->historia_model->tipoempresaspromotoras(); 
        $this->load->view('front_end/historias/hcpconsultaing_v', $datos);  
    }
    
    public function cmmodificacion()
    {
        $this->load->model('historia_model');
        $this->load->model('odontograma_model');
        $nivel_usuario                  =   $this->input->post('nivel_usuario', true);        
        $id_paciente                    =   $this->input->post('id_paciente', true);
        //$datos['sigla_sexo']            =   $this->input->post('sigla_sexo');
        //$datos['limiteedad']            =   $this->input->post('limiteedad');
        $sigla_sexo                         =   $this->input->post('sigla_sexo', true);
        $limiteedad                         =   $this->input->post('limiteedad', true);
        
        $datos['cod_persona_atie']      =   $this->input->post('cod_persona_atie', true);
        $datos['id_admi']               =   $this->input->post('id_admi', true);
        $datos['id_usuario']            =   $this->input->post('id_usuario', true);
        $datos['id_paciente']           =   $this->input->post('id_paciente', true);
        $datos['codprograma']           =   $this->input->post('codprograma', true);
        $datos['nivel_usuario']         =   $this->input->post('nivel_usuario', true);        
        $datos['tipoempresaspromotoras']=   $this->historia_model->tipoempresaspromotoras();  
        $datos['cie10_linea']           =   $this->historia_model->cie10_linea($sigla_sexo,$limiteedad);
        $datos['convencion']            =   $this->odontograma_model->convencion();      
        $this->load->view('front_end/historias/hcpconsultamod_v', $datos); 
    }
    
    public function cmconsulta()
    {
         
        $this->load->view('front_end/historias/hcpconsultacon_v', 301); 
    }
    
    public function cielinea()
    {
        $this->load->model('historia_model');
        $resultado  =   $this->historia_model->cielineacie();
    }
    public function ciesublinea()
    {
        $this->load->model('historia_model');
        $cielinea       =   $this->input->post('cielinea', true);
        $sigla_sexo     =   $this->input->post('sigla_sexo', true);
        $limiteedad     =   $this->input->post('limiteedad', true);
        $datos          =   $this->historia_model->cielinea($cielinea, $sigla_sexo, $limiteedad);
    }
    
    public function ciesublineanew()
    {
        $this->load->model('historia_model');
        $cielinea       =   $this->input->post('cielinea', true);
        $sigla_sexo     =   $this->input->post('sigla_sexo', true);
        $limiteedad     =   $this->input->post('limiteedad', true);
        
        // CLASIFICACION DEL SEXO
        if($sigla_sexo == 'M')
        {
            $sigla_sexo                 =   'H';
        }   
        else
        {
            $sigla_sexo                 =   'M';
        }    
        
        // GENERACION DE LIMITEEDAD
        date_default_timezone_set('America/Bogota');
        $ma                     = 12;
        $fechan                 = $fechanacimiento;
        $edadpaciente           = '';
        $totaldiasmes           = '';
        list($Y,$m,$d)          = explode("-",$fechan);            
        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
        $edadpaciente           = intval($edadpaciente);
        $mn                     = intval($m);  
        $dn                     = intval($d);
        $mesactual              = intval(date("m"));
        $diaactual              = intval(date("d"));            
        $mesanterior            = '';     
        $anocomp                = '';     
        $anoactual              = intval(date("Y")); 
        $anon                   = $Y;
                  
        if($mn == 2)
        {
            $totaldiasmes       = 28;
        }
        if($dn == 31)
        {
            $dn = $dn - 1;
        }
        if($mn == 2 && $dn >= 29)
        {
            $dn = 28;
        }
        //$edad = $edadpaciente;
        
        if($edadpaciente == 0)
        {             
            //MESES ACTUALES DEL PACIENTE               
           
            if($mesactual == 1)
            {
                $mesanterior = 12;
            }                
            else
            {
                $mesanterior = $mesactual - 1;
            }
            
            if($mesanterior == $mn || $mn == $mesactual)
            {
                if($mn == $mesactual)
                {
                    $edadresultado = $diaactual - $dn;
                }
                else
                {
                    $edadresultado = $diaactual + 30 - $dn;
                    
                }
                
                if($edadresultado >= 31)
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;                        
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    if($edadresultado > 1)
                    {
                        $edad = $edadresultado.' '.'días';
                        $redadpaciente          =   $edadresultado;
                        $vl                     =   $redadpaciente;
                        $rl                     =   2;                        
                        $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                        $limiteedad             =   $rl.$vl;
                        $pcara                  =   $rl.$vl;
                        $dpcara                 =   substr($pcara, 0, 1);                            
                        $dscara                 =   substr($pcara, 1, 2);
                    }  
                    else
                    {
                        if($edadresultado <= 1)
                        {
                            $horanacimiento         =   $paci['hora_nacimiento'];
                            list($hor,$min,$seg)    =   explode(":",$horanacimiento);
                            $horaactual             =   date("h");
                            $minutosactuales        =   intval(date("i"));
                            
                            if(intval($diaactual) == intval($d))
                            {
                                $horaresultado          =   $horaactual - intval($hor);
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                            }
                            else
                            {
                                $horav                  =   24;
                                $horaresultado          =   $horav - $hor + $horaactual;                                    
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                                if($horaresultado > 24)
                                {
                                    $horaresultado = '1 días';                                        
                                    $edad                   =   '1 días';
                                    $redadpaciente          =   1;
                                    $vl                     =   $redadpaciente;
                                    $rl                     =   2;                        
                                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                    $limiteedad             =   $rl.$vl;
                                    $pcara                  =   $rl.$vl;
                                    $dpcara                 =   substr($pcara, 0, 1);                            
                                    $dscara                 =   substr($pcara, 1, 2);
                                }
                                else
                                {
                                    
                                }
                                
                            }
                            
                        }
                    }                  
                }
            }
            else
            {
                $anocomp        = $anoactual - 1;
                if($anocomp == $anon)
                {
                    $edad                   =   12 - $mn + $mesactual.' '.'meses';
                    $redadpaciente          =   12 - $mn + $mesactual;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;       
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
            }
        }
        else
        {
            $edad                   =   $edadpaciente .' '.'años';
            $redadpaciente          =   $edadpaciente;
            $vl                     =   $redadpaciente;
            $rl                     =   4;
            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
            $limiteedad             =   $rl.$vl;
            $pcara                  =   $rl.$vl;
            $dpcara                 =   substr($pcara, 0, 1);                            
            $dscara                 =   substr($pcara, 1, 2);
        }
        
        $datos          =   $this->historia_model->cielinea($cielinea, $sigla_sexo, $limiteedad);
    }
    
    public function ciecodigonew()
    {
        $this->load->model('historia_model');
        $cielinea       =   $this->input->post('cielinea', true);
        $ciesublinea    =   $this->input->post('ciesublinea', true);
        $sigla_sexo     =   $this->input->post('sigla_sexo', true);
        $limiteedad     =   $this->input->post('limiteedad', true);
        
        // CLASIFICACION DEL SEXO
        if($sigla_sexo == 'M')
        {
            $sigla_sexo                 =   'H';
        }   
        else
        {
            $sigla_sexo                 =   'M';
        }    
        
        // GENERACION DE LIMITEEDAD
        date_default_timezone_set('America/Bogota');
        $ma                     = 12;
        $fechan                 = $fechanacimiento;
        $edadpaciente           = '';
        $totaldiasmes           = '';
        list($Y,$m,$d)          = explode("-",$fechan);            
        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
        $edadpaciente           = intval($edadpaciente);
        $mn                     = intval($m);  
        $dn                     = intval($d);
        $mesactual              = intval(date("m"));
        $diaactual              = intval(date("d"));            
        $mesanterior            = '';     
        $anocomp                = '';     
        $anoactual              = intval(date("Y")); 
        $anon                   = $Y;
                  
        if($mn == 2)
        {
            $totaldiasmes       = 28;
        }
        if($dn == 31)
        {
            $dn = $dn - 1;
        }
        if($mn == 2 && $dn >= 29)
        {
            $dn = 28;
        }
        //$edad = $edadpaciente;
        
        if($edadpaciente == 0)
        {             
            //MESES ACTUALES DEL PACIENTE               
           
            if($mesactual == 1)
            {
                $mesanterior = 12;
            }                
            else
            {
                $mesanterior = $mesactual - 1;
            }
            
            if($mesanterior == $mn || $mn == $mesactual)
            {
                if($mn == $mesactual)
                {
                    $edadresultado = $diaactual - $dn;
                }
                else
                {
                    $edadresultado = $diaactual + 30 - $dn;
                    
                }
                
                if($edadresultado >= 31)
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;                        
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    if($edadresultado > 1)
                    {
                        $edad = $edadresultado.' '.'días';
                        $redadpaciente          =   $edadresultado;
                        $vl                     =   $redadpaciente;
                        $rl                     =   2;                        
                        $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                        $limiteedad             =   $rl.$vl;
                        $pcara                  =   $rl.$vl;
                        $dpcara                 =   substr($pcara, 0, 1);                            
                        $dscara                 =   substr($pcara, 1, 2);
                    }  
                    else
                    {
                        if($edadresultado <= 1)
                        {
                            $horanacimiento         =   $paci['hora_nacimiento'];
                            list($hor,$min,$seg)    =   explode(":",$horanacimiento);
                            $horaactual             =   date("h");
                            $minutosactuales        =   intval(date("i"));
                            
                            if(intval($diaactual) == intval($d))
                            {
                                $horaresultado          =   $horaactual - intval($hor);
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                            }
                            else
                            {
                                $horav                  =   24;
                                $horaresultado          =   $horav - $hor + $horaactual;                                    
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                                if($horaresultado > 24)
                                {
                                    $horaresultado = '1 días';                                        
                                    $edad                   =   '1 días';
                                    $redadpaciente          =   1;
                                    $vl                     =   $redadpaciente;
                                    $rl                     =   2;                        
                                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                    $limiteedad             =   $rl.$vl;
                                    $pcara                  =   $rl.$vl;
                                    $dpcara                 =   substr($pcara, 0, 1);                            
                                    $dscara                 =   substr($pcara, 1, 2);
                                }
                                else
                                {
                                    
                                }
                                
                            }
                            
                        }
                    }                  
                }
            }
            else
            {
                $anocomp        = $anoactual - 1;
                if($anocomp == $anon)
                {
                    $edad                   =   12 - $mn + $mesactual.' '.'meses';
                    $redadpaciente          =   12 - $mn + $mesactual;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;       
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
            }
        }
        else
        {
            $edad                   =   $edadpaciente .' '.'años';
            $redadpaciente          =   $edadpaciente;
            $vl                     =   $redadpaciente;
            $rl                     =   4;
            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
            $limiteedad             =   $rl.$vl;
            $pcara                  =   $rl.$vl;
            $dpcara                 =   substr($pcara, 0, 1);                            
            $dscara                 =   substr($pcara, 1, 2);
        }
        
        $datos          =   $this->historia_model->ciesublinea($cielinea, $ciesublinea, $sigla_sexo, $limiteedad);
    }
    
    public function ciecodigo()
    {
        $this->load->model('historia_model');
        $cielinea       =   $this->input->post('cielinea', true);
        $ciesublinea    =   $this->input->post('ciesublinea', true);
        $sigla_sexo     =   $this->input->post('sigla_sexo', true);
        $limiteedad     =   $this->input->post('limiteedad', true);
        $datos          =   $this->historia_model->ciesublinea($cielinea, $ciesublinea, $sigla_sexo, $limiteedad);
    }
    
    public function busquedacienew()
    {
        $sigla_sexo         =   trim($this->input->post('sigla_sexo', true));
        $fechanacimiento    =   $this->input->post('fechanacimiento', true);
        $abuscar            =   trim($this->input->post('abuscar', true));
        $opbuscarcie        =   trim($this->input->post('opbuscarcie', true));
        
        // GENERACION DE LIMITEEDAD
        date_default_timezone_set('America/Bogota');
        $ma                     = 12;
        $fechan                 = $fechanacimiento;
        $edadpaciente           = '';
        $totaldiasmes           = '';
        list($Y,$m,$d)          = explode("-",$fechan);            
        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
        $edadpaciente           = intval($edadpaciente);
        $mn                     = intval($m);  
        $dn                     = intval($d);
        $mesactual              = intval(date("m"));
        $diaactual              = intval(date("d"));            
        $mesanterior            = '';     
        $anocomp                = '';     
        $anoactual              = intval(date("Y")); 
        $anon                   = $Y;
                  
        if($mn == 2)
        {
            $totaldiasmes       = 28;
        }
        if($dn == 31)
        {
            $dn = $dn - 1;
        }
        if($mn == 2 && $dn >= 29)
        {
            $dn = 28;
        }
        //$edad = $edadpaciente;
        
        if($edadpaciente == 0)
        {             
            //MESES ACTUALES DEL PACIENTE               
           
            if($mesactual == 1)
            {
                $mesanterior = 12;
            }                
            else
            {
                $mesanterior = $mesactual - 1;
            }
            
            if($mesanterior == $mn || $mn == $mesactual)
            {
                if($mn == $mesactual)
                {
                    $edadresultado = $diaactual - $dn;
                }
                else
                {
                    $edadresultado = $diaactual + 30 - $dn;
                    
                }
                
                if($edadresultado >= 31)
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;                        
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    if($edadresultado >=1)
                    {
                        $edad = $edadresultado.' '.'días';
                        $redadpaciente          =   $edadresultado;
                        $vl                     =   $redadpaciente;
                        $rl                     =   2;                        
                        $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                        $limiteedad             =   $rl.$vl;
                        $pcara                  =   $rl.$vl;
                        $dpcara                 =   substr($pcara, 0, 1);                            
                        $dscara                 =   substr($pcara, 1, 2);
                    }  
                    else
                    {
                        if($edadresultado < 1)
                        {
                            //$horanacimiento         =   $paci['hora_nacimiento'];
                            $horanacimiento         =   '00:00:00';
                            list($hor,$min,$seg)    =   explode(":",$horanacimiento);
                            $horaactual             =   date("h");
                            $minutosactuales        =   intval(date("i"));
                            
                            if(intval($diaactual) == intval($d))
                            {
                                $horaresultado          =   $horaactual - intval($hor);
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                            }
                            else
                            {
                                $horav                  =   24;
                                $horaresultado          =   $horav - $hor + $horaactual;                                    
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                                if($horaresultado > 24)
                                {
                                    $horaresultado = '1 días';                                        
                                    $edad                   =   '1 días';
                                    $redadpaciente          =   1;
                                    $vl                     =   $redadpaciente;
                                    $rl                     =   2;                        
                                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                    $limiteedad             =   $rl.$vl;
                                    $pcara                  =   $rl.$vl;
                                    $dpcara                 =   substr($pcara, 0, 1);                            
                                    $dscara                 =   substr($pcara, 1, 2);
                                }
                                else
                                {
                                    
                                }
                                
                            }
                            
                        }
                    }                  
                }
            }
            else
            {
                $anocomp        = $anoactual - 1;
                if($anocomp == $anon)
                {
                    $edad                   =   12 - $mn + $mesactual.' '.'meses';
                    $redadpaciente          =   12 - $mn + $mesactual;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;       
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
            }
        }
        else
        {
            $edad                   =   $edadpaciente .' '.'años';
            $redadpaciente          =   $edadpaciente;
            $vl                     =   $redadpaciente;
            $rl                     =   4;
            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
            $limiteedad             =   $rl.$vl;
            $pcara                  =   $rl.$vl;
            $dpcara                 =   substr($pcara, 0, 1);                            
            $dscara                 =   substr($pcara, 1, 2);
        }
        // CONSULTAS
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";
        
        if($opbuscarcie == 'codigo')
        {
            $this->datatables->select("cod_cie, nombre_cie, id_cie")
            ->filter($ledad)
                    
            ->from('cie10');
            $names = array('A', $sigla_sexo );            
            $this->db->like('cod_cie', $abuscar);       
            $this->db->where_in('sexo', $names);    
        }else if($opbuscarcie == 'descripcion')
        {
            $this->datatables->select("cod_cie, nombre_cie, id_cie")
            ->filter($ledad)
                    
            ->from('cie10');
            $names = array('A', $sigla_sexo );
            $this->db->like("nombre_cie", $abuscar);             
            $this->db->where_in('sexo', $names);   
        }       
        echo $this->datatables->generate(); 
    }
    
    public function busquedacie()
    {
        $sigla_sexo     =   $this->input->post('sigla_sexo', true);
        $limiteedad     =   $this->input->post('limiteedad', true);
        $abuscar        =   $this->input->post('abuscar', true);
        
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";
        
        $this->datatables->select("cod_cie, nombre_cie, cod_cielinea, cod_ciesublinea, id_cie")
        ->filter($ledad)
                
        ->from('cie10');
        $names = array('A', $sigla_sexo );
        $this->db->like("nombre_cie", $abuscar);        
        $this->db->where_in('sexo', $names);
                
        echo $this->datatables->generate(); 
    }
    
    
    public function diagnosticop()
    {        
        $this->load->model('historia_model');
        $datos['cie10_linea'] = $this->historia_model->cie10_linea();
        $this->load->view('front_end/historias/diagnosticop', $datos);
    }
    
    public function cielineap()
    {
        $this->load->model('historia_model');
        $cielineap  = $this->input->post('cielinea', true); 
        $datos      = $this->historia_model->cielineap($cielineap);
    }
    
    public function ciesublineap()
    {
        $this->load->model('historia_model');
        $ciesublineap   = $this->input->post('ciesublinea', true); 
        $datos          = $this->historia_model->ciesublineap($ciesublineap);
    }
    
    public function cupssublinea()
    {
        $this->load->model('historia_model');
        $cupslinea  = $this->input->post('cupslinea', true); 
        $datos      = $this->historia_model->cupssublinea($cupslinea);
    }
    
    public function finalidad2()
    {
        $this->load->model('historia_model');
        $cod_persona_atie   = $this->input->post('cod_persona_atie', true);
        $datos              = $this->historia_model->finalidad2($cod_persona_atie);
    }
    
    public function causa()
    {
        $this->load->model('historia_model');
        $cod_persona_atie   = $this->input->post('cod_persona_atie', true);
        $datos              = $this->historia_model->causa1($cod_persona_atie);
    }
    
    public function tipo()
    {
        $this->load->model('historia_model');
        $cod_persona_atie   = $this->input->post('cod_persona_atie', true);
        $datos              = $this->historia_model->tipo1($cod_persona_atie);
    }
    
    public function busquedacups()
    {        
        $this->load->library('edad');
        $opbuscarcups       =   trim($this->input->post('opbuscarcups', true));
        $sigla_sexo         =   trim($this->input->post('sigla_sexo', true));
        $fechanacimiento    =   $this->input->post('fechanacimiento', true);
        $abuscar            =   trim($this->input->post('abuscar', true));
        $especialidad       =   trim($this->input->post('especialidad', true));
        //$id_contratista     =   trim($this->input->post('convenio', true));
        // GENERACION DE LIMITEEDAD
        date_default_timezone_set('America/Bogota');
        $ma                     = 12;
        $fechan                 = $fechanacimiento;
        $edadpaciente           = '';
        $totaldiasmes           = '';
        list($Y,$m,$d)          = explode("-",$fechan);            
        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
        $edadpaciente           = intval($edadpaciente);
        $mn                     = intval($m);  
        $dn                     = intval($d);
        $mesactual              = intval(date("m"));
        $diaactual              = intval(date("d"));            
        $mesanterior            = '';     
        $anocomp                = '';     
        $anoactual              = intval(date("Y")); 
        $anon                   = $Y;
                  
        if($mn == 2)
        {
            $totaldiasmes       = 28;
        }
        if($dn == 31)
        {
            $dn = $dn - 1;
        }
        if($mn == 2 && $dn >= 29)
        {
            $dn = 28;
        }
        //$edad = $edadpaciente;
        
        if($edadpaciente == 0)
        {             
            //MESES ACTUALES DEL PACIENTE               
           
            if($mesactual == 1)
            {
                $mesanterior = 12;
            }                
            else
            {
                $mesanterior = $mesactual - 1;
            }
            
            if($mesanterior == $mn || $mn == $mesactual)
            {
                if($mn == $mesactual)
                {
                    $edadresultado = $diaactual - $dn;
                }
                else
                {
                    $edadresultado = $diaactual + 30 - $dn;
                    
                }
                
                if($edadresultado >= 31)
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;                        
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    if($edadresultado > 1)
                    {
                        $edad = $edadresultado.' '.'días';
                        $redadpaciente          =   $edadresultado;
                        $vl                     =   $redadpaciente;
                        $rl                     =   2;                        
                        $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                        $limiteedad             =   $rl.$vl;
                        $pcara                  =   $rl.$vl;
                        $dpcara                 =   substr($pcara, 0, 1);                            
                        $dscara                 =   substr($pcara, 1, 2);
                    }  
                    else
                    {
                        if($edadresultado <= 1)
                        {
                            $horanacimiento         =   $paci['hora_nacimiento'];
                            list($hor,$min,$seg)    =   explode(":",$horanacimiento);
                            $horaactual             =   date("h");
                            $minutosactuales        =   intval(date("i"));
                            
                            if(intval($diaactual) == intval($d))
                            {
                                $horaresultado          =   $horaactual - intval($hor);
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                            }
                            else
                            {
                                $horav                  =   24;
                                $horaresultado          =   $horav - $hor + $horaactual;                                    
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                                if($horaresultado > 24)
                                {
                                    $horaresultado = '1 días';                                        
                                    $edad                   =   '1 días';
                                    $redadpaciente          =   1;
                                    $vl                     =   $redadpaciente;
                                    $rl                     =   2;                        
                                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                    $limiteedad             =   $rl.$vl;
                                    $pcara                  =   $rl.$vl;
                                    $dpcara                 =   substr($pcara, 0, 1);                            
                                    $dscara                 =   substr($pcara, 1, 2);
                                }
                                else
                                {
                                    
                                }
                                
                            }
                            
                        }
                    }                  
                }
            }
            else
            {
                $anocomp        = $anoactual - 1;
                if($anocomp == $anon)
                {
                    $edad                   =   12 - $mn + $mesactual.' '.'meses';
                    $redadpaciente          =   12 - $mn + $mesactual;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;       
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
            }
        }
        else
        {
            $edad                   =   $edadpaciente .' '.'años';
            $redadpaciente          =   $edadpaciente;
            $vl                     =   $redadpaciente;
            $rl                     =   4;
            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
            $limiteedad             =   $rl.$vl;
            $pcara                  =   $rl.$vl;
            $dpcara                 =   substr($pcara, 0, 1);                            
            $dscara                 =   substr($pcara, 1, 2);
        }
        
        // CONSULTAS
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";
        
        if($especialidad == 'todos')
        {
            if($opbuscarcups == 'codigo')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('cups');
                 
                $names = array('A', $sigla_sexo );
                $this->db->like("cod_cups", $abuscar); 
                //$this->db->where('id_contratistas', $id_contratista);
                $this->db->where_in('sexo', $names);
            }else if($opbuscarcups == 'descripcion')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('cups');
                
                $names = array('A', $sigla_sexo );
                $this->db->like("nombre_cups", $abuscar);  
                //$this->db->where('id_contratistas', $id_contratista);                  
                $this->db->where_in('sexo', $names);
            }    
        }else
        {
            if($opbuscarcups == 'codigo')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('cups');
                $this->db->where('cod_cups_tipopro', $especialidad); 
                $names = array('A', $sigla_sexo );
                $this->db->like("cod_cups", $abuscar); 
                //$this->db->where('id_contratistas', $id_contratista);
                $this->db->where_in('sexo', $names);
            }else if($opbuscarcups == 'descripcion')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('cups');
                
                $this->db->where('cod_cups_tipopro', $especialidad);
                $names = array('A', $sigla_sexo );
                $this->db->like("nombre_cups", $abuscar);  
                //$this->db->where('id_contratistas', $id_contratista);                  
                $this->db->where_in('sexo', $names);
            }
        }        
        
        echo $this->datatables->generate();         
    }

    public function busquedacups_fac()
    {        
        $this->load->library('edad');
        $opbuscarcups       =   trim($this->input->post('opbuscarcups', true));
        $sigla_sexo         =   trim($this->input->post('sigla_sexo', true));
        $fechanacimiento    =   $this->input->post('fechanacimiento', true);
        $abuscar            =   trim($this->input->post('abuscar', true));
        $especialidad       =   trim($this->input->post('especialidad', true));
        //$id_contratista     =   trim($this->input->post('convenio', true));
        // GENERACION DE LIMITEEDAD
        date_default_timezone_set('America/Bogota');
        $ma                     = 12;
        $fechan                 = $fechanacimiento;
        $edadpaciente           = '';
        $totaldiasmes           = '';
        list($Y,$m,$d)          = explode("-",$fechan);            
        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
        $edadpaciente           = intval($edadpaciente);
        $mn                     = intval($m);  
        $dn                     = intval($d);
        $mesactual              = intval(date("m"));
        $diaactual              = intval(date("d"));            
        $mesanterior            = '';     
        $anocomp                = '';     
        $anoactual              = intval(date("Y")); 
        $anon                   = $Y;
                  
        if($mn == 2)
        {
            $totaldiasmes       = 28;
        }
        if($dn == 31)
        {
            $dn = $dn - 1;
        }
        if($mn == 2 && $dn >= 29)
        {
            $dn = 28;
        }
        //$edad = $edadpaciente;
        
        if($edadpaciente == 0)
        {             
            //MESES ACTUALES DEL PACIENTE               
           
            if($mesactual == 1)
            {
                $mesanterior = 12;
            }                
            else
            {
                $mesanterior = $mesactual - 1;
            }
            
            if($mesanterior == $mn || $mn == $mesactual)
            {
                if($mn == $mesactual)
                {
                    $edadresultado = $diaactual - $dn;
                }
                else
                {
                    $edadresultado = $diaactual + 30 - $dn;
                    
                }
                
                if($edadresultado >= 31)
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;                        
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    if($edadresultado > 1)
                    {
                        $edad = $edadresultado.' '.'días';
                        $redadpaciente          =   $edadresultado;
                        $vl                     =   $redadpaciente;
                        $rl                     =   2;                        
                        $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                        $limiteedad             =   $rl.$vl;
                        $pcara                  =   $rl.$vl;
                        $dpcara                 =   substr($pcara, 0, 1);                            
                        $dscara                 =   substr($pcara, 1, 2);
                    }  
                    else
                    {
                        if($edadresultado <= 1)
                        {
                            $horanacimiento         =   $paci['hora_nacimiento'];
                            list($hor,$min,$seg)    =   explode(":",$horanacimiento);
                            $horaactual             =   date("h");
                            $minutosactuales        =   intval(date("i"));
                            
                            if(intval($diaactual) == intval($d))
                            {
                                $horaresultado          =   $horaactual - intval($hor);
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                            }
                            else
                            {
                                $horav                  =   24;
                                $horaresultado          =   $horav - $hor + $horaactual;                                    
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                                if($horaresultado > 24)
                                {
                                    $horaresultado = '1 días';                                        
                                    $edad                   =   '1 días';
                                    $redadpaciente          =   1;
                                    $vl                     =   $redadpaciente;
                                    $rl                     =   2;                        
                                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                    $limiteedad             =   $rl.$vl;
                                    $pcara                  =   $rl.$vl;
                                    $dpcara                 =   substr($pcara, 0, 1);                            
                                    $dscara                 =   substr($pcara, 1, 2);
                                }
                                else
                                {
                                    
                                }
                                
                            }
                            
                        }
                    }                  
                }
            }
            else
            {
                $anocomp        = $anoactual - 1;
                if($anocomp == $anon)
                {
                    $edad                   =   12 - $mn + $mesactual.' '.'meses';
                    $redadpaciente          =   12 - $mn + $mesactual;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;       
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
            }
        }
        else
        {
            $edad                   =   $edadpaciente .' '.'años';
            $redadpaciente          =   $edadpaciente;
            $vl                     =   $redadpaciente;
            $rl                     =   4;
            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
            $limiteedad             =   $rl.$vl;
            $pcara                  =   $rl.$vl;
            $dpcara                 =   substr($pcara, 0, 1);                            
            $dscara                 =   substr($pcara, 1, 2);
        }
        
        // CONSULTAS
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";
        
        if($especialidad == 'todos')
        {
            if($opbuscarcups == 'codigo')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('contratistas_cups');
                 
                $names = array('A', $sigla_sexo );
                $this->db->like("cod_cups", $abuscar); 
                //$this->db->where('id_contratistas', $id_contratista);
                $this->db->where_in('sexo', $names);
            }else if($opbuscarcups == 'descripcion')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('contratistas_cups');
                
                $names = array('A', $sigla_sexo );
                $this->db->like("nombre_cups", $abuscar);  
                //$this->db->where('id_contratistas', $id_contratista);                  
                $this->db->where_in('sexo', $names);
            }    
        }else
        {
            if($opbuscarcups == 'codigo')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('contratistas_cups');
                $this->db->where('cod_cups_tipopro', $especialidad); 
                $names = array('A', $sigla_sexo );
                $this->db->like("cod_cups", $abuscar); 
                //$this->db->where('id_contratistas', $id_contratista);
                $this->db->where_in('sexo', $names);
            }else if($opbuscarcups == 'descripcion')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('contratistas_cups');
                
                $this->db->where('cod_cups_tipopro', $especialidad);
                $names = array('A', $sigla_sexo );
                $this->db->like("nombre_cups", $abuscar);  
                //$this->db->where('id_contratistas', $id_contratista);                  
                $this->db->where_in('sexo', $names);
            }
        }        
        
        echo $this->datatables->generate();         
    }
    public function valcups()
    {
        $this->load->model('historia_model');
        $cod_cups               =   trim($this->input->post('cod_cups', true));
        $tipo_docu              =   trim($this->input->post('tipo_docu', true));
        $identificacion         =   trim($this->input->post('identificacion', true));
        $cupsmaxvecesvida       =   trim($this->input->post('cupsmaxvecesvida', true));
        $cupsmaxvecesdia        =   trim($this->input->post('cupsmaxvecesdia', true));
        $cupstiempolimitedias   =   trim($this->input->post('cupstiempolimitedias', true));
        $consultabdcups         =   '0';
        
        date_default_timezone_set('America/Bogota');
        $fechaactual        =   date("Y").'-'.date("m").'-'.date("d");
        
        if($cupsmaxvecesvida)
        {
            $consultabdcups     =   $this->historia_model->consultabdcupsvida($cod_cups, $tipo_docu, $identificacion, $cupsmaxvecesvida);
        }else if($cupsmaxvecesdia)
        {            
            $consultabdcups     =   $this->historia_model->consultabdcupsdia($cod_cups, $tipo_docu, $identificacion, $cupsmaxvecesdia, $fechaactual);
        }
        if($cupstiempolimitedias)
        {
            $consultabdcups     =   $this->historia_model->consultabdcupslimi($cod_cups, $tipo_docu, $identificacion, $cupstiempolimitedias, $fechaactual);
        }
        
        echo $consultabdcups;
        
    }   
    public function valcups_examen()
    {
        $this->load->model('historia_model');
        $cod_cups               =   trim($this->input->post('cod_cups', true));
        $id_paciente              =   trim($this->input->post('id_paciente', true));
        $cupsmaxvecesvida       =   trim($this->input->post('cupsmaxvecesvida', true));
        $cupsmaxvecesdia        =   trim($this->input->post('cupsmaxvecesdia', true));
        $cupstiempolimitedias   =   trim($this->input->post('cupstiempolimitedias', true));
        $consultabdcups         =   '0';
        
        date_default_timezone_set('America/Bogota');
        $fechaactual        =   date("Y").'-'.date("m").'-'.date("d");
        
        if($cupsmaxvecesvida)
        {
            $consultabdcups     =   $this->historia_model->consultabdcupsvida_exa($cod_cups, $id_paciente, $cupsmaxvecesvida);
        }else if($cupsmaxvecesdia)
        {            
            $consultabdcups     =   $this->historia_model->consultabdcupsdia_exa($cod_cups, $id_paciente, $cupsmaxvecesdia, $fechaactual);
        }
        if($cupstiempolimitedias)
        {
            $consultabdcups     =   $this->historia_model->consultabdcupslimi_exa($cod_cups, $id_paciente, $cupstiempolimitedias, $fechaactual);
        }
        
        echo $consultabdcups;
        
    }  
    
    public function cupslinea()
    {
        $this->load->model('historia_model');
        $cod_persona_atie   = $this->input->post('cod_persona_atie', true);
        $datos              = $this->historia_model->cupslinea($cod_persona_atie);
    }
    
    public function cupsgrupo()
    {
        $this->load->model('historia_model');
        $cupslinea          = $this->input->post('cupslinea', true);
        $cupsublinea        = $this->input->post('cupssublinea', true);
        $datos              = $this->historia_model->cupsgrupo($cupslinea, $cupsublinea);
    }
    
    public function cupscodigo()
    {
        $this->load->model('historia_model');
        $cupslinea          = $this->input->post('cupslinea', true);
        $cupsublinea        = $this->input->post('cupssublinea', true);
        $cupsgrupo          = $this->input->post('cupsgrupo', true);
        $datos              = $this->historia_model->cupscodigo($cupslinea, $cupsublinea, $cupsgrupo);
    }    
    
    public function finalidad1()
    {
        $this->load->model('historia_model');
        $cod_persona_atie   = $this->input->post('cod_persona_atie', true);
        $datos              = $this->historia_model->finalidad1($cod_persona_atie);
    }
    
    public function fconsultamedicaing()
    {
        $this->load->model('historia_model');
        $datos  = $this->historia_model->fconsultamedicaing();
    }
    
    public function fconsultamedicaingmv()
    {            
        $this->load->model('historia_model');
        $datos  = $this->historia_model->fconsultamedicaingmv();
    }
    
    public function nconsulta()
    {
        $this->load->model('historia_model');
        $datos  = $this->historia_model->nconsulta();
    }
    
    public function medico()
    {
        $this->load->model('historia_model');
        $id_usuario = $this->input->post('id_usuario', true);
        $persona = $this->input->post('cod_persona_atie', true);
        $datos = $this->historia_model->medico($persona, $id_usuario);
    }
    
    public function error_consultamedica()
    {
        $datos['varcampo']  = $this->input->post('varcampo', true);
        $datos['titulo']    = $this->input->post('titulo', true);
        $datos['mensaje']   = $this->input->post('mensaje', true);
        $this->load->view('front_end/historias/errores/error_consultamedica_v', $datos);       
    }
    
    public function erroresindicadoresp()
    {
        $datos['varcampo']  = $this->input->post('varcampo', true);
        $datos['titulo']    = $this->input->post('titulo', true);
        $datos['mensaje']   = $this->input->post('mensaje', true);
        $this->load->view('front_end/historias/errores/erroresindicadoresp', $datos);       
    }
    
    public function administradora()
    {
        $this->load->model('historia_model');
        $medico         = $this->input->post('medico', true);
        $medico         = strval($medico);       
        $administradora = $this->historia_model->administradora($medico);
    }
    
    public function administradoras()
    {
        $this->load->model('historia_model');
        $tipoadministradora = $this->input->post('tipoadministradora', true);            
        $administradora     = $this->historia_model->administradoras($tipoadministradora);
    }
    
    public function cadministradoras()
    {
        $this->load->model('historia_model');
        $valadministradora  = $this->input->post('valadministradora', true);               
        $cadministradora    = $this->historia_model->cadministradoras($valadministradora);
    }
    
    public function codigoconsulta()
    {
        $this->load->model('historia_model');
        $cod_medi       = $this->input->post('medico', true);        
        $codconsulta    = $this->historia_model->codigoconsulta($cod_medi);
    }
    
    public function ambito()
    {
        $this->load->model('historia_model');
        $ambito = $this->historia_model->ambito();
    }
    
    public function actoq()
    {
        $this->load->model('historia_model');
        $actoq  = $this->historia_model->actoq();
    }
    
    public function menudp()
    {        
        $this->load->model('historia_model');
        $modulo                 =   $this->input->post('modulo', true);
        $codprograma            =   $this->input->post('codprograma', true);
        $codseccion             =   $this->input->post('codseccion', true);
        $id_paciente            =   $this->input->post('id_paciente', true);
        $identificacion         =   $this->input->post('identificacion', true);
        $tipodocu               =   $this->input->post('tipodocu', true);
        $codmedico              =   $this->input->post('codmedico', true);
        
        $histid                 =   $this->input->post('histid', true);
        $histnombre             =   $this->input->post('histnombre', true);
        $histlogin              =   $this->input->post('histlogin', true);
        $histnivel              =   $this->input->post('histnivel', true);
        $histcodpersona         =   $this->input->post('histcodpersona', true);
        $gempnumero             =   $this->input->post('gempnumero', true);
        $gempnombre             =   $this->input->post('gempnombre', true);
        
        $datos['id_agenda']              =   $this->input->post('id_agenda', true);

        $conmedico              =   $this->historia_model->consulmedico($codmedico);
        foreach($conmedico as $conmed)
        {
            $datos['codmedico'] =   $conmed['cod_medi'];
            $datos['nommedico'] =   $conmed['primer_nombre_medi'].' '.$conmed['segundo_nombre_medi'].' '.$conmed['primer_apellido_medi'].' '.$conmed['segundo_apellido_medi'];
        }
        
        $session_nivel_usuario  =   $histnivel;
        $datos['modulo']        =   $modulo;        
        $datos['codseccion']    =   $codseccion;
        $datos['id_paciente']   =   $id_paciente;
        $datos['identificacion']=   $identificacion;
        $datos['tipodocu']      =   $tipodocu;
        $datos['raiz']          =   $this->historia_model->raiz($codprograma, $histnivel);
        $this->load->view('front_end/historias/menudp', $datos);
    }
    
    public function menudpresumen()
    {
        $datos['descripcion'] = $this->input->post('descripcion', true);
        $this->load->view('front_end/historias/menudpresumen', $datos);
    }
    
    
    
    public function tipo_docu()
    {
        $this->load->model('historia_model');
        $vtipo_docu     =   $this->input->post('vtipo_docu', true);
        $rvtipo_docu    =   $this->historia_model->vtipo_docu($vtipo_docu);
    }
    
    public function sigla_sexo()
    {
        $this->load->model('historia_model');
        $vsigla_sexo     =   $this->input->post('vsigla_sexo', true);
        $rvsigla_sexo    =   $this->historia_model->vsigla_sexo($vsigla_sexo);
    }
    
    public function cod_estado_civi()
    {
        $this->load->model('historia_model');
        $vcod_estado_civi     =   $this->input->post('vcod_estado_civi', true);
        $rvcod_estado_civi    =   $this->historia_model->vcod_estado_civi($vcod_estado_civi);
    }
    
    public function cod_pais()
    {
        $this->load->model('historia_model');
        $vcod_pais     =   $this->input->post('vcod_pais', true);
        $rvcod_pais    =   $this->historia_model->vcod_pais($vcod_pais);
    }
 
    public function id_depa()
    {
        $this->load->model('historia_model');
        $vcod_pais    =   $this->input->post('vcod_pais', true);
        $vid_depa     =   $this->input->post('vid_depa', true);        
        $rvid_depa    =   $this->historia_model->vid_depa($vid_depa, $vcod_pais);
    }
     
    public function id_muni()
    {
        $this->load->model('historia_model');
        $vcod_pais    =   $this->input->post('vcod_pais', true);
        $vid_depa     =   $this->input->post('vid_depa', true); 
        $vid_muni     =   $this->input->post('vid_muni', true);
        $rvid_muni    =   $this->historia_model->vid_muni($vid_depa, $vcod_pais, $vid_muni);
    }
    
    public function id_barr()
    {
        $this->load->model('historia_model');
        $vcod_pais    =   $this->input->post('vcod_pais', true);
        $vid_depa     =   $this->input->post('vid_depa', true); 
        $vid_muni     =   $this->input->post('vid_muni', true);
        $vid_barr     =   $this->input->post('vid_barr', true);
        $rvid_muni    =   $this->historia_model->vid_muni($vid_depa, $vcod_pais, $vid_muni, $vid_barr);
    }
    
    public function cod_zona_resi()
    {
        $this->load->model('historia_model');
        $vcod_zona_resi    =   $this->input->post('cod_zona_resi', true);        
        $rvcod_zona_resi   =   $this->historia_model->vcod_zona_resi($vcod_zona_resi);
    }
    
    public function id_admi()
    {
        $this->load->model('historia_model');
        $vid_admi    =   $this->input->post('vid_admi', true);        
        $rvid_admi   =   $this->historia_model->vid_admi($vid_admi);
    }      
    
    public function cod_tipo_usua()
    {
        $this->load->model('historia_model');
        $vcod_tipo_usua    =   $this->input->post('vcod_tipo_usua', true);        
        $rvcod_tipo_usua   =   $this->historia_model->vcod_tipo_usua($vcod_tipo_usua);
    }
    
    public function id_ocup()
    {
        $this->load->model('historia_model');
        $vid_ocup    =   $this->input->post('vid_ocup', true);        
        $rvid_ocup   =   $this->historia_model->vid_ocup($vid_ocup);
    }
    
    public function fconsultamedicamod()
    {
        $this->load->model('historia_model');
        $datos  = $this->historia_model->fconsultamedicamod();
    }    
    public function consultacotodontograma()
    {
        $this->load->model('historia_model');
        $tipo_docu          =   $this->input->post('tipo_docu', true);
        $identificacion     =   $this->input->post('identificacion', true);        
        $conscotodontograma =   $this->historia_model->consultacotodontograma($tipo_docu, $identificacion);
        //echo $conscotodontograma;
    }
    
    public function consentimientocitamedica()
    {
        $this->load->model('historia_model');
        $tipo_docu      =   $this->input->post('tipo_docu', true);
        $identificacion =   $this->input->post('identificacion', true);
        $numconsulta    =   trim($this->input->post('numconsulta', true));
        $cotizacion     =   trim($this->input->post('cotizacion', true));
        
        // PRESTADOR
        $consultaprestador  =   $this->historia_model->consultaprestador();
        foreach($consultaprestador as $cpres)
        {
            $datos['pnumero']        =   $cpres['numero'];
            $datos['pnombre']        =   $cpres['nombre'];
            $datos['pdireccion']     =   $cpres['direccion'];
            $datos['ptelefonos']     =   $cpres['telefono1'].' '.$cpres['telefono2'];
            $datos['plogo']          =   $cpres['logopresatador'];   
        }
        
        // DATOS DE TABLA: CONSULTA_MEDICA (ENCABEZADO)
        $regconsulta    =   $this->historia_model->regconsulta($numconsulta, $cotizacion);
        if($regconsulta)
        {
            foreach($regconsulta as $regc)
            {
                $datos['nomb_cie']      =   $regc['rciecodigo'];
                $datos['nomb_cie1']     =   $regc['rciecodigo1'];
                $datos['nomb_cie2']     =   $regc['rciecodigo2'];
            }
        }
        
        // DATOS TABLA: CONSULTA_MEDICAXTRATAMIENTO (CUPS)
        $datos['cupsxconsulta']     =   $this->historia_model->cupsxconsulta($numconsulta, $cotizacion);
        
        // DATOS DEL PACIENTE
        $datpac         =   $this->historia_model->datpac($tipo_docu, $identificacion);
        foreach($datpac as $dtos)
        {
            $datos['nombre']    =   $dtos['primer_nombre'].' '.$dtos['segundo_nombre'].' '.$dtos['primer_apellido'].' '.$dtos['segundo_apellido'];
        }
        $datos['tipo_docu']     =   $tipo_docu;
        $datos['identificacion']=   $identificacion;
        $this->load->view('front_end/historias/consentimientocitamedica_v', $datos);
    }
    
    public function consulmedico()
    {
        $this->load->model('historia_model');
        $codmedico  =   $this->input->post('codmedico', true);
        $consmedico =   $this->historia_model->codmedico($codmedico);
        
    }   
    public function validacups()
    {
        $this->load->model('historia_model');
        $this->load->library('edad');
        $opbuscarcups       =   trim($this->input->post('opbuscarcups', true));
        $sigla_sexo         =   trim($this->input->post('sigla_sexo', true));
        $fechanacimiento    =   $this->input->post('fechanacimiento', true);
        $abuscar            =   trim($this->input->post('abuscar', true));
        $especialidad       =   trim($this->input->post('especialidad', true));
        $contratistas       =   trim($this->input->post('convenio', true));
        
        // limites de edad
        $limiteedad         =   $this->edad->limiteedad($fechanacimiento);
        // busqueda x especialidad 
        if($especialidad == 'todos')
        {
            if($opbuscarcups == 'codigo')
            {
                $consultagen   =   $this->historia_model->conscupscod($abuscar, $contratistas);
            }else if($opbuscarcups == 'descripcion') 
            {
                $consultagen   =   $this->historia_model->conscupsdes($abuscar, $contratistas);
            }  
            
            if($consultagen == '1')
            {
                
                if($opbuscarcups == 'codigo')
                {                    
                    $consultagen =   $this->historia_model->conscupscodsex($abuscar, $sigla_sexo, $contratistas);
                }else if($opbuscarcups == 'descripcion')
                {                 
                    $consultagen =   $this->historia_model->conscupsdessex($abuscar, $sigla_sexo, $contratistas);
                }                
                if($consultagen == '1')
                {
                    if($opbuscarcups == 'codigo')
                    {
                        $consultagen =   $this->historia_model->conscupscodlim($abuscar, $sigla_sexo, $limiteedad, $contratistas);
                    }else if($opbuscarcups == 'descripcion')
                    {
                        $consultagen =   $this->historia_model->conscupsdeslim($abuscar, $sigla_sexo, $limiteedad, $contratistas);
                    }                
                }
            }
            echo $consultagen;
        }else
        {         
            if($opbuscarcups == 'codigo')
            {
                $consulta   =   $this->historia_model->espcupscod($especialidad, $abuscar, $contratistas);
            }else if($opbuscarcups == 'descripcion') 
            {
                $consulta   =   $this->historia_model->espcupsdes($especialidad, $abuscar, $contratistas);
            }
            if($consulta ==  '1')   
            {
                if($opbuscarcups == 'codigo')
                {
                    $consulta   =   $this->historia_model->espsexocupscod($sigla_sexo, $abuscar, $especialidad, $contratistas);
                }else if($opbuscarcups == 'descripcion') 
                {
                    $consulta   =   $this->historia_model->espsexocupsdes($sigla_sexo, $abuscar, $especialidad, $contratistas);
                }
                if($consulta ==  '1')   
                {
                    if($opbuscarcups == 'codigo')
                    {
                        $consulta   =   $this->historia_model->esplimcupscod($sigla_sexo, $abuscar, $especialidad, $limiteedad, $contratistas);
                    }else if($opbuscarcups == 'descripcion') 
                    {
                        $consulta   =   $this->historia_model->espslimcupsdes($sigla_sexo, $abuscar, $especialidad, $limiteedad, $contratistas);
                    }
                }
            }
            echo $consulta;
        }
    } 
 
    // consulta pacientes
    public function resumengenagendamed()
    {
        $this->load->model('historia_model');
        date_default_timezone_set('America/Bogota');
        $fechaingreso       =   date("Y").'-'.date("m").'-'.date("d");
        $horaingreso        =   date("H").':'.date("i").':'.date("s");   
        $cod_medip          =   $this->input->post('cod_medi', true);
        $cmedicopers        =   $this->historia_model->cmedicopers($cod_medip);
        
        if($cmedicopers)
        {
            foreach($cmedicopers as $cmed)
            {
                $cod_medi   =    $cmed['id'];
                
            }
        }else
        {
            $cod_medi   =    '';
        }
        $this->db->trans_start();
          
        if($cod_medi == 'todos')
        {
            $this->datatables->select('p.id_agenda, p.id_paciente, pa.tipo_docu, pa.identificacion, pa.primer_apellido,pa.segundo_apellido,pa.primer_nombre,pa.segundo_nombre, p.fecha, p.horainicio, p.horafin, p.cod_medi, e.nombre as personal, p.cod_listap,p.color, p.estado, l.nombre_listap, p.telefono_paciente,
                p.celular_paciente, p.observaciones, co.nombre_admi, p.id_agenda')
            ->join('listaprecios l', 'l.cod_listap = p.cod_listap')
            ->join('personal e', 'e.id = p.cod_medi')
            ->join('pacientes pa', 'pa.id_paciente = p.id_paciente', 'left outer')
            ->join('contratistas co', 'co.id_contratistas = pa.id_admi')
            ->where('fecha', $fechaingreso)            
            ->from('agenda p');
        }else
        {
            $this->datatables->select('p.id_agenda, pa.tipo_docu, pa.identificacion, pa.primer_apellido,pa.segundo_apellido,pa.primer_nombre,pa.segundo_nombre, p.fecha, p.horainicio, p.horafin, p.cod_medi, e.nombre as personal, p.cod_listap,p.color, p.estado, l.nombre_listap, p.telefono_paciente,
                p.celular_paciente,p.observaciones, co.nombre_admi, p.id_agenda')
            ->join('listaprecios l', 'l.cod_listap = p.cod_listap')
            ->join('personal e', 'e.id = p.cod_medi')
            ->join('pacientes pa', 'pa.id_paciente = p.id_paciente', 'left outer')
            ->join('contratistas co', 'co.id_contratistas = pa.id_admi')
            ->where('fecha', $fechaingreso)
            ->where('p.cod_medi', $cod_medi)
            ->from('agenda p');
        }  
        echo $this->datatables->generate();
        $this->db->trans_complete();        
    }    
 
    public function resumengenbusqueda() 
    {
        $this->db->trans_start();
        $busgeneral = $this->input->post('busgeneral', true);
        $this->datatables->select('p.id_paciente, p.tipo_docu, p.identificacion, p.primer_apellido,p.segundo_apellido,p.primer_nombre,p.segundo_nombre, p.telefono_paciente,
                p.celular_paciente, e.ultimocontrol, e.proximocontrol, co.nombre_admi')
            ->join('encabezado e', 'e.id_paciente = p.id_paciente and e.ref_procesos = "GN" ')
            ->join('contratistas co', 'co.id_contratistas = p.id_admi', 'left outer')
            ->from('pacientes p');
        $this->db->like('identificacion', $busgeneral);
        $this->db->or_like('primer_apellido', $busgeneral);
        $this->db->or_like('segundo_apellido', $busgeneral);
        $this->db->or_like('primer_nombre', $busgeneral);
        $this->db->or_like('segundo_nombre', $busgeneral);

        echo $this->datatables->generate();
        $this->db->trans_complete();
    }
    
    public function resumenruta()
    {
        $this->load->model('historia_model');
        date_default_timezone_set('America/Bogota');
        $fechaingreso       =   date("Y").'-'.date("m").'-'.date("d");
        $horaingreso        =   date("H").':'.date("i").':'.date("s");   
        $cod_medip          =   $this->input->post('cod_medi', true);
        $cmedicopers        =   $this->historia_model->cmedicopers($cod_medip);
        if($cmedicopers)
        {
            foreach($cmedicopers as $cmed)
            {
                $cod_medi   =    $cmed['id'];
                
            }
        }else
        {
            $cod_medi   =    '';
        }
        $this->db->trans_start();
          
        if($cod_medi == 'todos')
        {
            $this->datatables->select('p.id_paciente, p.tipo_docu, p.identificacion, p.primer_apellido,p.segundo_apellido,p.primer_nombre,p.segundo_nombre, p.fecha, p.horainicio, p.horafin, p.cod_medi, e.nombre as personal, p.cod_listap,p.color, p.estado, l.nombre_listap, p.telefono_paciente,
                p.celular_paciente, p.observaciones, co.nombre_admi, p.id_agenda, p.hora_estado')
            ->join('listaprecios l', 'l.cod_listap = p.cod_listap')
            ->join('personal e', 'e.id = p.cod_medi')
            ->join('contratistas co', 'co.id_contratistas = p.id_admi')
            ->where('fecha', $fechaingreso)   
            ->where('estado', 'Asistio')         
            ->from('agenda p');
        }else
        {
            $this->datatables->select('p.id_paciente, p.tipo_docu, p.identificacion, p.primer_apellido,p.segundo_apellido,p.primer_nombre,p.segundo_nombre, p.fecha, p.horainicio, p.horafin, p.cod_medi, e.nombre as personal, p.cod_listap,p.color, p.estado, l.nombre_listap, p.telefono_paciente,
                p.celular_paciente,p.observaciones, co.nombre_admi, p.id_agenda, p.hora_estado')
            ->join('listaprecios l', 'l.cod_listap = p.cod_listap')
            ->join('personal e', 'e.id = p.cod_medi')
            ->join('contratistas co', 'co.id_contratistas = p.id_admi')
            ->where('fecha', $fechaingreso)
            ->where('cod_medi', $cod_medi)
            ->where('estado', 'Asistio')         
            ->from('agenda p');
        }  
        echo $this->datatables->generate();
        $this->db->trans_complete();        
    }                         
}