<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Usuarios extends CI_Controller {
    
    //private $session_id, $session_nombre, $nivel_usuario;     
    public function __construct()
    {
        parent::__construct();            
        $this->load->library('Datatables');       
    }
   
    public function index()
    {            
        $this->load->view('front_end/tecnico/menut_f_v', 301);
    }
    
    public function pantallainicio()
    {
        $this->load->view('front_end/tecnico/pantallainicio_v', 301);
    }
    public function ingreso()
    {        
        $datos['titulo']    =   'Usuario ingreso';
        $this->load->view('front_end/tecnico/admusuing_v', $datos);
    }
    
    public function resumen()
    {
        $this->db->trans_start();
                
        $nivusu     =   "nivel_usuario != '0'";
        $this->datatables->select('u.id, u.nombre,u.nombre2, u.apellido1,u.apellido2,u.cedula, u.login, p.nombre_persona_atie, u.medico, u.activo, u.nivel_usuario')            
            ->join('persona_atiende p','u.cod_persona_atie = p.cod_persona_atie')                  
            ->from('usuarios u');
          
        
        $this->db->where($nivusu);
        $this->db->trans_complete();
        echo $this->datatables->generate();
    
    }
    
    public function modificacion()
    {
        $datos['titulo']    =   'Modificación ingreso';        
        $this->load->view('front_end/tecnico/admusumod_v', $datos);
    }
    
    public function consulta()
    {
        $this->load->model('admon_model');
        $datos['titulo']    =   'Modificación ingreso';
        $datos['consulta']  =   $this->admon_model->consultausuarios();
        $this->load->view('front_end/tecnico/admusucon_v', $datos);
    }
    
    public function tipodocumento()
    {
        $this->load->model('admon_model');
        $tipodocumento  =   $this->admon_model->tipodocumento();
    }
    
    public function pais()
    {
        $this->load->model('admon_model');
        $tipodocumento  =   $this->admon_model->pais();
    }
    
    public function departamento()
    {
        $this->load->model('admon_model');
        $pais       =   $this->input->post('vpais');
        $consulta   =   $this->admon_model->departamento($pais);
    }
    
    public function ciudad()
    {
        $this->load->model('admon_model');
        $pais       =   $this->input->post('vpais');
        $dpto       =   $this->input->post('vdpto');
        $consulta   =   $this->admon_model->ciudad($pais, $dpto);
    }
    
    public function barrio()
    {
        $this->load->model('admon_model');
        $pais       =   $this->input->post('vpais');
        $dpto       =   $this->input->post('vdpto');
        $ciudad     =   $this->input->post('vciudad');
        $consulta   =   $this->admon_model->barrio($pais, $dpto, $ciudad);
    }
    
    public function personaatiende()
    {
        $this->load->model('admon_model');
        $personaatiende =   $this->admon_model->personaatiende();
    }
    
    public function personaatiendemed()
    {
        $this->load->model('admon_model');
        $personaatiende =   $this->admon_model->personaatiendemed();
    }
    
    public function cantidadmedicos()
    {
        $this->load->model('admon_model');
        $cantidadmedicos  =   $this->admon_model->cantidadmedicos();
    }
    
    public function cantidadlicencias()
    {
        $this->load->model('admon_model');
        $cantidadlicencias  =   $this->admon_model->cantidadlicencias();    
    }
    
    public function oplicencias()
    {
        
    }
    
    public function medicoxconsulta()
    {
        $this->load->model('admon_model');
        $personaatiende     =   $this->input->post('personaatiende');
        $datos['consulta']  =   $this->admon_model->medicoxconsulta($personaatiende);
        $this->load->view('front_end/tecnico/admusuing_t_mxc', $datos);       
    }
    public function nivelusuario()
    {
        $this->load->model('admon_model');
        $nivelusuario   =   $this->admon_model->nivelusuario();
    }
    
    public function especialidad()
    {
        $this->load->model('admon_model');
        $especialidad   =   $this->admon_model->especialidad();
    }
    
    public function medicoespecialidad()
    {
        $this->load->model('admon_model');
        $datos['medicoespecialidad'] =   $this->admon_model->medicoespecialidad();
        $this->load->view('front_end/tecnico/admusuing_t_e_v', $datos);
    }
    
    public function consultamedica()
    {
        $this->load->model('admon_model');
        $datos['consultamedica'] =   $this->admon_model->consultamedica();
        $this->load->view('front_end/tecnico/admusuing_t_v', $datos);
    }
    
    public function estadocivil()
    {
        $this->load->model('admon_model');
        $estadocivil   =   $this->admon_model->estadocivil();
    }
    
    public function gruposanguineo()
    {
        $this->load->model('admon_model');
        $gruposanguinero  = $this->admon_model->gruposanguineo();
    }
    
    public function tipoempresaspromotoras()
    {
        $this->load->model('admon_model');
        $tipoempresaspromotoras  = $this->admon_model->tipoempresaspromotoras();
    }
    
    public function administradoras()
    {
        $this->load->model('admon_model');
        $tipo               =   $this->input->post('tipoempresaspromotoras');
        $administradoras    =   $this->admon_model->administradoras($tipo);
    }
    
    public function login()
    {
        $this->load->model('admon_model');
        $login  =   $this->input->post('login', true);
        $clogin =   $this->admon_model->login($login);
    }
    
    public function nuevousuario()
    {
        $this->load->model('admon_model');
        $nuevousuario   =   $this->admon_model->nuevousuario();
        
        $usuario            =   $nuevousuario['idusuario'];
        $consulusu          =   $this->admon_model->cusuario($usuario);
        foreach($consulusu as $row)
        {
            $medico     =   $row['medico'];
            $codmedi    =   $row['cod_medi'];
            if($medico == 'SI')
            {
                $datos['rmedico']   =   'S';
                $datos['cmedico']   =   $this->admon_model->cmedico($codmedi);
            }
            else
            {
                $datos['rmedico']   =   'N';
            }
        }
        $datos['cusuario']  =   $this->admon_model->cusuario($usuario);
        $datos['titulo']    =   'Consulta de usuario';
        $datos['idusuario'] =   $usuario;
        $this->load->view('front_end/tecnico/admusucon_t_v', $datos);
    }
    
    public function consultaridentificacion()
    {
        $this->load->model('admon_model');
        $tipodocu                   =   $this->input->post('valtipo_docu', true);
        $identificacion             =   $this->input->post('validentificacion', true);
        $consultaridentificacion    =   $this->admon_model->consultaridentificacion($tipodocu, $identificacion);
    }    
    
    public function consultaridentificacion1()
    {
        $this->load->model('admon_model');
        $tipodocu                   =   $this->input->post('vtipo_docu');
        $identificacion             =   $this->input->post('videntificacion');
        $consultaridentificacion    =   $this->admon_model->consultaridentificacion($tipodocu, $identificacion);
    }
    
    public function consultarcodigomedico()
    {
        $this->load->model('admon_model');
        $codigomedico           =   trim($this->input->post('valcodigomedico', true));        
        $consultarcodigomedico  =   $this->admon_model->consultarcodigomedico($codigomedico);
    }
    
    public function usuarioamodificar()
    {
        $this->load->model('admon_model');
        $usuario            =   $this->input->post('idusuario', true);        
        $consulusu          =   $this->admon_model->cusuario($usuario);
        foreach($consulusu as $row)
        {
            $medico     =   $row['medico'];
            $codmedi    =   $row['cod_medi'];
            if($medico == 'SI')
            {
                $datos['rmedico']   =   'S';
                $datos['cmedico']   =   $this->admon_model->cmedico($codmedi);
            }
            else
            {
                $datos['rmedico']   =   'N';
            }
        }
        $datos['cusuario']  =   $this->admon_model->cusuario($usuario);
        $datos['titulo']    =   'Modificación de usuarios';
        $datos['idusuario'] =   $usuario;
        $this->load->view('front_end/tecnico/admusumod_t_v', $datos);
    }    
    
    public function vtipodocumento()
    {
        $this->load->model('admon_model');
        $tipodocumento      =   $this->input->post('tipo_docu');
        $vtipodocumento     =   $this->admon_model->vtipodocumento($tipodocumento);
    }
    
    public function vpais()
    {
        $this->load->model('admon_model');
        $pais      =   $this->input->post('cod_pais');
        $vpais     =   $this->admon_model->vpais($pais);
    }
    
    public function vdpto()
    {
        $this->load->model('admon_model');
        $pais      =   $this->input->post('cod_pais');
        $dpto      =   $this->input->post('id_depa');
        $vdpto     =   $this->admon_model->vdpto($pais, $dpto);
    }
    
    public function vmuni()
    {
        $this->load->model('admon_model');
        $pais      =   $this->input->post('cod_pais');
        $dpto      =   $this->input->post('id_depa');
        $muni      =   $this->input->post('id_muni');  
        $vmuni     =   $this->admon_model->vmuni($pais, $dpto, $muni);
    }
    
    public function vbarrio()
    {
        $this->load->model('admon_model');
        $pais      =   $this->input->post('cod_pais');
        $dpto      =   $this->input->post('id_depa');
        $muni      =   $this->input->post('id_muni');
        $barr      =   $this->input->post('id_barr');  
        $vbarrio   =   $this->admon_model->vbarrio($pais, $dpto, $muni, $barr);
    }
    
    public function vestadocivil()
    {
        $this->load->model('admon_model');
        $estadocivil    =   $this->input->post('cod_estado_civi');
        $vestadocivil   =   $this->admon_model->vestadocivil($estadocivil);
    }
    
    public function vgruposanguineo()
    {
        $this->load->model('admon_model');
        $gruposanguineo     =   $this->input->post('cod_grupo_sang');
        $vgruposanguineo    =   $this->admon_model->vgruposanguineo($gruposanguineo);
    }
    
    public function vpersonaatiende()
    {
        $this->load->model('admon_model');
        $personaatiende     =   $this->input->post('cod_persona_atie');
        $vpersonaatiende    =   $this->admon_model->vpersonaatiende($personaatiende);
    }
    
    public function vnivelusuario()
    {
        $this->load->model('admon_model');
        $nivelusuario     =   $this->input->post('nivel_usuario');
        $vnivelusuario    =   $this->admon_model->vnivelusuario($nivelusuario);
    }
    
    public function vadministradoras()
    {
        $this->load->model('admon_model');
        $id_admi     =   $this->input->post('id_admi');
        $vid_admi    =   $this->admon_model->vadministradoras($id_admi);
    }
    
    public function vtipoempresaspromotoras()
    {
        $this->load->model('admon_model');
        $tadministradora     =   $this->input->post('tadministradora');
        $vtadministradora    =   $this->admon_model->vtipoempresaspromotoras($tadministradora);
    }

    public function cespeconsul()
    {
        $this->load->model('admon_model');
        $ccod_medi   =   trim($this->input->post('ccod_medi'));
        $datos  =   array();        
        $datos['especialidad']     =   $this->admon_model->cespecialidad($ccod_medi);
        $datos['consulta']         =   $this->admon_model->cconsulta($ccod_medi);
        
        echo json_encode($datos);
    }
    
    public function modconsultaridentificacion()
    {
        $this->load->model('admon_model');
        $tipodocu                   =   $this->input->post('vtipo_docu');
        $identificacion             =   $this->input->post('videntificacion');
        $idusuario                  =   $this->input->post('idusuario');
        $consultaridentificacion    =   $this->admon_model->modconsultaridentificacion($tipodocu, $identificacion, $idusuario);
    }
    
    public function modlogin()
    {
        $this->load->model('admon_model');
        $login      =   $this->input->post('login');
        $idusuario  =   $this->input->post('idusuario');
        $clogin =   $this->admon_model->modlogin($login, $idusuario);
    }
    
    public function modconsultarcodigomedico()
    {
        $this->load->model('admon_model');
        $codigomedico           =   $this->input->post('codigomedico', true);   
        $idusuario              =   $this->input->post('idusuario', true);     
        $consultarcodigomedico  =   $this->admon_model->modconsultarcodigomedico($codigomedico, $idusuario);
    }
    
    public function modificarusuario()
    {
        $this->load->model('admon_model');
        $idusuario      =   $this->input->post('idusuario', true);
        $activo         =   $this->input->post('activo', true);
        $fechamod       =   $this->input->post('fechamod', true);
        $horamod        =   $this->input->post('horamod', true);
        
        $nuevousuario   =   $this->admon_model->modificarusuario($idusuario, $activo, $fechamod, $horamod);
        
        $usuario            =   $nuevousuario['idusuario'];
        $consulusu          =   $this->admon_model->cusuario($usuario);
        foreach($consulusu as $row)
        {
            $medico     =   $row['medico'];
            $codmedi    =   $row['cod_medi'];
            if($medico == 'SI')
            {
                $datos['rmedico']   =   'S';
                $datos['cmedico']   =   $this->admon_model->cmedico($codmedi);
            }
            else
            {
                $datos['rmedico']   =   'N';
            }
        }
        $datos['cusuario']  =   $this->admon_model->cusuario($usuario);
        $datos['titulo']    =   'Consulta de usuario';
        $datos['idusuario'] =   $usuario;
        $this->load->view('front_end/tecnico/admusucon_t_v', $datos);
    }
    
    public function modificarusuarios()
    {
        $this->load->model('admon_model');
        $nuevousuario   =   $this->admon_model->modificarusuarios();
    }
    
    public function modificarusuarioa()
    {
        $this->load->model('admon_model');
        $nuevousuario   =   $this->admon_model->modificarusuarioa();
    }
    
    public function modificarusuariob()
    {
        $this->load->model('admon_model');
        $nuevousuario   =   $this->admon_model->modificarusuariob();
    }
    
    public function modificarusuarioc()
    {
        $this->load->model('admon_model');
        $nuevousuario       =   $this->admon_model->modificarusuarioc();
        
        $usuario            =   $nuevousuario['idusuario'];
        $consulusu          =   $this->admon_model->cusuario($usuario);
        foreach($consulusu as $row)
        {
            $medico     =   $row['medico'];
            $codmedi    =   $row['cod_medi'];
            if($medico == 'SI')
            {
                $datos['rmedico']   =   'S';
                $datos['cmedico']   =   $this->admon_model->cmedico($codmedi);
            }
            else
            {
                $datos['rmedico']   =   'N';
            }
        }
        $datos['cusuario']  =   $this->admon_model->cusuario($usuario);
        $datos['titulo']    =   'Consulta de usuario';
        $datos['idusuario'] =   $usuario;
        $this->load->view('front_end/tecnico/admusucon_t_v', $datos);
    }
    
    public function usuarioaconsultar()
    {
        $this->load->model('admon_model');
        $usuario            =   $this->input->post('id', true);
        $consulusu          =   $this->admon_model->cusuario($usuario);
        foreach($consulusu as $row)
        {
            $medico     =   $row['medico'];
            $codmedi    =   $row['cod_medi'];
            if($medico == 'SI')
            {
                $datos['rmedico']   =   'S';
                $datos['cmedico']   =   $this->admon_model->cmedico($codmedi);
            }
            else
            {
                $datos['rmedico']   =   'N';
            }
        }
        $datos['cusuario']  =   $this->admon_model->cusuario($usuario);
        $datos['titulo']    =   'Consulta de usuario';
        $datos['idusuario'] =   $usuario;
        $this->load->view('front_end/tecnico/admusucon_t_v', $datos);
    }   
    
    public function errorusuarioingreso()
    {
        $datos['etipo_docu']         =   $this->input->post('etipo_docu');
        $datos['ecedula']            =   $this->input->post('ecedula');        
        $datos['enombre']            =   $this->input->post('enombre');
        $datos['eenombre']           =   $this->input->post('eenombre');
        $datos['eapellido1']         =   $this->input->post('eapellido1');
        $datos['eeapellido1']        =   $this->input->post('eeapellido1');
        $datos['ecod_pais']          =   $this->input->post('ecod_pais');
        $datos['eid_depa']           =   $this->input->post('eid_depa');
        $datos['eid_muni']           =   $this->input->post('eid_muni');
        $datos['eid_barr']           =   $this->input->post('eid_barr');
        $datos['efechanacimiento']   =   $this->input->post('efechanacimiento');
        $datos['ecod_estado_civi']   =   $this->input->post('ecod_estado_civi');
        $datos['ecod_grupo_sang']    =   $this->input->post('ecod_grupo_sang');
        $datos['ecod_persona_atie']  =   $this->input->post('ecod_persona_atie');
        $datos['enivel_usuario']     =   $this->input->post('enivel_usuario');
        $datos['elogin']             =   $this->input->post('elogin');
        $datos['eelogin']            =   $this->input->post('eelogin');
        $datos['epass']              =   $this->input->post('epass');
        $datos['eepass']             =   $this->input->post('eepass');
        $datos['emedico']            =   $this->input->post('emedico');        
        $datos['eid_admi']           =   $this->input->post('eid_admi');
        $datos['erowCount']          =   $this->input->post('erowCount');
        $datos['elicencias']         =   $this->input->post('elicencias');
        $datos['eemedico']           =   $this->input->post('eemedico');
        
        $this->load->view('front_end/tecnico/errores/errorusuarioingreso', $datos);
    }
    
    public function errorprestadoringreso()
    {
        $datos['etipo_docu']        =   $this->input->post('etipo_docu', true);
        $datos['enumero']           =   $this->input->post('enumero', true);
        $datos['ecodigoprestador']  =   $this->input->post('ecodigoprestador', true);
        $datos['elongitudcp']       =   $this->input->post('elongitudcp', true);
        $datos['epais']             =   $this->input->post('epais', true);
        $datos['edepartamento']     =   $this->input->post('edepartamento', true);       
        $datos['eciudad']           =   $this->input->post('eciudad', true);
        $datos['ebarrio']           =   $this->input->post('ebarrio', true);
        $datos['edireccion']        =   $this->input->post('edireccion', true);
        $datos['elicencias']        =   $this->input->post('elicencias', true);
        $this->load->view('front_end/tecnico/errores/errorprestadoringreso', true, $datos);
    }
    
    public function firma()
    {
        $datos['titulo']    =   'Firma médico'; 
        $this->load->view('front_end/tecnico/firmam_v', $datos);
    }
    
    public function firmamedico()
    {
        $this->load->model('admon_model');
        $firma      =   $this->input->post('firmamedi');
        $ingfirma   =   $this->admon_model->firmamedico($firma); 
        $this->load->view('front_end/tecnico/firmam_v', $datos);
    }

    // firma para medico
    public function firma_medico()
    {        
        $datos['titulo']    =   'Ingreso firma a médico';
        $this->load->view('front_end/tecnico/firma_medico_v', $datos);
    }

    // consulta solo medicos
    public function resumen_medicos()
    {
        $this->db->trans_start();
        $nivusu     =   "nivel_usuario != '0'";
        $this->datatables->select('id_medi, primer_nombre_medi, segundo_nombre_medi, primer_apellido_medi, segundo_apellido_medi')            
            ->from('medicos u');
        $this->db->where('activo', 'SI');
        $this->db->trans_complete();
        echo $this->datatables->generate();
    }

    // seleccion de medico a actualizar la firma
    public function medico_modificar()
    {
        $this->load->model('admon_model');
        $id_medi            =   $this->input->post('id_medi', true);    
        $datos['primer_n']  =   $this->input->post('primer_n', true);
        $datos['segundo_n'] =   $this->input->post('segundo_n', true);
        $datos['primer_a']  =   $this->input->post('primer_a', true);
        $datos['segundo_a'] =   $this->input->post('segundo_a', true);

        $consulusu          =   $this->admon_model->consulta_medico($id_medi);
        if($consulusu)
        {
            foreach($consulusu as $cf)
            {
                $datos['firmamedi'] = $cf['firmamedi'];
            }
        }
        
        $datos['titulo']    =   'Actualización de firma en médicos';
        $datos['id_medi']   =   $id_medi;
        $this->load->view('front_end/tecnico/actualizar_fima_v', $datos);
    }  

    // actualiza firma medico
    public function actualizar_firma_medico()
    {
        $this->load->library('imagenes');
        $this->load->model('admon_model');
        $id_medi = $this->input->post('id_medi', true);

        $cp     =   "output/";
        

        if($this->input->post('nfoto')) 
        {
            $u_foto_firma    = $this->imagenes->base64_img($this->input->post('nfoto'),("fm_" . uniqid($this->input->post('id_medi', true) . "_", true)), $cp);

            
            $v_foto    = $this->imagenes->Upload($u_foto_firma, "fm_r_" . uniqid($this->input->post('id_medi', true) . "_", true), $cp);  

            $up_foto = $cp.$u_foto_firma;

        } else 
        {
            
            $up_foto = '';
        }

        $m_firma = array(
            'firmamedi'     =>  $up_foto);

        $actualiza_firma = $this->admon_model->actualiza_firma($m_firma, $id_medi);
    }
          
}