<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Abono extends CI_Controller {
    
         
    public function __construct()
    {
        parent::__construct();             
        $this->load->library('Datatables');       
    }
   
    public function index()
    { 
        //$this->load->model('historia_model');
//        $id_usuario             =   $this->session_idusuario;
//        $persona_atiende        =   $this->historia_model->persona_atiende($id_usuario);
//        foreach($persona_atiende as $persona)
//        {
//            $datos['cod_persona_atie']      =   $persona['cod_persona_atie'];
//            $nombre_persona_atie            =   $persona['nombre_persona_atie'];
//            $datos['login']                 =   $persona['login'];
//        }
//        $datos['id_usuario']                =   $this->session_idusuario;
        $this->load->view('front_end/historias/estadodecuenta_v',301);
    }
    
    public function consultacotizaciones()
    {        
        $identificacion         =   $this->input->post('identificacion', true);
        $cod_medi               =   $this->input->post('cod_medi', true);
        
        $this->datatables->select("ref_procesos, numero_docu, identificacion_paci, valor_bruto, valor_descuento, valor_iva, valor_total, documento_ref, fechaingreso, horaingreso, proceso_ref, cod_medi, id_admi, cod_cons, tipo_docu, total_abonos")
        ->where('identificacion_paci', $identificacion)       
        ->where('cod_medi', $cod_medi)
        ->where('ref_procesos', 'CT')
        ->from('encabezado');
        
                
        echo $this->datatables->generate(); 
    }
    
    public function ingreso()
    {
        $this->load->model('historia_model');
        $datos['cod_persona_atie']  =   $this->input->post('cod_persona_atie');
        $datos['id_usuario']        =   $this->input->post('id_usuario');
        $datos['nivel_usuario']     =   $this->input->post('nivel_usuario');  
        $datos['id_paciente']       =   $this->input->post('id_paciente');
        $datos['id_admi']           =   $this->input->post('id_admi');
        
        $datos['tipoabono']     =   $this->historia_model->tipoabono();
        $datos['banco']         =   $this->historia_model->banco();
        $datos['consultorios']  =   $this->historia_model->consultorios();
        $this->load->view('front_end/historias/abonoingreso_v', $datos);
        //$this->load->view('front_end/historias/estadodecuenta_v', $datos);
    }
           
    public function aboingreso()
    {
        $this->load->model('historia_model');
        $data           =   $this->historia_model->aboingreso();
        
        // VARIABLES DE RECUPERACION 
        $numero_docu    =   $data['numero_docu'];
        $identificacion =   $data['identificacion'];
        $tipo_docu      =   $data['tipo_docu'];
        $ref_procesos   =   $data['ref_procesos'];
        
        $datos['numero_docu']    =   $data['numero_docu'];
        $datos['identificacion'] =   $data['identificacion'];
        $datos['tipo_docu']      =   $data['tipo_docu'];
        $datos['ref_procesos']   =   $data['ref_procesos'];
        
        // PRESTADOR
        $consultaprestador  =   $this->historia_model->consultaprestador();
        foreach($consultaprestador as $cpres)
        {
            $datos['pnumero']        =   $cpres['numero'];
            $datos['pnombre']        =   $cpres['nombre'];
            $datos['pdireccion']     =   $cpres['direccion'];
            $datos['ptelefonos']     =   $cpres['telefono1'].' '.$cpres['telefono2'];
            $datos['plogo']          =   $cpres['logopresatador'];   
        }
        
        // ENCABEZADO DE LA COTIZACION
        $consultaect    =   $this->historia_model->consultaect($tipo_docu, $identificacion, $ref_procesos, $numero_docu);
        foreach($consultaect as $cct)
        {
            $datos['numeroct']   =   $cct['numero_docu'];
            $datos['valorbrct']  =   $cct['valor_bruto'];
            $datos['valordesc']  =   $cct['valor_descuento'];
            $datos['valortota']  =   $cct['valor_total'];
            $datos['fechact']    =   $cct['fechaingreso'];
            
        }
        
        // DETALLES DE LA COTIZACION
        $datos['consultadct']    =   $this->historia_model->consultadct($numero_docu);
        
        
        // EXCANBEZADO RECIBO DE CAJA     
        $consultacot    =   $this->historia_model->consultarcn($numero_docu);
        if($consultacot)
        {
            foreach($consultacot as $ccot)
            {
                $datos['fecha']         =   $ccot['fechaingreso'];
                $datos['numero_docu']   =   $ccot['numero_docu'];            
                $datos['valor']         =   $ccot['valor_total'];
                $numerodocu             =   $ccot['numero_docu'];
            }
            // DETALLES DEL RECIBO DE CAJA
            $datos['consultacotd']   =   $this->historia_model->consultacotd($numerodocu, $numero_docu);
        }else
        {
            $datos['fecha']         =   '';
            $datos['numero_docu']   =   '';            
            $datos['valor']         =   '';
            $datos['consultacotd']  =   '';
        }  
        
        
        
             
        // PACIENTE
        $consultapaciente   =   $this->historia_model->consultapaciente($identificacion, $tipo_docu);
        foreach($consultapaciente as $cpac)
        {
            $datos['cidentificacion']    =   $cpac['identificacion'];
            $datos['cnombre']            =   $cpac['primer_nombre'].' '.$cpac['segundo_nombre'].' '.$cpac['primer_apellido'].' '.$cpac['segundo_apellido'];
            $datos['cdireccion']         =   $cpac['direccion_paci'];
            $datos['ctelefonos']         =   $cpac['telefono_paciente']. ' ' . $cpac['celular_paciente'];
        }
        
        $this->load->view('front_end/historias/abonoingreso_r_v', $datos);
    }
    
    public function modificacion()
    {
        $this->load->view('front_end/historias/abonomodificacion_v',301);
    }
    
    public function consulta()
    {
        $this->load->view('front_end/historias/abonoconsulta_v',301);
    }
    
    public function consultaabonocan()
    {
        $this->db->trans_start();
        $identificacion     =   $this->input->post('identificacion', true);
        $cod_medi           =   $this->input->post('cod_medi', true);      
        $this->datatables->select('ref_procesos,numero_docu,identificacion_paci,documento_ref, valor_total, fechaingreso, cod_medi')
            ->where('identificacion_paci', $identificacion)
            ->where('cod_medi', $cod_medi)
            ->where('ref_procesos', 'RC')
            ->where('estado', 'ACTIVO')
            ->unset_column('identificacion_paci')
            ->from('encabezado');
        echo $this->datatables->generate();
        $this->db->trans_complete();
    }
    
    public function consuldetallesabo()
    {
        $this->load->model('historia_model');
        $numero_docu        =   trim($this->input->post('numero_docu', true));
        $documento_ref      =   trim($this->input->post('documento_ref', true));
        $ref_procesos       =   trim($this->input->post('ref_procesos', true));
        $fechaabono         =   $this->input->post('fechaabo', true);
        $valort             =   $this->input->post('valort', true);
        $datos['proceso']   =   $this->input->post('proceso', true);
        
        $datos['consulta']  =   $this->historia_model->consuldetallesabo($numero_docu, $documento_ref, $ref_procesos);
        $datos['anumero']   =   $numero_docu;
        $datos['adocref']   =   $documento_ref;
        $datos['arefpro']   =   $ref_procesos;
        $datos['afechaa']   =   $fechaabono;
        $datos['valort']    =   $valort;
        $this->load->view('front_end/historias/abonodetalle_v',$datos);
    }
    
    public function eliminarabono()
    {
        $this->load->model('historia_model');
        $refprocesos        =   $this->input->post('abonotipo', true);
        $numerodocu         =   $this->input->post('abonodocu', true);
        $documentoref       =   $this->input->post('abonocoti', true);
        $valorabono         =   $this->input->post('valort', true);
        $histlogin          =   $this->input->post('histlogin', true);
        $proceso            =   $this->historia_model->eliminarabono($refprocesos, $numerodocu, $documentoref, $valorabono, $histlogin);
    }
    
    public function repabono()
    {
        $this->load->model('historia_model');
        $this->load->library('pdf');
        // VARIABLE QUE LLEGAN X POST
        $numero_docu        =   trim($this->input->post('numero_docu', true));
        $ref_procesos       =   trim($this->input->post('ref_procesos', true));
        $tipo_docu          =   trim($this->input->post('tipo_docu', true));
        $identificacion     =   trim($this->input->post('identificacion', true));
        
        
        // PRESTADOR
        $consultaprestador  =   $this->historia_model->consultaprestador();
        foreach($consultaprestador as $cpres)
        {
            $datos['pnumero']        =   $cpres['numero'];
            $datos['pnombre']        =   $cpres['nombre'];
            $datos['pdireccion']     =   $cpres['direccion'];
            $datos['ptelefonos']     =   $cpres['telefono1'].' '.$cpres['telefono2'];
            $datos['plogo']          =   $cpres['logopresatador'];   
        }
        
        // ENCABEZADO DE LA COTIZACION
        $consultaect    =   $this->historia_model->consultaect($tipo_docu, $identificacion, $ref_procesos, $numero_docu);
        foreach($consultaect as $cct)
        {
            $datos['numeroct']   =   $cct['numero_docu'];
            $datos['valorbrct']  =   $cct['valor_bruto'];
            $datos['valordesc']  =   $cct['valor_descuento'];
            $datos['valortota']  =   $cct['valor_total'];
            $datos['fechact']    =   $cct['fechaingreso'];
            
        }
        
        // DETALLES DE LA COTIZACION
        $datos['consultadct']    =   $this->historia_model->consultadct($numero_docu);
        
        
        // EXCANBEZADO RECIBO DE CAJA     
        $consultacot    =   $this->historia_model->consultarcn($numero_docu);
        if($consultacot)
        {
            foreach($consultacot as $ccot)
            {
                $datos['fecha']         =   $ccot['fechaingreso'];
                $datos['numero_docu']   =   $ccot['numero_docu'];            
                $datos['valor']         =   $ccot['valor_total'];
                $numerodocu             =   $ccot['numero_docu'];
            }
            // DETALLES DEL RECIBO DE CAJA
            $datos['consultacotd']   =   $this->historia_model->consultacotd($numerodocu, $numero_docu);
        }else
        {
            $datos['fecha']         =   '';
            $datos['numero_docu']   =   '';            
            $datos['valor']         =   '';
            $datos['consultacotd']  =   '';
        }  
             
        
        //////////////////////////////
        // PRESTADOR
        $prestador      =   $this->historia_model->consultaprestador();
        foreach($prestador as $pres)
        {
            $nombre         =   $pres['nombre'];
            $direccion      =   $pres['direccion'];
            $telefono       =   $pres['telefono1'];
            $celular        =   $pres['celular1'];
            $email          =   $pres['email'];
            $sitioweb       =   $pres['sitioweb'];
        }
        
        // ENCABEZADO RECIBO DE CAJA
        $cencarc        =   $this->historia_model->cencarc($numero_docu, $ref_procesos);
        foreach($cencarc as $cenc)
        {
            $cpaciente          =   $cenc['nombre'];
            $ctipo_docu         =   $cenc['tipo_docu'];
            $cidentificacion    =   $cenc['identificacion_paci'];
            $cfechaingreso      =   $cenc['fechaingreso'];
            $choraingreso       =   $cenc['horaingreso'];
            $cvalor_total       =   $cenc['valor_total'];
            $cdireccion_paci    =   $cenc['direccion_paci'];
            $ctelefonop         =   $cenc['telefonop'];
            $cemail_paciente    =   $cenc['email_paciente'];
            
        }
        // DETALLES RC
        $cdetarc        =   $this->historia_model->cdetarc($numero_docu, $ref_procesos);
        
        
        
        
        // SALDO 
        $totalct        =   $this->historia_model->totalct($tipo_docu, $identificacion);
        if($totalct)
        {
            foreach($totalct as $tct)
            {
                $vtotalct   =   $tct['valor_total'];
            }
        }else
        {
                $vtotalct   =   0;
        }    
        
        $totalrc        =   $this->historia_model->totalrc($tipo_docu, $identificacion);
        if($totalrc)
        {
            foreach($totalrc as $trc)
            {
                $vtotalrc   =   $trc['valor_total'];
            }
        }else
        {
                $vtotalrc   =   0;
        }    
        
        $saldo  =   $vtotalct - $vtotalrc;
        
        ///////////////////////////
        
        
        // GENERACION DEL REPORTE
        $this->pdf = new PDF();
        $npaciente  =   $cpaciente;
        
        $this->pdf->npaciente           =   $npaciente;
        $this->pdf->numero_docu         =   $numero_docu;
        $this->pdf->cdireccion_paci     =   $cdireccion_paci;
        $this->pdf->ctelefonop          =   $ctelefonop;
        $this->pdf->cfechaingreso       =   $cfechaingreso;
        $this->pdf->cemail_paciente     =   $cemail_paciente;
        $this->pdf->choraingreso        =   $choraingreso;
         
        $this->pdf->AliasNbPages();                
        $this->pdf->AddPage();
        
        $this->pdf->SetFillColor(200,200,200);
        $this->pdf->SetMargins(10, 15 , 15);
        $this->pdf->SetAutoPageBreak(true,175);  
        
        $this->pdf->SetFont('helvetica', '', 9);
        $this->pdf->SetTitle('Reporte Recibo de Caja', false);

        $this->pdf->datospaciente($npaciente, $numero_docu, $cdireccion_paci, $ctelefonop, $cfechaingreso, $cemail_paciente, $choraingreso, $cdetarc);


        $this->pdf->Ln(30);
        $this->pdf->Cell(10,4,utf8_decode('   '),0,0,'L');  
        $this->pdf->Ln(15);
        $this->pdf->SetX(150);
        $this->pdf->Cell(10,4,utf8_decode('Valor Total'),0,0,'L');
        $this->pdf->SetX(185);
        $this->pdf->Cell(20, 5, number_format($cvalor_total), 1, 0, 'R', 1);
        $this->pdf->Ln(5);
         //IMPRESION DEL SALDO
        $this->pdf->SetX(150);
        $this->pdf->Cell(10,4,utf8_decode('Saldo'),0,0,'L');
        $this->pdf->SetX(185);
        $this->pdf->Cell(20,5,number_format($saldo), 1, 0, 'R', 1);
        
        $this->pdf->SetY(105);
        $this->pdf->Cell(10,4,utf8_decode('Firma del paciente'),0,0,'L');   
        $this->pdf->Ln(10);
        $this->pdf->Cell(10,4,utf8_decode('________________'),0,0,'L');       
        
        /*
         * Se manda el pdf al navegador
         *
         * $this->pdf->Output(nombredelarchivo, destino);
         *
         * I = Muestra el pdf en el navegador
         * D = Envia el pdf para descarga
         *
         */
        //$this->pdf->Output();
        $this->pdf->Output("Recibo de caja No. ".$numero_docu.".pdf", 'I');
    }
}