<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');
class Eps extends CI_Controller 
{
    public function __construct()
    {
        parent::__construct();
        $this->load->helper(array('download', 'file')); 
        $this->load->library('pdf');
        $this->load->helper(array('url'));
        $this->load->library('Datatables');        
    }

    public function validacups()
    {
        $this->load->model('historia_model');
        $this->load->library('edad');
        $opbuscarcups       =   trim($this->input->post('opbuscarcups', true));
        $sigla_sexo         =   trim($this->input->post('sigla_sexo', true));
        $fechanacimiento    =   $this->input->post('fechanacimiento', true);
        $abuscar            =   trim($this->input->post('abuscar', true));
        $especialidad       =   trim($this->input->post('especialidad', true));
        $contratistas       =   trim($this->input->post('convenio', true));
        
        // limites de edad
        $limiteedad         =   $this->edad->limiteedad($fechanacimiento);
        // busqueda x especialidad 
        if($especialidad == 'todos')
        {
            if($opbuscarcups == 'codigo')
            {
                $consultagen   =   $this->historia_model->conscupscod($abuscar, $contratistas);
            }else if($opbuscarcups == 'descripcion') 
            {
                $consultagen   =   $this->historia_model->conscupsdes($abuscar, $contratistas);
            }  
            
            if($consultagen == '1')
            {
                
                if($opbuscarcups == 'codigo')
                {                    
                    $consultagen =   $this->historia_model->conscupscodsex($abuscar, $sigla_sexo, $contratistas);
                }else if($opbuscarcups == 'descripcion')
                {                 
                    $consultagen =   $this->historia_model->conscupsdessex($abuscar, $sigla_sexo, $contratistas);
                }                
                if($consultagen == '1')
                {
                    if($opbuscarcups == 'codigo')
                    {
                        $consultagen =   $this->historia_model->conscupscodlim($abuscar, $sigla_sexo, $limiteedad, $contratistas);
                    }else if($opbuscarcups == 'descripcion')
                    {
                        $consultagen =   $this->historia_model->conscupsdeslim($abuscar, $sigla_sexo, $limiteedad, $contratistas);
                    }                
                }
            }
            echo $consultagen;
        }else
        {         
            if($opbuscarcups == 'codigo')
            {
                $consulta   =   $this->historia_model->espcupscod($especialidad, $abuscar, $contratistas);
            }else if($opbuscarcups == 'descripcion') 
            {
                $consulta   =   $this->historia_model->espcupsdes($especialidad, $abuscar, $contratistas);
            }
            if($consulta ==  '1')   
            {
                if($opbuscarcups == 'codigo')
                {
                    $consulta   =   $this->historia_model->espsexocupscod($sigla_sexo, $abuscar, $especialidad, $contratistas);
                }else if($opbuscarcups == 'descripcion') 
                {
                    $consulta   =   $this->historia_model->espsexocupsdes($sigla_sexo, $abuscar, $especialidad, $contratistas);
                }
                if($consulta ==  '1')   
                {
                    if($opbuscarcups == 'codigo')
                    {
                        $consulta   =   $this->historia_model->esplimcupscod($sigla_sexo, $abuscar, $especialidad, $limiteedad, $contratistas);
                    }else if($opbuscarcups == 'descripcion') 
                    {
                        $consulta   =   $this->historia_model->espslimcupsdes($sigla_sexo, $abuscar, $especialidad, $limiteedad, $contratistas);
                    }
                }
            }
            echo $consulta;
        }
    } 
    
    public function busquedacups1()
    {        
        $this->load->library('edad');
        $opbuscarcups       =   trim($this->input->post('opbuscarcups', true));
        $sigla_sexo         =   trim($this->input->post('sigla_sexo', true));
        $fechanacimiento    =   $this->input->post('fechanacimiento', true);
        $abuscar            =   trim($this->input->post('abuscar', true));
        $especialidad       =   trim($this->input->post('especialidad', true));
        $id_contratista     =   trim($this->input->post('convenio', true));
        // GENERACION DE LIMITEEDAD
        date_default_timezone_set('America/Bogota');
        $ma                     = 12;
        $fechan                 = $fechanacimiento;
        $edadpaciente           = '';
        $totaldiasmes           = '';
        list($Y,$m,$d)          = explode("-",$fechan);            
        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
        $edadpaciente           = intval($edadpaciente);
        $mn                     = intval($m);  
        $dn                     = intval($d);
        $mesactual              = intval(date("m"));
        $diaactual              = intval(date("d"));            
        $mesanterior            = '';     
        $anocomp                = '';     
        $anoactual              = intval(date("Y")); 
        $anon                   = $Y;
                  
        if($mn == 2)
        {
            $totaldiasmes       = 28;
        }
        if($dn == 31)
        {
            $dn = $dn - 1;
        }
        if($mn == 2 && $dn >= 29)
        {
            $dn = 28;
        }
        //$edad = $edadpaciente;
        
        if($edadpaciente == 0)
        {             
            //MESES ACTUALES DEL PACIENTE               
           
            if($mesactual == 1)
            {
                $mesanterior = 12;
            }                
            else
            {
                $mesanterior = $mesactual - 1;
            }
            
            if($mesanterior == $mn || $mn == $mesactual)
            {
                if($mn == $mesactual)
                {
                    $edadresultado = $diaactual - $dn;
                }
                else
                {
                    $edadresultado = $diaactual + 30 - $dn;
                    
                }
                
                if($edadresultado >= 31)
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;                        
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    if($edadresultado > 1)
                    {
                        $edad = $edadresultado.' '.'das';
                        $redadpaciente          =   $edadresultado;
                        $vl                     =   $redadpaciente;
                        $rl                     =   2;                        
                        $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                        $limiteedad             =   $rl.$vl;
                        $pcara                  =   $rl.$vl;
                        $dpcara                 =   substr($pcara, 0, 1);                            
                        $dscara                 =   substr($pcara, 1, 2);
                    }  
                    else
                    {
                        if($edadresultado <= 1)
                        {
                            $horanacimiento         =   $paci['hora_nacimiento'];
                            list($hor,$min,$seg)    =   explode(":",$horanacimiento);
                            $horaactual             =   date("h");
                            $minutosactuales        =   intval(date("i"));
                            
                            if(intval($diaactual) == intval($d))
                            {
                                $horaresultado          =   $horaactual - intval($hor);
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                            }
                            else
                            {
                                $horav                  =   24;
                                $horaresultado          =   $horav - $hor + $horaactual;                                    
                                $edad                   =   $horaresultado.' '.'horas';
                                $redadpaciente          =   $horaresultado;
                                $vl                     =   $redadpaciente;
                                $rl                     =   1;                        
                                $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                $limiteedad             =   $rl.$vl;
                                $pcara                  =   $rl.$vl;
                                $dpcara                 =   substr($pcara, 0, 1);                            
                                $dscara                 =   substr($pcara, 1, 2);
                                if($horaresultado > 24)
                                {
                                    $horaresultado = '1 das';                                        
                                    $edad                   =   '1 das';
                                    $redadpaciente          =   1;
                                    $vl                     =   $redadpaciente;
                                    $rl                     =   2;                        
                                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                                    $limiteedad             =   $rl.$vl;
                                    $pcara                  =   $rl.$vl;
                                    $dpcara                 =   substr($pcara, 0, 1);                            
                                    $dscara                 =   substr($pcara, 1, 2);
                                }
                                else
                                {
                                    
                                }
                                
                            }
                            
                        }
                    }                  
                }
            }
            else
            {
                $anocomp        = $anoactual - 1;
                if($anocomp == $anon)
                {
                    $edad                   =   12 - $mn + $mesactual.' '.'meses';
                    $redadpaciente          =   12 - $mn + $mesactual;
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
                else
                {
                    $edad                   =   $mesactual - $mn.' '.'meses';
                    $redadpaciente          =   $mesactual - $mn;       
                    $vl                     =   $redadpaciente;
                    $rl                     =   3;
                    $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
                    $limiteedad             =   $rl.$vl;
                    $pcara                  =   $rl.$vl;
                    $dpcara                 =   substr($pcara, 0, 1);                            
                    $dscara                 =   substr($pcara, 1, 2);
                }
            }
        }
        else
        {
            $edad                   =   $edadpaciente .' '.'aos';
            $redadpaciente          =   $edadpaciente;
            $vl                     =   $redadpaciente;
            $rl                     =   4;
            $vl                     =   ($vl < 10) ? '0'.$vl : $vl;
            $limiteedad             =   $rl.$vl;
            $pcara                  =   $rl.$vl;
            $dpcara                 =   substr($pcara, 0, 1);                            
            $dscara                 =   substr($pcara, 1, 2);
        }
        
        // CONSULTAS
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";
        
        if($especialidad == 'todos')
        {
            if($opbuscarcups == 'codigo')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('contratistas_cups');
                 
                $names = array('A', $sigla_sexo );
                $this->db->like("cod_cups", $abuscar); 
                $this->db->where('id_contratistas', $id_contratista);
                $this->db->where_in('sexo', $names);
            }else if($opbuscarcups == 'descripcion')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('contratistas_cups');
                
                $names = array('A', $sigla_sexo );
                $this->db->like("nombre_cups", $abuscar);  
                $this->db->where('id_contratistas', $id_contratista);                  
                $this->db->where_in('sexo', $names);
            }    
        }else
        {
            if($opbuscarcups == 'codigo')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('contratistas_cups');
                $this->db->where('cod_cups_tipopro', $especialidad); 
                $names = array('A', $sigla_sexo );
                $this->db->like("cod_cups", $abuscar); 
                $this->db->where('id_contratistas', $id_contratista);
                $this->db->where_in('sexo', $names);
            }else if($opbuscarcups == 'descripcion')
            {
                $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->filter($ledad)                    
                ->from('contratistas_cups');
                
                $this->db->where('cod_cups_tipopro', $especialidad);
                $names = array('A', $sigla_sexo );
                $this->db->like("nombre_cups", $abuscar);  
                $this->db->where('id_contratistas', $id_contratista);                  
                $this->db->where_in('sexo', $names);
            }
        }        
        
        echo $this->datatables->generate();         
    }

    public function busquedacups()
    {     
        $this->db->trans_start();   
        $opbuscarcups       =   trim($this->input->post('opbuscarcups', true));
        $abuscar            =   trim($this->input->post('abuscar', true));
        $id_contratista     =   trim($this->input->post('convenio', true));
        
        if($opbuscarcups == 'codigo')
        {
            $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->where('id_contratistas', $id_contratista)
                ->from('contratistas_cups');
                
                $this->db->like("cod_cups", $abuscar);
                //$this->db->or_like("nombre_cups", $abuscar); 
        } 
        else if($opbuscarcups == 'descripcion')
        {       

            $this->datatables->select("cod_cups, nombre_cups, id_cups, cupsmaxvecesdia, cupsmaxvecesvida, cupstiempolimitedias,     
                cupsconcie, cupstipoatencion, cupstipoprocedimiento, cod_cups_tipopro, valor")
                ->where('id_contratistas', $id_contratista)
                ->from('contratistas_cups');
                
                //$this->db->like("cod_cups", $abuscar);
                $this->db->or_like("nombre_cups", $abuscar); 
        } 
        
        
        echo $this->datatables->generate();   
        $this->db->trans_complete();      
    }
                       
}