<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Examen extends CI_Controller {
    
    
    public function __construct()
    {
        parent::__construct();                
        $this->load->helper(array('download', 'file'));  
        $this->load->library('pdf');
        $this->load->helper(array('url'));
        $this->load->library('Datatables'); 
    }

    public function detallecontroles()
    {
        $this->load->model('examen_model');

        $cons_examen                =   $this->input->post('cons_examen', true);              
        $id_paciente                =   $this->input->post('id_paciente', true);
        $datos['id_paciente']       =   $id_paciente;
        $datos['examen']            =   $this->examen_model->detallesexamen($cons_examen, $id_paciente);        
        $datos['cie']               =   $this->examen_model->ciexamencie($id_paciente, $cons_examen);
        $datos['cups']              =   $this->examen_model->cicups($id_paciente, $cons_examen);
        
        $this->load->view('front_end/historias/hexamen_de_v', $datos);
    }
   
    public function ingresoexamen() 
    {

        ///$this->load->library('imagenes');

        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen = $this->examen_model->consultaconsecutivo(7);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);

        $fechan      = $this->input->post('fechanacimiento', true);
        $datos['nconsulta'] =  $this->input->post('nconsulta', true);
        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /**
         * Subir firmas y foto
         */

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'               =>  $id_paciente,
            'cons_examen'               =>  $n_conexamen,
            'fechaactual'               =>  $fechaactual,
            'horaactual'                =>  $horaactual,
            'nconsulta'                 =>  $this->input->post('nconsulta', true),
            'login_ing'                 =>  $this->input->post('login', true),
            'edad'                      =>  $edad,
            'ume'                       =>  $ume,
            'cod_cons'                  =>  $this->input->post('codconsulta', true),
            'observacionescups'         =>  $this->input->post('observacionescups', true),
            'firmapaci'                 =>  $this->input->post('firmapaciente1'),
            'firmamedi'                 =>  $this->input->post('firmamedico1'),
            'cod_medi'                  =>  $this->input->post('medico', true),
            'id_admi'                   =>  $this->input->post('convenios', true),
            //'cod_consultorio'           =>  $this->input->post('consultorios', true),
            'num_oftalmologia'          =>  $this->input->post('num_oftalmologia', true),
            'motivo_control'            =>  $this->input->post('motivo_control', true),
            'antecedentes_personales'   =>  $this->input->post('antecedentes_personales', true),
            'parpados'                  =>  $this->input->post('parpados', true),
            'conjuntiva'                =>  $this->input->post('conjuntiva', true),
            'viaslagrimales'            =>  $this->input->post('viaslagrimales', true),
            'cornea'                    =>  $this->input->post('cornea', true),
            'camara'                    =>  $this->input->post('camara', true),
            'iris'                      =>  $this->input->post('iris', true),
            'pupila'                    =>  $this->input->post('pupila', true),
            'cristalino'                =>  $this->input->post('cristalino', true),
            'excavacion'                =>  $this->input->post('excavacion', true),
            'retina'                    =>  $this->input->post('retina', true),
            'fo'                        =>  $this->input->post('fo', true),
            'tension'                   =>  $this->input->post('tension', true),
            'tipo_co'                   =>  $this->input->post('tipo_co', true),
            'abierta'                   =>  'SI',
            'planotratamiento'          =>  $this->input->post('planotratamiento', true),
            'id_agenda'                 =>  $this->input->post('id_agenda', true),
            'incapacidades'          =>  $this->input->post('incapacidades', true)
        );

        $insertExa = $this->examen_model->insertExa($examen, $n_conexamen);

        $vcod_cier = $this->input->post('cod_cier', true);

        if (!$vcod_cier || $vcod_cier === '') {
            $cod_cier       =   '';
            $nombre_cier    =   '';
        } else {
            $cod_cier       =   $vcod_cier;
            $nombre_cier    =   $this->input->post('nombre_cier');
        };

        $vcod_ciers = $this->input->post('cod_ciers', true);

        if (!$vcod_ciers || $vcod_ciers === '') {
            $cod_ciers      =   '';
            $nombre_ciers   =   '';
        } else {
            $cod_ciers      =   $vcod_ciers;
            $nombre_ciers   =   $this->input->post('nombre_ciers');
        };

        $vcod_cierr = $this->input->post('cod_cierr', true);

        if (!$vcod_cierr || $vcod_cierr === '') {
            $cod_cierr      =   '';
            $nombre_cierr   =   '';
        } else {
            $cod_cierr      =   $vcod_cierr;
            $nombre_cierr   =   $this->input->post('nombre_cierr');
        };

        $ciecups = array(
            'id_paciente'        => $id_paciente,
            'cons_examen'        => $n_conexamen,
            'nconsulta'          => $this->input->post('nconsulta', true),
            //'tipo_docu'          => $tipo_docu,
            //'identificacion'     => $identificacion,
            'edad'               => $edad,
            'ume'                => $ume,
            'cod_cie'            => $this->input->post('cod_cie'),
            'nombre_cie'         => $this->input->post('nombre_cie'),
            'cod_causa_dia'      => $this->input->post('causa', true),
            'cod_fina_cie'       => $this->input->post('finalidad2', true),
            'cod_tipo'           => $this->input->post('tipoo', true),
            'observacionescie'   => $this->input->post('observacionescie', true),
            'cod_cier'           => $cod_cier,      
            'nombre_cier'        => $nombre_cier,          
            'observacionescier'  => $this->input->post('observacionescier', true),
            'cod_ciers'          => $cod_ciers,
            'nombre_ciers'       => $nombre_ciers,
            'observacionesciers' => $this->input->post('observacionesciers', true),
            'cod_cierr'          => $cod_cierr,
            'nombre_cierr'       => $nombre_cierr,
            'observacionescierr' => $this->input->post('observacionescierr', true),
            'fechaactual'        => $fechaactual,
            'horaactual'         => $horaactual,
            'cod_medi'           => '110010756401',
            'cod_cons'           => $this->input->post('codconsulta'),
            'login_ing'          => $this->input->post('login', true),
            'id_admi'            => $this->input->post('convenios', true),
            'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
            //'revolucion'         => 'SI',
            //'nevolucion'         => $this->input->post('version', true),
            'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
            'activo'             => 'SI'
        );

        $this->examen_model->insertCieCups($ciecups);

        $cod_cups = $this->input->post('cod_cups');

        if ($cod_cups) {

            for ($i = 0; $i < count($this->input->post('cod_cups')); $i++) {

                if (!$this->input->post('actoqcupso', true)[$i] && $this->input->post('actoqcupso', true)[$i] === '') {
                    $actoQuirirgico = '';
                } else {
                    $actoQuirirgico = $this->input->post('actoqcupso', true)[$i];
                }

                $cups = [
                    'id_paciente'    => $id_paciente,
                    'cons_examen'    => $n_conexamen,
                    'nconsulta'      => $this->input->post('nconsulta', true),
                    //'tipo_docu'      => $tipo_docu,
                    //'identificacion' => $identificacion,
                    'edad'           => $edad,
                    'ume'            => $ume,
                    'cod_cups'       => $this->input->post('cod_cups')[$i],
                    'nombre_cups'    => $this->input->post('nombre_cups')[$i],
                    'id_finalidad'   => $this->input->post('finalidadcupso', true)[$i],
                    'cod_ambi'       => $this->input->post('ambitocupso', true)[$i],
                    'cod_actoq'      => $actoQuirirgico,
                    'lateralidad'    => $this->input->post('lateralidad', true)[$i],
                    'autorizacion'   => $this->input->post('autorizacion', true)[$i],
                    'valor_cups'     => $this->input->post('valor_cups')[$i],
                    'fechaactual'    => $fechaactual,
                    'horaactual'     => $horaactual,
                    'cod_medi'       => '110010756401',
                    'cod_cons'       => $this->input->post('codconsulta'),
                    'login_ing'      => $this->input->post('login', true),
                    'id_admi'        => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'     => 'SI',
                    //'nevolucion'     => $this->input->post('version', true)
                    'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
                    'activo'             => 'SI'
                ];
                $this->examen_model->insertCieCups($cups);
            }

        }

        // mas cie diagnosticos
        $mas_cups = $this->input->post('cod_cierr_mop');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cierr_mop')); $i++) 
            {
                $mciecups = array(
                    'id_paciente'        => $id_paciente,
                    'cons_examen'        => $n_conexamen,
                    'nconsulta'          => $this->input->post('nconsulta', true),
                    //'tipo_docu'          => $tipo_docu,
                    //'identificacion'     => $identificacion,
                    'edad'               => $edad,
                    'ume'                => $ume,
                    'cod_causa_dia'      => $this->input->post('causa', true),
                    'cod_fina_cie'       => $this->input->post('finalidad2', true),
                    'cod_tipo'           => $this->input->post('tipoo', true),
                    'fechaactual'        => $fechaactual,
                    'horaactual'         => $horaactual,
                    'cod_medi'           => '110010756401',
                    'cod_cons'           => $this->input->post('codconsulta'),
                    'login_ing'          => $this->input->post('login', true),
                    'id_admi'            => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'         => 'SI',
                    //'nevolucion'         => $this->input->post('version', true),
                    'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
                    'cod_ciemas'         => $this->input->post('cod_cierr_mop', true)[$i],
                    'nombre_ciemas'      => $this->input->post('nombre_cierr_mop', true)[$i],
                    'observaciones_ciemas'   => $this->input->post('observaciones_cierr_mop', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertCieCups($mciecups);
            }
        }

        // medicamentos oftalmologia
        $mas_cups = $this->input->post('id_medicamento');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('id_medicamento')); $i++) 
            {
                $m_medicamentos = array(
                    'id_paciente'               =>  $id_paciente,
                    'cons_examen'               =>  $n_conexamen,
                    'fechaactual'               =>  $fechaactual,
                    'horaactual'                =>  $horaactual,
                    'nconsulta'                 =>  $this->input->post('nconsulta', true),
                    'login_ing'                 =>  $this->input->post('login', true),
                    'cod_medi'                  =>  $this->input->post('medico', true),
                    'id_admi'                   =>  $this->input->post('convenios', true),
                    'tipo_historia'             =>  'OFTALMOLOGIA',
                    'id_medicamento'            =>  $this->input->post('id_medicamento', true)[$i],
                    'nombre_medicamento'        =>  $this->input->post('nombre_medicamento', true)[$i],
                    'concentracion'             =>  $this->input->post('concentracion', true)[$i],
                    'prescripcion'              =>  $this->input->post('prescripcion', true)[$i],
                    'cantidad'                  =>  $this->input->post('cantidad', true)[$i],
                    'tiempo'                    =>  $this->input->post('tiempo', true)[$i],
                    'activo'                    => 'SI'
                );
                $this->examen_model->insertMedicamentos($m_medicamentos);
            }
        }

        // paraclinicos
        $cod_para = $this->input->post('cod_para');
        if ($cod_para) 
        {
            for ($i = 0; $i < count($this->input->post('cod_para')); $i++) 
            { 
                $m_para = array(
                    'id_paciente'        => $this->input->post('id_paciente'),
                    'cons_examen'        => $n_conexamen,
                    'cons_paraclinico'   => $n_conparaclinico,
                    'login_ing'          => $this->input->post('login', true),
                    'cod_para'           => $this->input->post('cod_para', true)[$i],
                    'nombre_para'        => $this->input->post('nombre_para', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertPara($m_para, $n_conparaclinico);
            }
        }


        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            'ultimocontrol'         =>  $fechaactual,
            'version'               =>  $this->input->post('version', true),
            'num_oftalmologia'      => $this->input->post('num_oftalmologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // actualiza agenda color y evento
        $id_agenda          =    $this->input->post('id_agenda', true);
        if($id_agenda === '')
        {

        }else
        {
            $m_agenda   =   array(
                'estado'    =>   'Atendio',
                'color'     =>   '#5cb85c'
            );
            $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
        }    

        // CONSULTA DE PACIENTE NUEVO
        //$this->load->library('s3');

        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_oftalmologia']      =  $this->input->post('num_oftalmologia', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['cons_examen']           =   $n_conexamen;

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    // actualizar oftalmologia
    // actualizando historia oftalmologica
    public function actualizaexamen() 
    {
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->input->post('ofatlmologia_abierta', true);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);
        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        $id_paciente                =   $this->input->post('id_paciente', true);
        //$tipo_docu                  =   $this->input->post('tipo_docu', true);
        //$identificacion             =   $this->input->post('identificacion', true);

        $examen = array(

            'id_paciente'               =>  $id_paciente,
            'cons_examen'               =>  $n_conexamen,
            'fechaactual'               =>  $fechaactual,
            'horaactual'                =>  $horaactual,
            'nconsulta'                 =>  $this->input->post('nconsulta', true),
            'login_ing'                 =>  $this->input->post('login', true),
            'edad'                      =>  $edad,
            'ume'                       =>  $ume,
            'cod_cons'                  =>  $this->input->post('codconsulta', true),
            'observacionescups'         =>  $this->input->post('observacionescups', true),
            'firmapaci'                 =>  $this->input->post('firmapaciente1'),
            'firmamedi'                 =>  $this->input->post('firmamedico1'),
            'cod_medi'                  =>  $this->input->post('medico', true),
            'id_admi'                   =>  $this->input->post('convenios', true),
            //'cod_consultorio'           =>  $this->input->post('consultorios', true),
            'num_oftalmologia'          =>  $this->input->post('num_oftalmologia', true),
            'motivo_control'            =>  $this->input->post('motivo_control', true),
            'antecedentes_personales'   =>  $this->input->post('antecedentes_personales', true),
            'parpados'                  =>  $this->input->post('parpados', true),
            'conjuntiva'                =>  $this->input->post('conjuntiva', true),
            'viaslagrimales'            =>  $this->input->post('viaslagrimales', true),
            'cornea'                    =>  $this->input->post('cornea', true),
            'camara'                    =>  $this->input->post('camara', true),
            'iris'                      =>  $this->input->post('iris', true),
            'pupila'                    =>  $this->input->post('pupila', true),
            'cristalino'                =>  $this->input->post('cristalino', true),
            'excavacion'                =>  $this->input->post('excavacion', true),
            'retina'                    =>  $this->input->post('retina', true),
            'fo'                        =>  $this->input->post('fo', true),
            'tension'                   =>  $this->input->post('tension', true),
            'tipo_co'                   =>  $this->input->post('tipo_co', true),
            'abierta'                   =>  'SI',
            'planotratamiento'          =>  $this->input->post('planotratamiento', true),
            'id_agenda'                 =>  $this->input->post('id_agenda', true),
            'incapacidades'          =>  $this->input->post('incapacidades', true),
        );

        $updateExa = $this->examen_model->updateExa($examen, $n_conexamen);

        // colocar inactivo los cie en ciecups
        $m_cie_activo   =    array(
            'activo'    => 'NO');

        $update_cie_activo  =   $this->examen_model->updateCIEActivo($m_cie_activo, $n_conexamen);

        // proceso del cie
        $vcod_cier = $this->input->post('cod_cier', true);

        if (!$vcod_cier || $vcod_cier === '') {
            $cod_cier       =   '';
            $nombre_cier    =   '';
        } else {
            $cod_cier       =   $vcod_cier;
            $nombre_cier    =   $this->input->post('nombre_cier');
        };

        $vcod_ciers = $this->input->post('cod_ciers', true);

        if (!$vcod_ciers || $vcod_ciers === '') {
            $cod_ciers      =   '';
            $nombre_ciers   =   '';
        } else {
            $cod_ciers      =   $vcod_ciers;
            $nombre_ciers   =   $this->input->post('nombre_ciers');
        };

        $vcod_cierr = $this->input->post('cod_cierr', true);

        if (!$vcod_cierr || $vcod_cierr === '') {
            $cod_cierr      =   '';
            $nombre_cierr   =   '';
        } else {
            $cod_cierr      =   $vcod_cierr;
            $nombre_cierr   =   $this->input->post('nombre_cierr');
        };

        $ciecups = array(
            'id_paciente'        => $id_paciente,
            'cons_examen'        => $n_conexamen,
            'nconsulta'          => $this->input->post('nconsulta', true),
            //'tipo_docu'          => $tipo_docu,
            //'identificacion'     => $identificacion,
            'edad'               => $edad,
            'ume'                => $ume,
            'cod_cie'            => $this->input->post('cod_cie'),
            'nombre_cie'         => $this->input->post('nombre_cie'),
            'cod_causa_dia'      => $this->input->post('causa', true),
            'cod_fina_cie'       => $this->input->post('finalidad2', true),
            'cod_tipo'           => $this->input->post('tipoo', true),
            'observacionescie'   => $this->input->post('observacionescie', true),
            'cod_cier'           => $cod_cier,      
            'nombre_cier'        => $nombre_cier,          
            'observacionescier'  => $this->input->post('observacionescier', true),
            'cod_ciers'          => $cod_ciers,
            'nombre_ciers'       => $nombre_ciers,
            'observacionesciers' => $this->input->post('observacionesciers', true),
            'cod_cierr'          => $cod_cierr,
            'nombre_cierr'       => $nombre_cierr,
            'observacionescierr' => $this->input->post('observacionescierr', true),
            'fechaactual'        => $fechaactual,
            'horaactual'         => $horaactual,
            'cod_medi'           => '110010756401',
            'cod_cons'           => $this->input->post('codconsulta'),
            'login_ing'          => $this->input->post('login', true),
            'id_admi'            => $this->input->post('convenios', true),
            'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
            //'revolucion'         => 'SI',
            //'nevolucion'         => $this->input->post('version', true),
            'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
            'activo'             => 'SI'
        );

        $this->examen_model->insertCieCups($ciecups);

        $cod_cups = $this->input->post('cod_cups');

        if ($cod_cups) {

            for ($i = 0; $i < count($this->input->post('cod_cups')); $i++) {

                if (!$this->input->post('actoqcupso', true)[$i] && $this->input->post('actoqcupso', true)[$i] === '') {
                    $actoQuirirgico = '';
                } else {
                    $actoQuirirgico = $this->input->post('actoqcupso', true)[$i];
                }

                $cups = [
                    'id_paciente'    => $id_paciente,
                    'cons_examen'    => $n_conexamen,
                    'nconsulta'      => $this->input->post('nconsulta', true),
                    //'tipo_docu'      => $tipo_docu,
                    //'identificacion' => $identificacion,
                    'edad'           => $edad,
                    'ume'            => $ume,
                    'cod_cups'       => $this->input->post('cod_cups')[$i],
                    'nombre_cups'    => $this->input->post('nombre_cups')[$i],
                    'id_finalidad'   => $this->input->post('finalidadcupso', true)[$i],
                    'cod_ambi'       => $this->input->post('ambitocupso', true)[$i],
                    'cod_actoq'      => $actoQuirirgico,
                    'lateralidad'    => $this->input->post('lateralidad', true)[$i],
                    'autorizacion'   => $this->input->post('autorizacion', true)[$i],
                    'valor_cups'     => $this->input->post('valor_cups')[$i],
                    'fechaactual'    => $fechaactual,
                    'horaactual'     => $horaactual,
                    'cod_medi'       => '110010756401',
                    'cod_cons'       => $this->input->post('codconsulta'),
                    'login_ing'      => $this->input->post('login', true),
                    'id_admi'        => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'     => 'SI',
                    //'nevolucion'     => $this->input->post('version', true)
                    'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
                    'activo'             => 'SI'
                ];
                $this->examen_model->insertCieCups($cups);
            }
        }

        // mas cie diagnosticos
        $mas_cups = $this->input->post('cod_cierr_mop');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cierr_mop')); $i++) 
            {
                $mciecups = array(
                    'id_paciente'        => $id_paciente,
                    'cons_examen'        => $n_conexamen,
                    'nconsulta'          => $this->input->post('nconsulta', true),
                    //'tipo_docu'          => $tipo_docu,
                    //'identificacion'     => $identificacion,
                    'edad'               => $edad,
                    'ume'                => $ume,
                    'cod_causa_dia'      => $this->input->post('causa', true),
                    'cod_fina_cie'       => $this->input->post('finalidad2', true),
                    'cod_tipo'           => $this->input->post('tipoo', true),
                    'fechaactual'        => $fechaactual,
                    'horaactual'         => $horaactual,
                    'cod_medi'           => '110010756401',
                    'cod_cons'           => $this->input->post('codconsulta'),
                    'login_ing'          => $this->input->post('login', true),
                    'id_admi'            => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'         => 'SI',
                    //'nevolucion'         => $this->input->post('version', true),
                    'num_oftalmologia'   => $this->input->post('num_oftalmologia', true),
                    'cod_ciemas'         => $this->input->post('cod_cierr_mop', true)[$i],
                    'nombre_ciemas'      => $this->input->post('nombre_cierr_mop', true)[$i],
                    'observaciones_ciemas'   => $this->input->post('observaciones_cierr_mop', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertCieCups($mciecups);
            }
        }

        // medicamentos oftalmologia
        // colocar inactivo los medicamentos en ciecups
        $m_med_activo   =    array(
            'activo'    => 'NO');

        $update_med_activo  =   $this->examen_model->updateMEDActivo($m_med_activo, $n_conexamen);
        
        $mas_medicamento = $this->input->post('id_medicamento');
        if ($mas_medicamento) 
        {
            for ($i = 0; $i < count($this->input->post('id_medicamento')); $i++) 
            {
                $m_medicamentos = array(
                    'id_paciente'               =>  $id_paciente,
                    'cons_examen'               =>  $n_conexamen,
                    'fechaactual'               =>  $fechaactual,
                    'horaactual'                =>  $horaactual,
                    'nconsulta'                 =>  $this->input->post('nconsulta', true),
                    'login_ing'                 =>  $this->input->post('login', true),
                    'cod_medi'                  =>  $this->input->post('medico', true),
                    'id_admi'                   =>  $this->input->post('convenios', true),
                    'tipo_historia'             =>  'OFTALMOLOGIA',
                    'id_medicamento'            =>  $this->input->post('id_medicamento', true)[$i],
                    'nombre_medicamento'        =>  $this->input->post('nombre_medicamento', true)[$i],
                    'concentracion'             =>  $this->input->post('concentracion', true)[$i],
                    'prescripcion'              =>  $this->input->post('prescripcion', true)[$i],
                    'cantidad'                  =>  $this->input->post('cantidad', true)[$i],
                    'tiempo'                    =>  $this->input->post('tiempo', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertMedicamentos($m_medicamentos);
            }
        }

        // paraclinicos
        $m_para_activo   =    array(
            'activo'    => 'NO');

        $update_para_activo  =   $this->examen_model->updatePARAActivo($m_para_activo, $n_conexamen);

        $cod_para = $this->input->post('cod_para');
        if ($cod_para) 
        {
            for ($i = 0; $i < count($this->input->post('cod_para')); $i++) 
            { 
                $m_para = array(
                    'id_paciente'        => $this->input->post('id_paciente'),
                    'cons_examen'        => $n_conexamen,
                    'cons_paraclinico'   => $n_conparaclinico,
                    'login_ing'          => $this->input->post('login', true),
                    'cod_para'           => $this->input->post('cod_para', true)[$i],
                    'nombre_para'        => $this->input->post('nombre_para', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertPara($m_para, $n_conparaclinico);
            }
        }

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            'ultimocontrol'         =>  $fechaactual,
            //'version'               =>  $this->input->post('version', true),
            //'num_oftalmologia'      =>  $this->input->post('num_oftalmologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // actualiza agenda color y evento
        /*$id_agenda          =    $this->input->post('id_agenda', true);
        if($id_agenda === '')
        {

        }else
        {
            $m_agenda   =   array(
                'estado'    =>   'Atendio',
                'color'     =>   '#5cb85c'
            );
            $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
        }*/

        // CONSULTA DE PACIENTE NUEVO

        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['id_paciente']           =   $id_paciente;
        //$datos['identificacion']        =   $identificacion;
        //$datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        //$datos['n_conparaclinico']      =   $n_conparaclinico;

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    // cerrar historia clinica
    public function cerrar_examen_oft() 
    {
        $this->load->model('examen_model');
        $n_conexamen            =   $this->input->post('ofatlmologia_abierta', true);
        $id_paciente            =   $this->input->post('id_paciente', true);

        $m_cerrar_oft           =   array(
            'abierta'           =>  'NO');

        $cerrar_oftalmologia    =   $this->examen_model->cerrar_oftalmologia($m_cerrar_oft, $n_conexamen);

        // CONSULTA DE PACIENTE NUEVO
        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['id_paciente']           =   $id_paciente;
        //$datos['identificacion']        =   $identificacion;
        //$datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        //$datos['n_conparaclinico']      =   $n_conparaclinico;

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    public function rep_historia()
    {
        $this->load->model('examen_model');
        //$this->load->library('s3');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('n_conexamen');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);

        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);
        

        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // PRESTADOR
        //$prestador          =   $this->examen_model->prestador();
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto     =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $nombre_admi    =   $pac->nombre_admi;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        foreach($examen as $exa)
        {
            $fecha_consulta  =   $exa->fechaactual;
            $hora_consulta   =   $exa->horaactual;
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
        }

        
        /*$imgextension   =   substr($imagenfoto, -3);
        $contarpunto    =   substr_count($imagenfoto, ".");

        $porciones  =   explode(".", $imagenfoto);
        $extfoto    =   $porciones[$contarpunto]; 
        //echo $extfoto;

        if($imagenfoto)
        {            
            $datos['imagenfoto']  =   $this->pdf->Image(S3::getAuthenticatedURL('histocol', $imagenfoto, 600), 170,5, 26, 26, $extfoto);
        }else 
        {
            $datos['imagenfoto']  =   '';
        }*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 

        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        /////
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/

        //$this->pdf->Ln(3);

        /*$this->pdf->SetDrawColor(215,215,215);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);


        // FALTA ACUDIENTE

        // MEDICO Y TIPO CONSULTA
        /*$this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($tipo),0,0,'L');
        $this->pdf->Ln();

        // tipo de consulta oftalmologia.consulta y control
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','BU',7);
        $this->pdf->Cell(15,4,utf8_decode('TIPO DE CONSULTA: OFTALMOLOGÍA'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(20,4,utf8_decode('Tipo consulta'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(60,4,utf8_decode($tipoconsulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(20,4,utf8_decode('Número Control:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(40,4,utf8_decode($num_oftalmologia),0,0,'L');
        $this->pdf->Ln(); */
        /////

        $this->pdf->Ln();

        foreach($examen as $exa)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('EXAMEN BIOMICROSCOPICO'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());  

            // MEDICO, TIPO CONSULTA
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
            $this->pdf->SetX(45);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi),0,0,'L');
            
            $this->pdf->SetX(165);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(25,4,utf8_decode('Número Control:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(40,4,utf8_decode($exa->num_oftalmologia),0,0,'L');
            $this->pdf->Ln();

            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
            $this->pdf->SetX(45);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa->nombre_listap),0,0,'L');
            $this->pdf->Ln();

            if($exa->motivo_control)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Motivo Consulta:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->motivo_control),0,'J');
            }

            if($exa->antecedentes_personales)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Antecedentes personales:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->antecedentes_personales),0,'J');
            }

            if($exa->parpados)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Parpados:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->parpados),0,'J');
            }

            if($exa->conjuntiva)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Conjuntiva:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->conjuntiva),0,'J');
            }

            if($exa->viaslagrimales)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Vías Lagrimales:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->viaslagrimales),0,'J');
            }
            

            if($exa->cornea)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Cornea:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->cornea),0,'J');
            }

            if($exa->iris)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Iris:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->iris),0,'J');
            }

            if($exa->pupila)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Pupila:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->pupila),0,'J');
            }

            if($exa->cristalino)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Cristalino:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->cristalino),0,'J');
            }

            if($exa->excavacion)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Excavación:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->excavacion),0,'J');
            }

            if($exa->retina)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Retina:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->retina),0,'J');
            }

            if($exa->fo)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Fo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->fo),0,'J');
            }

            if($exa->tension)
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tensión:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa->tension),0,'J');
            }


            

            // FIRMAS X EVOLUCION
            /*if($exa['firmapaci'])
            {
                
                $this->pdf->Cell(25,5,'Firma paciente',0,0,'C');
                
                $ffirmapaci  =   $this->pdf->Image(S3::getAuthenticatedURL('histocol', $exa['firmapaci'], 600), 5, $this->pdf->GetY(), 50, 50, 'png');
            }
            else
            {
                $ffirmapaci  =   '';    
            }
            
            if($exa['firmamedi'])
            {
                
                $this->pdf->SetX(80);
                $ffirmamedi =   $this->pdf->Cell(25,5,'Firma profesional',0,0,'C'); 
                $ffirmamedi =   $this->pdf->Image(S3::getAuthenticatedURL('histocol', $exa['firmamedi'], 600), 80, $this->pdf->GetY(), 50, 50, 'png');    
            }else
            {
                $this->pdf->SetX(80);
                $ffirmamedi =   '';  
            }*/
        }

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());   
                

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');    
                }
                

                if($ci['cod_cier'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                    if($ci['observacionescier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                    }
                    
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                    if($ci['observacionesciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                    if($ci['observacionescierr'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                    }
                }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }

        // ordenes medicas
        if($cups)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('ORDENES MÉDICAS'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
            $this->pdf->Ln();
            
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(160, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(160,20));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($cups)
            {
                foreach ($cups as $row) 
                {   
                    $cod_cups            =   utf8_decode($row['cod_cups'].'-'.$row['nombre_cups']);
                    $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                    
                    
                    $this->pdf->Row(array($cod_cups, $nombre_lateralidad));
                }
            }    
        }
        // paraclinicos
        if($paraclinicos)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('PREQUIRURGICOS'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
            $this->pdf->Ln();

            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(150));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($paraclinicos)
            {
                foreach ($paraclinicos as $para) 
                {   
                    $nombre_para            =   utf8_decode($para['nombre_para']);
                    
                    
                    $this->pdf->Row(array($nombre_para));
                }
            }    
        }

        // observaciones cups
        if($exa->observacionescups)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($exa->observacionescups),0,'J');
            $this->pdf->Ln();
        }

        // plan de tratamiento
        if($exa->planotratamiento)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Plan o Tratamiento:'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($exa->planotratamiento),0,'J');
            $this->pdf->Ln();   
        }

        // medicamentos
        if($medicamentos)
        {
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('MEDICAMENTOS'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
            $this->pdf->Ln();

            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(68,38,38,15,30));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','L','L','L'));

            if($medicamentos)
            {
                foreach ($medicamentos as $med) 
                {   
                    $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                    $concentracion              =   utf8_decode($med['concentracion']);
                    $prescripcion               =   utf8_decode($med['prescripcion']);
                    $cantidad                   =   utf8_decode($med['cantidad']);
                    $tiempo                     =   utf8_decode($med['tiempo']);
                    
                    $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                }
            }    
        }

        
        

        $this->pdf->Ln();

        //$var_Y = $this->pdf->GetY()
        //$this->pdf->Cell(15,4,utf8_decode($var_Y),0,0,'L');
        
        /*if($i > '380')
        {
            
            $this->pdf->AddPage();
        }*/
        // FIRMAS X EVOLUCION
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');

            
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
            

        }
        else
        {
        }
        
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
        
        $this->pdf->Output("Reporte historia.pdf", 'I');
    }

    public function ingresoexamen_opt() 
    {
        //var_dump($this->input->post());
        //exit();
        //$this->load->library('imagenes');

        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->examen_model->consultaconsecutivo(7);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);

        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso       =   date("Y-m-d");
        $horaingreso        =   date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /**
         * Subir firmas y foto
         */

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1_op'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1_op'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'                   =>  $id_paciente,
            'cons_examen'                   =>  $n_conexamen,
            'fechaactual'                   =>  $fechaactual,
            'horaactual'                    =>  $horaactual,
            'nconsulta'                     =>  $this->input->post('nconsulta', true),
            'login_ing'                     =>  $this->input->post('login', true),
            'edad'                          =>  $edad,
            'ume'                           =>  $ume,
            'cod_cons'                      =>  $this->input->post('codconsulta_op', true),
            'observacionescups'             => $this->input->post('observacionescups_op', true),
            'firmapaci'                     =>  $this->input->post('firmapaciente1_op'),
            'firmamedi'                     =>  $this->input->post('firmamedico1_op'),
            'cod_medi'                      =>  $this->input->post('medico_op', true),
            'num_optometria'                =>  $this->input->post('num_optometria', true),
            'cod_consultorio'               =>  $this->input->post('consultorios_op', true),
            'id_admi'                       =>  $this->input->post('convenios_op', true),
            'sintomas'                      =>  $this->input->post('sintomas', true),
            'ocupacion_habitual'            =>  $this->input->post('ocupacion_habitual', true),
            'distancia_habitual'            =>  $this->input->post('distancia_habitual', true),
            'ojo_dominante'                 =>  $this->input->post('ojo_dominante', true),
            'mano_dominante'                =>  $this->input->post('mano_dominante', true),
            'ultima_rx'                     =>  $this->input->post('ultima_rx', true),
            'optica_fecha'                  =>  $this->input->post('optica_fecha', true),
            'uso_clase_le'                  =>  $this->input->post('uso_clase_le', true),
            'uso_od'                        =>  $this->input->post('uso_od', true),
            'uso_oi'                        =>  $this->input->post('uso_oi', true),
            'uso_od_v'                      =>  $this->input->post('uso_od_v', true),
            'uso_oi_v'                      =>  $this->input->post('uso_oi_v', true),
            'clase_od'                      =>  $this->input->post('clase_od', true),
            'clase_od_v'                    =>  $this->input->post('clase_od_v', true),
            'clase_oi'                      =>  $this->input->post('clase_oi', true),
            'clase_oi_v'                    =>  $this->input->post('clase_oi_v', true),
            'uso_observaciones'             =>  $this->input->post('uso_observaciones', true),
            'estenopelco_od'                =>  $this->input->post('estenopelco_od', true),
            'estenopelco_oi'                =>  $this->input->post('estenopelco_oi', true),
            'estado_forico'                 =>  $this->input->post('estado_forico', true),
            'horizontal_lejos'              =>  $this->input->post('horizontal_lejos', true),
            'horizontal_cerca'              =>  $this->input->post('horizontal_cerca', true),
            'vertical_lejos'                =>  $this->input->post('vertical_lejos', true),
            'vertical_cerca'                =>  $this->input->post('vertical_cerca', true),
            'oftalmometria_od'              =>  $this->input->post('oftalmometria_od', true),
            'oftalmometria_oi'              =>  $this->input->post('oftalmometria_oi', true),
            'oftalmometria_obs'             =>  $this->input->post('oftalmometria_obs', true),
            'retino_esta_od'                =>  $this->input->post('retino_esta_od', true),
            'retino_esta_oi'                =>  $this->input->post('retino_esta_oi', true),
            'retino_esta_obs'               =>  $this->input->post('retino_esta_obs', true),
            'retino_dina_od'                =>  $this->input->post('retino_dina_od', true),
            'retino_dina_oi'                =>  $this->input->post('retino_dina_oi', true),
            'subjetivo_od'                  =>  $this->input->post('subjetivo_od', true),
            'subjetivo_od_v'                =>  $this->input->post('subjetivo_od_v', true),
            'subjetivo_oi'                  =>  $this->input->post('subjetivo_oi', true),
            'subjetivo_oi_v'                =>  $this->input->post('subjetivo_oi_v', true),
            'adicion_od'                    =>  $this->input->post('adicion_od', true),
            'adicion_od_v'                  =>  $this->input->post('adicion_od_v', true),
            'adicion_od_dist'               =>  $this->input->post('adicion_od_dist', true),
            'adicion_oi'                    =>  $this->input->post('adicion_oi', true),
            'adicion_oi_v'                  =>  $this->input->post('adicion_oi_v', true),
            'adicion_oi_dist'               =>  $this->input->post('adicion_oi_dist', true),
            'mipes_od'                      =>  $this->input->post('mipes_od', true),
            'forico_h_lejos'                =>  $this->input->post('forico_h_lejos', true),
            'forico_v_lejos'                =>  $this->input->post('forico_v_lejos', true),
            'forico_h_cerca'                =>  $this->input->post('forico_h_cerca', true),
            'forico_v_cerca'                =>  $this->input->post('forico_v_cerca', true),
            'forico_obs'                    =>  $this->input->post('forico_obs', true),
            'amplitud_od'                   =>  $this->input->post('amplitud_od', true),
            'amplitud_oi'                   =>  $this->input->post('amplitud_oi', true),
            'amplitud_r_pos'                =>  $this->input->post('amplitud_r_pos', true),
            'amplitud_r_neg'                =>  $this->input->post('amplitud_r_neg', true),
            'amplitud_obs'                  =>  $this->input->post('amplitud_obs', true),
            'for_vl_esf_od'                 =>  $this->input->post('for_vl_esf_od', true),
            'for_vl_cil_od'                 =>  $this->input->post('for_vl_cil_od', true),
            'for_vl_eje_od'                 =>  $this->input->post('for_vl_eje_od', true),
            'for_vl_pri_od'                 =>  $this->input->post('for_vl_pri_od', true),
            'for_vl_bas_od'                 =>  $this->input->post('for_vl_bas_od', true),
            'for_vl_esf_oi'                 =>  $this->input->post('for_vl_esf_oi', true),
            'for_vl_cil_oi'                 =>  $this->input->post('for_vl_cil_oi', true),
            'for_vl_eje_oi'                 =>  $this->input->post('for_vl_eje_oi', true),
            'for_vl_pri_oi'                 =>  $this->input->post('for_vl_pri_oi', true),
            'for_vl_bas_oi'                 =>  $this->input->post('for_vl_bas_oi', true),
            'for_vp_esf_od'                 =>  $this->input->post('for_vp_esf_od', true),
            'for_vp_cil_od'                 =>  $this->input->post('for_vp_cil_od', true),
            'for_vp_eje_od'                 =>  $this->input->post('for_vp_eje_od', true),
            'for_vp_pri_od'                 =>  $this->input->post('for_vp_pri_od', true),
            'for_vp_bas_od'                 =>  $this->input->post('for_vp_bas_od', true),
            'for_vp_esf_oi'                 =>  $this->input->post('for_vp_esf_oi', true),
            'for_vp_cil_oi'                 =>  $this->input->post('for_vp_cil_oi', true),
            'for_vp_eje_oi'                 =>  $this->input->post('for_vp_eje_oi', true),
            'for_vp_pri_oi'                 =>  $this->input->post('for_vp_pri_oi', true),
            'for_vp_bas_oi'                 =>  $this->input->post('for_vp_bas_oi', true),
            'obs_formula'                   =>  $this->input->post('obs_formula', true),
            'color'                         =>  $this->input->post('color', true),
            'dist_pupilar'                  =>  $this->input->post('dist_pupilar', true),
            'comentarios'                   =>  $this->input->post('comentarios', true),
            'tipo_co'                       =>  $this->input->post('tipo_co_op', true),
            'abierta'                       =>  'SI',
            'planotratamiento'              =>  $this->input->post('planotratamiento_op', true),
            'id_agenda'                     =>  $this->input->post('id_agenda_op', true),
            'incapacidades'                 =>  $this->input->post('incapacidades_op', true)
        );

            $insertExa = $this->examen_model->insertExa_opt($examen, $n_conexamen);

            $vcod_cier = $this->input->post('cod_cier_op', true);

            if (!$vcod_cier || $vcod_cier === '') {
                $cod_cier       =   '';
                $nombre_cier    =   '';
            } else {
                $cod_cier       =   $vcod_cier;
                $nombre_cier    =   $this->input->post('nombre_cier_op');
            };

            $vcod_ciers = $this->input->post('cod_ciers_op', true);

            if (!$vcod_ciers || $vcod_ciers === '') {
                $cod_ciers      =   '';
                $nombre_ciers   =   '';
            } else {
                $cod_ciers      =   $vcod_ciers;
                $nombre_ciers   =   $this->input->post('nombre_ciers_op');
            };

            $vcod_cierr = $this->input->post('cod_cierr_op', true);

            if (!$vcod_cierr || $vcod_cierr === '') {
                $cod_cierr      =   '';
                $nombre_cierr   =   '';
            } else {
                $cod_cierr      =   $vcod_cierr;
                $nombre_cierr   =   $this->input->post('nombre_cierr_op');
            };

            $ciecups = array(
                'id_paciente'        => $id_paciente,
                'cons_examen'        => $n_conexamen,
                'nconsulta'          => $this->input->post('nconsulta', true),
                //'tipo_docu'          => $tipo_docu,
                //'identificacion'     => $identificacion,
                'edad'               => $edad,
                'ume'                => $ume,
                'cod_cie'            => $this->input->post('cod_cie_op'),
                'nombre_cie'         => $this->input->post('nombre_cie_op'),
                'cod_causa_dia'      => $this->input->post('causa_op', true),
                'cod_fina_cie'       => $this->input->post('finalidad2_op', true),
                'cod_tipo'           => $this->input->post('tipoo_op', true),
                'observacionescie'   => $this->input->post('observacionescie_op', true),
                'cod_cier'           => $cod_cier,      
                'nombre_cier'        => $nombre_cier,          
                'observacionescier'  => $this->input->post('observacionescier_op', true),
                'cod_ciers'          => $cod_ciers,
                'nombre_ciers'       => $nombre_ciers,
                'observacionesciers' => $this->input->post('observacionesciers_op', true),
                'cod_cierr'          => $cod_cierr,
                'nombre_cierr'       => $nombre_cierr,
                'observacionescierr' => $this->input->post('observacionescierr_op', true),
                'fechaactual'        => $fechaactual,
                'horaactual'         => $horaactual,
                'cod_medi'           => '110010756401',
                'cod_cons'           => $this->input->post('codconsulta_op'),
                'login_ing'          => $this->input->post('login', true),
                'id_admi'            => $this->input->post('convenios_op', true),
                'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                //'revolucion'         => 'SI',
                //'nevolucion'         => $this->input->post('version', true),
                'num_optometria'     =>  $this->input->post('num_optometria', true),
                'activo'             => 'SI'
            );

            $this->examen_model->insertCieCups($ciecups);

            /////////////// *** inicio de cie +cie cups prequ medi incap
            $cod_cups = $this->input->post('cod_cups_op');

            if ($cod_cups) {

                for ($i = 0; $i < count($this->input->post('cod_cups_op')); $i++) {

                    if (!$this->input->post('actoqcupso_op', true)[$i] && $this->input->post('actoqcupso_op', true)[$i] === '') {
                        $actoQuirirgico = '';
                    } else {
                        $actoQuirirgico = $this->input->post('actoqcupso_op', true)[$i];
                    }

                    $cups = [
                        'id_paciente'    => $id_paciente,
                        'cons_examen'    => $n_conexamen,
                        'nconsulta'      => $this->input->post('nconsulta', true),
                        //'tipo_docu'      => $tipo_docu,
                        //'identificacion' => $identificacion,
                        'edad'           => $edad,
                        'ume'            => $ume,
                        'cod_cups'       => $this->input->post('cod_cups_op')[$i],
                        'nombre_cups'    => $this->input->post('nombre_cups_op')[$i],
                        'id_finalidad'   => $this->input->post('finalidadcupso_op', true)[$i],
                        'cod_ambi'       => $this->input->post('ambitocupso_op', true)[$i],
                        'cod_actoq'      => $actoQuirirgico,
                        'lateralidad'    => $this->input->post('lateralidad_op', true)[$i],
                        'autorizacion'   => $this->input->post('autorizacion_op', true)[$i],
                        'valor_cups'     => $this->input->post('valor_cups_op')[$i],
                        'fechaactual'    => $fechaactual,
                        'horaactual'     => $horaactual,
                        'cod_medi'       => '110010756401',
                        'cod_cons'       => $this->input->post('codconsulta_op'),
                        'login_ing'      => $this->input->post('login', true),
                        'id_admi'        => $this->input->post('convenios_op', true),
                        'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                        //'revolucion'     => 'SI',
                        //'nevolucion'     => $this->input->post('version', true)
                        'num_optometria' => $this->input->post('num_optometria', true),
                        'activo'             => 'SI'
                    ];
                    $this->examen_model->insertCieCups($cups);
                }

            }

            // mas cie diagnosticos
            $mas_cups = $this->input->post('cod_cierr_mop_op');
            if ($mas_cups) 
            {
                for ($i = 0; $i < count($this->input->post('cod_cierr_mop_op')); $i++) 
                {
                    $mciecups = array(
                        'id_paciente'        => $id_paciente,
                        'cons_examen'        => $n_conexamen,
                        'nconsulta'          => $this->input->post('nconsulta', true),
                        //'tipo_docu'          => $tipo_docu,
                        //'identificacion'     => $identificacion,
                        'edad'               => $edad,
                        'ume'                => $ume,
                        'cod_causa_dia'      => $this->input->post('causa_op', true),
                        'cod_fina_cie'       => $this->input->post('finalidad2_op', true),
                        'cod_tipo'           => $this->input->post('tipoo_op', true),
                        'fechaactual'        => $fechaactual,
                        'horaactual'         => $horaactual,
                        'cod_medi'           => '110010756401',
                        'cod_cons'           => $this->input->post('codconsulta_op'),
                        'login_ing'          => $this->input->post('login', true),
                        'id_admi'            => $this->input->post('convenios_op', true),
                        'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                        //'revolucion'         => 'SI',
                        //'nevolucion'         => $this->input->post('version', true),
                        'num_optometria'     => $this->input->post('num_optometria', true),
                        'cod_ciemas'         => $this->input->post('cod_cierr_mop_op', true)[$i],
                        'nombre_ciemas'      => $this->input->post('nombre_cierr_mop_op', true)[$i],
                        'observaciones_ciemas'   => $this->input->post('observaciones_cierr_mop_op', true)[$i],
                        'activo'             => 'SI'
                    );
                    $this->examen_model->insertCieCups($mciecups);
                }
            }

            // medicamentos oftalmologia
            $mas_cups = $this->input->post('id_medicamento_op');
            if ($mas_cups) 
            {
                for ($i = 0; $i < count($this->input->post('id_medicamento_op')); $i++) 
                {
                    $m_medicamentos = array(
                        'id_paciente'               =>  $id_paciente,
                        'cons_examen'               =>  $n_conexamen,
                        'fechaactual'               =>  $fechaactual,
                        'horaactual'                =>  $horaactual,
                        'nconsulta'                 =>  $this->input->post('nconsulta', true),
                        'login_ing'                 =>  $this->input->post('login', true),
                        'cod_medi'                  =>  $this->input->post('medico', true),
                        'id_admi'                   =>  $this->input->post('convenios', true),
                        'tipo_historia'             =>  'OPTOMETRIA',
                        'id_medicamento'            =>  $this->input->post('id_medicamento_op', true)[$i],
                        'nombre_medicamento'        =>  $this->input->post('nombre_medicamento_op', true)[$i],
                        'concentracion'             =>  $this->input->post('concentracion_op', true)[$i],
                        'prescripcion'              =>  $this->input->post('prescripcion_op', true)[$i],
                        'cantidad'                  =>  $this->input->post('cantidad_op', true)[$i],
                        'tiempo'                    =>  $this->input->post('tiempo_op', true)[$i],
                        'activo'                    => 'SI'
                    );
                    $this->examen_model->insertMedicamentos($m_medicamentos);
                }
            }

            // paraclinicos
            $cod_para = $this->input->post('cod_para_op');
            if ($cod_para) 
            {
                for ($i = 0; $i < count($this->input->post('cod_para_op')); $i++) 
                { 
                    $m_para = array(
                        'id_paciente'        => $this->input->post('id_paciente'),
                        'cons_examen'        => $n_conexamen,
                        'cons_paraclinico'   => $n_conparaclinico,
                        'login_ing'          => $this->input->post('login', true),
                        'cod_para'           => $this->input->post('cod_para_op', true)[$i],
                        'nombre_para'        => $this->input->post('nombre_para_op', true)[$i],
                        'activo'             => 'SI'
                    );
                    $this->examen_model->insertPara($m_para, $n_conparaclinico);
                }
            }

            // actualiza agenda color y evento
            $id_agenda          =    $this->input->post('id_agenda', true);
            if($id_agenda === '')
            {

            }else
            {
                $m_agenda   =   array(
                    'estado'    =>   'Atendio',
                    'color'     =>   '#5cb85c'
                );
                $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
            }              
            /////////////// *** cierre de cie +cie cups prequ medi incap 


        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            
            'ultimocontrol'         =>  $fechaactual,
            'version'               =>  $this->input->post('version', true),
            'num_optometria'        =>  $this->input->post('num_optometria', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        

        // CONSULTA DE PACIENTE NUEVO
        //$this->load->library('s3');

        $datos['examen_opt']            =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_optometria']      =  $this->input->post('num_optometria', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen;        

        $this->load->view('front_end/historias/hexamen_opt_v', $datos);
    }

    // actualizando historia oftalmologica
    public function actualizaexamen_opt() 
    {
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->input->post('optometria_abierta', true);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);
        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        $id_paciente                =   $this->input->post('id_paciente', true);
        //$tipo_docu                  =   $this->input->post('tipo_docu', true);
        //$identificacion             =   $this->input->post('identificacion', true);

       

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'                   =>  $id_paciente,
            'cons_examen'                   =>  $n_conexamen,
            'fechaactual'                   =>  $fechaactual,
            'horaactual'                    =>  $horaactual,
            'nconsulta'                     =>  $this->input->post('nconsulta', true),
            'login_ing'                     =>  $this->input->post('login', true),
            'edad'                          =>  $edad,
            'ume'                           =>  $ume,
            'cod_cons'                      =>  $this->input->post('codconsulta_op', true),
            'observacionescups'             => $this->input->post('observacionescups_op', true),
            'firmapaci'                     =>  $this->input->post('firmapaciente1_op'),
            'firmamedi'                     =>  $this->input->post('firmamedico1_op'),
            'cod_medi'                      =>  $this->input->post('medico_op', true),
            'num_optometria'                =>  $this->input->post('num_optometria', true),
            //'cod_consultorio'               =>  $this->input->post('consultorios_op', true),
            'id_admi'                       =>  $this->input->post('convenios_op', true),
            'sintomas'                      =>  $this->input->post('sintomas', true),
            'ocupacion_habitual'            =>  $this->input->post('ocupacion_habitual', true),
            'distancia_habitual'            =>  $this->input->post('distancia_habitual', true),
            'ojo_dominante'                 =>  $this->input->post('ojo_dominante', true),
            'mano_dominante'                =>  $this->input->post('mano_dominante', true),
            'ultima_rx'                     =>  $this->input->post('ultima_rx', true),
            'optica_fecha'                  =>  $this->input->post('optica_fecha', true),
            'uso_clase_le'                  =>  $this->input->post('uso_clase_le', true),
            'uso_od'                        =>  $this->input->post('uso_od', true),
            'uso_oi'                        =>  $this->input->post('uso_oi', true),
            'uso_od_v'                      =>  $this->input->post('uso_od_v', true),
            'uso_oi_v'                      =>  $this->input->post('uso_oi_v', true),
            'clase_od'                      =>  $this->input->post('clase_od', true),
            'clase_od_v'                    =>  $this->input->post('clase_od_v', true),
            'clase_oi'                      =>  $this->input->post('clase_oi', true),
            'clase_oi_v'                    =>  $this->input->post('clase_oi_v', true),
            'uso_observaciones'             =>  $this->input->post('uso_observaciones', true),
            'estenopelco_od'                =>  $this->input->post('estenopelco_od', true),
            'estenopelco_oi'                =>  $this->input->post('estenopelco_oi', true),
            'estado_forico'                 =>  $this->input->post('estado_forico', true),
            'horizontal_lejos'              =>  $this->input->post('horizontal_lejos', true),
            'horizontal_cerca'              =>  $this->input->post('horizontal_cerca', true),
            'vertical_lejos'                =>  $this->input->post('vertical_lejos', true),
            'vertical_cerca'                =>  $this->input->post('vertical_cerca', true),
            'oftalmometria_od'              =>  $this->input->post('oftalmometria_od', true),
            'oftalmometria_oi'              =>  $this->input->post('oftalmometria_oi', true),
            'oftalmometria_obs'             =>  $this->input->post('oftalmometria_obs', true),
            'retino_esta_od'                =>  $this->input->post('retino_esta_od', true),
            'retino_esta_oi'                =>  $this->input->post('retino_esta_oi', true),
            'retino_esta_obs'               =>  $this->input->post('retino_esta_obs', true),
            'retino_dina_od'                =>  $this->input->post('retino_dina_od', true),
            'retino_dina_oi'                =>  $this->input->post('retino_dina_oi', true),
            'subjetivo_od'                  =>  $this->input->post('subjetivo_od', true),
            'subjetivo_od_v'                =>  $this->input->post('subjetivo_od_v', true),
            'subjetivo_oi'                  =>  $this->input->post('subjetivo_oi', true),
            'subjetivo_oi_v'                =>  $this->input->post('subjetivo_oi_v', true),
            'adicion_od'                    =>  $this->input->post('adicion_od', true),
            'adicion_od_v'                  =>  $this->input->post('adicion_od_v', true),
            'adicion_od_dist'               =>  $this->input->post('adicion_od_dist', true),
            'adicion_oi'                    =>  $this->input->post('adicion_oi', true),
            'adicion_oi_v'                  =>  $this->input->post('adicion_oi_v', true),
            'adicion_oi_dist'               =>  $this->input->post('adicion_oi_dist', true),
            'mipes_od'                      =>  $this->input->post('mipes_od', true),
            'forico_h_lejos'                =>  $this->input->post('forico_h_lejos', true),
            'forico_v_lejos'                =>  $this->input->post('forico_v_lejos', true),
            'forico_h_cerca'                =>  $this->input->post('forico_h_cerca', true),
            'forico_v_cerca'                =>  $this->input->post('forico_v_cerca', true),
            'forico_obs'                    =>  $this->input->post('forico_obs', true),
            'amplitud_od'                   =>  $this->input->post('amplitud_od', true),
            'amplitud_oi'                   =>  $this->input->post('amplitud_oi', true),
            'amplitud_r_pos'                =>  $this->input->post('amplitud_r_pos', true),
            'amplitud_r_neg'                =>  $this->input->post('amplitud_r_neg', true),
            'amplitud_obs'                  =>  $this->input->post('amplitud_obs', true),
            'for_vl_esf_od'                 =>  $this->input->post('for_vl_esf_od', true),
            'for_vl_cil_od'                 =>  $this->input->post('for_vl_cil_od', true),
            'for_vl_eje_od'                 =>  $this->input->post('for_vl_eje_od', true),
            'for_vl_pri_od'                 =>  $this->input->post('for_vl_pri_od', true),
            'for_vl_bas_od'                 =>  $this->input->post('for_vl_bas_od', true),
            'for_vl_esf_oi'                 =>  $this->input->post('for_vl_esf_oi', true),
            'for_vl_cil_oi'                 =>  $this->input->post('for_vl_cil_oi', true),
            'for_vl_eje_oi'                 =>  $this->input->post('for_vl_eje_oi', true),
            'for_vl_pri_oi'                 =>  $this->input->post('for_vl_pri_oi', true),
            'for_vl_bas_oi'                 =>  $this->input->post('for_vl_bas_oi', true),
            'for_vp_esf_od'                 =>  $this->input->post('for_vp_esf_od', true),
            'for_vp_cil_od'                 =>  $this->input->post('for_vp_cil_od', true),
            'for_vp_eje_od'                 =>  $this->input->post('for_vp_eje_od', true),
            'for_vp_pri_od'                 =>  $this->input->post('for_vp_pri_od', true),
            'for_vp_bas_od'                 =>  $this->input->post('for_vp_bas_od', true),
            'for_vp_esf_oi'                 =>  $this->input->post('for_vp_esf_oi', true),
            'for_vp_cil_oi'                 =>  $this->input->post('for_vp_cil_oi', true),
            'for_vp_eje_oi'                 =>  $this->input->post('for_vp_eje_oi', true),
            'for_vp_pri_oi'                 =>  $this->input->post('for_vp_pri_oi', true),
            'for_vp_bas_oi'                 =>  $this->input->post('for_vp_bas_oi', true),
            'obs_formula'                   =>  $this->input->post('obs_formula', true),
            'color'                         =>  $this->input->post('color', true),
            'dist_pupilar'                  =>  $this->input->post('dist_pupilar', true),
            'comentarios'                   =>  $this->input->post('comentarios', true),
            'tipo_co'                       =>  $this->input->post('tipo_co_op', true),
            'abierta'                       =>  'SI',
            'planotratamiento'              =>  $this->input->post('planotratamiento_op', true),
            'id_agenda'                     =>  $this->input->post('id_agenda_op', true),
            'incapacidades'                 =>  $this->input->post('incapacidades_op', true)
        );

        //var_dump($this->input->post());
        //exit();

        $updateExa = $this->examen_model->updateExa_opt($examen, $n_conexamen);

        // colocar inactivo los cie en ciecups
        $m_cie_activo   =    array(
            'activo'    => 'NO');

        $update_cie_activo  =   $this->examen_model->updateCIEActivo($m_cie_activo, $n_conexamen);

        $vcod_cier = $this->input->post('cod_cier_op', true);

        if (!$vcod_cier || $vcod_cier === '') {
            $cod_cier       =   '';
            $nombre_cier    =   '';
        } else {
            $cod_cier       =   $vcod_cier;
            $nombre_cier    =   $this->input->post('nombre_cier_op');
        };

        $vcod_ciers = $this->input->post('cod_ciers_op', true);

        if (!$vcod_ciers || $vcod_ciers === '') {
            $cod_ciers      =   '';
            $nombre_ciers   =   '';
        } else {
            $cod_ciers      =   $vcod_ciers;
            $nombre_ciers   =   $this->input->post('nombre_ciers_op');
        };

        $vcod_cierr = $this->input->post('cod_cierr_op', true);

        if (!$vcod_cierr || $vcod_cierr === '') {
            $cod_cierr      =   '';
            $nombre_cierr   =   '';
        } else {
            $cod_cierr      =   $vcod_cierr;
            $nombre_cierr   =   $this->input->post('nombre_cierr_op');
        };

        $ciecups = array(
            'id_paciente'        => $id_paciente,
            'cons_examen'        => $n_conexamen,
            'nconsulta'          => $this->input->post('nconsulta', true),
            //'tipo_docu'          => $tipo_docu,
            //'identificacion'     => $identificacion,
            'edad'               => $edad,
            'ume'                => $ume,
            'cod_cie'            => $this->input->post('cod_cie_op'),
            'nombre_cie'         => $this->input->post('nombre_cie_op'),
            'cod_causa_dia'      => $this->input->post('causa_op', true),
            'cod_fina_cie'       => $this->input->post('finalidad2_op', true),
            'cod_tipo'           => $this->input->post('tipoo_op', true),
            'observacionescie'   => $this->input->post('observacionescie_op', true),
            'cod_cier'           => $cod_cier,      
            'nombre_cier'        => $nombre_cier,          
            'observacionescier'  => $this->input->post('observacionescier_op', true),
            'cod_ciers'          => $cod_ciers,
            'nombre_ciers'       => $nombre_ciers,
            'observacionesciers' => $this->input->post('observacionesciers_op', true),
            'cod_cierr'          => $cod_cierr,
            'nombre_cierr'       => $nombre_cierr,
            'observacionescierr' => $this->input->post('observacionescierr_op', true),
            'fechaactual'        => $fechaactual,
            'horaactual'         => $horaactual,
            'cod_medi'           => '110010756401',
            'cod_cons'           => $this->input->post('codconsulta_op'),
            'login_ing'          => $this->input->post('login', true),
            'id_admi'            => $this->input->post('convenios_op', true),
            'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
            //'revolucion'         => 'SI',
            //'nevolucion'         => $this->input->post('version', true),
            'num_optometria'     =>  $this->input->post('num_optometria', true),
            'activo'             => 'SI'
        );

        $this->examen_model->insertCieCups($ciecups);

        $cod_cups = $this->input->post('cod_cups_op');

        if ($cod_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cups_op')); $i++) 
            {
                if (!$this->input->post('actoqcupso_op', true)[$i] && $this->input->post('actoqcupso_op', true)[$i] === '') 
                {
                    $actoQuirirgico = '';
                }else 
                {
                    $actoQuirirgico = $this->input->post('actoqcupso_op', true)[$i];
                }

                $cups = [
                    'id_paciente'    => $id_paciente,
                    'cons_examen'    => $n_conexamen,
                    'nconsulta'      => $this->input->post('nconsulta', true),
                    //'tipo_docu'      => $tipo_docu,
                    //'identificacion' => $identificacion,
                    'edad'           => $edad,
                    'ume'            => $ume,
                    'cod_cups'       => $this->input->post('cod_cups_op')[$i],
                    'nombre_cups'    => $this->input->post('nombre_cups_op')[$i],
                    'id_finalidad'   => $this->input->post('finalidadcupso_op', true)[$i],
                    'cod_ambi'       => $this->input->post('ambitocupso_op', true)[$i],
                    'cod_actoq'      => $actoQuirirgico,
                    'lateralidad'    => $this->input->post('lateralidad_op', true)[$i],
                    'autorizacion'   => $this->input->post('autorizacion_op', true)[$i],
                    'valor_cups'     => $this->input->post('valor_cups_op')[$i],
                    'fechaactual'    => $fechaactual,
                    'horaactual'     => $horaactual,
                    'cod_medi'       => '110010756401',
                    'cod_cons'       => $this->input->post('codconsulta_op'),
                    'login_ing'      => $this->input->post('login', true),
                    'id_admi'        => $this->input->post('convenios_op', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'     => 'SI',
                    //'nevolucion'     => $this->input->post('version', true)
                    'num_optometria' => $this->input->post('num_optometria', true),
                    'activo'             => 'SI'
                ];
                $this->examen_model->insertCieCups($cups);
            }
        }

        // mas cie diagnosticos
        $mas_cups = $this->input->post('cod_cierr_mop');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cierr_mop')); $i++) 
            {
                $mciecups = array(
                    'id_paciente'        => $id_paciente,
                    'cons_examen'        => $n_conexamen,
                    'nconsulta'          => $this->input->post('nconsulta', true),
                    //'tipo_docu'          => $tipo_docu,
                    //'identificacion'     => $identificacion,
                    'edad'               => $edad,
                    'ume'                => $ume,
                    'cod_causa_dia'      => $this->input->post('causa', true),
                    'cod_fina_cie'       => $this->input->post('finalidad2', true),
                    'cod_tipo'           => $this->input->post('tipoo', true),
                    'fechaactual'        => $fechaactual,
                    'horaactual'         => $horaactual,
                    'cod_medi'           => '110010756401',
                    'cod_cons'           => $this->input->post('codconsulta'),
                    'login_ing'          => $this->input->post('login', true),
                    'id_admi'            => $this->input->post('convenios', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'         => 'SI',
                    //'nevolucion'         => $this->input->post('version', true),
                    'num_optometria'     =>  $this->input->post('num_optometria', true),
                    'cod_ciemas'         => $this->input->post('cod_cierr_mop', true)[$i],
                    'nombre_ciemas'      => $this->input->post('nombre_cierr_mop', true)[$i],
                    'observaciones_ciemas'   => $this->input->post('observaciones_cierr_mop', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertCieCups($mciecups);
            }
        }

        // medicamentos oftalmologia
        // colocar inactivo los medicamentos en ciecups
        $m_med_activo   =    array(
            'activo'    => 'NO');

        $update_med_activo  =   $this->examen_model->updateMEDActivo($m_med_activo, $n_conexamen);
        
        $mas_medicamento = $this->input->post('id_medicamento_op');
        if ($mas_medicamento) 
        {
            for ($i = 0; $i < count($this->input->post('id_medicamento_op')); $i++) 
            {
                $m_medicamentos = array(
                    'id_paciente'               =>  $id_paciente,
                    'cons_examen'               =>  $n_conexamen,
                    'fechaactual'               =>  $fechaactual,
                    'horaactual'                =>  $horaactual,
                    'nconsulta'                 =>  $this->input->post('nconsulta', true),
                    'login_ing'                 =>  $this->input->post('login', true),
                    'cod_medi'                  =>  $this->input->post('medico', true),
                    'id_admi'                   =>  $this->input->post('convenios', true),
                    'tipo_historia'             =>  'OPTOMETRIA',
                    'id_medicamento'            =>  $this->input->post('id_medicamento_op', true)[$i],
                    'nombre_medicamento'        =>  $this->input->post('nombre_medicamento_op', true)[$i],
                    'concentracion'             =>  $this->input->post('concentracion_op', true)[$i],
                    'prescripcion'              =>  $this->input->post('prescripcion_op', true)[$i],
                    'cantidad'                  =>  $this->input->post('cantidad_op', true)[$i],
                    'tiempo'                    =>  $this->input->post('tiempo_op', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertMedicamentos($m_medicamentos);
            }
        }

        // paraclinicos
        $m_para_activo   =    array(
            'activo'    => 'NO');

        $update_para_activo  =   $this->examen_model->updatePARAActivo($m_para_activo, $n_conexamen);

        $cod_para = $this->input->post('cod_para_op');
        if ($cod_para) 
        {
            for ($i = 0; $i < count($this->input->post('cod_para_op')); $i++) 
            { 
                $m_para = array(
                    'id_paciente'        => $this->input->post('id_paciente'),
                    'cons_examen'        => $n_conexamen,
                    'cons_paraclinico'   => $n_conparaclinico,
                    'login_ing'          => $this->input->post('login', true),
                    'cod_para'           => $this->input->post('cod_para_op', true)[$i],
                    'nombre_para'        => $this->input->post('nombre_para_op', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertPara($m_para, $n_conparaclinico);
            }
        }

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            'ultimocontrol'         =>  $fechaactual,
            //'version'               =>  $this->input->post('version', true),
            //'num_oftalmologia'      =>  $this->input->post('num_oftalmologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // actualiza agenda color y evento
        /*$id_agenda          =    $this->input->post('id_agenda', true);
        if($id_agenda === '')
        {

        }else
        {
            $m_agenda   =   array(
                'estado'    =>   'Atendio',
                'color'     =>   '#5cb85c'
            );
            $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
        }*/

        // CONSULTA DE PACIENTE NUEVO

        $datos['examen_opt']            =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_optometria']      =  $this->input->post('num_optometria', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen;        

        $this->load->view('front_end/historias/hexamen_opt_v', $datos);
    }

    public function rep_historia_opt()
    {
        $this->load->model('examen_model');
        //$this->load->library('s3');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('n_conexamen');

        $examen             =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        //$ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        

        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // PRESTADOR
        //$prestador          =   $this->examen_model->prestador();
        
        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto     =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $nombre_admi    =   $pac->nombre_admi;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        foreach($examen as $exa)
        {
            $fecha_consulta  =   $exa['fechaactual'];
            $hora_consulta   =   $exa['horaactual'];
            $medico                         =   $exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi'];
        }

        
        /*$imgextension   =   substr($imagenfoto, -3);
        $contarpunto    =   substr_count($imagenfoto, ".");

        $porciones  =   explode(".", $imagenfoto);
        $extfoto    =   $porciones[$contarpunto]; 
        //echo $extfoto;

        if($imagenfoto)
        {            
            $datos['imagenfoto']  =   $this->pdf->Image(S3::getAuthenticatedURL('histocol', $imagenfoto, 600), 170,5, 26, 26, $extfoto);
        }else 
        {
            $datos['imagenfoto']  =   '';
        }*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 

        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        /////
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();

        foreach($examen as $exa)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Examen Biomicroscopico'),0,0,'L');
            
            // MEDICO, TIPO CONSULTA
            $this->pdf->SetX(55);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi']),0,0,'L');
            $this->pdf->SetX(120);
            
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(25,4,utf8_decode('Número Control:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(40,4,utf8_decode($exa['num_optometria']),0,0,'L');
            $this->pdf->Ln();

            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());
            $this->pdf->Ln();

            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['nombre_cons']),0,0,'L');
            $this->pdf->Ln();            


            if($exa['sintomas'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Sintomas:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['sintomas']),0,'J');
            }

            if($exa['ocupacion_habitual'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ocupación habitual más frecuente:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['ocupacion_habitual']),0,'J');
            }

            if($exa['distancia_habitual'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Distancia de trabajo cercana habitual:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['distancia_habitual']),0,'J');
            }

            if($exa['mano_dominante'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Mano dominante:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['mano_dominante']),0,'J');
            }

            if($exa['ojo_dominante'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo dominante:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['ojo_dominante']),0,'J');
            }

            if($exa['ultima_rx'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Dato de la última Rx:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['ultima_rx']),0,'J');
            }

            if($exa['optica_fecha'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Optica(Fecha):'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['optica_fecha']),0,'J');
            }

            if($exa['uso_clase_le'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Uso o clase de lentes:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['uso_clase_le']),0,'J');
            }

            if($exa['uso_od'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['uso_od']),0,'J');
            }

            if($exa['uso_od_v'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['uso_od_v']),0,'J');
            }

            if($exa['uso_oi'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['uso_oi']),0,'J');
            }

            if($exa['uso_oi_v'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['uso_oi_v']),0,'J');
            }

            if($exa['clase_od'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['clase_od']),0,'J');
            }

            if($exa['clase_od_v'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['clase_od_v']),0,'J');
            }

            if($exa['clase_oi'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['clase_oi']),0,'J');
            }

            if($exa['clase_oi_v'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['clase_oi_v']),0,'J');
            }
            $this->pdf->Ln();

            if($exa['estenopelco_od'] || $exa['estenopelco_oi'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Agudeza visual con estenopelco:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['estenopelco_od']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['estenopelco_oi']),0,'J');
            } 

            if($exa['estado_forico'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Estado fórico habitual(Con-Sin Rx):'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['estado_forico']),0,'J');
            }

            if($exa['horizontal_lejos'] || $exa['horizontal_cerca'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Horizontal:'),0,0,'L');
                $this->pdf->Ln();

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Lejos:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['horizontal_lejos']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Cerca:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['horizontal_cerca']),0,'J');
            }

            if($exa['vertical_lejos'] || $exa['vertical_cerca'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Vertical:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Lejos:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['vertical_lejos']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Cerca:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['vertical_cerca']),0,'J');
            }

            if($exa['oftalmometria_od'] || $exa['oftalmometria_oi'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Oftalmometría:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['oftalmometria_od']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['oftalmometria_oi']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observacioens:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['oftalmometria_obs']),0,'J');
            }

            if($exa['retino_esta_od'] || $exa['retino_esta_oi'] || $exa['retino_esta_obs'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Retinoscopía Estática:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['retino_esta_od']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['retino_esta_oi']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['retino_esta_obs']),0,'J');
            }

            if($exa['retino_dina_od'] || $exa['retino_dina_oi'] )
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Retinoscopía Dinámica:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['retino_dina_od']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['retino_dina_oi']),0,'J');
            }   

            if($exa['subjetivo_od'] || $exa['subjetivo_od_v'] ||$exa['subjetivo_oi'] || $exa['subjetivo_oi_v'] )
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Subjetivo:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['subjetivo_od']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['subjetivo_od_v']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['subjetivo_oi']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['subjetivo_oi_v']),0,'J');
            }   

            if($exa['adicion_od'] || $exa['adicion_od_v'] ||$exa['adicion_od_dist'] || $exa['adicion_oi'] || $exa['adicion_oi_v'] || $exa['adicion_oi_dist'] || $exa['mipes_od'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Adición:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['adicion_od']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['adicion_od_v']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Dist:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['adicion_od_dist']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['adicion_oi']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['adicion_oi_v']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Dist:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['adicion_oi_dist']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Visión próxima sin corrección (Miopes) Ojo Derecho:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['mipes_od']),0,'J');
            }   

            if($exa['forico_h_lejos'] || $exa['forico_v_lejos'] ||$exa['forico_h_cerca'] || $exa['forico_v_cerca'] || $exa['forico_obs'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Estado fórico inducido:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('H - Lejos:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['forico_h_lejos']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V - Lejos:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['forico_v_lejos']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('H - Cerca:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['forico_h_cerca']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('V - Cerca:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['forico_v_cerca']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['forico_obs']),0,'J');
            }   


            if($exa['amplitud_od'] || $exa['amplitud_oi'] )
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Amplitud de acomodación:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Derecho:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['amplitud_od']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Ojo Izquierdo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['amplitud_oi']),0,'J');
            }   

            if($exa['amplitud_r_pos'] || $exa['amplitud_r_neg'] )
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Amplitud de acomodación Relativa:'),0,0,'L');
                $this->pdf->Ln();
                
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('POSITIVO:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['amplitud_r_pos']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('NEGATIVO:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['amplitud_r_neg']),0,'J');
            } 

            if($exa['for_vl_esf_od'] || $exa['for_vl_cil_od'] || $exa['for_vl_eje_od'] || $exa['for_vl_pri_od'] || $exa['for_vl_bas_od'] || $exa['for_vl_esf_oi'] || $exa['for_vl_cil_oi'] || $exa['for_vl_eje_oi'] || $exa['for_vl_pri_oi'] || $exa['for_vl_bas_oi'] || $exa['for_vp_esf_od'] || $exa['for_vp_cil_od'] || $exa['for_vp_eje_od'] || $exa['for_vp_pri_od'] || $exa['for_vp_bas_od'] || $exa['for_vp_esf_oi'] || $exa['for_vp_cil_oi'] || $exa['for_vp_eje_oi'] || $exa['for_vp_pri_oi'] || $exa['for_vp_bas_oi'] || $exa['obs_formula'] || $exa['color'] || $exa['dist_pupilar'] )  
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('FORMULA FINAL'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                $this->pdf->Cell(41, 5, utf8_decode('PRESCRIPCIÓN'), 1, 0, 'C', 0);
                $this->pdf->Cell(27, 5, utf8_decode('ESFERA'), 1, 0, 'C', 0);
                $this->pdf->Cell(27, 5, utf8_decode('CILINDRO'), 1, 0, 'C', 0);
                $this->pdf->Cell(27, 5, utf8_decode('EJE'), 1, 0, 'C', 0);
                $this->pdf->Cell(27, 5, utf8_decode('PRISMA'), 1, 0, 'C', 0);
                $this->pdf->Cell(27, 5, utf8_decode('BASE'), 1, 0, 'C', 0);

                $this->pdf->Ln();

                // DETALLES

                // PRIMER FILA
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(14,27,27,27,27,27,27));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('C','C','C','C','C','C'));
                  
                $vision_lejana      =   utf8_decode('LEJOS');
                $vl_ojo_derecho     =   utf8_decode('Ojo Derecho');
                $for_vl_esf_od      =   utf8_decode($exa['for_vl_esf_od']);
                $for_vl_cil_od      =   utf8_decode($exa['for_vl_cil_od']);
                $for_vl_eje_od      =   utf8_decode($exa['for_vl_eje_od']);
                $for_vl_pri_od      =   utf8_decode($exa['for_vl_pri_od']);
                $for_vl_bas_od      =   utf8_decode($exa['for_vl_bas_od']);
                
                $this->pdf->Row(array($vision_lejana, $vl_ojo_derecho, $for_vl_esf_od, $for_vl_cil_od, $for_vl_eje_od, $for_vl_pri_od, $for_vl_bas_od));

                // SEGUNDA FILA
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(14,27,27,27,27,27,27));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('C','C','C','C','C','C','C'));

                  
                $vision_lejana      =   utf8_decode('LEJOS');
                $vl_ojo_derecho     =   utf8_decode('Ojo Izquierdo');
                $for_vl_esf_oi      =   utf8_decode($exa['for_vl_esf_oi']);
                $for_vl_cil_oi      =   utf8_decode($exa['for_vl_cil_oi']);
                $for_vl_eje_oi      =   utf8_decode($exa['for_vl_eje_oi']);
                $for_vl_pri_oi      =   utf8_decode($exa['for_vl_pri_oi']);
                $for_vl_bas_oi      =   utf8_decode($exa['for_vl_bas_oi']);
                
                $this->pdf->Row(array($vision_lejana, $vl_ojo_derecho, $for_vl_esf_oi, $for_vl_cil_oi, $for_vl_eje_oi, $for_vl_pri_oi, $for_vl_bas_oi));

                // TERCERA FILA
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(14,27,27,27,27,27,27));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('C','C','C','C','C','C','C'));

                  
                $vision_lejana      =   utf8_decode('CERCA');
                $vl_ojo_derecho     =   utf8_decode('Ojo Derecho');
                $for_vp_esf_od      =   utf8_decode($exa['for_vp_esf_od']);
                $for_vp_cil_od      =   utf8_decode($exa['for_vp_cil_od']);
                $for_vp_eje_od      =   utf8_decode($exa['for_vp_eje_od']);
                $for_vp_pri_od      =   utf8_decode($exa['for_vp_pri_od']);
                $for_vp_bas_od      =   utf8_decode($exa['for_vp_bas_od']);
                
                $this->pdf->Row(array($vision_lejana, $vl_ojo_derecho, $for_vp_esf_od, $for_vp_cil_od, $for_vp_eje_od, $for_vp_pri_od, $for_vp_bas_od));

                // CUARTA FILA
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(14,27,27,27,27,27,27));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('C','C','C','C','C','C','C'));

                  
                $vision_lejana      =   utf8_decode('CERCA');
                $vl_ojo_derecho     =   utf8_decode('Ojo Izquierdo');
                $for_vp_esf_oi      =   utf8_decode($exa['for_vp_esf_oi']);
                $for_vp_cil_oi      =   utf8_decode($exa['for_vp_cil_oi']);
                $for_vp_eje_oi      =   utf8_decode($exa['for_vp_eje_oi']);
                $for_vp_pri_oi      =   utf8_decode($exa['for_vp_pri_oi']);
                $for_vp_bas_oi      =   utf8_decode($exa['for_vp_bas_oi']);
                
                $this->pdf->Row(array($vision_lejana, $vl_ojo_derecho, $for_vp_esf_oi, $for_vp_cil_oi, $for_vp_eje_oi, $for_vp_pri_oi, $for_vp_bas_oi));

                if($exa['obs_formula'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['obs_formula']),0,'J');
                }   

                if($exa['color'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Color:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['color']),0,'J');
                }   

                if($exa['dist_pupilar'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Distancia Pupilar:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['dist_pupilar']),0,'J');
                }   
            }

            // DIAGNOSTICOS
            if($cie)
            {
                foreach($cie as $ci)
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());   
                    

                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','BU',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                    

                    if($ci['observacionescie'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');    
                    }
                    

                    if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                    if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                    if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
                }
            }

            // MAS DIAGNOSTICOS
            if($ciemas)
            {
                $this->pdf->Ln(5);
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
                $this->pdf->Ln(5);
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(90,90));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($ciemas)
                {
                    foreach ($ciemas as $cmas) 
                    {   
                        $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                        $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                        
                        
                        $this->pdf->Row(array($cod_ciemas, $cod_observ));
                    }
                }    
            }

            // ordenes medicas
            if($cups)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('ORDENES MÉDICAS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();
                
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(160, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(160,20));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($cups)
                {
                    foreach ($cups as $row) 
                    {   
                        $cod_cups            =   utf8_decode($row['cod_cups'].'-'.$row['nombre_cups']);
                        $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                        
                        
                        $this->pdf->Row(array($cod_cups, $nombre_lateralidad));
                    }
                }    
            }

            // observaciones cups
            if($exa['observacionescups'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['observacionescups']),0,'J');
                $this->pdf->Ln();
            }

            // COMENTARIOS
            if($exa['comentarios'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Comentarios:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['comentarios']),0,'J');
            } 

            // plan de tratamiento
            if($exa['planotratamiento'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Plan o Tratamiento:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['planotratamiento']),0,'J');
                $this->pdf->Ln();   
            }

            // medicamentos
            if($medicamentos)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('MEDICAMENTOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
                $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
                $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
                $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
                $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(68,38,38,15,30));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L','L','L','L'));

                if($medicamentos)
                {
                    foreach ($medicamentos as $med) 
                    {   
                        $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                        $concentracion              =   utf8_decode($med['concentracion']);
                        $prescripcion               =   utf8_decode($med['prescripcion']);
                        $cantidad                   =   utf8_decode($med['cantidad']);
                        $tiempo                     =   utf8_decode($med['tiempo']);
                        
                        $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                    }
                }    
            }

            // paraclinicos
            if($paraclinicos)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('PREQUIRURGICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',7);
                $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',7);
                $this->pdf->SetWidths(array(150));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($paraclinicos)
                {
                    foreach ($paraclinicos as $para) 
                    {   
                        $nombre_para            =   utf8_decode($para['nombre_para']);
                        
                        
                        $this->pdf->Row(array($nombre_para));
                    }
                }    
            }
            

            $this->pdf->Ln();  

            // FIRMAS X EVOLUCION
            if($exa['firmamedi'])
            {
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
                $this->pdf->Image('data://image/png;base64,'.$exa['firmamedi'],20, $this->pdf->GetY(), 50, 25, 'png');
            }else
            {
            }

            if($exa['firmapaci'])
            {
                $this->pdf->SetX(80);
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
                $this->pdf->Image('data://image/png;base64,'.$exa['firmapaci'],110, $this->pdf->GetY(), 50, 25, 'png');
            }
            else
            {
            }

            $this->pdf->ln(20);
        

            // NOMBRES PACIENTE Y MEDICO EN FIRMAS
            $this->pdf->SetX(25);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

            $this->pdf->SetX(110);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
            
            
        }

        $this->pdf->Ln();
        $this->pdf->Output("Reporte historia .pdf", 'I');
    }

    public function ingresoexamen_ne() 
    {


        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        = $this->examen_model->consultaconsecutivo(7);
        $num_formula        = $this->historia_model->consultaconsecutivo(16);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        

        $id_paciente                =   $this->input->post('id_paciente', true);
        //$tipo_docu                  =   $this->input->post('tipo_docu', true);
        //$identificacion             =   $this->input->post('identificacion', true);

        $m_ne = array(
            'id_paciente'               => $id_paciente,
            'cons_examen'               => $n_conexamen,
            'fechaactual'               => $fechaactual,
            'horaactual'                => $horaactual,
            'nconsulta'                 => $this->input->post('nconsulta', true),
            'login_ing'                 => $this->input->post('login', true),
            //'firmapaci'                 => $up_firma_paciente,
            //'firmamedi'                 => $up_firma_medico,
            //'cod_medi'                  => $this->input->post('medico', true),
            'neferm_alergico'           =>  $this->input->post('neferm_alergico', true),
            'neferm_procedimiento'      =>  $this->input->post('neferm_procedimiento', true),
            'nenferm_tipo'              =>  $this->input->post('nenferm_tipo'),
            'neferm_horanota'           =>  $this->input->post('neferm_horanota'),
        );

            $insertExa_ne = $this->examen_model->insertExa_ne($m_ne, $n_conexamen);

            

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            
            'ultimocontrol'         =>  $fechaactual,
            //'version'               =>  $this->input->post('version', true),
            'num_ne'                => $this->input->post('num_ne', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // AGREGANDO MEDICAMENTOS
        $id_medicamento = $this->input->post('id_medicamento');

        if ($id_medicamento) 
        {
            // encabezado
            $m_enc_medicamentos = array(                    
                'num_formula'           =>  $num_formula,
                'id_paciente'           =>  $id_paciente,
                //'cod_medi'              =>  $cod_medi,
                'fechaactual'           =>  $fechaactual,
                'horaactual'            =>  $horaactual,                            
                'login_ing'             =>  $login_ing,
                'cons_examen'           =>  $n_conexamen
            );
            // INSERTAR DATOS ENCABEZADO  medicamento            
            $this->historia_model->ingresoencmed($m_enc_medicamentos, $num_formula);

            for ($i = 0; $i < count($this->input->post('id_medicamento')); $i++) 
            {
                // ingresar detalles
                $m_det_medicamentos = array(
                'num_formula'       =>  $num_formula,
                'id_paciente'       =>  $id_paciente,
                'id_medicamento'    =>  $this->input->post('id_medicamento', true)[$i], 
                'medicamento'       =>  $this->input->post('medicamento', true)[$i], 
                'cantidad'          =>  $this->input->post('cantidad', true)[$i],
                'prescripcion'      =>  $this->input->post('prescripcion', true)[$i],
                'viamedicamento'    =>  $this->input->post('viamedicamento', true)[$i],
                'fechaactual'       =>  $fechaactual,
                'horaactual'        =>  $horaactual,                            
                'login_ing'         =>  $login_ing,
                'cons_examen'       =>  $n_conexamen
                ); 

                // INSERTAR DATOS detalles medicamento            
                $this->historia_model->ingresodetmed($m_det_medicamentos);
            }

        } 
        
        // ENCABEZADO
        $encabezado                     =   $this->historia_model->conencaformula($num_formula, $id_paciente);
        // DETALLES
        $datos['detalles']              =   $this->historia_model->condetaformula($num_formula);
        //$datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        //$datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;

        //$this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    public function validacups()
    {
        $this->load->model('examen_model');

        $cod_cups           =   trim($this->input->post('bd_cod_cups', true));
        
        $cons_cups         =   $this->examen_model->cons_cups($cod_cups);
        echo $cons_cups;
    }

    // prequirurgicos
    public function busqueda_para()
    {
        $paraclinico         =   trim($this->input->post('paraclinico', true));
        
        $this->datatables->select("cod_listap, nombre_listap")
        ->from('listaprecios');
        $this->db->like('nombre_listap', $paraclinico);       
        $this->db->where_in('cod_lptipo', '4');    
        echo $this->datatables->generate(); 
    }  

    // consulta prequirurgicos
    public function consulta_prequirurgicos()
    {
        $this->load->model('examen_model');
        $datos['cons_prequirurgicos']         =   $this->examen_model->cons_prequirurgicos();
        $this->load->view('front_end/historias/hexamen_preq_v', $datos);
    }

    // consulta prequirurgicos
    public function consulta_prequirurgicos_op()
    {
        $this->load->model('examen_model');
        $datos['cons_prequirurgicos']         =   $this->examen_model->cons_prequirurgicos();
        $this->load->view('front_end/historias/hexamen_preq_op_v', $datos);
    }

    public function nuevocups()
    {   
        $this->load->model('examen_model');

        $cod_cups               =   strtoupper($this->input->post('codigo_cups', true));
        $nombre_cups            =   strtoupper($this->input->post('nombre_cups', true));
        $sexo                   =   'A';
        $limite_inferior        =   0;
        $limite_superior        =   599;
        $cupsmaxvecesdia        =   '1';
        $cupsmaxvecesvida       =   '';
        $cupstiempolimitedias   =   '';
        $cupsconcie             =   'S';
        $cupstipoatencion       =   'AP';
        $cupstipoprocedimiento  =   'Cirugía';
        $cod_cups_tipopro       =   '1';
        $valor                  =   0;
        $nuevo_manual           =   'SI';

        $m_nuevo_cups           =   array(
            'cod_cups'              =>   $cod_cups,
            'nombre_cups'           =>   $nombre_cups,
            'sexo'                  =>   $sexo,
            'limite_inferior'       =>   $limite_inferior,
            'limite_superior'       =>   $limite_superior,
            'cupsmaxvecesdia'       =>   $cupsmaxvecesdia,
            'cupsmaxvecesvida'      =>   $cupsmaxvecesvida,
            'cupstiempolimitedias'  =>   $cupstiempolimitedias,
            'cupsconcie'            =>   $cupsconcie,
            'cupstipoatencion'      =>   $cupstipoatencion,
            'cupstipoprocedimiento' =>   $cupstipoprocedimiento,
            'cod_cups_tipopro'      =>   $cod_cups_tipopro,
            'valor'                 =>   $valor,
            'nuevo_manual'          =>   $nuevo_manual
        );

        $insertNewCups  =   $this->examen_model->insertNewCups($m_nuevo_cups);
        $cons_id        =   $this->examen_model->cons_id($cod_cups);
        
        echo $cons_id;
    }

    public function siluetas() {
        $vista = $this->input->post('vista');

        if ($this->input->post('identificacion') && $this->input->post('tipo_docu')) {

            $this->load->model('examen_model');
            $datos["notes"] = $this->examen_model->silueta($this->input->post('identificacion'), $this->input->post('tipo_docu'), $this->input->post('n_conexamen'));
            $this->load->view('front_end/historias/' . $vista . ".php", $datos);

        } else {
            $this->load->view('front_end/historias/' . $vista . ".php");
        }

    }

    public function csiluetas() {
        $vista = $this->input->post('vista');
        $vnotes= $this->input->post('vnotes');
        $datos['vnotes'] =  $vnotes;
        if ($this->input->post('id_paciente')) {

            $this->load->model('historia_model');
            $datos["notes"] = $this->historia_model->silueta($this->input->post('id_paciente'));
            $this->load->view('front_end/historias/' . $vista . ".php", $datos);

        } else {
            $this->load->view('front_end/historias/' . $vista . ".php");
        }

    }

    public function consulta_hist_oft()
    {
        $this->load->model('examen_model');

        $id_paciente        =   $this->input->post('bd_id_paciente_oft', true);
        $n_conexamen        =   $this->input->post('bd_cons_examen_oft', true);

        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   '';
        $datos['tipo_identificacion']   =   '';
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);   
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);     

        $this->load->view('front_end/historias/hexamen_r_v', $datos);

    }

    public function consulta_hist_opt()
    {
        $this->load->model('examen_model');
        //$this->load->library('imagenes');

        $id_paciente        =   $this->input->post('bd_id_paciente_opt', true);
        $n_conexamen        =   $this->input->post('bd_cons_examen_opt', true);



        //$this->load->library('s3');

        $datos['examen_opt']            =   $this->examen_model->ciexamen_opt($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        

        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_optometria']      =  $this->input->post('num_optometria', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   '';
        $datos['tipo_identificacion']   =   '';
        $datos['n_conexamen']           =   $n_conexamen;

        
        $datos['cons_examen']           =   $n_conexamen;  


        $this->load->view('front_end/historias/hexamen_opt_v', $datos);
    }

    // consentimientos anestesia
    public function ing_cons_anestesia()
    {
        $this->load->library('imagenes');
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        
        $n_conexamen = $this->examen_model->consultaconsecutivo(7);
        $fechaingreso   = date("Y-m-d");
        $horaingreso    = date("H:i:s");
        $id_paciente    =   $this->input->post('id_paciente', true);

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1_cons_ane'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $m_cons_anestesia = [
            'cons_examen'       =>  $n_conexamen,
            'id_paciente'       =>  $id_paciente,
            'descripcion'       =>  $this->input->post('descripcioncons_ane'),
            'fechaactual'       =>  $fechaingreso,
            'horaactual'        =>  $horaingreso,
            'tipo'              =>  'DILATACIÓN',
            'firmamedi'         =>  $up_firma_medico
        ];

        $inserConsOdon = $this->examen_model->ingresoConsAne($m_cons_anestesia, $n_conexamen);

        // CONSULTA DE consentimiento anestesia
        $this->load->library('s3');
        $datos['cons_cons_ane']         =   $this->examen_model->cons_cons_ane($id_paciente,$n_conexamen);
        $this->load->view('front_end/historias/hexamen_cons_ane_v', $datos);
    } 

    public function rep_cons_ane()
    {
        
        $this->load->library('s3');
        $this->load->model('examen_model');
        
        $bd_id_con_asig         =   trim($this->input->post('bd_id_con_asig'));
        
        
        $con_cons_ane           =   $this->examen_model->con_cons_ane($bd_id_con_asig);  
        if($con_cons_ane)
        {
            foreach($con_cons_ane as $cpac)
            {
                $texto          =   $cpac['descripcion'];
                //$firmapaci      =   $cpac['firmapaci'];
            }    
        }
        

        //if ($a->firmapaci !== '0') 
        //{
            
        //    $fpac   =   "<img src='". S3::getAuthenticatedURL('histocol', $a->firmapaci, 3600). "' style='width: 300px; height: 150px' />";
        //} else {
            $fpac   =   "";
        //}

        $html = 
        "<style>@page {
                margin-top: 0.5cm;
                margin-bottom: 0.5cm;
                margin-left: 0.5cm;
                margin-right: 0.5cm;
            }
            </style>".
        "<body>
            <div style='color:#006699;'><b>".$texto."<b></div>".
                "<div style='width:50px; height:50px; background-color:red;'>asdf</div>

                <div >".$fpac."</div>

        </body>";


        $this->load->library('M_pdf');
        $mpdf = new mPDF('c', 'A4-L'); 
        $mpdf->WriteHTML($texto);
        $mpdf->Output("Reporte consentimiento odontologia.pdf", "I");
    }

    public function cons_firma_med()
    {
        $this->load->model('examen_model');
        $cod_medi   =   $this->input->post('cod_medi');
        $cons_f     =   $this->examen_model->firma_medi($cod_medi);


    }
    
    public function rep_medicamentos()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);

        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);
        
        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }
        }

        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           =   $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }            
        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        
        
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(0,4,utf8_decode('FORMULACIÓN DE MEDICAMENTOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/

        //$this->pdf->Ln(3);

        /*$this->pdf->SetDrawColor(215,215,215);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);


        // FALTA ACUDIENTE

        // MEDICO Y TIPO CONSULTA
        /*$this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($tipo),0,0,'L');
        $this->pdf->Ln();

        // tipo de consulta oftalmologia.consulta y control
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','BU',7);
        $this->pdf->Cell(15,4,utf8_decode('TIPO DE CONSULTA: OFTALMOLOGÍA'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(20,4,utf8_decode('Tipo consulta'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(60,4,utf8_decode($tipoconsulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(20,4,utf8_decode('Número Control:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(40,4,utf8_decode($num_oftalmologia),0,0,'L');
        $this->pdf->Ln(); */

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }

        if($medicamentos)
        {
            //$this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Medicamentos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(68,38,38,15,30));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','L','L','L'));

            if($medicamentos)
            {
                foreach ($medicamentos as $med) 
                {   
                    $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                    $concentracion              =   utf8_decode($med['concentracion']);
                    $prescripcion               =   utf8_decode($med['prescripcion']);
                    $cantidad                   =   utf8_decode($med['cantidad']);
                    $tiempo                     =   utf8_decode($med['tiempo']);
                    
                    $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        
        
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');

            
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
            

        }
        else
        {
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
        

        $this->pdf->Output("Reporte medicamentos .pdf", 'I');

    }

    public function rep_medicamentos_op()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen_op($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);

        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);
        
        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }
        }

        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           =   $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }            
        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        
        
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(0,4,utf8_decode('FORMULACIÓN DE MEDICAMENTOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/

        //$this->pdf->Ln(3);

        /*$this->pdf->SetDrawColor(215,215,215);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);


        // FALTA ACUDIENTE

        // MEDICO Y TIPO CONSULTA
        /*$this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($tipo),0,0,'L');
        $this->pdf->Ln();

        // tipo de consulta oftalmologia.consulta y control
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','BU',7);
        $this->pdf->Cell(15,4,utf8_decode('TIPO DE CONSULTA: OFTALMOLOGÍA'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(20,4,utf8_decode('Tipo consulta'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(60,4,utf8_decode($tipoconsulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(20,4,utf8_decode('Número Control:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(40,4,utf8_decode($num_oftalmologia),0,0,'L');
        $this->pdf->Ln(); */

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }

        if($medicamentos)
        {
            //$this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Medicamentos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(68,38,38,15,30));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','L','L','L'));

            if($medicamentos)
            {
                foreach ($medicamentos as $med) 
                {   
                    $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                    $concentracion              =   utf8_decode($med['concentracion']);
                    $prescripcion               =   utf8_decode($med['prescripcion']);
                    $cantidad                   =   utf8_decode($med['cantidad']);
                    $tiempo                     =   utf8_decode($med['tiempo']);
                    
                    $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,110, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }
        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,20, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }
        
        

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);


        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte medicamentos .pdf", 'I');

    }

    public function rep_prequirurgico()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('PREQUIRURGICOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();         
        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // paraclinicos
        if($paraclinicos)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(150));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($paraclinicos)
            {
                foreach ($paraclinicos as $para) 
                {   
                    $nombre_para            =   utf8_decode($para['nombre_para']);
                    
                    
                    $this->pdf->Row(array($nombre_para));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
        

        $this->pdf->Output("Reporte prequirurgico.pdf", 'I');
    }

    public function rep_prequirurgico_op()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen_op($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('PREQUIRURGICOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();         
        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // paraclinicos
        if($paraclinicos)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(150));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($paraclinicos)
            {
                foreach ($paraclinicos as $para) 
                {   
                    $nombre_para            =   utf8_decode($para['nombre_para']);
                    
                    
                    $this->pdf->Row(array($nombre_para));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }
        
        $this->pdf->ln(20);
        
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte prequirurgico.pdf", 'I');
    }

    // reporte incapacidades
    public function rep_incapacidades()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            
            $nombre_admi                    =   $exa->nombre_admi;
            

            $incapacidades                  =   $exa->incapacidades;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('INCAPACIDAD'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // incapacidades
        if($incapacidades)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte incapacidad.pdf", 'I');
    }

    public function rep_incapacidades_op()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen_op($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            
            $nombre_admi                    =   $exa->nombre_admi;
            

            $incapacidades                  =   $exa->incapacidades;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('INCAPACIDAD'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // incapacidades
        if($incapacidades)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte incapacidad.pdf", 'I');
    }

    // reporte ordenes medicas oftalmologicas
    public function rep_ordenes_medicas()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }
        
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta              =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $tipo                           = $exa->nombre_listap;
            $tipoconsulta                   = $exa->nombre_cons;
            $firmapaci                      =   $exa->firmapaci;
            $firmamedi                      =   $exa->firmamedi;

            $observacionescups              =   $exa->observacionescups;
            $nombre_admi                    =   $exa->nombre_admi;
            $nombre_listap                  =   $exa->nombre_listap;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        //for($num_linea=1;$num_linea<=185;$num_linea++)
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('ORDEN MÉDICA'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                    if($ci['observacionescier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                    if($ci['observacionesciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                    if($ci['observacionescierr'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                    }
                }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }
        $this->pdf->Ln();

        // CUPS
        if($cups)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15, 5, utf8_decode('CUPS'), 1, 0, 'C', 0);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(15,150,20));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($cups)
            {
                foreach ($cups as $row) 
                {   
                    $cod_cups            =   utf8_decode($row['cod_cups']);
                    $descripcion         =   utf8_decode($row['nombre_cups']);
                    $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                    
                    
                    $this->pdf->Row(array($cod_cups, $descripcion, $nombre_lateralidad));
                }
            }    
        }

        if($observacionescups)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($observacionescups),0,'J');
            //$this->pdf->Ln(3);
        }
        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($c_firma_medico)
        {
            $this->pdf->Image('data://image/png;base64,'.$firmamedi,20, $this->pdf->GetY(), 30, 20, 'png');
        }

        if($firmapaci)
        {
            $this->pdf->SetX(80);
            $this->pdf->Image('data://image/png;base64,'.$firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
            
        }
        //$vfirmamed              =   (($firmamedi) ? $this->pdf->Image(S3::getAuthenticatedURL('histocol', $firmamedi, 600), 90, $this->pdf->GetY(), 30, 30, 'png'):"");
        

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte Orden Medica .pdf", 'I');
    }

    // reporte ordenes medicas oftalmologicas
    public function rep_ordenes_medicas_op()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_oftalmologia   =   $this->input->post('num_oftalmologia');

        $examen             =   $this->examen_model->ciexamen_op($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }
        
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;

            $tipo                           =   $exa->nombre_listap;
            $tipoconsulta                   =   $exa->nombre_cons;
            $firmapaci                      =   $exa->firmapaci;
            $firmamedi                      =   $exa->firmamedi;

            $observacionescups              =   $exa->observacionescups;
            $nombre_admi                    =   $exa->nombre_admi;
            $nombre_listap                  =   $exa->nombre_listap;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        //for($num_linea=1;$num_linea<=185;$num_linea++)
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('ORDEN MÉDICA'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                    if($ci['observacionescier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                    if($ci['observacionesciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                    if($ci['observacionescierr'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                    }
                }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }
        $this->pdf->Ln();

        // CUPS
        if($cups)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15, 5, utf8_decode('CUPS'), 1, 0, 'C', 0);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(15,150,20));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($cups)
            {
                foreach ($cups as $row) 
                {   
                    $cod_cups            =   utf8_decode($row['cod_cups']);
                    $descripcion         =   utf8_decode($row['nombre_cups']);
                    $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                    
                    
                    $this->pdf->Row(array($cod_cups, $descripcion, $nombre_lateralidad));
                }
            }    
        }

        if($observacionescups)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($observacionescups),0,'J');
            //$this->pdf->Ln(3);
        }
        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($firmapaci)
        {
          $this->pdf->Image('data://image/png;base64,'.$firmapaci,30, $this->pdf->GetY(), 50, 25, 'png');
            
        }
        //$vfirmamed              =   (($firmamedi) ? $this->pdf->Image(S3::getAuthenticatedURL('histocol', $firmamedi, 600), 90, $this->pdf->GetY(), 30, 30, 'png'):"");
        if($c_firma_medico)
        {
            $this->pdf->Image('data://image/png;base64,'.$firmamedi,115, $this->pdf->GetY(), 30, 20, 'png');
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte Orden Medica .pdf", 'I');
    }

    // optometria
    // nuevo cups optometria
    public function nuevocups_op()
    {   
        
        
        $this->load->model('examen_model');

        $cod_cups               =   strtoupper($this->input->post('codigo_cups_op', true));
        $nombre_cups            =   strtoupper($this->input->post('nombre_cups_op', true));
        $sexo                   =   'A';
        $limite_inferior        =   0;
        $limite_superior        =   599;
        $cupsmaxvecesdia        =   '1';
        $cupsmaxvecesvida       =   '';
        $cupstiempolimitedias   =   '';
        $cupsconcie             =   'S';
        $cupstipoatencion       =   'AP';
        $cupstipoprocedimiento  =   'Cirugía';
        $cod_cups_tipopro       =   '1';
        $valor                  =   0;
        $nuevo_manual           =   'SI';

        $m_nuevo_cups           =   array(
            'cod_cups'              =>   $cod_cups,
            'nombre_cups'           =>   $nombre_cups,
            'sexo'                  =>   $sexo,
            'limite_inferior'       =>   $limite_inferior,
            'limite_superior'       =>   $limite_superior,
            'cupsmaxvecesdia'       =>   $cupsmaxvecesdia,
            'cupsmaxvecesvida'      =>   $cupsmaxvecesvida,
            'cupstiempolimitedias'  =>   $cupstiempolimitedias,
            'cupsconcie'            =>   $cupsconcie,
            'cupstipoatencion'      =>   $cupstipoatencion,
            'cupstipoprocedimiento' =>   $cupstipoprocedimiento,
            'cod_cups_tipopro'      =>   $cod_cups_tipopro,
            'valor'                 =>   $valor,
            'nuevo_manual'          =>   $nuevo_manual
        );

        $insertNewCups  =   $this->examen_model->insertNewCups($m_nuevo_cups);
        $cons_id        =   $this->examen_model->cons_id($cod_cups);
        
        echo $cons_id;

    }

    // retinologia
    public function ingresoexamen_ret() 
    {
        //$this->load->library('imagenes');
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->examen_model->consultaconsecutivo(7);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);

        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso       =   date("Y-m-d");
        $horaingreso        =   date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /**
         * Subir firmas y foto
         */

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1_op'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1_op'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));*/

        

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'                   =>  $id_paciente,
            'cons_examen'                   =>  $n_conexamen,
            'fechaactual'                   =>  $fechaactual,
            'horaactual'                    =>  $horaactual,
            'nconsulta'                     =>  $this->input->post('nconsulta', true),
            'login_ing'                     =>  $this->input->post('login', true),
            'edad'                          =>  $edad,
            'ume'                           =>  $ume,
            'cod_cons'                      =>  $this->input->post('codconsulta_ret', true),
            'observacionescups'             =>  $this->input->post('observacionescups_opret', true),
            'firmapaci'                     =>  $this->input->post('firmapaciente1_opret'),
            'firmamedi'                     =>  $this->input->post('firmamedico1_opret'),
            'cod_medi'                      =>  $this->input->post('medico_opret', true),
            'num_retinologia'               =>  $this->input->post('num_retinologia', true),
            //'cod_consultorio'               =>  $this->input->post('consultorios_op', true),
            'id_admi'                       =>  $this->input->post('convenios_opret', true),
            'mc_retin'                      =>  $this->input->post('mc_retin', true),
            'ea_retin'                      =>  $this->input->post('ea_retin', true),
            'ap_retin'                      =>  $this->input->post('ap_retin', true),
            'av_retin'                      =>  $this->input->post('av_retin', true),
            'bio_retin'                     =>  $this->input->post('bio_retin', true),
            'moe_retin'                     =>  $this->input->post('moe_retin', true),
            'pio_retin'                     =>  $this->input->post('pio_retin', true),
            'fo_retin'                      =>  $this->input->post('fo_retin', true),
            'reco_retin'                    =>  $this->input->post('reco_retin', true),
            'tipo_co'                       =>  $this->input->post('tipo_co_op_ret', true),
            'abierta'                       =>  'SI',
            'planotratamiento'              =>  $this->input->post('planotratamiento_opret', true),
            'id_agenda'                     =>  $this->input->post('id_agenda_opret', true),
            'incapacidades'                 =>  $this->input->post('incapacidades_opret', true)
        );

            $insertExa = $this->examen_model->insertExa_optret($examen, $n_conexamen);

            $vcod_cier = $this->input->post('cod_cier_opret', true);

            if (!$vcod_cier || $vcod_cier === '') {
                $cod_cier       =   '';
                $nombre_cier    =   '';
            } else {
                $cod_cier       =   $vcod_cier;
                $nombre_cier    =   $this->input->post('nombre_cier_opret');
            };

            $vcod_ciers = $this->input->post('cod_ciers_opret', true);

            if (!$vcod_ciers || $vcod_ciers === '') {
                $cod_ciers      =   '';
                $nombre_ciers   =   '';
            } else {
                $cod_ciers      =   $vcod_ciers;
                $nombre_ciers   =   $this->input->post('nombre_ciers_opret');
            };

            $vcod_cierr = $this->input->post('cod_cierr_opret', true);

            if (!$vcod_cierr || $vcod_cierr === '') {
                $cod_cierr      =   '';
                $nombre_cierr   =   '';
            } else {
                $cod_cierr      =   $vcod_cierr;
                $nombre_cierr   =   $this->input->post('nombre_cierr_opret');
            };

            $ciecups = array(
                'id_paciente'        => $id_paciente,
                'cons_examen'        => $n_conexamen,
                'nconsulta'          => $this->input->post('nconsulta', true),
                //'tipo_docu'          => $tipo_docu,
                //'identificacion'     => $identificacion,
                'edad'               => $edad,
                'ume'                => $ume,
                'cod_cie'            => $this->input->post('cod_cie_opret'),
                'nombre_cie'         => $this->input->post('nombre_cie_opret'),
                'cod_causa_dia'      => $this->input->post('causa_opret', true),
                'cod_fina_cie'       => $this->input->post('finalidad2_opret', true),
                'cod_tipo'           => $this->input->post('tipoo_opret', true),
                'observacionescie'   => $this->input->post('observacionescie_opret', true),
                'cod_cier'           => $cod_cier,      
                'nombre_cier'        => $nombre_cier,          
                'observacionescier'  => $this->input->post('observacionescier_opret', true),
                'cod_ciers'          => $cod_ciers,
                'nombre_ciers'       => $nombre_ciers,
                'observacionesciers' => $this->input->post('observacionesciers_opret', true),
                'cod_cierr'          => $cod_cierr,
                'nombre_cierr'       => $nombre_cierr,
                'observacionescierr' => $this->input->post('observacionescierr_opret', true),
                'fechaactual'        => $fechaactual,
                'horaactual'         => $horaactual,
                'cod_medi'           => '110010756401',
                'cod_cons'           => $this->input->post('codconsulta_ret'),
                'login_ing'          => $this->input->post('login', true),
                'id_admi'            => $this->input->post('convenios_opret', true),
                'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                //'revolucion'         => 'SI',
                //'nevolucion'         => $this->input->post('version', true),
                'num_retinologia'     =>  $this->input->post('num_retinologia', true),
                'activo'             => 'SI'
            );

            $this->examen_model->insertCieCups($ciecups);

            /////////////// *** inicio de cie +cie cups prequ medi incap
            $cod_cups = $this->input->post('cod_cups_opret');

            if ($cod_cups) {

                for ($i = 0; $i < count($this->input->post('cod_cups_opret')); $i++) {

                    if (!$this->input->post('actoqcupso_opret', true)[$i] && $this->input->post('actoqcupso_opret', true)[$i] === '') {
                        $actoQuirirgico = '';
                    } else {
                        $actoQuirirgico = $this->input->post('actoqcupso_opret', true)[$i];
                    }

                    $cups = [
                        'id_paciente'    => $id_paciente,
                        'cons_examen'    => $n_conexamen,
                        'nconsulta'      => $this->input->post('nconsulta', true),
                        //'tipo_docu'      => $tipo_docu,
                        //'identificacion' => $identificacion,
                        'edad'           => $edad,
                        'ume'            => $ume,
                        'cod_cups'       => $this->input->post('cod_cups_opret')[$i],
                        'nombre_cups'    => $this->input->post('nombre_cups_opret')[$i],
                        'id_finalidad'   => $this->input->post('finalidadcupso_opret', true)[$i],
                        'cod_ambi'       => $this->input->post('ambitocupso_opret', true)[$i],
                        'cod_actoq'      => $actoQuirirgico,
                        'lateralidad'    => $this->input->post('lateralidad_opret', true)[$i],
                        'autorizacion'   => $this->input->post('autorizacion_opret', true)[$i],
                        'valor_cups'     => $this->input->post('valor_cups_opret')[$i],
                        'fechaactual'    => $fechaactual,
                        'horaactual'     => $horaactual,
                        'cod_medi'       => '110010756401',
                        'cod_cons'       => $this->input->post('codconsulta_ret'),
                        'login_ing'      => $this->input->post('login', true),
                        'id_admi'        => $this->input->post('convenios_opret', true),
                        'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                        //'revolucion'     => 'SI',
                        //'nevolucion'     => $this->input->post('version', true)
                        'num_retinologia' => $this->input->post('num_retinologia', true),
                        'activo'             => 'SI'
                    ];
                    $this->examen_model->insertCieCups($cups);
                }

            }

            // mas cie diagnosticos
            $mas_cups = $this->input->post('cod_cierr_mop_opret');
            if ($mas_cups) 
            {
                for ($i = 0; $i < count($this->input->post('cod_cierr_mop_opret')); $i++) 
                {
                    $mciecups = array(
                        'id_paciente'           => $id_paciente,
                        'cons_examen'           => $n_conexamen,
                        'nconsulta'             => $this->input->post('nconsulta', true),
                        //'tipo_docu'          => $tipo_docu,
                        //'identificacion'     => $identificacion,
                        'edad'                  => $edad,
                        'ume'                   => $ume,
                        'cod_causa_dia'         => $this->input->post('causa_opret', true),
                        'cod_fina_cie'          => $this->input->post('finalidad2_opret', true),
                        'cod_tipo'              => $this->input->post('tipoo_opret', true),
                        'fechaactual'           => $fechaactual,
                        'horaactual'            => $horaactual,
                        'cod_medi'              => '110010756401',
                        'cod_cons'              => $this->input->post('codconsulta_ret'),
                        'login_ing'             => $this->input->post('login', true),
                        'id_admi'               => $this->input->post('convenios_opret', true),
                        'cod_persona_atie'      => $this->input->post('cod_persona_atie', true),
                        //'revolucion'         => 'SI',
                        //'nevolucion'         => $this->input->post('version', true),
                        'num_retinologia'       => $this->input->post('num_retinologia', true),
                        'cod_ciemas'            => $this->input->post('cod_cierr_mop_opret', true)[$i],
                        'nombre_ciemas'         => $this->input->post('nombre_cierr_mop_opret', true)[$i],
                        'observaciones_ciemas'  => $this->input->post('observaciones_cierr_mop_opret', true)[$i],
                        'activo'                => 'SI'
                    );
                    $this->examen_model->insertCieCups($mciecups);
                }
            }

            // medicamentos retinologia
            $medicamentos = $this->input->post('id_medicamento_opret');
            if ($medicamentos) 
            {
                for ($i = 0; $i < count($this->input->post('id_medicamento_opret')); $i++) 
                {
                    $m_medicamentos = array(
                        'id_paciente'               =>  $id_paciente,
                        'cons_examen'               =>  $n_conexamen,
                        'fechaactual'               =>  $fechaactual,
                        'horaactual'                =>  $horaactual,
                        'nconsulta'                 =>  $this->input->post('nconsulta', true),
                        'login_ing'                 =>  $this->input->post('login', true),
                        'cod_medi'                  =>  $this->input->post('medico', true),
                        'id_admi'                   =>  $this->input->post('convenios_opret', true),
                        'tipo_historia'             =>  'RETINOLOGIA',
                        'id_medicamento'            =>  $this->input->post('id_medicamento_opret', true)[$i],
                        'nombre_medicamento'        =>  $this->input->post('nombre_medicamento_opret', true)[$i],
                        'concentracion'             =>  $this->input->post('concentracion_opret', true)[$i],
                        'prescripcion'              =>  $this->input->post('prescripcion_opret', true)[$i],
                        'cantidad'                  =>  $this->input->post('cantidad_opret', true)[$i],
                        'tiempo'                    =>  $this->input->post('tiempo_opret', true)[$i],
                        'activo'                    => 'SI'
                    );
                    $this->examen_model->insertMedicamentos($m_medicamentos);
                }
            }

            // paraclinicos
            $cod_para = $this->input->post('cod_para_opret');
            if ($cod_para) 
            {
                for ($i = 0; $i < count($this->input->post('cod_para_opret')); $i++) 
                { 
                    $m_para = array(
                        'id_paciente'        => $this->input->post('id_paciente'),
                        'cons_examen'        => $n_conexamen,
                        'cons_paraclinico'   => $n_conparaclinico,
                        'login_ing'          => $this->input->post('login', true),
                        'cod_para'           => $this->input->post('cod_para_opret', true)[$i],
                        'nombre_para'        => $this->input->post('nombre_para_opret', true)[$i],
                        'activo'             => 'SI'
                    );
                    $this->examen_model->insertPara($m_para, $n_conparaclinico);
                }
            }

            // actualiza agenda color y evento
            $id_agenda          =    $this->input->post('id_agenda_opret', true);
            if($id_agenda === '')
            {

            }else
            {
                $m_agenda   =   array(
                    'estado'    =>   'Atendio',
                    'color'     =>   '#5cb85c'
                );
                $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
            }              
            /////////////// *** cierre de cie +cie cups prequ medi incap 


        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            
            'ultimocontrol'         =>  $fechaactual,
            'version'               =>  $this->input->post('version', true),
            'num_retinologia'        =>  $this->input->post('num_retinologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        

        // CONSULTA DE PACIENTE NUEVO
        //$this->load->library('s3');

        $datos['examen_optret']         =   $this->examen_model->ciexamen_optret($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_retinologia']       =  $this->input->post('num_retinologia', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen;        

        $this->load->view('front_end/historias/hexamen_opt_ret_v', $datos);
    }

    // actualizando historia oftalmologica
    public function actualizaexamen_optret() 
    {
        date_default_timezone_set('America/Bogota');

        $this->load->model('examen_model');
        $n_conexamen        =   $this->input->post('retinologia_abierta', true);
        $n_conparaclinico   =   $this->examen_model->consultaconsecutivo(21);
        $fechan             =   $this->input->post('fechanacimiento', true);

        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($Y, $m, $d) = explode("-", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }
            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        $id_paciente                =   $this->input->post('id_paciente', true);
        //$tipo_docu                  =   $this->input->post('tipo_docu', true);
        //$identificacion             =   $this->input->post('identificacion', true);

       

        $id_paciente                =   $this->input->post('id_paciente', true);
        $tipo_docu                  =   $this->input->post('tipo_docu', true);
        $identificacion             =   $this->input->post('identificacion', true);

        $examen = array(
            'id_paciente'                   =>  $id_paciente,
            'cons_examen'                   =>  $n_conexamen,
            'fechaactual'                   =>  $fechaactual,
            'horaactual'                    =>  $horaactual,
            'nconsulta'                     =>  $this->input->post('nconsulta', true),
            'login_ing'                     =>  $this->input->post('login', true),
            'edad'                          =>  $edad,
            'ume'                           =>  $ume,
            'cod_cons'                      =>  $this->input->post('codconsulta_ret', true),
            'observacionescups'             =>  $this->input->post('observacionescups_opret', true),
            'firmapaci'                     =>  $this->input->post('firmapaciente1_opret'),
            'firmamedi'                     =>  $this->input->post('firmamedico1_opret'),
            'cod_medi'                      =>  $this->input->post('medico_opret', true),
            'num_retinologia'               =>  $this->input->post('num_retinologia', true),
            //'cod_consultorio'               =>  $this->input->post('consultorios_op', true),
            'id_admi'                       =>  $this->input->post('convenios_opret', true),
            'mc_retin'                      =>  $this->input->post('mc_retin', true),
            'ea_retin'                      =>  $this->input->post('ea_retin', true),
            'ap_retin'                      =>  $this->input->post('ap_retin', true),
            'av_retin'                      =>  $this->input->post('av_retin', true),
            'bio_retin'                     =>  $this->input->post('bio_retin', true),
            'moe_retin'                     =>  $this->input->post('moe_retin', true),
            'pio_retin'                     =>  $this->input->post('pio_retin', true),
            'fo_retin'                      =>  $this->input->post('fo_retin', true),
            'reco_retin'                    =>  $this->input->post('reco_retin', true),
            'tipo_co'                       =>  $this->input->post('tipo_co_op_ret', true),
            'abierta'                       =>  'SI',
            'planotratamiento'              =>  $this->input->post('planotratamiento_opret', true),
            'id_agenda'                     =>  $this->input->post('id_agenda_opret', true),
            'incapacidades'                 =>  $this->input->post('incapacidades_opret', true)
        );
        //var_dump($this->input->post());
        //exit();

        $updateExa = $this->examen_model->updateExa_optret($examen, $n_conexamen);

        // colocar inactivo los cie en ciecups
        $m_cie_activo   =    array(
            'activo'    => 'NO');

        $update_cie_activo  =   $this->examen_model->updateCIEActivo($m_cie_activo, $n_conexamen);

        $vcod_cier = $this->input->post('cod_cier_opret', true);

        if (!$vcod_cier || $vcod_cier === '') {
            $cod_cier       =   '';
            $nombre_cier    =   '';
        } else {
            $cod_cier       =   $vcod_cier;
            $nombre_cier    =   $this->input->post('nombre_cier_opret');
        };

        $vcod_ciers = $this->input->post('cod_ciers_opret', true);

        if (!$vcod_ciers || $vcod_ciers === '') {
            $cod_ciers      =   '';
            $nombre_ciers   =   '';
        } else {
            $cod_ciers      =   $vcod_ciers;
            $nombre_ciers   =   $this->input->post('nombre_ciers_opret');
        };

        $vcod_cierr = $this->input->post('cod_cierr_opret', true);

        if (!$vcod_cierr || $vcod_cierr === '') {
            $cod_cierr      =   '';
            $nombre_cierr   =   '';
        } else {
            $cod_cierr      =   $vcod_cierr;
            $nombre_cierr   =   $this->input->post('nombre_cierr_opret');
        };

        $ciecups = array(
            'id_paciente'        => $id_paciente,
            'cons_examen'        => $n_conexamen,
            'nconsulta'          => $this->input->post('nconsulta', true),
            //'tipo_docu'          => $tipo_docu,
            //'identificacion'     => $identificacion,
            'edad'               => $edad,
            'ume'                => $ume,
            'cod_cie'            => $this->input->post('cod_cie_opret'),
            'nombre_cie'         => $this->input->post('nombre_cie_opret'),
            'cod_causa_dia'      => $this->input->post('causa_opret', true),
            'cod_fina_cie'       => $this->input->post('finalidad2_opret', true),
            'cod_tipo'           => $this->input->post('tipoo_opret', true),
            'observacionescie'   => $this->input->post('observacionescie_opret', true),
            'cod_cier'           => $cod_cier,      
            'nombre_cier'        => $nombre_cier,          
            'observacionescier'  => $this->input->post('observacionescier_opret', true),
            'cod_ciers'          => $cod_ciers,
            'nombre_ciers'       => $nombre_ciers,
            'observacionesciers' => $this->input->post('observacionesciers_opret', true),
            'cod_cierr'          => $cod_cierr,
            'nombre_cierr'       => $nombre_cierr,
            'observacionescierr' => $this->input->post('observacionescierr_opret', true),
            'fechaactual'        => $fechaactual,
            'horaactual'         => $horaactual,
            'cod_medi'           => '110010756401',
            'cod_cons'           => $this->input->post('codconsulta_ret'),
            'login_ing'          => $this->input->post('login', true),
            'id_admi'            => $this->input->post('convenios_opret', true),
            'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
            //'revolucion'         => 'SI',
            //'nevolucion'         => $this->input->post('version', true),
            'num_retinologia'     =>  $this->input->post('num_retinologia', true),
            'activo'             => 'SI'
        );

        $this->examen_model->insertCieCups($ciecups);

        $cod_cups = $this->input->post('cod_cups_opret');

        if ($cod_cups) {

            for ($i = 0; $i < count($this->input->post('cod_cups_opret')); $i++) {

                if (!$this->input->post('actoqcupso_opret', true)[$i] && $this->input->post('actoqcupso_opret', true)[$i] === '') {
                    $actoQuirirgico = '';
                } else {
                    $actoQuirirgico = $this->input->post('actoqcupso_opret', true)[$i];
                }

                $cups = [
                    'id_paciente'    => $id_paciente,
                    'cons_examen'    => $n_conexamen,
                    'nconsulta'      => $this->input->post('nconsulta', true),
                    //'tipo_docu'      => $tipo_docu,
                    //'identificacion' => $identificacion,
                    'edad'           => $edad,
                    'ume'            => $ume,
                    'cod_cups'       => $this->input->post('cod_cups_opret')[$i],
                    'nombre_cups'    => $this->input->post('nombre_cups_opret')[$i],
                    'id_finalidad'   => $this->input->post('finalidadcupso_opret', true)[$i],
                    'cod_ambi'       => $this->input->post('ambitocupso_opret', true)[$i],
                    'cod_actoq'      => $actoQuirirgico,
                    'lateralidad'    => $this->input->post('lateralidad_opret', true)[$i],
                    'autorizacion'   => $this->input->post('autorizacion_opret', true)[$i],
                    'valor_cups'     => $this->input->post('valor_cups_opret')[$i],
                    'fechaactual'    => $fechaactual,
                    'horaactual'     => $horaactual,
                    'cod_medi'       => '110010756401',
                    'cod_cons'       => $this->input->post('codconsulta_ret'),
                    'login_ing'      => $this->input->post('login', true),
                    'id_admi'        => $this->input->post('convenios_opret', true),
                    'cod_persona_atie'   => $this->input->post('cod_persona_atie', true),
                    //'revolucion'     => 'SI',
                    //'nevolucion'     => $this->input->post('version', true)
                    'num_retinologia' => $this->input->post('num_retinologia', true),
                    'activo'             => 'SI'
                ];
                $this->examen_model->insertCieCups($cups);
            }

        }

        // mas cie diagnosticos
        $mas_cups = $this->input->post('cod_cierr_mop_opret');
        if ($mas_cups) 
        {
            for ($i = 0; $i < count($this->input->post('cod_cierr_mop_opret')); $i++) 
            {
                $mciecups = array(
                    'id_paciente'           => $id_paciente,
                    'cons_examen'           => $n_conexamen,
                    'nconsulta'             => $this->input->post('nconsulta', true),
                    //'tipo_docu'          => $tipo_docu,
                    //'identificacion'     => $identificacion,
                    'edad'                  => $edad,
                    'ume'                   => $ume,
                    'cod_causa_dia'         => $this->input->post('causa_opret', true),
                    'cod_fina_cie'          => $this->input->post('finalidad2_opret', true),
                    'cod_tipo'              => $this->input->post('tipoo_opret', true),
                    'fechaactual'           => $fechaactual,
                    'horaactual'            => $horaactual,
                    'cod_medi'              => '110010756401',
                    'cod_cons'              => $this->input->post('codconsulta_ret'),
                    'login_ing'             => $this->input->post('login', true),
                    'id_admi'               => $this->input->post('convenios_opret', true),
                    'cod_persona_atie'      => $this->input->post('cod_persona_atie', true),
                    //'revolucion'         => 'SI',
                    //'nevolucion'         => $this->input->post('version', true),
                    'num_retinologia'       => $this->input->post('num_retinologia', true),
                    'cod_ciemas'            => $this->input->post('cod_cierr_mop_opret', true)[$i],
                    'nombre_ciemas'         => $this->input->post('nombre_cierr_mop_opret', true)[$i],
                    'observaciones_ciemas'  => $this->input->post('observaciones_cierr_mop_opret', true)[$i],
                    'activo'                => 'SI'
                );
                $this->examen_model->insertCieCups($mciecups);
            }
        }

        // colocar inactivo los medicamentos
        $m_med_activo   =    array(
            'activo'    => 'NO');

        $update_med_activo  =   $this->examen_model->updateMEDActivo($m_med_activo, $n_conexamen);
        
        // medicamentos retinologia
        $medicamentos = $this->input->post('id_medicamento_opret');
        if ($medicamentos) 
        {
            for ($i = 0; $i < count($this->input->post('id_medicamento_opret')); $i++) 
            {
                $m_medicamentos = array(
                    'id_paciente'               =>  $id_paciente,
                    'cons_examen'               =>  $n_conexamen,
                    'fechaactual'               =>  $fechaactual,
                    'horaactual'                =>  $horaactual,
                    'nconsulta'                 =>  $this->input->post('nconsulta', true),
                    'login_ing'                 =>  $this->input->post('login', true),
                    'cod_medi'                  =>  $this->input->post('medico', true),
                    'id_admi'                   =>  $this->input->post('convenios_opret', true),
                    'tipo_historia'             =>  'RETINOLOGIA',
                    'id_medicamento'            =>  $this->input->post('id_medicamento_opret', true)[$i],
                    'nombre_medicamento'        =>  $this->input->post('nombre_medicamento_opret', true)[$i],
                    'concentracion'             =>  $this->input->post('concentracion_opret', true)[$i],
                    'prescripcion'              =>  $this->input->post('prescripcion_opret', true)[$i],
                    'cantidad'                  =>  $this->input->post('cantidad_opret', true)[$i],
                    'tiempo'                    =>  $this->input->post('tiempo_opret', true)[$i],
                    'activo'                    => 'SI'
                );
                $this->examen_model->insertMedicamentos($m_medicamentos);
            }
        }

        // paraclinicos
        $m_para_activo   =    array(
            'activo'    => 'NO');

        $update_para_activo  =   $this->examen_model->updatePARAActivo($m_para_activo, $n_conexamen);

        // paraclinicos
        $cod_para = $this->input->post('cod_para_opret');
        if ($cod_para) 
        {
            for ($i = 0; $i < count($this->input->post('cod_para_opret')); $i++) 
            { 
                $m_para = array(
                    'id_paciente'        => $this->input->post('id_paciente'),
                    'cons_examen'        => $n_conexamen,
                    'cons_paraclinico'   => $n_conparaclinico,
                    'login_ing'          => $this->input->post('login', true),
                    'cod_para'           => $this->input->post('cod_para_opret', true)[$i],
                    'nombre_para'        => $this->input->post('nombre_para_opret', true)[$i],
                    'activo'             => 'SI'
                );
                $this->examen_model->insertPara($m_para, $n_conparaclinico);
            }
        }

        // ACTUALIZAR ENCABEZADO
        $datencabezadogn = array(            
            'ultimocontrol'         =>  $fechaactual,
            //'version'               =>  $this->input->post('version', true),
            //'num_oftalmologia'      =>  $this->input->post('num_oftalmologia', true),
            );
        $updateEncabezadoGN =   $this->examen_model->updateEncabezadoGN($datencabezadogn, $id_paciente);

        // actualiza agenda color y evento
        /*$id_agenda          =    $this->input->post('id_agenda', true);
        if($id_agenda === '')
        {

        }else
        {
            $m_agenda   =   array(
                'estado'    =>   'Atendio',
                'color'     =>   '#5cb85c'
            );
            $update_agenda      =   $this->examen_model->update_agenda($id_agenda, $m_agenda);
        }*/

        // CONSULTA DE PACIENTE NUEVO

        

        $datos['examen_optret']         =   $this->examen_model->ciexamen_optret($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_retinologia']       =  $this->input->post('num_retinologia', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   $identificacion;
        $datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        $datos['cons_examen']           =   $n_conexamen;        

        $this->load->view('front_end/historias/hexamen_opt_ret_v', $datos);
    }

    public function rep_historia_optret()
    {
        $this->load->model('examen_model');
        //$this->load->library('s3');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('n_conexamen');

        $examen             =   $this->examen_model->ciexamen_optret($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        //$ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        

        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // PRESTADOR
        //$prestador          =   $this->examen_model->prestador();
        
        date_default_timezone_set('America/Bogota');

        $datos['fecha_impresion'] = date("Y-m-d");
        $datos['hora_impresion']  = date("H:i:s");
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto     =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $nombre_admi    =   $pac->nombre_admi;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        foreach($examen as $exa)
        {
            $fecha_consulta  =   $exa['fechaactual'];
            $hora_consulta   =   $exa['horaactual'];
            $medico          =   $exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi'];
        }

        
        /*$imgextension   =   substr($imagenfoto, -3);
        $contarpunto    =   substr_count($imagenfoto, ".");

        $porciones  =   explode(".", $imagenfoto);
        $extfoto    =   $porciones[$contarpunto]; 
        //echo $extfoto;

        if($imagenfoto)
        {            
            $datos['imagenfoto']  =   $this->pdf->Image(S3::getAuthenticatedURL('histocol', $imagenfoto, 600), 170,5, 26, 26, $extfoto);
        }else 
        {
            $datos['imagenfoto']  =   '';
        }*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 

        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        /////
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();

        foreach($examen as $exa)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Examen Retinología'),0,0,'L');
            
            // MEDICO, TIPO CONSULTA
            $this->pdf->SetX(55);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['primer_nombre_medi'].' '.$exa['segundo_nombre_medi'].' '.$exa['primer_apellido_medi'].' '.$exa['segundo_apellido_medi']),0,0,'L');
            $this->pdf->SetX(120);
            
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(25,4,utf8_decode('Número Control:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(40,4,utf8_decode($exa['num_retinologia']),0,0,'L');
            $this->pdf->Ln();

            $this->pdf->SetDrawColor(0,0,0);
            $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());
            $this->pdf->Ln();

            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(35,4,utf8_decode($exa['nombre_listap']),0,0,'L');
            $this->pdf->Ln();            


            if($exa['mc_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('MC:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['mc_retin']),0,'J');
            }

            if($exa['ea_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('EA:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['ea_retin']),0,'J');
            }

            if($exa['ap_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('AP:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['ap_retin']),0,'J');
            }


            if($exa['av_retin'] || $exa['bio_retin'] || $exa['moe_retin'] || $exa['pio_retin'] || $exa['fo_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Examen'),0,0,'L');    
                $this->pdf->Ln();

                if($exa['av_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('AV:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['av_retin']),0,'J');
                }

                if($exa['bio_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('BIO:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['bio_retin']),0,'J');
                }

                if($exa['moe_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('BIO:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['moe_retin']),0,'J');
                }

                if($exa['pio_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('BIO:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['pio_retin']),0,'J');
                }

                if($exa['fo_retin'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('BIO:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($exa['fo_retin']),0,'J');
                }
            }

            if($exa['reco_retin'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Recomendaciones:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['reco_retin']),0,'J');
            }
            
            // DIAGNOSTICOS
            if($cie)
            {
                foreach($cie as $ci)
                {
                    $this->pdf->Ln();
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                    $this->pdf->Ln();
                    $this->pdf->SetDrawColor(0,0,0);
                    $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());   
                    
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','BU',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                    if($ci['observacionescie'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');    
                    }
                    
                    if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                    }

                    if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                    if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
                }
            }

            // MAS DIAGNOSTICOS
            if($ciemas)
            {
                $this->pdf->Ln(5);
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
                $this->pdf->Ln(5);
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(90,90));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($ciemas)
                {
                    foreach ($ciemas as $cmas) 
                    {   
                        $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                        $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                        
                        
                        $this->pdf->Row(array($cod_ciemas, $cod_observ));
                    }
                }    
            }

            // ordenes medicas
            if($cups)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('ORDENES MÉDICAS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();
                
                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(160, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(160,20));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($cups)
                {
                    foreach ($cups as $row) 
                    {   
                        $cod_cups            =   utf8_decode($row['cod_cups'].'-'.$row['nombre_cups']);
                        $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                        
                        
                        $this->pdf->Row(array($cod_cups, $nombre_lateralidad));
                    }
                }    
            }

            // observaciones cups
            if($exa['observacionescups'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['observacionescups']),0,'J');
                $this->pdf->Ln();
            }

            // plan de tratamiento
            if($exa['planotratamiento'])
            {
                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Plan o Tratamiento:'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetX(45);
                $this->pdf->MultiCell(0,4,utf8_decode($exa['planotratamiento']),0,'J');
                $this->pdf->Ln();   
            }

            // medicamentos
            if($medicamentos)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('MEDICAMENTOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
                $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
                $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
                $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
                $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->SetWidths(array(68,38,38,15,30));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L','L','L','L'));

                if($medicamentos)
                {
                    foreach ($medicamentos as $med) 
                    {   
                        $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                        $concentracion              =   utf8_decode($med['concentracion']);
                        $prescripcion               =   utf8_decode($med['prescripcion']);
                        $cantidad                   =   utf8_decode($med['cantidad']);
                        $tiempo                     =   utf8_decode($med['tiempo']);
                        
                        $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                    }
                }    
            }

            // paraclinicos
            if($paraclinicos)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('PREQUIRURGICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                $this->pdf->Ln();

                //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
                $this->pdf->SetFont('Arial','B',7);
                $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
                $this->pdf->Ln();
                // DETALLES
                $this->pdf->SetFont('Arial','',7);
                $this->pdf->SetWidths(array(150));
                srand(microtime()*1000000);
                $this->pdf->SetAligns(array('L','L'));

                if($paraclinicos)
                {
                    foreach ($paraclinicos as $para) 
                    {   
                        $nombre_para            =   utf8_decode($para['nombre_para']);
                        
                        
                        $this->pdf->Row(array($nombre_para));
                    }
                }    
            }
            

            $this->pdf->Ln();  

            // FIRMAS X EVOLUCION
            if($exa['firmamedi'])
            {
                $this->pdf->SetX(80);
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
                $this->pdf->Image('data://image/png;base64,'.$exa['firmamedi'],20, $this->pdf->GetY(), 50, 25, 'png');
            }else
            {
            }

            if($exa['firmapaci'])
            {
                
                //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
                $this->pdf->Image('data://image/png;base64,'.$exa['firmapaci'],110, $this->pdf->GetY(), 50, 25, 'png');
            }
            else
            {
            }

            $this->pdf->ln(20);

            // NOMBRES PACIENTE Y MEDICO EN FIRMAS
            $this->pdf->SetX(25);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

            $this->pdf->SetX(110);
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);
            
            
        }

        $this->pdf->Ln();
        $this->pdf->Output("Reporte historia .pdf", 'I');
    }

    // retinologia reporte medicamentos
    public function rep_medicamentos_opret()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_retinologia   =   $this->input->post('num_retinologia');

        $examen             =   $this->examen_model->ciexamen_opret($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);

        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $medicamentos       =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);
        
        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }
        }

        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           =   $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }            
        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        
        
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(0,4,utf8_decode('FORMULACIÓN DE MEDICAMENTOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/

        //$this->pdf->Ln(3);

        /*$this->pdf->SetDrawColor(215,215,215);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);


        // FALTA ACUDIENTE

        // MEDICO Y TIPO CONSULTA
        /*$this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($tipo),0,0,'L');
        $this->pdf->Ln();

        // tipo de consulta oftalmologia.consulta y control
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','BU',7);
        $this->pdf->Cell(15,4,utf8_decode('TIPO DE CONSULTA: OFTALMOLOGÍA'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(20,4,utf8_decode('Tipo consulta'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(60,4,utf8_decode($tipoconsulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(20,4,utf8_decode('Número Control:'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(40,4,utf8_decode($num_oftalmologia),0,0,'L');
        $this->pdf->Ln(); */

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }

        if($medicamentos)
        {
            //$this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Medicamentos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(68, 5, utf8_decode('Principio Activo + Presentación'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Concentración'), 1, 0, 'C', 0);
            $this->pdf->Cell(38, 5, utf8_decode('Dosis / Día'), 1, 0, 'C', 0);
            $this->pdf->Cell(15, 5, utf8_decode('Cantidad'), 1, 0, 'C', 0);
            $this->pdf->Cell(30, 5, utf8_decode('Tiempo/Admin.'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(68,38,38,15,30));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L','L','L','L'));

            if($medicamentos)
            {
                foreach ($medicamentos as $med) 
                {   
                    $nombre_medicamento         =   utf8_decode($med['nombre_medicamento']);
                    $concentracion              =   utf8_decode($med['concentracion']);
                    $prescripcion               =   utf8_decode($med['prescripcion']);
                    $cantidad                   =   utf8_decode($med['cantidad']);
                    $tiempo                     =   utf8_decode($med['tiempo']);
                    
                    $this->pdf->Row(array($nombre_medicamento, $concentracion, $prescripcion, $cantidad,$tiempo));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            $ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,110, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            $ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,20, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }
        
        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);


        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte medicamentos .pdf", 'I');

    }

    // retinologia reporte ordenes medicas
    public function rep_ordenes_medicas_opret()
    {
        $this->load->model('examen_model');
        
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_retinologia    =   $this->input->post('num_retinologia');

        $examen             =   $this->examen_model->ciexamen_opret($id_paciente,$n_conexamen);
        $cups               =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        
        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }
        
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         =   $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;

            $tipo                           =   $exa->nombre_listap;
            $tipoconsulta                   =   $exa->nombre_cons;
            $firmapaci                      =   $exa->firmapaci;
            $firmamedi                      =   $exa->firmamedi;

            $observacionescups              =   $exa->observacionescups;
            $nombre_admi                    =   $exa->nombre_admi;
            $nombre_listap                  =   $exa->nombre_listap;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        //for($num_linea=1;$num_linea<=185;$num_linea++)
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
        
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('ORDEN MÉDICA'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(2);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                    if($ci['observacionescier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                    if($ci['observacionesciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                    }
                }

                if($ci['cod_ciers'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                    if($ci['observacionescierr'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                    }
                }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }
        $this->pdf->Ln();

        // CUPS
        if($cups)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15, 5, utf8_decode('CUPS'), 1, 0, 'C', 0);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(15,150,20));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($cups)
            {
                foreach ($cups as $row) 
                {   
                    $cod_cups            =   utf8_decode($row['cod_cups']);
                    $descripcion         =   utf8_decode($row['nombre_cups']);
                    $nombre_lateralidad  =   utf8_decode($row['nombre_lateralidad']);
                    
                    
                    $this->pdf->Row(array($cod_cups, $descripcion, $nombre_lateralidad));
                }
            }    
        }

        if($observacionescups)
        {
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Observaciones plan de tratamiento :'),0,0,'L');
            $this->pdf->Ln();
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetX(45);
            $this->pdf->MultiCell(0,4,utf8_decode($observacionescups),0,'J');
            //$this->pdf->Ln(3);
        }
        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($firmapaci)
        {
          $this->pdf->Image('data://image/png;base64,'.$firmapaci,30, $this->pdf->GetY(), 50, 25, 'png');
            
        }
        //$vfirmamed              =   (($firmamedi) ? $this->pdf->Image(S3::getAuthenticatedURL('histocol', $firmamedi, 600), 90, $this->pdf->GetY(), 30, 30, 'png'):"");
        if($c_firma_medico)
        {
            $this->pdf->Image('data://image/png;base64,'.$firmamedi,115, $this->pdf->GetY(), 30, 20, 'png');
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->SetX(110);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte Orden Medica .pdf", 'I');
    }

    // retinologia reporte prequirurgicos
    public function rep_prequirurgico_opret()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_retinologia    =   $this->input->post('num_retinologia');

        $examen             =   $this->examen_model->ciexamen_opret($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $paraclinicos       =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            $nombre_admi                    =   $exa->nombre_admi;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('PREQUIRURGICOS'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();         
        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                        
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // paraclinicos
        if($paraclinicos)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(150, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->SetWidths(array(150));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($paraclinicos)
            {
                foreach ($paraclinicos as $para) 
                {   
                    $nombre_para            =   utf8_decode($para['nombre_para']);
                    
                    
                    $this->pdf->Row(array($nombre_para));
                }
            }    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }
        
        $this->pdf->ln(20);
        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte prequirurgico.pdf", 'I');
    }

    // retinologia reporte de incapacidades
    public function rep_incapacidades_opret()
    {
        $this->load->model('examen_model');
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $id_paciente        =   $this->input->post('id_paciente');
        $n_conexamen        =   $this->input->post('cons_examen');
        $nconsulta          =   $this->input->post('nconsulta');
        $num_retinologia    =   $this->input->post('num_retinologia');

        $examen             =   $this->examen_model->ciexamen_opret($id_paciente,$n_conexamen);
        $cie                =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $ciemas             =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);

        // CONSULTA BASE DE DATOS PACIENTE
        $paciente           =   $this->examen_model->cipaciente_v($id_paciente);

        // CONSULTA DE ANTECEDENTES
        foreach($paciente as $pac)
        {
            $pacnombre      =   $pac->primer_nombre.' '.$pac->segundo_nombre.' '.$pac->primer_apellido.' '.$pac->segundo_apellido;
            $pacdireccion   =   $pac->direccion_paci;
            $pactelefono    =   $pac->telefono_paciente;
            $paccelular     =   $pac->celular_paciente;
            $pacemail       =   $pac->email_paciente;
            $idhistoria     =   $pac->id_paciente;
            $fechaingreso   =   $pac->fechaingreso;
            $horaingreso    =   $pac->horaingreso;
            $imagenfoto     =   $pac->imagenfoto;
            $imagenfoto              =   $pac->imagenfoto;
            $tipo_docu      =   $pac->tipo_docu;
            $identificacion =   $pac->identificacion;
            $nombre_sexo    =   $pac->nombre_sexo;
            $fnacimiento    =   $pac->fecha_de_nacimiento;
            $nombre_pais    =   $pac->nombre_pais;
            $nombre_depa    =   $pac->nombre_depa;
            $nombre_muni    =   $pac->nombre_muni;
            $barrio         =   $pac->barrio;
            $ecivil         =   $pac->nombre_estado_civi;
            $gsanguineo     =   $pac->cod_grupo_sang;
            $celularp       =   $pac->celular_paciente;
            $telfijo        =   $pac->telefono_paciente;
            $direccionp     =   $pac->direccion_paci;
            $zresidencia    =   $pac->nombre_zona_resi;
            $emailp         =   $pac->email_paciente;
            $eps            =   $pac->eps;
            $tipousuario    =   $pac->nombre_tipo_usua;
            $ocupacion      =   $pac->ocupacion;
            $referidopor    =   $pac->referidopor;
            $facebook       =   $pac->facebook;
            $religion       =   $pac->religion;

            $nombre_acom    =   $pac->nombre_acom;
            $telefono_acom  =   $pac->telefono_acom;
            $celular_acom   =   $pac->telefono_acom;
            $parentescoacom =   $pac->parentescoacom;

            $nombre_acu     =   $pac->nombre_acu;
            $telefono_acu   =   $pac->telefono_acu;
            $celular_acu    =   $pac->celular_acu;
            $parentescoacu  =   $pac->parentescoacu;

            $fecha_naci    =   $pac->fecha_de_nacimiento;
            $dia=date("j");
            $mes=date("n");
            $anno=date("Y");
            $dia_nac=substr($fecha_naci, 8, 2);
            $mes_nac=substr($fecha_naci, 5, 2);
            $anno_nac=substr($fecha_naci, 0, 4);
            if($mes_nac>$mes){
            $calc_edad= $anno-$anno_nac-1;
            }else{
                if($mes==$mes_nac AND $dia_nac>$dia)
                {
                    $calc_edad= $anno-$anno_nac-1;
                }else
                {
                    $calc_edad= $anno-$anno_nac;
                }
            }

        }

        // EXAMEN
        foreach($examen as $exa)
        {
            $fecha_consulta                 =   $exa->fechaactual;
            $hora_consulta                  =   $exa->horaactual;
            $cod_medi                       =   $exa->cod_medi;                  
            $medico                         = $exa->primer_nombre_medi.' '.$exa->segundo_nombre_medi.' '.$exa->primer_apellido_medi.' '.$exa->segundo_apellido_medi;
            $nombre_listap                           = $exa->nombre_listap;
            
            $nombre_admi                    =   $exa->nombre_admi;
            

            $incapacidades                  =   $exa->incapacidades;
        }

        // consulta de firma de medico
        $cons_medico        =   $this->examen_model->cons_medico($cod_medi);
        foreach($cons_medico as $cmed)
        {
            $c_firma_medico     =   $cmed['firmamedi'];
        }  

        //$this->pdf = new PDF_MC_Table();
        /*$this->pdf = new PDF_MC_Table('L', 'mm', array(216,140));
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);*/
        
        $this->pdf = new PDF_MC_Table();
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->SetX(5);
        $this->pdf->Ln(3); 
                    
        $this->pdf->SetX(5);
        $this->pdf->Ln(3);
        // logos
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,10,10,56,18);
        $this->pdf->Ln(15);
        // DATOS DEL ENCABEZADO

        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(0,4,utf8_decode('INCAPACIDAD'),0,0,'C');
        $this->pdf->Ln(2);
        
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(15,4,utf8_decode('DATOS DEL PACIENTE'),0,0,'L');
        $this->pdf->Ln();
        $this->pdf->SetDrawColor(0,0,0);
        $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        

        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Historia'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($idhistoria),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Fecha:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(15,4,utf8_decode($fecha_consulta),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Hora:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(10,4,utf8_decode($hora_consulta),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(26,4,utf8_decode('TD./Identificación:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($tipo_docu.' / '.$identificacion),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Paciente:'),0,0,'L');
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(35,4,utf8_decode($pacnombre),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('F.Nacimiento:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(28,4,utf8_decode($fnacimiento." / ".$calc_edad." años"),0,0,'L');
        
        $this->pdf->Ln(3);
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Sexo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_sexo),0,0,'L');
        $this->pdf->SetX(55);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(8,4,utf8_decode('País:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_pais),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('Dpto:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($nombre_depa),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('Ciud./Local.:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(35,4,utf8_decode($nombre_muni),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->Ln(3);
        

        $this->pdf->SetX(10);
        if($celularp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Celular:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($celularp),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telfijo)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Tel.Fijo:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telfijo),0,0,'L');    
        }
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(11,4,utf8_decode('E.Civil:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($ecivil),0,0,'L');
        $this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(18,4,utf8_decode('G.Sanguíneo:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($gsanguineo),0,0,'L');
        $this->pdf->Ln(3);

        $this->pdf->SetX(10);
        if($nombre_admi)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('EPS:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(150,4,utf8_decode($nombre_admi),0,0,'L');
        }

        if($direccionp)
        {
            $this->pdf->SetX(95);
            $this->pdf->SetFont('Arial','B',6);
            $this->pdf->Cell(11,4,utf8_decode('Dirección:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($direccionp),0,0,'L');
        }

        /*if($barrio)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Barrio:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($barrio),0,0,'L');    
        }
        
        $this->pdf->Ln();*/

        
        /*$this->pdf->SetX(135);
        $this->pdf->SetFont('Arial','B',7);
        $this->pdf->Cell(20,4,utf8_decode('Zona/Res:'),0,0,'L');
        $this->pdf->SetFont('Arial','',7);
        $this->pdf->Cell(45,4,utf8_decode($zresidencia),0,0,'L');
        $this->pdf->Ln();

        /////////
        $this->pdf->SetX(10);
        if($emailp)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Email:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($emailp),0,0,'L');
        }
        $this->pdf->SetX(55);
        /*if($tipousuario)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Usua:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($tipousuario),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($ocupacion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Ocupación:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($ocupacion),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($referidopor)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Referido por:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($referidopor),0,0,'L');
        }
        $this->pdf->Ln();

        /////////
        /*$this->pdf->SetX(10);
        if($facebook)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Facebook:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($facebook),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($religion)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Religión:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($religion),0,0,'L');    
        }
        if($facebook || $religion)
        {
            $this->pdf->Ln();
        }

        // ACOMPAÑANTE
        $this->pdf->SetX(10);
        if($nombre_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(15,4,utf8_decode('Acompañante:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acom),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acomp:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acom),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acom:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acom),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacom)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacom),0,0,'L');
        }
        if($nombre_acom || $telefono_acom || $celular_acom || $parentescoacom)
        {
            $this->pdf->Ln();
        }

        // ACUDIENTE
        $this->pdf->SetX(10);
        if($nombre_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(18,4,utf8_decode('Acudiente:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(35,4,utf8_decode($nombre_acu),0,0,'L');
        }
        $this->pdf->SetX(55);
        if($telefono_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('T/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(28,4,utf8_decode($telefono_acu),0,0,'L');    
        }
        $this->pdf->SetX(95);
        if($celular_acu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(11,4,utf8_decode('Celular/Acud:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($celular_acu),0,0,'L');
        }
        $this->pdf->SetX(135);
        if($parentescoacu)
        {
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(20,4,utf8_decode('Parentesco:'),0,0,'L');
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->Cell(45,4,utf8_decode($parentescoacu),0,0,'L');
        }

        if($nombre_acu || $telefono_acu || $celular_acu || $parentescoacu)
        {
            $this->pdf->Ln();
        }*/
        $this->pdf->Ln();
        $this->pdf->SetX(10);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(15,4,utf8_decode('Médico'),0,0,'L');
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($medico),0,0,'L');

        $this->pdf->SetX(80);
        $this->pdf->SetFont('Arial','B',8);
        $this->pdf->Cell(10,4,utf8_decode('Tipo:'),0,0,'L');
        $this->pdf->SetX(95);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(35,4,utf8_decode($nombre_listap),0,0,'L');
        $this->pdf->Ln();        

        // DIAGNOSTICOS
        if($cie)
        {
            foreach($cie as $ci)
            {
                $this->pdf->Ln();
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('DIAGNÓSTICOS'),0,0,'L');
                $this->pdf->Ln();
                $this->pdf->SetDrawColor(0,0,0);
                $this->pdf->Line(10, $this->pdf->GetY() , 200, $this->pdf->GetY());        
                //$this->pdf->Ln(3);

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','BU',8);
                $this->pdf->Cell(15,4,utf8_decode('Diagnóstico Principal:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cie'].'-'.$ci['nombre_cie']),0,'J');

                /*$this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Causa:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_causa_dia']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Finalidad:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_fina']),0,'J');

                $this->pdf->SetX(10);
                $this->pdf->SetFont('Arial','B',8);
                $this->pdf->Cell(15,4,utf8_decode('Tipo:'),0,0,'L');
                $this->pdf->SetX(45);
                $this->pdf->SetFont('Arial','',8);
                $this->pdf->MultiCell(0,4,utf8_decode($ci['nombre_tipo']),0,'J');*/

                if($ci['observacionescie'])
                {
                    $this->pdf->SetX(10);
                    $this->pdf->SetFont('Arial','B',8);
                    $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                    $this->pdf->SetX(45);
                    $this->pdf->SetFont('Arial','',8);
                    $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescie']),0,'J');
                }

                if($ci['cod_cier'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 2:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cier'].'-'.$ci['nombre_cier']),0,'J');

                        if($ci['observacionescier'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescier']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico 3:'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_ciers'].'-'.$ci['nombre_ciers']),0,'J');

                        if($ci['observacionesciers'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionesciers']),0,'J');    
                        }
                    }

                if($ci['cod_ciers'])
                    {
                        $this->pdf->SetX(10);
                        $this->pdf->SetFont('Arial','B',8);
                        $this->pdf->Cell(15,4,utf8_decode('Diagnóstico :'),0,0,'L');
                        $this->pdf->SetX(45);
                        $this->pdf->SetFont('Arial','',8);
                        $this->pdf->MultiCell(0,4,utf8_decode($ci['cod_cierr'].'-'.$ci['nombre_cierr']),0,'J');

                        if($ci['observacionescierr'])
                        {
                            $this->pdf->SetX(10);
                            $this->pdf->SetFont('Arial','B',8);
                            $this->pdf->Cell(15,4,utf8_decode('Observaciones:'),0,0,'L');
                            $this->pdf->SetX(45);
                            $this->pdf->SetFont('Arial','',8);
                            $this->pdf->MultiCell(0,4,utf8_decode($ci['observacionescierr']),0,'J');    
                        }
                    }
            }
        }

        // MAS DIAGNOSTICOS
        if($ciemas)
        {
            $this->pdf->Ln(5);
            $this->pdf->SetX(10);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(15,4,utf8_decode('Más Diagnósticos:'),0,0,'L');
            $this->pdf->Ln(5);
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',8);
            $this->pdf->Cell(90, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Cell(90, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',8);
            $this->pdf->SetWidths(array(90,90));
            srand(microtime()*1000000);
            $this->pdf->SetAligns(array('L','L'));

            if($ciemas)
            {
                foreach ($ciemas as $cmas) 
                {   
                    $cod_ciemas            =   utf8_decode($cmas['cod_ciemas'].'-'.$cmas['nombre_ciemas']);
                    $cod_observ            =   utf8_decode($cmas['observaciones_ciemas']);
                    
                    
                    $this->pdf->Row(array($cod_ciemas, $cod_observ));
                }
            }    
        }


        // incapacidades
        if($incapacidades)
        {
            //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
            $this->pdf->SetFont('Arial','B',7);
            $this->pdf->Cell(0, 5, utf8_decode('Descripción'), 1, 0, 'C', 0);
            $this->pdf->Ln();
            // DETALLES
            $this->pdf->SetFont('Arial','',7);
            $this->pdf->MultiCell(0,4,utf8_decode($incapacidades),1,'J');    
        }

        $this->pdf->Ln(1);
        $this->pdf->SetX(10);

        // FIRMAS
        
        
        if($exa->firmamedi)
        {
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma profesional'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmamedi,20, $this->pdf->GetY(), 50, 25, 'png');
           
        }else
        {
        }

        if($exa->firmapaci)
        {
            $this->pdf->SetX(80);
            //$ffirmamedi =   $this->pdf->Cell(25,5,utf8_decode('Firma paciente'),0,0,'C'); 
            $this->pdf->Image('data://image/png;base64,'.$exa->firmapaci,110, $this->pdf->GetY(), 50, 25, 'png');
        }
        else
        {
        }

        $this->pdf->ln(20);
        

        // NOMBRES PACIENTE Y MEDICO EN FIRMAS
        $this->pdf->SetX(25);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Dr.(a): '. $medico), 0, 0, 'C', 0);

        $this->pdf->SetX(90);
        $this->pdf->SetFont('Arial','',8);
        $this->pdf->Cell(42, 5, utf8_decode('Pac: '. $pacnombre), 0, 0, 'C', 0);

        $this->pdf->Output("Reporte incapacidad.pdf", 'I');
    }
    
    // optometria
    // cerrar historia clinica
    public function cerrar_examen_op() 
    {
        $this->load->model('examen_model');
        $n_conexamen            =   $this->input->post('optometria_abierta', true);
        $id_paciente            =   $this->input->post('id_paciente', true);

        $m_cerrar_opt           =   array(
            'abierta'           =>  'NO');

        $cerrar_optometria      =   $this->examen_model->cerrar_optometria($m_cerrar_opt, $n_conexamen);

        // CONSULTA DE PACIENTE NUEVO
        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['id_paciente']           =   $id_paciente;
        //$datos['identificacion']        =   $identificacion;
        //$datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        //$datos['n_conparaclinico']      =   $n_conparaclinico;

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    // retinologia
    // cerrar historia clinica
    public function cerrar_examen_opret() 
    {
        $this->load->model('examen_model');
        $n_conexamen            =   $this->input->post('retinologia_abierta', true);
        $id_paciente            =   $this->input->post('id_paciente', true);

        $m_cerrar_optret           =   array(
            'abierta'           =>  'NO');

        $cerrar_optometria      =   $this->examen_model->cerrar_retinologia($m_cerrar_optret, $n_conexamen);

        // CONSULTA DE PACIENTE NUEVO
        $datos['examen']                =   $this->examen_model->ciexamen($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['id_paciente']           =   $id_paciente;
        //$datos['identificacion']        =   $identificacion;
        //$datos['tipo_identificacion']   =   $tipo_docu;
        $datos['n_conexamen']           =   $n_conexamen;
        //$datos['n_conparaclinico']      =   $n_conparaclinico;

        $this->load->view('front_end/historias/hexamen_r_v', $datos);
    }

    /// retinologia historico
    public function consulta_hist_ret()
    {
        $this->load->model('examen_model');
        //$this->load->library('imagenes');

        $id_paciente        =   $this->input->post('bd_id_paciente_ret', true);
        $n_conexamen        =   $this->input->post('bd_cons_examen_ret', true);



        //$this->load->library('s3');

        $datos['examen_optret']         =   $this->examen_model->ciexamen_optret($id_paciente,$n_conexamen);
        $datos['cie']                   =   $this->examen_model->ciexamencie($id_paciente,$n_conexamen);
        $datos['cups']                  =   $this->examen_model->cicups($id_paciente,$n_conexamen);
        

        $datos['ciemas']                =   $this->examen_model->ciexamenciemas($id_paciente,$n_conexamen);
        $datos['medicamentos']          =   $this->examen_model->cimedicamentos($id_paciente,$n_conexamen);
        $datos['paraclinicos']          =   $this->examen_model->paraclinicos($id_paciente, $n_conexamen);

        $datos['num_retinologia']       =  $this->input->post('num_retinologia', true);
        
        $datos['id_paciente']           =   $id_paciente;
        $datos['identificacion']        =   '';
        $datos['tipo_identificacion']   =   '';
        $datos['n_conexamen']           =   $n_conexamen;

        
        $datos['cons_examen']           =   $n_conexamen;  


        $this->load->view('front_end/historias/hexamen_opt_ret_v', $datos);
    }

    

}