<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Listaprecios extends CI_Controller {
    
    //private $session_id, $session_nombre, $nivel_usuario;     
    public function __construct()
    {
        parent::__construct();        
        $this->load->library('Datatables');      
    }
    
    public function listap()
    {
        $this->load->model('listaprecios_model');
        $datos['constipo']      =   $this->listaprecios_model->constipo();
        $datos['consindice']    =   $this->listaprecios_model->consindice();
        
        $this->load->view('front_end/historias/listap_v', $datos);
    }
    
    public function clistap()
    {          
        //$this->output->cache(10);
        $this->datatables->select("lp.cod_listap, lp.nombre_listap, lp.detalle, t.nombre_lptipo, lp.frecuencia,
        lp.tiempo_entrega, lp.agenda, lp.medico, i.nombre_lpindice, lp.color, lp.valor")
        ->join('listaprecios_tipo t', 't.cod_lptipo = lp.cod_lptipo')
        ->join('listaprecios_indice i', 'i.cod_lpindice = lp.cod_lpindice')  
        ->where('lp.division', '')
        ->from('listaprecios lp');
        
        echo $this->datatables->generate();
    }
    
    public function insertarprocedimiento()
    {        
        $this->load->model('listaprecios_model');   
        $numeroc        = $this->listaprecios_model->consultaconsecutivo(11);

        $nuevoitem      =   array(
            'cod_listap'     =>   $numeroc,
            'nombre_listap'  =>   strtoupper($this->input->post('nuevotratamiento', true)),
            'detalle'        =>   strtoupper($this->input->post('detalletratamiento', true)),
            'cod_lptipo'     =>   $this->input->post('tipo', true),
            'frecuencia'     =>   $this->input->post('frecuencia', true),
            'tiempo_entrega' =>  $this->input->post('tiempo_entrega', true),
            'agenda'         =>   $this->input->post('agenda', true),
            'medico'         =>   $this->input->post('medico', true),
            'cod_lpindice'   =>   $this->input->post('indice', true),
            'valor'          =>   $this->input->post('nuevovalortrata', true),
            'color'          =>   $this->input->post('color', true));
        $data           =   $this->listaprecios_model->insertarprocedimiento($nuevoitem, $numeroc);
        redirect(base_url().'1historias/listaprecios/listap', 301);
    }
    
    public function modificarprocedimiento()
    {
        $this->load->model('listaprecios_model');
        $cod_listapm                =   $this->input->post('cod_listapm', true);        
        $modificaritem              =   array(
            'nombre_listap'         =>  strtoupper($this->input->post('nuevotratamientom', true)),
            'detalle'               =>  strtoupper($this->input->post('detallem', true)),
            'cod_lptipo'            =>  $this->input->post('tipom', true),
            'frecuencia'            =>  $this->input->post('frecuenciam', true),
            'tiempo_entrega'        =>  $this->input->post('tiempo_entregam', true),
            'agenda'                =>  $this->input->post('agendam', true),
            'medico'                =>  $this->input->post('medicom', true),
            'cod_lpindice'          =>  $this->input->post('indicem', true),
            'valor'                 =>  $this->input->post('nuevovalortratam', true),
            'color'                 =>   $this->input->post('colorm', true)
             );

        $actualizar                 =   $this->listaprecios_model->vmodificarprocedimiento($cod_listapm, $modificaritem);
        redirect(base_url().'1historias/listaprecios/listap', 301);
    }
    
    public function clistapm()
    {          
        //$this->output->cache(10);
        $this->datatables->select("lp.cod_listap, lp.nombre_listap, lp.detalle, lp.cod_lptipo, lp.cod_lpindice, t.nombre_lptipo, lp.frecuencia, lp.tiempo_entrega, lp.agenda, lp.medico, i.nombre_lpindice, lp.color, lp.valor")
        ->join('listaprecios_tipo t', 't.cod_lptipo = lp.cod_lptipo')
        ->join('listaprecios_indice i', 'i.cod_lpindice = lp.cod_lpindice')  
        ->where('lp.division', '')     
        ->from('listaprecios lp');
        
        
        echo $this->datatables->generate();
    }
    
    public function clistaindice()
    {          
        //$this->output->cache(10);
        $this->datatables->select("cod_lpindice, nombre_lpindice")                
        ->from('listaprecios_indice');
        
        echo $this->datatables->generate();
    }   
    
    public function insertarindice()
    {
        $this->load->model('listaprecios_model');
        $numeroindice        = $this->listaprecios_model->consultaconsecutivo(18);
        $nuevoindice            =   array(
            'cod_lpindice'      =>  $numeroindice,
            'nombre_lpindice'   =>  strtoupper($this->input->post('nue_indice', true)));
                       
        $indicenuevo            =   $this->listaprecios_model->indicenuevo($nuevoindice, $numeroindice);
        redirect(base_url().'1historias/listaprecios/listap', 301);
    }
    
    public function modificarindice()
    {
        $this->load->model('listaprecios_model');
        $modindice          =   array(
            'nombre_lpindice'   =>  strtoupper($this->input->post('mod_indice', true)));
        $cod_lpindice       =   $this->input->post('modcod_lpindice', true);
        
        $indicemodificar    =   $this->listaprecios_model->modificarindice($cod_lpindice, $modindice);
        redirect(base_url().'1historias/listaprecios/listap', 301);
    }
    
    public function clistatipo()
    {          
        //$this->output->cache(10);
        $this->datatables->select("cod_lptipo, nombre_lptipo, agenda")                
        ->from('listaprecios_tipo');      
        
        $this->db->order_by('nombre_lptipo');
        echo $this->datatables->generate();
    }
    
    public function insertartipo()
    {
        $this->load->model('listaprecios_model');
        $numerotipo        = $this->listaprecios_model->consultaconsecutivo(19);

        $nuevotipo  =   array(
            'cod_lptipo'        =>  $numerotipo,       
            'nombre_lptipo'     =>  strtoupper($this->input->post('nombre_lptipo', true)),                    
            'agenda'            =>  strtoupper($this->input->post('agenda_tipo', true)));                    
        $tiponuevo              =   $this->listaprecios_model->tiponuevo($nuevotipo, $numerotipo);
        redirect(base_url().'1historias/listaprecios/listap', 301);
    }
    
    public function modificartipo()
    {
        $this->load->model('listaprecios_model');
        $modtipo            =   array(
            'nombre_lptipo' =>  strtoupper($this->input->post('modnombre_lptipo', true)),
            'agenda'        =>  strtoupper($this->input->post('agenda_tipom', true)));
        

        $cod_lptipo         =   $this->input->post('modcod_lptipo', true);
        
        $tipomodificar      =   $this->listaprecios_model->modificartipo($cod_lptipo, $modtipo);
        redirect(base_url().'1historias/listaprecios/listap', 301);
    }
    
    public function tlistapaq()
    {        
        $this->datatables->select("cod_listap, nombre_listap, valor")
        ->where('cod_lptipo = "3"')
        ->where('valor', '0')
        ->from('listaprecios');     
                
        echo $this->datatables->generate();
    }
    
    public function tlistaitemsnuevos()
    {        
        $this->datatables->select("l.cod_listap, l.nombre_listap, lt.nombre_lptipo, l.frecuencia, l.valor")
        
        ->from('listaprecios l');      
        $this->db->join('listaprecios_tipo lt', 'lt.cod_lptipo = l.cod_lptipo');
        $this->db->where_not_in('l.cod_lptipo', '3');        
        echo $this->datatables->generate();
    }
    
    public function nuevopaquete()
    {
        $this->load->model('listaprecios_model');
        $nuevopaquete  =   array(
            'cod_listap'        =>  $this->input->post('codpaqnuevo', true),
            'valor'             =>  $this->input->post('ntotal', true));                    
        $paqueteenca      =   $this->listaprecios_model->paqueteencabezado($nuevopaquete);

        // actualizar paquete el valor en tabla listap
        $modpaquete  =   array(            
            'valor'         =>  $this->input->post('ntotal', true));                    
        $mcod_listap        =   $this->input->post('codpaqnuevo', true);
        $paqmod             =   $this->listaprecios_model->paqueactualizar($modpaquete, $mcod_listap);

        for ($i = 0; $i < count($this->input->post('ncodigo')); $i++) 
        {
            
            $nuevopaquetedetalles   =   array(
            'cod_listapaquete'  =>  $this->input->post('codpaqnuevo', true),
            'cod_listap'        =>  $this->input->post('ncodigo', true)[$i],
            'frecuencia'        =>  $this->input->post('nfrecuencia', true)[$i],
            'valor'             =>  $this->input->post('nvalor', true)[$i]
            );       
            $paquetedeta      =   $this->listaprecios_model->paquetedetalles($nuevopaquetedetalles);
        }
        redirect(base_url().'1historias/listaprecios/listap', 301);
    }

    public function resumenpaquetes()
    {          
        //$this->output->cache(10);
        $this->datatables->select("e.cod_listap, lp.nombre_listap, e.valor")
        ->join('listaprecios lp', 'lp.cod_listap = e.cod_listap')
        ->from('listaprecios_paquetes_e e');
        
        echo $this->datatables->generate();
    }

    public function consultapaquete()   
    {
        $this->load->model('listaprecios_model');
        $cod_listap             =   $this->input->post('bdcod_listap');
        $datos['rcodpaquete']   =   $this->input->post('bdcod_listap');
        $datos['nombre']        =   $this->input->post('bdnombre');
        $datos['conspaquete']   =   $this->listaprecios_model->consultapaquete($cod_listap);
        $this->load->view('front_end/historias/listap_r_v', $datos);
    }

    public function actualizarpaquete()
    {
        $this->load->model('listaprecios_model');
        // ACTUALIZANDO ENCABEZADO        
        $codpaquete             =   $this->input->post('codpaquete');
        
        $epaquete   =   array(
            'valor' =>  $this->input->post('mntotal'));

        $actuepaquete   =   $this->listaprecios_model->actuepaquete($codpaquete, $epaquete);
                          
        // ACTUALIZANDO DETALLES DEL PAQUETE
        $actudpaquete   =   $this->listaprecios_model->actudpaquete($codpaquete);

        for ($i = 0; $i < count($this->input->post('resbdcod_listap')); $i++) 
        {
            $nuevopaquetedetalles   =   array(
            'cod_listapaquete'  =>  $this->input->post('codpaquete'),
            'cod_listap'        =>  $this->input->post('resbdcod_listap', true)[$i],
            'frecuencia'        =>  $this->input->post('resbdfrecuencia', true)[$i],
            'valor'             =>  $this->input->post('resbdvalor', true)[$i]
            );       
            $paquetedeta      =   $this->listaprecios_model->paquetedetalles($nuevopaquetedetalles);
        }

    }
}  