<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Odontograma extends CI_Controller 
{
    public function __construct()
    {
        parent::__construct();
        //$this->load->library('Session');
//        $this->session_id               = $this->session->userdata('login');    
//        $this->session_nombre           = $this->session->userdata('nombre'); 
//        $this->session_nivel_usuario    = $this->session->userdata('nivel_usuario');
//        $this->session_idusuario        = $this->session->userdata('id');
//        $this->session_gempnumero       = $this->session->userdata('gempnumero');
//        $this->session_gempnombre       = $this->session->userdata('gempnombre'); 
//        $this->session_gempanoc         = $this->session->userdata('gempanoc');
        
        $this->load->helper(array('download', 'file')); 
//        $this->load->library('pdfconsentimiento');
        $this->load->helper(array('url'));
        $this->load->library('Datatables');
    }
    
    public function index()
    {
    }
    
    public function odoningresar()
    {
        $this->load->model('odontograma_model');
        $datos['cod_persona_atie']  =   $this->input->post('cod_persona_atie');
        $datos['id_admi']           =   $this->input->post('id_admi');
        $datos['id_usuario']        =   $this->input->post('id_usuario');
        $datos['id_paciente']       =   $this->input->post('id_paciente');
        $datos['codprograma']       =   $this->input->post('codprograma');
        $datos['convencion']        =   $this->odontograma_model->convencion();
        $datos['odon_proce']        =   $this->odontograma_model->odon_proce();
        $this->load->view('front_end/historias/odontograma_v', $datos);
    }
    
    public function listadeprecios()
    {
        $this->load->model('odontograma_model');
        $datos['convencion']        =   $this->odontograma_model->convencion();
        $datos['odon_proce']        =   $this->odontograma_model->odon_proce();
        $this->load->view('front_end/historias/odontograma_listap_v', $datos);
    } 
    
    public function busquedacieo()
    {
        $sigla_sexo     =   $this->input->post('sigla_sexo');
        $limiteedad     =   $this->input->post('limiteedad');
        $abuscar        =   $this->input->post('abuscar');
        
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";
        
                
        $this->datatables->select("c.cod_cie, c.nombre_cie, c.cod_cielinea, c.cod_ciesublinea, c.id_cie, cl.nombre_cielinea, cs.nombre_ciesublinea")
        ->filter($ledad)
                
        ->join('cie10_linea cl', 'c.cod_cielinea = cl.cod_cielinea')        
        ->join('cie10_sublinea cs', 'c.cod_ciesublinea = cs.cod_ciesublinea')
        ->from('cie10 c');
        $names = array('A', $sigla_sexo );
        
        $this->db->like("nombre_cie", $abuscar);        
        $this->db->or_like('cod_cie', $abuscar);
        $this->db->where('especialidad', 'ODO');       
        $this->db->where_in('sexo', $names);
        
        echo $this->datatables->generate(); 
    }
    
    public function cielinea()
    {
        $this->load->model('odontograma_model');
        $sigla_sexo =   $this->input->post('sigla_sexo');
        $limiteedad =   $this->input->post('limiteedad');
        $cielinea   =   $this->odontograma_model->cielinea($sigla_sexo, $limiteedad);
    }
    
    public function ciesublinea()
    {
        $this->load->model('odontograma_model');
        $cielinea       =   $this->input->post('cielineao');
        $sigla_sexo     =   $this->input->post('sigla_sexo');
        $limiteedad     =   $this->input->post('limiteedad');
        $ciesublinea    =   $this->odontograma_model->ciesublinea($cielinea, $sigla_sexo, $limiteedad); 
    }
    
    public function ciecodigo()
    {    
        $this->load->model('odontograma_model');
        $cielinea       =   $this->input->post('cielinea');
        $ciesublinea    =   $this->input->post('ciesublinea');
        $sigla_sexo     =   $this->input->post('sigla_sexo');
        $limiteedad     =   $this->input->post('limiteedad');
        $ciecodigo      =   $this->odontograma_model->ciecodigo($cielinea, $ciesublinea, $sigla_sexo, $limiteedad); 
    }
    
     public function busquedacups()
    {        
        $abuscar        =   $this->input->post('abuscar');
        
        $this->datatables->select("c.cod_cups, c.nombre_cups, c.cod_cupslinea, c.cod_cupsublinea, c.cod_cupsgrupo, c.id_cups, c.cupsconcie, cl.nombre_cupslinea, cs.nombre_cupsublinea, cg.nombre_cupsgrupo, c.valor")
        ->join('cups_linea cl', 'c.cod_cupslinea = cl.cod_cupslinea')        
        ->join('cups_sublinea cs', 'c.cod_cupsublinea = cs.cod_cupsublinea')  
        ->join('cups_grupo cg', 'c.cod_cupsgrupo = cg.cod_cupsgrupo')
        ->from('cups c');
        
        $this->db->like("nombre_cups", $abuscar); 
        $this->db->or_like("cod_cups", $abuscar);                
        echo $this->datatables->generate(); 
    }
    
    public function cupslinea()
    {
        $this->load->model('odontograma_model');
        $cupslinea  =   $this->odontograma_model->cupslinea();
    }
    
    public function cupssublinea()
    {
        $this->load->model('odontograma_model');
        $cupslinea      =   $this->input->post('cod_cupslinea');
        $cupssublinea   =   $this->odontograma_model->cupssublinea($cupslinea);
    }
    
    public function cupsgrupo()
    {
        $this->load->model('odontograma_model');
        $cupsublinea    =   $this->input->post('cod_cupsublinea');
        $cupsgrupo      =   $this->odontograma_model->cupsgrupo($cupsublinea);
    }
    
    public function cupscodigo()
    {
        $this->load->model('odontograma_model');
        $cupsgrupo      =   $this->input->post('cod_cupsgrupo');
        $cupscodigo     =   $this->odontograma_model->cupscodigo($cupsgrupo);
    }
    
    public function convencion()
    {
        $this->load->model('odontograma_model');
        $convencion     =   $this->odontograma_model->convencion();
    }
    
    public function odoningreso()
    {
        $this->load->model('odontograma_model');
        $data           =   $this->odontograma_model->odoningreso();
        $conscot        =   $data['conscot'];
        $consodon       =   $data['consodon'];
        $ref_procesos   =   $data['ref_procesos'];
        $cod_medi       =   $data['cod_medi'];
        $id_admi        =   $data['id_admi'];
        $cod_cons       =   $data['cod_cons'];
        $identificacion =   $data['identificacion'];
        $tipo_docu      =   $data['tipo_docu'];
        
        // EXCANBEZADO COTIZACION     
        $consultacot    =   $this->odontograma_model->consultacot($conscot, $consodon, $ref_procesos);
        foreach($consultacot as $ccot)
        {
            $datos['fecha']         =   $ccot['fechaingreso'];
            $datos['numcotizacion'] =   $ccot['numero_docu'];
            $datos['numodontograma']=   $ccot['documento_ref'];
            $datos['valor']         =   $ccot['valor_total'];
        }
        // PRESTADOR
        $consultaprestador  =   $this->odontograma_model->consultaprestador();
        foreach($consultaprestador as $cpres)
        {
            $datos['pnumero']        =   $cpres['numero'];
            $datos['pnombre']        =   $cpres['nombre'];
            $datos['pdireccion']     =   $cpres['direccion'];
            $datos['ptelefonos']     =   $cpres['telefono1'].' '.$cpres['telefono2'];
            $datos['plogo']          =   $cpres['logopresatador'];   
        }
        // MEDICO
        $consutamedico  =   $this->odontograma_model->consultamedico($cod_medi);
        foreach($consutamedico as $cmed)
        {
            $datos['mcodigo']   =   $cmed['cod_medi'];
            $datos['mnombre']   =   $cmed['primer_nombre_medi'].' '.$cmed['segundo_nombre_medi'].' '.$cmed['primer_apellido_medi'].' '.$cmed['segundo_apellido_medi'];
        }
        // ADMINISTRADORA
        $consultaadmin  =   $this->odontograma_model->consultaadmin($id_admi);
        foreach($consultaadmin as $cadmin)
        {
            $datos['anombre_admi']  =   $cadmin['nombre_admi'];
        }
        // CONSULTA
        $consultacod_cons   =   $this->odontograma_model->consultacod_cons($cod_cons);
        foreach($consultacod_cons as $ccod)
        {
            $datos['cnombre_cons']  =   $ccod['nombre_cons'];
        }
        // PACIENTE
        $consultapaciente   =   $this->odontograma_model->consultapaciente($identificacion, $tipo_docu);
        foreach($consultapaciente as $cpac)
        {
            $datos['cidentificacion']    =   $cpac['identificacion'];
            $datos['cnombre']            =   $cpac['primer_nombre'].' '.$cpac['segundo_nombre'].' '.$cpac['primer_apellido'].' '.$cpac['segundo_apellido'];
            $datos['cdireccion']         =   $cpac['direccion_paci'];
            $datos['ctelefonos']         =   $cpac['telefono_paciente']. ' ' . $cpac['celular_paciente'];
        }
        $this->load->view('front_end/historias/odontograma_r_v', $datos);
    }
    
    public function odoningreso1()
    {
        $this->load->model('odontograma_model');
        $datos  =   array(); 
        
        $data           =   $this->odontograma_model->odoningreso();  
        $version        =   $data['version'];        
        $numodon        =   $data['numodon'];
        $versiones      =   $this->odontograma_model->consulversion($numodon, $version);
        foreach($versiones as $ver)
        {
            $datos['fechaversion']  =   $ver['fecha'];
        }
              
        $encabezado   =   $this->odontograma_model->cencabezado($numodon, $version);
        foreach($encabezado as $enc)
        {
            $datos['num_odon']  =   $enc['num_odon'];
            $datos['version']   =   $enc['version'];
            $identificacion     =   $enc['identificacion'];
        }
        
        $consulpaciente =   $this->odontograma_model->consulpaciente($identificacion);
        foreach($consulpaciente as $cpac)
        {
            $datos['nompaciente']   =   $cpac['primer_nombre'].' '.$cpac['segundo_nombre'].' '.$cpac['primer_apellido'].' '.$cpac['segundo_apellido'];
            $datos['idepaciente']   =   $cpac['identificacion'];
            $datos['dirpaciente']   =   $cpac['direccion_paci'];
            $datos['telpaciente']   =   $cpac['telefono_paciente']. ' ' . $cpac['celular_paciente'];
        }
          
        $prestador                      =   $this->odontograma_model->prestador();
        foreach($prestador as $pre)
        {
            $datos['presnumero']        =   $pre['numero'];
            $datos['presnombre']        =   $pre['nombre'];
            $datos['presdireccion']     =   $pre['direccion'];
            $datos['prestelefono']      =   $pre['telefono1']. ' ' .$pre['telefono2'];
        }  
        
        $cotizacionenc     =   $this->odontograma_model->cotizacionenc($numodon, $version);
        foreach($cotizacionenc as $cenca)
        {
            $datos['numero_docu']           =   $cenca['numero_docu'];
            $datos['identificacion_paci']   =   $cenca['identificacion_paci'];
            $datos['documento_ref']         =   $cenca['documento_ref'];
            $datos['version']               =   $cenca['version'];            
            $datos['valor_total_cot']       =   $cenca['valor_total'];
            $datos['fechaingreso']          =   $cenca['fechaingreso'];
            $datos['horaingreso']           =   $cenca['horaingreso'];
        }
        
        $datos['cotizaciondet']     =   $this->odontograma_model->cotizaciondet($numodon, $version);
        
                  
        $datos['detalles']  =   $this->odontograma_model->cdetalles($numodon, $version);
        
        echo json_encode($datos);
    }
    
    public function odonactualizar1()
    {
        //echo 'login';
        //$this->load->model('odontograma_model');
        //$data                       =   $this->odontograma_model->odonactualizar();
        //echo $data;  
    }
    public function odonactualizar()
    {
        $this->load->model('odontograma_model');
        $data                       =   $this->odontograma_model->odonactualizar();  
        $datos['num_odon']          =   $data['num_odon'];
        $datos['num_cotizacion']    =   $data['num_cotizacion'];
        $datos['fechamod']          =   $data['fechamod'];
        $datos['horamod']           =   $data['horamod'];
        $datos['version']           =   $data['version'];
        $datos['valortotal']        =   $data['valortotal'];
        
        $conscot                    =   $data['num_cotizacion'];
        $consodon                   =   $data['num_odon'];
        $ref_procesos               =   $data['ref_procesos'];
        $cod_medi                   =   $data['cod_medi'];
        $id_admi                    =   $data['id_admi'];
        $cod_cons                   =   $data['cod_cons'];
        $identificacion             =   $data['identificacion'];
        $tipo_docu                  =   $data['tipo_docu'];
        
        // EXCANBEZADO COTIZACION     
        $consultacot    =   $this->odontograma_model->consultacot($conscot, $consodon, $ref_procesos);
        foreach($consultacot as $ccot)
        {
            $datos['fecha']         =   $ccot['fechaingreso'];
            $datos['numcotizacion'] =   $ccot['numero_docu'];
            $datos['numodontograma']=   $ccot['documento_ref'];
            $datos['valor']         =   $ccot['valor_total'];
        }
        // PRESTADOR
        $consultaprestador  =   $this->odontograma_model->consultaprestador();
        foreach($consultaprestador as $cpres)
        {
            $datos['pnumero']        =   $cpres['numero'];
            $datos['pnombre']        =   $cpres['nombre'];
            $datos['pdireccion']     =   $cpres['direccion'];
            $datos['ptelefonos']     =   $cpres['telefono1'].' '.$cpres['telefono2'];
            $datos['plogo']          =   $cpres['logopresatador'];   
        }
        // MEDICO
        $consutamedico  =   $this->odontograma_model->consultamedico($cod_medi);
        foreach($consutamedico as $cmed)
        {
            $datos['mcodigo']   =   $cmed['cod_medi'];
            $datos['mnombre']   =   $cmed['primer_nombre_medi'].' '.$cmed['segundo_nombre_medi'].' '.$cmed['primer_apellido_medi'].' '.$cmed['segundo_apellido_medi'];
        }
        // ADMINISTRADORA
        $consultaadmin  =   $this->odontograma_model->consultaadmin($id_admi);
        foreach($consultaadmin as $cadmin)
        {
            $datos['anombre_admi']  =   $cadmin['nombre_admi'];
        }
        // CONSULTA
        $consultacod_cons   =   $this->odontograma_model->consultacod_cons($cod_cons);
        foreach($consultacod_cons as $ccod)
        {
            $datos['cnombre_cons']  =   $ccod['nombre_cons'];
        }
        // PACIENTE
        $consultapaciente   =   $this->odontograma_model->consultapaciente($identificacion, $tipo_docu);
        foreach($consultapaciente as $cpac)
        {
            $datos['cidentificacion']    =   $cpac['identificacion'];
            $datos['cnombre']            =   $cpac['primer_nombre'].' '.$cpac['segundo_nombre'].' '.$cpac['primer_apellido'].' '.$cpac['segundo_apellido'];
            $datos['cdireccion']         =   $cpac['direccion_paci'];
            $datos['ctelefonos']         =   $cpac['telefono_paciente']. ' ' . $cpac['celular_paciente'];
        }
        $this->load->view('front_end/historias/hcodonmod_r_v', $datos);    
    }
    
    public function odonconsulta()
    {
        $this->load->model('odontograma_model');
        $prestador                      =   $this->odontograma_model->prestador();
        foreach($prestador as $pre)
        {
            $datos['presnumero']        =   $pre['numero'];
            $datos['presnombre']        =   $pre['nombre'];
            $datos['presdireccion']     =   $pre['direccion'];
            $datos['prestelefono']      =   $pre['telefono1']. ' ' .$pre['telefono2'];
        }
        $datos['cod_persona_atie']  = $this->input->post('cod_persona_atie');
        $datos['id_admi']           = $this->input->post('id_admi');
        $datos['id_usuario']        = $this->input->post('id_usuario');
        $datos['id_paciente']       = $this->input->post('id_paciente');
        $datos['codprograma']       = $this->input->post('codprograma');
        $datos['convencion']        = $this->odontograma_model->convencion();
        $datos['versionodontograma']    = $this->odontograma_model->versionodontograma($this->input->post('id_paciente'));
        $this->load->view('front_end/historias/hcodoncon_v', $datos);
    }
    
    public function odonmodificar()
    {
        $this->load->model('odontograma_model');
        $prestador                      =   $this->odontograma_model->prestador();
        foreach($prestador as $pre)
        {
            $datos['presnumero']        =   $pre['numero'];
            $datos['presnombre']        =   $pre['nombre'];
            $datos['presdireccion']     =   $pre['direccion'];
            $datos['prestelefono']      =   $pre['telefono1']. ' ' .$pre['telefono2'];
        }
        $datos['cod_persona_atie']      =   $this->input->post('cod_persona_atie');
        $datos['id_admi']               =   $this->input->post('id_admi');
        $datos['id_usuario']            =   $this->input->post('id_usuario');
        $datos['id_paciente']           =   $this->input->post('id_paciente');
        $datos['codprograma']           =   $this->input->post('codprograma');
        $datos['convencion']            =   $this->odontograma_model->convencion();
        $datos['odon_proce']            =   $this->odontograma_model->odon_proce();             
        $this->load->view('front_end/historias/hcodonmod_v', $datos);
    }
    
    public function consultaversionodontograma()
    {
        $tipodocu                       =   $this->input->post('tipodocu');
        $identificacion                 =   $this->input->post('identificacion');
        $codmedi                        =   $this->input->post('vvcodmedi');
        
        $this->datatables->select("v.cotizacion, v.num_odon, v.version, v.fecha, v.hora, v.valortotal")
        ->where('v.tipo_docu', $tipodocu)
        ->where('v.identificacion', $identificacion)
        ->where('v.cod_medi', $codmedi)
        ->join('odontograma_encabezado o', 'o.version = v.version AND o.num_odon = v.num_odon')        
        ->from('odontograma_versiones v');
        
                
        echo $this->datatables->generate(); 
    }
    
    public function consultaversionesodontograma()
    {
        $tipodocu                       =   $this->input->post('tipodocu');
        $identificacion                 =   $this->input->post('identificacion');
        $codmedi                        =   $this->input->post('vvcodmedi');
        
        $this->datatables->select("cotizacion, num_odon, version, fecha, hora, valortotal ")
        ->where('tipo_docu', $tipodocu)
        ->where('identificacion', $identificacion)
        ->where('cod_medi', $codmedi)                
        ->from('odontograma_versiones');
        
                
        echo $this->datatables->generate(); 
    }
   
    public function consultar()
    {
        $this->load->model('odontograma_model');
        $num_odon               =   $this->input->post('num_odon');
        $version                =   $this->input->post('version');       
        $identificacion         =   $this->input->post('identificacion');
        $datos  =   array();   
        $datos['fechaversion']  =   $this->input->post('fechaversion');     
        $consultodontograma     =   $this->odontograma_model->consultodontograma($num_odon, $version);
        foreach($consultodontograma as $row)
        {
            $datos['num_odon']      =   $row['num_odon'];
            $datos['cod_medi']      =   $row['cod_medi'];
            $cod_medi               =   $row['cod_medi'];
            $id_admi                =   $row['id_admi'];
            $cod_cons               =   $row['cod_cons'];
            $datos['cod_cons']      =   $row['cod_cons'];
            $datos['version']       =   $row['version'];
            $datos['nombre_cons']   =   $row['nombre_cons'];
            $datos['nombre_medi']   =   $row['primer_nombre_medi'].' '.$row['segundo_nombre_medi'].' '.$row['primer_apellido_medi'].' '.$row['segundo_apellido_medi'];
        }
        $encabezado    =   $this->odontograma_model->consultaodontograma($num_odon);
        foreach($encabezado as $enc)
        {
            $datos['sist']          =   $enc['sist'];
            $datos['diast']         =   $enc['diast'];
            $datos['ppm']           =   $enc['ppm'];
            $datos['rpm']           =   $enc['rpm'];
            $datos['grados']        =   $enc['grados'];
            $datos['altura']        =   $enc['altura'];
            $datos['peso']          =   $enc['peso'];
            $datos['imc']           =   $enc['imc'];
            $datos['versionenc']    =   $enc['version'];
        }
        $cidpaciente    =   $this->odontograma_model->cpacienteodon($identificacion);
        foreach($cidpaciente as $cid)
        {
            $datos['idepaciente']           =   $cid['identificacion'];            
            $datos['nompaciente']           =   $cid['primer_nombre'].' '.$cid['segundo_nombre'].' '.$cid['primer_apellido'].' '.$cid['segundo_apellido'];
            $datos['dirpaciente']           =   $cid['direccion_paci'];
            $datos['telpaciente']           =   $cid['telefono_paciente']. ' ' . $cid['celular_paciente'];
        }
        
        // DATOS PARA COTIZACIONES
        $cotizacionenc     =   $this->odontograma_model->cotizacionenc($num_odon, $version);
        foreach($cotizacionenc as $cenca)
        {
            $datos['numero_docu']           =   $cenca['numero_docu'];
            $datos['identificacion_paci']   =   $cenca['identificacion_paci'];
            $datos['documento_ref']         =   $cenca['documento_ref'];
            $datos['version']               =   $cenca['version'];            
            $datos['valor_total_cot']       =   $cenca['valor_total'];
            $datos['fechaingreso']          =   $cenca['fechaingreso'];
            $datos['horaingreso']           =   $cenca['horaingreso'];
            $datos['total_abonos']          =   $cenca['total_abonos'];
        }
        $consutamedico  =   $this->odontograma_model->consultamedico($cod_medi);
        foreach($consutamedico as $cmed)
        {
            $datos['mcodigo']   =   $cmed['cod_medi'];
            $datos['mnombre']   =   $cmed['primer_nombre_medi'].' '.$cmed['segundo_nombre_medi'].' '.$cmed['primer_apellido_medi'].' '.$cmed['segundo_apellido_medi'];
        }
        // ADMINISTRADORA
        $consultaadmin  =   $this->odontograma_model->consultaadmin($id_admi);
        foreach($consultaadmin as $cadmin)
        {
            $datos['anombre_admi']  =   $cadmin['nombre_admi'];
        }
        // CONSULTA
        $consultacod_cons   =   $this->odontograma_model->consultacod_cons($cod_cons);
        foreach($consultacod_cons as $ccod)
        {
            $datos['cnombre_cons']  =   $ccod['nombre_cons'];
        }
        
        $datos['cotizaciondet']     =   $this->odontograma_model->cotizaciondet($num_odon, $version);
        
        $datos['detalles']          =   $this->odontograma_model->consultarodontograma($num_odon, $version);
        
        
        echo json_encode($datos);
    }
    
    public function confinalidadcie()
    {
        $this->load->model('odontograma_model');
        $cod_fina       =   $this->input->post('ccod_fina');
        $cod_tipo_fina  =   $this->input->post('cod_tipo_fina_cie');
        $consfina       =   $this->odontograma_model->confinalidadcie($cod_fina, $cod_tipo_fina);
    }
    
    public function concausacie()
    {
        $this->load->model('odontograma_model');
        $cod_causa_dia       =   $this->input->post('cod_causa_dia');        
        $conscausa           =   $this->odontograma_model->concausacie($cod_causa_dia);
    }    
    
    public function contipo()
    {
        $this->load->model('odontograma_model');
        $cod_tipo       =   $this->input->post('cod_tipo');        
        $constipo       =   $this->odontograma_model->contipo($cod_tipo);
    }
    
    public function confinalidadcups()
    {
        $this->load->model('odontograma_model');
        $ccod_fina_cups       =   $this->input->post('ccod_fina_cups');
        $cod_tipo_fina_cups   =   $this->input->post('cod_tipo_fina_cups');
        $consfinacups         =   $this->odontograma_model->confinalidadcups($ccod_fina_cups, $cod_tipo_fina_cups);
    }
    
    public function conambitocups()
    {
        $this->load->model('odontograma_model');
        $cambitocupso       =   $this->input->post('cambitocupso');        
        $consambito         =   $this->odontograma_model->conambitocups($cambitocupso);
    }
    
    public function conactoq()
    {
        $this->load->model('odontograma_model');
        $cactoqcupso       =   $this->input->post('cactoqcupso');        
        $consactoq         =   $this->odontograma_model->conactoq($cactoqcupso);
    }
    
    public function consentimientoodontogramacot()
    {
        $this->load->model('historia_model');
        $tipo_docu      =   $this->input->post('tipo_docu');
        $identificacion =   $this->input->post('identificacion');
        
        // PRESTADOR
        $consultaprestador  =   $this->historia_model->consultaprestador();
        foreach($consultaprestador as $cpres)
        {
            $datos['pnumero']        =   $cpres['numero'];
            $datos['pnombre']        =   $cpres['nombre'];
            $datos['pdireccion']     =   $cpres['direccion'];
            $datos['ptelefonos']     =   $cpres['telefono1'].' '.$cpres['telefono2'];
            $datos['plogo']          =   $cpres['logopresatador'];   
        }
        
        // DATOS DEL PACIENTE
        $datpac         =   $this->historia_model->datpac($tipo_docu, $identificacion);
        foreach($datpac as $dtos)
        {
            $datos['nombre']    =   $dtos['primer_nombre'].' '.$dtos['segundo_nombre'].' '.$dtos['primer_apellido'].' '.$dtos['segundo_apellido'];
        }
        $datos['tipo_docu']     =   $tipo_docu;
        $datos['identificacion']=   $identificacion;
        $this->load->view('front_end/historias/consentimientoodontogramacot_v', $datos);
    }
    
    public function consentimientoodontogramamod()
    {
        $this->load->model('historia_model');
        $this->load->model('odontograma_model');
        
        
        $tipo_docu      =   $this->input->post('tipo_docu');
        $identificacion =   $this->input->post('identificacion');
        $numconsulta    =   trim($this->input->post('numconsulta'));
        $cotizacion     =   trim($this->input->post('cotizacion'));
        $version        =   $this->input->post('version');
        
        // PRESTADOR
        $consultaprestador  =   $this->historia_model->consultaprestador();
        foreach($consultaprestador as $cpres)
        {
            $datos['pnumero']        =   $cpres['numero'];
            $datos['pnombre']        =   $cpres['nombre'];
            $datos['pdireccion']     =   $cpres['direccion'];
            $datos['ptelefonos']     =   $cpres['telefono1'].' '.$cpres['telefono2'];
            $datos['plogo']          =   $cpres['logopresatador'];   
        }
        
        // CIE Y CUPS DEL ODONTOGRAMA CUANDO SE MODIFICA
        $datos['regconsulta']       =   $this->odontograma_model->regconsulta($tipo_docu, $numconsulta, $cotizacion, $version);
        $fechaversion               =   $this->odontograma_model->regversion($tipo_docu, $numconsulta, $cotizacion, $version);
        foreach($fechaversion as $fecv)
        {
            $datos['fechaversion']  =   $fecv['fecha'];
        }
        // DATOS DEL PACIENTE
        $datpac         =   $this->historia_model->datpac($tipo_docu, $identificacion);
        foreach($datpac as $dtos)
        {
            $datos['nombre']    =   $dtos['primer_nombre'].' '.$dtos['segundo_nombre'].' '.$dtos['primer_apellido'].' '.$dtos['segundo_apellido'];
        }
        $datos['tipo_docu']     =   $tipo_docu;
        $datos['identificacion']=   $identificacion;
        $datos['numconsulta']   =   $numconsulta;
        $datos['version']       =   $version;
        $datos['cotizacion']    =   $cotizacion;   
        $this->load->view('front_end/historias/consentimientoodontogramamod_v', $datos);
    }
    
    
    public function insertarprocedimiento()
    {
        $this->load->model('odontograma_model');
        $procedimiento              =   $this->input->post('procedimiento');        
        $nombre_convencion_odon     =   $this->input->post('nombre_convencion_odon');
        $valor                      =   $this->input->post('valor');
        $datos['data']              =   $this->odontograma_model->vinsertarprocedimiento($procedimiento, $nombre_convencion_odon, $valor);
//        foreach($data as $row)
//        {
//            $datos['tdestadoconv']              =   $row['nombre_convencion_odon'];
//            $datos['tima_convencion_odon']      =   $row['imagen_convencion_odon'];  
//            $datos['cotvalor']                  =   $row['valor'];                 
//            $datos['tcod_convencion_odon']      =   $row['cod_convencion_odon'];
//            $datos['tnom_convencion_odon']      =   $row['nombre_convencion_odon'];
//            $datos['opcionconvencion']          =   $row['cod_convencion_odon'];
//            
//        }
//        
        $this->load->view('front_end/historias/odontograma_ins_v', $datos);
    }
 
    public function actualizarfirma()
    {        
        $this->load->model('odontograma_model');
        $this->load->model('historia_model');
        
        $tipo_docu      =   trim($this->input->post('tipo_docu'));
        $identificacion =   trim($this->input->post('identificacion'));
        $num_odon       =   trim($this->input->post('num_odon'));
        $version        =   trim($this->input->post('version'));                    
        $cotizacion     =   trim($this->input->post('cotizacion'));
        $firma          =   $this->input->post('firma');
        
        $actualizarfir  =   $this->odontograma_model->actualizarfirma($tipo_docu, $identificacion, $num_odon, $version, $cotizacion, $firma);
        
        // PRESTADOR
        $consultaprestador  =   $this->historia_model->consultaprestador();
        foreach($consultaprestador as $cpres)
        {
            $datos['pnumero']        =   $cpres['numero'];
            $datos['pnombre']        =   $cpres['nombre'];
            $datos['pdireccion']     =   $cpres['direccion'];
            $datos['ptelefonos']     =   $cpres['telefono1'].' '.$cpres['telefono2'];
            $datos['plogo']          =   $cpres['logopresatador'];   
        }
        
        // CIE Y CUPS DEL ODONTOGRAMA CUANDO SE MODIFICA
        $datos['regconsulta']       =   $this->odontograma_model->regconsulta($tipo_docu, $num_odon, $cotizacion, $version);
        $fechaversion               =   $this->odontograma_model->regversion($tipo_docu, $num_odon, $cotizacion, $version);
        foreach($fechaversion as $fecv)
        {
            $datos['fechaversion']  =   $fecv['fecha'];
            $datos['firma']                  =   $fecv['signature'];
            //            $firma                  =   'Hola';
        }
        // DATOS DEL PACIENTE
        $datpac         =   $this->historia_model->datpac($tipo_docu, $identificacion);
        foreach($datpac as $dtos)
        {
            $datos['nombre']    =   $dtos['primer_nombre'].' '.$dtos['segundo_nombre'].' '.$dtos['primer_apellido'].' '.$dtos['segundo_apellido'];
        }
        $datos['tipo_docu']     =   $tipo_docu;
        $datos['identificacion']=   $identificacion;
        $datos['numconsulta']   =   $num_odon;
        $datos['version']       =   $version;
        $datos['cotizacion']    =   $cotizacion;   
        
        // GENERACION  DEL PDF
        //$this->pdfconsentimiento  = new Pdfconsentimiento();
//        $this->pdfconsentimiento->AddPage();        
//        $this->pdfconsentimiento->cabecerav($firma);
//        //$this->pdfconsentimiento->AliasNbPages();
////        $this->pdfconsentimiento->SetTitle("Reporte Imagen por paciente");
////        $this->pdfconsentimiento->cuerpo($rimagen);
////        $nit        = $this->session_gempnumero;
////        $empresa    = $this->session_gempnombre;
////        $this->pdfconsentimiento->ultimo($nit, $empresa);
//        //$this->pdfconsentimiento->Output();
////        $pdf = new Pdfconsentimiento();
////        $pdf->AddPage();
////        $pdf->SetFont('Arial','B',16);
////        $pdf->Cell(40,10,'¡Hola, Mundo!');
//        echo $this->pdfconsentimiento->Output("informe imagen.pdf",'F');
        $this->load->view('front_end/historias/consentimientoodontogramamod_pdf_v', $datos);
    }
    
    public function generarpdf()
    {
        $this->load->model('odontograma_model');
        $tipo_docu      =   trim($this->input->post('tipo_docu'));
        $identificacion =   trim($this->input->post('identificacion'));
        $num_odon       =   trim($this->input->post('num_odon'));
        $version        =   trim($this->input->post('version'));
        $cotizacion     =   trim($this->input->post('cotizacion'));
        
        
        $rutafirma      =   'O'.$num_odon.'V'.$version;
        $proceso        =   $this->odontograma_model->generarp($tipo_docu, $identificacion, $num_odon, $version, $cotizacion, $rutafirma);
        $data = base64_decode($_POST['data']);
        file_put_contents( "image/".$rutafirma.".pdf", $data );
        
    }
    
    public function resumenevolucion()
    {
        $this->load->model('odontograma_model');
        $tipo_docu          =   $this->input->post('tipo_docu');
        $identificacion     =   $this->input->post('identificacion');
        $num_cotizacion     =   $this->input->post('num_cotizacion');
        $num_odon           =   $this->input->post('num_odon');
        $version            =   $this->input->post('version');
        
        
        $rconsulta  =   array();
        $rconsulta['detalles']  =   $this->odontograma_model->resumenevolucion($tipo_docu,$identificacion,$num_cotizacion,$num_odon,$version);
        $consulversion   =   $this->odontograma_model->resumenversion($tipo_docu,$identificacion,$num_cotizacion,$num_odon,$version);           
        foreach($consulversion as $conver)
        {
            $rconsulta['cnum_odon']      =   $conver['num_odon'];
            $rconsulta['cfecha']         =   $conver['fecha'];
            $rconsulta['ccotizacion']    =   $conver['cotizacion'];
            $rconsulta['cversion']       =   $conver['version'];
            $rconsulta['crutafirma']     =   base_url().'image/'.$conver['rutafirma'].'.pdf';
        }
        
        echo json_encode($rconsulta);
    }  
              
}