<?php
if (!defined('BASEPATH')) {
    exit('No hay acceso directo al script permitido, usuarios');
}
class Agenda extends CI_Controller {
    public function __construct() {
        parent::__construct();
        $this->load->library('Datatables');
        $this->load->model('agenda_model', 'am');
    }
    public function index() {

        date_default_timezone_set('America/Bogota');
        $datos['fechaactual'] = date("Y-m-d");
        $datos['horaactual']  = date("H:i:s");

        // DATOS PACIENTE
        $id_usuario      = $this->input->post('histid', true);
        
        $persona_atiende = $this->am->persona_atiende($id_usuario);
        foreach ($persona_atiende as $persona) {
            $datos['cod_persona_atie']  =    $persona['cod_persona_atie'];
            $nombre_persona_atie        =    $persona['nombre_persona_atie'];
            $datos['login']             =    $persona['login'];
            $datos['medico']            =    $persona['medico']; 
        }
        $datos['id_usuario']            =   $id_usuario;
        $datos['histlogin']             =   $this->input->post('histlogin');
        // DATOS DEL PACIENTE
        $datos['id_paciente']           =   '';
        $datos['bd_tipo_docu']          =   '';
        $datos['bd_identificacion']     =   '';
        $datos['bd_primer_nombre']      =   '';
        $datos['bd_segundo_nombre']     =   '';
        $datos['bd_primer_apellido']    =   '';
        $datos['bd_segundo_apellido']   =   '';
        $datos['bd_telefono_paci']      =   '';
        $datos['bd_id_admi']            =   '';
        $datos['bd_nombre_admi']        =   '';
        $datos['bd_celular_paci']       =   '';
        $codprograma                    =   '85';

        // PROCEDIMIENTOS
        $datos['tipo']                  = $this->am->conTipo();
        $datos['procedimientos']        = $this->am->conProcedimientos();
        $datos['personal']              = $this->am->conPersonal();
        $datos['entero']                = $this->am->entero();
        $permisos                       =   $this->am->permisos($id_usuario, $codprograma);
        $datos['convenios']             =   $this->am->convenios();

        //$datos['personal']              =   $this->am->personal();
        $datos['spersonal']             =   $this->am->spersonal();
        // PROCEDIMIENTOS
        //$datos['procedimientos']        =   $this->am->conProcedimientos();
        $datos['clasificacion']         =   $this->am->conClasificacion();
        $datos['tipodocumento']         =   $this->am->tipodocumenton(); 

        if($permisos)
        {
            $datos['permisos']  =   'SI';
        }else
        {
            $datos['permisos']  =   'NO';
        }

        $personal               =   $this->am->conPersonal_id($id_usuario);
        if($personal)
        {
            foreach($personal as $per)
            {
                $datos['id_personal'] = $per['id'];
            }
        }else
        {
            $datos['id_personal'] = '';
        }

        $datos['consultorios'] = $this->am->consultorios();

        $this->load->view('front_end/agenda/ageningreso_v', $datos);
    }

    public function filtro()
    {

        // DATOS PACIENTE
        $id_usuario                     =   $this->input->post('id_usuario', true);
        $persona_atiende                =   $this->am->persona_atiende($id_usuario);
        $tipo_lista                     =   $this->input->post('tipo_lista');
        $tipo_procedimiento             =   $this->input->post('tipo_procedimiento');


        $datos['tipo_lista']            =   $tipo_lista;
        $datos['tipo_procedimiento']    =   $tipo_procedimiento;

        foreach ($persona_atiende as $persona) {
            $datos['cod_persona_atie']  =   $persona['cod_persona_atie'];
            $nombre_persona_atie        =   $persona['nombre_persona_atie'];
            $datos['login']             =   $persona['login'];
        }
        $datos['id_usuario']            =   $id_usuario;
        $datos['histlogin']             =   $this->input->post('histlogin');
        // DATOS DEL PACIENTE
        $datos['id_paciente']           =   '';
        $datos['bd_tipo_docu']          =   '';
        $datos['bd_identificacion']     =   '';
        $datos['bd_primer_nombre']      =   '';
        $datos['bd_segundo_nombre']     =   '';
        $datos['bd_primer_apellido']    =   '';
        $datos['bd_segundo_apellido']   =   '';
        $datos['bd_telefono_paci']      =   '';
        $datos['bd_id_admi']            =   '';
        $datos['bd_nombre_admi']        =   '';
        $datos['bd_celular_paci']       =   '';
        // PROCEDIMIENTOS
        $datos['tipo']                  =   $this->am->conTipo();
        $datos['procedimientos']        =   $this->am->conProcedimientos();
        $datos['personal']              =   $this->am->conPersonal();
        $datos['entero']                =   $this->am->entero();
        $datos['convenios']             =   $this->am->convenios();
        $datos['consultorios']          =   $this->am->consultorios();

        $this->load->view('front_end/agenda/ageningreso_v_filtro', $datos);
    }

    public function ingreso() {
        date_default_timezone_set('America/Bogota');
        $datos['fechaactual'] = date("Y-m-d");
        $datos['horaactual']  = date("H:i:s");
        
        $histlogin      = $this->input->post('histlogin', true);
        $datos['login'] = $histlogin;
        $datos['consultorios'] = $this->am->consultorios();
        exit();
        $this->load->view('front_end/agenda/ageningreso_v', $datos);
    }
    public function eventos() {
        $fecha_inico = $this->input->post('start');
        $fecha_final = $this->input->post('end');
        
        $datos = $this->am->get_data($fecha_inico, $fecha_final);
        echo json_encode($datos);
    }

    public function eventos_filtro() {
        $fecha_inico        = $this->input->post('start');
        $fecha_final        = $this->input->post('end');
        $tipo_lista         = $this->input->post('tipo_lista');
        $tipo_procedimiento = $this->input->post('tipo_procedimiento');

        if($tipo_lista == 'all')
        {
            $datos = $this->am->get_data($fecha_inico, $fecha_final);
        }else if($tipo_lista == 'all' && $tipo_procedimiento == 'all')
        {
            $datos = $this->am->get_data($fecha_inico, $fecha_final);
        }else if($tipo_lista > '0' && $tipo_procedimiento == 'all')
        {
            $datos = $this->am->get_data_filtro_all($fecha_inico, $fecha_final, $tipo_lista);
        }else
        {
            $datos = $this->am->get_data_filtro($fecha_inico, $fecha_final, $tipo_lista, $tipo_procedimiento);
        }
        //$datos = $this->am->get_data_filtro($fecha_inico, $fecha_final, $tipo_lista, $tipo_procedimiento);
        //$datos = $this->am->get_data($fecha_inico, $fecha_final);
        echo json_encode($datos);
    }

    public function eventos_filtro_medico()
    {
        $fecha_inico        = $this->input->post('start');
        $fecha_final        = $this->input->post('end');
        $tipo_personal      = $this->input->post('tipo_personal');
        if($tipo_personal == 'all')
        {
            $datos = $this->am->get_data($fecha_inico, $fecha_final);
        }else 
        {
            $datos = $this->am->get_data_filtro_medico($fecha_inico, $fecha_final, $tipo_personal);    
        }
        
        echo json_encode($datos);
    }

    public function eventos_filtro_todo() {
        $fecha_inico        = $this->input->post('start');
        $fecha_final        = $this->input->post('end');
        
        $tipo_lista         = $this->input->post('tipo_lista', true);
        $tipo_procedimiento = $this->input->post('tipo_procedimiento', true);
        $tipo_personal      = $this->input->post('tipo_personal', true);

        if($tipo_lista == 'all' && $tipo_procedimiento == 'all' && $tipo_personal == 'all')
        {
            $datos = $this->am->get_data($fecha_inico, $fecha_final);
        }else if($tipo_lista > '0' && $tipo_procedimiento == 'all' && $tipo_personal == 'all')
        {
            $datos = $this->am->get_data_filtro_all($fecha_inico, $fecha_final, $tipo_lista);
        }else if($tipo_lista > '0' && $tipo_procedimiento > '0' && $tipo_personal == 'all')
        {
            $datos = $this->am->get_data_filtro($fecha_inico, $fecha_final, $tipo_lista, $tipo_procedimiento);
        }else if($tipo_lista == 'all' && $tipo_procedimiento == 'all' && $tipo_personal > '0')
        {
            $datos = $this->am->get_data_filtro_medico($fecha_inico, $fecha_final, $tipo_personal);
        }else if($tipo_lista > '0' && $tipo_procedimiento == 'all' && $tipo_personal > '0')
        {
            $datos = $this->am->get_data_filtro_dos($fecha_inico, $fecha_final, $tipo_lista, $tipo_personal);
        }
        else if($tipo_lista > '0' && $tipo_procedimiento > '0' && $tipo_personal > '0')
        {
            $datos = $this->am->get_data_filtro_todos($fecha_inico, $fecha_final, $tipo_lista, $tipo_procedimiento, $tipo_personal);
        }

        echo json_encode($datos);
    }

    public function imprimir()
    {
        $datos['tipo']                  = $this->am->conTipo();
        $datos['procedimientos']        = $this->am->conProcedimientos();
        $datos['personal']              = $this->am->conPersonal();

        
        $this->load->view('front_end/agenda/agenimprimir_v', $datos);
    }

    public function repagenda()
    {
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $tipo_lista             =   $this->input->post('tipo_lista_b');
        $tipo_procedimiento     =   $this->input->post('tipo_procedimiento_b');
        $tipo_personal          =   $this->input->post('tipo_personal');
        $fecha_inicial          =   $this->input->post('fecha_inicial');
        $fecha_final            =   $this->input->post('fecha_final');

        // TODOS
        if($tipo_lista == 'all' && $tipo_procedimiento == 'all' && $tipo_personal == 'all')
        {
            $busqueda  =   $this->am->c_todos($fecha_inicial, $fecha_final);
        }

        // X TIPO 
        if($tipo_lista != 'all' && $tipo_procedimiento == 'all' && $tipo_personal == 'all')
        {
            $busqueda  =   $this->am->c_tipolista($fecha_inicial, $fecha_final, $tipo_lista);
        }

        // X TIPO Y PROCEDIMIENTO
        if($tipo_lista != 'all' && $tipo_procedimiento != 'all' && $tipo_personal == 'all')
        {
            $busqueda  =   $this->am->c_procedimiento($fecha_inicial, $fecha_final, $tipo_procedimiento);
        }

        // X PERSONAL + PROCEDIMIENTO
        if($tipo_lista != 'all' && $tipo_procedimiento != 'all' && $tipo_personal != 'all')
        {
            $busqueda  =   $this->am->c_procedimiento_per($fecha_inicial, $fecha_final, $tipo_procedimiento, $tipo_personal);
        }

        // X tipo y PERSONAL 
        if($tipo_lista != 'all' && $tipo_procedimiento == 'all' && $tipo_personal != 'all')
        {
            $busqueda  =   $this->am->c_tipo_pers($fecha_inicial, $fecha_final, $tipo_lista, $tipo_personal);
        }

        // X PERSONAL 
        if($tipo_lista == 'all' && $tipo_procedimiento == 'all' && $tipo_personal != 'all')
        {
            $busqueda  =   $this->am->c_personal($fecha_inicial, $fecha_final, $tipo_personal);
        }

        if($tipo_lista == 'all')
        {
            $nom_tipo   =   'Todos';
        }else
        {
            $c_nom_tipo =   $this->am->c_nom_tipo($tipo_lista);
            foreach($c_nom_tipo as $ntipo)
            {
                $nom_tipo   =   $ntipo['nombre_lptipo'];
            }
        }

        if($tipo_procedimiento == 'all')
        {
            $nom_procedimiento  =   'Todos';
        }else
        {
            $c_nom_procedimiento =   $this->am->c_nom_procedimiento($tipo_procedimiento);
            foreach($c_nom_procedimiento as $nprocedimiento)
            {
                $nom_procedimiento   =   $nprocedimiento['nombre_listap'];
            }   
        }

        if($tipo_personal == 'all')
        {
            $nom_personal   =   'Todos';
        }else
        {
            $c_nom_personal =   $this->am->c_nom_personal($tipo_personal);
            foreach($c_nom_personal as $npersonal)
            {
                $nom_personal   =   $npersonal['nombre'];
            }  
        }
        
        
        // GENERACION DEL REPORTE
        
        //$this->pdf = new PDF_MC_Table();
        $this->pdf = new PDF_MC_Table('L','mm','A4');
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',7);
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,5,5,0,20);
        
        $this->pdf->SetXY(110,5);
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,'Fecha Inicial:',0,0,'L');
        $this->pdf->SetX(160);
        $this->pdf->Cell(20,4,$fecha_inicial,0,0,'L');
        $this->pdf->Ln(4);

        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,utf8_decode('Fecha final:'),0,0,'L');
        $this->pdf->SetX(160);
        $this->pdf->Cell(20,4,$fecha_final,0,0,'L');
    
        $this->pdf->Ln(4);
            
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,utf8_decode('Tipo.:'),0,0,'L');
        $this->pdf->SetX(160);
        $this->pdf->Cell(20,4,utf8_decode($nom_tipo),0,0,'L');
        
        $this->pdf->Ln(4);
        
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,utf8_decode('Procedimiento.:'),0,0,'L');
        $this->pdf->SetX(160);
        $this->pdf->Cell(20,4,utf8_decode($nom_procedimiento),0,0,'L');
        $this->pdf->SetX(175);

        
        $this->pdf->Ln(4);
        
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,utf8_decode('Profesional:'),0,0,'L');
        $this->pdf->SetX(160);
        $this->pdf->Cell(20,4,utf8_decode($nom_personal),0,0,'L');
        $this->pdf->SetX(175);

        $this->pdf->SetX(184);
        
        $this->pdf->Cell(0,10,utf8_decode('Página ').$this->pdf->PageNo().'/{nb}',0,0,'C');
        $this->pdf->Ln(4);


        $this->pdf->SetXY(110,30);
        $this->pdf->SetX(10);
        $this->pdf->Cell(35,4,utf8_decode('Informe de Citas'),0,0,'L');

        $this->pdf->Ln(5);
        
        //$this->pdf->Cell(17, 5, 'Idagenda.', 1, 0, 'C', 0);
        $this->pdf->Cell(17, 5, 'Fecha', 1, 0, 'C', 0);
        $this->pdf->Cell(10, 5, 'H/Inicio', 1, 0, 'C', 0);
        $this->pdf->Cell(35, 5, utf8_decode('Paciente'), 1, 0, 'C', 0);
        $this->pdf->Cell(20, 5, utf8_decode('Identificación'), 1, 0, 'C', 0);
        $this->pdf->Cell(20, 5, utf8_decode('Lateralidad'), 1, 0, 'C', 0);
        $this->pdf->Cell(30, 5, utf8_decode('Procedimiento'), 1, 0, 'C', 0);
        $this->pdf->Cell(30, 5, utf8_decode('Diagnóstico'), 1, 0, 'C', 0);
        $this->pdf->Cell(20, 5, utf8_decode('Teléfonos'), 1, 0, 'C', 0);
        $this->pdf->Cell(35, 5, utf8_decode('EPS'), 1, 0, 'C', 0);
        $this->pdf->Cell(35, 5, utf8_decode('Profesional'), 1, 0, 'C', 0);
        $this->pdf->Cell(30, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
        $this->pdf->Ln();
        
        // DETALLES
        $this->pdf->SetWidths(array(17,10,35,20,20,30,30,20,35,35,30));
        srand(microtime()*1000000);
        $this->pdf->SetAligns(array('L','L','L','L','L','L','L','L','L','L','L'));
        
        
        if($busqueda)
        {
            foreach ($busqueda as $row) 
            {   
                //$id_agenda              =   utf8_decode($row['id_agenda']);
                $fecha              =   utf8_decode($row['fecha']);
                $horainicio         =   utf8_decode($row['horainicio']);
                $paciente           =   utf8_decode($row['primer_nombre']).' '.utf8_decode($row['segundo_nombre']).' '.utf8_decode($row['primer_apellido']).' '.utf8_decode($row['segundo_apellido']);
                $lateralidad        =   utf8_decode($row['lateralidad']) ; 
                $identificacion     =   utf8_decode($row['identificacion']) ; 
                $nom_procedimiento  =   utf8_decode($row['nom_procedimiento']);
                $cie                =   utf8_decode($row['cie']);
                $telefonos          =   utf8_decode($row['telefono_paciente'].' '.$row['celular_paciente']);
                $nombre_admi        =   utf8_decode($row['nombre_admi']);
                $nom_personal       =   utf8_decode($row['nom_personal']);
                $estado             =   utf8_decode($row['observaciones']);
                
                $this->pdf->Row(array($fecha, $horainicio, $paciente,$identificacion, $lateralidad, $nom_procedimiento,$cie,$telefonos,$nombre_admi,$nom_personal, $estado));
            }
        }    
        

        
  
        
        $this->pdf->Output("Reporte agenda fecha inicial: ".$fecha_inicial."a fecha final: ".$fecha_final.".pdf", 'I');


    }

    public function exportaexcelgen()
    {
        $this->load->library('export');
        /*$fechainicial       =   trim($this->input->post('xlsfechainicial'));
        $fechafinal         =   trim($this->input->post('xlsfechafinal'));
        //$tipotrata          =   $this->input->post('tipotrata');
        $tipotrata          =   $this->input->post('xlsplantrata');
        
        
        $consulta           =   $this->am->exportaexcel($fechainicial, $fechafinal, $tipotrata);*/
        $tipo_lista             =   $this->input->post('tipo_lista_b_xls');
        $tipo_procedimiento     =   $this->input->post('tipo_procedimiento_b_xls');
        $tipo_personal          =   $this->input->post('tipo_personal_xls');
        $fecha_inicial          =   $this->input->post('fecha_inicial_xls');
        $fecha_final            =   $this->input->post('fecha_final_xls');

        // TODOS
        if($tipo_lista == 'all' && $tipo_procedimiento == 'all' && $tipo_personal == 'all')
        {
            $busqueda  =   $this->am->c_todos_xls($fecha_inicial, $fecha_final);
        }

        // X TIPO 
        if($tipo_lista != 'all' && $tipo_procedimiento == 'all' && $tipo_personal == 'all')
        {
            $busqueda  =   $this->am->c_tipolista_xls($fecha_inicial, $fecha_final, $tipo_lista);
        }

        // X TIPO Y PROCEDIMIENTO
        if($tipo_lista != 'all' && $tipo_procedimiento != 'all' && $tipo_personal == 'all')
        {
            $busqueda  =   $this->am->c_procedimiento_xls($fecha_inicial, $fecha_final, $tipo_procedimiento);
        }

        // X PERSONAL + PROCEDIMIENTO
        if($tipo_lista != 'all' && $tipo_procedimiento != 'all' && $tipo_personal != 'all')
        {
            $busqueda  =   $this->am->c_procedimiento_per_xls($fecha_inicial, $fecha_final, $tipo_procedimiento, $tipo_personal);
        }

        // X tipo y PERSONAL 
        if($tipo_lista != 'all' && $tipo_procedimiento == 'all' && $tipo_personal != 'all')
        {
            $busqueda  =   $this->am->c_tipo_pers_xls($fecha_inicial, $fecha_final, $tipo_lista, $tipo_personal);
        }

        // X PERSONAL 
        if($tipo_lista == 'all' && $tipo_procedimiento == 'all' && $tipo_personal != 'all')
        {
            $busqueda  =   $this->am->c_personal_xls($fecha_inicial, $fecha_final, $tipo_personal);
        }

        if($tipo_lista == 'all')
        {
            $nom_tipo   =   'Todos';
        }else
        {
            $c_nom_tipo =   $this->am->c_nom_tipo($tipo_lista);
            foreach($c_nom_tipo as $ntipo)
            {
                $nom_tipo   =   $ntipo['nombre_lptipo'];
            }
        }

        if($tipo_procedimiento == 'all')
        {
            $nom_procedimiento  =   'Todos';
        }else
        {
            $c_nom_procedimiento =   $this->am->c_nom_procedimiento($tipo_procedimiento);
            foreach($c_nom_procedimiento as $nprocedimiento)
            {
                $nom_procedimiento   =   $nprocedimiento['nombre_listap'];
            }   
        }

        if($tipo_personal == 'all')
        {
            $nom_personal   =   'Todos';
        }else
        {
            $c_nom_personal =   $this->am->c_nom_personal($tipo_personal);
            foreach($c_nom_personal as $npersonal)
            {
                $nom_personal   =   $npersonal['nombre'];
            }  
        }
        $this->export->to_excel($busqueda, 'Estadisticas'); 
    }

    public function creareventos() 
    {

        if (isset($_POST['vista'])) {
            $vista                  =   $this->input->post('vista');
            $data['fecha_dia']      =   $this->input->post('fecha_dia');
            $data['personal']       =   $this->am->personal();
            $data['spersonal']      =   $this->am->spersonal();
            $data['login']          =   $this->input->post('login');
            $data['hor_inicio']     =   $this->input->post('horainicio');
            // PROCEDIMIENTOS
            $data['procedimientos'] =   $this->am->conProcedimientos();
            $data['clasificacion']  =   $this->am->conClasificacion();
            $data['tipodocumento']  =   $this->am->tipodocumenton(); 
            $this->load->view('front_end/agenda/' . $vista, $data);
        } else {
            
            date_default_timezone_set('America/Bogota');
            $fechaingreso = date("Y-m-d");
            $horaingreso  = date("H:i:s");
           
            $numeroa     = $this->am->consultaconsecutivo(23);

            $data = array(
                'numeroa'           =>  $numeroa,
                'fecha'             =>  $this->input->post('fecha'),
                'horainicio'        =>  $this->input->post('horainicio'),
                'horafin'           =>  $this->input->post('horafinal'),
                'color'             =>  $this->input->post('color'),
                'id_paciente'       =>  $this->input->post('id_paciente'),
                'tipo_docu'         =>  $this->input->post('td'),
                'identificacion'    =>  $this->input->post('identificacion'),
                'primer_nombre'     =>  $this->input->post('primer_nombre'),
                'segundo_nombre'    =>  $this->input->post('segundo_nombre'),
                'primer_apellido'   =>  $this->input->post('primer_apellido'),
                'segundo_apellido'  =>  $this->input->post('segundo_apellido'),
                'telefono_paciente' =>  $this->input->post('telefono'),
                'celular_paciente'  =>  $this->input->post('celular'),
                'id_admi'           =>  $this->input->post('convenio'),
                'email'             =>  $this->input->post('email'),
                'observaciones'     =>  $this->input->post('observaciones'),
                'cod_medi'          =>  $this->input->post('personal'),
                'nom_personal'      =>  $this->input->post('nom_personal'),
                'login'             =>  $this->input->post('islogin'),
                'fechaingreso'      =>  $fechaingreso,
                'horaingreso'       =>  $horaingreso,
                'procedimiento'     =>  $this->input->post('procedimiento'),
                'nom_procedimiento' =>  $this->input->post('nom_procedimiento')
            );
            $respuesta = $this->am->insertAgenda($data, $numeroa);
            
            $m_procedimientos   =   $this->input->post("tprocedim");

            foreach($m_procedimientos as $a)
            {
                $m_proced = array(
                    'numeroa'     =>  $numeroa,
                    'cod_lptipo'    =>  $a['codtipo'],
                    'cod_listap'    =>  $a['codlp'],
                    'id_personal'   =>  $a['idpersonal']);
                $this->am->insertProcedimiento($m_proced);

            }
            
            echo $respuesta;
        }
    }

    public function nueva_cita()
    {
        date_default_timezone_set('America/Bogota');
        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");
       
        $numeroa     = $this->am->consultaconsecutivo(23);

        // procedimientos
        $m_procedimientos   =   $this->input->post("cod_lptipo");

        if($m_procedimientos)
        {
            for ($i = 0; $i < count($this->input->post('cod_lptipo')); $i++) 
            {
                /*$m_proced = array(
                    'numeroa'       =>  $numeroa,
                    'cod_lptipo'    =>  $this->input->post('cod_lptipo')[$i],
                    'cod_listap'    =>  $this->input->post('cod_listap')[$i],
                    'id_personal'   =>  $this->input->post('id_personal')[$i]);
                $this->am->insertProcedimiento($m_proced);*/
                $data = array(
                    'numeroa'           =>  $numeroa,
                    'fecha'             =>  $this->input->post('fecha_dia_semana'),
                    'horainicio'        =>  $this->input->post('horainicio')[$i],
                    'horafin'           =>  $this->input->post('horafin')[$i],
                    'color'             =>  $this->input->post('color'),
                    'id_paciente'       =>  $this->input->post('rs_id_paciente'),
                    'tipo_docu'         =>  $this->input->post('rs_td'),
                    'identificacion'    =>  $this->input->post('rs_identificacion'),
                    'primer_nombre'     =>  $this->input->post('rs_primernombre'),
                    'segundo_nombre'    =>  $this->input->post('rs_segundonombre'),
                    'primer_apellido'   =>  $this->input->post('rs_primerapellido'),
                    'segundo_apellido'  =>  $this->input->post('rs_segundoapellido'),
                    'telefono_paciente' =>  $this->input->post('rs_telefono'),
                    'celular_paciente'  =>  $this->input->post('rs_celular'),
                    'id_admi'           =>  $this->input->post('rs_id_admi'),
                    'email'             =>  $this->input->post('rs_email'),
                    'observaciones'     =>  $this->input->post('observaciones'),
                    'cod_medi'          =>  $this->input->post('id_personal')[$i],
                    'nom_personal'      =>  $this->input->post('nombre_profesional')[$i],
                    'login'             =>  $this->input->post('login'),
                    'fechaingreso'      =>  $fechaingreso,
                    'horaingreso'       =>  $horaingreso,
                    'cod_lptipo'        =>  $this->input->post('cod_lptipo')[$i],
                    'cod_listap'        =>  $this->input->post('cod_listap')[$i],
                    'id_personal'       =>  $this->input->post('id_personal')[$i]
                    //'procedimiento'     =>  $this->input->post('cod_listap')[$i],
                    //'nom_procedimiento' =>  $this->input->post('nombre_procedimiento')
                );
                $respuesta = $this->am->insertAgenda($data, $numeroa);
            }
        }
        echo $respuesta;
    }

    public function nueva_cita_vista()
    {
        $datos['login']             =   $this->input->post('login', true);
        $datos['nue_fecha']         =   $this->input->post('nue_fecha', true);
        //$datos['nue_horainicio']    =   $this->input->post('nue_horainicio', true);
        //$datos['nue_horafinal']     =   $this->input->post('nue_horafinal', true);

        $datos['spersonal']             =   $this->am->spersonal();
        // PROCEDIMIENTOS
        //$datos['procedimientos']        =   $this->am->conProcedimientos();
        $datos['tipodocumento']         =   $this->am->tipodocumenton(); 
        $datos['clasificacion']         =   $this->am->conClasificacion();


        $this->load->view('front_end/agenda/nuevo_evento_v', $datos);
    }

    public function updateevento() {
        $id = $this->input->post('id');
        $data = array(
            'fecha'      => $this->input->post('fecha'),
            'horainicio' => $this->input->post('horainicio'),
            'horafin'    => $this->input->post('horafin'),
        );
        $result = $this->am->update($data, $id);
        return $result;
    }
    public function detalle() {
        $vista                  = $this->input->post('vista');
        $id                     = $this->input->post('id');
        $c_agenda               = $this->am->c_agenda($id);
        foreach($c_agenda as $ca)
        {
            $data['numeroa']    =   $ca['numeroa'];
        }

        $data['id_agenda']      =   $id;
        $data['datos']          =   $this->am->conEditar($id);
        $data['pagenda']        =   $this->am->conPAgenda($id);
        $data['spersonal']      =   $this->am->spersonal();
        $data['procedimientos'] =   $this->am->conProcedimientos();
        $data['clasificacion']  =   $this->am->conClasificacion();
        $data['tipodocumento']  =   $this->am->tipodocumenton(); 
        $data['especialidad']   =   $this->am->especialidad();
        $data['lateralidad']    =   $this->am->lateralidad_g();


        $this->load->view('front_end/agenda/' . $vista, $data);
    }

    public function actualizar_cita_vista() {
        $vista                  = 'actualizar_evento_v';
        $id                     = $this->input->post('id');
        $data['login']          = $this->input->post('login');
        $c_agenda               = $this->am->c_agenda($id);
        foreach($c_agenda as $ca)
        {
            $data['numeroa']    =   $ca['numeroa'];
        }

        $data['id_agenda']      =   $id;

        // consulta si hay factura
        $datos                  =   $this->am->conEditar($id);
        if($datos)
        {
            //foreach($datos as $dat)
            //{
                $n_estado = $datos->estado;
                if($n_estado !='')
                {
                    $cons_facturas = $this->am->cons_facturas($id);
                    $data['cons_facturas'] = $this->am->cons_facturas($id);

                    if($cons_facturas)
                    {
                        foreach($cons_facturas as $cfac)
                        {
                            $data['c_factura']          =   $cfac['numero_docu'];
                            $data['c_fechaingreso']     =   $cfac['fechaingreso'];
                            $data['c_horaingreso']      =   $cfac['horaingreso'];
                            $data['c_autorizacion']      =   $cfac['autorizacion'];
                        }
                    }
                    $data['cons_facturas'] = $this->am->cons_facturas($id);
                }
            //}
        }




        $data['datos']          =   $this->am->conEditar($id);

        /*$dato_cita              =   $this->am->conEditar($id);
        foreach($dato_cita as $dc)
        {
            $cod_lptipo         =   $dc->cod_lptipo;
            $cod_listap         =   $dc->cod_listap;
            // consulta del tipo de indice
            //$datos['c_cod_lptipo']  =   
        }*/
        $data['pagenda']        =   $this->am->conPAgenda($id);
        $data['spersonal']      =   $this->am->spersonal();
        $data['procedimientos'] =   $this->am->conProcedimientos();
        $data['clasificacion']  =   $this->am->conClasificacion();
        $data['tipodocumento']  =   $this->am->tipodocumenton(); 
        $data['especialidad']   =   $this->am->especialidad();
        $data['lateralidad']    =   $this->am->lateralidad_g();
        $data['convenio_eps']   =   $this->am->conConvenioEps();
        $data['contratistas']   =   $this->am->conContratistas();


        $this->load->view('front_end/agenda/' . $vista, $data);
    }

    // actualizar agenda
    public function actualizar_cita_n()
    {
        date_default_timezone_set('America/Bogota');
        $fecha_mod = date("Y-m-d");
        $hora_mod  = date("H:i:s");

        $id_agenda      =   $this->input->post('id_agenda', true);
        $fecha          =   $this->input->post('fechacita', true);
        $horainicio     =   $this->input->post('horainicio_n', true);
        $horafin        =   $this->input->post('horafinal_n', true);
        $cod_lptipo     =   $this->input->post('clasificacion', true);
        $procedimiento  =   $this->input->post('procedimiento', true);
        $personal       =   $this->input->post('personal', true);
        $observaciones  =   $this->input->post('mpobservaciones', true);

        $login          =   $this->input->post('login', true);
        $m_cita         =   array(
            'id_agenda'     =>  $id_agenda,
            'fecha'         =>  $fecha,
            'horainicio'    =>  $horainicio,
            'horafin'       =>  $horafin,
            'cod_medi'      =>  $personal,
            'observaciones' =>  $observaciones,
            'procedimiento' =>  $procedimiento,
            'color'         =>  '#5348d4',
            'login_mod'     =>  $login,
            'fecha_mod'     =>  $fecha_mod,
            'hora_mod'      =>  $hora_mod,
            'cod_lptipo'    =>  $cod_lptipo,
            'cod_listap'    =>  $procedimiento,
            'id_personal'   =>  $personal
        );

        $update_cita    =   $this->am->update_cita($m_cita, $id_agenda);
        return $update_cita;

    }

    public function carga_procedimiento()
    {
        $bd_cod_lptipo = $this->input->post('bd_cod_lptipo', true);
        $datos['c_procedimiento_tipo']  =   $this->am->c_procedimiento_tipo($bd_cod_lptipo);
        $this->load->view('front_end/agenda/consulta_procedimientos_v', $datos);        
    }

    public function consulta_mod()
    {
        $login_modificar    =   $this->input->post('login_modificar');
        $c_login_mod        =   $this->am->c_login_mod($login_modificar);
    }

    
    public function actualizareventos()
    {
        date_default_timezone_set('America/Bogota');
        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");
       
        $id_agenda     = $this->input->post('id_agenda');
        $data = array(
            'fecha'             =>  $this->input->post('fecha'),
            'horainicio'        =>  $this->input->post('horainicio'),
            'horafin'           =>  $this->input->post('horafinal'),
            'color'             =>  $this->input->post('color'),
            'cod_medi'          =>  $this->input->post('personal'),
            'nom_personal'      =>  $this->input->post('nom_personal'),
            'login'             =>  $this->input->post('islogin'),
            'fechaingreso'      =>  $fechaingreso,
            'horaingreso'       =>  $horaingreso,
            'procedimiento'     =>  $this->input->post('procedimiento'),
            'nom_procedimiento' =>  $this->input->post('nom_procedimiento')
        );
        $update_cita = $this->am->update_cita($data, $id_agenda);
        
        // eliminando registros en la tabla agenda_procedimiento
        $numeroa                =   $this->input->post('numeroa');
        $delete_aproc           =   $this->am->delete_aproc($numeroa);
        $m_procedimientos       =   $this->input->post("tprocedim");

        foreach($m_procedimientos as $a)
        {
            $m_proced = array(
                'numeroa'       =>  $numeroa,
                'cod_lptipo'    =>  $a['codtipo'],
                'cod_listap'    =>  $a['codlp'],
                'id_personal'   =>  $a['idpersonal']);
            $this->am->insertProcedimiento($m_proced);

        }
        
        echo $update_cita;
    }

    public function updateEstado() 
    {
        $id                 =   $this->input->post('id');
        $estado             =   (int) $this->input->post('estado');
        $id_paciente        =   $this->input->post('id_paciente');
        $observaciones_cita =   $this->input->post('observaciones_cita', true);
        $tipo_paciente      =   $this->input->post('tipo_paciente', true);
         
        
        date_default_timezone_set('America/Bogota');
        $fecha = date("Y") . '-' . date("m") . '-' . date("d");
        $hora  = date("H") . ':' . date("i") . ':' . date("s");
        
        if ($estado === 1) 
        {
            $data     = array(
                'estado'                =>  'Asistio',
                'observaciones_cita'    =>  $observaciones_cita,
                'tipo_paciente'         =>  $tipo_paciente,
                'color'                 =>  '#f6ff4c'
            );
            $msg      = 'Asistió';

            // CONSULTAR EL NUMEROA
            $c_numeroa      =   $this->am->c_numeroa($id);
            foreach($c_numeroa as $cnum)
            {
                $numeroa    =   $cnum['numeroa'];
            }

            // consulta de la agenda procedimientos
            $c_proc         =   $this->am->c_proc($numeroa);
            foreach($c_proc as $cpr)
            {
                $id_personal=   $cpr['id_personal'];
                $cod_listap =   $cpr['cod_listap'];
                $cod_medi   =   $cpr['codigo'];

                $dingreso = array(
                'fecha'          => $fecha,
                'id_paciente'    => $id_paciente,
                'hinicioagenda'  => $hora,
                'procedimiento'  => $cod_listap,
                'cod_medi'       => $cod_medi
                );
                $insertarruta = $this->am->insertarrutaagen($dingreso);  
            }

            
        } else {
            $data = array(
                'estado' => 'Cancelo',
                'observaciones_cita'    =>  $observaciones_cita
            );
            $msg  = 'Cancelo';
        }
        $insert = $this->am->update($data, $id);
        if ($update) {
            InsRuta($id);
            echo "El estado cambio a " . $msg;
        } else {
            echo "Error no se a podido realizar la acción";
        }
    }

    // asiste particular
    public function asiste_particular() 
    {
        $id                 =   $this->input->post('id');
        $estado             =   (int) $this->input->post('estado');
        $id_paciente        =   $this->input->post('id_paciente');
        $observaciones_cita =   $this->input->post('observaciones_cita', true);
        $tipo_paciente      =   $this->input->post('tipo_paciente', true);
        $color              =   $this->input->post('color', true);
         
        date_default_timezone_set('America/Bogota');
        $fecha = date("Y") . '-' . date("m") . '-' . date("d");
        $hora  = date("H") . ':' . date("i") . ':' . date("s");
        
        
        $data     = array(
            'estado'                =>  'Asistio',
            'observaciones_cita'    =>  $observaciones_cita,
            'tipo_paciente'         =>  $tipo_paciente,
            'color'                 =>  $color
        );
        $insert = $this->am->update($data, $id);

        /*$msg      = 'Asistió';

        // CONSULTAR EL NUMEROA
        $c_numeroa      =   $this->am->c_numeroa($id);
        foreach($c_numeroa as $cnum)
        {
            $numeroa    =   $cnum['numeroa'];
        }

        // consulta de la agenda procedimientos
        /*$c_proc         =   $this->am->c_proc($numeroa);
        foreach($c_proc as $cpr)
        {
            $id_personal=   $cpr['id_personal'];
            $cod_listap =   $cpr['cod_listap'];
            $cod_medi   =   $cpr['codigo'];

            $dingreso = array(
            'fecha'          => $fecha,
            'id_paciente'    => $id_paciente,
            'hinicioagenda'  => $hora,
            'procedimiento'  => $cod_listap,
            'cod_medi'       => $cod_medi
            );
            $insertarruta = $this->am->insertarrutaagen($dingreso);  
        }*/

            
        
        
        
    }

    // asiste particular
    public function no_asiste_particular() 
    {
        $id                 =   $this->input->post('id');
        $estado             =   (int) $this->input->post('estado');
        $id_paciente        =   $this->input->post('id_paciente');
        $observaciones_cita =   $this->input->post('observaciones_cita', true);
        $tipo_paciente      =   $this->input->post('tipo_paciente', true);
        $color              =   $this->input->post('color', true);
        $estado             =   $this->input->post('estado', true);
         
        date_default_timezone_set('America/Bogota');
        $fecha = date("Y") . '-' . date("m") . '-' . date("d");
        $hora  = date("H") . ':' . date("i") . ':' . date("s");
        
        
        $data     = array(
            'estado'                =>  $estado,
            'observaciones_cita'    =>  $observaciones_cita,
            'tipo_paciente'         =>  $tipo_paciente,
            'color'                 =>  $color
        );
        $insert = $this->am->update($data, $id);

        /*$msg      = 'Asistió';

        // CONSULTAR EL NUMEROA
        $c_numeroa      =   $this->am->c_numeroa($id);
        foreach($c_numeroa as $cnum)
        {
            $numeroa    =   $cnum['numeroa'];
        }

        // consulta de la agenda procedimientos
        /*$c_proc         =   $this->am->c_proc($numeroa);
        foreach($c_proc as $cpr)
        {
            $id_personal=   $cpr['id_personal'];
            $cod_listap =   $cpr['cod_listap'];
            $cod_medi   =   $cpr['codigo'];

            $dingreso = array(
            'fecha'          => $fecha,
            'id_paciente'    => $id_paciente,
            'hinicioagenda'  => $hora,
            'procedimiento'  => $cod_listap,
            'cod_medi'       => $cod_medi
            );
            $insertarruta = $this->am->insertarrutaagen($dingreso);  
        }*/

            
        
        
        
    }


    public function updateEstado_Cups() 
    {
        $id                     =   $this->input->post('id');
        $estado                 =   (int) $this->input->post('estado', true);
        $id_paciente            =   $this->input->post('id_paciente', true);
        $observaciones_cita     =   $this->input->post('observaciones_cita', true);
        $tipo_paciente          =   $this->input->post('no_cups', true); 
        $fecha_autorizacion_n   =   $this->input->post('fecha_autorizacion', true);
        $medico                 =   $this->input->post('cod_medi', true);
        $color                  =   $this->input->post('color', true);


        list($d, $m, $Y) = explode("/", $fecha_autorizacion_n);
        $fecha_autorizacion        = $Y . '-' . $m . '-' . $d;
        
        date_default_timezone_set('America/Bogota');
        $fecha = date("Y") . '-' . date("m") . '-' . date("d");
        $hora  = date("H") . ':' . date("i") . ':' . date("s");
        
        if ($estado === 1) {
            $data     = array(
                'estado'                =>  'Asistio',
                'color'                 =>  $color,
                'observaciones_cita'    =>  $observaciones_cita,
                'tipo_paciente'         =>  $tipo_paciente
                );
            $msg      = 'Asistió';

            // CONSULTAR EL NUMEROA
            $c_numeroa      =   $this->am->c_numeroa($id);
            foreach($c_numeroa as $cnum)
            {
                $numeroa    =   $cnum['numeroa'];
            }

            // consulta de la agenda procedimientos
            $c_proc         =   $this->am->c_proc($numeroa);
            foreach($c_proc as $cpr)
            {
                $id_personal=   $cpr['id_personal'];
                $cod_listap =   $cpr['cod_listap'];
                $cod_medi   =   $cpr['codigo'];

                $dingreso = array(
                'fecha'          => $fecha,
                'id_paciente'    => $id_paciente,
                'hinicioagenda'  => $hora,
                'procedimiento'  => $cod_listap,
                'cod_medi'       => $cod_medi
                );
                $insertarruta = $this->am->insertarrutaagen($dingreso);  
            }

            
        } 

        $insert         =   $this->am->update($data, $id);

        // facturacion encabezado
        // consulta consecutivo de facturacion y suma uno
        
        $numero_docu    =   $this->am->consultaconsecutivo(2);
        $ref_procesos   =   'FA';
        $valor_bruto    =   $this->input->post('total_cups', true);
        $porc_copago    =   $this->input->post('porc_copago', true);
        $valor_copago   =   $this->input->post('valor_copago', true);
        $valor_total    =   $this->input->post('total_saldo', true);
        $documento_ref  =   $id;
        $login_ing      =   $this->input->post('login_ing', true);
        $id_admi        =   $this->input->post('id_admi', true);
        $autorizacion   =   $this->input->post('autorizacion', true);
        $aplica_copago  =   $this->input->post('aplica_copago', true);

        $seccional      =   $this->input->post('seccional', true);
        $contrato       =   $this->input->post('contrato', true);
        $nivel          =   $this->input->post('nivel', true);
        $historia       =   $this->input->post('historia', true);
        $carne          =   $this->input->post('carne', true);

        // EDAD
        $fecha_nacimiento   =   $this->input->post('fecha_nacimiento', true);
        $cumpleanos         =   new DateTime($fecha_nacimiento);
        $hoy                =   new DateTime();
        $annos              =   $hoy->diff($cumpleanos);
        $edad               =   $annos->y;
        

        $m_encabezado   =   array(
            'ref_procesos'          =>  $ref_procesos,
            'numero_docu'           =>  $numero_docu,
            'id_paciente'           =>  $id_paciente,
            'valor_bruto'           =>  $valor_bruto,
            'porc_copago'           =>  $porc_copago,
            'valor_copago'          =>  $valor_copago,
            'valor_total'           =>  $valor_total,
            'documento_ref'         =>  $documento_ref,
            'fechaingreso'          =>  $fecha,
            'horaingreso'           =>  $hora,
            'login_ing'             =>  $login_ing,
            'proceso_ref'           =>  'AG',
            'id_admi'               =>  $id_admi,
            'autorizacion'          =>  $autorizacion,
            'observaciones_cita'    =>  $observaciones_cita,
            'aplica_copago'         =>  $aplica_copago,
            'tipo_paciente'         =>  $tipo_paciente,
            'fecha_autorizacion'    =>  $fecha_autorizacion,
            'procesada'             =>  'NO',
            'edad'                  =>  $edad,
            'cod_medi'              =>  $medico,
            'seccional'             =>  $seccional,
            'contrato'              =>  $contrato,
            'nivel'                 =>  $nivel,
            'historia'              =>  $historia,
            'carne'                 =>  $carne
        );
        $this->am->insertEncabezadoFact($m_encabezado, $numero_docu);

        // detalles de la facturacion cie
        $m_cie     =   $this->input->post("datos_cie");

        foreach($m_cie as $b)
        {
            $m_proced_cie = array(
                'id_paciente'           =>  $id_paciente,
                'numero_docu'           =>  $numero_docu,
                'ref_procesos'          =>  $ref_procesos,
                'documento_ref'         =>  $documento_ref,
                'proceso_ref'           =>  'AG',
                'cod_cie'               =>  $b['cod_cie'],
                'nombre_cie'            =>  $b['nombre_cie'],
                'fechaingreso'          =>  $fecha,
                'horaingreso'           =>  $hora,
                'login_ing'             =>  $login_ing,
                'fecha_autorizacion'    =>  $fecha_autorizacion,
                'id_admi'               =>  $id_admi,
                'procesada'             =>  'NO'
                );
            $this->am->insertDetallesFact($m_proced_cie);

        }

        // detalles de la facturacion cups
        $m_cups     =   $this->input->post("datos_cups");

        foreach($m_cups as $a)
        {
            $m_proced = array(
                'id_paciente'           =>  $id_paciente,
                'numero_docu'           =>  $numero_docu,
                'ref_procesos'          =>  $ref_procesos,
                'documento_ref'         =>  $documento_ref,
                'id_cups'               =>  $a['id_cups'],
                'cod_cups'              =>  $a['cod_cups'],
                'nombre_cups'           =>  $a['nombre_cups'],
                'valor_cups'            =>  $a['valor_cups'],
                'valor_cups_t'          =>  $a['valor_cups_total'],
                'porc_copago'           =>  $a['porc_copago'],
                'valor_copago'          =>  ($a['valor_cups_total'] * $a['porc_copago'])/100, 
                'fechaingreso'          =>  $fecha,
                'horaingreso'           =>  $hora,
                'login_ing'             =>  $login_ing,
                'autorizacion'          =>  $autorizacion,
                'fecha_autorizacion'    =>  $fecha_autorizacion,
                'id_admi'               =>  $id_admi,
                'proceso_ref'           =>  'AG',
                'lateralidad'           =>  $a['lateralidad'],
                'cantidad'              =>  $a['cantidad'],
                'valor_cups_total'      =>  $a['valor_cups_total'] - (($a['valor_cups_total'] * $a['porc_copago'])/100),
                'procesada'             =>  'NO'
                );
            $this->am->insertDetallesFact($m_proced);

        }

        
    }

    public function actualizar_agenda()
    {
        date_default_timezone_set('America/Bogota');
        $fecha_mod = date("Y-m-d");
        $hora_mod  = date("H:i:s");

        $fecha              =   $this->input->post('fechacita', true);
        $horainicio         =   $this->input->post('horainicio', true);
        $horafin            =   $this->input->post('horafinal', true); 
        $id_agenda          =   $this->input->post('id_agenda', true);
        $login_mod          =   $this->input->post('login_mod', true);
        $numeroa            =   $this->input->post('numeroa', true);
        $color              =   $this->input->post('color', true);        
        $nom_personal       =   $this->input->post('nom_personal', true);
        $observaciones      =   $this->input->post('observaciones', true);                  
        $procedimiento      =   $this->input->post('procedimiento', true);
        $nom_procedimiento  =   $this->input->post('nom_procedimiento', true);

        

        // CUANDO TIENE CAMBIOS EN LOS PROCEDIMIENTOS
        $m_procedimientos   =   $this->input->post("tprocedim");
        if($m_procedimientos)
        {
            // elimina los registros de agendra procesos del numeroa
            $delete_aproc   =   $this->am->delete_aproc($numeroa);
            $data   =   array(
            'fecha'             =>  $fecha,
            'horainicio'        =>  $horainicio,
            'horafin'           =>  $horafin,
            'login_mod'         =>  $login_mod,
            'fecha_mod'         =>  $fecha_mod,
            'hora_mod'          =>  $hora_mod,
            'color'             =>  $color,
            'nom_personal'      =>  $nom_personal,
            'observaciones'     =>  $observaciones,
            'procedimiento'     =>  $procedimiento,
            'nom_procedimiento' =>  $nom_procedimiento
            );

        $update_cita    =   $this->am->update_cita($data, $id_agenda);
        }else
        {
            $data   =   array(
            'fecha'             =>  $fecha,
            'horainicio'        =>  $horainicio,
            'horafin'           =>  $horafin,
            'login_mod'         =>  $login_mod,
            'fecha_mod'         =>  $fecha_mod,
            'hora_mod'          =>  $hora_mod
            );

        $update_cita    =   $this->am->update_cita($data, $id_agenda);
        }

        foreach($m_procedimientos as $a)
        {
            $m_proced = array(
                'numeroa'       =>  $numeroa,
                'cod_lptipo'    =>  $a['codtipo'],
                'cod_listap'    =>  $a['codlp'],
                'id_personal'   =>  $a['idpersonal']);
            $this->am->insertProcedimiento($m_proced);

        } 
         
        return $update_cita;

    }

    public function InsRuta($id) {}
    public function eliminarEvento() {
        $id     = $this->input->post('id');
        $delete = $this->am->delete($id);
        if ($delete) {
            echo "Evento eliminado con éxito!";
        } else {
            echo "Ha ocurrido un error";
        }
    }
    public function consultapaciente() {
        $this->load->library('Datatables');
        $busqueda = $this->input->post('busqueda');
        $this->datatables->select("p.id_paciente, p.primer_nombre,p.segundo_nombre,p.primer_apellido,p.segundo_apellido,p.tipo_docu,p.identificacion,p.telefono_paciente,p.celular_paciente, p.email_paciente, p.id_admi, c.nombre_admi")->from('pacientes p');
        $this->db->like("p.primer_nombre", $busqueda)
             ->or_like('p.segundo_nombre', $busqueda)
             ->or_like('p.primer_apellido', $busqueda)
             ->or_like('p.segundo_apellido', $busqueda)
             ->or_like('p.identificacion', $busqueda)
             ->or_like('p.telefono_paciente', $busqueda)
             ->or_like('p.celular_paciente', $busqueda);

        $this->db->join('contratistas c', 'c.id_contratistas = p.id_admi');
        echo $this->datatables->generate();
    }

    /*public function consultapaciente() {
        $this->load->library('Datatables');
        $busqueda = $this->input->post('busqueda');
        $this->datatables->select("id_paciente, primer_nombre,segundo_nombre,primer_apellido,segundo_apellido,tipo_docu,identificacion,telefono_paciente,celular_paciente, email_paciente")->from('pacientes');
        $this->db->like("primer_nombre", $busqueda)
             ->or_like('segundo_nombre', $busqueda)
             ->or_like('primer_apellido', $busqueda)
             ->or_like('segundo_apellido', $busqueda)
             ->or_like('identificacion', $busqueda)
             ->or_like('telefono_paciente', $busqueda)
             ->or_like('celular_paciente', $busqueda);

        echo $this->datatables->generate();
    }*/
    public function paciente() {
        if (isset($_POST['vista'])) {
            $vista = $this->input->post('vista');
            $this->load->view('front_end/agenda/' . $vista);
        } else {
        }
    }
    public function nuevaagenda() 
    {
        // DATOS PACIENTE
        $id_usuario      = $this->input->post('histid', true);
        $persona_atiende = $this->am->persona_atiende($id_usuario);
        foreach ($persona_atiende as $persona) {
            $datos['cod_persona_atie'] = $persona['cod_persona_atie'];
            $nombre_persona_atie       = $persona['nombre_persona_atie'];
            $datos['login']            = $persona['login'];
        }
        $datos['id_usuario']   = $id_usuario;
        $datos['histlogin']    = $this->input->post('histlogin');
        $datos['consultorios'] = $this->am->consultorios();
        // PROCEDIMIENTOS
        $datos['procedimientos'] = $this->am->conProcedimientos();
        // CONSULTA DE PACIENTE
        $id_paciente                    =   $this->input->post('id_paciente');
        $cpaciente                      =   $this->am->cpaciente($id_paciente);
        //var_dump($this->am->cpaciente($id_paciente));
        //exit();

        foreach($cpaciente as $pac)
        {
            date_default_timezone_set('America/Bogota');
            $datos['fechaactual'] = date("Y-m-d");
            $datos['horaactual']  = date("H:i:s");
            
            // DATOS DEL PACIENTE
            $datos['id_paciente']           =   $id_paciente;
            $datos['bd_tipo_docu']          =   $pac['tipo_docu'];
            $datos['bd_identificacion']     =   $pac['identificacion'];
            $datos['bd_primer_nombre']      =   $pac['primer_nombre'];
            $datos['bd_segundo_nombre']     =   $pac['segundo_nombre'];
            $datos['bd_primer_apellido']    =   $pac['primer_apellido'];
            $datos['bd_segundo_apellido']   =   $pac['segundo_apellido'];
            $datos['bd_id_admi']            =   $pac['id_admi'];
            $datos['bd_nombre_admi']        =   $pac['nombre_admi'];
            $datos['bd_telefono_paci']      =   $pac['telefono_paciente'];
            $datos['bd_celular_paci']       =   $pac['celular_paciente'];
        }  
        $datos['convenios']             =   $this->am->convenios();     

        $datos['entero']                = $this->am->entero();
        
        $this->load->view('front_end/agenda/ageningreso_v', $datos);
    }
    public function ingresopacienteagen() 
    {
        $this->load->library('imagenes');
        date_default_timezone_set('America/Bogota');
        
        $this->load->model('agenda_model');
                
        $numeroc     = $this->agenda_model->consultaconsecutivo(10);

        //
        $this->load->library('imagenes');

        date_default_timezone_set('America/Bogota');

        $this->load->model('historia_model');
        $numeroc     = $this->historia_model->consultaconsecutivo(10);
        $n_conexamen = $this->historia_model->consultaconsecutivo(7);
        $fechan      = $this->input->post('fechanacimiento', true);

        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");

        $ma              = 12;
        $edadpaciente    = '';
        $totaldiasmes    = '';
        list($d, $m, $Y) = explode("/", $fechan);
        $fechanac        = $Y . '-' . $m . '-' . $d;
        $edadpaciente    = (date("md") < $m . $d ? date("Y") - $Y - 1 : date("Y") - $Y);
        $edadpaciente    = intval($edadpaciente);
        $mn              = intval($m);
        $dn              = intval($d);
        $mesactual       = intval(date("m"));
        $diaactual       = intval(date("d"));
        $mesanterior     = '';
        $anocomp         = '';
        $anoactual       = intval(date("Y"));
        $anon            = $Y;
        $ume             = '';

        if ($mn === 2) {
            $totaldiasmes = 28;
        }

        if ($dn === 31) {
            $dn = $dn - 1;
        }

        if ($mn === 2 && $dn >= 29) {
            $dn = 28;
        }

        if ($edadpaciente === 0) {

            if ($mesactual === 1) {
                $mesanterior = 12;
            } else {
                $mesanterior = $mesactual - 1;
            }

            if ($mesanterior === $mn || $mn === $mesactual) {

                if ($mn === $mesactual) {
                    $edadresultado = $diaactual - $dn;
                } else {
                    $edadresultado = $diaactual + 30 - $dn;
                }

                if ($edadresultado >= 31) {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                } else {
                    $edad = $edadresultado;
                    $ume  = 3;
                }

            } else {
                $anocomp = $anoactual - 1;

                if ($anocomp === $anon) {
                    $edad = 12 - $mn + $mesactual;
                    $ume  = 2;
                } else {
                    $edad = $mesactual - $mn;
                    $ume  = 2;
                }

            }

        } else {
            $edad = $edadpaciente;
            $ume  = 1;
        }

        if ($ume === '1') {
            $complementoano = 'años';
        } elseif ($ume === '2') {
            $complementoano = 'meses';
        } else {
            $complementoano = 'días';
        }

        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");

        /**
         * Subir firmas y foto
         */

        /*$firma_paciente    = $this->imagenes->base64_img($this->input->post('firmapaciente1'));
        $up_firma_paciente = $this->imagenes->uploads3($firma_paciente, "np_fp_" . uniqid($this->input->post('identificacion', true) . "_", true));

        $firma_medico    = $this->imagenes->base64_img($this->input->post('firmamedico1'));
        $up_firma_medico = $this->imagenes->uploads3($firma_medico, "np_fm_" . uniqid($this->input->post('identificacion', true) . "_", true));

        
        
        if (empty($this->input->post('nfoto'))) {
            $foto    = $this->imagenes->Upload('foto');
            $up_foto = $this->imagenes->uploads3($foto, "np_ft_" . uniqid($this->input->post('identificacion', true) . "_", true));
        } else {
            $foto    = $this->imagenes->base64_img($this->input->post('nfoto'));
            $up_foto = $this->imagenes->uploads3($foto, "np_ft_" . uniqid($this->input->post('identificacion', true) . "_", true));
        }*/

        
        $paciente = [
            'id_historia'         => $numeroc,
            'tipo_docu'           => $this->input->post('tipoidentificacion', true),
            'identificacion'      => $this->input->post('identificacion', true),
            'primer_nombre'       => strtoupper($this->input->post('1nombre', true)),
            'segundo_nombre'      => strtoupper($this->input->post('2nombre', true)),
            'primer_apellido'     => strtoupper($this->input->post('1apellido', true)),
            'segundo_apellido'    => strtoupper($this->input->post('2apellido', true)),
            'sigla_sexo'          => $this->input->post('sexo', true),
            'tipo_medida_edad'    => $ume,
            'edad'                => $edad,
            'fecha_de_nacimiento' => $fechanac,
            'cod_estado_civi'     => $this->input->post('estadocivil', true),
            'telefono_paciente'   => $this->input->post('telefonofijo', true),
            'celular_paciente'    => $this->input->post('celular', true),
            'cod_grupo_sang'      => $this->input->post('rh', true),
            'cod_pais'            => $this->input->post('pais', true),
            'id_depa'             => $this->input->post('departamento', true),
            'id_muni'             => $this->input->post('ciudad', true),
            'direccion_paci'      => $this->input->post('direccion', true),
            'email_paciente'      => $this->input->post('email', true),
            'eps'                 => $this->input->post('eps', true),
            'cod_zona_resi'       => $this->input->post('zonaresidencia', true),
            'cod_tipo_usua'       => $this->input->post('tipousuario', true),
            'fechaingreso'        => $fechaingreso,
            'horaingreso'         => $horaingreso,
            'login_ing'           => $this->input->post('login', true),
            'referidopor'         => $this->input->post('referidopor', true),
            'facebook'            => $this->input->post('facebook', true),
            'religion'            => $this->input->post('religion', true),
            'nombre_acom'         => $this->input->post('nombreacom', true),
            'telefono_acom'       => $this->input->post('telacom', true),
            'celular_acom'        => $this->input->post('celular_acom', true),
            'parentescoacom'      => $this->input->post('parentescoacom', true),
            'nombre_acu'          => $this->input->post('nombre_acu', true),
            'telefono_acu'        => $this->input->post('telefono_acu', true),
            'celular_acu'         => $this->input->post('celular_acu', true),
            'parentescoacu'       => $this->input->post('parentescoacu', true),
            'nconsulta'           => $numeroc,
            'barrio'              => $this->input->post('localidad', true),
            'cod_consultorio'     => $this->input->post('consultorios', true),
            'ocupacion'           => $this->input->post('ocupacion', true),
            'cod_medi'            => $this->input->post('medico', true),
            'firmapaci'           => $this->input->post('firmapaciente1', true),
            'firmamedi'           => $this->input->post('firmamedico1'),
            'imagenfoto'          => $this->input->post('nfoto', true),
            'autorizadatos'       => $this->input->post('autorizadatos', true),
            'id_admi'             => $this->input->post('convenios', true)
        ];

                
        $inserPaciente = $this->agenda_model->ingresopaciente($paciente, $numeroc);
        // INSERTAR ENCABEZADO
        $id_paciente    = (int) $this->agenda_model->id_Paciente($this->input->post('tipoidentificacion', true), $this->input->post('identificacion', true));
        $datencabezadon = array(
            'ref_procesos'          =>  'GN',
            'documento_ref'         =>  '',
            'id_paciente'           =>  $id_paciente,            
            'fechaingreso'          =>  $fechaingreso,
            'horaingreso'           =>  $horaingreso,
            'login_ing'             =>  $this->input->post('login', true)
            );
        $insertarEncabezado =   $this->agenda_model->insertarencabezado($datencabezadon);
        $idagenda = $this->input->post('idagenda');
        $agenda = [
            'id_paciente'      => $id_paciente,
            'identificacion'   => $this->input->post('identificacion', true),
            'primer_nombre'    => $this->input->post('1nombre', true),
            'segundo_nombre'   => $this->input->post('2nombre', true),
            'primer_apellido'  => $this->input->post('1apellido', true),
            'segundo_apellido' => $this->input->post('2apellido', true),
            'estado'           => 'Asistio',
            'id_admi'             => $this->input->post('convenios', true)
        ];

        $update_agenda_ev = $this->agenda_model->update($agenda, $idagenda);

        // CONSULTA DE PACIENTE NUEVO
        $this->load->library('s3');

        $nevolucion                 =   '0';
        $datos['paciente']          =   $this->agenda_model->cipaciente($id_paciente);
        
        $datos['datos']             =   $this->agenda_model->conEditar($idagenda);
        $datos['contratistas']      =   $this->agenda_model->conContratistas();

        //$this->load->view('front_end/agenda/pacienteingreso_r_v', $datos);
        // carga la tabla de registro de paciente en cita asignada
        $this->load->view('front_end/agenda/tabla_paciente_nuevo_cita_v', $datos);
        //redirect(base_url().'2agenda/agenda/ingresopacienteagen', 301);
    }
    public function ingresopaciente()
    {
        // DATOS PACIENTE
        $id_usuario      = $this->input->post('histid', true);
        $persona_atiende = $this->am->persona_atiende($id_usuario);
        
        $datos['cod_persona_atie']  =   $this->input->post('histcodpersona');
        $datos['login']             =   $this->input->post('histlogin');
        $nombre_persona_atie        =   $this->input->post('histnombre');
        
        $datos['id_usuario']        =   $id_usuario;
        $datos['histlogin']         =   $this->input->post('histlogin');
        $datos['consultorios']      =   $this->am->consultorios();
        // DATOS DEL PACIENTE
        $datos['id_paciente']           =   '';
        $datos['bd_tipo_docu']          =   '';
        $datos['bd_identificacion']     =   '';
        $datos['bd_primer_nombre']      =   '';
        $datos['bd_segundo_nombre']     =   '';
        $datos['bd_primer_apellido']    =   '';
        $datos['bd_segundo_apellido']   =   '';
        $datos['bd_telefono_paci']      =   '';
        $datos['bd_id_admi']            =   '';
        $datos['bd_nombre_admi']        =   '';
        $datos['bd_celular_paci']       =   '';
        $datos['convenios']             =   $this->am->convenios();

        $datos['entero']                =   $this->am->entero();

        $this->load->view('front_end/agenda/pacienteingreso_v', $datos);
    }
    public function personal()
    {
        // DATOS PACIENTE
        $id_usuario      = $this->input->post('histid', true);
        $persona_atiende = $this->am->persona_atiende($id_usuario);
        foreach ($persona_atiende as $persona) {
            $datos['cod_persona_atie'] = $persona['cod_persona_atie'];
            $nombre_persona_atie       = $persona['nombre_persona_atie'];
            $datos['login']            = $persona['login'];
        }
        $this->load->view('front_end/agenda/personal_v', 301);   
    }
    public function cusuarios()
    {
        $datos['usuarios']   =   $this->am->usuarios();
        $this->load->view('front_end/agenda/cusuarios_v', $datos);   
    }
    public function insertarpersonal()
    {
        date_default_timezone_set('America/Bogota');
        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");
        $personal = [
            'id_usuario'        =>  $this->input->post('id_u', true),
            'nombre'            =>  $this->input->post('nombre', true),
            'codigo'            =>  $this->input->post('cod_medi', true),
            'activo'            =>  'SI'
        ];
        $inserPersonal = $this->am->ingresopersonal($personal);
        $this->load->view('front_end/agenda/personal_v', 301);
    }
    public function cpersonal()
    {
        $datos['personal']   =   $this->am->cpersonal();
        $this->load->view('front_end/agenda/cpersonal_v', $datos);   
    }
    public function actualizarpersonal()
    {
        date_default_timezone_set('America/Bogota');
        $fechaactual = date("Y-m-d");
        $horaactual  = date("H:i:s");
        $bd_id_usuario_personal =   $this->input->post('bd_id_usuario_personal');
        $consulta_usu_id        =   $this->am->c_id_usuario($bd_id_usuario_personal);
        foreach($consulta_usu_id as $cusu)
        {
            $codigo   =   $cusu['codigo'];
        }
        $bd_id_personal     =   $this->input->post('bd_id_personal');
        $personal = array(            
            'nombre'           => $this->input->post('nombrem', true),
            'activo'      => $this->input->post('u_activo', true),
            'codigo'       => $codigo
        );
        $updatePaciente = $this->am->actualizarpersonal($personal, $bd_id_personal);
        $this->load->view('front_end/agenda/personal_v', 301);
    }

    public function procedimiento()
    {
        $clasificacion      = $this->input->post('clasificacion', true);
        $procedimiento      = $this->am->procedimiento($clasificacion);
    }

    public function conTipo_lista()
    {
        $tipo_lista     =   $this->input->post('tipo_lista');
        $conTipo_lista  =   $this->am->conTipo_lista($tipo_lista);   
    }

    public function medicosel()
    {
        $id_usuario     =   $this->input->post('id_usuario', true);
        $persona        =   $this->input->post('cod_persona_atie', true);
        $login          =   $this->input->post('login', true); 
        $datos          =   $this->am->medicosel($persona, $id_usuario, $login);
    }

    public function tipodocumento() 
    {
        $tipodocumento = $this->am->tipodocumento();
    }

    public function sexo() 
    {
        $sexo = $this->am->sexo();
    }

    public function estadocivil() 
    {
        $estadocivil = $this->am->estadocivil();
    }

    public function rh() 
    {
        $rh = $this->am->rh();
    }

    public function pais() 
    {
        $pais = $this->am->pais();
    }

    public function departamento() 
    {
        $pais         = $this->input->post('pais', true);
        $departamento = $this->am->departamento($pais);
    }

    public function ciudad() 
    {
        $pais         = $this->input->post('pais', true);
        $departamento = $this->input->post('departamento', true);
        $ciudad       = $this->am->ciudad($pais, $departamento);
    }

    public function zonaresidencia() 
    {
        $zonaresidencia = $this->am->zonaresidencia();
    }

    public function tipousuario() 
    {
        $tipousuario = $this->am->tipousuario();
    }

    public function videntificacion()
    {
        $tipo_docu       = $this->input->post('vtipo_docu', true);
        $identificacion  = $this->input->post('videntificacion', true);
        $videntificacion = $this->am->videntificacion($tipo_docu, $identificacion);
    }

    public function consulta_proc()
    {
        $fecha          =   $this->input->post('fecha', true);
        $horainicio     =   $this->input->post('horainicio', true);
        $horafinal      =   $this->input->post('horafinal', true);
        $cod_listap     =   $this->input->post('nprocedimiento', true);
        $frecuencia     =   $this->input->post('v_frec', true);

        $cfecha     =   $this->am->cfecha($fecha, $horainicio, $horafinal, $cod_listap, $frecuencia);
    }

    public function consulta_proc_val()
    {
        //var_dump($this->input->post());
        $fecha          =   $this->input->post('fecha', true);
        $horainicio     =   $this->input->post('horainicio', true);
        $horafinal      =   $this->input->post('horafinal', true);
        $cod_listap     =   $this->input->post('nprocedimiento', true);
        $frecuencia     =   $this->input->post('v_frec', true);

        $cfecha     =   $this->am->cfecha($fecha, $horainicio, $horafinal, $cod_listap, $frecuencia);
    }

    public function bus_paciente()
    {
        $bus_pac            =   $this->input->post('bus_pac', true);
        $datos['agendapac'] =   $this->am->agendapac($bus_pac);
        $this->load->view('front_end/agenda/bus_pac_v', $datos);
    }

    // informe a supersalud
    public function info_super()
    {
        // DATOS PACIENTE
        /*$id_usuario      = $this->input->post('histid', true);
        $persona_atiende = $this->am->persona_atiende($id_usuario);
        foreach ($persona_atiende as $persona) {
            $datos['cod_persona_atie'] = $persona['cod_persona_atie'];
            $nombre_persona_atie       = $persona['nombre_persona_atie'];
            $datos['login']            = $persona['login'];
        }*/
        $this->load->view('front_end/agenda/super_v', 301);   
    }

    public function rep_super_pdf()
    {
        require_once APPPATH."/third_party/fpdf/PDF_MC_Table.php";

        $fecha_inicial          =   $this->input->post('fecha_inicial');
        $fecha_final            =   $this->input->post('fecha_final');

        // TODOS
        $busqueda  =   $this->am->c_super_x_fecha($fecha_inicial, $fecha_final);

        // GENERACION DEL REPORTE
        
        //$this->pdf = new PDF_MC_Table();
        $this->pdf = new PDF_MC_Table('L','mm','A4');
        $this->pdf->AliasNbPages();
        $this->pdf->AddPage();
        $this->pdf->SetFont('Arial','',8);
        
        // DATOS DEL ENCABEZADO
        $logoempresa    =   base_url('img/logoempresa.png');
        $this->pdf->Image($logoempresa,5,5,0,25);
        
        $this->pdf->SetXY(110,5);
        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,'Fecha Inicial:',0,0,'L');
        $this->pdf->SetX(160);
        $this->pdf->Cell(20,4,$fecha_inicial,0,0,'L');
        $this->pdf->Ln(4);

        $this->pdf->SetX(120);
        $this->pdf->Cell(10,4,utf8_decode('Fecha final:'),0,0,'L');
        $this->pdf->SetX(160);
        $this->pdf->Cell(20,4,$fecha_final,0,0,'L');
    
        $this->pdf->Ln(4);
            
        $this->pdf->SetX(184);
        
        $this->pdf->Cell(0,10,utf8_decode('Página ').$this->pdf->PageNo().'/{nb}',0,0,'C');
        $this->pdf->Ln(4);


        $this->pdf->SetXY(110,30);
        $this->pdf->SetX(10);
        $this->pdf->Cell(35,4,utf8_decode('Informe de Citas por fecha ingreso y fecha asignado'),0,0,'L');

        
        $this->pdf->Ln();
        
        $this->pdf->Ln(5);
        $this->pdf->Cell(17, 5, 'F/Ingreso', 1, 0, 'C', 0);
        $this->pdf->Cell(17, 5, 'F/Agenda', 1, 0, 'C', 0);
        $this->pdf->Cell(14, 5, 'H/Inicio', 1, 0, 'C', 0);
        $this->pdf->Cell(14, 5, utf8_decode('H/Final'), 1, 0, 'C', 0);
        $this->pdf->Cell(14, 5, utf8_decode('ID'), 1, 0, 'C', 0);
        $this->pdf->Cell(45, 5, utf8_decode('Paciente'), 1, 0, 'C', 0);
        $this->pdf->Cell(22, 5, utf8_decode('Teléfonos'), 1, 0, 'C', 0);
        $this->pdf->Cell(45, 5, utf8_decode('Procedimiento'), 1, 0, 'C', 0);
        $this->pdf->Cell(50, 5, utf8_decode('Profesional'), 1, 0, 'C', 0);
        $this->pdf->Cell(45, 5, utf8_decode('Observaciones'), 1, 0, 'C', 0);
        $this->pdf->Ln();
        
        // DETALLES
        $this->pdf->SetWidths(array(17,17,14,14,14,45,22,45,50,45));
        srand(microtime()*1000000);
        $this->pdf->SetAligns(array('L','L','L','L','L','L','L','L','L','L'));
        
        
        if($busqueda)
        {
            foreach ($busqueda as $row) 
            {   
                $fechaing           =   utf8_decode($row['fechaingreso']);
                $fecha              =   utf8_decode($row['fecha']);
                $horainicio         =   date("g:i a",strtotime($row['horainicio'])) ;                
                $horafin            =   date("g:i a",strtotime($row['horafin'])) ; 
                $id_paciente        =   utf8_decode($row['id_paciente']) ; 
                $paciente           =   utf8_decode($row['primer_nombre']).' '.utf8_decode($row['segundo_nombre']).' '.utf8_decode($row['primer_apellido']).' '.utf8_decode($row['segundo_apellido']);
                $telefonos  =   utf8_decode($row['telefono_paciente'].' '.$row['celular_paciente']);
                $nom_procedimiento  =   utf8_decode($row['nom_procedimiento']);
                $nom_personal       =   utf8_decode($row['nom_personal']);
                $estado             =   utf8_decode($row['observaciones']);
                
                $this->pdf->Row(array($fechaing,$fecha,$horainicio,$horafin,$id_paciente,$paciente,$telefonos,$nom_procedimiento,$nom_personal,$estado));
            }
        }    
        
        $this->pdf->Output("Reporte agenda fecha inicial: ".$fecha_inicial."a fecha final: ".$fecha_final.".pdf", 'I');
    }

    public function rep_super_excel()
    {
        $this->load->library('export');
        $fecha_inicial          =   $this->input->post('fecha_inicial_xls');
        $fecha_final            =   $this->input->post('fecha_final_xls');

        // TODOS
        $busqueda  =   $this->am->c_super_x_fecha_xls($fecha_inicial, $fecha_final);
        
        $this->export->to_excel($busqueda, 'Informe_Super_Salud'); 
    }

    public function cons_autorizacion()
    {
        $autorizacion           =   $this->input->post('autorizacion', true);
        $cons_autorizacion      =   $this->am->cons_autorizacion($autorizacion);
    }

    public function consulta_factura()
    {
        $id_agenda              =   $this->input->post('id_agenda', true);
        $id_paciente            =   $this->input->post('id_paciente', true);
        $cons_factura           =   $this->am->cons_factura($id_agenda, $id_paciente);
    }

    public function quitar_evento()
    {
        date_default_timezone_set('America/Bogota');
        $fecha_mod = date("Y-m-d");
        $hora_mod  = date("H:i:s");

        $id_agenda              =   $this->input->post('id_agenda', true);
        $login_modificar        =   $this->input->post('login_modificar', true);
        $quitar_evento          =   $this->am->quitar_evento($id_agenda, $login_modificar, $fecha_mod, $hora_mod);
    }

    public function quitar_cita()
    {
        date_default_timezone_set('America/Bogota');
        $fecha_mod = date("Y-m-d");
        $hora_mod  = date("H:i:s");

        $id_agenda              =   $this->input->post('id_agenda', true);
        $login_modificar        =   $this->input->post('login_modificar', true);
        $numeroa                =   $this->input->post('numeroa', true);
        $quitar_evento          =   $this->am->quitar_cita($id_agenda, $login_modificar, $fecha_mod, $hora_mod, $numeroa);
    }

    public function lateralidad()
    {
        $lateralidad   =   $this->am->lateralidad();
    }

    /// nueva cita desde otra cita
    public function nc_nueva_cita()
    {
        date_default_timezone_set('America/Bogota');
        $fechaingreso = date("Y-m-d");
        $horaingreso  = date("H:i:s");
       
        $numeroa     = $this->am->consultaconsecutivo(23);

        // procedimientos
        $m_procedimientos   =   $this->input->post("nc_cod_lptipo");

        if($m_procedimientos)
        {
            for ($i = 0; $i < count($this->input->post('nc_cod_lptipo')); $i++) 
            {
                /*$m_proced = array(
                    'numeroa'       =>  $numeroa,
                    'cod_lptipo'    =>  $this->input->post('cod_lptipo')[$i],
                    'cod_listap'    =>  $this->input->post('cod_listap')[$i],
                    'id_personal'   =>  $this->input->post('id_personal')[$i]);
                $this->am->insertProcedimiento($m_proced);*/
                $data = array(
                    'numeroa'           =>  $numeroa,
                    'fecha'             =>  $this->input->post('rfecha'),
                    'horainicio'        =>  $this->input->post('nc_horainicio')[$i],
                    'horafin'           =>  $this->input->post('nc_horafin')[$i],
                    'color'             =>  $this->input->post('nc_color'),
                    'id_paciente'       =>  $this->input->post('rs_id_paciente'),
                    'tipo_docu'         =>  $this->input->post('rs_td'),
                    'identificacion'    =>  $this->input->post('rs_identificacion'),
                    'primer_nombre'     =>  $this->input->post('rs_primernombre'),
                    'segundo_nombre'    =>  $this->input->post('rs_segundonombre'),
                    'primer_apellido'   =>  $this->input->post('rs_primerapellido'),
                    'segundo_apellido'  =>  $this->input->post('rs_segundoapellido'),
                    'telefono_paciente' =>  $this->input->post('rs_telefono'),
                    'celular_paciente'  =>  $this->input->post('rs_celular'),
                    'id_admi'           =>  $this->input->post('rs_id_admi'),
                    'email'             =>  $this->input->post('rs_email'),
                    'observaciones'     =>  $this->input->post('nc_observaciones'),
                    'cod_medi'          =>  $this->input->post('nc_id_personal')[$i],
                    'nom_personal'      =>  $this->input->post('nc_nombre_profesional')[$i],
                    'login'             =>  $this->input->post('login'),
                    'fechaingreso'      =>  $fechaingreso,
                    'horaingreso'       =>  $horaingreso,
                    'cod_lptipo'        =>  $this->input->post('nc_cod_lptipo')[$i],
                    'cod_listap'        =>  $this->input->post('nc_cod_listap')[$i],
                    'id_personal'       =>  $this->input->post('nc_id_personal')[$i]
                    //'procedimiento'     =>  $this->input->post('cod_listap')[$i],
                    //'nom_procedimiento' =>  $this->input->post('nombre_procedimiento')
                );
                $respuesta = $this->am->insertAgenda($data, $numeroa);
            }
        }
        echo $respuesta;
    }
}