<?php if ( ! defined('BASEPATH')) exit('No hay acceso directo al script permitido, usuarios');

class Cups extends CI_Controller {
    
    //private $session_id, $session_nombre, $nivel_usuario;     
    public function __construct()
    {
        parent::__construct();
        $this->session_id               =   $this->session->userdata('login');    
        $this->session_nombre           =   $this->session->userdata('nombre'); 
        $this->session_nivel_usuario    =   $this->session->userdata('nivel_usuario');
        $this->session_idusuario        =   $this->session->userdata('id');
        $this->session_gempnumero       =   $this->session->userdata('gempnumero');
        $this->session_gempnombre       =   $this->session->userdata('gempnombre'); 
        $this->session_gempanoc         =   $this->session->userdata('gempanoc');
        $this->load->library('Datatables');              
    }
   
    public function index()
    {            
        $this->load->view('front_end/tecnico/menut_f_v', 301);
    }
    
    public function resumen()
    {
        $this->db->trans_start();
        $abuscar    =   $this->input->post('abuscar');        
        
        $this->datatables->select('cod_cups, nombre_cups, valor')
            ->from('cups');
          
        $this->db->like('nombre_cups', $abuscar);
        $this->db->or_like('cod_cups', $abuscar);
        $this->db->or_like('valor', $abuscar);
        
        
        $this->db->trans_complete();
        echo $this->datatables->generate();
    }
    
    public function ingreso()
    {
        $datos['titulo']    =   'Cups ingreso valor';
        $this->load->view('front_end/tecnico/admcupsvringreso_v', $datos);
    }
    
    public function modificacion()
    {
        $datos['titulo']        =   'Cups modificación valor';        
        $this->load->view('front_end/tecnico/admcupsvrmodificacion_v', 301);
    }
    
    public function cupsamodificar()
    {
        $this->load->model('admon_model');
        $codcups                =   $this->input->post('codcups');
        $datos['consultacups']  =   $this->admon_model->consultacups($codcups);
        $datos['titulo']        =   'Cups modificación valor';        
        $this->load->view('front_end/tecnico/admcupsvrmodificacion_t_v', $datos);
    }
    
    
    public function modcups()
    {
        $this->load->model('admon_model');
        $cod_cups           =   trim($this->input->post('cod_cups'));
        $valor              =   trim($this->input->post('valor'));
        $datos['cmedico']  =   $this->admon_model->modcups($cod_cups, $valor);
    }
    
    public function consulta()
    {
        $this->load->model('admon_model');
        $datos['titulo']        =   'Prestador consulta';
        $datos['modprestador']  =   $this->admon_model->modprestador();
        $this->load->view('front_end/tecnico/admcupsvrconsulta_v', $datos);
    }
    
    public function pantallainicio()
    {
        $this->load->view('front_end/tecnico/pantallainicio_v', 301);
    }
}