<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Upload extends CI_Controller {

	public function __construct() {
		parent::__construct();
		$this->load->library('imagenes');
		$this->load->helper("file");
	}

	public function archivos() 
	{
		$this->load->model('archivos_model', 'am');

		date_default_timezone_set('America/Bogota');
		$fechaactual = date("Y-m-d");
		$horaactual  = date("H:i:s");

		$url = $this->imagenes->Upload('archivo', 'uploads/');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'original');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'Nombre archivo');

		if ($url["error"]) {
			echo json_encode($url);
		} else {

			$data = array(
				'obs'            => $this->input->post('obs'),
				'url'            => $url["urlimg"],
				'id_paciente'    => $this->input->post('id_paciente'),
				'login_ing'      => $this->input->post('histlogin'),
				'horaactual'     => $horaactual,
				'fechaactual'    => $fechaactual,
				'tipo'			 => 'inbody'
			);

			$insert = $this->am->insert($data);

			if ($insert) {
				echo json_encode($url);
			} else {
				$result = array(
					'error'         => true,
					'display_error' => 'Ocurrio un error en elproceso de guardado',
				);
				echo json_encode($result);
			}
		}
	}

	public function archivos_inbody() 
	{
		$this->load->model('archivos_model', 'am');

		date_default_timezone_set('America/Bogota');
		$fechaactual = date("Y-m-d");
		$horaactual  = date("H:i:s");

		$url = $this->imagenes->Upload('archivo', 'uploads/');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'original');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'Nombre archivo');

		if ($url["error"]) {
			echo json_encode($url);
		} else 
		{
			$ruta_completa 	=	$url["urlimg"];
			$nueva_ruta		=	strpos($ruta_completa, 'uploads');
			$extraer 		=	substr($ruta_completa, $nueva_ruta);
			//var_dump($extraer);
			//exit();
			$data = array(
				'obs'            => $this->input->post('obs'),
				//'url'            => $url["urlimg"],
				'url'            => $extraer,
				'id_paciente'    => $this->input->post('id_paciente'),
				'login_ing'      => $this->input->post('histlogin'),
				'horaactual'     => $horaactual,
				'fechaactual'    => $fechaactual,
				'tipo'			 => 'inbody'
			);

			$insert = $this->am->insert($data);

			if ($insert) {
				echo json_encode($url);
			} else {
				$result = array(
					'error'         => true,
					'display_error' => 'Ocurrio un error en elproceso de guardado',
				);
				echo json_encode($result);
			}

			// datos de estado fisico
			$imc       =  trim($this->input->post('imc', true)); 
	        $icc       =  trim($this->input->post('icc', true)); 
	        $pgs       =  trim($this->input->post('pgs', true)); 

	        $cp        =  trim($this->input->post('cp', true)); 
	        $cg        =  trim($this->input->post('cg', true)); 
	        $cm        =  trim($this->input->post('cm', true));  
	        if($imc || $icc || $pgs || $cp || $cg || $cm)
	        {
	            if($imc)
	            {
	                $v_imc  =   $imc;
	            }else
	            {
	                $v_imc  =   '';
	            }

	            if($icc)
	            {
	                $v_icc  =   $icc;
	            }else
	            {
	                $v_icc  =   '';
	            }

	            if($pgs)
	            {
	                $v_pgs  =   $pgs;
	            }else
	            {
	                $v_pgs  =   '';
	            }

	            if($cp)
	            {
	                $v_cp  =   $cp;
	            }else
	            {
	                $v_cp  =   '';
	            }

	            if($cg)
	            {
	                $v_cg  =   $cg;
	            }else
	            {
	                $v_cg  =   '';
	            }

	            if($cm)
	            {
	                $v_cm  =   $cm;
	            }else
	            {
	                $v_cm  =   '';
	            }

	            $this->load->model('examen_model');
	            $n_conexamen        =   $this->examen_model->consultaconsecutivo(7);

	            $estado_fisico = array(
	                'id_paciente'           =>  $this->input->post('id_paciente', true),
	                'nconsulta'             =>  $this->input->post('nconsulta'),
	                'cons_examen'           =>  $n_conexamen,
	                'login_ing'      		=> $this->input->post('histlogin'),
	                'fechaactual'           =>  $fechaactual,
	                'horaactual'            =>  $horaactual,
	                'imc'                   =>  $v_imc,
	                'color_imc'             =>  $this->input->post('color_imc', true),
	                'icc'                   =>  $v_icc,
	                'color_icc'             =>  $this->input->post('color_icc', true),
	                'pgs'                   =>  $v_pgs,
	                'color_pgs'             =>  $this->input->post('color_pgs', true),
	                'cp'                    =>  $v_cp,
	                'color_cp'              =>  $this->input->post('color_cp', true),
	                'cg'                    =>  $v_cg,
	                'color_cg'              =>  $this->input->post('color_cg', true),
	                'cm'                    =>  $v_cm,
	                'color_cm'              =>  $this->input->post('color_cm', true),
	                'tipo'					=> 	'estadofisico'
	            );
	            $insertAnt = $this->examen_model->insert_estf($estado_fisico);
	            if ($insertAnt) {
					echo json_encode($url);
				} else {
					$result = array(
						'error'         => true,
						'display_error' => 'Ocurrio un error en elproceso de guardado',
					);
					echo json_encode($result);
				}
	        }
		}
		

	}

	public function archivos_nutricion()
	{
		$this->load->model('archivos_model', 'am');

		date_default_timezone_set('America/Bogota');
		$fechaactual = date("Y-m-d");
		$horaactual  = date("H:i:s");

		$url = $this->imagenes->Upload('archivo', 'uploads/');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'original');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'Nombre archivo');

		if ($url["error"]) {
			echo json_encode($url);
		} else 
		{
			$ruta_completa 	=	$url["urlimg"];
			$nueva_ruta		=	strpos($ruta_completa, 'uploads');
			$extraer 		=	substr($ruta_completa, $nueva_ruta);

			$data = array(
				'titulo'		=> $this->input->post('titulo_nutricion'),
				'obs'           => $this->input->post('obs'),
				'url'           => $extraer,
				'id_paciente'   => $this->input->post('id_paciente'),
				'login_ing'     => $this->input->post('histlogin'),
				'horaactual'    => $horaactual,
				'fechaactual'   => $fechaactual,
				'tipo'			=> 'nutricion'
			);

			$insert = $this->am->insert($data);

			if ($insert) {
				echo json_encode($url);
			} else {
				$result = array(
					'error'         => true,
					'display_error' => 'Ocurrio un error en elproceso de guardado',
				);
				echo json_encode($result);
			}
		}
	}

	public function carga_img_inbody()
	{
		$this->load->model('archivos_model', 'am');

		$id_paciente 		=	$this->input->post('id_paciente');
		$id_usuario			=	$this->input->post('id_usuario');
		$codprograma 		=	$this->input->post('codprograma');
        $datos["archivos"]  =   $this->am->get($id_paciente, true);
        $datos['permisos']  =   $this->am->permisos($id_usuario, $codprograma);
        $this->load->view('front_end/historias/hcorporal_tinbody_v', $datos);
	}

	// cargar imagenes
	public function carga_imagenes()
	{
		$this->load->model('archivos_model', 'am');

		$id_paciente 		=	$this->input->post('id_paciente');
		$id_usuario			=	$this->input->post('id_usuario');
		$codprograma 		=	$this->input->post('codprograma');
		$tipo 				=	$this->input->post('tipo');
        $datos["archivos"]  =   $this->am->get_general($id_paciente, $tipo, true);
        $datos['permisos']  =   $this->am->permisos($id_usuario, $codprograma);
        $this->load->view('front_end/historias/hcorporal_tnutricion_v', $datos);
	} 

	public function delete() 
	{
		$this->load->model('archivos_model', 'am');

		$fileName = '';
		$id_archivos 	=	$this->input->post('id_archivos');
		$cons_imagen 	=	$this->am->cons_imagen($id_archivos);

		foreach($cons_imagen as $csi)
		{
			$url 		=	$csi->url;
			$fileName 	=	base_url().$url;
			$eliminar 	=	$this->am->eliminar_registro($id_archivos);
			unlink($url);
		}
	}

	public function archivosecografia() 
	{
		$this->load->model('archivos_model', 'am');
		
		date_default_timezone_set('America/Bogota');
		$fechaactual = 	date("Y-m-d");
		$horaactual  = 	date("H:i:s");
		$id_paciente =	$this->input->post('id_paciente');

		$url = $this->imagenes->Upload('archivo', 'uploads/');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'original');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'Nombre archivo');

		if ($url["error"]) {
			echo json_encode($url);
		} else {

			$data = array(
				'fur'            => $this->input->post('fur'),
				'gestacion'      => $this->input->post('gestacion'),
				'partos'         => $this->input->post('partos'),
				'abortos'        => $this->input->post('abortos'),
				'vivos'          => $this->input->post('vivos'),
				'obs'            => $this->input->post('observaciones'),
				'conclusion'     => $this->input->post('conclusion'),
				'url'            => $url["urlimg"],
				'id_paciente'    => $id_paciente,
				'login_ing'      => $this->input->post('histlogin'),
				'horaactual'     => $horaactual,
				'fechaactual'    => $fechaactual,
				'tipo'			 => 'ecografia'
			);

			$insert = $this->am->insert($data);

			if ($insert) {
				echo json_encode($url);
			} else {
				$result = array(
					'error'         => true,
					'display_error' => 'Ocurrio un error en elproceso de guardado',
				);
				echo json_encode($result);
			}
		}
	}

	public function carga_ecografia()
	{
		$this->load->model('archivos_model', 'am');

		$id_paciente 			=	$this->input->post('id_paciente');
		$id_usuario				=	$this->input->post('id_usuario');
		$codprograma 			=	$this->input->post('codprograma');
        $datos["archivoseco"]   =   $this->am->geteco($id_paciente, true);
        $datos['permisos']  	=   $this->am->permisos($id_usuario, $codprograma);
        
        $this->load->view('front_end/historias/hexamen_eco_v', $datos);
	}

	public function subirarchivos() 
	{

		$this->load->model('archivos_model', 'am');
		
		date_default_timezone_set('America/Bogota');
		$fechaactual = 	date("Y-m-d");
		$horaactual  = 	date("H:i:s");
		$id_paciente =	$this->input->post('id_paciente');

		$url = $this->imagenes->Upload('archivo', 'uploads/');
		//var_dump($this->input->post());
		//exit();
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'original');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'Nombre archivo');

		if ($url["error"]) {
			echo json_encode($url);
		} else 
		{
			$ruta_completa 	=	$url["urlimg"];
			$nueva_ruta		=	strpos($ruta_completa, 'uploads');
			$extraer 		=	substr($ruta_completa, $nueva_ruta);

			$data = array(
				'obs'            => $this->input->post('detalle_archivo'),
				'url'            => $extraer,
				'id_paciente'    => $id_paciente,
				'login_ing'      => $this->input->post('histlogin'),
				'horaactual'     => $horaactual,
				'fechaactual'    => $fechaactual,
				'tipo'			 => 'archivos'
			);

			$insert = $this->am->insert($data);

			if ($insert) {
				
				//$datos["archivoseco"]           =   $this->am->geteco($id_paciente, true);
				//$this->load->view('front_end/historias/hexamen_eco_v', $datos);
				echo json_encode($url);
				
			} else {
				$result = array(
					'error'         => true,
					'display_error' => 'Ocurrio un error en elproceso de guardado',
				);
				echo json_encode($result);
			}
		}
	}

	

	public function carga_archivos()
	{
		$this->load->model('archivos_model', 'am');

		$id_paciente 			=	$this->input->post('id_paciente');
		$id_usuario				=	$this->input->post('id_usuario');
		$codprograma 			=	$this->input->post('codprograma');
        $datos["archivoslab"]   =   $this->am->getlabo($id_paciente, true);
		$datos['permisos']  	=   $this->am->permisos($id_usuario, $codprograma);        

        $this->load->view('front_end/historias/harchivos_resu_v', $datos);
;

	}



	// ordenes
	public function archivosorden() 
	{
		$this->load->model('archivos_model', 'am');
		
		date_default_timezone_set('America/Bogota');
		$fechaactual = 	date("Y-m-d");
		$horaactual  = 	date("H:i:s");
		$id_paciente =	$this->input->post('id_paciente');

		$url = $this->imagenes->Upload('archivo', 'uploads/');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'original');
		// $url = $this->imagenes->Upload('archivo', 'uploads/', 'Nombre archivo');

		if ($url["error"]) {
			echo json_encode($url);
		} else {
			$ruta_completa 	=	$url["urlimg"];
			$nueva_ruta		=	strpos($ruta_completa, 'uploads');
			$extraer 		=	substr($ruta_completa, $nueva_ruta);

			$data = array(
				'obs'            => $this->input->post('detalle_lab'),
				'url'            => $extraer,
				'id_paciente'    => $id_paciente,
				'login_ing'      => $this->input->post('histlogin'),
				'horaactual'     => $horaactual,
				'fechaactual'    => $fechaactual,
				'tipo'			 => 'ordenes'
			);

			$insert = $this->am->insert($data);

			if ($insert) {
				
				//$datos["archivoseco"]           =   $this->am->geteco($id_paciente, true);
				//$this->load->view('front_end/historias/hexamen_eco_v', $datos);
				echo json_encode($url);
				
			} else {
				$result = array(
					'error'         => true,
					'display_error' => 'Ocurrio un error en elproceso de guardado',
				);
				echo json_encode($result);
			}
		}
	}

	public function carga_orden()
	{
		$this->load->model('archivos_model', 'am');

		$id_paciente 			=	$this->input->post('id_paciente');
		$id_usuario				=	$this->input->post('id_usuario');
		$codprograma 			=	$this->input->post('codprograma');
        $datos["archivosord"]   =   $this->am->getord($id_paciente, true);
        $datos['permisos']  	=   $this->am->permisos($id_usuario, $codprograma);
        
        $this->load->view('front_end/historias/hexamen_orde_v', $datos);
	} 

}
