<?php

if (!defined('BASEPATH')) {
    exit('No direct script access allowed');
}

class Agenda_model extends CI_Model {
    public function __construct() {
        parent::__construct();
    }

    public function get_data($fecha_inico, $fecha_final) {

        $sql = "SELECT a.id_agenda as id,
                CONCAT(a.fecha, ' ', a.horainicio) as start,
                CONCAT(a.fecha, ' ', a.horafin ) as end, 
                CONCAT('Pac: ',
                    CASE WHEN a.primer_nombre is NULL THEN '' ELSE a.primer_nombre END , ' ' , 
                    CASE WHEN a.segundo_nombre is NULL THEN '' ELSE a.segundo_nombre END, ' ' ,
                    CASE WHEN a.primer_apellido is NULL THEN '' ELSE  a.primer_apellido END, ' ', 
                    CASE WHEN a.segundo_apellido is NULL THEN '' ELSE a.segundo_apellido END,
                    ' T: ', CASE WHEN a.celular_paciente is NULL THEN '' ELSE a.celular_paciente END , 
                    ' - ID: ',a.id_paciente, 
                    ' Est: ',CASE WHEN a.estado is NULL THEN '' ELSE a.estado END, ' \n',
                    'Proc: ',lp.nombre_listap, ' \n' , 
                    'Med: ',pe.nombre, ' \n' ,
                    'Obs: ', CASE WHEN a.observaciones is NULL THEN '' ELSE a.observaciones END
                ) as title,
                (case when estado = 'Asistio' then '#f6ff4c' when estado = 'Cancelo' then '#d9534f' when 'Atendio' then '#5cb85c' when 'No Asistio' then '#A4A4A4' else a.color end) as color,
                lp.color as colorprocedimiento, lp.cod_listap as cod_prod
                FROM agenda a
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                JOIN personal pe ON pe.id = a.cod_medi
                
                WHERE fecha BETWEEN '{$fecha_inico}' AND '{$fecha_final}'
        ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result();
    }

    

    //LEFT JOIN personal p ON a.cod_medi = p.id
    public function get_data_filtro($fecha_inico, $fecha_final, $tipo_lista, $tipo_procedimiento) {

        $sql = "SELECT a.id_agenda as id,
                CONCAT(a.fecha, ' ', a.horainicio) as start,
                CONCAT(a.fecha, ' ', a.horafin) as end,
                CONCAT('Pac: ',
                    CASE WHEN a.primer_nombre is NULL THEN '' ELSE a.primer_nombre END , ' ' , 
                    CASE WHEN a.segundo_nombre is NULL THEN '' ELSE a.segundo_nombre END, ' ' ,
                    CASE WHEN a.primer_apellido is NULL THEN '' ELSE  a.primer_apellido END, ' ', 
                    CASE WHEN a.segundo_apellido is NULL THEN '' ELSE a.segundo_apellido END,
                    ' T: ', CASE WHEN a.celular_paciente is NULL THEN '' ELSE a.celular_paciente END , 
                    ' - ID: ',a.id_paciente, 
                    ' Est: ',CASE WHEN a.estado is NULL THEN '' ELSE a.estado END, ' \n',
                    'Proc: ',lp.nombre_listap, ' \n' , 
                    'Med: ',pe.nombre, ' \n' ,
                    'Obs: ', CASE WHEN a.observaciones is NULL THEN '' ELSE a.observaciones END
                ) as title,
                (case when estado = 'Asistio' then '#f6ff4c' when estado = 'Cancelo' then '#d9534f' when 'Atendio' then '#5cb85c' when 'No Asistio' then '#A4A4A4' else a.color end) as color,
                lp.color as colorprocedimiento, lp.cod_listap as cod_prod
                FROM agenda a
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                JOIN personal pe ON pe.id = a.cod_medi

                WHERE (fecha BETWEEN '{$fecha_inico}' AND '{$fecha_final}') 
                AND a.cod_lptipo = $tipo_lista
                AND a.cod_listap = $tipo_procedimiento
        ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result();
    }

    //JOIN agenda_procedimiento ap ON ap.cod_lptipo = $tipo_lista and ap.cod_listap  = $tipo_procedimiento and ap.numeroa = a.numeroa

    public function get_data_filtro_medico($fecha_inico, $fecha_final, $tipo_personal)
    {
        $sql = "SELECT a.id_agenda as id,
                CONCAT(a.fecha, ' ', a.horainicio) as start,
                CONCAT(a.fecha, ' ', a.horafin) as end,
                CONCAT('Pac: ',
                    CASE WHEN a.primer_nombre is NULL THEN '' ELSE a.primer_nombre END , ' ' , 
                    CASE WHEN a.segundo_nombre is NULL THEN '' ELSE a.segundo_nombre END, ' ' ,
                    CASE WHEN a.primer_apellido is NULL THEN '' ELSE  a.primer_apellido END, ' ', 
                    CASE WHEN a.segundo_apellido is NULL THEN '' ELSE a.segundo_apellido END,
                    ' T: ', CASE WHEN a.celular_paciente is NULL THEN '' ELSE a.celular_paciente END , 
                    ' - ID: ',a.id_paciente, 
                    ' Est: ',CASE WHEN a.estado is NULL THEN '' ELSE a.estado END, ' \n',
                    'Proc: ',lp.nombre_listap, ' \n' , 
                    'Med: ',pe.nombre, ' \n' ,
                    'Obs: ', CASE WHEN a.observaciones is NULL THEN '' ELSE a.observaciones END
                ) as title,
                (case when estado = 'Asistio' then '#f6ff4c' when estado = 'Cancelo' then '#d9534f' when 'Atendio' then '#5cb85c' when 'No Asistio' then '#A4A4A4' else a.color end) as color,
                lp.color as colorprocedimiento, lp.cod_listap as cod_prod
                FROM agenda a
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                JOIN personal pe ON pe.id = a.cod_medi


                WHERE (fecha BETWEEN '{$fecha_inico}' AND '{$fecha_final}')
                AND a.id_personal = $tipo_personal
        ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result();
    }

    //JOIN agenda_procedimiento ap ON ap.id_personal = $tipo_personal and ap.numeroa = a.numeroa

    public function get_data_filtro_all($fecha_inico, $fecha_final, $tipo_lista)
    {
        $sql = "SELECT a.id_agenda as id,
                CONCAT(a.fecha, ' ', a.horainicio) as start,
                CONCAT(a.fecha, ' ', a.horafin) as end,
                CONCAT('Pac: ',
                    CASE WHEN a.primer_nombre is NULL THEN '' ELSE a.primer_nombre END , ' ' , 
                    CASE WHEN a.segundo_nombre is NULL THEN '' ELSE a.segundo_nombre END, ' ' ,
                    CASE WHEN a.primer_apellido is NULL THEN '' ELSE  a.primer_apellido END, ' ', 
                    CASE WHEN a.segundo_apellido is NULL THEN '' ELSE a.segundo_apellido END,
                    ' T: ', CASE WHEN a.celular_paciente is NULL THEN '' ELSE a.celular_paciente END , 
                    ' - ID: ',a.id_paciente, 
                    ' Est: ',CASE WHEN a.estado is NULL THEN '' ELSE a.estado END, ' \n',
                    'Proc: ',lp.nombre_listap, ' \n' , 
                    'Med: ',pe.nombre, ' \n' ,
                    'Obs: ', CASE WHEN a.observaciones is NULL THEN '' ELSE a.observaciones END
                ) as title,
                (case when estado = 'Asistio' then '#f6ff4c' when estado = 'Cancelo' then '#d9534f' when 'Atendio' then '#5cb85c' when 'No Asistio' then '#A4A4A4' else a.color end) as color,
                lp.color as colorprocedimiento, lp.cod_listap as cod_prod
                FROM agenda a
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                JOIN personal pe ON pe.id = a.cod_medi
                
                WHERE (fecha BETWEEN '{$fecha_inico}' AND '{$fecha_final}')
                AND a.cod_lptipo = $tipo_lista
        ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        //var_dump($consulta)
        return $consulta->result();
    }

    ///JOIN agenda_procedimiento ap ON ap.cod_lptipo = $tipo_lista and ap.numeroa = a.numeroa

    public function get_data_filtro_todos($fecha_inico, $fecha_final, $tipo_lista, $tipo_procedimiento, $tipo_personal) 
    {
        $sql = "SELECT a.id_agenda as id,
                CONCAT(a.fecha, ' ', a.horainicio) as start,
                CONCAT(a.fecha, ' ', a.horafin) as end,
                CONCAT('Pac: ',
                    CASE WHEN a.primer_nombre is NULL THEN '' ELSE a.primer_nombre END , ' ' , 
                    CASE WHEN a.segundo_nombre is NULL THEN '' ELSE a.segundo_nombre END, ' ' ,
                    CASE WHEN a.primer_apellido is NULL THEN '' ELSE  a.primer_apellido END, ' ', 
                    CASE WHEN a.segundo_apellido is NULL THEN '' ELSE a.segundo_apellido END,
                    ' T: ', CASE WHEN a.celular_paciente is NULL THEN '' ELSE a.celular_paciente END , 
                    ' - ID: ',a.id_paciente, 
                    ' Est: ',CASE WHEN a.estado is NULL THEN '' ELSE a.estado END, ' \n',
                    'Proc: ',lp.nombre_listap, ' \n' , 
                    'Med: ',pe.nombre, ' \n' ,
                    'Obs: ', CASE WHEN a.observaciones is NULL THEN '' ELSE a.observaciones END
                ) as title,
                (case when estado = 'Asistio' then '#f6ff4c' when estado = 'Cancelo' then '#d9534f' when 'Atendio' then '#5cb85c' when 'No Asistio' then '#A4A4A4' else a.color end) as color,
                lp.color as colorprocedimiento, lp.cod_listap as cod_prod
                FROM agenda a
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                JOIN personal pe ON pe.id = a.cod_medi

                WHERE (fecha BETWEEN '{$fecha_inico}' AND '{$fecha_final}')
                AND a.cod_lptipo = $tipo_lista
                AND a.cod_listap = $tipo_procedimiento
                AND a.id_personal = $tipo_personal

        ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result();
    }

    //JOIN agenda_procedimiento ap ON ap.cod_lptipo = $tipo_lista and ap.cod_listap  = $tipo_procedimiento and ap.numeroa = a.numeroa and id_personal = $tipo_personal

    public function get_data_filtro_dos($fecha_inico, $fecha_final, $tipo_lista, $tipo_personal) 
    {

        $sql = "SELECT a.id_agenda as id,
                CONCAT(a.fecha, ' ', a.horainicio) as start,
                CONCAT(a.fecha, ' ', a.horafin) as end,
                CONCAT('Pac: ',
                    CASE WHEN a.primer_nombre is NULL THEN '' ELSE a.primer_nombre END , ' ' , 
                    CASE WHEN a.segundo_nombre is NULL THEN '' ELSE a.segundo_nombre END, ' ' ,
                    CASE WHEN a.primer_apellido is NULL THEN '' ELSE  a.primer_apellido END, ' ', 
                    CASE WHEN a.segundo_apellido is NULL THEN '' ELSE a.segundo_apellido END,
                    ' T: ', CASE WHEN a.celular_paciente is NULL THEN '' ELSE a.celular_paciente END , 
                    ' - ID: ',a.id_paciente, 
                    ' Est: ',CASE WHEN a.estado is NULL THEN '' ELSE a.estado END, ' \n',
                    'Proc: ',lp.nombre_listap, ' \n' , 
                    'Med: ',pe.nombre, ' \n' ,
                    'Obs: ', CASE WHEN a.observaciones is NULL THEN '' ELSE a.observaciones END
                ) as title,
                (case when estado = 'Asistio' then '#f6ff4c' when estado = 'Cancelo' then '#d9534f' when 'Atendio' then '#5cb85c' when 'No Asistio' then '#A4A4A4' else a.color end) as color,
                lp.color as colorprocedimiento, lp.cod_listap as cod_prod
                FROM agenda a
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                JOIN personal pe ON pe.id = a.cod_medi

                WHERE (fecha BETWEEN '{$fecha_inico}' AND '{$fecha_final}')
                AND a.cod_lptipo = $tipo_lista
                AND a.id_personal = $tipo_personal
        ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result();
    }

    //JOIN agenda_procedimiento ap ON ap.cod_lptipo = $tipo_lista and ap.numeroa = a.numeroa and id_personal = $tipo_personal

    public function permisos($id_usuario, $codprograma)
    {
        $this->db->select();
        $this->db->from('tipo_permisos');   
        $this->db->where('id_usuario',$id_usuario);
        $this->db->where('id_programa', $codprograma);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();  
    }


    public function c_todos($fecha_inicial, $fecha_final)
    {
        $sql = "SELECT a.id_agenda as id_agenda, a.fecha as fecha, DATE_FORMAT(a.horainicio,'%H:%i') as horainicio, a.primer_nombre as primer_nombre, a.segundo_nombre as segundo_nombre, a.primer_apellido as primer_apellido, a.segundo_apellido as segundo_apellido, pa.identificacion as identificacion, 
             group_concat(DISTINCT(lp.nombre_listap)) as nom_procedimiento, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as nom_personal, a.estado as estado, a.telefono_paciente as telefono_paciente, a.celular_paciente as celular_paciente, a.observaciones as observaciones, c.nombre_admi as nombre_admi, group_concat(DISTINCT(l.nombre_lateralidad)) as lateralidad, group_concat(DISTINCT(ci.nombre_cie)) as cie
                
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                 
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}'
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result_array();
        $this->db->close();
    }

    //JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa

    public function c_tipolista($fecha_inicial, $fecha_final, $tipo_lista)
    {
        $sql = "SELECT a.id_agenda as id_agenda, a.fecha as fecha,  DATE_FORMAT(a.horainicio,'%H:%i') as horainicio, a.primer_nombre as primer_nombre, a.segundo_nombre as segundo_nombre, a.primer_apellido as primer_apellido, a.segundo_apellido as segundo_apellido, pa.identificacion as identificacion, 
             group_concat(DISTINCT(lp.nombre_listap)) as nom_procedimiento, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as nom_personal,  a.estado as estado, a.telefono_paciente as telefono_paciente, a.celular_paciente as celular_paciente, a.observaciones as observaciones, c.nombre_admi as nombre_admi, group_concat(DISTINCT(l.nombre_lateralidad)) as lateralidad, group_concat(DISTINCT(ci.nombre_cie)) as cie
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.cod_lptipo = $tipo_lista
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result_array();
        $this->db->close();
    }

    //JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa and ap.cod_lptipo = {$tipo_lista}

    public function c_procedimiento($fecha_inicial, $fecha_final, $tipo_procedimiento)
    {
        $sql = "SELECT a.id_agenda as id_agenda, a.fecha as fecha, DATE_FORMAT(a.horainicio,'%H:%i') as horainicio, a.primer_nombre as primer_nombre, a.segundo_nombre as segundo_nombre, a.primer_apellido as primer_apellido, a.segundo_apellido as segundo_apellido, pa.identificacion as identificacion, 
             group_concat(DISTINCT(lp.nombre_listap)) as nom_procedimiento, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as nom_personal,  a.estado as estado, a.telefono_paciente as telefono_paciente, a.celular_paciente as celular_paciente, a.observaciones as observaciones, c.nombre_admi as nombre_admi, group_concat(DISTINCT(l.nombre_lateralidad)) as lateralidad, group_concat(DISTINCT(ci.nombre_cie)) as cie
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.cod_listap = $tipo_procedimiento
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result_array();
        $this->db->close();
    }

    // JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa and ap.cod_listap = {$tipo_procedimiento}

    public function c_procedimiento_per($fecha_inicial, $fecha_final, $tipo_procedimiento, $tipo_personal)
    {
        $sql = "SELECT a.id_agenda as id_agenda, a.fecha as fecha, DATE_FORMAT(a.horainicio,'%H:%i') as horainicio, a.primer_nombre as primer_nombre, a.segundo_nombre as segundo_nombre, a.primer_apellido as primer_apellido, a.segundo_apellido as segundo_apellido, pa.identificacion as identificacion, 
             group_concat(DISTINCT(lp.nombre_listap)) as nom_procedimiento, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as nom_personal, a.estado as estado, a.telefono_paciente as telefono_paciente, a.celular_paciente as celular_paciente, a.observaciones as observaciones, c.nombre_admi as nombre_admi, group_concat(DISTINCT(l.nombre_lateralidad)) as lateralidad, group_concat(DISTINCT(ci.nombre_cie)) as cie
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.cod_listap = $tipo_procedimiento
                AND a.id_personal = $tipo_personal
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result_array();
        $this->db->close();
    }

    // JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa and ap.cod_listap = {$tipo_procedimiento} and ap.id_personal={$tipo_personal}

    public function c_tipo_pers($fecha_inicial, $fecha_final, $tipo_lista, $tipo_personal)
    {
        $sql = "SELECT a.id_agenda as id_agenda, a.fecha as fecha, DATE_FORMAT(a.horainicio,'%H:%i') as horainicio, a.primer_nombre as primer_nombre, a.segundo_nombre as segundo_nombre, a.primer_apellido as primer_apellido, a.segundo_apellido as segundo_apellido, pa.identificacion as identificacion, 
             group_concat(DISTINCT(lp.nombre_listap)) as nom_procedimiento, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as nom_personal, a.estado as estado, a.telefono_paciente as telefono_paciente, a.celular_paciente as celular_paciente, a.observaciones as observaciones, c.nombre_admi as nombre_admi, group_concat(DISTINCT(l.nombre_lateralidad)) as lateralidad, group_concat(DISTINCT(ci.nombre_cie)) as cie
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.cod_lptipo = $tipo_lista
                AND a.id_personal = $tipo_personal
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result_array();
        $this->db->close();
    }

    //JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa and ap.cod_lptipo = {$tipo_lista} and ap.id_personal={$tipo_personal}

    public function c_personal($fecha_inicial, $fecha_final, $tipo_personal)
    {
        $sql = "SELECT a.id_agenda as id_agenda, a.fecha as fecha, DATE_FORMAT(a.horainicio,'%H:%i') as horainicio, a.primer_nombre as primer_nombre, a.segundo_nombre as segundo_nombre, a.primer_apellido as primer_apellido, a.segundo_apellido as segundo_apellido, pa.identificacion as identificacion, 
             group_concat(DISTINCT(lp.nombre_listap)) as nom_procedimiento, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as nom_personal, a.estado as estado, a.telefono_paciente as telefono_paciente, a.celular_paciente as celular_paciente, a.observaciones as observaciones, c.nombre_admi as nombre_admi, group_concat(DISTINCT(l.nombre_lateralidad)) as lateralidad, group_concat(DISTINCT(ci.nombre_cie)) as cie
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie 
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario 
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.id_personal = $tipo_personal
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta->result_array();
        $this->db->close();
    }

    //JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa and ap.id_personal={$tipo_personal}
     
    public function c_nom_tipo($tipo_lista)
    {
        $this->db->select('nombre_lptipo');
        $this->db->where('cod_lptipo', $tipo_lista);
        $query = $this->db->get('listaprecios_tipo');

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
        $this->db->close();
    }

    public function c_nom_procedimiento($tipo_procedimiento)
    {
        $this->db->select('nombre_listap');
        $this->db->where('cod_listap', $tipo_procedimiento);
        $query = $this->db->get('listaprecios');

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
        $this->db->close();   
    }

    public function c_nom_personal($tipo_personal)
    {
        $this->db->select('nombre');
        $this->db->where('id', $tipo_personal);
        $query = $this->db->get('personal');

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
        $this->db->close();   
    }

    public function c_agenda($id)
    {
        $this->db->select('numeroa');
        $this->db->where('id_agenda', $id);
        $query = $this->db->get('agenda');

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
        $this->db->close();
    }

    public function conEditar($id) {
        $data = array();
        $this->db->select('p.id, a.id_agenda, a.numeroa, a.fecha, a.id_paciente, a.primer_nombre, a.segundo_nombre, a.primer_apellido, a.segundo_apellido, a.estado, u.nombre, u.nombre2, u.apellido1, u.apellido2, a.login_mod, a.fechaingreso, a.horaingreso, a.login_mod, a.fecha_mod, a.hora_mod,
            pa.sigla_sexo, pa.fecha_de_nacimiento, lp.nombre_listap, lt.nombre_lptipo, lp.frecuencia,a.color ');
        $this->db->select('a.telefono_paciente, a.celular_paciente');
        $this->db->select('a.tipo_docu, a.identificacion, p.nombre as personal, a.observaciones, a.cod_lptipo');
        $this->db->select('a.horainicio, a.horafin');
        $this->db->select('a.cod_listap, a.email, a.id_admi, co.nombre_admi, co.aplica_copago, co.porc_copago');
        $this->db->select('lp.nombre_listap, a.id_personal');
        $this->db->join('personal p', 'a.cod_medi = p.id');
        $this->db->join('listaprecios lp', 'lp.cod_listap = a.cod_listap');
        $this->db->join('listaprecios_tipo lt', 'lt.cod_lptipo = a.cod_lptipo');
        $this->db->join('usuarios u', 'u.login = a.login');
        $this->db->join('contratistas co', 'co.id_contratistas = a.id_admi', 'left outer');
        $this->db->join('pacientes pa', 'pa.id_paciente = a.id_paciente', 'left outer');
        $this->db->where('id_agenda', $id);
        $query = $this->db->get('agenda a');

        if ($query->num_rows() > 0) {
            $data = $query->row();
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    // consulta de facturas con el id de la agenda
    public function cons_facturas($id)
    {
        $this->db->select();
        $this->db->from('detalles');
        $this->db->where('documento_ref', $id);
        $this->db->where('proceso_ref', 'AG');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();  
    }

    public function c_procedimiento_tipo($bd_cod_lptipo)
    {
        $this->db->select();
        $this->db->from('listaprecios');
        $this->db->where('cod_lptipo', $bd_cod_lptipo);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();        
    }

    public function c_login_mod($login_modificar)
    {
        $cadena =   '';
        $this->db->select('nombre,nombre2, apellido1, apellido2');
        $this->db->where('login', $login_modificar);
        $query = $this->db->get('usuarios');
        foreach ($query->result_array() as $row) 
        {
            $cadena =   $row['nombre'].' '.$row['nombre2'].' '.$row['apellido1'].' '.$row['apellido2'];
            echo $cadena;
        }
        $query->free_result();
        $this->db->close();
    }

    public function conPAgenda($id)
    {
        $this->db->select('p.cod_listap, t.nombre_lptipo, lp.nombre_listap, pe.nombre, lp.frecuencia');
        $this->db->join('agenda a', "a.numeroa = p.numeroa AND a.id_agenda = '".$id."'");
        $this->db->join('listaprecios lp', 'lp.cod_listap = p.cod_listap');
        $this->db->join('listaprecios_tipo t', 't.cod_lptipo = p.cod_lptipo');
        $this->db->join('personal pe', 'pe.id = p.id_personal');
        $query = $this->db->get('agenda_procedimiento p');

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
        $this->db->close();
    }

    public function spersonal() {
        $data = array();
        $this->db->select('p.id,p.nombre');
        $this->db->join('usuarios u', "u.id = p.id_usuario and u.activo = 'SI'");
        $this->db->order_by('nombre','asc');
        $query = $this->db->get('personal p');

        if ($query->num_rows() > 0) {
            $data = $query->result();
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function personal() {
        $data = array();
        $this->db->select('id,nombre');
        $query = $this->db->get('personal');

        if ($query->num_rows() > 0) {
            $data = $query->result();
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function conTipo()
    {
        $data = array();
        $this->db->select('nombre_lptipo, cod_lptipo');
        $this->db->where('agenda', 'SI');
        //$this->db->where('division', '');
        $query = $this->db->get('listaprecios_tipo');

        if ($query->num_rows() > 0) {
            $data = $query->result();
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function conProcedimientos() {
        $data = array();
        $this->db->select('nombre_listap, cod_listap, color');
        $this->db->where('agenda', 'SI');
        $query = $this->db->get('listaprecios');

        if ($query->num_rows() > 0) {
            $data = $query->result();
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function conPersonal() {
        $data = array();
        $this->db->select('nombre, id');
        //$this->db->where('activo', 'SI');
        $this->db->order_by('nombre', 'asc');
        
        $query = $this->db->get('personal');

        if ($query->num_rows() > 0) {
            $data = $query->result();
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function conPersonal_id($id_usuario) {
        $data = array();
        $this->db->select('nombre, id, id_usuario');
        $this->db->where('activo', 'SI');
        $this->db->where('id_usuario', $id_usuario);

        $query = $this->db->get('personal');

        if ($query->num_rows() > 0) {
            $data = $query->result_array();
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function conClasificacion() {
        $data = array();
        $this->db->select('nombre_lptipo, cod_lptipo');
        $this->db->where('agenda', 'SI');
        //$this->db->where('division', '');
        $query = $this->db->get('listaprecios_tipo');

        if ($query->num_rows() > 0) {
            $data = $query->result();
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function procedimiento($clasificacion) {
        $cadena = '';
        $this->db->select();
        $this->db->from('listaprecios');
        $this->db->where('cod_lptipo', $clasificacion);
        $this->db->order_by('nombre_listap');
        $query = $this->db->get();
        $cadena .= "<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['cod_listap']}' frecuencia='{$row['frecuencia']}' data-color='{$row['color']}'  color='{$row['color']}'>{$row['nombre_listap']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function insertAgenda($data, $numeroa) {
        // ACTUALIZA LA HISTORIA EN CONSECUTIVOS
        $chistoria = array(
            'numero_consecutivo' => $numeroa,
        );
        $this->db->where('cod_consecutivo', 23);
        $this->db->update('consecutivos', $chistoria);

        return $this->db->insert('agenda', $data);
    }

    public function update($data, $id) {
        $this->db->where('id_agenda', $id);
        return $this->db->update('agenda', $data);
    }

    public function updateNoPaciente($data, $id) {
        $this->db->where('id_agenda', $id);
        return $this->db->update('agenda', $data);
    }

    public function delete($id) 
    {
        // CONSULTAR EL NUMEROA DE LA AGENDA 
        $this->db->select();
        $this->db->from('agenda');
        $this->db->where('id_agenda', $id);
        $query = $this->db->get();

        foreach ($query->result() as $row)
        {
            $numeroa    =    $row->numeroa;
            $this->db->where('numeroa', $numeroa);
            $this->db->delete('agenda_procedimiento');
        }

        $this->db->where('id_agenda', $id);
        return $this->db->delete('agenda');
    }

    public function update_cita($data, $id_agenda)
    {
        $this->db->where('id_agenda', $id_agenda);
        return $this->db->update('agenda', $data);
    }

    public function delete_aproc($numeroa)
    {
        $this->db->where('numeroa', $numeroa);
        return $this->db->delete('agenda_procedimiento');
    }

    public function xdef($modulo, $session_nivel_usuario) {
        $this->db->select('n.codprograma, n.codseccion, p.descripcion, p.vistav, vistafv, p.ruta, p.nombre');
        $this->db->from('nuxprograma n');
        $this->db->join('programas p', 'p.id = n.codprograma');
        $this->db->where('n.codmodulos', $modulo);
        $this->db->where('n.nivel_usuario', $session_nivel_usuario);
        $this->db->where('xdefmod', 'x');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }



    public function pacientes() {
        $this->db->select();
        $this->db->from('pacientes');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function medicos($session_idusuario) {
        $cadena = '';
        $this->db->select();
        $this->db->from('medicos');
        $this->db->where('id_usuario', $session_idusuario);
        $query = $this->db->get();

        if ($query->num_rows() === 1) {

            foreach ($query->result_array() as $row) {
                $cadena .= "<option value='{$row['cod_medi']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']}  {$row['primer_apellido_medi']}  {$row['segundo_apellido_medi']}  {$row['razon_social']}</option>";
            }

            echo $cadena;
        } else {
            $this->db->select();
            $this->db->from('medicos');
            $query2 = $this->db->get();
            $cadena .= "<option value='todos'>Todos los medicos</option>";

            foreach ($query2->result_array() as $row) {
                $cadena .= "<option value='{$row['cod_medi']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']}  {$row['primer_apellido_medi']}  {$row['segundo_apellido_medi']}  {$row['razon_social']}</option>";
            }

            echo $cadena;
            $query2->free_result();
        }

        $query->free_result();
    }

    public function fechanueva1($fechanueva, $medicosel, $idprograma) {

        if ($medicosel === 'todos') {
            $this->db->select('a.*, p.primer_nombre, p.segundo_nombre, p.primer_apellido, p.segundo_apellido ');
            $this->db->from('agenda a');
            $this->db->where('a.fecha', $fechanueva);
            $this->db->join('pacientes p', 'p.id_paciente = a.id_paciente');
            $this->db->order_by('a.horainicio');
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result_array();
            } else {
                return $query = array();
            }

        } else {
            $this->db->select('a.*, p.primer_nombre, p.segundo_nombre, p.primer_apellido, p.segundo_apellido ');
            $this->db->from('agenda a');
            $this->db->where('a.fecha', $fechanueva);
            $this->db->where('a.cod_medi', $medicosel);
            $this->db->join('pacientes p', 'p.id_paciente = a.id_paciente');
            $this->db->order_by('a.horainicio');
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result_array();
            } else {
                return $query = array();
            }

        }

        $query->free_result();
    }

    public function fechanueva($fechanueva, $medicosel, $idprograma) {
        $idprograma = trim($idprograma);

        if ($medicosel === 'todos') {

            if ($idprograma === '60') {
                //$this->db->select('a.*, p.primer_nombre, p.segundo_nombre, p.primer_apellido, p.segundo_apellido ');
                $this->db->select();
                $this->db->from('agenda a');
                $this->db->where('a.fecha', $fechanueva);
                //$this->db->join('pacientes p', 'p.id_paciente = a.id_paciente');
                $this->db->order_by('a.horainicio');
                $query = $this->db->get();

                if ($query->num_rows() > 0) {
                    return $query->result_array();
                } else {
                    return $query = array();
                }

            } else {
                //$this->db->select('a.*, p.primer_nombre, p.segundo_nombre, p.primer_apellido, p.segundo_apellido ');
                $this->db->select();
                $this->db->from('agenda a');
                $this->db->where('a.fecha', $fechanueva);
                $this->db->where('a.cancelo !=', 'S');
                //$this->db->join('pacientes p', 'p.id_paciente = a.id_paciente');
                $this->db->order_by('a.horainicio');
                $query = $this->db->get();

                if ($query->num_rows() > 0) {
                    return $query->result_array();
                } else {
                    return $query = array();
                }

            }

        } else {

            if ($idprograma === '60') {
                //$this->db->select('a.*, p.primer_nombre, p.segundo_nombre, p.primer_apellido, p.segundo_apellido ');
                $this->db->select();
                $this->db->from('agenda a');
                $this->db->where('a.fecha', $fechanueva);
                $this->db->where('a.cod_medi', $medicosel);
                //$this->db->join('pacientes p', 'p.id_paciente = a.id_paciente');
                $this->db->order_by('a.horainicio');
                $query = $this->db->get();

                if ($query->num_rows() > 0) {
                    return $query->result_array();
                } else {
                    return $query = array();
                }

            } else {
                //$this->db->select('a.*, p.primer_nombre, p.segundo_nombre, p.primer_apellido, p.segundo_apellido ');
                $this->db->select();
                $this->db->from('agenda a');
                $this->db->where('a.fecha', $fechanueva);
                $this->db->where('a.cod_medi', $medicosel);
                $this->db->where('a.cancelo !=', 'S');
                //$this->db->join('pacientes p', 'p.id_paciente = a.id_paciente');
                $this->db->order_by('a.horainicio');
                $query = $this->db->get();

                if ($query->num_rows() > 0) {
                    return $query->result_array();
                } else {
                    return $query = array();
                }

            }

        }

        $query->free_result();
    }

    public function hora_ini_fin() {
        $this->db->select();
        $this->db->from('modulo_agenda');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function consultorios() {
        $this->db->select();
        $this->db->from('consultorios');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function citaingreso1() {
        $login           = trim($this->input->post('histlogin'));
        $fecha           = trim($this->input->post('fecha'));
        $horainicio      = trim($this->input->post('horainicio'));
        $horafin         = trim($this->input->post('horafin'));
        $id_paciente     = trim($this->input->post('id_paciente'));
        $identificacion  = trim($this->input->post('identificacion'));
        $paciente        = trim($this->input->post('paciente'));
        $cod_medi        = trim($this->input->post('cod_medi'));
        $medico          = trim($this->input->post('medico'));
        $cod_consultorio = trim($this->input->post('cod_consultorio'));
        $observaciones   = trim($this->input->post('observaciones'));
        $fechaingreso    = trim($this->input->post('fechaingreso'));
        $horaingreso     = trim($this->input->post('horaingreso'));
        echo $horaingreso;
        exit();
    }

    public function citaingreso() {

        if ($this->input->post()) {
            $data = array(
                'login'           => trim($this->input->post('histlogin', true)),
                'fecha'           => trim($this->input->post('fecha', true)),
                'horainicio'      => trim($this->input->post('horainicio', true)),
                'horafin'         => trim($this->input->post('horafin', true)),
                'id_paciente'     => trim($this->input->post('id_paciente', true)),
                'identificacion'  => trim($this->input->post('identificacion', true)),
                'paciente'        => trim($this->input->post('paciente', true)),
                'cod_medi'        => trim($this->input->post('cod_medi', true)),
                'medico'          => trim($this->input->post('medico', true)),
                'cod_consultorio' => trim($this->input->post('cod_consultorio', true)),
                'observaciones'   => trim($this->input->post('observaciones', true)),
                'fechaingreso'    => trim($this->input->post('fechaingreso', true)),
                'horaingreso'     => trim($this->input->post('horaingreso', true)),
                'estado'          => 'Programado',
            );

            // INSERTAR DATOS
            $this->db->insert('agenda', $data);
        } else {
            redirect(base_url() . 'usuarios/avisosesion', 301);
        }

    }

    public function consulta_agenda($id_agenda) {
        $this->db->select();
        $this->db->from('agenda');
        $this->db->where('id_agenda', $id_agenda);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function modificarasistio() {

        if (!empty($this->session_id)) {

            if ($this->input->post()) {
                $id_agenda = trim($this->input->post('id_agenda'));
                $datos     = array(
                    'loginmod'  => $this->session_id,
                    'asistio'   => trim($this->input->post('asistio')),
                    'noasistio' => trim($this->input->post('noasistio')),
                    'fechamod'  => trim($this->input->post('fechamod')),
                    'horamod'   => trim($this->input->post('horamod')),
                    'motivo'    => trim($this->input->post('motivo')),
                    'estado'    => 'Asistió',
                );
                // ACTUALIZANDO DATOS ENCABEZADO
                $this->db->where('id_agenda', $id_agenda);
                $this->db->update('agenda', $datos);
            } else {
                redirect(base_url() . 'usuarios/avisosesion', 301);
            }

        } else {
            redirect(base_url() . 'usuarios/avisosesion', 301);
        }

    }

    public function modificarcancelo() {

        if (!empty($this->session_id)) {

            if ($this->input->post()) {
                $id_agenda = trim($this->input->post('id_agenda'));
                $datos     = array(
                    'loginmod'   => $this->session_id,
                    'asistio'    => trim($this->input->post('asistio')),
                    'noasistio'  => trim($this->input->post('noasistio')),
                    'fechamod'   => trim($this->input->post('fechamod')),
                    'horamod'    => trim($this->input->post('horamod')),
                    'motivo'     => trim($this->input->post('motivo')),
                    'cancelo'    => trim($this->input->post('cancelo')),
                    'reprogramo' => trim($this->input->post('reprogramo')),
                    'estado'     => 'Canceló',
                );
                // ACTUALIZANDO DATOS ENCABEZADO
                $this->db->where('id_agenda', $id_agenda);
                $this->db->update('agenda', $datos);
            } else {
                redirect(base_url() . 'usuarios/avisosesion', 301);
            }

        } else {
            redirect(base_url() . 'usuarios/avisosesion', 301);
        }

    }

    public function modificarreprogramo() {

        if (!empty($this->session_id)) {

            if ($this->input->post()) {
                $id_agenda = trim($this->input->post('id_agenda'));
                $datos     = array(
                    'loginmod'        => $this->session_id,
                    'asistio'         => trim($this->input->post('asistio')),
                    'noasistio'       => trim($this->input->post('noasistio')),
                    'fechamod'        => trim($this->input->post('fechamod')),
                    'horamod'         => trim($this->input->post('horamod')),
                    'motivo'          => trim($this->input->post('motivo')),
                    'cancelo'         => trim($this->input->post('cancelo')),
                    'reprogramo'      => trim($this->input->post('reprogramo')),
                    'cod_medi'        => trim($this->input->post('cod_medi')),
                    'medico'          => trim($this->input->post('medico')),
                    'fecha'           => trim($this->input->post('fecha')),
                    'horainicio'      => trim($this->input->post('horainicio')),
                    'horafin'         => trim($this->input->post('horafin')),
                    'fecha_ante'      => trim($this->input->post('fecha_ante')),
                    'horainicio_ante' => trim($this->input->post('horainicio_ante')),
                    'horafin_ante'    => trim($this->input->post('horafin_ante')),
                    'estado'          => 'Reprogramó',
                );
                // ACTUALIZANDO DATOS ENCABEZADO
                $this->db->where('id_agenda', $id_agenda);
                $this->db->update('agenda', $datos);
            } else {
                redirect(base_url() . 'usuarios/avisosesion', 301);
            }

        } else {
            redirect(base_url() . 'usuarios/avisosesion', 301);
        }

    }

    public function consultarcita($id_agenda) {
        $this->db->select();
        $this->db->from('agenda');
        $this->db->where('id_agenda', $id_agenda);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function cpaciente($id_paciente) {
        $this->db->select('p.*, c.nombre_admi');
        $this->db->from('pacientes p');
        $this->db->join('contratistas c', 'c.id_contratistas = p.id_admi');
        $this->db->where('p.id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function cmedico($cod_medi) {
        $this->db->select();
        $this->db->from('medicos');
        $this->db->where('cod_medi', $cod_medi);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function consultausuario($login) {
        $this->db->select();
        $this->db->from('usuarios');
        $this->db->where('login', $login);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function consumedico($codpersonaatie, $login, $idusuario) {

        if ($codpersonaatie === '20' || $codpersonaatie === '21') {
            $this->db->select();
            $this->db->from('medicos');
            $this->db->where('loginasistente', $login);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result_array();
            } else {
                $this->db->select('m.*');
                $this->db->from('medicoxasistente x');
                $this->db->where('x.login', $login);
                $this->db->join('medicos m', 'x.cod_medi = m.cod_medi');
                $query1 = $this->db->get();

                if ($query1->num_rows() > 0) {
                    return $query1->result_array();
                } else {
                    return $query1 = array();
                }

            }

        } else {

            $this->db->select();
            $this->db->from('medicos');
            $this->db->where('id_usuario', $idusuario);
            $query = $this->db->get();

            if ($query->num_rows() > 0) {
                return $query->result_array();
            } else {
                return $query = array();
            }

        }

        $query->free_result();
    }

    public function agendaok($id_agenda, $loginmod) {

        if ($this->input->post()) {
            $id_agenda = trim($this->input->post('id_agenda'));

            $datos = array(
                'loginmod'  => $loginmod,
                'asistio'   => 'S',
                'noasistio' => 'N',
                'cancelo'   => 'N',
                'fechamod'  => $fechamod,
                'horamod'   => $horamod,
                'estado'    => 'Asistió',
            );
            // ACTUALIZANDO DATOS ENCABEZADO
            $this->db->where('id_agenda', $id_agenda);
            $this->db->update('agenda', $datos);
        }

    }

    public function agendax($id_agenda, $loginmod) {

        if ($this->input->post()) {
            $id_agenda = trim($this->input->post('id_agenda'));

            $datos = array(
                'loginmod'  => $loginmod,
                'asistio'   => 'N',
                'noasistio' => 'S',
                'cancelo'   => 'S',
                'fechamod'  => $fechamod,
                'horamod'   => $horamod,
                'estado'    => 'Canceló',
            );
            // ACTUALIZANDO DATOS ENCABEZADO
            $this->db->where('id_agenda', $id_agenda);
            $this->db->update('agenda', $datos);
        }

    }

    public function agendae($id_agenda) {

        if ($this->input->post()) {
            $id_agenda = trim($this->input->post('id_agenda'));

            // ELIMINANDO DATOS ENCABEZADO
            $this->db->where('id_agenda', $id_agenda);
            $this->db->delete('agenda');
        }

    }

    public function horario() {
        $this->db->select('hilunes, hflunes, himartes, hfmartes, himiercoles, hfmiercoles, hijueves, hfjueves, hiviernes, hfviernes, hisabado, hfsabado, hidomingo, hfdomingo');
        $this->db->from('modulo_agenda');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function ingresopaciente($paciente, $numeroc) 
    {
        // ACTUALIZA LA HISTORIA EN CONSECUTIVOS
        $chistoria = array(
            'numero_consecutivo' => $numeroc,
        );
        $this->db->where('cod_consecutivo', 10);
        $this->db->update('consecutivos', $chistoria);

        // INSERTA PACIENTE
        return $this->db->insert('pacientes', $paciente);
    }


    public function consultaconsecutivo($numero) {
        $data = array();
        $this->db->select('numero_consecutivo');
        $this->db->where('cod_consecutivo', $numero);
        $query = $this->db->get('consecutivos');

        if ($query->num_rows() > 0) {
            $n    = $query->result();
            $data = (int) $n[0]->numero_consecutivo + 1;
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function persona_atiende($id_usuario)
    {
        $this->db->select('u.cod_persona_atie, pa.nombre_persona_atie, u.login, pa.cups,u.medico');
        $this->db->from('usuarios u');
        $this->db->join('persona_atiende pa','pa.cod_persona_atie = u.cod_persona_atie');
        $this->db->where('u.id',$id_usuario);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }

    public function insertarrutaagen($dingreso)
    {
        return $this->db->insert('ruta', $dingreso);
    }

    // INSERTAR ENCABEZADO GN
    public function insertarencabezado($datencabezadon)
    {
        return $this->db->insert('encabezado', $datencabezadon);
    }

    public function id_paciente($tipo_docu, $identificacion) {
        $data = array();
        $this->db->select('id_paciente');
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get('pacientes');

        if ($query->num_rows() > 0) {
            $data = $query->row()->id_paciente;
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function usuarios()
    {
        $this->db->select();
        $this->db->from('usuarios');
        $this->db->where('activo', 'SI');
        $this->db->where_not_in('id', 1);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function ingresopersonal($personal)
    {
        // INSERTA PERSONAL
        return $this->db->insert('personal', $personal);
    }

    // modificacion personal
    public function cpersonal()
    {
        $this->db->select();
        $this->db->from('personal');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function c_id_usuario($bd_id_usuario_personal)
    {
        $this->db->select();
        $this->db->where('id_usuario', $bd_id_usuario_personal);
        $this->db->from('personal');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function actualizarpersonal($personal, $bd_id_personal)
    {
        $this->db->where('id', $bd_id_personal);
        $this->db->update('personal', $personal);
    }

    public function entero()
    {
        $this->db->select();
        $this->db->from('tipo_entero');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
    }

    public function insertEncuestaG($m_general)
    {
        // INSERTA ENCUESTA GENERAL
        return $this->db->insert('pacientes_encg', $m_general);
    }

    public function insertEncuestaC($m_cerebral)
    {
        // INSERTA ENCUESTA CEREBRAL
        return $this->db->insert('pacientes_encc', $m_cerebral);
    }

    public function insertEncuestaM($m_menopausia)
    {
        // INSERTA ENCUESTA CEREBRAL
        return $this->db->insert('pacientes_encm', $m_menopausia);
    }

    public function insertEncuestaA($m_adam)
    {
        // INSERTA ENCUESTA CEREBRAL
        return $this->db->insert('pacientes_enca', $m_adam);
    }

    public function insertProcedimiento($m_proced)
    {
        return $this->db->insert('agenda_procedimiento', $m_proced);
    }

    public function conTipo_lista($tipo_lista)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('listaprecios');
        $this->db->where('cod_lptipo', $tipo_lista);
        $this->db->order_by('nombre_listap');
        $query = $this->db->get();
        $cadena .= "<option value='all'>Todos</option>";
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['cod_listap']}' data-color='{$row['color']}' >{$row['nombre_listap']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }
 
    public function tipodocumenton()
    {        
        $this->db->select();
        $this->db->from('tipo_documento');
        $query = $this->db->get();            
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }   

    public function medicosel($persona, $id_usuario, $login) {
        $cadena = '';

        //if ($persona === 20 || $persona === 21) {
        if ($persona) {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            //$this->db->where('m.loginasistente', $login);
            $query = $this->db->get();

            //$cadena.="<option value=''>Seleccione Médico . . .</option>";
            if ($query->num_rows() > 0) {
                foreach ($query->result_array() as $row) {
                    $cadena .= "<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";

                }

            } else {
                $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
                $this->db->from('medicoxasistente x');
                $this->db->where('x.login', $login);
                $this->db->join('medicos m', 'x.cod_medi = m.cod_medi');
                $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
                $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');

                $query1 = $this->db->get();
                foreach ($query1->result_array() as $row) {
                    $cadena .= "<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
                }

            }

            echo $cadena;
        } else {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            $this->db->where('m.id_usuario', $id_usuario);
            $query = $this->db->get();
            $cadena .= "";
            foreach ($query->result_array() as $row) {
                $cadena .= "<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }

            echo $cadena;
        }

        $query->free_result();
    }

    public function tipodocumento() {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_documento');
        $query = $this->db->get();
        $cadena .= "<option value=''>Seleccione . . .</option>";

        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['tipo_docu']}' caracter = '{$row['caracteres']}'>{$row['tipo_docu']} - {$row['nombre_tipo_docu']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function sexo() {
        $cadena = '';
        $this->db->select();
        $this->db->from('sexo');
        $this->db->where_not_in('sigla_sexo', 'A');
        $query = $this->db->get();
        $cadena .= "<option value=''>Seleccione . . .</option>";

        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['sigla_sexo']}'>{$row['nombre_sexo']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function estadocivil() {
        $cadena = '';
        $this->db->select();
        $this->db->from('estadocivil');
        $query = $this->db->get();

        //$cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['cod_estado_civi']}'>{$row['nombre_estado_civi']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function rh() {
        $cadena = '';
        $this->db->select();
        $this->db->from('gruposanguineo');
        $query = $this->db->get();

        //$cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['cod_grupo_sang']}'>{$row['cod_grupo_sang']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function pais() {
        $cadena = '';
        $this->db->select();
        $this->db->from('paises');
        $this->db->where('cod_pais', '169');
        $query3 = $this->db->get();
        $cadena .= "";
        foreach ($query3->result_array() as $row) {
            $cadena .= "<option class='registrolista' value='{$row['cod_pais']}'>{$row['nombre_pais']}</option>";
            $this->db->select();
            $this->db->from('paises');
            $this->db->where_not_in('cod_pais', '169');
            $query4 = $this->db->get();
            foreach ($query4->result_array() as $row) {
                $cadena .= "<option value='{$row['cod_pais']}'>{$row['nombre_pais']}</option>";
            }

        }

        echo $cadena;
        $query3->free_result();
        $query4->free_result();
    }

    public function departamento($pais) {
        $cadena = '';
        $this->db->select();
        $this->db->from('departamento');
        $this->db->order_by('nombre_depa', 'ASC');
        $this->db->where('cod_pais', $pais);
        $query = $this->db->get();
        $cadena .= "<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['id_depa']}'>{$row['nombre_depa']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function ciudad($pais, $departamento) {
        $cadena = '';
        $this->db->select();
        $this->db->from('municipio');
        $this->db->where('cod_pais', $pais);
        $this->db->where('id_depa', $departamento);
        $this->db->order_by('nombre_muni', ASC);
        $query = $this->db->get();
        $cadena .= "<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['id_muni']}'>{$row['nombre_muni']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function zonaresidencia() {
        $cadena = '';
        $this->db->select();
        $this->db->from('zona_residencia');
        $query = $this->db->get();

        //$cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['cod_zona_resi']}'>{$row['nombre_zona_resi']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function tipousuario() {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_usuario');
        $this->db->order_by('orden', 'asc');
        $query = $this->db->get();
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['cod_tipo_usua']}'>{$row['nombre_tipo_usua']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }

    public function videntificacion($tipo_docu, $identificacion) {
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();
        echo $query->num_rows();
        $query->free_result();
    }

    public function cfecha($fecha, $horainicio, $horafinal, $cod_listap, $frecuencia)
    {
        $array      =   array('fecha' => $fecha, 'horainicio' => $horainicio, 'horafin' => $horafinal);
        
        

        $cadena     =   '';
        $contar     =   0;

        $this->db->select();
        $this->db->from('agenda');
        $this->db->where($array);

        $query = $this->db->get();
        foreach ($query->result_array() as $row) 
        {
            $numeroa    =   $row['numeroa'];
            $fecha      =   $row['fecha'];
            $horainicio =   $row['horainicio'];
            $horafin    =   $row['horafin'];

            
            //exit();

            $this->db->select();
            $this->db->from('agenda_procedimiento');
            $this->db->where('numeroa', $numeroa);
            $this->db->where('cod_listap', $cod_listap);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row) 
            {
                $cadena .= "{$row['numeroa']}'-'{$row['cod_listap']}'";
                $cadena .= "\n";
                $contar = $contar + 1;
                
                //echo $frecuencia.' -- '.$contar;
                if($contar >= $frecuencia)
                {
                    echo 'sobrepaso la cantidad establecida para el procedimiento';
                }else{
                    echo 'no supera';
                }
            }

            $query2->free_result();   
        }


        $query->free_result();   
    }

    public function agendapac($bus_pac)
    {
        $this->db->select('a.*, l.nombre_listap, u.nombre, u.nombre2, u.apellido1,u.apellido2');
        $this->db->from('agenda a');
        $this->db->join('listaprecios l', 'l.cod_listap = a.cod_listap');
        $this->db->join('personal p', 'p.id = a.id_personal');
        $this->db->join('usuarios u', 'u.id = p.id_usuario');
        $this->db->like('a.identificacion', $bus_pac);
        $query2 = $this->db->get();
        if($query2->num_rows() > 0)
        {
            return $query2->result_array();
        }else
        {
            return $query2 = array();
        }
        $query2->free_result();
    }

    public function c_numeroa($id)
    {
        $this->db->select('numeroa');
        $this->db->from('agenda');
        $this->db->where('id_agenda', $id);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }

    public function c_proc($numeroa)
    {
        $this->db->select('ap.id_personal, ap.cod_listap, p.codigo');
        $this->db->from('agenda_procedimiento ap');
        $this->db->join('personal p', 'p.id = ap.id_personal');
        $this->db->where('ap.numeroa', $numeroa);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }

    public function c_todos_xls($fecha_inicial, $fecha_final)
    {        
        $sql = "SELECT a.fecha as Fecha, DATE_FORMAT(a.horainicio,'%H:%i') as Hora, CONCAT(a.primer_nombre, "."' '".", a.segundo_nombre, "."' '".", a.primer_apellido, "."' '".", a.segundo_apellido) as Paciente, pa.identificacion as Identificacion, group_concat(DISTINCT(l.nombre_lateralidad)) as Lateralidad,
             group_concat(DISTINCT(lp.nombre_listap)) as Procedimiento, group_concat(DISTINCT(ci.nombre_cie)) as Diagnostico, CONCAT(a.telefono_paciente, "."' '".", a.celular_paciente) as Telefonos, c.nombre_admi as EPS, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as Profesional, a.observaciones as Observaciones
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}'
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta;
        $this->db->close();
    }      

    /// JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa 

    public function c_tipolista_xls($fecha_inicial, $fecha_final, $tipo_lista)
    {
        $sql = "SELECT a.fecha as Fecha, DATE_FORMAT(a.horainicio,'%H:%i') as Hora, CONCAT(a.primer_nombre, "."' '".", a.segundo_nombre, "."' '".", a.primer_apellido, "."' '".", a.segundo_apellido) as Paciente, pa.identificacion as Identificacion, group_concat(DISTINCT(l.nombre_lateralidad)) as Lateralidad,
             group_concat(DISTINCT(lp.nombre_listap)) as Procedimiento, group_concat(DISTINCT(ci.nombre_cie)) as Diagnostico, CONCAT(a.telefono_paciente, "."' '".", a.celular_paciente) as Telefonos, c.nombre_admi as EPS, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as Profesional, a.observaciones as Observaciones
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie 
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario 
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.cod_lptipo = $tipo_lista
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta;
        $this->db->close();
    }

    // JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa AND ap.cod_lptipo = {$tipo_lista}

    public function c_procedimiento_xls($fecha_inicial, $fecha_final, $tipo_procedimiento)
    {
        $sql = "SELECT a.fecha as Fecha, DATE_FORMAT(a.horainicio,'%H:%i') as Hora, CONCAT(a.primer_nombre, "."' '".", a.segundo_nombre, "."' '".", a.primer_apellido, "."' '".", a.segundo_apellido) as Paciente, pa.identificacion as Identificacion, group_concat(DISTINCT(l.nombre_lateralidad)) as Lateralidad,
             group_concat(DISTINCT(lp.nombre_listap)) as Procedimiento, group_concat(DISTINCT(ci.nombre_cie)) as Diagnostico, CONCAT(a.telefono_paciente, "."' '".", a.celular_paciente) as Telefonos, c.nombre_admi as EPS, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as Profesional, a.observaciones as Observaciones
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.cod_listap = $tipo_procedimiento
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta;
        $this->db->close();
    }

    // JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa AND ap.cod_listap = {$tipo_procedimiento}

    public function c_procedimiento_per_xls($fecha_inicial, $fecha_final, $tipo_procedimiento, $tipo_personal)
    {
        $sql = "SELECT a.fecha as Fecha, DATE_FORMAT(a.horainicio,'%H:%i') as Hora, CONCAT(a.primer_nombre, "."' '".", a.segundo_nombre, "."' '".", a.primer_apellido, "."' '".", a.segundo_apellido) as Paciente, pa.identificacion as Identificacion, group_concat(DISTINCT(l.nombre_lateralidad)) as Lateralidad,
             group_concat(DISTINCT(lp.nombre_listap)) as Procedimiento, group_concat(DISTINCT(ci.nombre_cie)) as Diagnostico, CONCAT(a.telefono_paciente, "."' '".", a.celular_paciente) as Telefonos, c.nombre_admi as EPS, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as Profesional, a.observaciones as Observaciones
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario  
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.cod_listap = $tipo_procedimiento
                AND a.id_personal = $tipo_personal
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta;
        $this->db->close();
    }

    // JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa AND ap.cod_listap = {$tipo_procedimiento} and ap.id_personal = {$tipo_personal}

    public function c_tipo_pers_xls($fecha_inicial, $fecha_final, $tipo_lista, $tipo_personal)
    {
        $sql = "SELECT a.fecha as Fecha, DATE_FORMAT(a.horainicio,'%H:%i') as Hora, CONCAT(a.primer_nombre, "."' '".", a.segundo_nombre, "."' '".", a.primer_apellido, "."' '".", a.segundo_apellido) as Paciente, pa.identificacion as Identificacion, group_concat(DISTINCT(l.nombre_lateralidad)) as Lateralidad,
             group_concat(DISTINCT(lp.nombre_listap)) as Procedimiento, group_concat(DISTINCT(ci.nombre_cie)) as Diagnostico, CONCAT(a.telefono_paciente, "."' '".", a.celular_paciente) as Telefonos, c.nombre_admi as EPS, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as Profesional, a.observaciones as Observaciones
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.cod_lptipo = $tipo_lista
                AND a.id_personal = $tipo_personal
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta;
        $this->db->close();
    }

    // JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa AND ap.cod_lptipo = {$tipo_lista} and ap.id_personal = {$tipo_personal}

    public function c_personal_xls($fecha_inicial, $fecha_final, $tipo_personal)
    {
        $sql = "SELECT a.fecha as Fecha, DATE_FORMAT(a.horainicio,'%H:%i') as Hora, CONCAT(a.primer_nombre, "."' '".", a.segundo_nombre, "."' '".", a.primer_apellido, "."' '".", a.segundo_apellido) as Paciente, pa.identificacion as Identificacion, group_concat(DISTINCT(l.nombre_lateralidad)) as Lateralidad,
             group_concat(DISTINCT(lp.nombre_listap)) as Procedimiento, group_concat(DISTINCT(ci.nombre_cie)) as Diagnostico, CONCAT(a.telefono_paciente, "."' '".", a.celular_paciente) as Telefonos, c.nombre_admi as EPS, CONCAT(us.nombre,' ',us.nombre2,' ',us.apellido1,' ',us.apellido2) as Profesional, a.observaciones as Observaciones
                FROM agenda a
                JOIN contratistas c ON c.id_admi = a.id_admi
                
                JOIN listaprecios lp ON lp.cod_listap = a.cod_listap
                LEFT OUTER JOIN pacientes pa ON pa.id_paciente = a.id_paciente 
                LEFT OUTER JOIN detalles d ON  d.documento_ref = a.id_agenda and d.proceso_ref = 'AG'
                LEFT OUTER JOIN tipo_lateralidad l ON l.id_lateralidad = d.lateralidad  
                LEFT OUTER JOIN cie10 ci ON ci.cod_cie = d.cod_cie  
                JOIN personal per ON per.id = a.cod_medi
                JOIN usuarios us ON us.id = per.id_usuario
                WHERE (a.fecha BETWEEN '{$fecha_inicial}' AND '{$fecha_final}')
                AND a.id_personal = $tipo_personal
                GROUP BY a.id_agenda
                ORDER BY a.fecha, a.horainicio
                ";
        $consulta = $this->db->query($sql) or die(mysql_error());
        return $consulta;
        $this->db->close();
    }

    // JOIN agenda_procedimiento ap ON a.numeroa = ap.numeroa and ap.id_personal = {$tipo_personal}

    // INFORME SUPER
    public function c_super_x_fecha($fecha_inicial, $fecha_final)
    {        
        $this->db->select('id_paciente, fechaingreso, fecha, horainicio, horafin, primer_nombre, segundo_nombre, primer_apellido, segundo_apellido, nom_procedimiento, nom_personal, estado, telefono_paciente, celular_paciente, observaciones');
        $this->db->where('fechaingreso BETWEEN "'. date('Y-m-d', strtotime($fecha_inicial)). '" and "'. date('Y-m-d', strtotime($fecha_final)).'"');
        $this->db->order_by('fechaingreso');
        $query = $this->db->get('agenda');

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return $query = array();
        }

        $query->free_result();
        $this->db->close();
    }    

    public function c_super_x_fecha_xls($fecha_inicial, $fecha_final)
    {        
        $fecha_inicial  =   date('Y-m-d', strtotime($fecha_inicial));
        $fecha_final    =   date('Y-m-d', strtotime($fecha_final));
        
        $query = $this->db->query('SELECT fechaingreso as "F/Ingreso", fecha as "F/Agenda", horainicio as "H/Inicio", horafin as "H/Final", id_paciente as ID, CONCAT(primer_nombre, '.'" "'.', segundo_nombre,  '.'" "'.', primer_apellido, '.'" "'.', segundo_apellido) as Paciente, CONCAT(telefono_paciente, '.'" "'.', celular_paciente) as Telefonos, nom_procedimiento as Procedimiento, nom_personal as Profesional, estado as Estado,  observaciones as Observaciones FROM agenda where fechaingreso BETWEEN "'.$fecha_inicial.'" and"'. $fecha_final .'" order by fechaingreso');

        
            return $query;  
        

        $query->free_result();
        $this->db->close();
    } 

    // consulta de paciente
    public function cipaciente($id_paciente)
    {
        $this->db->select('p.*, td.nombre_tipo_docu, sx.nombre_sexo, pa.nombre_pais, de.nombre_depa, mu.nombre_muni,  
        ec.nombre_estado_civi, zr.nombre_zona_resi, tu.nombre_tipo_usua, co.nombre_admi');
        $this->db->from('pacientes p');
        $this->db->join('tipo_documento td', 'td.tipo_docu = p.tipo_docu');  
        $this->db->join('sexo sx', 'sx.sigla_sexo = p.sigla_sexo');
        $this->db->join('paises pa', 'pa.cod_pais = p.cod_pais');
        $this->db->join('departamento de', 'de.cod_pais = p.cod_pais AND de.id_depa = p.id_depa');
        $this->db->join('municipio mu', 'mu.cod_pais = p.cod_pais AND mu.id_depa = p.id_depa AND mu.id_muni = p.id_muni');
        $this->db->join('estadocivil ec', 'ec.cod_estado_civi = p.cod_estado_civi');
        $this->db->join('zona_residencia zr', 'zr.cod_zona_resi = p.cod_zona_resi');
        $this->db->join('tipo_usuario tu', 'tu.cod_tipo_usua = p.cod_tipo_usua');
        $this->db->join('contratistas co', 'co.id_admi = p.id_admi');
        $this->db->where('p.id_paciente', $id_paciente);      
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }else
        {
            return false;
        }
        $query->free_result(); 
    } 


    public function convenios()  
    {        
        $this->db->select();
        $this->db->from('contratistas');                
        $this->db->where('activo', 'SI');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }

    public function especialidad()
    {
        $this->db->select();
        $this->db->from('cups_tipoprocedimiento');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();   
    }

    // facturacion de cups desde agenda
    // insertar encabezado
    public function insertEncabezadoFact($m_encabezado, $numero_docu) {
        // ACTUALIZA LA HISTORIA EN CONSECUTIVOS
        $consecutivo = array(
            'numero_consecutivo' => $numero_docu,
        );
        $this->db->where('cod_consecutivo', 2);
        $this->db->update('consecutivos', $consecutivo);

        return $this->db->insert('encabezado', $m_encabezado);
        $this->db->close();
    }

    public function insertDetallesFact($m_proced)
    {
        return $this->db->insert('detalles', $m_proced);
        $this->db->close();
    }

    public function cons_autorizacion($autorizacion)
    {
        $this->db->select();
        $this->db->from('encabezado');
        $this->db->where('ref_procesos', 'FA');
        $this->db->where('autorizacion', $autorizacion);
        $query = $this->db->get();
        $data = '';
        if ($query->num_rows() > 0) {
            $data = '1';
        } else {
            $data = false;
        }

        echo $data;

        $query->free_result();
    }

    public function cons_factura($id_agenda, $id_paciente)
    {
        $this->db->select();
        $this->db->from('encabezado');
        $this->db->where('proceso_ref', 'AG');
        $this->db->where('documento_ref', $id_agenda);
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('procesada', 'NO');
        $query = $this->db->get();
        $data = '';
        if ($query->num_rows() > 0) {
            $data = '1';
        } else {
            $data = false;
        }
        echo $data;
        $query->free_result();
    }

    public function quitar_evento($id_agenda, $login_modificar, $fecha_mod, $hora_mod)
    {
        
        $sql = "INSERT INTO agenda_log SELECT * FROM agenda WHERE id_agenda=$id_agenda";
        $consulta = $this->db->query($sql) or die(mysql_error());
        
        $m_evento = array(
            'estado'    =>  '',
            'login_mod' =>  $login_modificar,
            'fecha_mod' =>  $fecha_mod,
            'hora_mod'  =>  $hora_mod,
            'color'     =>  '#5348d4'

        );

        $this->db->where('id_agenda', $id_agenda);
        $this->db->update('agenda', $m_evento);      

        $sql = "INSERT INTO agenda_log SELECT * FROM agenda WHERE id_agenda=$id_agenda";
        $consulta = $this->db->query($sql) or die(mysql_error()); 
    }

    public function quitar_cita($id_agenda, $login_modificar, $fecha_mod, $hora_mod, $numeroa)
    {
        
        $sql = "INSERT INTO agenda_log SELECT * FROM agenda WHERE id_agenda=$id_agenda";
        $consulta = $this->db->query($sql) or die(mysql_error());
        
        $m_evento = array(
            'estado'    =>  'Elimino',
            'login_mod' =>  $login_modificar,
            'fecha_mod' =>  $fecha_mod,
            'hora_mod'  =>  $hora_mod
        );

        $this->db->where('id_agenda', $id_agenda);
        $this->db->update('agenda_log', $m_evento);  

        $sql2 = "INSERT INTO agenda_procedimiento_log SELECT * FROM agenda_procedimiento WHERE numeroa=$numeroa";
        $consulta2 = $this->db->query($sql2) or die(mysql_error());

        $this->db->where('numeroa', $numeroa);
        $this->db->delete('agenda_procedimiento');

        
        $this->db->where('id_agenda', $id_agenda);
        return $this->db->delete('agenda');
    }

    public function lateralidad()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_lateralidad');
        $query = $this->db->get();
        foreach ($query->result_array() as $row) {
            $cadena .= "<option value='{$row['id_lateralidad']}' >{$row['nombre_lateralidad']}</option>";
        }

        echo $cadena;
        $query->free_result();
    }    

    public function lateralidad_g()
    {
        $this->db->select();
        $this->db->from('tipo_lateralidad');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }    

    // consulta convenios de eps
    public function conConvenioEps()
    {
        $this->db->select();
        $this->db->from('contratistas_convenio');        
        $this->db->where('activo', 'SI');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }

    // consulta contratistas
    public function conContratistas()
    {
        $this->db->select();
        $this->db->from('contratistas');        
        $this->db->where('activo', 'SI');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();    

    }

}