<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Facturacion_model extends CI_Model
{    
	public function __construct()
    {
        parent::__construct();        
        $this->load->library('consecutivo'); 	        
    }

    public function administradoras()
    {
        $this->db->select();
        $this->db->from('administradoras');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function contratistas()
    {
        $this->db->select();
        $this->db->from('contratistas');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();   
    }

    public function ingresocontratista($contratista)
    {
        return $this->db->insert('contratistas', $contratista);
        $this->db->close();
    }

    public function  actualizarcontratista($id_contratistas, $contratista)
    {
        $this->db->where('id_contratistas', $id_contratistas);
        $this->db->update('contratistas', $contratista);
        $this->db->close();
    }

    public function con_cups($id_contratistas)
    {
        $this->db->select();
        $this->db->from('contratistas_cups');        
        $this->db->where('id_contratistas', $id_contratistas);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();      
    }

    public function eliminarDetalles($id_contratistas)
    {
        // BORRADO DE LOS CUPS X CONTRATO DEPENDEN DE ID
        $this->db->where('id_contratistas', $id_contratistas);
        $this->db->delete('contratistas_cups');
    }

    public function insertDetalles($o_detalles)
    {
        // INGRESO DE LOS NUEVOS ITEMS AL CONTRATO
        return $this->db->insert('contratistas_cups', $o_detalles); 
        $this->db->close();
    }

    public function updateDetalles($o_detalles, $id_cups)
    {
        // actualizar cups del contratista o eps
        $this->db->where('id_cups', $id_cups);
        $this->db->update('contratistas_cups', $o_detalles);
        $this->db->close();
    }

    public function insertNewCups($m_nuevo_cups)
    {
        // ingreso nuevo cups a la bd de cups
        return $this->db->insert('cups', $m_nuevo_cups);
        $this->db->close();
    }

    public function cons_cups($cod_cups, $id_contratista)
    {
        $this->db->select();
        $this->db->from('contratistas_cups');        
        $this->db->where('id_contratistas', $id_contratista);
        $this->db->where('cod_cups', $cod_cups);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return false;
        }
        $query->free_result();      
    }

    public function cons_id($cod_cups)
    {
        $this->db->select('id_cups');
        $this->db->from('cups');        
        $this->db->where('cod_cups', $cod_cups);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $row = $query->row();
            return $row->id_cups;
        }else
        {
            return false;
        }
        $query->free_result();
    }

    /// facturacion consulta de encabezado
    public function encabezado($numero_docu, $id_paciente, $ref_procesos)
    {
        $this->db->select('e.id_paciente, e.fechaingreso, e.numero_docu, e.id_admi, c.nombre_admi, p.tipo_docu, p.identificacion, p.primer_nombre, p.segundo_nombre, p.primer_apellido, p.segundo_apellido, e.autorizacion, e.fecha_autorizacion, e.valor_bruto, e.porc_copago, e.valor_copago, e.valor_total,
            e.seccional, e.contrato, e.carne, e.nivel, e.historia');
        $this->db->from('encabezado e');    
        $this->db->join('pacientes p', 'p.id_paciente = e.id_paciente', 'left outer');   
        $this->db->join('contratistas c', 'c.id_contratistas = e.id_admi', 'left outer');         
        $this->db->where('e.ref_procesos', $ref_procesos);
        $this->db->where('e.numero_docu', $numero_docu);  
        $this->db->where('e.id_paciente', $id_paciente);  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function detalles_cie($numero_docu, $id_paciente, $ref_procesos)
    {
        $this->db->select('id_paciente, cod_cie, nombre_cie');
        $this->db->from('detalles');    
        $this->db->where('ref_procesos', $ref_procesos);
        $this->db->where('numero_docu', $numero_docu);  
        $this->db->where('id_paciente', $id_paciente);  
        $this->db->where_not_in('cod_cie', '');  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }
    public function detalles_cups($numero_docu, $id_paciente, $ref_procesos)
    {
        $this->db->select('id_paciente, cod_cups, cantidad, nombre_cups, valor_cups, valor_total');
        $this->db->from('detalles');    
        $this->db->where('ref_procesos', $ref_procesos);
        $this->db->where('numero_docu', $numero_docu);  
        $this->db->where('id_paciente', $id_paciente); 
        $this->db->where_not_in('cod_cups', '');   
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    /// facturacion consulta de detalles
    /// 
    /// 
    /// consulta de paciente
    public function paciente($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes');    
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    } 

    
}