<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Historia_model extends CI_Model
{    
	public function __construct()
    {
        parent::__construct();        
        $this->load->library('consecutivo'); 	        
    }
    
    public function silueta($id_paciente) {
        $data = [];
        $this->db->select('notes');
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get('pacientes_exa');

        if ($query->num_rows() > 0) {
            $res  = $query->row();
            $data = $res->notes;
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }
    
    public function pacienteconsulta()
    {
        $query = $this->db->get('pacientes');
        return $query;
    }  
    
    public function pacienteconsultatotal()
    {
        $this->db->count_all('pacientes');
        $query = $this->db->get();
        return $query;
        $query->free_result();
    }  
    
    public function pacienteconsulta1($limit, $offset)
    {
        $bnombre = $this->input->post('bnombre');
        $this->session->set_userdata('bnombre', $bnombre);
        $bnombre = $this->bnombre;
        $this->db->select();       
        $this->db->like('primer_nombre',$bnombre);
        $this->db->or_like('segundo_nombre',$bnombre);
        $this->db->or_like('primer_apellido',$bnombre);
        $this->db->or_like('segundo_apellido',$bnombre);
        $this->db->or_like('identificacion',$bnombre);
        $this->db->order_by('id_paciente');
        $query = $this->db->get('pacientes',$limit, $offset);
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function total_pacientes()
    {        
        $bnombre = $this->input->post('bnombre');
        $this->session->set_userdata('bnombre', $bnombre);
        $bnombre = $this->bnombre;
        
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->like('primer_nombre',$bnombre);
        $this->db->or_like('segundo_nombre',$bnombre);
        $this->db->or_like('primer_apellido',$bnombre);
        $this->db->or_like('segundo_apellido',$bnombre);
        $this->db->or_like('identificacion',$bnombre);
        $query = $this->db->get();        
        return $query->num_rows();
        
        
        $query->free_result();
    }
    
    public function total_pacientesn($bnombre)
    {    
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->like('primer_nombre',$bnombre);
        $this->db->or_like('segundo_nombre',$bnombre);
        $this->db->or_like('primer_apellido',$bnombre);
        $this->db->or_like('segundo_apellido',$bnombre);
        $query = $this->db->get();        
        return $query->num_rows();  
        $query->free_result(); 
    }
    
    public function total_pacientesi($bidentificacion)
    {
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->like('identificacion',$bidentificacion);        
        $query = $this->db->get();        
        return $query->num_rows();  
        $query->free_result(); 
    }
    
    public function bseccion($codprograma)
    {
        $this->db->select();
        $this->db->from('programas');
        $this->db->where('id', $codprograma);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function nprogramas($modulo)
    {
        $this->db->select();
        $this->db->from('programas');
        $this->db->where('id', $modulo);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }    
    
    public function seccion($seccion)
    {
        $this->db->select();
        $this->db->from('nuxprograma');
        $this->db->where('codprograma', $seccion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function bnombre($bnombre, $limit, $offset)
    {    
        $this->db->select();
        $this->db->like('primer_nombre',$bnombre);
        $this->db->or_like('segundo_nombre',$bnombre);
        $this->db->or_like('primer_apellido',$bnombre);
        $this->db->or_like('segundo_apellido',$bnombre);       
        $this->db->order_by('id_paciente');
        $consulta = $this->db->get('pacientes',$limit, $offset);
        
        if($consulta->num_rows() > 0)
        {
            return $consulta->result_array();
        }else
        {
            return false;
        }
        $consulta->free_result();
    }
    
    public function bidentificacion($limit, $offset, $bidentificacion)
    {
        $this->db->select();
        $this->db->like('identificacion',$bidentificacion);  
        $query = $this->db->get('pacientes',$limit, $offset);
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
        
    public function cpaciente($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('id_paciente',$id_paciente);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function raiz($codprograma, $session_nivel_usuario)
    {
        $this->db->select('n.raiz, n.codseccion, n.codmodulos, n.codprograma, n.nivel_usuario, n.colorfondo, n.menu, p.programa as nprograma, p.descripcion, p.ruta, p.nombre, p.vistav, p.vistafv, p.vistatablav, p.imagen');
        $this->db->from('nuxprograma n');
        $this->db->join('programas p', 'p.id = n.codprograma');
        $this->db->where('raiz',$codprograma);
        $this->db->where('n.nivel_usuario', $session_nivel_usuario);
        $this->db->order_by('n.orden');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function cpacienteb($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    public function cpacienteb1($id_paciente)
    {
        $this->db->select('p.*, d.nombre_tipo_docu as nombredocu, d.tipo_docu as tipodocu, 
        x.nombre_sexo as nomsexo, e.nombre_estado_civi as nombreestado, pa.nombre_pais as nompais,
        de.nombre_depa as nombredepa, mu.nombre_muni as nombremuni, ba.nombre_barr as nombrebarr,
        ad.nombre_admi as nombreadmi, oc.nombre_ocup as nombreocup, t.nombre_tipo_usua, z.nombre_zona_resi');
        $this->db->from('pacientes p');
        $this->db->join('tipo_documento d','d.tipo_docu = p.tipo_docu');
        $this->db->join('sexo x','p.sigla_sexo = x.sigla_sexo');
        $this->db->join('estadocivil e','e.cod_estado_civi = p.cod_estado_civi');        
        $this->db->join('paises pa', 'pa.cod_pais = p.cod_pais'); 
        $this->db->join('departamento de','de.id_depa = p.id_depa');
        $this->db->join('municipio mu', 'mu.id_muni = p.id_muni AND mu.id_depa = de.id_depa');
        $this->db->join('barrio ba', 'ba.id_barr = p.id_barr');               
        $this->db->join('administradoras ad', 'ad.id_admi = p.id_admi');
        $this->db->join('ocupaciones oc', 'oc.id_ocup = p.id_ocup');
        $this->db->join('tipo_usuario t', 't.cod_tipo_usua = p.cod_tipo_usua');
        $this->db->join('zona_residencia z', 'z.cod_zona_resi = p.cod_zona_resi');
        $this->db->where('id_paciente',$id_paciente);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function acompanante($id_paciente)
    {
        $this->db->select();
        $this->db->from('acompanante');
        $this->db->where('id_paciente',$id_paciente);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }   
        $query->free_result();
    }    
    
    public function imagenes($id_paciente)
    {
        $this->db->select();
        $this->db->from('imagenes');
        $this->db->where('id_paciente',$id_paciente);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }    
    
    function datoimagen($id_imag)
    {
        $this->db->select('im.fecha_imag as fecha, im.descripcion_imag as descripcion, ,im.ruta_imag, pa.tipo_docu, pa.identificacion,
        pa.primer_apellido,pa.segundo_apellido,pa.primer_nombre,pa.segundo_nombre,
        pa.telefono_paciente, pa.celular_paciente');
        $this->db->from('imagenes im');
        $this->db->join('pacientes pa','pa.id_paciente = im.id_paciente');
        $this->db->where('ruta_imag',$id_imag);
        $rimagen = $this->db->get();
        return $rimagen->result_array();
        $rimagen->free_result();
    }
    
      
  public function persona_atiende($id_usuario)
  {
        $this->db->select('u.cod_persona_atie, pa.nombre_persona_atie, u.login, pa.cups, u.medico');
        $this->db->from('usuarios u');
        $this->db->join('persona_atiende pa','pa.cod_persona_atie = u.cod_persona_atie');
        $this->db->where('u.id',$id_usuario);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
  }
  
  public function medicos()
  {
        $this->db->select();
        $this->db->from('medicos');
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
  }
  
  public function busquedacie($sigla_sexo, $limiteedad)
  {        
        $this->db->select();
        $this->db->from('cie10');
        $sexo = array('A', $sigla_sexo);
        $this->db->where($sexo);
        $ledad = "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad) ";
        $this->db->where($ledad); 
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->row_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
  }
  
  
    public function cielinea($cielinea, $sigla_sexo, $limiteedad)
	{              
        $cadena = '';
        $this->db->distinct();
        $this->db->select('cs.*');
        $this->db->from('cie10_sublinea cs'); 
        $this->db->join("cie10 c", "c.cod_cielinea = cs.cod_cielinea and c.cod_ciesublinea = cs.cod_ciesublinea and (c.sexo = 'A' or c.sexo='$sigla_sexo') and (c.limite_inferior = '0' or c.limite_inferior = '000' or c.limite_inferior<='$limiteedad') and (c.limite_superior = '0' or c.limite_superior = '000' or c.limite_superior >= '$limiteedad')");
        $this->db->where('cs.cod_cielinea', $cielinea);
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_ciesublinea']}'>{$row['cod_ciesublinea']} - {$row['nombre_ciesublinea']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
	}
    
    public function ciesublinea($cielinea, $ciesublinea, $sigla_sexo, $limiteedad)
	{              
        $cadena = '';
        $this->db->select('');
        $this->db->from('cie10');
        $this->db->where('cod_cielinea', $cielinea);
        $this->db->where('cod_ciesublinea', $ciesublinea);        
        $sexo = array('A', $sigla_sexo);
        $this->db->where_in('sexo', $sexo);
        $ledad = "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad) ";
        $this->db->where($ledad); 
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {           
           $cadena.="<option value='{$row['id_cie']}' cod_cie='{$row['cod_cie']}' cod_cielinea='{$row['cod_cielinea']}' cod_ciesublinea='{$row['cod_ciesublinea']}'>{$row['cod_cie']} - {$row['nombre_cie']}</option>";
        }
        echo $cadena;
        $query->free_result();  
	}
    
     public function clielinea($cielineap)
    {
        $this->db->select();
        $this->db->from('cie10_linea');
        $this->db->where('cod_cielinea',$cielineap);
        $query = $this->db->get(); 
        $resultado.="";
        foreach ($query->result_array() as $row)
        {           
           $resultado.=$row['cod_cielinea']. ' - ' .$row['nombre_cielinea'];
        }
        echo $resultado;
        $query->free_result();
    }
    
    public function cliesublinea($ciesublineap)
    {
        $this->db->select();
        $this->db->from('cie10_linea');
        $this->db->where('cod_ciesublinea',$ciesublineap);
        $query = $this->db->get(); 
        $resultado.="";
        foreach ($query->result_array() as $row)
        {           
           $resultado.=$row['cod_ciesublinea']. ' - ' .$row['nombre_ciesublinea'];
        }
        echo $resultado;
        $query->free_result();
    }
    
    public function finalidad()
    {
        $this->db->select();
        $this->db->from('finalidad');
        $this->db->where('cod_tipo_fina', 1);
        $this->db->where('cod_fina !=',10);
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }    

    public function finalidadxdefecto()
    {
        $this->db->select();
        $this->db->from('finalidad');
        $this->db->where('cod_tipo_fina', 1);
        $this->db->where('cod_fina',10);
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function causaxdefecto()
    {
        $this->db->select();
        $this->db->from('causa_diagnostico');        
        $this->db->where('cod_causa_dia',13);
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function causa()
    {
        $this->db->select();
        $this->db->from('causa_diagnostico');        
        $this->db->where('cod_causa_dia !=',13);
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function tipoxdefecto()
    {
        $this->db->select();
        $this->db->from('tipo');        
        $this->db->where('cod_tipo',2);
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function tipo()
    {
        $this->db->select();
        $this->db->from('tipo');        
        $this->db->where('cod_tipo !=',2);
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }    
    
    public function finalidad1xdefecto()
    {
        $this->db->select();
        $this->db->from('finalidad');
        $this->db->where('cod_tipo_fina', 2);
        $this->db->where('cod_fina',2);
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    
    
    public function cupssublinea($cupslinea)
	{              
        $cadena = '';
        $this->db->select();
        $this->db->from('cups_sublinea'); 
        $this->db->where('cod_cupslinea', $cupslinea);
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione Subíndice CUPS. . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_cupsublinea']}'>{$row['cod_cupsublinea']} - {$row['nombre_cupsublinea']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
	}      
    
    public function finalidad2($cod_persona_atie)
    {
        $cadena = '';
        $this->db->select('f.id_finalidad, f.cod_fina, f.nombre_fina');
        $this->db->from('finalidad f');
        $this->db->join('persona_atiende p', 'f.cod_fina = p.cod_fina');
        $this->db->where('f.cod_tipo_fina', 1);        
        $this->db->where('p.cod_persona_atie',$cod_persona_atie);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option value='{$row['id_finalidad']}'>{$row['nombre_fina']}</option>";
            
            $this->db->select('f.id_finalidad, f.cod_fina, f.nombre_fina');
            $this->db->from('persona_atiende p');
            $this->db->join('finalidad f', 'f.cod_fina != p.cod_fina'); 
            $this->db->where('f.cod_tipo_fina', 1);       
            $this->db->where('p.cod_persona_atie',$cod_persona_atie);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_finalidad']}'>{$row['nombre_fina']}</option>";    
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();
    }  

    public function finalidad_gen_cie()
    {
        $this->db->select();
        $this->db->from('finalidad');
        $this->db->where('cod_tipo_fina', 1);        
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function causa1($cod_persona_atie)
    {
        $cadena = '';
        $this->db->select('f.cod_causa_dia, f.nombre_causa_dia');
        $this->db->from('causa_diagnostico f');
        $this->db->join('persona_atiende p', 'f.cod_causa_dia = p.cod_causa_dia');                
        $this->db->where('p.cod_persona_atie',$cod_persona_atie);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option value='{$row['cod_causa_dia']}'>{$row['nombre_causa_dia']}</option>";
            
            $this->db->select('f.cod_causa_dia, f.nombre_causa_dia');
            $this->db->from('causa_diagnostico f');
            $this->db->join('persona_atiende p', 'f.cod_causa_dia != p.cod_causa_dia');     
            $this->db->where('p.cod_persona_atie',$cod_persona_atie);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_causa_dia']}'>{$row['nombre_causa_dia']}</option>";    
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();
    }

    public function causa_gen()
    {
        $this->db->select();
        $this->db->from('causa_diagnostico');
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function tipo1($cod_persona_atie)
    {
        $cadena = '';
        $this->db->select('f.cod_tipo, f.nombre_tipo');
        $this->db->from('tipo f');
        $this->db->join('persona_atiende p', 'f.cod_tipo = p.cod_tipo');                
        $this->db->where('p.cod_persona_atie',$cod_persona_atie);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option value='{$row['cod_tipo']}'>{$row['nombre_tipo']}</option>";
            
            $this->db->select('f.cod_tipo, f.nombre_tipo');
            $this->db->from('tipo f');
            $this->db->join('persona_atiende p', 'f.cod_tipo != p.cod_tipo');  
            $this->db->where('p.cod_persona_atie',$cod_persona_atie);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_tipo']}'>{$row['nombre_tipo']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result();
        $query2->free_result(); 
    }   

    public function tipo_gen()
    {
        $this->db->select();
        $this->db->from('tipo');
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }                              
    
    public function cupslinea($cod_persona_atie)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('persona_atiende');                    
        $this->db->where('cod_persona_atie',$cod_persona_atie);
        $query = $this->db->get();
        if ($query->num_rows() > 0)
        {
            $row = $query->row(); 
            $codcupslinea = $row->cod_cupslinea; 
            if($codcupslinea == '--')
            {
                $this->db->select('f.cod_cupslinea, f.nombre_cupslinea');
                $this->db->from('cups_linea f');
                $query2 = $this->db->get();
                foreach ($query2->result_array() as $row)
                {
                    $cadena.="<option value='{$row['cod_cupslinea']}'>{$row['cod_cupslinea']} - {$row['nombre_cupslinea']}</option>";  
                } 
                echo $cadena; 
            }
            else
            {
                $this->db->select('f.cod_cupslinea, f.nombre_cupslinea');
                $this->db->from('cups_linea f');
                $this->db->join('persona_atiende p', 'f.cod_cupslinea = p.cod_cupslinea');  
                $this->db->where('p.cod_persona_atie',$cod_persona_atie);
                $query3 = $this->db->get();
                $cadena.="";
                foreach ($query3->result_array() as $row)
                {
                    $cadena.="<option value='{$row['cod_cupslinea']}'>{$row['cod_cupslinea']} - {$row['nombre_cupslinea']}</option>"; 
                    
                    $this->db->select('f.cod_cupslinea, f.nombre_cupslinea');
                    $this->db->from('cups_linea f');
                    $this->db->join('persona_atiende p', 'f.cod_cupslinea != p.cod_cupslinea'); 
                    $this->db->where('p.cod_persona_atie',$cod_persona_atie);
                    $query4 = $this->db->get();
                    foreach ($query4->result_array() as $row)
                    {
                        $cadena.="<option value='{$row['cod_cupslinea']}'>{$row['cod_cupslinea']} - {$row['nombre_cupslinea']}</option>";
                    } 
                }
                echo $cadena;  
            }            
        }
        $query->free_result(); 
        $query2->free_result();
        $query3->free_result();
        $query4->free_result();
    }
    
    public function cupsgrupo($cupslinea, $cupsublinea)
	{              
        $cadena = '';
        $this->db->select();
        $this->db->from('cups_grupo'); 
        $this->db->where('cod_cupslinea', $cupslinea);
        $this->db->where('cod_cupsublinea', $cupsublinea);        
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione Categoría CUPS. . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_cupsgrupo']}'>{$row['cod_cupsgrupo']} - {$row['nombre_cupsgrupo']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
	}  
    
    public function cupscodigo($cupslinea, $cupsublinea, $cupsgrupo)
	{              
        $cadena = '';
        $this->db->select();
        $this->db->from('cups'); 
        $this->db->where('cod_cupslinea', $cupslinea);
        $this->db->where('cod_cupsublinea', $cupsublinea);
        $this->db->where('cod_cupsgrupo', $cupsgrupo);
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione Código CUPS Tratamiento . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_cups']}' vcodcups='{$row['cod_cups']}' vcodlinea='{$row['cod_cupslinea']}' 
           vcodsublinea='{$row['cod_cupsublinea']}' vcodgrupo='{$row['cod_cupsgrupo']}'>{$row['cod_cups']} - {$row['nombre_cups']}</option>
           ";
        }
        echo $cadena; 
        $query->free_result(); 
	}   
        
    public function finalidad1($cod_persona_atie)
    {
        $cadena = '';
        $this->db->select('f.id_finalidad, f.cod_fina, f.nombre_fina');
        $this->db->from('finalidad f');
        $this->db->join('persona_atiende p', 'f.cod_fina = p.cod_fina2');
        $this->db->where('f.cod_tipo_fina', 2);        
        $this->db->where('p.cod_persona_atie',$cod_persona_atie);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option value='{$row['id_finalidad']}'>{$row['nombre_fina']}</option>";
            
            $this->db->select('f.id_finalidad, f.cod_fina, f.nombre_fina');
            $this->db->from('persona_atiende p');
            $this->db->join('finalidad f', 'f.cod_fina != p.cod_fina2'); 
            $this->db->where('f.cod_tipo_fina', 2);       
            $this->db->where('p.cod_persona_atie',$cod_persona_atie);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_finalidad']}'>{$row['nombre_fina']}</option>";    
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();
    }

    public function finalidad_gen()
    {
        $this->db->select();
        $this->db->from('finalidad');
        $this->db->where('cod_tipo_fina', 2);        
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function nconsulta()
    {
        $this->db->select();
        $this->db->from('consecutivos');
        $this->db->where('cod_consecutivo', 7);   
        $query = $this->db->get();
        $consecutivo = "";        
        foreach ($query->result_array() as $row)
        {
            $consecutivo = $row['numero_consecutivo'];
        }        
        echo $consecutivo = $consecutivo + 1;
        $query->free_result();
    }
    
    public function medico($persona, $id_usuario)
    {        
        $cadena = '';
        if($persona == 20)
        {
            $this->db->select();
            $this->db->from('medicos');                   
            $query = $this->db->get();
            $cadena.="<option value=''>Seleccione Médico . . .</option>";
            foreach ($query->result_array() as $row)
            {
               $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }
            echo $cadena;
        }
        else
        {
            $this->db->select();
            $this->db->from('medicos');  
            $this->db->where('id_usuario', $id_usuario);                 
            $query = $this->db->get();
            $cadena.="";
            foreach ($query->result_array() as $row)
            {
               $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }
            echo $cadena;     
        }
        $query->free_result(); 
    }    
    
    public function fconsultamedicaing1()
    {
    // VER X PANTALLA LA INFORMACION DE LA MATRIZ INFORMO
        print_r($_POST['informo']);
        print_r($_POST['data']);        
    }
    
    public function fconsultamedicaing()
    {
        if(!empty($this->session_id))  
		{
            if($this->input->post())
            {
                $login_ing         =  $this->session_id; 
                $this->db->select();
                $this->db->from('usuarios');
                $this->db->where('login', $login_ing);   
                $query = $this->db->get();
                if ($query->num_rows() <= 0)
                {
                    $datos['error'] =   'Falta login';
                    $this->load->view('front_end/salidaerror', $datos); 
                }
                //CONSECUTIVO DE CONSULTA MEDICA
                $this->db->select();
                $this->db->from('consecutivos');
                $this->db->where('cod_consecutivo', 7);   
                $query1 = $this->db->get();
                $consecutivo = '';        
                foreach ($query1->result_array() as $row)
                {
                    $consecutivo = $row['numero_consecutivo'];
                    $consecutivo = $consecutivo + 1;
                }             
                
                // CONSULTA DE COTIZACION EN CONSECUTIVOS
                $this->db->select();
                $this->db->from('consecutivos');
                $this->db->where('cod_consecutivo', 8);   
                $query2 = $this->db->get();
                $conscot = '';        
                foreach ($query2->result_array() as $row)
                {
                $conscot = $row['numero_consecutivo'];
                $conscot = $conscot + 1;
                }
                
                // CONSULTA DE FACTURAS
                $this->db->select();
                $this->db->from('consecutivos');
                $this->db->where('cod_consecutivo', 2);   
                $query3 = $this->db->get();
                $consfac = '';        
                foreach ($query3->result_array() as $row)
                {
                $consfac = $row['numero_consecutivo'];
                $consfac = $consfac + 1;
                }
                
                    
                // RECORRER MATRIZ INFORMO QUE VIENE DE JSON
                $dat = $this->input->post('informo');         
                $dat = json_decode($dat);
                if (is_array($dat)) 
                {
                    foreach ($dat as $row => $val) 
                    {     
                        $identificacion   =   trim($val->identificacion);
                        $tipo_docu        =   trim($val->tipo_docu);               
                        $this->db->select();
                        $this->db->from('pacientes');
                        $this->db->where('identificacion', $identificacion);
                        $this->db->where('tipo_docu', $tipo_docu);
                        $query4 = $this->db->get();
                        foreach($query4->result_array() as $pac)
                        {    
                            $fechan                 = $pac['fecha_de_nacimiento'];                   
                        }
                        
                        //generando edad y unidad medida de la edad
                        date_default_timezone_set('America/Bogota');
                        $ma                     = 12;
                        //$fechan                 = $paci['fecha_de_nacimiento'];
                        $edadpaciente           = '';
                        $totaldiasmes           = '';
                        list($Y,$m,$d)          = explode("-",$fechan);            
                        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
                        $edadpaciente           = intval($edadpaciente);
                        $mn                     = intval($m);  
                        $dn                     = intval($d);
                        $mesactual              = intval(date("m"));
                        $diaactual              = intval(date("d"));            
                        $mesanterior            = '';     
                        $anocomp                = '';     
                        $anoactual              = intval(date("Y")); 
                        $anon                   = $Y;
                        $ume                    = '';
                                  
                        if($mn == 2)
                        {
                            $totaldiasmes = 28;
                        }
                        if($dn == 31)
                        {
                            $dn = $dn - 1;
                        }
                        if($mn == 2 && $dn >= 29)
                        {
                            $dn = 28;
                        }
                        //$edad = $edadpaciente;
                        
                        if($edadpaciente == 0)
                        {             
                            //MESES ACTUALES DEL PACIENTE               
                           
                            if($mesactual == 1)
                            {
                                $mesanterior = 12;
                            }                
                            else
                            {
                                $mesanterior = $mesactual - 1;
                            }
                            
                            if($mesanterior == $mn || $mn == $mesactual)
                            {
                                if($mn == $mesactual)
                                {
                                    $edadresultado = $diaactual - $dn;
                                }
                                else
                                {
                                    $edadresultado = $diaactual + 30 - $dn;
                                    
                                }
                                
                                if($edadresultado >= 31)
                                {
                                    $edad   = $mesactual - $mn;
                                    $ume    = 2;  
                                }
                                else
                                {
                                    $edad = $edadresultado;
                                    $ume    = 3;
                                }                    
                            }
                            else
                            {
                                $anocomp        = $anoactual - 1;
                                if($anocomp == $anon)
                                {
                                    $edad  = 12 - $mn + $mesactual;
                                    $ume    = 2;
                                }
                                else
                                {
                                    $edad  = $mesactual - $mn;
                                    $ume    = 2;
                                }
                            }
                        }
                        else
                        {
                            $edad   = $edadpaciente;
                            $ume    = 1;
                        }
                        
                        
                        // VARIABLES
                                                       
                                      
                        $edad              =    trim($edad);                 
                        $ume               =    trim($ume);
                        $nconsulta         =    $consecutivo;                               
                        $cod_medi          =    trim($val->cod_medi);                               
                        $id_admi           =    trim($val->id_admi);                
                        $cod_cons          =    trim($val->cod_cons);                
                        $sist              =    trim($val->sist);                
                        $diast             =    trim($val->diast);                
                        $ppm               =    trim($val->ppm);                
                        $rpm               =    trim($val->rpm);                
                        $grados            =    trim($val->grados);                
                        $altura            =    trim($val->altura);                
                        $peso              =    trim($val->peso);                 
                        $imc               =    trim($val->imc);                
                        $id_cie            =    $val->id_cie;                
                        $id_cie1           =    $val->id_cie1;                
                        $id_cie2           =    $val->id_cie2;                                
                        $cod_cie           =    trim($val->cod_cie);                
                        $cod_cielinea      =    trim($val->cod_cielinea);                
                        $cod_ciesublinea   =    trim($val->cod_ciesublinea);                 
                        $cod_cie1          =    trim($val->cod_cie1);                
                        $cod_cielinea1     =    trim($val->cod_cielinea1);                
                        $cod_ciesublinea1  =    trim($val->cod_ciesublinea1);                
                        $cod_cie2          =    trim($val->cod_cie2);                
                        $cod_cielinea2     =    trim($val->cod_cielinea2);                
                        $cod_ciesublinea2  =    trim($val->cod_ciesublinea2);                
                        $autorizacion      =    trim(strtoupper($val->autorizacion));                
                        $id_finalidad      =    $val->id_finalidad;                
                        $cod_causa_dia     =    trim(strtoupper($val->cod_causa_dia));                
                        $cod_tipo          =    trim(strtoupper($val->cod_tipo));                
                        $observacionescie  =    trim(strtoupper($val->observacionescie));                
                        $valor_cie         =    trim($val->valor_cie);                
                        $valor_cuota       =    trim($val->valor_cuota);                
                        $valor_subtotal    =    trim($val->valor_subtotal);                
                        $observacionescups =    trim(strtoupper($val->observacionescups));                
                        $valor_cups        =    trim($val->valor_cups);                
                        $valor_total       =    trim($val->valor_total);               
                        $horaactual        =    trim($val->horaactual);                 
                        $fechaactual       =    trim($val->fechaactual);                
                        $rciecodigo        =    trim($val->rciecodigo);                   
                        $rciecodigo1       =    trim($val->rciecodigo1);                
                        $rciecodigo2       =    trim($val->rciecodigo2);                 
                        $cotizacion        =    trim($conscot);
                        
                        
                        if ($identificacion == '')
                        {
                            $datos['error'] =   'Falta identificación';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($tipo_docu == '')
                        {
                            $datos['error'] =   'Falta tipo de documento';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($edad == '')
                        {
                            $datos['error'] =   'Falta la edad';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($nconsulta == '')
                        {
                            $datos['error'] =   'Falta el número de consulta';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_medi == '')
                        {
                            $datos['error'] =   'Falta el código del médico';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($id_admi == '')
                        {
                            $datos['error'] =   'Falta la administradora';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_cons == '')
                        {
                            $datos['error'] =   'Falta la consulta';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($id_cie == '')
                        {
                            $datos['error'] =   'Falta el ID CIE';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_cie == '')
                        {
                            $datos['error'] =   'Falta el  código CIE';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else
                        {
                            //// MATRIZ PARA FACTURAS
        //                    $factu  =   array(
        //                    'ref_procesos'         =>      'FA',
        //                    'numero_docu'          =>      trim($consfac),
        //                    'identificacion_paci'  =>      $identificacion,
        //                    'valor_bruto'          =>      $valor_total,
        //                    'valor_cuota'          =>      $valor_cuota,
        //                    'valor_total'          =>      $valor_total,
        //                    'proceso_ref'          =>      'CM',
        //                    'fechaingreso'         =>      $fechaactual,
        //                    'horaingreso'          =>      $horaactual  
        //                    );
        //                    // INSERTAR DATOS ENCABEZADO               
        //                    $this->db->insert('encabezado', $factu); 
                            
                            // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: consulta_medica
                            $data = array(
                            'login_ing'         =>  $login_ing,                                
                            'identificacion'    =>  $identificacion,
                            'edad'              =>  $edad,
                            'ume'               =>  $ume,                
                            'nconsulta'         =>  $consecutivo,                
                            'cod_medi'          =>  $cod_medi,                
                            'id_admi'           =>  $id_admi,
                            'cod_cons'          =>  $cod_cons,
                            'sist'              =>  $sist,
                            'diast'             =>  $diast,
                            'ppm'               =>  $ppm,
                            'rpm'               =>  $rpm,
                            'grados'            =>  $grados,
                            'altura'            =>  $altura,
                            'peso'              =>  $peso,
                            'imc'               =>  $imc,
                            'id_cie'            =>  $id_cie,
                            'id_cie1'           =>  $id_cie1,
                            'id_cie2'           =>  $id_cie2,                
                            'cod_cie'           =>  $cod_cie,
                            'cod_cielinea'      =>  $cod_cielinea,
                            'cod_ciesublinea'   =>  $cod_ciesublinea, 
                            'cod_cie1'          =>  $cod_cie1,
                            'cod_cielinea1'     =>  $cod_cielinea1,
                            'cod_ciesublinea1'  =>  $cod_ciesublinea1,
                            'cod_cie2'          =>  $cod_cie2,
                            'cod_cielinea2'     =>  $cod_cielinea2,
                            'cod_ciesublinea2'  =>  $cod_ciesublinea2,
                            'autorizacion'      =>  $autorizacion,
                            'id_finalidad'      =>  $id_finalidad,
                            'cod_causa_dia'     =>  $cod_causa_dia,
                            'cod_tipo'          =>  $cod_tipo,
                            'observacionescie'  =>  $observacionescie,
                            'valor_cie'         =>  $valor_cie,
                            'valor_cuota'       =>  $valor_cuota,
                            'valor_subtotal'    =>  $valor_subtotal,
                            'observacionescups' =>  $observacionescups,
                            'valor_cups'        =>  $valor_cups,
                            'valor_total'       =>  $valor_total,
                            'horaactual'        =>  $horaactual,
                            'fechaactual'       =>  $fechaactual,
                            'rciecodigo'        =>  $rciecodigo,
                            'rciecodigo1'       =>  $rciecodigo1,
                            'rciecodigo2'       =>  $rciecodigo2,
                            'cotizacion'        =>  $cotizacion,
                            'numfac'            =>  $consfac,
                            'tipo_docu'         =>  $tipo_docu                  
                            );
                            
                           // INSERTAR DATOS                
                            $this->db->insert('consulta_medica', $data);                     
                            
                            // MATRIZ PARA COTIZACIONES
                            $coti  =   array(
                            'login_ing'             =>  $login_ing,
                            'ref_procesos'          =>  'CT',
                            'numero_docu'           =>  trim($conscot),
                            'identificacion_paci'   =>  $identificacion,
                            'rciecodigo'            =>  $rciecodigo,
                            'valor_cie'             =>  $valor_cie,
                            'valor_cuota'           =>  $valor_cuota,
                            'valor_cups'            =>  $valor_cups,
                            'valor_bruto'           =>  $valor_total,
                            'valor_total'           =>  $valor_total,
                            'documento_ref'         =>  trim($consecutivo),
                            'proceso_ref'           =>  'CM',
                            'fechaingreso'          =>  $fechaactual,
                            'horaingreso'           =>  $horaactual,
                            'numfac'                =>  $consfac,
                            'tipo_docu'             =>  $tipo_docu,
                            'cod_medi'              =>  $cod_medi,      
                            'id_admi'               =>  $id_admi,
                            'cod_cons'              =>  $cod_cons                
                            );
                            
                            // INSERTAR DATOS ENCABEZADO               
                            $this->db->insert('encabezado', $coti);      
                        }           
                    } 
                    // LEER MATRIZ DATOS QUE VIENE DE JSON    
                    $datmv = $this->input->post('data'); 
                    $datmv = json_decode($datmv);
                    if (is_array($datmv)) 
                    {
                        foreach ($datmv as $key => $value) 
                        {            
                            $nconsulta         =    $consecutivo;
                            $id_cups           =    $value->id_cups;
                            $cod_cups          =    $value->cod_cups;
                            $cod_cupslinea     =    $value->cod_cupslinea;
                            $cod_cupsublinea   =    $value->cod_cupsublinea;
                            $cod_cupsgrupo     =    $value->cod_cupsgrupo;
                            $coddescripcion    =    trim($value->coddescripcion);
                            $id_finalidad      =    $value->id_finalidad;
                            $finalidadesdes    =    trim($value->finalidadesdes);
                            $cod_ambi          =    trim(strtoupper($value->cod_ambi));
                            $ambitosdes        =    trim($value->ambitosdes);
                            $cod_actoq         =    trim(strtoupper($value->cod_actoq));
                            $actoqsdes         =    trim($value->actoqsdes);
                            $autorizaciones    =    trim(strtoupper($value->autorizaciones));
                            $valor_cups        =    trim($value->valor_cups);
                            $horaactual        =    trim($value->horaactual);
                            $fechaactual       =    trim($value->fechaactual);
                            $cotizacion        =    trim($conscot);  
                            
                            // CREAR MATRIZ DE DATOS PARA INSERTAR EN TABLA : consulta_medicaxtratamiento
                            $datamv = array(
                            'nconsulta'         =>  $nconsulta,
                            'id_cups'           =>  $id_cups,
                            'cod_cups'          =>  $cod_cups,
                            'cod_cupslinea'     =>  $cod_cupslinea,
                            'cod_cupsublinea'   =>  $cod_cupsublinea,
                            'cod_cupsgrupo'     =>  $cod_cupsgrupo,
                            'coddescripcion'    =>  $coddescripcion,
                            'id_finalidad'      =>  $id_finalidad,
                            'finalidadesdes'    =>  $finalidadesdes,
                            'cod_ambi'          =>  $cod_ambi,
                            'ambitosdes'        =>  $ambitosdes,
                            'cod_actoq'         =>  $cod_actoq,
                            'actoqsdes'         =>  $actoqsdes,
                            'autorizaciones'    =>  $autorizaciones,
                            'valor_cups'        =>  $valor_cups,
                            'horaactual'        =>  $horaactual,
                            'fechaactual'       =>  $fechaactual,
                            'cotizacion'        =>  trim($conscot),
                            'numfac'            =>  $consfac 
                            );
                            
                            // INSERTAR DATOS EN TABLA
                            $this->db->insert('consulta_medicaxtratamiento', $datamv);
                            
                            // MATRIZ PARA DETALLES DE COTIZACIONES
                            $dcot   =   array(
                            'login_ing'                 =>  $login_ing,
                            'numero_docu'               =>  trim($conscot),
                            'documento_ref'             =>  trim($consecutivo),
                            'proceso_ref'               =>  'CM',                  
                            'cod_cups'                  =>  $cod_cups,
                            'cod_cupslinea'             =>  $cod_cupslinea,
                            'cod_cupsublinea'           =>  $cod_cupsublinea,
                            'cod_cupsgrupo'             =>  $cod_cupsgrupo,  
                            'nombre_cups'               =>  $coddescripcion,             
                            'valor_cups'                =>  $valor_cups,                
                            'horaingreso'               =>  $horaactual,
                            'fechaingreso'              =>  $fechaactual,
                            'ref_procesos'              =>  'CT',
                            'numfac'                    =>  $consfac
                            );
                            
                            // INSERTAR DATOS DETALLES               
                            $this->db->insert('detalles', $dcot);
                            
                            // MATRIZ PARA DETALLES DE COTIZACIONES
                            //$dfac   =   array(                
            //                'numero_docu'               =>  $consfac,
            //                'documento_ref'             =>  $conscot,
            //                'fechaingreso'              =>  $fechaactual,
            //                'horaingreso'               =>  $horaactual,
            //                'ref_procesos'              =>  'FA',
            //                'login_ing'                 =>  $login_ing,
            //                'proceso_ref'               =>  'CT',
            //                'valor_fac'                 =>  $data['valor_total'],
            //                'descripcion_fac'           =>  'Cita médica'
            //                );
            //                
            //                // INSERTAR DATOS DETALLES               
            //                $this->db->insert('detalles', $nconsfac);  
                            
                        }
                    
                    } 
                    
                    // ACTUALIZANDO CONSECUTIVOS DE CONSULTA MEDICA
                    $nconsecutivo = array(
                    'numero_consecutivo'    => $consecutivo
                    );
                    
                    $this->db->where('cod_consecutivo', 7);
                    $this->db->update('consecutivos', $nconsecutivo);
                    
                    // ACTUALIZANDO CONSECUTIVOS DE COTIZACIONES
                    $nconscoti = array(
                    'numero_consecutivo'    => $conscot
                    );
                    
                    $this->db->where('cod_consecutivo', 8);
                    $this->db->update('consecutivos', $nconscoti);
                    
                    // ACTUALIZANDO CONSECUTIVOS DE FACTURAS
                    //$nconsfac = array(
            //        'numero_consecutivo'    => $consfac
            //        );
            //        
            //        $this->db->where('cod_consecutivo', 2);
            //        $this->db->update('consecutivos', $nconsfac);    
                    
                    //CONSULTANDO INFORMACION DEL REGISTRO GRABADO, UTILIZANDO LIBRERIA CONSECUTIVO
                    $consultarconsecutivo = $this->consecutivo->consultamedicaingcon($consecutivo);
                    //return $consultarconsecutivo;
                    
                    // LIBERANDO VARIABLES DE CONSULTA
                    $query->free_result();
                    $query1->free_result();
                    $query2->free_result();
                    $query3->free_result();
                    $query4->free_result();       
                }
            }                            
            else
            {   
                redirect(base_url().'usuarios/avisosesion', 301);	 
            }
        }
        else
        {
            redirect(base_url().'usuarios/avisosesion', 301);	 
        }
    }
    
    public function fconsultamedicaingmv($array)
    {    
        if (is_array($array)) 
        {
            foreach ($array as $key => $value) 
            {            
                $nconsulta                  = trim(strtolower($value->nconsulta));
                $cod_cups                   = trim(strtolower($value->cod_cups));
                $cod_fina                   = trim(strtolower($value->cod_fina));
                $cod_ambi                   = trim(strtolower($value->cod_ambi));
                $cod_actoq                  = trim(strtolower($value->cod_actoq));
                $autorizaciones             = trim(strtolower($value->autorizaciones));
                $valor_cups                 = trim(strtolower($value->valor_cups));
                
                echo "<br>";
                echo "<br>";
                echo ("nconsulta: ").$nconsulta;
                echo "<br>";  
                echo ("cod_cups: ").$cod_cups;
                echo "<br>";  
                echo ("cod_fina: ").$cod_fina;
                echo "<br>";  
                echo ("cod_ambi: ").$cod_ambi;
                echo "<br>";  
                echo ("cod_actoq: ").$cod_actoq;
                echo "<br>";  
                echo ("autorizaciones: ").$autorizaciones;
                echo "<br>";  
                echo ("valor_cups: ").$valor_cups;
                echo "<br>";
            }
        }else
        echo('no hay matriz data');      
    }
    
    public function administradora($medico)
    {       
        $cadena = '';
        $this->db->select('m.id_admi, a.nombre_admi, a.id_administradora');
        $this->db->from('medicos m');  
        $this->db->where('m.id_medi', trim($medico));
        $this->db->join('administradoras a', 'm.id_admi = a.id_admi');                  
        $query = $this->db->get();            
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<div id='administradora' class='administradora' value='{$row['id_admi']}' idadministradora='{$row['id_administradora']}'>{$row['nombre_admi']}</div>";
        }
        echo $cadena; 
        $query->free_result();  
    }
    
    public function tipoempresaspromotoras()
    {
        $this->db->select();
        $this->db->from('tipoempresaspromotoras');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function administradoras($tipoadministradora)
    {       
        $cadena = '';
        $this->db->select();
        $this->db->from('administradoras');  
        $this->db->where('id_tipo_promo', $tipoadministradora);                          
        $query = $this->db->get();            
        $cadena.="<option value=''>Seleccione Administradora . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_admi']}' idadministradora='{$row['id_administradora']}'>{$row['nombre_admi']}</option>";
        }
        echo $cadena; 
        $query->free_result();  
    }
    
    public function cadministradoras($valadministradora)
    {       
        $cadena = '';
        $this->db->select();
        $this->db->from('administradoras');  
        $this->db->where('id_admi', $valadministradora);                          
        $query = $this->db->get();            
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_admi']}'>{$row['nombre_admi']}</option>";
        }
        echo $cadena; 
        $query->free_result();  
    }
    
    public function codigoconsulta($cod_medi)
    {
        $cadena = '';
        $this->db->select('e.cod_cons, c.nombre_cons');
        $this->db->from('especialidadxconsulta e');        
        $this->db->join('consulta c', 'c.cod_cons = e.cod_cons');        
        $this->db->where('e.cod_medi', $cod_medi); 
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_cons']}'>{$row['nombre_cons']}</option>";
        }
        echo $cadena; 
        $query->free_result();  
    }

    public function codigoconsulta_gen($cod_medi)
    {
        $this->db->select('e.cod_cons, c.nombre_cons');
        $this->db->from('especialidadxconsulta e');        
        $this->db->join('consulta c', 'c.cod_cons = e.cod_cons');        
        $this->db->where('e.cod_medi', $cod_medi); 
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }
    
    public function ambito()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('ambito');
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_ambi']}'>{$row['nombre_ambi']}</option>";
        }
        echo $cadena; 
        $query->free_result();  
    }

    public function ambito_gen()
    {
        $this->db->select();
        $this->db->from('ambito');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }
    
    public function actoq()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('actoquirurgico');
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_actoq']}'>{$row['nombre_actoq']}</option>";
        }
        echo $cadena; 
        $query->free_result();  
    }

    public function actoq_gen()
    {
        $this->db->select();
        $this->db->from('actoquirurgico');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }
    
    public function iseccion($iseccion)
    {
        $this->db->select();
        $this->db->from('secciones');
        $this->db->where('codmodulos', $iseccion);
        $query = $this->db->get();
        foreach($query->result_array as $row)        
        {
            $isecciones = $row['nombre'];
            echo $isecciones;
            
        }
        $query->free_result();
    }
    
    public function xdef($modulo, $session_nivel_usuario)
    {
        $this->db->select('n.codprograma, n.codseccion, p.descripcion, p.vistav, vistafv, p.ruta, p.nombre');
        $this->db->from('nuxprograma n');
        $this->db->join('programas p','p.id = n.codprograma');
        $this->db->where('n.codmodulos', $modulo);
        $this->db->where('n.nivel_usuario', $session_nivel_usuario);
        $this->db->where('xdefmod', 'x');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }    
    
    public function modxsub($codprograma, $session_nivel_usuario)
    {
        $this->db->select('p.*, n.raiz ');
        $this->db->from('nuxprograma n');
        $this->db->join('programas p', 'p.id = n.codprograma'); 
        $this->db->where('n.raiz', $codprograma);
        $this->db->where('n.nivel_usuario', $session_nivel_usuario);
        $this->db->where('n.menu', 'x');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }        
    
    public function codsubprograma($codsubprograma, $session_nivel_usuario)
    {
        $this->db->select('p.*');
        $this->db->from('nuxprograma n');
        $this->db->join('programas p', 'p.id = n.codprograma'); 
        $this->db->where('n.codprograma', $codsubprograma);
        $this->db->where('n.nivel_usuario', $session_nivel_usuario);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }
    
    public function consultacmedica()
    {
        $consecutivo = $this->input->post('consecutivo');
        $consultarconsecutivo = $this->consecutivo->consultamedicaconcon($consecutivo);
    }
    
    public function tipodocumento()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_documento');
        $query = $this->db->get();            
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['tipo_docu']}' caracter = '{$row['caracteres']}'>{$row['tipo_docu']} - {$row['nombre_tipo_docu']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }
    
    public function tipodocumentoc()
    {        
        $this->db->select();
        $this->db->from('tipo_documento');
        $query = $this->db->get(); 
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();        
    }
    
    public function sexo()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('sexo');
        $this->db->where_not_in('sigla_sexo', 'A');
        $query = $this->db->get();            
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['sigla_sexo']}'>{$row['nombre_sexo']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }
    
    public function sexoc()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('sexo');
        $this->db->where_not_in('sigla_sexo', 'A');
        $query = $this->db->get();            
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();        
    }
    
    
    public function estadocivil()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('estadocivil');        
        $query = $this->db->get();            
        //$cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_estado_civi']}'>{$row['nombre_estado_civi']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }
    
    public function consestadocivil()
    {        
        $this->db->select();
        $this->db->from('estadocivil');        
        $query = $this->db->get();            
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();        
    }
    
    public function rh()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('gruposanguineo');        
        $query = $this->db->get();            
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_grupo_sang']}'>{$row['cod_grupo_sang']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }
    
    public function consrh()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('gruposanguineo');
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();      
    }
        
    public function pais()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('paises');        
        $this->db->where('cod_pais', '169');
        $query3 = $this->db->get();
        $cadena.="";
        foreach ($query3->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_pais']}'>{$row['nombre_pais']}</option>";            
            $this->db->select();
            $this->db->from('paises');  
            $this->db->where_not_in('cod_pais','169');
            $query4 = $this->db->get();
            foreach ($query4->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_pais']}'>{$row['nombre_pais']}</option>";  
            }
        }
        echo $cadena; 
        $query3->free_result(); 
        $query4->free_result(); 
    }
    
    public function departamento($pais)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('departamento');
        $this->db->order_by('nombre_depa', "asc");
        $this->db->where('cod_pais', $pais);        
        $query = $this->db->get();            
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_depa']}'>{$row['nombre_depa']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }
    
    public function ciudad($pais, $departamento)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('municipio');
        $this->db->where('cod_pais', $pais);
        $this->db->where('id_depa', $departamento);   
        $this->db->order_by('nombre_muni', "asc");     
        $query = $this->db->get();            
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_muni']}'>{$row['nombre_muni']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }
    
    public function localidad($pais, $departamento, $ciudad)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('barrio');
        $this->db->where('cod_pais', $pais);
        $this->db->where('id_depa', $departamento);
        $this->db->where('id_muni', $ciudad);
        $query = $this->db->get();            
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_barr']}'>{$row['nombre_barr']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }
    
    public function zonaresidencia()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('zona_residencia');        
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_zona_resi']}'>{$row['nombre_zona_resi']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }

    public function conszonaresidencia()
    {        
        $this->db->select();
        $this->db->from('zona_residencia');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();     
    }
        
    public function emppromotora()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipoempresaspromotoras');
        $this->db->order_by('orden');        
        $query = $this->db->get();
        //$cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_tipo_promo']}'>{$row['nombre_tipo_promo']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }
    
    public function eps($emppromotora)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('administradoras');
        $this->db->where('id_tipo_promo', $emppromotora);     
        $this->db->order_by('nombre_admi', "asc");   
        $query = $this->db->get();            
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['id_admi']}'>{$row['nombre_admi']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    }

    public function tipousuario()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_usuario');
        $this->db->order_by('orden', 'asc');                
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_tipo_usua']}'>{$row['nombre_tipo_usua']}</option>";
        }
        echo $cadena; 
        $query->free_result();
    } 

    public function constipousuario()
    {        
        $this->db->select();
        $this->db->from('tipo_usuario');
        $this->db->order_by('orden', 'asc');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }     
    public function ocupacion()
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('ocupaciones');
        $this->db->where('id_ocup', '999');        
        $query = $this->db->get();            
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option class='registrolista' value='{$row['id_ocup']}'>{$row['nombre_ocup']}</option>";
           $this->db->select();
            $this->db->from('ocupaciones');
            $this->db->where_not_in('id_ocup', '999');
            $this->db->order_by('nombre_ocup', "asc");                                      
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_ocup']}'>{$row['nombre_ocup']}</option>";
            }  
        }
        echo $cadena; 
        $query->free_result();
        $query2->free_result(); 
    }    
    
    public function videntificacion($tipo_docu, $identificacion)
    {
        $this->db->select();
        $this->db->from('pacientes');        
        $this->db->where('tipo_docu',$tipo_docu);
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            echo '1';            
        }else
        {
            echo '0';            
        }
        $query->free_result();
    }    
    
    
    
    public function ingresopaciente($paciente, $numeroc) {
        // ACTUALIZA LA HISTORIA EN CONSECUTIVOS
        $chistoria = array(
            'numero_consecutivo' => $numeroc,
        );
        $this->db->where('cod_consecutivo', 10);
        $this->db->update('consecutivos', $chistoria);

        // INSERTA PACIENTE
        return $this->db->insert('pacientes', $paciente);
    }
        
    public function insertAnt($data) {
        return $this->db->insert('pacientes_ant', $data);
    }

    public function tipo_docu($tipo_docu)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_documento');
        $this->db->where('tipo_docu', $tipo_docu);        
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena = $row['tipo_docu']. ' - '. $row['nombre_tipo_docu'];
        }
        echo $cadena; 
                        
        $query->free_result();  
     }
    
    public function sigla_sexo($sigla_sexo)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('sexo');
        $this->db->where('sigla_sexo', $sigla_sexo);        
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena = $row['sigla_sexo']. ' - '. $row['nombre_sexo'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }                
            
    public function cod_pais($cod_pais)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('paises');
        $this->db->where('cod_pais', $cod_pais);        
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_pais'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }
    
    public function id_depa($cod_pais, $id_depa)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('departamento');
        $this->db->where('cod_pais', $cod_pais);
        $this->db->where('id_depa', $id_depa);        
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_depa'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }    
    
    public function id_muni($cod_pais, $id_depa, $id_muni)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('municipio');
        $this->db->where('cod_pais', $cod_pais);
        $this->db->where('id_depa', $id_depa);
        $this->db->where('id_muni', $id_muni);         
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_muni'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }
    
    public function id_barr($cod_pais, $id_depa, $id_muni, $id_barr)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('barrio');
        $this->db->where('cod_pais', $cod_pais);
        $this->db->where('id_depa', $id_depa);
        $this->db->where('id_muni', $id_muni);
        $this->db->where('id_barr', $id_barr);          
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_barr'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }
    
    public function cod_estado_civi($cod_estado_civi)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('estadocivil');
        $this->db->where('cod_estado_civi', $cod_estado_civi);              
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_estado_civi'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }
    
    public function cod_zona_resi($cod_zona_resi)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('zona_residencia');
        $this->db->where('cod_zona_resi', $cod_zona_resi);              
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_zona_resi'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }
    
    public function id_admi($id_admi)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('administradoras');
        $this->db->where('id_admi', $id_admi);              
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_admi'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }
    
    public function cod_tipo_usua($cod_tipo_usua)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_usuario');
        $this->db->where('cod_tipo_usua', $cod_tipo_usua);              
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_tipo_usua'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }
    
    public function id_ocup($id_ocup)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('ocupaciones');
        $this->db->where('id_ocup', $id_ocup);              
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['nombre_ocup'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }
    
    public function antecedentes($tipo_docu, $identificacion)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('tipo_docu', $tipo_docu);              
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena.=   "<div class='row'>";
           $cadena.=   "<h5><u><strong>Familiares</strong></u></h5>  ";
           $cadena.=   "<textarea class='form-control ' rows='5'  >{$row['antecedentefamiliar']}</textarea>";
           $cadena.=   "</div>";
           $cadena.=   "<div class='row'>";
           $cadena.=   "<h5><u><strong>Personales</strong></u></h5>";
           $cadena.=   "<textarea class='form-control' rows='5' >{$row['antecedentepersonal']}</textarea>";
           $cadena.=   "</div>";
           
        }
        echo $cadena;         
        $query->free_result();                
    }
    
    public function alergias($tipo_docu, $identificacion)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('tipo_docu', $tipo_docu);              
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena.=   "<div class='row'>";           
           $cadena.=   "<textarea class='form-control' rows='5'  >{$row['alergia']}</textarea>";
           $cadena.=   "</div>";
           
        }
        echo $cadena;         
        $query->free_result();                
    }
    
    public function vacunas($tipo_docu, $identificacion)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('tipo_docu', $tipo_docu);              
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena.=   "<div class='row'>";           
           $cadena.=   "<textarea class='form-control' rows='5'  >{$row['vacunas']}</textarea>";
           $cadena.=   "</div>";
        }
        echo $cadena;         
        $query->free_result();                
    }
    
    public function intervenciones($tipo_docu, $identificacion)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('tipo_docu', $tipo_docu);              
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena.=   "<div class='row'>";           
           $cadena.=   "<textarea class='form-control' rows='5'  >{$row['intervenciones']}</textarea>";
           $cadena.=   "</div>";
        }
        echo $cadena;         
        $query->free_result();                
    }
    
    public function enfermedades($tipo_docu, $identificacion)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('tipo_docu', $tipo_docu);              
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena.=   "<div class='row'>";           
           $cadena.=   "<textarea class='form-control' rows='5' >{$row['enfermedades']}</textarea>";
           $cadena.=   "</div>";
        }
        echo $cadena;         
        $query->free_result();                
    }
    
    public function vacompanante($identificacion)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('acompanante');                      
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();  
        $cadena.=   "<table class='table table-striped table-bordered' id='tabla'>";
        $cadena.=   "<thead class='encabezadotabla'>";
        $cadena.=   "<th class='text-center'>Fecha</th>";        
        $cadena.=   "<th class='text-center'>Nombre</th>";
        $cadena.=   "<th class='text-center'>Teléfono</th>";
        $cadena.=   "<th class='text-center'>Celular</th>";
        $cadena.=   "</thead>";
        $cadena.=   "<tbody>";      
        foreach ($query->result_array() as $row)
        {
           $cadena.=   "<tr>";           
           $cadena.=   "<td>{$row['fecha']}</td>";           
           $cadena.=   "<td>{$row['nombre_acom']}</td>";           
           $cadena.=   "<td>{$row['telefono_acom']}</td>";
           $cadena.=   "<td>{$row['celular_acom']}</td>";
           $cadena.=   "</tr>";
        }
        $cadena.=   "</tbody>";
        $cadena.=   "</table>";
        echo $cadena;         
        $query->free_result();                
    }
    
    public function modtipo_docu($tipo_docu)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_documento');        
        $this->db->where('tipo_docu', $tipo_docu);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['tipo_docu']}' caracter = '{$row['caracteres']}'>Actual : {$row['nombre_tipo_docu']}</option>";            
            $this->db->select();
            $this->db->from('tipo_documento');  
            $this->db->where_not_in('tipo_docu',$tipo_docu);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['tipo_docu']}' caracter = '{$row['caracteres']}'>{$row['nombre_tipo_docu']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modsigla_sexo($sexo)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('sexo');        
        $this->db->where('sigla_sexo', $sexo);        
        $query3 = $this->db->get();
        $cadena.="";
        foreach ($query3->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['sigla_sexo']}'>Actual: {$row['nombre_sexo']}</option>";            
            $this->db->select();
            $this->db->from('sexo');  
            $this->db->where_not_in('sigla_sexo',$sexo);
            $this->db->where_not_in('sigla_sexo', 'A');
            $query4 = $this->db->get();
            foreach ($query4->result_array() as $row)
            {
                $cadena.="<option value='{$row['sigla_sexo']}'>{$row['nombre_sexo']}</option>";  
            }
        }
        echo $cadena; 
        $query3->free_result(); 
        $query4->free_result();    
    }
    
    public function modcod_pais($cod_pais)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('paises');        
        $this->db->where('cod_pais', $cod_pais);
        $query3 = $this->db->get();
        $cadena.="";
        foreach ($query3->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_pais']}'>Actual: {$row['nombre_pais']}</option>";            
            $this->db->select();
            $this->db->from('paises');  
            $this->db->where_not_in('cod_pais',$cod_pais);
            $query4 = $this->db->get();
            foreach ($query4->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_pais']}'>{$row['nombre_pais']}</option>";  
            }
        }
        echo $cadena; 
        $query3->free_result(); 
        $query4->free_result();    
    }        
    
    public function modcod_consultorio($cod_consultorio)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('consultorios');        
        $this->db->where('cod_consultorio', $cod_consultorio);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_consultorio']}'>Actual: {$row['nom_consultorio']}</option>";            
            $this->db->select();
            $this->db->from('consultorios');  
            $this->db->where_not_in('cod_consultorio',$cod_consultorio);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_consultorio']}'>{$row['nom_consultorio']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modid_depa($cod_pais, $id_depa)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('departamento');        
        $this->db->where('cod_pais', $cod_pais);
        $this->db->where('id_depa', $id_depa);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['id_depa']}'>Actual: {$row['nombre_depa']}</option>";            
            $this->db->select();
            $this->db->from('departamento'); 
            $this->db->where('cod_pais', $cod_pais); 
            $this->db->where_not_in('id_depa',$id_depa);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_depa']}'>{$row['nombre_depa']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modid_muni($cod_pais, $id_depa, $id_muni)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('municipio');        
        $this->db->where('cod_pais', $cod_pais);
        $this->db->where('id_depa', $id_depa);
        $this->db->where('id_muni', $id_muni);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['id_muni']}'>Actual: {$row['nombre_muni']}</option>";            
            $this->db->select();
            $this->db->from('municipio'); 
            $this->db->where('cod_pais', $cod_pais);
            $this->db->where('id_depa', $id_depa); 
            $this->db->where_not_in('id_muni', $id_muni);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_muni']}'>{$row['nombre_muni']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modid_barr($cod_pais, $id_depa, $id_muni, $id_barr)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('barrio');        
        $this->db->where('cod_pais', $cod_pais);
        $this->db->where('id_depa', $id_depa);
        $this->db->where('id_muni', $id_muni);
        $this->db->where('id_barr', $id_barr);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['id_barr']}'>Actual: {$row['nombre_barr']}</option>";            
            $this->db->select();
            $this->db->from('barrio'); 
            $this->db->where('cod_pais', $cod_pais);
            $this->db->where('id_depa', $id_depa);
            $this->db->where('id_muni', $id_muni); 
            $this->db->where_not_in('id_barr', $id_barr);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_barr']}'>{$row['nombre_barr']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modcod_estado_civi($cod_estado_civi)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('estadocivil');        
        $this->db->where('cod_estado_civi', $cod_estado_civi);        
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_estado_civi']}'>Actual: {$row['nombre_estado_civi']}</option>";            
            $this->db->select();
            $this->db->from('estadocivil');             
            $this->db->where_not_in('cod_estado_civi', $cod_estado_civi);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_estado_civi']}'>{$row['nombre_estado_civi']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modcod_grupo_sang($cod_grupo_sang)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('gruposanguineo');        
        $this->db->where('cod_grupo_sang', $cod_grupo_sang);        
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_grupo_sang']}'>Actual: {$row['cod_grupo_sang']}</option>";            
            $this->db->select();
            $this->db->from('gruposanguineo');             
            $this->db->where_not_in('cod_grupo_sang', $cod_grupo_sang);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_grupo_sang']}'>{$row['cod_grupo_sang']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modcod_zona_resi($cod_zona_resi)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('zona_residencia');        
        $this->db->where('cod_zona_resi', $cod_zona_resi);        
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_zona_resi']}'>Actual: {$row['nombre_zona_resi']}</option>";            
            $this->db->select();
            $this->db->from('zona_residencia');             
            $this->db->where_not_in('cod_zona_resi', $cod_zona_resi);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_zona_resi']}'>{$row['nombre_zona_resi']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
        
    public function modemppromotora($eps)
    {
        $cadena = '';
        $this->db->distinct('id_tipo_promo');
        $this->db->from('administradoras');        
        $this->db->where('id_admi', $eps);        
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
            $promo  =   $row['id_tipo_promo'];            
        }        
        $this->db->select();
        $this->db->from('tipoempresaspromotoras');             
        $this->db->where('id_tipo_promo', $promo);
        $query2 = $this->db->get();
        $cadena.="";
        foreach ($query2->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['id_tipo_promo']}'>{$row['nombre_tipo_promo']}</option>";
            $this->db->select();
            $this->db->from('tipoempresaspromotoras');             
            $this->db->where_not_in('id_tipo_promo', $promo);
            $query3 = $this->db->get();
            foreach ($query3->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_tipo_promo']}'>{$row['nombre_tipo_promo']}</option>";  
            }  
        }        
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
        $query3->free_result();
    }   
    
    public function modid_admi($id_admi, $emppromotora)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('administradoras');        
        $this->db->where('id_admi', $id_admi); 
        $this->db->where('id_tipo_promo', $emppromotora);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['id_admi']}'>Actual: {$row['nombre_admi']}</option>";            
            $this->db->select();
            $this->db->from('administradoras');  
            $this->db->where('id_tipo_promo', $emppromotora);           
            $this->db->where_not_in('id_admi', $id_admi);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_admi']}'>{$row['nombre_admi']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modcod_tipo_usua($cod_tipo_usua)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_usuario');        
        $this->db->where('cod_tipo_usua', $cod_tipo_usua);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_tipo_usua']}'>Actual: {$row['nombre_tipo_usua']}</option>";            
            $this->db->select();
            $this->db->from('tipo_usuario');
            $this->db->where_not_in('cod_tipo_usua', $cod_tipo_usua);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_tipo_usua']}'>{$row['nombre_tipo_usua']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function modid_ocup($id_ocup)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('ocupaciones');        
        $this->db->where('id_ocup', $id_ocup);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['id_ocup']}'>Actual: {$row['nombre_ocup']}</option>";            
            $this->db->select();
            $this->db->from('ocupaciones');
            $this->db->where_not_in('id_ocup', $id_ocup);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_ocup']}'>{$row['nombre_ocup']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result();    
    }
    
    public function cacompanante($pidentificacion)
    {
        $this->db->select();
        $this->db->from('acompanante');
        $this->db->where('identificacion',$pidentificacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();       
    }
    
    public function tipodocuacom($tipodocuacom)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo_documento');        
        $this->db->where('tipo_docu',$tipodocuacom);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['tipo_docu']}'>Actual: {$row['nombre_tipo_docu']}</option>";            
            $this->db->select();
            $this->db->from('tipo_documento');
            $this->db->where_not_in('tipo_docu',$tipodocuacom);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['tipo_docu']}'>{$row['nombre_tipo_docu']}</option>";  
            }
        }
        echo $cadena; 
        $query->free_result(); 
        $query2->free_result(); 
    }
    
    public function actualizarpaciente0()
    {
    // VER X PANTALLA LA INFORMACION DE LA MATRIZ INFORMO
        print_r($_POST['informo']);
        //print_r($_POST['data']);
    }
    public function actualizarpaciente()
    {
    // VER X PANTALLA LA INFORMACION DE LA MATRIZ INFORMO
        //print_r($_POST['informo']);
        //print_r($_POST['data']);
        //if(!empty($this->session_id))  
//		{
            if($this->input->post())
            {
                $dat = $this->input->post('informo');         
                $dat = json_decode($dat);
                if (is_array($dat)) 
                {
                    foreach ($dat as $row => $val) 
                    { 
                        $id_paciente   =   trim($val->id_paciente);
                        
                        //generando edad y unidad medida de la edad
                        date_default_timezone_set('America/Bogota');
                        $ma                     = 12;
                        $fechan                 = trim($val->fecha_de_nacimiento);
                        $edadpaciente           = '';
                        $totaldiasmes           = '';
                        list($Y,$m,$d)          = explode("-",$fechan);            
                        $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
                        $edadpaciente           = intval($edadpaciente);
                        $mn                     = intval($m);  
                        $dn                     = intval($d);
                        $mesactual              = intval(date("m"));
                        $diaactual              = intval(date("d"));            
                        $mesanterior            = '';     
                        $anocomp                = '';     
                        $anoactual              = intval(date("Y")); 
                        $anon                   = $Y;
                        $ume                    = '';
                                  
                        if($mn == 2)
                        {
                            $totaldiasmes = 28;
                        }
                        if($dn == 31)
                        {
                            $dn = $dn - 1;
                        }
                        if($mn == 2 && $dn >= 29)
                        {
                            $dn = 28;
                        }
                        //$edad = $edadpaciente;
                        
                        if($edadpaciente == 0)
                        {             
                            //MESES ACTUALES DEL PACIENTE               
                           
                            if($mesactual == 1)
                            {
                                $mesanterior = 12;
                            }                
                            else
                            {
                                $mesanterior = $mesactual - 1;
                            }
                            
                            if($mesanterior == $mn || $mn == $mesactual)
                            {
                                if($mn == $mesactual)
                                {
                                    $edadresultado = $diaactual - $dn;
                                }
                                else
                                {
                                    $edadresultado = $diaactual + 30 - $dn;
                                    
                                }
                                
                                if($edadresultado >= 31)
                                {
                                    $edad   = $mesactual - $mn;
                                    $ume    = 2;  
                                }
                                else
                                {
                                    $edad = $edadresultado;
                                    $ume    = 3;
                                }                    
                            }
                            else
                            {
                                $anocomp        = $anoactual - 1;
                                if($anocomp == $anon)
                                {
                                    $edad  = 12 - $mn + $mesactual;
                                    $ume    = 2;
                                }
                                else
                                {
                                    $edad  = $mesactual - $mn;
                                    $ume    = 2;
                                }
                            }
                        }
                        else
                        {
                            $edad   = $edadpaciente;
                            $ume    = 1;
                        }
                        
                        $loginmod              =  trim($val->loginmod);                        
                        $primer_nombre         =  trim($val->primer_nombre);                          
                        $segundo_nombre        =  trim($val->segundo_nombre);                                    
                        $primer_apellido       =  trim($val->primer_apellido);                        
                        $segundo_apellido      =  trim($val->segundo_apellido);
                        $tipo_docu             =  trim($val->tipo_docu);
                        $identificacion        =  trim($val->identificacion);                
                        $sigla_sexo            =  trim($val->sigla_sexo);       
                        $fecha_de_nacimiento   =  trim($val->fecha_de_nacimiento);                
                        $cod_pais              =  trim($val->cod_pais);                
                        $id_depa               =  trim($val->id_depa);                
                        $id_muni               =  trim($val->id_muni);                
                        $barrio                =  trim($val->barrio);        
                        $cod_estado_civi       =  trim($val->cod_estado_civi);                
                        $cod_grupo_sang        =  trim($val->cod_grupo_sang);              
                        $celular_paciente      =  trim($val->celular_paciente);
                        $telefono_paciente     =  trim($val->telefono_paciente);                
                        $direccion_paci        =  trim($val->direccion_paci);   
                        $cod_zona_resi         =  trim($val->cod_zona_resi);               
                        $email_paciente        =  trim($val->email_paciente);                
                        $eps                   =  trim($val->eps);
                        $cod_tipo_usua         =  trim($val->cod_tipo_usua);
                        $ocupacion             =  trim($val->ocupacion);
                        $referidopor           =  trim($val->referidopor);
                        $facebook              =  trim($val->facebook);
                        $religion              =  trim($val->religion);
                        $nombre_acom           =  trim($val->nombre_acom);    
                        $telefono_acom         =  trim($val->telefono_acom);
                        $celular_acom          =  trim($val->celular_acom);
                        $parentescoacom        =  trim($val->parentescoacom);
                        $nombre_acu            =  trim($val->nombre_acu);
                        $telefono_acu          =  trim($val->telefono_acu);
                        $celular_acu           =  trim($val->celular_acu);
                        $parentescoacu         =  trim($val->parentescoacu);
                        $cod_consultorio       =  trim($val->cod_consultorio);
                        $cod_medi              =  trim($val->cod_medi);
                        $fechamod              =  trim($val->fechamod);
                        $horamod               =  trim($val->horamod);
                        $loginmod              =  trim($val->loginmod);
                        $firmapaci             =  trim($val->firmapaci);
                        $firmamedi             =  trim($val->firmamedi);
                        $imagenfoto            =  trim($val->imagenfoto);
                        
                       
                         
                        $this->db->select();
                        $this->db->from('usuarios');
                        $this->db->where('login', $loginmod);   
                        $query = $this->db->get();
                                                                        
                        if ($query->num_rows() <= 0)
                        {
                            $datos['error'] =   'Falta login';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($primer_nombre == '')
                        {
                            $datos['error'] =   'Falta el primer nombre';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($primer_apellido == '')
                        {
                            $datos['error'] =   'Falta el primer apellido';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($tipo_docu == '')
                        {
                            $datos['error'] =   'Falta el tipo de documento';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($identificacion == '')
                        {
                            $datos['error'] =   'Falta la identificación';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($sigla_sexo == '')
                        {
                            $datos['error'] =   'Falta la sigla del sexo';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($fecha_de_nacimiento == '')
                        {
                            $datos['error'] =   'Falta la fecha de nacimiento';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($cod_pais == '')
                        {
                            $datos['error'] =   'Falta el país';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($id_depa == '')
                        {
                            $datos['error'] =   'Falta el departamento';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($id_muni == '')
                        {
                            $datos['error'] =   'Falta la municipio';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else
                        {
                            // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: consulta_medica
                            $data = array(
                            'loginmod'              =>  $loginmod,
                            'primer_nombre'         =>  $primer_nombre,                
                            'segundo_nombre'        =>  $segundo_nombre,
                            'primer_apellido'       =>  $primer_apellido,
                            'segundo_apellido'      =>  $segundo_apellido,
                            'tipo_docu'             =>  $tipo_docu,
                            'identificacion'        =>  $identificacion,                
                            'sigla_sexo'            =>  $sigla_sexo,                
                            'fecha_de_nacimiento'   =>  $fecha_de_nacimiento,                
                            'cod_pais'              =>  $cod_pais,                
                            'id_depa'               =>  $id_depa,                
                            'id_muni'               =>  $id_muni,                
                            'barrio'                =>  $barrio,                
                            'cod_estado_civi'       =>  $cod_estado_civi,                
                            'cod_grupo_sang'        =>  $cod_grupo_sang,                
                            'celular_paciente'      =>  $celular_paciente,
                            'telefono_paciente'     =>  $telefono_paciente,                
                            'direccion_paci'        =>  $direccion_paci,   
                            'cod_zona_resi'         =>  $cod_zona_resi,                
                            'email_paciente'        =>  $email_paciente,                
                            'eps'                   =>  $eps, 
                            'cod_tipo_usua'         =>  $cod_tipo_usua,
                            'ocupacion'             =>  $ocupacion,
                            'referidopor'           =>  $referidopor,
                            'facebook'              =>  $facebook,
                            'religion'              =>  $religion,
                            'nombre_acom'           =>  $nombre_acom,    
                            'telefono_acom'         =>  $telefono_acom,
                            'celular_acom'          =>  $celular_acom,
                            'parentescoacom'        =>  $parentescoacom,
                            'nombre_acu'            =>  $nombre_acu,
                            'telefono_acu'          =>  $telefono_acu,
                            'celular_acu'           =>  $celular_acu,
                            'parentescoacu'         =>  $parentescoacu,                            
                            'cod_consultorio'       =>  $cod_consultorio,
                            'cod_medi'              =>  $cod_medi,
                            'fechamod'              =>  $fechamod,
                            'horamod'               =>  $horamod,
                            'loginmod'              =>  $loginmod,
                            'firmapaci'             =>  $firmapaci,
                            'firmamedi'             =>  $firmamedi,
                            'imagenfoto'            =>  $imagenfoto                            
                            );
                            
                           // ACTUALIZANDO DATOS ENCABEZADO               
                            $this->db->where('id_paciente', $id_paciente);
                            $this->db->update('pacientes', $data);
                        }
                        // RETORNANDO VARIABLES PARA CONSULTAS
                        $datosr['tipo_docu']           =   $tipo_docu;
                        $datosr['identificacion']      =   $identificacion;
                        $datosr['rfecha_de_nacimiento']=   $fecha_de_nacimiento;  
                        
                        return $datosr;
                    }
                                        
                }
                else
                {
                    redirect(base_url().'usuarios/logout', 301);	 
                }
            }                            
            else
            {   
                redirect(base_url().'usuarios/avisosesion', 301);	 
            }
        //}
//        else
//        {
//            redirect(base_url().'usuarios/avisosesion', 301);	 
//        }
        
    }
    
    public function vtipo_docu($vtipo_docu)
    {
        $this->db->select();
        $this->db->from('tipo_documento');        
        $this->db->where('tipo_docu',$vtipo_docu);
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['tipo_docu'].' - '.$row['nombre_tipo_docu'];
        } 
        $query->free_result();                
    }                         
    
    public function vsigla_sexo($vsigla_sexo)
    {
        $this->db->select();
        $this->db->from('sexo');        
        $this->db->where('sigla_sexo',$vsigla_sexo);
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_sexo'];
        } 
        $query->free_result();                
    }
    
    public function vcod_estado_civi($vcod_estado_civi)
    {
        $this->db->select();
        $this->db->from('estadocivil');        
        $this->db->where('cod_estado_civi',$vcod_estado_civi);
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_estado_civi'];
        } 
        $query->free_result();                
    }
    
    public function vcod_pais($vcod_pais)
    {
        $this->db->select();
        $this->db->from('paises');        
        $this->db->where('cod_pais',$vcod_pais);
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_pais'];
        } 
        $query->free_result();                
    }               
    
    public function vid_depa($vid_depa, $vcod_pais)
    {
        $this->db->select();
        $this->db->from('departamento');        
        $this->db->where('cod_pais',$vcod_pais);
        $this->db->where('id_depa',$vid_depa);
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_depa'];
        } 
        $query->free_result();                
    }
    
    public function vid_muni($vid_depa, $vcod_pais, $vid_muni)
    {
        $this->db->select();
        $this->db->from('municipio');        
        $this->db->where('cod_pais',$vcod_pais);
        $this->db->where('id_depa',$vid_depa);
        $this->db->where('id_muni',$vid_muni);
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_muni'];
        } 
        $query->free_result();                
    }
    
    public function vid_barr($vid_depa, $vcod_pais, $vid_muni, $vid_barr)
    {
        $this->db->select();
        $this->db->from('barrio');        
        $this->db->where('cod_pais',$vcod_pais);
        $this->db->where('id_depa',$vid_depa);
        $this->db->where('id_muni',$vid_muni);
        $this->db->where('id_barr',$vid_barr);        
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_barr'];
        } 
        $query->free_result();                
    }
    
    public function vcod_zona_resi($vcod_zona_resi)
    {
        $this->db->select();
        $this->db->from('zona_residencia');
        $this->db->where('cod_zona_resi',$vcod_zona_resi);        
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_zona_resi'];
        } 
        $query->free_result();                
    }
    
    public function vid_admi($vid_admi)
    {
        $this->db->select();
        $this->db->from('administradoras');
        $this->db->where('id_admi',$vid_admi);        
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_admi'];
        } 
        $query->free_result();                
    }
    
    public function vcod_tipo_usua($vcod_tipo_usua)
    {
        $this->db->select();
        $this->db->from('tipo_usuario');
        $this->db->where('cod_tipo_usua',$vcod_tipo_usua);        
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_tipo_usua'];
        } 
        $query->free_result();                
    }
    
    public function vid_ocup($vid_ocup)
    {
        $this->db->select();
        $this->db->from('ocupaciones');
        $this->db->where('id_ocup',$vid_ocup);        
        $query = $this->db->get();
        foreach ($query->result_array() as $row)
        {
            echo $row['nombre_ocup'];
        } 
        $query->free_result();                
    }
    
    public function masistente($nivel_usuario)
    {
        $this->db->select('p.vistav');
        $this->db->from('nuxprograma n');
        $this->db->join('programas p','n.codprograma = p.id');
        $this->db->where('n.nivel_usuario', $nivel_usuario);
        $this->db->where('n.raiz','45');      
        $this->db->where('n.menu','x');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();        
    }   

    public function cmedica($nconsulta)
    {
        $this->db->select();
        $this->db->from('consulta_medica');        
        $this->db->where('nconsulta', $nconsulta);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();     
    }                                        


    public function cmtratamiento($nconsulta)
    {
        $this->db->select();
        $this->db->from('consulta_medicaxtratamiento');        
        $this->db->where('nconsulta', $nconsulta);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();     
    }        
    
    public function cmedico($persona, $id_usuario, $codmedi)
    {        
        $cadena = '';
        if($persona == 20)
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora');
            $this->db->from('medicos m'); 
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
            $this->db->where('m.cod_medi', $codmedi);                  
            $query = $this->db->get();
            $cadena.="";
            foreach ($query->result_array() as $row)
            {
                $cadena.="<option class='registrolista' value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
                $this->db->select('m.*, a.nombre_admi, a.id_administradora');
                $this->db->from('medicos m'); 
                $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
                $this->db->where_not_in('m.cod_medi', $codmedi);                  
                $query2 = $this->db->get();
                foreach ($query2->result_array() as $row)
                {
                    $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";  
                } 
            }                 
            return $cadena;
            $query->free_result(); 
            $query2->free_result(); 
        }
        else
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora');
            $this->db->from('medicos m');  
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
            $this->db->where('m.id_usuario', $id_usuario); 
            $this->db->or_where('m.cod_medi', $codmedi);                  
            $query = $this->db->get();
            $cadena.="";
            foreach ($query->result_array() as $row)
            {
               $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }                 
            return $cadena;
            $query->free_result(); 
        }        
    }   
   
    public function cfinalidad($idfinalidad)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('finalidad');             
        $this->db->where('id_finalidad', $idfinalidad);
        $this->db->where('cod_tipo_fina', 1);
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['id_finalidad']}'>{$row['nombre_fina']}</option>";
            $this->db->select();
            $this->db->from('finalidad');             
            $this->db->where_not_in('id_finalidad', $idfinalidad);
            $this->db->where('cod_tipo_fina', 1);
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['id_finalidad']}'>{$row['nombre_fina']}</option>";  
            }  
        }        
        return $cadena; 
        $query->free_result(); 
        $query2->free_result();
    }  
    
    public function ccausa($codcausadia) 
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('causa_diagnostico');             
        $this->db->where('cod_causa_dia', $codcausadia);        
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_causa_dia']}'>{$row['nombre_causa_dia']}</option>";
            $this->db->select();
            $this->db->from('causa_diagnostico');             
            $this->db->where_not_in('cod_causa_dia', $codcausadia);            
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_causa_dia']}'>{$row['nombre_causa_dia']}</option>";  
            }  
        }        
        return $cadena; 
        $query->free_result(); 
        $query2->free_result();
    }  
    
    public function ctipo($codtipo) 
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('tipo');             
        $this->db->where('cod_tipo', $codtipo);        
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_tipo']}'>{$row['nombre_tipo']}</option>";
            $this->db->select();
            $this->db->from('tipo');             
            $this->db->where_not_in('cod_tipo', $codtipo);            
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_tipo']}'>{$row['nombre_tipo']}</option>";  
            }  
        }        
        return $cadena; 
        $query->free_result(); 
        $query2->free_result();
    }  
    
    public function cidadmi($idadmi)
    {        
        $this->db->select();
        $this->db->from('administradoras');             
        $this->db->where('id_admi', $idadmi);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }    

    public function ccod_cons($codcons, $codmedi)
    {
        $cadena = '';
        $this->db->select('e.cod_cons, c.nombre_cons');
        $this->db->from('especialidadxconsulta e');        
        $this->db->join('consulta c', 'c.cod_cons = e.cod_cons');        
        $this->db->where('e.cod_cons', $codcons);
        $this->db->where('e.cod_medi', $codmedi);        
        $query = $this->db->get();
        $cadena.="";
        foreach ($query->result_array() as $row)
        {
            $cadena.="<option class='registrolista' value='{$row['cod_cons']}'>{$row['nombre_cons']}</option>";
            $this->db->select('e.cod_cons, c.nombre_cons');
            $this->db->from('especialidadxconsulta e');        
            $this->db->join('consulta c', 'c.cod_cons = e.cod_cons');        
            $this->db->where_not_in('e.cod_cons', $codcons);
            $this->db->where('e.cod_medi', $codmedi); 
            $query2 = $this->db->get();
            foreach ($query2->result_array() as $row)
            {
                $cadena.="<option value='{$row['cod_cons']}'>{$row['nombre_cons']}</option>";
            }
        }
        return $cadena; 
        $query->free_result();
        $query2->free_result();    
    }
    
    public function ccodconsultav($codcons, $codmedi)
    {
        $this->db->select('e.cod_cons, c.nombre_cons');
        $this->db->from('especialidadxconsulta e');        
        $this->db->join('consulta c', 'c.cod_cons = e.cod_cons');        
        $this->db->where('e.cod_cons', $codcons);
        $this->db->where('e.cod_medi', $codmedi);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }
    
    public function fconsultamedicamod1()
    {
    // VER X PANTALLA LA INFORMACION DE LA MATRIZ INFORMO
        print_r($_POST['informo']);
        //print_r($_POST['data']);        
    }
    
    public function fconsultamedicamod()
    {            
        if(!empty($this->session_id))  
		{
            if($this->input->post())
            {
                $loginmod         =  $this->session_id; 
                $this->db->select();
                $this->db->from('usuarios');
                $this->db->where('login', $loginmod);   
                $query = $this->db->get();
                if ($query->num_rows() <= 0)
                {
                    $datos['error'] =   'Falta login';
                    $this->load->view('front_end/salidaerror', $datos);
                    redirect(base_url().'usuarios/logout', 301);	  
                }else
                {
                    // RECORRER MATRIZ INFORMO QUE VIENE DE JSON
                    $dat = $this->input->post('informo');         
                    $dat = json_decode($dat);
                    if (is_array($dat)) 
                    {
                        foreach ($dat as $row => $val) 
                        {     
                            $identificacion = trim(strtolower($val->identificacion));
                            $tipo_docu      = trim(strtolower($val->tipo_docu));
                            $this->db->select();
                            $this->db->from('pacientes');
                            $this->db->where('identificacion', $identificacion);
                            $this->db->where('tipo_docu', $tipo_docu);
                            $query1 = $this->db->get();
                            foreach($query1->result_array() as $pac)
                            {    
                                $fechan                 = $pac['fecha_de_nacimiento'];                   
                            }
                            
                            //generando edad y unidad medida de la edad
                            date_default_timezone_set('America/Bogota');
                            $ma                     = 12;
                            //$fechan                 = $paci['fecha_de_nacimiento'];
                            $edadpaciente           = '';
                            $totaldiasmes           = '';
                            list($Y,$m,$d)          = explode("-",$fechan);            
                            $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
                            $edadpaciente           = intval($edadpaciente);
                            $mn                     = intval($m);  
                            $dn                     = intval($d);
                            $mesactual              = intval(date("m"));
                            $diaactual              = intval(date("d"));            
                            $mesanterior            = '';     
                            $anocomp                = '';     
                            $anoactual              = intval(date("Y")); 
                            $anon                   = $Y;
                            $ume                    = '';
                                      
                            if($mn == 2)
                            {
                                $totaldiasmes = 28;
                            }
                            if($dn == 31)
                            {
                                $dn = $dn - 1;
                            }
                            if($mn == 2 && $dn >= 29)
                            {
                                $dn = 28;
                            }
                            //$edad = $edadpaciente;
                            
                            if($edadpaciente == 0)
                            {             
                                //MESES ACTUALES DEL PACIENTE               
                               
                                if($mesactual == 1)
                                {
                                    $mesanterior = 12;
                                }                
                                else
                                {
                                    $mesanterior = $mesactual - 1;
                                }
                                
                                if($mesanterior == $mn || $mn == $mesactual)
                                {
                                    if($mn == $mesactual)
                                    {
                                        $edadresultado = $diaactual - $dn;
                                    }
                                    else
                                    {
                                        $edadresultado = $diaactual + 30 - $dn;
                                        
                                    }
                                    
                                    if($edadresultado >= 31)
                                    {
                                        $edad   = $mesactual - $mn;
                                        $ume    = 2;  
                                    }
                                    else
                                    {
                                        $edad = $edadresultado;
                                        $ume    = 3;
                                    }                    
                                }
                                else
                                {
                                    $anocomp        = $anoactual - 1;
                                    if($anocomp == $anon)
                                    {
                                        $edad  = 12 - $mn + $mesactual;
                                        $ume    = 2;
                                    }
                                    else
                                    {
                                        $edad  = $mesactual - $mn;
                                        $ume    = 2;
                                    }
                                }
                            }
                            else
                            {
                                $edad   = $edadpaciente;
                                $ume    = 1;
                            }
                            
                            // ASIGNACION DE VARIABLES
                                            
                            $edad              =  trim($edad);
                            $ume               =  trim($ume);                
                            $cod_medi          =  trim($val->cod_medi);                
                            $id_admi           =  trim($val->id_admi);
                            $cod_cons          =  trim($val->cod_cons);
                            $sist              =  trim($val->sist);
                            $diast             =  trim($val->diast);
                            $ppm               =  trim($val->ppm);
                            $rpm               =  trim($val->rpm);
                            $grados            =  trim($val->grados);
                            $altura            =  trim($val->altura);
                            $peso              =  trim($val->peso);
                            $imc               =  trim($val->imc);                
                            $autorizacion      =  trim(strtoupper($val->autorizacion));
                            $id_finalidad      =  $val->id_finalidad;
                            $cod_causa_dia     =  trim(strtoupper($val->cod_causa_dia));
                            $cod_tipo          =  trim(strtoupper($val->cod_tipo));
                            $observacionescie  =  trim(strtoupper($val->observacionescie));
                            $valor_cie         =  trim($val->valor_cie);
                            $valor_cuota       =  trim($val->valor_cuota);
                            $valor_subtotal    =  trim($val->valor_subtotal);
                            $observacionescups =  trim(strtoupper($val->observacionescups));
                            $valor_cups        =  trim($val->valor_cups);
                            $valor_total       =  trim($val->valor_total);
                            $horamod           =  trim($val->horaactual);
                            $fechamod          =  trim($val->fechaactual);
                            $observacionescorreccion    =   trim($val->observacionescorreccion);
                            
                            // VALIDACIONES DE CAMPOS
                            if ($identificacion == '')
                            {
                                $datos['error'] =   'Falta identificación';
                                $this->load->view('front_end/salidaerror', $datos); 
                            }else if($tipo_docu == '')
                            {
                                $datos['error'] =   'Falta tipo de documento';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($edad == '')
                            {
                                $datos['error'] =   'Falta la edad';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($ume == '')
                            {
                                $datos['error'] =   'Falta la ume';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($cod_medi == '')
                            {
                                $datos['error'] =   'Falta el código del médico';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($id_admi == '')
                            {
                                $datos['error'] =   'Falta la administradora';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($cod_cons == '')
                            {
                                $datos['error'] =   'Falta la consulta';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($id_finalidad == '')
                            {
                                $datos['error'] =   'Falta la finalidad';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($cod_causa_dia == '')
                            {
                                $datos['error'] =   'Falta la causa';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($cod_tipo == '')
                            {
                                $datos['error'] =   'Falta el tipo';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($horamod == '')
                            {
                                $datos['error'] =   'Falta la hora de modificación';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($fechamod == '')
                            {
                                $datos['error'] =   'Falta la fecha de modificación';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else
                            {
                                // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: consulta_medica
                                $data = array(
                                'loginmod'          =>  $loginmod,                
                                'edad'              =>  trim($edad),
                                'ume'               =>  trim($ume),                    
                                'cod_medi'          =>  $cod_medi,                
                                'id_admi'           =>  $id_admi,
                                'cod_cons'          =>  $cod_cons,
                                'sist'              =>  $sist,
                                'diast'             =>  $diast,
                                'ppm'               =>  $ppm,
                                'rpm'               =>  $rpm,
                                'grados'            =>  $grados,
                                'altura'            =>  $altura,
                                'peso'              =>  $peso,
                                'imc'               =>  $imc,                    
                                'autorizacion'      =>  $autorizacion,
                                'id_finalidad'      =>  $id_finalidad,
                                'cod_causa_dia'     =>  $cod_causa_dia,
                                'cod_tipo'          =>  $cod_tipo,
                                'observacionescie'  =>  $observacionescie,
                                'valor_cie'         =>  $valor_cie,
                                'valor_cuota'       =>  $valor_cuota,
                                'valor_subtotal'    =>  $valor_subtotal,
                                'observacionescups' =>  $observacionescups,
                                'valor_cups'        =>  $valor_cups,
                                'valor_total'       =>  $valor_total,
                                'horamod'           =>  $horamod,
                                'fechamod'          =>  $fechamod,
                                'observacionescorreccion'   =>  $observacionescorreccion                
                                );
                                
                               // ACTUALIZANDO DATOS A LA TABLA CONSULTA MEDICA
                                $nconsulta   =   trim($val->nconsulta);
                                $this->db->where('nconsulta', $nconsulta);
                                $this->db->update('consulta_medica', $data);  
                                
                                // MATRIZ PARA COTIZACIONES
                                $coti  =   array(
                                'loginmod'             =>      $loginmod,                    
                                'valor_cie'            =>      $valor_cie,
                                'valor_cuota'          =>      $valor_cuota,
                                'valor_cups'           =>      $valor_cups,
                                'valor_bruto'          =>      $valor_total,
                                'valor_total'          =>      $valor_total,
                                'fechamodi'            =>      $fechamod,
                                'horamodi'             =>      $horamod          
                                );
                                
                                // ACTUALIZANDO DATOS ENCABEZADO A LA COTIZACION
                                $ref_procesos       =   'CT';
                                $numero_docu        =   trim($val->cotizacion);
                                $documento_ref      =   trim($val->nconsulta);
                                $proceso_ref        =   'CM';
                
                                $this->db->where('ref_procesos', $ref_procesos);
                                $this->db->where('numero_docu', $numero_docu);
                                $this->db->where('documento_ref', $documento_ref);
                                $this->db->where('proceso_ref', $proceso_ref);                            
                                $this->db->update('encabezado', $coti); 
                                
                                
                            }             
                        }  
                        //CONSULTANDO INFORMACION DEL REGISTRO GRABADO, UTILIZANDO LIBRERIA CONSECUTIVO
                        $consultarconsecutivo = $this->consecutivo->consultamedicaingcon($nconsulta);      
                    }  
                    else
                    {
                        redirect(base_url().'usuarios/logout', 301);	 
                    }
                }
            }                            
            else
            {   
                redirect(base_url().'usuarios/avisosesion', 301);	 
            }
        }
        else
        {
            redirect(base_url().'usuarios/avisosesion', 301);	 
        }
    }
    
    public function tipoabono()
    {
        $this->db->select();
        $this->db->from('tipo_abono');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();       
    }
    
    public function banco()
    {
        $this->db->select();
        $this->db->from('tipo_bancos');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();       
    }
    
    /*public function medicosel($persona, $id_usuario, $login)
    {        
        $cadena = '';
        if($persona == 20 || $persona == 21 )
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');             
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');   
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            //$this->db->where('m.loginasistente', $login);               
            $query = $this->db->get();
            //$cadena.="<option value=''>Seleccione Médico . . .</option>";
            if($query->num_rows() > 0)
            {
                foreach ($query->result_array() as $row)
                {
                    $cadena.="<option value='{$row['cod_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
                    
                }
            }else
            {
                $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
                $this->db->from('medicoxasistente x');             
                $this->db->where('x.login', $login);
                $this->db->join('medicos m', 'x.cod_medi = m.cod_medi');
                $this->db->join('administradoras a', 'm.id_admi = a.id_admi');   
                $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
                 
                                              
                $query1 = $this->db->get();
                foreach ($query1->result_array() as $row)
                {
                    $cadena.="<option value='{$row['cod_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";    
                }
            }
            echo $cadena;
        }
        else
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');            
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');     
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            $this->db->where('m.id_usuario', $id_usuario);                 
            $query = $this->db->get();
            $cadena.="";
            foreach ($query->result_array() as $row)
            {
               $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }
            echo $cadena;     
        }
        $query->free_result(); 
    }*/
    public function medicosel($persona, $id_usuario, $login) {
        $cadena = '';

        //if ($persona === 20 || $persona === 21) {
        if ($persona) {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            //$this->db->order_by('m.orden', 'asc');
            //$this->db->where('m.loginasistente', $login);
            $query = $this->db->get();

            //$cadena.="<option value=''>Seleccione Médico . . .</option>";
            if ($query->num_rows() > 0) {
                foreach ($query->result_array() as $row) {
                    $cadena .= "<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";

                }

            } else {
                $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
                $this->db->from('medicoxasistente x');
                $this->db->where('x.login', $login);
                $this->db->join('medicos m', 'x.cod_medi = m.cod_medi');
                $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
                $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
                //$this->db->order_by('m.orden', 'asc');
                $query1 = $this->db->get();
                foreach ($query1->result_array() as $row) {
                    $cadena .= "<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
                }

            }

            echo $cadena;
        } else {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            $this->db->where('m.id_usuario', $id_usuario);
            //$this->db->order_by('m.orden', 'asc');
            $query = $this->db->get();
            $cadena .= "";
            foreach ($query->result_array() as $row) {
                $cadena .= "<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }

            echo $cadena;
        }

        $query->free_result();
    }
    
    public function consmedico($persona, $id_usuario, $login)
    {        
        if($persona == 20 || $persona == 21 )
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');             
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');   
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');                          
            $query = $this->db->get();            
            if($query->num_rows() > 0)
            {
                return $query->result_array();
            }else
            {
                $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
                $this->db->from('medicoxasistente x');             
                $this->db->where('x.login', $login);
                $this->db->join('medicos m', 'x.cod_medi = m.cod_medi');
                $this->db->join('administradoras a', 'm.id_admi = a.id_admi');   
                $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
                $query1 = $this->db->get();
                if($query1->num_rows() > 0)
                {
                    return $query->result_array();
                }else
                {
                    return $query = array();
                }
            }            
        }
        else
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');            
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');     
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            //$this->db->where('m.id_usuario', $id_usuario);                 
            $query = $this->db->get();            
            if($query->num_rows() > 0)
            {
                return $query->result_array();
            }else
            {
                return $query = array();
            }    
        }
        $query->free_result(); 
    }
    
    public function medicoselsub($persona, $id_usuario, $login, $codmedico)
    {        
        $cadena = '';
        if($persona == 20 || $persona == 21 )
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');             
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');   
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            $this->db->where('m.loginasistente', $login);     
            $this->db->where('m.cod_medi', $codmedico);          
            $query = $this->db->get();
            $cadena.="";
            foreach ($query->result_array() as $row)
            {
               $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }
            echo $cadena;
        }
        else
        {
            $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
            $this->db->from('medicos m');            
            $this->db->join('administradoras a', 'm.id_admi = a.id_admi');     
            $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
            $this->db->where('m.id_usuario', $id_usuario);  
            $this->db->where('m.cod_medi', $codmedico);                 
            $query = $this->db->get();
            $cadena.="";
            foreach ($query->result_array() as $row)
            {
               $cadena.="<option value='{$row['id_medi']}' cod_medi='{$row['cod_medi']}' cod_persona_atie='{$row['cod_persona_atie']}' id_admi='{$row['id_admi']}' idadministradora='{$row['id_administradora']}' nombre_admi='{$row['nombre_admi']}' verificacups='{$row['cups']}'>{$row['primer_nombre_medi']}  {$row['segundo_nombre_medi']} {$row['primer_apellido_medi']} {$row['segundo_apellido_medi']}</option>";
            }
            echo $cadena;     
        }
        $query->free_result(); 
    }
    
    public function consultacotodontogramav($tipo_docu, $identificacion)
    {
        $rcantcot = '';
        $this->db->select();
        $this->db->from('encabezado');
        $this->db->where('tipo_docu', $tipo_docu);                 
        $this->db->where('identificacion_paci', $identificacion);
        $this->db->where('ref_procesos', 'CT');
        $this->db->where('proceso_ref', 'OD');
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            $rcantcot   =   '1';
            return $rcantcot;
        }else
        {
            $rcantcot   =   '0';
            return $rcantcot;
        }       
        $query->free_result(); 
    }
    
    public function aboingreso1()
    {
        print_r($_POST['encabezado']);        
        //print_r($_POST['detalles']);
        //print_r($_POST['encabezadoct']);
        //print_r($_POST['detallesct']);
    }
    
    public function aboingreso()
    {
        if($this->input->post())
        {   
            //CONSECUTIVO DE ODONTOGRAMA
            $this->db->select();
            $this->db->from('consecutivos');
            $this->db->where('cod_consecutivo', 5);   
            $query1 = $this->db->get();
            $consrc = '';        
            foreach ($query1->result_array() as $row)
            {
                $consrc = $row['numero_consecutivo'];
                $consrc = $consrc + 1;
            }

            //CONSECUTIVO DE ODONTOGRAMA
            $this->db->select();
            $this->db->from('consecutivos');
            $this->db->where('cod_consecutivo', 8);   
            $query2 = $this->db->get();
            $consct = '';        
            foreach ($query2->result_array() as $row)
            {
                $consct = $row['numero_consecutivo'];
                $consct = $consct + 1;
            }            
            //if ($query->num_rows() > 0)
//            {        
                // RECORRER MATRIZ INFORMO QUE VIENE DE JSON
                $dat = $this->input->post('encabezado');         
                $dat = json_decode($dat);
                if (is_array($dat)) 
                {
                    foreach ($dat as $row => $val) 
                    {     
                        $identificacion_paci    =   trim($val->identificacion_paci);    
                        $tipo_docu              =   trim($val->tipo_docu);
                        $ref_procesos           =   trim($val->ref_procesos);
                        $valor_bruto            =   trim($val->valor_bruto);
                        $valor_total            =   trim($val->valor_total);
                        $documento_ref          =   $consct;
                        $fechaingreso           =   trim($val->fechaingreso);
                        $horaingreso            =   trim($val->horaingreso);
                        $proceso_ref            =   trim($val->proceso_ref);
                        $cod_medi               =   trim($val->cod_medi);                        
                        
                        // VERIFICA SESSION
                        $vlogin                 =   trim($val->histlogin);
                        $this->db->select();
                        $this->db->from('usuarios');
                        $this->db->where('login', $vlogin);   
                        $query = $this->db->get();
                        if ($query->num_rows() <= 0)
                        {
                            $datos['error'] =   'Falta login';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($identificacion_paci == '')
                        {
                            $datos['error'] =   'Falta la identificación del paciente';
                            $this->load->view('front_end/salidaerror', $datos); 
                        }else if($tipo_docu == '')
                        {
                            $datos['error'] =   'Falta el tipo de documento';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($ref_procesos == '')
                        {
                            $datos['error'] =   'Falta la referencia del proceso';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($valor_bruto == '')
                        {
                            $datos['error'] =   'Falta el valor bruto';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($valor_total == '')
                        {
                            $datos['error'] =   'Falta el valor total';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($documento_ref == '')
                        {
                            $datos['error'] =   'Falta el documento referencia encabezado abonos';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($fechaingreso == '')
                        {
                            $datos['error'] =   'Falta la fecha';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($horaingreso == '')
                        {
                            $datos['error'] =   'Falta la hora';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($proceso_ref == '')
                        {
                            $datos['error'] =   'Falta el proceso referencia';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else if($cod_medi == '')
                        {
                            $datos['error'] =   'Falta el código del médico';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else
                        {
                            // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: encabezado como recibo de caja
                            $coti = array(    
                            'ref_procesos'          =>  $ref_procesos,                        
                            'numero_docu'           =>  $consrc,
                            'identificacion_paci'   =>  $identificacion_paci,
                            'valor_bruto'           =>  $valor_bruto,
                            'valor_total'           =>  $valor_total,
                            'documento_ref'         =>  $documento_ref,
                            'fechaingreso'          =>  $fechaingreso,
                            'horaingreso'           =>  $horaingreso,
                            'login_ing'             =>  $vlogin,
                            'proceso_ref'           =>  $proceso_ref,
                            'cod_medi'              =>  $cod_medi,
                            'tipo_docu'             =>  $tipo_docu,                            
                            'estado'                =>  'ACTIVO'                                     
                            );
                            
                           // INSERTAR DATOS ENCABEZADO               
                            $this->db->insert('encabezado', $coti);  
                            
                            //$abocot = array(
//                            'total_abonos'          =>  $total_abonos
//                            );
//                            
//                            // ACTUALIZANDO DATOS ENCABEZADO               
//                            $this->db->where('numero_docu', $documento_ref);
//                            $this->db->where('ref_procesos', 'CT');
//                            $this->db->where('cod_medi', $cod_medi);
//                            $this->db->update('encabezado', $abocot); 
                        }
                    }
                    // MATRIZ CON LOS DETALLES DEL ABONO
                    $datmv = $this->input->post('detalles');         
                    $datmv = json_decode($datmv);
                    if (is_array($datmv)) 
                    {
                        foreach ($datmv as $key => $value) 
                        {            
                            $documento_ref              =   $consct;
                            $fechaingreso               =   trim($value->fechaingreso);
                            $horaingreso                =   trim($value->horaingreso);
                            $ref_procesos               =   trim($value->ref_procesos);                    
                            $proceso_ref                =   trim($value->proceso_ref);
                            $cod_medi                   =   trim($value->cod_medi);
                            $valor_abono                =   trim($value->valor_abono);
                            $tipo_abono                 =   trim($value->tipo_abono);
                            $efectivo                   =   trim($value->efectivo);
                            $cheque                     =   trim($value->cheque);
                            $codigo_banco               =   trim($value->codigo_banco);
                            $banco                      =   trim($value->banco);
                            $num_cheque                 =   trim($value->num_cheque);
                            $fec_consignacion           =   trim($value->fec_consignacion);
                            $tarjeta_debito             =   trim($value->tarjeta_debito);
                            $autorizacion               =   trim($value->autorizacion);
                            $tarjeta_credito            =   trim($value->tarjeta_credito);
                            $consignacion               =   trim($value->consignacion);
                            $vlogin                     =   trim($value->histlogin);
                            
                            if($documento_ref == '')
                            {
                                $datos['error'] =   'Falta el documento referencia detalles abono';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($fechaingreso == '')
                            {
                                $datos['error'] =   'Falta la fecha ';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($horaingreso == '')
                            {
                                $datos['error'] =   'Falta la hora ';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($ref_procesos == '')
                            {
                                $datos['error'] =   'Falta la referencia del proceso ';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($proceso_ref == '')
                            {
                                $datos['error'] =   'Falta el proceso de referencia';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($cod_medi == '')
                            {
                                $datos['error'] =   'Falta el codigo del médico';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($valor_abono == '')
                            {
                                $datos['error'] =   'Falta el valor del abono';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($tipo_abono == '')
                            {
                                $datos['error'] =   'Falta el tipo del abono';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else
                            {
                                // CREAR MATRIZ DE DATOS PARA INSERTAR EN TABLA : detalles                    
                                $deta = array(
                                'numero_docu'               =>  $consrc,
                                'documento_ref'             =>  $documento_ref,
                                'fechaingreso'              =>  $fechaingreso,                    
                                'horaingreso'               =>  $horaingreso,
                                'ref_procesos'              =>  $ref_procesos,
                                'proceso_ref'               =>  $proceso_ref,  
                                'cod_medi'                  =>  $cod_medi, 
                                'valor_abono'               =>  $valor_abono,
                                'tipo_abono'                =>  $tipo_abono,
                                'efectivo'                  =>  $efectivo,
                                'cheque'                    =>  $cheque,                                            
                                'codigo_banco'              =>  $codigo_banco,
                                'banco'                     =>  $banco,
                                'num_cheque'                =>  $num_cheque,
                                'fec_consignacion'          =>  $fec_consignacion,
                                'tarjeta_debito'            =>  $tarjeta_debito,
                                'autorizacion'              =>  $autorizacion,
                                'tarjeta_credito'           =>  $tarjeta_credito,
                                'consignacion'              =>  $consignacion,
                                'login_ing'                 =>  $vlogin,
                                'estado'                    =>  'ACTIVO'    
                                );
                                
                                // INSERTAR DATOS DETALLES ODONTOGRAMA
                                $this->db->insert('detalles', $deta); 
                            }        
                        }
                    }
                    // ACTUALIZANDO CONSECUTIVOS DE RECIBOS DE CAJA
                    $nconsrc = array(
                    'numero_consecutivo'    => $consrc
                    );
                    $this->db->where('cod_consecutivo', 5);
                    $this->db->update('consecutivos', $nconsrc); 
                    
                    
                }
                
                $datect = $this->input->post('encabezadoct');         
                $datect = json_decode($datect);
                if (is_array($datect)) 
                {
                    foreach ($datect as $regi => $vect) 
                    {     
                        $ref_procesos           =   trim($vect->ref_procesos);   
                        $tipo_docu              =   trim($vect->tipo_docu);
                        $identificacion_paci    =   trim($vect->identificacion_paci);
                        $valor_bruto            =   trim($vect->valor_bruto);
                        $valor_descuento        =   trim($vect->valor_descuento);
                        $valor_total            =   trim($vect->valor_total);
                        $documento_ref          =   trim($vect->documento_ref);
                        $fechaingreso           =   trim($vect->fechaingreso);
                        $horaingreso            =   trim($vect->horaingreso);
                        $proceso_ref            =   trim($vect->proceso_ref);
                        $cod_medi               =   trim($vect->cod_medi);
                        $histlogin              =   trim($vect->histlogin);
                        $total_abonos           =   trim($vect->total_abonos);
                        
                        if($identificacion_paci == '')
                        {
                            $datos['error'] =   'Falta la identificaci?';
                            $this->load->view('front_end/salidaerror', $datos);
                            
                        }else if($valor_bruto == '')
                        {
                            $datos['error'] =   'Falta el valor';
                            $this->load->view('front_end/salidaerror', $datos);
                        }else
                        {
                            // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: encabezado como recibo de caja
                            $ecoti = array(    
                            'ref_procesos'          =>  $ref_procesos,                        
                            'numero_docu'           =>  $consct,
                            'tipo_docu'             =>  $tipo_docu,
                            'identificacion_paci'   =>  $identificacion_paci,
                            'valor_bruto'           =>  $valor_bruto,
                            'valor_descuento'       =>  $valor_descuento,
                            'valor_total'           =>  $valor_total,
                            'documento_ref'         =>  $consct,
                            'fechaingreso'          =>  $fechaingreso,
                            'horaingreso'           =>  $horaingreso,
                            'login_ing'             =>  $histlogin,
                            'proceso_ref'           =>  $proceso_ref,
                            'cod_medi'              =>  $cod_medi, 
                            'total_abonos'          =>  $total_abonos,                           
                            'estado'                =>  'ACTIVO'                                     
                            );
                            
                           // INSERTAR DATOS ENCABEZADO               
                            $this->db->insert('encabezado', $ecoti);  
                        }
                    }
                    $datdct = $this->input->post('detallesct');         
                    $datdct = json_decode($datdct);
                    if (is_array($datdct)) 
                    {
                        foreach ($datdct as $dregi => $vdct) 
                        {     
                            $fechaingreso           =   trim($vdct->fechaingreso);
                            $horaingreso            =   trim($vdct->horaingreso);
                            $proceso_ref            =   trim($vdct->proceso_ref);
                            $cod_medi               =   trim($vdct->cod_medi);
                            $histlogin              =   trim($vdct->histlogin);
                            $cod_listap             =   trim($vdct->cod_listap);
                            $nombre_listap          =   trim($vdct->nombre_listap);
                            $valorlistap            =   trim($vdct->valorlistap);
                            
                            if($fechaingreso == '')
                            {
                                $datos['error'] =   'Falta la fecha';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else if($nombre_listap == '')
                            {
                                $datos['error'] =   'Falta el nombre a cobrar';
                                $this->load->view('front_end/salidaerror', $datos);
                            }else
                            {
                            $detad = array(
                                'numero_docu'               =>  $consct,    
                                'documento_ref'             =>  $consct,                            
                                'fechaingreso'              =>  $fechaingreso,                    
                                'horaingreso'               =>  $horaingreso,                                
                                'proceso_ref'               =>  $proceso_ref,  
                                'cod_medi'                  =>  $cod_medi,                                
                                'login_ing'                 =>  $histlogin,
                                'cod_listap'                =>  $cod_listap,
                                'nombre_listap'             =>  $nombre_listap,
                                'valorlistap'               =>  $valorlistap,
                                'estado'                    =>  'ACTIVO'    
                                );
                                
                                // INSERTAR DATOS DETALLES ODONTOGRAMA
                                $this->db->insert('detalles', $detad); 
                            }
                        }
                    } 
                    // ACTUALIZANDO CONSECUTIVOS DE COTIZACIONES
                    $nconsct = array(
                    'numero_consecutivo'    => $consct
                    );
                    $this->db->where('cod_consecutivo', 8);
                    $this->db->update('consecutivos', $nconsct);   
                } 
                
                $datos['numero_docu']       =   $ecoti['numero_docu'];                
                $datos['identificacion']    =   $ecoti['identificacion_paci'];
                $datos['tipo_docu']         =   $ecoti['tipo_docu'];
                $datos['ref_procesos']      =   $ecoti['ref_procesos'];
                return $datos; 
                
                
            //}
            //else
//            {
//                redirect(base_url().'usuarios/logout', 301);	 
//            }
        $query1->free_result();
        $query2->free_result();
        }                            
        else
        {   
            redirect(base_url().'usuarios/logout', 301);	 
        }
        
    }     
    
    public function consultaprestador()
    {
        $this->db->select();
        $this->db->from('global');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consultarc($ref_procesos, $numero_docu, $documento_ref)
    {
        $this->db->select();
        $this->db->from('encabezado');
        $this->db->where('ref_procesos', $ref_procesos); 
        $this->db->where('numero_docu', $numero_docu)  ;     
        $this->db->where('documento_ref', $documento_ref);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
           
    public function consultapaciente($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes'); 
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }  
    
    public function consultamedico($cod_medi)
    {
        $this->db->select();
        $this->db->from('medicos');  
        $this->db->where('cod_medi', $cod_medi);      
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function datpac($tipo_docu, $identificacion)
    {
        $this->db->select();
        $this->db->from('pacientes');  
        $this->db->where('tipo_docu', $tipo_docu);      
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function regconsulta($numconsulta, $cotizacion)
    {
        $this->db->select();
        $this->db->from('consulta_medica');  
        $this->db->where('nconsulta', $numconsulta);      
        $this->db->where('cotizacion', $cotizacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function cupsxconsulta($numconsulta, $cotizacion)
    {
        $this->db->select();
        $this->db->from('consulta_medicaxtratamiento');  
        $this->db->where('nconsulta', $numconsulta);      
        $this->db->where('cotizacion', $cotizacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function modidentificacion($vtipo_docu, $videntificacion, $idmedico)
    {
        $this->db->select();
        $this->db->from('pacientes');
        $this->db->where('tipo_docu', $vtipo_docu);
        $this->db->where('identificacion', $videntificacion);
        $this->db->where_not_in('id_paciente', $idmedico);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            echo '1';
        }else
        {
            echo '0';
        }
        $query->free_result();       
    } 
    
    public function consuldetallesabo($numero_docu, $documento_ref, $ref_procesos)
    {
        $this->db->select();
        $this->db->from('detalles');  
        $this->db->where('numero_docu', $numero_docu);      
        $this->db->where('documento_ref', $documento_ref);
        $this->db->where('ref_procesos', $ref_procesos);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }  
    
    public function codmedico($codmedico)
    {
        $cadena = '';
        $this->db->select();
        $this->db->from('medicos');
        $this->db->where('cod_medi', $codmedico);              
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
           $cadena =    $row['primer_nombre_medi'].' '.$row['segundo_nombre_medi'].' '.$row['primer_apellido_medi'].' '.$row['segundo_apellido_medi'];
        }
        echo $cadena; 
        
        $query->free_result();  
    }  
    
    public function consulmedico($codmedico)
    {
        $this->db->select('m.*, a.nombre_admi, a.id_administradora, p.cups');
        $this->db->join('administradoras a', 'm.id_admi = a.id_admi');   
        $this->db->join('persona_atiende p', 'p.cod_persona_atie = m.cod_persona_atie');
        $this->db->from('medicos m');
        $this->db->where('cod_medi', $codmedico);              
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function eliminarabono($refprocesos, $numerodocu, $documentoref, $valorabono, $histlogin)
    {
        //if(!empty($this->session_id))  
//		{
            if($this->input->post())
            {
                $loginmod         =  $histlogin; 
                $this->db->select();
                $this->db->from('usuarios');
                $this->db->where('login', $loginmod);   
                $query = $this->db->get();
                if ($query->num_rows() <= 0)
                {
                    $datos['error'] =   'Falta login';
                    $this->load->view('front_end/salidaerror', $datos); 
                }else
                {
                    // INACTIVO EN ENCABEZADO
                    $procesoabono = array(
                    'estado'    => 'INACTIVO'
                    );
                    
                    $this->db->where('ref_procesos', $refprocesos);
                    $this->db->where('numero_docu', $numerodocu);
                    $this->db->where('documento_ref', $documentoref);
                    $this->db->update('encabezado', $procesoabono);
                    
                    // INACTIVO EN DETALLES
                    $procesodetaabono = array(
                    'estado'    => 'INACTIVO'
                    );
                    
                    $this->db->where('ref_procesos', $refprocesos);
                    $this->db->where('numero_docu', $numerodocu);
                    $this->db->where('documento_ref', $documentoref);
                    $this->db->update('detalles', $procesodetaabono);
                    
                    // RESTANDO EL VALOR DEL ABONO A LA COTIZACION
                    $cadena = '';
                    $this->db->select();
                    $this->db->from('encabezado');
                    $this->db->where('ref_procesos', 'CT');              
                    $this->db->where('numero_docu', $documentoref);
                    $query = $this->db->get();        
                    foreach ($query->result_array() as $row)
                    {
                        $cadena =    $row['total_abonos'] - $valorabono;
                        // VALOR ABONO 
                        $vabono = array(
                        'total_abonos'    => $cadena 
                        );
                        
                        $this->db->where('numero_docu', $documentoref);
                        $this->db->where('ref_procesos', 'CT');
                        $this->db->update('encabezado', $vabono); 
                    }
                    $query->free_result();
                    $datos['registro']  =   'Abono eliminado';        
                    $this->load->view('front_end/documentook', $datos);     
                }                
            }else
            {
                redirect(base_url().'usuarios/avisosesion', 301);	 
            }
        //}else
//        {
//            redirect(base_url().'usuarios/avisosesion', 301);	 
//        }
    }
    
    public function imc($imc)
    {
        
        $cadena = '';
        $this->db->select();
        $this->db->from('indicemasacorporal');
        $this->db->where('valorminimo <=', $imc);
        $query = $this->db->get();        
        foreach ($query->result_array() as $row)
        {
            $cadena =    $row['puntodecorte'];
        }
        echo $cadena;
        $query->free_result();
    }                                                                                                                                                                
    
    public function contexturac($contexturac, $sexo)
    {
        if($sexo == 'M')
        {
            $cadenac = '';
            $this->db->select();
            $this->db->from('indicecontexturacorporal');
            $this->db->where('hombre_max <', $contexturac);
            $query = $this->db->get();        
            foreach ($query->result_array() as $row)
            {
                $cadenac =    $row['contextura'];
            }
            echo $cadenac;
            $query->free_result();    
        }
        if($sexo == 'F')
        {
            $cadenac = '';
            $this->db->select();
            $this->db->from('indicecontexturacorporal');
            $this->db->where('mujeres_max < ', $contexturac);
            $query = $this->db->get();        
            foreach ($query->result_array() as $row)
            {
                $cadenac =    $row['contextura'];
            }
            echo $cadenac;
            $query->free_result();    
        }
        
        
    }
    
    public function porcentajegrasa($sexo, $diametromu, $caderas, $adbomen, $altura, $peso)
    {
        if($sexo == 'F')
        {
            $constante_a = '';
            $this->db->select();
            $this->db->from('indicecaderas');
            $this->db->where('centimetros', $caderas);
            $query = $this->db->get();        
            foreach ($query->result_array() as $row)
            {
                $constante_a =    $row['constante_a'];
            }
            
            $constante_b = '';
            $this->db->select();
            $this->db->from('indiceabdomen');
            $this->db->where('centimetros', $adbomen);
            $query1 = $this->db->get();        
            foreach ($query1->result_array() as $row)
            {
                $constante_b =    $row['constante_b'];
            }
            
            $constante_c = '';
            $this->db->select();
            $this->db->from('indicealtura');
            $this->db->where('centimetros', $altura);
            $query2 = $this->db->get();        
            foreach ($query2->result_array() as $row)
            {
                $constante_c =    $row['constante_c'];
            }
            
            $porcentajeg        =   '';
            echo $porcentajeg   =   ($constante_a + $constante_b) - $constante_c ;
        }
        
        if($sexo == 'M')
        {
            $cintumune  =   $adbomen - $diametromu;
            $rpeso      =   $peso%2;
            if($rpeso == '0')
            {
                $peso   =   $peso - 1;    
            }
            
            
            $porcentajeg = '';
            $this->db->select();
            $this->db->from('indicegrasacorporal');
            $this->db->where('peso', $peso);
            $this->db->where('cinturamuneca', $cintumune);
            $query2 = $this->db->get();        
            foreach ($query2->result_array() as $row)
            {
                $porcentajeg =    $row['resultante'];
            }
            echo $porcentajeg;
        }
    }
    
    public function cielineacie()    
    {
        $cadena = '';
        $this->db->distinct();
        $this->db->select();
        $this->db->from('cie10_linea');
        $query = $this->db->get();
        $cadena.="<option value=''>Seleccione . . .</option>";
        foreach ($query->result_array() as $row)
        {
           $cadena.="<option value='{$row['cod_cielinea']}'>{$row['cod_cielinea']} - {$row['nombre_cielinea']}</option>";
        }
        echo $cadena; 
        $query->free_result(); 
    }

    public function con_paciente($id_paciente)
    {
        $this->db->select('p.*, td.nombre_tipo_docu, sx.nombre_sexo, pa.nombre_pais, de.nombre_depa, mu.nombre_muni,  
        ec.nombre_estado_civi, zr.nombre_zona_resi, tu.nombre_tipo_usua');
        $this->db->from('pacientes p');
        $this->db->join('tipo_documento td', 'td.tipo_docu = p.tipo_docu');  
        $this->db->join('sexo sx', 'sx.sigla_sexo = p.sigla_sexo');
        $this->db->join('paises pa', 'pa.cod_pais = p.cod_pais');
        $this->db->join('departamento de', 'de.cod_pais = p.cod_pais AND de.id_depa = p.id_depa');
        $this->db->join('municipio mu', 'mu.cod_pais = p.cod_pais AND mu.id_depa = p.id_depa AND mu.id_muni = p.id_muni');
        $this->db->join('estadocivil ec', 'ec.cod_estado_civi = p.cod_estado_civi');
        $this->db->join('zona_residencia zr', 'zr.cod_zona_resi = p.cod_zona_resi');
        $this->db->join('tipo_usuario tu', 'tu.cod_tipo_usua = p.cod_tipo_usua');
        $this->db->where('p.id_paciente', $id_paciente);      
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }
    
    public function cipaciente($id_paciente)
    {
        $this->db->select('p.*, td.nombre_tipo_docu, sx.nombre_sexo, pa.nombre_pais, de.nombre_depa, mu.nombre_muni,  
        ec.nombre_estado_civi, zr.nombre_zona_resi, tu.nombre_tipo_usua, co.nombre_admi');
        $this->db->from('pacientes p');
        $this->db->join('tipo_documento td', 'td.tipo_docu = p.tipo_docu');  
        $this->db->join('sexo sx', 'sx.sigla_sexo = p.sigla_sexo');
        $this->db->join('paises pa', 'pa.cod_pais = p.cod_pais');
        $this->db->join('departamento de', 'de.cod_pais = p.cod_pais AND de.id_depa = p.id_depa');
        $this->db->join('municipio mu', 'mu.cod_pais = p.cod_pais AND mu.id_depa = p.id_depa AND mu.id_muni = p.id_muni');
        $this->db->join('estadocivil ec', 'ec.cod_estado_civi = p.cod_estado_civi');
        $this->db->join('zona_residencia zr', 'zr.cod_zona_resi = p.cod_zona_resi');
        $this->db->join('tipo_usuario tu', 'tu.cod_tipo_usua = p.cod_tipo_usua');
        $this->db->join('contratistas co', 'co.id_contratistas = p.id_admi');
        $this->db->where('p.id_paciente', $id_paciente);      
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }

    public function ciantecedentes($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes_ant');  
        $this->db->where('id_paciente', $id_paciente);      
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }
    
    public function ciexamen($id_paciente, $n_conexamen) 
    {

        $this->db->select('e.*, co.nombre_cons');
        $this->db->from('pacientes_exa e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons');    
        $this->db->where('e.id_paciente', $id_paciente);
        $this->db->where('e.cons_examen', $n_conexamen);  
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }
    
    
    public function ciexamencie($id_paciente, $n_conexamen) {
        $this->db->select('c.*, cie.nombre_cie, cd.nombre_causa_dia, fi.nombre_fina, co.nombre_cons, ti.nombre_tipo, cier.nombre_cie as nombre_cier, ciers.nombre_cie as nombre_ciers, cierr.nombre_cie as nombre_cierr');
        $this->db->from('ciecups c');
        $this->db->join('cie10 cie', 'cie.cod_cie = c.cod_cie ');
        $this->db->join('cie10 cier', 'cier.cod_cie = c.cod_cier', 'left outer');
        $this->db->join('cie10 ciers', 'ciers.cod_cie = c.cod_ciers', 'left outer');
        $this->db->join('cie10 cierr', 'cierr.cod_cie = c.cod_cierr', 'left outer');
        $this->db->join('causa_diagnostico cd', 'cd.cod_causa_dia = c.cod_causa_dia');
        $this->db->join('finalidad  fi', 'fi.cod_fina = c.cod_fina_cie AND fi.cod_tipo_fina = "1" ');
        $this->db->join('consulta co', 'co.cod_cons = c.cod_cons');
        $this->db->join('tipo ti', 'ti.cod_tipo = c.cod_tipo');
        $this->db->where('c.id_paciente', $id_paciente);
        $this->db->where('c.cons_examen', $n_conexamen);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }
        $query->free_result();
    }

    public function cicups($id_paciente, $n_conexamen) {
        $this->db->select('c.*, cu.nombre_cups, ac.nombre_actoq, fi.nombre_fina, am.nombre_ambi');
        $this->db->from('ciecups c');
        $this->db->join('cups cu', 'cu.cod_cups = c.cod_cups');
        $this->db->join('actoquirurgico ac', 'ac.cod_actoq = c.cod_actoq', 'left outer');
        $this->db->join('finalidad fi', 'fi.id_finalidad = c.id_finalidad and fi.cod_tipo_fina = "2"');
        $this->db->join('ambito am', 'am.cod_ambi = c.cod_ambi');
        $this->db->where('c.id_paciente', $id_paciente);
        $this->db->where('cons_examen', $n_conexamen);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }
    
    public function ingresodiagnostico($descripcionnuevocie)
    {
        if($this->input->post())
        {
            // CONSULTA CONSECUTIVO DE CONVENCIONES
            $this->db->select();
            $this->db->from('consecutivos');
            $this->db->where('cod_consecutivo', 14);   
            $query = $this->db->get();
            $consdia = '';
            $consecutivodia =   '';        
            foreach ($query->result_array() as $row)
            {
                $consdia        =   $row['numero_consecutivo'];
                $consdia        =   $consdia + 1;
                $consecutivodia =   $consdia;
                $consdia        =   'xxx'.$consdia;
            }
            
            $ndia = array(                    
            'cod_cie'               =>  $consdia,
            'nombre_cie'            =>  $descripcionnuevocie,
            'cod_cielinea'          =>  'xxx - xxx',
            'cod_ciesublinea'       =>  'xxx',
            'sexo'                  =>  'A',
            'limite_inferior'       =>  '0',
            'limite_superior'       =>  '0'
            );
                    
            // INSERTAR DATOS ENCABEZADO               
            $this->db->insert('cie10', $ndia);  
            
            // ACTUALIZANDO CONSECUTIVOS DE PROCEDIMIENTOS
            $nndia = array(
            'numero_consecutivo'    => $consecutivodia
            );
            $this->db->where('cod_consecutivo', 14);
            $this->db->update('consecutivos', $nndia); 
            
            $this->db->select();
            $this->db->from('cie10');        
            $this->db->where('cod_cie', $consdia);
            $query2 = $this->db->get();
            if($query2->num_rows() > 0)
            {
                return $query2->result_array();
            }else
            {
                return false;
            }
            $query->free_result();
            $query2->free_result();    
        }
    }
    
    public function ingresotratamiento($descripcionnuevocups)
    {
        if($this->input->post())
        {
            // CONSULTA CONSECUTIVO DE CONVENCIONES
            $this->db->select();
            $this->db->from('consecutivos');
            $this->db->where('cod_consecutivo', 15);   
            $query = $this->db->get();
            $conscups = '';
            $consecutivocups =   '';        
            foreach ($query->result_array() as $row)
            {
                $conscups        =   $row['numero_consecutivo'];
                $conscups        =   $conscups + 1;
                $consecutivocups =   $conscups;
                $conscups        =   'xxx'.$conscups;
            }
            
            
            $matrizcups = array(                    
            'cod_cups'              =>  $conscups,
            'nombre_cups'           =>  $descripcionnuevocups,
            'cod_cupslinea'         =>  'xx',
            'cod_cupsublinea'       =>  'xxxx',
            'cod_cupsgrupo'         =>  'xxxxxx'
            );
            
                
            // INSERTAR DATOS ENCABEZADO               
            $this->db->insert('cups', $matrizcups);  
            
            // ACTUALIZANDO CONSECUTIVOS DE PROCEDIMIENTOS
            $nncups = array(
            'numero_consecutivo'    => $consecutivocups
            );
            $this->db->where('cod_consecutivo', 15);
            $this->db->update('consecutivos', $nncups); 
            
            $this->db->select();
            $this->db->from('cups');        
            $this->db->where('cod_cups', $conscups);
            $query2 = $this->db->get();
            if($query2->num_rows() > 0)
            {
                return $query2->result_array();
            }else
            {
                return false;
            }
            $query->free_result();
            $query2->free_result();    
        }
    }
    
    public function ingresocorporal1()
    {
        ///print_r($_POST['corporal']);    
    }
    
    public function ingresocorporal()
    {
        if($this->input->post())
        {
            // CORPORAL RECORRER MATRIZ INFORMO QUE VIENE DE JSON
            $cor = $this->input->post('corporal');         
            $cor = json_decode($cor);
            if (is_array($cor))
            {
                foreach ($cor as $corow => $vcor) 
                { 
                    //CONSECUTIVO HISTORIA PACIENTE
                    $this->db->select();
                    $this->db->from('consecutivos');
                    $this->db->where('cod_consecutivo', 12);   
                    $query2 = $this->db->get();
                    $conscorpo = '';        
                    foreach ($query2->result_array() as $row)
                    {
                        $conscorpo = $row['numero_consecutivo'];
                        $conscorpo = $conscorpo + 1;
                    }
                    
                    $tipo_docu                          =   trim($vcor->tipo_docu);
                    $identificacion                     =   trim($vcor->identificacion);
                    $cons_historiac                     =   $conscorpo;
                    $tipo_historia                      =   trim($vcor->tipo_historia);
                    $motivo_corporal                    =   trim($vcor->motivo_corporal);
                    $padecimientof1                     =   trim($vcor->padecimientof1);
                    $familiar1                          =   trim($vcor->familiar1);
                    $padecimientof2                     =   trim($vcor->padecimientof2);
                    $familiar2                          =   trim($vcor->familiar2);
                    $padecimientof3                     =   trim($vcor->padecimientof3);
                    $familiar3                          =   trim($vcor->familiar3);
                    $pat_convulsiones                   =   trim($vcor->pat_convulsiones);
                    $pat_convulsiones_desc              =   trim($vcor->pat_convulsiones_desc);
                    $pat_desmayos                       =   trim($vcor->pat_desmayos);
                    $pat_desmayos_desc                  =   trim($vcor->pat_desmayos_desc);
                    $pat_amigdalitis                    =   trim($vcor->pat_amigdalitis);
                    $pat_amigdalitis_desc               =   trim($vcor->pat_amigdalitis_desc);
                    $pat_alergias_nasales               =   trim($vcor->pat_alergias_nasales);
                    $pat_alergias_nasales_desc          =   trim($vcor->pat_alergias_nasales_desc);
                    $pat_asma                           =   trim($vcor->pat_asma);
                    $pat_asma_desc                      =   trim($vcor->pat_asma_desc);
                    $pat_bronquitis                     =   trim($vcor->pat_bronquitis);
                    $pat_bronquitis_desc                =   trim($vcor->pat_bronquitis_desc);
                    $pat_dolores_precordiales           =   trim($vcor->pat_dolores_precordiales);
                    $pat_dolores_precordiales_desc      =   trim($vcor->pat_dolores_precordiales_desc);
                    $pat_infartos                       =   trim($vcor->pat_infartos);
                    $pat_infartos_desc                  =   trim($vcor->pat_infartos_desc);
                    $pat_diabetes                       =   trim($vcor->pat_diabetes);
                    $pat_diabetes_desc                  =   trim($vcor->pat_diabetes_desc);
                    $pat_hipertiroidismo                =   trim($vcor->pat_hipertiroidismo);
                    $pat_hipertiroidismo_desc           =   trim($vcor->pat_hipertiroidismo_desc);
                    $pat_hipotiroidismo                 =   trim($vcor->pat_hipotiroidismo);
                    $pat_hipotiroidismo_desc            =   trim($vcor->pat_hipotiroidismo_desc);
                    $pat_hepatitis                      =   trim($vcor->pat_hepatitis);
                    $pat_hepatitis_desc                 =   trim($vcor->pat_hepatitis_desc);
                    $pat_pancreatitis                   =   trim($vcor->pat_pancreatitis);
                    $pat_pancreatitis_desc              =   trim($vcor->pat_pancreatitis_desc);
                    $pat_infecciones_urinarios          =   trim($vcor->pat_infecciones_urinarios);
                    $pat_infecciones_urinarios_desc     =   trim($vcor->pat_infecciones_urinarios_desc);
                    $pat_gastritis                      =   trim($vcor->pat_gastritis);
                    $pat_gastritis_desc                 =   trim($vcor->pat_gastritis_desc);
                    $pat_ulcera_gastrica                =   trim($vcor->pat_ulcera_gastrica);
                    $pat_ulcera_gastrica_desc           =   trim($vcor->pat_ulcera_gastrica_desc);
                    $pat_calculos_renales               =   trim($vcor->pat_calculos_renales);
                    $pat_calculos_renales_desc          =   trim($vcor->pat_calculos_renales_desc);
                    $pat_artritis                       =   trim($vcor->pat_artritis);
                    $pat_artritis_desc                  =   trim($vcor->pat_artritis_desc);
                    $pat_dermatitis                     =   trim($vcor->pat_dermatitis);
                    $pat_dermatitis_desc                =   trim($vcor->pat_dermatitis_desc);
                    $pat_furunculosis                   =   trim($vcor->pat_furunculosis);
                    $pat_furunculosis_desc              =   trim($vcor->pat_furunculosis_desc);
                    $pat_ansiedad                       =   trim($vcor->pat_ansiedad);
                    $pat_ansiedad_desc                  =   trim($vcor->pat_ansiedad_desc);
                    $pat_transtornos_psiquiatricos      =   trim($vcor->pat_transtornos_psiquiatricos);
                    $pat_transtornos_psiquiatricos_desc =   trim($vcor->pat_transtornos_psiquiatricos_desc);
                    $pat_enfermedad_colageno            =   trim($vcor->pat_enfermedad_colageno);
                    $pat_enfermedad_colageno_desc       =   trim($vcor->pat_enfermedad_colageno_desc);
                    $pat_enfermedades_vasculares        =   trim($vcor->pat_enfermedades_vasculares);
                    $pat_enfermedades_vasculares_desc   =   trim($vcor->pat_enfermedades_vasculares_desc);
                    $antecedentesquirurgicos            =   trim($vcor->antecedentesquirurgicos);
                    $fuma                               =   trim($vcor->fuma);
                    $antecedentestoxicoalergicos        =   trim($vcor->antecedentestoxicoalergicos);
                    $antecedentesfarmacologicos         =   trim($vcor->antecedentesfarmacologicos);
                    $gestacion                          =   trim($vcor->gestacion);
                    $partos                             =   trim($vcor->partos);
                    $aborto                             =   trim($vcor->aborto);
                    $cesarea                            =   trim($vcor->cesarea);
                    $vivos                              =   trim($vcor->vivos);
                    $cliclomenstrual                    =   trim($vcor->cliclomenstrual);
                    $cadacliclomenstrual                =   trim($vcor->cadacliclomenstrual);
                    $frecuenciaciclo                    =   trim($vcor->frecuenciaciclo);
                    $fechafup                           =   trim($vcor->fechafup);
                    $fechafur                           =   trim($vcor->fechafur);
                    $observacionesgineco                =   trim($vcor->observacionesgineco);
                    $habitosnuticionales                =   trim($vcor->habitosnuticionales);
                    $habitosdesueno                     =   trim($vcor->habitosdesueno);
                    $actividadfisica                    =   trim($vcor->actividadfisica);
                    $pielyfaneras                       =   trim($vcor->pielyfaneras);                    
                    $neurosensorial                     =   trim($vcor->neurosensorial);
                    $endocrino                          =   trim($vcor->endocrino);
                    $linfatico                          =   trim($vcor->linfatico);
                    $hematopoyetico                     =   trim($vcor->hematopoyetico);
                    $digestivo                          =   trim($vcor->digestivo);
                    $cardiovascular                     =   trim($vcor->cardiovascular);
                    $respiratorio                       =   trim($vcor->respiratorio);
                    $genitourinario                     =   trim($vcor->genitourinario);
                    $locomotor                          =   trim($vcor->locomotor);
                    $tneurosensorial                    =   trim($vcor->tneurosensorial);
                    $tpielyfaneras                      =   trim($vcor->tpielyfaneras);
                    $tendocrino                         =   trim($vcor->tendocrino);
                    $tlinfatico                         =   trim($vcor->tlinfatico);
                    $thematopoyetico                    =   trim($vcor->thematopoyetico);
                    $tdigestivo                         =   trim($vcor->tdigestivo);
                    $tcardiovascular                    =   trim($vcor->tcardiovascular);
                    $trespiratorio                      =   trim($vcor->trespiratorio);
                    $tgenitourinario                    =   trim($vcor->tgenitourinario);
                    $tlocomotor                         =   trim($vcor->tlocomotor);
                    $otrosrevisionxsistema              =   trim($vcor->otrosrevisionxsistema);
                    $fechacorporal                      =   trim($vcor->fechacorporal);
                    $horacorporal                       =   trim($vcor->horacorporal);
                    $login_ing                          =   trim($vcor->login_ing);
                    $nconsulta                          =   trim($vcor->nconsulta);
                    $cod_medi                           =   trim($vcor->cod_medi);
                    $cod_consultorio                    =   trim($vcor->cod_consultorio);
                    $pat_otros                          =   trim($vcor->pat_otros);
                    
                    
                    
                    // MATRIZ CORPORAL PRIMER PARTE
                    $datacorporal = array(                        
                    'tipo_docu'                             =>  $tipo_docu,
                    'identificacion'                        =>  $identificacion,
                    'cons_historia'                         =>  $cons_historiac,
                    'tipo_historia'                         =>  $tipo_historia,
                    'motivo_corporal'                       =>  $motivo_corporal,
                    'padecimientof1'                        =>  $padecimientof1,
                    'familiar1'                             =>  $familiar1,
                    'padecimientof2'                        =>  $padecimientof2,
                    'familiar2'                             =>  $familiar2,
                    'padecimientof3'                        =>  $padecimientof3,
                    'familiar3'                             =>  $familiar3,                        
                    'gestacion'                             =>  $gestacion,
                    'partos'                                =>  $partos,
                    'aborto'                                =>  $aborto,
                    'cesarea'                               =>  $cesarea,
                    'vivos'                                 =>  $vivos,
                    'cliclomenstrual'                       =>  $cliclomenstrual,
                    'cadacliclomenstrual'                   =>  $cadacliclomenstrual,
                    'frecuenciaciclo'                       =>  $frecuenciaciclo,
                    'fechafup'                              =>  $fechafup,
                    'fechafur'                              =>  $fechafur,
                    'observacionesgineco'                   =>  $observacionesgineco,
                    'fechacorporal'                         =>  $fechacorporal,
                    'horacorporal'                          =>  $horacorporal,
                    'login_ing'                             =>  $login_ing,
                    'nconsulta'                             =>  $nconsulta,
                    'cod_medi'                              =>  $cod_medi,
                    'cod_consultorio'                       =>  $cod_consultorio
                    );
                    $this->db->insert('historiaclinica', $datacorporal);
                    
                    // MATRIZ CORPORAL PRIMER PARTE
                    $datacorporals = array(
                        'tipo_docu'                             =>  $tipo_docu,
                        'identificacion'                        =>  $identificacion,
                        'cons_historia'                         =>  $cons_historiac,
                        'tipo_historia'                         =>  $tipo_historia,
                        'antecedentesquirurgicos'               =>  $antecedentesquirurgicos,
                        'antecedentestoxicoalergicos'           =>  $antecedentestoxicoalergicos,
                        'antecedentesfarmacologicos'            =>  $antecedentesfarmacologicos,                            
                        'habitosnuticionales'                   =>  $habitosnuticionales,
                        'habitosdesueno'                        =>  $habitosdesueno,
                        'actividadfisica'                       =>  $actividadfisica,
                        'fuma'                                  =>  $fuma                    
                    );                        
                    $this->db->insert('hist_cli_ah ', $datacorporals);                        
                        
                    $pgrupo = array( 
                        'tipo_docu'                             =>  $tipo_docu,
                        'identificacion'                        =>  $identificacion,
                        'cons_historia'                         =>  $cons_historiac,
                        'tipo_historia'                         =>  $tipo_historia,                            
                        'pat_convulsiones'                      =>  $pat_convulsiones,                            
                        'pat_desmayos'                          =>  $pat_desmayos,                            
                        'pat_amigdalitis'                       =>  $pat_amigdalitis,                            
                        'pat_alergias_nasales'                  =>  $pat_alergias_nasales,                            
                        'pat_asma'                              =>  $pat_asma,                            
                        'pat_bronquitis'                        =>  $pat_bronquitis,                            
                        'pat_dolores_precordiales'              =>  $pat_dolores_precordiales,                            
                        'pat_infartos'                          =>  $pat_infartos,                            
                        'pat_convulsiones_desc'                 =>  $pat_convulsiones_desc,
                        'pat_desmayos_desc'                     =>  $pat_desmayos_desc,
                        'pat_amigdalitis_desc'                  =>  $pat_amigdalitis_desc,
                        'pat_alergias_nasales_desc'             =>  $pat_alergias_nasales_desc,
                        'pat_asma_desc'                         =>  $pat_asma_desc,
                        'pat_bronquitis_desc'                   =>  $pat_bronquitis_desc, 
                        'pat_dolores_precordiales_desc'         =>  $pat_dolores_precordiales_desc,
                        'pat_infartos_desc'                     =>  $pat_infartos_desc                                                 
                    );
                    $this->db->insert('histo_p_pato', $pgrupo);
                    
                    $sgrupo = array( 
                        'tipo_docu'                             =>  $tipo_docu,
                        'identificacion'                        =>  $identificacion,
                        'cons_historia'                         =>  $cons_historiac,
                        'tipo_historia'                         =>  $tipo_historia,
                        'pat_diabetes_desc'                     =>  $pat_diabetes_desc,      
                        'pat_hipertiroidismo_desc'              =>  $pat_hipertiroidismo_desc,
                        'pat_hipotiroidismo_desc'               =>  $pat_hipotiroidismo_desc, 
                        'pat_hepatitis_desc'                    =>  $pat_hepatitis_desc,         
                        'pat_pancreatitis_desc'                 =>  $pat_pancreatitis_desc,       
                        'pat_infecciones_urinarios_desc'        =>  $pat_infecciones_urinarios_desc,
                        'pat_gastritis_desc'                    =>  $pat_gastritis_desc,     
                        'pat_ulcera_gastrica_desc'              =>  $pat_ulcera_gastrica_desc,                            
                        'pat_diabetes'                          =>  $pat_diabetes,                            
                        'pat_hipertiroidismo'                   =>  $pat_hipertiroidismo,                                                        
                        'pat_hipotiroidismo'                    =>  $pat_hipotiroidismo,                            
                        'pat_hepatitis'                         =>  $pat_hepatitis,                            
                        'pat_pancreatitis'                      =>  $pat_pancreatitis,                            
                        'pat_infecciones_urinarios'             =>  $pat_infecciones_urinarios,                            
                        'pat_gastritis'                         =>  $pat_gastritis,                            
                        'pat_ulcera_gastrica'                   =>  $pat_ulcera_gastrica                                                                                                                                        
                    );                        
                    
                    $this->db->insert('histo_s_pato', $sgrupo);
                      
                    $tgrupo = array( 
                        'tipo_docu'                             =>  $tipo_docu,
                        'identificacion'                        =>  $identificacion,
                        'cons_historia'                         =>  $cons_historiac,
                        'tipo_historia'                         =>  $tipo_historia,
                        'pat_calculos_renales_desc'             =>  $pat_calculos_renales_desc,     
                        'pat_artritis_desc'                     =>  $pat_artritis_desc,
                        'pat_dermatitis_desc'                   =>  $pat_dermatitis_desc,
                        'pat_furunculosis_desc'                 =>  $pat_furunculosis_desc,
                        'pat_ansiedad_desc'                     =>  $pat_ansiedad_desc,    
                        'pat_transtornos_psiquiatricos_desc'    =>  $pat_transtornos_psiquiatricos_desc,
                        'pat_enfermedad_colageno_desc'          =>  $pat_enfermedad_colageno_desc,
                        'pat_enfermedades_vasculares_desc'      =>  $pat_enfermedades_vasculares_desc,
                        'pat_otros'                             =>  $pat_otros,
                        'pat_calculos_renales'                  =>  $pat_calculos_renales,
                        'pat_artritis'                          =>  $pat_artritis,
                        'pat_dermatitis'                        =>  $pat_dermatitis,
                        'pat_furunculosis'                      =>  $pat_furunculosis,
                        'pat_ansiedad'                          =>  $pat_ansiedad,
                        'pat_transtornos_psiquiatricos'         =>  $pat_transtornos_psiquiatricos,
                        'pat_enfermedad_colageno'               =>  $pat_enfermedad_colageno,
                        'pat_enfermedades_vasculares'           =>  $pat_enfermedades_vasculares                                                                                                        
                    );
                    
                    $this->db->insert('histo_t_pato ', $tgrupo);
                    
                    $trevxsistema   =   array(
                        'tipo_docu'                             =>  $tipo_docu,
                        'identificacion'                        =>  $identificacion,
                        'cons_historia'                         =>  $cons_historiac,
                        'tipo_historia'                         =>  $tipo_historia,
                        'tpielyfaneras'                         =>  $tpielyfaneras,    
                        'tneurosensorial'                       =>  $tneurosensorial,    
                        'tendocrino'                            =>  $tendocrino,    
                        'tlinfatico'                            =>  $tlinfatico,    
                        'thematopoyetico'                       =>  $thematopoyetico,    
                        'tdigestivo'                            =>  $tdigestivo,    
                        'tcardiovascular'                       =>  $tcardiovascular,    
                        'trespiratorio'                         =>  $trespiratorio,                            
                        'pielyfaneras'                          =>  $pielyfaneras,                                                    
                        'neurosensorial'                        =>  $neurosensorial,                                                    
                        'endocrino'                             =>  $endocrino,
                        'linfatico'                             =>  $linfatico,                                                    
                        'hematopoyetico'                        =>  $hematopoyetico,                                                    
                        'digestivo'                             =>  $digestivo,
                        'cardiovascular'                        =>  $cardiovascular,                        
                        'respiratorio'                          =>  $respiratorio  
                    );                    
                    $this->db->insert('histo_rxsists', $trevxsistema);
                    
                    // Revisión x Sistema SEGUNDA PARTE
                    $trevxsistemas   =   array(
                        'tipo_docu'                             =>  $tipo_docu,
                        'identificacion'                        =>  $identificacion,
                        'cons_historia'                         =>  $cons_historiac,
                        'tipo_historia'                         =>  $tipo_historia,
                        'tgenitourinario'                       =>  $tgenitourinario,    
                        'tlocomotor'                            =>  $tlocomotor,                                                        
                        'genitourinario'                        =>  $genitourinario,                                                    
                        'locomotor'                             =>  $locomotor,                            
                        'otrosrevisionxsistema'                 =>  $otrosrevisionxsistema
                    );
                    
                    $this->db->insert('histo_rxsist', $trevxsistemas);                              
                    
                    
                    // ACTUALIZANDO CONSECUTIVOS DE CONSULTA MEDICA
                    $consecutivohistcorporal = array(
                    'numero_consecutivo'    => $conscorpo
                    );
                    
                    $this->db->where('cod_consecutivo', 12);
                    $this->db->update('consecutivos', $consecutivohistcorporal);
                    
                    // ACTUALIZANDO EN EVOLUCION
                    $matrizevolucion = array(
                        'corporal'      =>  'Consultar',
                        'ncorporal'     =>  $conscorpo,
                        'fechacorporal' =>  $fechacorporal,
                        'horacorporal'  =>  $horacorporal
                    );
                    
                    $this->db->where('tipo_docu', $tipo_docu);
                    $this->db->where('identificacion', $identificacion);
                    $this->db->where('nevolucion', '0');
                    $this->db->update('consulta_medica_evolucion', $matrizevolucion);
                    
                    // RETORNANDO VARIABLES PARA CONSULTAS
                    $datosr['rtipo_docu']           =   $datacorporal['tipo_docu'];
                    $datosr['ridentificacion']      =   $datacorporal['identificacion'];
                    $datosr['rcons_historia']       =   $datacorporal['cons_historia'];
                    
                                    
                    return $datosr;
                    
                    $query2->free_result();    
                }
                
                
            } 
        }               
    }
    
    public function ingresofacial()
    {
        if($this->input->post())
        {
            // FACIAL RECORRER MATRIZ INFORMO QUE VIENE DE JSON
            $fac = $this->input->post('facial');         
            $fac = json_decode($fac);
            if (is_array($fac)) 
            {
                foreach ($fac as $farow => $vfac) 
                { 
                    //CONSECUTIVO HISTORIA PACIENTE
                    $this->db->select();
                    $this->db->from('consecutivos');
                    $this->db->where('cod_consecutivo', 13);   
                    $query3 = $this->db->get();
                    $consfacia = '';        
                    foreach ($query3->result_array() as $row)
                    {
                        $consfacia = $row['numero_consecutivo'];
                        $consfacia = $consfacia + 1;
                    }
                    
                    $tipo_docu                          =   trim($vfac->tipo_docu);
                    $identificacion                     =   trim($vfac->identificacion);
                    $cons_historiaf                     =   $consfacia;
                    $tipo_historia                      =   trim($vfac->tipo_historia);
                    $motivoconsultafacial               =   trim($vfac->motivoconsultafacial);
                    $opherpeslabial                     =   trim($vfac->opherpeslabial);
                    $hherpeslabial                      =   trim($vfac->hherpeslabial);
                    $opmoluscocontagioso                =   trim($vfac->opmoluscocontagioso);                        
                    $hmoluscocontagioso                 =   trim($vfac->hmoluscocontagioso);
                    $opusoderetinoides                  =   trim($vfac->opusoderetinoides);
                    $husoderetinoides                   =   trim($vfac->husoderetinoides);
                    $opverrugasviricas                  =   trim($vfac->opverrugasviricas);
                    $hverrugasviricas                   =   trim($vfac->hverrugasviricas);
                    $opcirugiafacial                    =   trim($vfac->opcirugiafacial);
                    $hcirugiafacial                     =   trim($vfac->hcirugiafacial);
                    $otrosantecedentesespecificos       =   trim($vfac->otrosantecedentesespecificos);
                    $opfototipocutaneo                  =   trim($vfac->opfototipocutaneo);
                    $opclasigoglau                      =   trim($vfac->opclasigoglau);
                    $hallazgospiel                      =   trim($vfac->hallazgospiel);
                    $diagnostico                        =   trim($vfac->diagnostico);
                    $selplantratamientofacial           =   trim($vfac->selplantratamientofacial);
                    $plandetratamientofacial            =   trim($vfac->plandetratamientofacial);
                    $costo                              =   trim($vfac->costo);
                    $fechafacial                        =   trim($vfac->fechafacial);
                    $horafacial                         =   trim($vfac->horafacial);
                    $login_ing                          =   trim($vfac->login_ing);
                    $nconsulta                          =   trim($vfac->nconsulta);
                    $cod_medi                           =   trim($vfac->cod_medi);
                    $cod_consultorio                    =   trim($vfac->cod_consultorio);
                    
                    $datafacial = array(                        
                    'tipo_docu'                             =>  $tipo_docu,
                    'identificacion'                        =>  $identificacion,
                    'cons_historia'                         =>  $cons_historiaf,
                    'tipo_historia'                         =>  $tipo_historia,
                    'motivoconsultafacial'                  =>  $motivoconsultafacial,
                    'opherpeslabial'                        =>  $opherpeslabial,
                    'hherpeslabial'                         =>  $hherpeslabial,
                    'opmoluscocontagioso'                   =>  $opmoluscocontagioso,                        
                    'hmoluscocontagioso'                    =>  $hmoluscocontagioso,
                    'opusoderetinoides'                     =>  $opusoderetinoides,
                    'husoderetinoides'                      =>  $husoderetinoides,
                    'opverrugasviricas'                     =>  $opverrugasviricas,
                    'hverrugasviricas'                      =>  $hverrugasviricas,
                    'opcirugiafacial'                       =>  $opcirugiafacial,
                    'hcirugiafacial'                        =>  $hcirugiafacial,
                    'otrosantecedentesespecificos'          =>  $otrosantecedentesespecificos,
                    'opfototipocutaneo'                     =>  $opfototipocutaneo,
                    'opclasigoglau'                         =>  $opclasigoglau,
                    'hallazgospiel'                         =>  $hallazgospiel,
                    'diagnostico'                           =>  $diagnostico,
                    'selplantratamientofacial'              =>  $selplantratamientofacial,
                    'plandetratamientofacial'               =>  $plandetratamientofacial,
                    'costo'                                 =>  $costo,
                    'fechafacial'                           =>  $fechafacial,
                    'horafacial'                            =>  $horafacial,
                    'login_ing'                             =>  $login_ing,
                    'nconsulta'                             =>  $nconsulta,
                    'cod_medi'                              =>  $cod_medi,
                    'cod_consultorio'                       =>  $cod_consultorio
                    );
                    // INSERTAR DATOS                
                    $this->db->insert('historiaclinica', $datafacial);
                    
                    // ACTUALIZANDO CONSECUTIVOS DE CONSULTA MEDICA
                    $consecutivohistfacial = array(
                    'numero_consecutivo'    => $consfacia
                    );
                    
                    $this->db->where('cod_consecutivo', 13);
                    $this->db->update('consecutivos', $consecutivohistfacial);
                    
                    // ACTUALIZANDO EN EVOLUCION
                    $matrizevolucion = array(
                        'facial'        =>  'Consultar',
                        'nfacial'       =>  $consfacia,
                        'fechafacial'   =>  $fechafacial,
                        'horafacial'    =>  $horafacial
                    );
                    
                    $this->db->where('tipo_docu', $tipo_docu);
                    $this->db->where('identificacion', $identificacion);
                    $this->db->where('nevolucion', '0');
                    $this->db->update('consulta_medica_evolucion', $matrizevolucion);
                    
                    // RETORNANDO VARIABLES PARA CONSULTAS
                    $datosr['rtipo_docu']           =   $datafacial['tipo_docu'];
                    $datosr['ridentificacion']      =   $datafacial['identificacion'];
                    $datosr['rcons_historia']       =   $datafacial['cons_historia'];
                    
                                    
                    return $datosr;
                    
                    $query3->free_result();
                }
            }
        }
    }
    
    public function ingresoexamen1()
    {
          //print_r($_POST['examen']);    
    }
    public function ingresoexamen()
    {
        if($this->input->post())
        {
            $exame = $this->input->post('examen');         
            $exame = json_decode($exame);
            if (is_array($exame)) 
            {                    
                foreach ($exame as $exrow => $vexa) 
                {                                       
                    // CONSECUTIVO EXAMEN MEDICO  PACIENTE
                    $this->db->select();
                    $this->db->from('consecutivos');
                    $this->db->where('cod_consecutivo', 7);   
                    $query6 = $this->db->get();
                    $cons_examen = '';        
                    foreach ($query6->result_array() as $row)
                    {
                        $cons_examen = $row['numero_consecutivo'];
                        $cons_examen = $cons_examen + 1;
                    }	                                        
                    
                    // VARIABLE FECHA DE NACIMIENTO
                    $fechan                 =   trim($vexa->fechanacimiento);
                    //generando edad y unidad medida de la edad
                    date_default_timezone_set('America/Bogota');
                    $ma                     = 12;
                    //$fechan                 = $paci['fecha_de_nacimiento'];
                    $edadpaciente           = '';
                    $totaldiasmes           = '';
                    list($Y,$m,$d)          = explode("-",$fechan);            
                    $edadpaciente           = ( date("md") < $m.$d ? date("Y")-$Y-1 : date("Y")-$Y );
                    $edadpaciente           = intval($edadpaciente);
                    $mn                     = intval($m);  
                    $dn                     = intval($d);
                    $mesactual              = intval(date("m"));
                    $diaactual              = intval(date("d"));            
                    $mesanterior            = '';     
                    $anocomp                = '';     
                    $anoactual              = intval(date("Y")); 
                    $anon                   = $Y;
                    $ume                    = '';
                              
                    if($mn == 2)
                    {
                        $totaldiasmes = 28;
                    }
                    if($dn == 31)
                    {
                        $dn = $dn - 1;
                    }
                    if($mn == 2 && $dn >= 29)
                    {
                        $dn = 28;
                    }
                    //$edad = $edadpaciente;
                    if($edadpaciente == 0)
                    {             
                        //MESES ACTUALES DEL PACIENTE               
                   
                        if($mesactual == 1)
                        {
                            $mesanterior = 12;
                        }                
                        else
                        {
                            $mesanterior = $mesactual - 1;
                        }
                        
                        if($mesanterior == $mn || $mn == $mesactual)
                        {
                            if($mn == $mesactual)
                            {
                                $edadresultado = $diaactual - $dn;
                            }
                            else
                            {
                                $edadresultado = $diaactual + 30 - $dn;
                                
                            }
                            
                            if($edadresultado >= 31)
                            {
                                $edad   = $mesactual - $mn;
                                $ume    = 2;  
                            }
                            else
                            {
                                $edad = $edadresultado;
                                $ume    = 3;
                            }                    
                        }
                        else
                        {
                            $anocomp        = $anoactual - 1;
                            if($anocomp == $anon)
                            {
                                $edad  = 12 - $mn + $mesactual;
                                $ume    = 2;
                            }
                            else
                            {
                                $edad  = $mesactual - $mn;
                                $ume    = 2;
                            }
                        }
                    }
                    else
                    {
                        $edad   = $edadpaciente;
                        $ume    = 1;
                    }
                    
                    
                    
                    $nconsulta                          =   trim($vexa->nconsulta);
                    $tipo_docu                          =   trim($vexa->tipo_docu);
                    $identificacion                     =   trim($vexa->identificacion);
                    $edad                               =   $edad;
                    $ume                                =   $ume;
                    $cod_cons                           =   trim($vexa->cod_cons);  
                    $motivocontrol                      =   trim($vexa->motivocontrol);
                    $sist                               =   trim($vexa->sist);
                    $diast                              =   trim($vexa->diast);
                    $ppm                                =   trim($vexa->ppm);
                    $rpm                                =   trim($vexa->rpm);
                    $peso                               =   trim($vexa->peso);
                    $altura                             =   trim($vexa->altura);
                    $imc                                =   trim($vexa->imc);
                    $contextura                         =   trim($vexa->contextura);
                    $diametromu                         =   trim($vexa->diametromu);
                    $diametromupor                      =   trim($vexa->diametromupor);
                    $puntodecorte                       =   trim($vexa->puntodecorte);
                    $pesominimo                         =   trim($vexa->pesominimo);
                    $pesomaximo                         =   trim($vexa->pesomaximo);
                    $medidacadera                       =   trim($vexa->medidacadera);
                    $medidacintura                      =   trim($vexa->medidacintura);
                    $porcentajegrasa                    =   trim($vexa->porcentajegrasa);
                    $pesograsocorporal                  =   trim($vexa->pesograsocorporal);
                    $opcabeza                           =   trim($vexa->opcabeza);
                    $dcabeza                            =   trim($vexa->dcabeza);
                    $oporganossentidos                  =   trim($vexa->oporganossentidos);
                    $dorganossentidos                   =   trim($vexa->dorganossentidos);
                    $opcuello                           =   trim($vexa->opcuello);
                    $dcuello                            =   trim($vexa->dcuello);
                    $opcardiopulmonar                   =   trim($vexa->opcardiopulmonar);
                    $dcardiopulmonar                    =   trim($vexa->dcardiopulmonar);
                    $opabdomen                          =   trim($vexa->opabdomen);
                    $dabdomen                           =   trim($vexa->dabdomen);
                    $oppielfaneras                      =   trim($vexa->oppielfaneras);
                    $dpielfaneras                       =   trim($vexa->dpielfaneras);
                    $opsistemanervioso                  =   trim($vexa->opsistemanervioso);
                    $dsistemanervioso                   =   trim($vexa->dsistemanervioso);
                    $opextremidades                     =   trim($vexa->opextremidades);
                    $dextremidades                      =   trim($vexa->dextremidades);
                    $impresiondiagnostica               =   trim($vexa->impresiondiagnostica);
                    $cod_tipo                           =   trim($vexa->cod_tipo);
                    $id_cie                             =   trim($vexa->id_cie);
                    $cod_cielinea                       =   trim($vexa->cod_cielinea);
                    $cod_ciesublinea                    =   trim($vexa->cod_ciesublinea);
                    $cod_cie                            =   trim($vexa->cod_cie);
                    $selplantratamiento                 =   trim($vexa->selplantratamiento);
                    $plandetratamiento                  =   trim($vexa->plandetratamiento);
                    $examenessolicitados                =   trim($vexa->examenessolicitados);
                    $observacionesexamen                =   trim($vexa->observacionesexamen);
                    $cod_causa_dia                      =   trim($vexa->cod_causa_dia);
                    $cod_fina_cie                       =   trim($vexa->cod_fina_cie);
                    $fechaactual                        =   trim($vexa->fechaactual);
                    $horaactual                         =   trim($vexa->horaactual);
                    $id_admi                            =   trim($vexa->id_admi);
                    $cod_medi                           =   trim($vexa->cod_medi);
                    $login_ing                          =   trim($vexa->login_ing);
                    $cod_consultorio                    =   trim($vexa->cod_consultorio);
                    
                           
                    // EXAMEN MEDICO PARTE UNO
                        $dataexamen = array(  
                        'cons_examen'                       =>  $cons_examen,                      
                        'nconsulta'                         =>  $nconsulta,
                        'tipo_docu'                         =>  $tipo_docu,
                        'identificacion'                    =>  $identificacion,
                        'edad'                              =>  $edad,
                        'ume'                               =>  $ume,
                        'cod_cons'                          =>  $cod_cons,                 
                        'sist'                              =>  $sist,
                        'diast'                             =>  $diast,
                        'ppm'                               =>  $ppm,
                        'rpm'                               =>  $rpm,                        
                        'peso'                              =>  $peso,
                        'altura'                            =>  $altura,
                        'imc'                               =>  $imc,
                        'contextura'                        =>  $contextura,
                        'diametromu'                        =>  $diametromu,
                        'diametromupor'                     =>  $diametromupor,
                        'puntodecorte'                      =>  $puntodecorte,
                        'pesominimo'                        =>  $pesominimo,
                        'pesomaximo'                        =>  $pesomaximo,
                        'medidacadera'                      =>  $medidacadera,
                        'medidacintura'                     =>  $medidacintura,
                        'porcentajegrasa'                   =>  $porcentajegrasa,
                        'pesograsocorporal'                 =>  $pesograsocorporal,                                              
                        'impresiondiagnostica'              =>  $impresiondiagnostica,
                        'cod_tipo'                          =>  $cod_tipo,
                        'id_cie'                            =>  $id_cie,
                        'cod_cielinea'                      =>  $cod_cielinea,
                        'cod_ciesublinea'                   =>  $cod_ciesublinea,
                        'cod_cie'                           =>  $cod_cie,
                        'selplantratamiento'                =>  $selplantratamiento,
                        'plandetratamiento'                 =>  $plandetratamiento,
                        'examenessolicitados'               =>  $examenessolicitados,
                        'observacionesexamen'               =>  $observacionesexamen,
                        'cod_causa_dia'                     =>  $cod_causa_dia,
                        'cod_fina_cie'                      =>  $cod_fina_cie,
                        'fechaactual'                       =>  $fechaactual,
                        'horaactual'                        =>  $horaactual,
                        'id_admi'                           =>  $id_admi,
                        'cod_medi'                          =>  $cod_medi,
                        'login_ing'                         =>  $login_ing,
                        'cod_consultorio'                   =>  $cod_consultorio,
                        'motivocontrol'                     =>  $motivocontrol
                        );
                        // INSERTAR DATOS                
                        $this->db->insert('consulta_medica', $dataexamen);
                        
                        // EXAMEN MEDICO PARTE DOS
                        $dataexamens = array(  
                        'cons_examen'                       =>  $cons_examen,                      
                        'nconsulta'                         =>  $nconsulta,
                        'tipo_docu'                         =>  $tipo_docu,
                        'identificacion'                    =>  $identificacion,                        
                        'dcabeza'                           =>  $dcabeza,                        
                        'dorganossentidos'                  =>  $dorganossentidos,                        
                        'dcuello'                           =>  $dcuello,                        
                        'dcardiopulmonar'                   =>  $dcardiopulmonar,                        
                        'dabdomen'                          =>  $dabdomen,                        
                        'dpielfaneras'                      =>  $dpielfaneras,                        
                        'dsistemanervioso'                  =>  $dsistemanervioso,                        
                        'dextremidades'                     =>  $dextremidades,                        
                        'opcabeza'                          =>  $opcabeza,                         
                        'oporganossentidos'                 =>  $oporganossentidos,                                                
                        'opcuello'                          =>  $opcuello,
                        'opcardiopulmonar'                  =>  $opcardiopulmonar,                                                
                        'opabdomen'                         =>  $opabdomen,
                        'oppielfaneras'                     =>  $oppielfaneras,                        
                        'opsistemanervioso'                 =>  $opsistemanervioso,                                                
                        'opextremidades'                    =>  $opextremidades                        
                        );
                        // INSERTAR DATOS                
                        $this->db->insert('hist_conmed_ef', $dataexamens);
                                                
                    // ACTUALIZANDO CONSECUTIVOS DE EXAMEN
                    $consecutivoexamen = array(
                    'numero_consecutivo'    => $cons_examen
                    );
                    
                    $this->db->where('cod_consecutivo', 7);
                    $this->db->update('consecutivos', $consecutivoexamen);
                }
                
                // CUPS RECORRER MATRIZ INFORMACION VIENE DE JSON
                $cup = $this->input->post('cups');         
                $cup = json_decode($cup);
                if (is_array($cup)) 
                {
                    foreach ($cup as $curow => $vcup) 
                    {
                        
                        $nconsulta                          =   trim($vcup->nconsulta);
                        $id_cups                            =   trim($vcup->id_cups);
                        $cod_cups                           =   trim($vcup->cod_cups);
                        $cod_cupslinea                      =   trim($vcup->cod_cupslinea);
                        $cod_cupsublinea                    =   trim($vcup->cod_cupsublinea);
                        $cod_cupsgrupo                      =   trim($vcup->cod_cupsgrupo);
                        $coddescripcion                     =   trim($vcup->coddescripcion);
                        $id_finalidad                       =   trim($vcup->id_finalidad);
                        $finalidadesdes                     =   trim($vcup->finalidadesdes);
                        $cod_ambi                           =   trim($vcup->cod_ambi);
                        $ambitosdes                         =   trim($vcup->ambitosdes);
                        $cod_actoq                          =   trim($vcup->cod_actoq);
                        $actoqsdes                          =   trim($vcup->actoqsdes);
                        $autorizaciones                     =   trim($vcup->autorizaciones);
                        $valor_cups                         =   trim($vcup->valor_cups);
                        $horaactual                         =   trim($vcup->horaactual);
                        $fechaactual                        =   trim($vcup->fechaactual);
                        
                        $datacups = array(                        
                        'nconsulta'                     =>  $nconsulta,
                        'id_cups'                       =>  $id_cups,
                        'cod_cups'                      =>  $cod_cups,
                        'cod_cupslinea'                 =>  $cod_cupslinea,
                        'cod_cupsublinea'               =>  $cod_cupsublinea,
                        'cod_cupsgrupo'                 =>  $cod_cupsgrupo,
                        'coddescripcion'                =>  $coddescripcion,
                        'id_finalidad'                  =>  $id_finalidad,
                        'finalidadesdes'                =>  $finalidadesdes,
                        'cod_ambi'                      =>  $cod_ambi,
                        'ambitosdes'                    =>  $ambitosdes,
                        'cod_actoq'                     =>  $cod_actoq,
                        'actoqsdes'                     =>  $actoqsdes,
                        'autorizaciones'                =>  $autorizaciones,
                        'valor_cups'                    =>  $valor_cups,
                        'horaactual'                    =>  $horaactual,
                        'fechaactual'                   =>  $fechaactual,
                        );
                        
                        // INSERTAR DATOS                
                        $this->db->insert('consulta_medicaxtratamiento', $datacups);
                    }
                }
                // RETORNANDO VARIABLES PARA CONSULTAS
                $datosr['rtipo_docu']           =   $dataexamen['tipo_docu'];
                $datosr['ridentificacion']      =   $dataexamen['identificacion'];
                $datosr['rnconsulta']           =   $dataexamen['nconsulta'];
                
                return $datosr;
                $query3->free_result();
            }           
        }
    }
    
    public function ingresoevolucion1()
    {
        print_r($_POST['evoluci']);    
    }
    public function ingresoevolucion()
    {
        if($this->input->post())
        {
            $evolu = $this->input->post('evoluci');         
            $evolu = json_decode($evolu);
            if (is_array($evolu)) 
            {                    
                foreach ($evolu as $exrow => $vevol) 
                {   
                    $tipo_docu                          =   trim($vevol->tipo_docu);
                    $identificacion                     =   trim($vevol->identificacion);
                    $fechacontrol                       =   trim($vevol->fechaingreso);
                    $horacontrol                        =   trim($vevol->horaingreso);
                    $metabolismo_basal                  =   trim($vevol->metabolismo_basal);
                    $requerimiento_calor                =   trim($vevol->requerimiento_calor);
                    $nconsulta                          =   trim($vevol->nconsulta);
                    $peso                               =   trim($vevol->evpeso);
                    $dia                                =   trim($vevol->evdias);
                    $semana                             =   trim($vevol->evsemana);
                    $brazo                              =   trim($vevol->evbrazo);
                    $antebrazo                          =   trim($vevol->evantebrazo);
                    $pecho                              =   trim($vevol->evpecho);
                    $busto                              =   trim($vevol->evbusto);
                    $abdomen_alto                       =   trim($vevol->evabdomenalto);
                    $cintura                            =   trim($vevol->evcintura);   
                    $cadera_alta                        =   trim($vevol->evcaderaalta);
                    $cadera_baja                        =   trim($vevol->evcaderabaja);
                    $muslos                             =   trim($vevol->evmuslos);
                    $evolucion                          =   trim($vevol->evolucion);
                    $cod_medi                           =   trim($vevol->cod_medi);
                    $fechaingreso                       =   trim($vevol->fechaingreso);
                    $horaingreso                        =   trim($vevol->horaingreso);
                    $login_ing                          =   trim($vevol->login_ing);
                    
                    $this->db->select_max('nevolucion');
                    $this->db->from('consulta_medica_evolucion ');
                    $this->db->where('tipo_docu', $tipo_docu);   
                    $this->db->where('identificacion', $identificacion);                    
                    $query = $this->db->get();
                    $consevolucion  = '';        
                    foreach ($query->result_array() as $row)
                    {
                        $consevolucion = $row['nevolucion'];
                        $consevolucion = $consevolucion + 1;
                    }
                    
                    $datacme = array(                        
                        'nconsulta'                     =>  $nconsulta,
                        'tipo_docu'                     =>  $tipo_docu,
                        'identificacion'                =>  $identificacion,
                        'fechacontrol'                  =>  $fechaingreso,
                        'horacontrol'                   =>  $horaingreso,
                        'nevolucion'                    =>  $consevolucion,
                        'fechaingreso'                  =>  $fechaingreso,
                        'horaingreso'                   =>  $horaingreso,
                        'login_ing'                     =>  $login_ing,
                        'plandetratamiento'             =>  $evolucion,
                        'cod_medi'                      =>  $cod_medi
                    );
                    
                    // INSERTAR DATOS                
                    $this->db->insert('consulta_medica_evolucion', $datacme);
                    
                    // MATRIZ PARA DETALLES DE EVOLUCION
                    $datacmed = array(
                        'nconsulta'                     =>  $nconsulta,
                        'nevolucion'                    =>  $consevolucion,
                        'tipo_docu'                     =>  $tipo_docu,
                        'identificacion'                =>  $identificacion,
                        'fechacontrol'                  =>  $fechaingreso,
                        'horacontrol'                   =>  $horaingreso,
                        'metabolismo_basal'             =>  $metabolismo_basal,
                        'requerimiento_calor'           =>  $requerimiento_calor,
                        'peso'                          =>  $peso,
                        'dia'                           =>  $dia,
                        'semana'                        =>  $semana,
                        'brazo'                         =>  $brazo,
                        'antebrazo'                     =>  $antebrazo,
                        'pecho'                         =>  $pecho,
                        'busto'                         =>  $busto,
                        'abdomen_alto'                  =>  $abdomen_alto,
                        'cintura'                       =>  $cintura,
                        'cadera_alta'                   =>  $cadera_alta,
                        'cadera_baja'                   =>  $cadera_baja,
                        'muslos'                        =>  $muslos,
                        'evolucion'                     =>  $evolucion,
                        'cod_medi'                      =>  $cod_medi,
                        'fechaingreso'                  =>  $fechaingreso,
                        'horaingreso'                   =>  $horaingreso,
                        'login_ing'                     =>  $login_ing
                    );
                    
                    // INSERTAR DATOS                
                    $this->db->insert('consulta_medica_evoluciondetalles', $datacmed);
                    
                    $datosr['nevolucion']       =   $consevolucion;
                    $datosr['tipo_docu']        =   $tipo_docu;
                    $datosr['identificacion']   =   $identificacion;
                    
                    return $datosr;
                    $query->free_result();                      
                }
            }
        }
    }
    
    public function evolucionelaborada($tipo_docu, $identificacion, $nevolucion)
    {
        $this->db->select();
        $this->db->from('consulta_medica_evoluciondetalles');        
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion', $identificacion);
        $this->db->where('nevolucion', $nevolucion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();       
    }
    
    public function cotizacioning()
    {
        if($this->input->post())
        {
            $coti = $this->input->post('cotizacion');         
            $coti = json_decode($coti);
            if (is_array($coti)) 
            {                    
                foreach ($coti as $exrow => $cot) 
                {
                    //CONSECUTIVO HISTORIA PACIENTE
                    $this->db->select();
                    $this->db->from('consecutivos');
                    $this->db->where('cod_consecutivo', 8);   
                    $query = $this->db->get();
                    $conscoti = '';        
                    foreach ($query->result_array() as $row)
                    {
                        $conscoti = $row['numero_consecutivo'];
                        $conscoti = $conscoti + 1;
                    }
                    
                    $tipo_docu                  =   trim($cot->tipo_docu);
                    $identificacion             =   trim($cot->identificacion);  
                    $nombre                     =   trim($cot->nombre);
                    $direccion                  =   trim($cot->direccion);
                    $telefono                   =   trim($cot->telefono);
                    $celular                    =   trim($cot->celular);
                    $email                      =   trim($cot->email);
                    $remitidopor                =   trim($cot->remitidopor);
                    $diagnostico                =   trim($cot->diagnostico);
                    $procedimiento              =   trim($cot->procedimiento);
                    $valor                      =   trim($cot->valor);
                    $observaciones              =   trim($cot->observaciones);
                    $login_ing                  =   trim($cot->login_ing);
                    $fechaingreso               =   trim($cot->fechaingreso);
                    $horaingreso                =   trim($cot->horaingreso);
    
                    // MATRIZ PARA DETALLES DE EVOLUCION
                    $datacotizacion = array(
                        'ncotizacion'                   =>  $conscoti,
                        'tipo_docu'                     =>  $tipo_docu,
                        'identificacion'                =>  $identificacion,
                        'nombre'                        =>  $nombre,
                        'direccion'                     =>  $direccion,
                        'telefono'                      =>  $telefono,
                        'celular'                       =>  $celular,
                        'email'                         =>  $email,
                        'remitidopor'                   =>  $remitidopor,
                        'diagnostico'                   =>  $diagnostico,
                        'procedimiento'                 =>  $procedimiento,
                        'valor'                         =>  $valor,
                        'observaciones'                 =>  $observaciones,                        
                        'fechaingreso'                  =>  $fechaingreso,
                        'horaingreso'                   =>  $horaingreso,
                        'login_ing'                     =>  $login_ing
                    );
                    
                    // INSERTAR DATOS                
                    $this->db->insert('cotizaciones', $datacotizacion);
    
    
                }
            }
        }
    }
    
    public function consultorios()
    {
        $this->db->select();
        $this->db->from('consultorios');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();            
    }   
    
    public function pesoideal($altura, $sigla_sexo, $contextura)    
    {
        $raltura      =   $altura%2;
        if($raltura == '0')
        {
            $altura   =   $altura;    
        }
        else
        {
            $altura   =   $altura - 1;
        }
        
        $this->db->select('minimo, maximo');
        $this->db->from('indicepesoideal');
        $this->db->where('altura', $altura);
        $this->db->where('sigla_sexo', $sigla_sexo);
        $this->db->where('contextura', $contextura);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function icie($tipo_docu, $identificacion, $nevolucion)
    { 
        $this->db->select('n.cod_cie, n.cod_cier, n.cod_ciers, n.cod_cierr, p.nombre_cie, m.nombre_causa_dia, f.nombre_fina, t.nombre_tipo, n.observacionescie, n.observacionescier, cr.nombre_cie as nombrecier, crs.nombre_cie as nombreciers, n.observacionesciers, crr.nombre_cie as nombrecrr, n.observacionescierr, c.nombre_cons');
        $this->db->from('ciecups n'); 
        $this->db->join('cie10 p', 'p.cod_cie=n.cod_cie');
        $this->db->join('causa_diagnostico m', 'm.cod_causa_dia=n.cod_causa_dia');
        $this->db->join('finalidad f', 'f.id_finalidad=n.cod_fina_cie');
        $this->db->join('tipo t', 't.cod_tipo=n.cod_tipo');
        $this->db->join('cie10 cr', 'cr.cod_cie=n.cod_cier', 'left outer');
        $this->db->join('cie10 crs', 'crs.cod_cie=n.cod_ciers', 'left outer');
        $this->db->join('cie10 crr', 'crr.cod_cie=n.cod_cierr', 'left outer');
        $this->db->join('consulta c', 'c.cod_cons=n.cod_cons');
        $this->db->where('n.tipo_docu', $tipo_docu);
        $this->db->where('n.identificacion' ,$identificacion);
        $this->db->where('n.nevolucion', $nevolucion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }
    
     public function icups($tipo_docu, $identificacion, $nevolucion)
    {
       $this->db->select('a.cod_cups, b.nombre_cups, c.nombre_fina, d.nombre_ambi, e.nombre_actoq, a.valor_cups, a.autorizacion'); 
       $this->db->from('ciecups a');
       $this->db->join('cups b', 'b.cod_cups=a.cod_cups');
       $this->db->join('finalidad c', 'c.id_finalidad=a.id_finalidad');
       $this->db->join('ambito d', 'd.cod_ambi=a.cod_ambi');
       $this->db->join('actoquirurgico e', 'e.cod_actoq=a.cod_actoq');
       $this->db->where('a.tipo_docu', $tipo_docu);
       $this->db->where('a.identificacion' ,$identificacion);
       $this->db->where('a.nevolucion', $nevolucion);
       $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
   

    
    public function insertarimg($fecha_imag, $descripcion_imag, $ruta_imag, $tipo_docu, $identificacion, $id_paciente, $peso, $login_ing, $horaactual, $imagen)
    {
        //MATRIZ PARA FACTURAS
        $imagi  =   array(
            'fecha_imag'            =>      $fecha_imag,
            'descripcion_imag'      =>      $descripcion_imag,
            'ruta_imag'             =>      $ruta_imag,
            'tipo_docu'             =>      $tipo_docu,
            'identificacion'        =>      $identificacion,
            'id_paciente'           =>      $id_paciente,
            'peso'                  =>      $peso,
            'login_ing'             =>      $login_ing,
            'horaactual'            =>      $horaactual,
            'fechaactual'           =>      $fecha_imag,
            'imagen'               =>      $imagen
        );
        //INSERTAR DATOS ENCABEZADO               
        $this->db->insert('imagenes', $imagi);     
    }
    
    public function consultafm($medico)
    {
        $this->db->select('firmamedi');
        $this->db->from('medicos');
        $this->db->where('cod_medi', $medico);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function vinsertarprocedimiento($nombre_convencion_odon, $valor)
    {   
        if($this->input->post())
        {       
            // CONSULTA CONSECUTIVO DE CONVENCIONES
            $this->db->select();
            $this->db->from('consecutivos');
            $this->db->where('cod_consecutivo', 11);   
            $query = $this->db->get();
            $conscon = '';        
            foreach ($query->result_array() as $row)
            {
            $conscon = $row['numero_consecutivo'];
            $conscon = $conscon + 1;
            } 
            
            if($nombre_convencion_odon == '')
            {
                $datos['error'] =   'Falta el nombre';
                $this->load->view('front_end/salidaerror', $datos);
            }
            else if($valor == '')
            {
                $datos['error'] =   'Falta el valor';
                $this->load->view('front_end/salidaerror', $datos);
            }else
            {
                $coti = array(                    
                'cod_listap'       =>  $conscon,
                'nombre_listap'    =>  $nombre_convencion_odon,                
                'valor'            =>  $valor                
                );
                
               // INSERTAR DATOS ENCABEZADO               
                $this->db->insert('listaprecios', $coti);
                
                // ACTUALIZANDO CONSECUTIVOS DE PROCEDIMIENTOS
                $nconscon = array(
                'numero_consecutivo'    => $conscon
                );
                $this->db->where('cod_consecutivo', 11);
                $this->db->update('consecutivos', $nconscon);  
                
                echo $conscon;      
            }
        $query->free_result();
        }
    }
    
    public function vmodificarprocedimiento($codigo, $descri, $valor)
    {   
        if($this->input->post())
        {    
            $coti = array(
            'nombre_listap'     =>  $descri,            
            'valor'             =>  $valor            
            );
            
            // INSERTAR DATOS ENCABEZADO               
            $this->db->where('cod_listap', $codigo);
            $this->db->update('listaprecios', $coti);
            
            echo $codigo;      
            
        $query->free_result();
        }
    }
    
    public function resumencons()
    {
        $this->db->select();
        $this->db->from('consentimientos');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();        
    }
    
    public function ingresocons()   
    {        
        if($this->input->post())
        {
            //print_r($_POST['consenti']);
            $conse = $this->input->post('consenti');         
            $conse = json_decode($conse);
            if (is_array($conse)) 
            {
                foreach ($conse as $row => $vcon) 
                { 
                    $titulo         =   trim($vcon->titulo);
                    $descripcion    =   trim($vcon->descripcion);
                    $login_ing      =   trim($vcon->histlogin);
                    $fechaactual    =   trim($vcon->fechaactual);
                      
                    $ingcons = array(
                    'titulo'        =>  $titulo,                                
                    'descripcion'   =>  $descripcion,
                    'login_ing'     =>  $login_ing,
                    'fechaactual'   =>  $fechaactual                
                    );
                    
                    //INSERTAR DATOS                
                    $this->db->insert('consentimientos', $ingcons);             
                }
            }
        }        
    }
    
    public function modificarcons()   
    {        
        if($this->input->post())
        {
            //print_r($_POST['consenti']);
            $consem = $this->input->post('consentim');         
            $consem = json_decode($consem);
            if (is_array($consem)) 
            {
                foreach ($consem as $row => $vconm) 
                { 
                    $id_consentimiento  =   trim($vconm->id_consentimiento);
                    $titulo             =   trim($vconm->titulo);
                    $descripcion        =   trim($vconm->descripcion);
                    $login_ing          =   trim($vconm->histlogin);
                    $fechaactual        =   trim($vconm->fechaactual);
                      
                    $ingconsm = array(
                    'titulo'        =>  $titulo,                                
                    'descripcion'   =>  $descripcion,
                    'login_ing'     =>  $login_ing,
                    'fechaactual'   =>  $fechaactual                
                    );
                    
                    $this->db->where('id_consentimiento', $id_consentimiento);
                    $this->db->update('consentimientos', $ingconsm);             
                }
            }
        }        
    }
    
    public function actualizarpresentacion($id_med_pres,$und_medicamento)
    {
        if($this->input->post())
        {
            $data = array(                                            
            'und_medicamento'   =>  $und_medicamento
            );
            
            // MODIFICAR MEDICAMENTOS
            $this->db->where('id_med_pres', $id_med_pres);
            $this->db->update('medicamentos_pres', $data);
        }
    }
    
    public function modificarmedicamento($id_medicamento, $cod_medicamento, $nombre_medicamento, $und_medicamento, $concentracion, $valor)
    {
        if($this->input->post())
        {
            $data = array(
            'cod_medicamento'       =>  $cod_medicamento,                                
            'nombre_medicamento'    =>  $nombre_medicamento,
            'und_medicamento'       =>  $und_medicamento,
            'concentracion'         =>  $concentracion,
            'valor'                 =>  $valor
            );
            
            // MODIFICAR MEDICAMENTOS
            $this->db->where('id_medicamento', $id_medicamento);
            $this->db->update('medicamentos', $data);
        }
    }     
    
    public function insertarpresentacion($und_medicamento)
    {
        if($this->input->post())
        {
            $data = array(
            'und_medicamento'       =>  $und_medicamento
            );
            
           // INSERTAR DATOS                
            $this->db->insert('medicamentos_pres', $data);                       
        }
    }  
    
    public function insertarmedicamento($data)
    {
        // INSERTAR DATOS                
        $this->db->insert('medicamentos', $data);                       
        
    }   
    
    public function insertareste($fecha_at,$fecha_es,$instrumental,$paquetes,$carga,$rotacion,$temperatura,$histlogin,$fechaactual)
    {
        if($this->input->post())
        {
            // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: consulta_medica
            $data = array(
            'fecha_at'          =>  $fecha_at,                                
            'fecha_es'          =>  $fecha_es,
            'instrumental'      =>  $instrumental,
            'paquetes'          =>  $paquetes,                
            'carga'             =>  $carga,                
            'rotacion'          =>  $rotacion,                
            'temperatura'       =>  $temperatura,
            'login_ing'         =>  $histlogin,
            'fechaactual'       =>  $fechaactual                 
            );
            
           // INSERTAR DATOS                
            $this->db->insert('p_esterilizacion', $data);           
        }
    }    
    
    public function modificareste($mid_esterilizacion,$fecha_es,$instrumental,$paquetes,$carga,$rotacion,$temperatura,$histlogin,$fechaactual)
    {
        if($this->input->post())
        {
            // GENERAR LA MATRIZ DEL ENCABEZADO PARA SER GRABADA EN TABLA: consulta_medica
            $data = array(                                            
            'fecha_es'          =>  $fecha_es,
            'instrumental'      =>  $instrumental,
            'paquetes'          =>  $paquetes,                
            'carga'             =>  $carga,                
            'rotacion'          =>  $rotacion,                
            'temperatura'       =>  $temperatura,
            'login_ing'         =>  $histlogin,
            'fechaactual'       =>  $fechaactual                 
            );
            
            // INSERTAR DATOS 
            $this->db->where('id_esterilizacion', $mid_esterilizacion);               
            $this->db->update('p_esterilizacion', $data);           
        }
    }
    
    public function bfecha_at($fechainicial, $fechafinal)
    {
        $this->db->select('fecha_at, fecha_es,  instrumental, paquetes, carga, rotacion, temperatura');
        $this->db->from('p_esterilizacion');                
        $this->db->where('fecha_at >=', $fechainicial);
        $this->db->where('fecha_at <=', $fechafinal);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();      
    }
    
    public function efectivo($fechainicial, $fechafinal)
    {
        $this->db->select_sum('valor_abono');
        $this->db->from('detalles');        
        $this->db->where('fechaingreso >=', $fechainicial);
        $this->db->where('fechaingreso <=', $fechafinal);
        $this->db->where('ref_procesos', 'RC');
        $this->db->where('estado', 'ACTIVO');
        $this->db->where('tipo_abono', 'Efectivo');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function cheque($fechainicial, $fechafinal)
    {
        $this->db->select_sum('valor_abono');
        $this->db->from('detalles');        
        $this->db->where('fechaingreso >=', $fechainicial);
        $this->db->where('fechaingreso <=', $fechafinal);
        $this->db->where('ref_procesos', 'RC');
        $this->db->where('estado', 'ACTIVO');
        $this->db->where('tipo_abono', 'Cheque');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function tarjetadebito($fechainicial, $fechafinal)
    {
        $this->db->select_sum('valor_abono');
        $this->db->from('detalles');        
        $this->db->where('fechaingreso >=', $fechainicial);
        $this->db->where('fechaingreso <=', $fechafinal);
        $this->db->where('ref_procesos', 'RC');
        $this->db->where('estado', 'ACTIVO');
        $this->db->where('tipo_abono', 'Tarjeta Débito');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function tarjetacredito($fechainicial, $fechafinal)
    {
        $this->db->select_sum('valor_abono');
        $this->db->from('detalles');        
        $this->db->where('fechaingreso >=', $fechainicial);
        $this->db->where('fechaingreso <=', $fechafinal);
        $this->db->where('ref_procesos', 'RC');
        $this->db->where('estado', 'ACTIVO');
        $this->db->where('tipo_abono', 'Tarjeta Crédito');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consignacion($fechainicial, $fechafinal)
    {
        $this->db->select_sum('valor_abono');
        $this->db->from('detalles');        
        $this->db->where('fechaingreso >=', $fechainicial);
        $this->db->where('fechaingreso <=', $fechafinal);
        $this->db->where('ref_procesos', 'RC');
        $this->db->where('estado', 'ACTIVO');
        $this->db->where('tipo_abono', 'Consignación');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function asignarconsentimiento($tipo_docu, $identificacion, $titulo, $datospaciente, $descripcioncons, $fechaactual, $horaactual, $login_ing, $firmapaci, $firmamedi)
    {
        if($this->input->post())
        {
            $data = array(
            'login_ing'         =>  $login_ing,                                
            'tipo_docu'         =>  $tipo_docu,
            'identificacion'    =>  $identificacion,
            'titulo'            =>  $titulo,
            'parrafouno'        =>  $datospaciente,
            'descripcion'       =>  $descripcioncons,
            'fechaactual'       =>  $fechaactual,
            'horaactual'        =>  $horaactual,
            'firmapaci'         =>  $firmapaci,
            'firmamedi'         =>  $firmamedi
            );
            
           // INSERTAR DATOS                
            $this->db->insert('consentimientos_asignados', $data);                       
        }
    }   
    
    public function conpaciente($id_paciente)
    {        
        $this->db->select('p.tipo_docu, p.identificacion, p.primer_nombre, p.segundo_nombre, p.primer_apellido, p.segundo_apellido, t.nombre_tipo_docu');
        $this->db->from('pacientes p');
        $this->db->where('p.id_paciente', $id_paciente);
        $this->db->join('tipo_documento t', 't.tipo_docu = p.tipo_docu');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
            
    }  
    
    public function consentimientosasig($tipo_docu, $identificacion)
    {
        $this->db->select();
        $this->db->from('consentimientos_asignados');
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function repconsentimiento($id_con_asig)
    {
        $this->db->select();
        $this->db->from('consentimientos_asignados');
        $this->db->where('id_con_asig', $id_con_asig);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function conencaformula($num_formula, $id_paciente)
    {
        $this->db->select('f.fechaactual, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi');
        $this->db->from('medicamentos_form f');
        $this->db->join('medicos m','m.cod_medi = f.cod_medi');
        $this->db->where('f.num_formula', $num_formula);
        $this->db->where('f.id_paciente', $id_paciente);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();       
    }
    
    public function condetaformula($num_formula)
    {
        $this->db->select('medicamento, cantidad, prescripcion, valor');
        $this->db->from('medicamentos_pac');        
        $this->db->where('num_formula', $num_formula);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();    
    }
    
    public function consultamedicof($cod_medi)
    {
        $this->db->select('firmamedi');
        $this->db->from('medicos');        
        $this->db->where('cod_medi', $cod_medi);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();    
    }
    
    public function ingresoremision()
    {
        if($this->input->post())
        {
            //CONSECUTIVO DE REMISIONES
            $this->db->select();
            $this->db->from('consecutivos');
            $this->db->where('cod_consecutivo', 17);   
            $query1 = $this->db->get();
            $consremi = '';        
            foreach ($query1->result_array() as $row)
            {
                $consremi = $row['numero_consecutivo'];
                $consremi = $consremi + 1;
            }
            
            // RECORRER MATRIZ INFORMO QUE VIENE DE JSON
            $dat = $this->input->post('encabezado');         
            $dat = json_decode($dat);
            if (is_array($dat)) 
            {
                foreach ($dat as $row => $val) 
                { 
                    // VERIFICA SESSION                    
                    $histlogin              =   trim($val->login_ing);
                    
                    $vlogin =   $histlogin;
                    $this->db->select();
                    $this->db->from('usuarios');
                    $this->db->where('login', $vlogin);   
                    $query = $this->db->get();
                    if ($query->num_rows() <= 0)
                    {
                        $datos['error'] =   'Falta login';
                        $this->load->view('front_end/salidaerror', $datos); 
                    }
                    
                    $tipo_docu          = trim($val->tipo_docu);
                    $identificacion     = trim($val->identificacion);    
                    $fecha_re           = trim($val->fecha_re);                    
                    $observaciones      = trim($val->observaciones);
                    $centromedico       = trim($val->centromedico);
                    $cod_medi           = trim($val->cod_medi);
                    $firmapaci          = trim($val->firmapaci);
                    $firmamedi          = trim($val->firmamedi);
                    
                    
                    // ENCABEZADO DE REMISIONES
                    $encremi    =   array(
                    'tipo_docu'         =>  $tipo_docu,
                    'identificacion'    =>  $identificacion,
                    'fecha_re'          =>  $fecha_re,
                    'observaciones'     =>  $observaciones,
                    'centromedico'      =>  $centromedico,
                    'login_ing'         =>  $vlogin,
                    'num_remision'      =>  $consremi,
                    'cod_medi'          =>  $cod_medi,
                    'firmapaci'         =>  $firmapaci,
                    'firmamedi'         =>  $firmamedi
                    );
                    
                    $this->db->insert('p_remisiones', $encremi);
                }
                
                
                // ACTUALIZANDO CONSECUTIVOS DE REMISIONES
                $nconsremi = array(
                'numero_consecutivo'    => $consremi
                );
                $this->db->where('cod_consecutivo', 17);
                $this->db->update('consecutivos', $nconsremi);  
            }
            
        }
    }
    
    public function modificarremision()
    {
        if($this->input->post())
        {    
            // RECORRER MATRIZ INFORMO QUE VIENE DE JSON
            $dat = $this->input->post('encabezado');         
            $dat = json_decode($dat);
            if (is_array($dat)) 
            {
                foreach ($dat as $row => $val) 
                { 
                    // VERIFICA SESSION                    
                    $histlogin              =   trim($val->login_ing);
                    
                    $vlogin =   $histlogin;
                    $this->db->select();
                    $this->db->from('usuarios');
                    $this->db->where('login', $vlogin);   
                    $query = $this->db->get();
                    if ($query->num_rows() <= 0)
                    {
                        $datos['error'] =   'Falta login';
                        $this->load->view('front_end/salidaerror', $datos); 
                    }
                    
                    $tipo_docu          = trim($val->tipo_docu);
                    $identificacion     = trim($val->identificacion);    
                    $fecha_mod          = trim($val->fecha_mod);                    
                    $observaciones      = trim($val->observaciones);
                    $centromedico       = trim($val->centromedico);
                    $cod_medi           = trim($val->cod_medi);
                    $firmapaci          = trim($val->firmapaci);
                    $firmamedi          = trim($val->firmamedi);
                    $num_remision       = trim($val->num_remision);
                    
                    // ENCABEZADO DE REMISIONES
                    $encremi    =   array(
                    'tipo_docu'         =>  $tipo_docu,
                    'identificacion'    =>  $identificacion,
                    'fecha_mod'         =>  $fecha_mod,
                    'observaciones'     =>  $observaciones,
                    'centromedico'      =>  $centromedico,
                    'login_ing'         =>  $vlogin,                    
                    'cod_medi'          =>  $cod_medi,
                    'firmapaci'         =>  $firmapaci,
                    'firmamedi'         =>  $firmamedi                    
                    );
                    
                    $this->db->where('num_remision', $num_remision);
                    $this->db->update('p_remisiones', $encremi);
                }
                
                
                $datos['num_remision']          =   $num_remision;                               
                return $datos;                  
            }
            
        }       
    }
    
    public function ceremisiones($num_remision)
    {
        $this->db->select('fecha_re, observaciones, centromedico, num_remision');
        $this->db->from('p_remisiones');                
        $this->db->where('num_remision', $num_remision);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();          
    }   
    
    public function cfirmapac($num_remision)
    {
        $this->db->select('firmapaci');
        $this->db->from('p_remisiones');                
        $this->db->where('num_remision', $num_remision);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();        
        }else
        {
                return false;
        }
        $query->free_result();     
    }
    
    public function cfirmamed($num_remision)
    {
        $this->db->select('firmamedi');
        $this->db->from('p_remisiones');                
        $this->db->where('num_remision', $num_remision);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();          
        }else
        {
            return false;
        }
        $query->free_result();  
    }
    
    public function firmasmod($mnum_remision)
    {
        $this->db->select('firmapaci');
        $this->db->from('p_remisiones');                
        $this->db->where('num_remision', $mnum_remision);        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            foreach ($query->result_array() as $row)
            {
               $firmapac = $row['firmapaci'];
               echo $firmapac; 
            }            
        }else
        {
            $firmapac = '';
            echo $firmapac;
        }
        $query->free_result();     
    }
    
    public function prestador()
    {
        $this->db->select();
        $this->db->from('global');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function cpremision($num_odon)
    {
        $this->db->select('tipo_docu, identificacion, fecha_re, observaciones, centromedico');
        $this->db->from('p_remisiones');
        $this->db->where('num_remision', $num_odon);
        $query2 = $this->db->get();
        if($query2->num_rows() > 0)
        {
            return $query2->result_array();
        }else
        {
            return false;
        }
        $query2->free_result();
    }
    
    public function consultaect($tipo_docu, $identificacion, $ref_procesos, $numero_docu)
    {
        $this->db->select();
        $this->db->from('encabezado');
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion_paci', $identificacion);
        $this->db->where('ref_procesos', $ref_procesos);
        $this->db->where('numero_docu', $numero_docu);
        $this->db->where('estado', 'ACTIVO');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consultadct($numero_docu)
    {
        $this->db->select();
        $this->db->from('detalles');
        $this->db->where('numero_docu', $numero_docu);
        $this->db->where('proceso_ref', 'CT');        
        $this->db->where('estado', 'ACTIVO');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consultarcn($numero_docu)
    {
        $this->db->select();
        $this->db->from('encabezado');
        $this->db->where('documento_ref', $numero_docu);
        $this->db->where('ref_procesos', 'RC');        
        $this->db->where('estado', 'ACTIVO');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function consultacotd($numerodocu, $numero_docu)
    {
        $this->db->select();
        $this->db->from('detalles');
        $this->db->where('numero_docu', $numerodocu);
        $this->db->where('documento_ref', $numero_docu);        
        $this->db->where('estado', 'ACTIVO');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function cencarc($numero_docu, $ref_procesos)
    {
        $this->db->select('e.numero_docu, e.fechaingreso, e.horaingreso, e.ref_procesos, e.tipo_docu, e.identificacion_paci, e.valor_total, CONCAT(p.primer_nombre, " "'.', p.segundo_nombre, " " '.', p.primer_apellido, " "'.', p.segundo_apellido) AS nombre, p.direccion_paci, CONCAT(p.telefono_paciente, " "'.' ,p.celular_paciente) AS telefonop, p.email_paciente', false);
        $this->db->from('encabezado e');
        $this->db->where('estado', 'ACTIVO');
        $this->db->where('e.ref_procesos', $ref_procesos);
        $this->db->where('e.numero_docu', $numero_docu);
        $this->db->join('pacientes p', 'p.tipo_docu = e.tipo_docu and p.identificacion = e.identificacion_paci');                      
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function cdetarc($numero_docu, $ref_procesos)
    {
        $this->db->select('tipo_abono, codigo_banco, banco, num_cheque, fec_consignacion, autorizacion, valor_abono');
        $this->db->from('detalles');        
        $this->db->where('ref_procesos', $ref_procesos);
        $this->db->where('numero_docu', $numero_docu);       
        $this->db->where('estado', 'ACTIVO');                       
        $query = $this->db->get();        
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function bdcodconsulta($cod_medi)  
    {        
        $this->db->select('e.cod_cons, c.nombre_cons');
        $this->db->from('especialidadxconsulta e');        
        $this->db->join('consulta c', 'c.cod_cons = e.cod_cons');        
        $this->db->where('e.cod_medi', $cod_medi); 
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }
    
    public function convenios()  
    {        
        $this->db->select();
        $this->db->from('contratistas');                
        $this->db->where('activo', 'SI');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }

    // CUPS
    public function consultabdcupsvida($cod_cups, $tipo_docu, $identificacion, $cupsmaxvecesvida)
    {
        $this->db->select();        
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion',$identificacion);
        $this->db->where('cod_cups',$cod_cups);        
        $this->db->from('ciecups');        
        $query = $this->db->get();
        $contarreg  =   $query->num_rows();

        if($contarreg > 0)
        {
            $cupsmaxvecesvida   =   (int)($cupsmaxvecesvida);

            $resultado  =   $cupsmaxvecesvida - $contarreg;
            //var_dump($resultado);
            if($resultado <= 0)
            {
                return 'Este procedimiento ha superado las veces permitido por vida';
            }else
            {
                return '0';
            }
        }else
        {
            return '0';
        }
        
        $query->free_result();       
    }

    public function consultabdcupsvida_exa($cod_cups, $id_paciente, $cupsmaxvecesvida)
    {
        $this->db->select();        
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('cod_cups',$cod_cups);        
        $this->db->from('ciecups');        
        $query = $this->db->get();
        $contarreg  =   $query->num_rows();

        if($contarreg > 0)
        {
            $cupsmaxvecesvida   =   (int)($cupsmaxvecesvida);

            $resultado  =   $cupsmaxvecesvida - $contarreg;
            //var_dump($resultado);
            if($resultado <= 0)
            {
                return 'Este procedimiento ha superado las veces permitido por vida';
            }else
            {
                return '0';
            }
        }else
        {
            return '0';
        }
        
        $query->free_result();       
    }

    public function consultabdcupsdia($cod_cups, $tipo_docu, $identificacion, $cupsmaxvecesdia, $fechaactual)
    {
        $this->db->select();        
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion',$identificacion);
        $this->db->where('cod_cups',$cod_cups);        
        $this->db->from('ciecups');        
        $query = $this->db->get();
        $contarreg  =   $query->num_rows();
        
        if($contarreg > 0)
        {
            foreach ($query->result_array() as $row)
            {

                $fechacups  =   $row['fechaactual'];

                if (strcmp($fechacups,$fechaactual) == 0)
                {                    
                    (int)($cupsmaxvecesdia);
                    $resultado  =   $cupsmaxvecesdia - $contarreg;
                    
                    if($resultado <= 0)
                    {
                        return 'Este procedimiento ha superado las veces permitido por día';
                    }else
                    {
                        return '0';
                    }
                }else
                {
                    return '0';
                }
            }
        }else
        {
            return '0';
        }
        $query->free_result();       
    } 

    public function consultabdcupsdia_exa($cod_cups, $id_paciente, $cupsmaxvecesdia, $fechaactual)
    {
        $this->db->select();        
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('cod_cups',$cod_cups);        
        $this->db->from('ciecups');        
        $query = $this->db->get();
        $contarreg  =   $query->num_rows();
        
        if($contarreg > 0)
        {
            foreach ($query->result_array() as $row)
            {

                $fechacups  =   $row['fechaactual'];

                if (strcmp($fechacups,$fechaactual) == 0)
                {                    
                    (int)($cupsmaxvecesdia);
                    $resultado  =   $cupsmaxvecesdia - $contarreg;
                    
                    if($resultado <= 0)
                    {
                        return 'Este procedimiento ha superado las veces permitido por día';
                    }else
                    {
                        return '0';
                    }
                }else
                {
                    return '0';
                }
            }
        }else
        {
            return '0';
        }
        $query->free_result();       
    } 

    public function consultabdcupslimi($cod_cups, $tipo_docu, $identificacion, $cupstiempolimitedias, $fechaactual)
    {
        $this->db->select_max('fechaactual');
        //$this->db->select();        
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion',$identificacion);
        $this->db->where('cod_cups',$cod_cups);        
        $this->db->from('ciecups');        
        $query = $this->db->get();
        if($query->num_rows() > 0 )
        {
            foreach ($query->result_array() as $row)
            {
                $fechacups              =   $row['fechaactual'];
                if($fechacups == NULL)
                {
                    return '0';
                     
                } else
                {   
                           
                    $datetime1              =   new DateTime($fechaactual);
                    $datetime2              =   new DateTime($fechacups);
                    $interval               =   $datetime2->diff($datetime1);
                    $resfecha               =   $interval->format('%a');
                    $resfecha               =   (int)($resfecha);
                    $cupstiempolimitedias   =   (int)($cupstiempolimitedias)+1;
                    
                    if ($resfecha < $cupstiempolimitedias)
                    {   
                        return 'Este procedimiento no se puede ejecutar con un periodo menor a  '.$cupstiempolimitedias. ' días, desde la ultima vez que se utilizo en este paciente';
                    }else
                    {
                        return '0';
                    }
                }
            }
        }else
        {
            return '0';
            var_dump('vacio');  
        }
        $query->free_result();  
    } 

    public function consultabdcupslimi_exa($cod_cups, $id_paciente, $cupstiempolimitedias, $fechaactual)
    {
        $this->db->select_max('fechaactual');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('cod_cups',$cod_cups);        
        $this->db->from('ciecups');        
        $query = $this->db->get();
        if($query->num_rows() > 0 )
        {
            foreach ($query->result_array() as $row)
            {
                $fechacups              =   $row['fechaactual'];
                if($fechacups == NULL)
                {
                    return '0';
                     
                } else
                {   
                           
                    $datetime1              =   new DateTime($fechaactual);
                    $datetime2              =   new DateTime($fechacups);
                    $interval               =   $datetime2->diff($datetime1);
                    $resfecha               =   $interval->format('%a');
                    $resfecha               =   (int)($resfecha);
                    $cupstiempolimitedias   =   (int)($cupstiempolimitedias)+1;
                    
                    if ($resfecha < $cupstiempolimitedias)
                    {   
                        return 'Este procedimiento no se puede ejecutar con un periodo menor a  '.$cupstiempolimitedias. ' días, desde la ultima vez que se utilizo en este paciente';
                    }else
                    {
                        return '0';
                    }
                }
            }
        }else
        {
            return '0';
            var_dump('vacio');  
        }
        $query->free_result();  
    } 

    public function especialidad()
    {
        $this->db->select();
        $this->db->from('cups_tipoprocedimiento');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();   
    }

        public function conscupscod($abuscar, $contratistas)
    {
        $this->db->select();
        $this->db->like('cod_cups', $abuscar); 
        $this->db->where('id_contratistas', $contratistas);
        $this->db->from('contratistas_cups');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Código no se encuentra en la búsqueda';
        }
        $query->free_result();       
    }

    public function conscupsdes($abuscar, $contratistas)
    {
        $this->db->select();
        $this->db->like('nombre_cups', $abuscar);     
        $this->db->where('id_contratistas', $contratistas);
        $this->db->from('contratistas_cups');           
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Descripción no se encuentra en la búsqueda';
        }
        $query->free_result();       
    }

    public function conscupscodsex($abuscar, $sigla_sexo, $contratistas)
    {
        $names = array('A', $sigla_sexo );
        $this->db->select();
        $this->db->like('cod_cups', $abuscar);  
        $this->db->where('id_contratistas', $contratistas);
        $this->db->where_in('sexo', $names); 
        $this->db->from('contratistas_cups');    
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Código no se encuentra relacionado con el sexo del paciente';
        }
        $query->free_result();       
    }

    public function conscupsdessex($abuscar, $sigla_sexo, $contratistas)
    {
        $names = array('A', $sigla_sexo );
        $this->db->select();
        $this->db->like('nombre_cups', $abuscar);  
        $this->db->where('id_contratistas', $contratistas);
        $this->db->where_in('sexo', $names);  
        $this->db->from('contratistas_cups');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Descripción no se encuentra relacionado con el sexo del paciente';
        }
        $query->free_result();       
    }

    public function conscupscodlim($abuscar, $sigla_sexo, $limiteedad, $contratistas)
    {
        $names = array('A', $sigla_sexo );
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";
        $this->db->select();
        $this->db->like('cod_cups', $abuscar);  
        $this->db->where($ledad);
        $this->db->where('id_contratistas', $contratistas);
        $this->db->where_in('sexo', $names);  
        $this->db->from('contratistas_cups');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Edad no corresponde al código seleccionado';
        }
        $query->free_result();       
    }

    public function conscupsdeslim($abuscar, $sigla_sexo, $limiteedad, $contratistas)
    {
        $names = array('A', $sigla_sexo );
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";
        $this->db->select();
        $this->db->like('nombre_cups', $abuscar);  
        $this->db->where($ledad);
        $this->db->where('id_contratistas', $contratistas);
        $this->db->where_in('sexo', $names); 
        $this->db->from('contratistas_cups');         
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Edad no corresponde a la descripción seleccionada';
        }
        $query->free_result();       
    }

    public function espcupscod($especialidad, $abuscar, $contratistas)
    {
        $this->db->select();
        $this->db->like('cod_cups', $abuscar);
        $this->db->where('cod_cups_tipopro', $especialidad);
        $this->db->where('id_contratistas', $contratistas);
        $this->db->from('contratistas_cups');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Código no encontrado en la especialidad seleccionada';
        }
        $query->free_result();       
    }

    public function espcupsdes($especialidad, $abuscar, $contratistas)
    {
        $this->db->select();
        $this->db->like('nombre_cups', $abuscar);
        $this->db->where('cod_cups_tipopro', $especialidad);
        $this->db->where('id_contratistas', $contratistas);
        $this->db->from('contratistas_cups');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Código no encontrado en la especialidad seleccionada';
        }
        $query->free_result();       
    }

    public function espsexocupscod($sigla_sexo, $abuscar, $especialidad, $contratistas)
    {
        $names = array('A', $sigla_sexo );
                
        $this->db->select();
        $this->db->like('cod_cups', $abuscar);
        $this->db->where('cod_cups_tipopro', $especialidad);
        $this->db->where('id_contratistas', $contratistas);
        $this->db->where_in('sexo', $names);
        $this->db->from('contratistas_cups');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Sexo no esta relacionada con la especialidad del código buscado';
        }
        $query->free_result();       
    }

    public function espsexocupsdes($sigla_sexo, $abuscar, $especialidad, $contratistas)
    {
        $names = array('A', $sigla_sexo );
                
        $this->db->select();
        $this->db->like('nombre_cups', $abuscar);
        $this->db->where('cod_cups_tipopro', $especialidad);
        $this->db->where('id_contratistas', $contratistas);
        $this->db->where_in('sexo', $names);
        $this->db->from('contratistas_cups');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Sexo no esta relacionada con la especialidad en la descripción buscada';
        }
        $query->free_result();       
    }

    public function esplimcupscod($sigla_sexo, $abuscar, $especialidad, $limiteedad, $contratistas)
    {
        $names = array('A', $sigla_sexo );
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";        
        $this->db->select();
        $this->db->like('cod_cups', $abuscar);
        $this->db->where('cod_cups_tipopro', $especialidad);
        $this->db->where($ledad);
        $this->db->where('id_contratistas', $contratistas);
        $this->db->where_in('sexo', $names);
        $this->db->from('contratistas_cups');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Edad no relacionada en la espcialidad del código buscado';
        }
        $query->free_result();       
    }

    public function espslimcupsdes($sigla_sexo, $abuscar, $especialidad, $limiteedad, $contratistas)
    {
        $names = array('A', $sigla_sexo );
        $ledad  =   "limite_inferior <= $limiteedad AND (limite_superior = '0' OR limite_superior >= $limiteedad)";        
        $this->db->select();
        $this->db->like('nombre_cups', $abuscar);
        $this->db->where('cod_cups_tipopro', $especialidad);
        $this->db->where($ledad);
        $this->db->where('id_contratistas', $contratistas);
        $this->db->where_in('sexo', $names);
        $this->db->from('contratistas_cups');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return 'Edad no relacionada en la espcialidad de la especialidad buscada';
        }
        $query->free_result();       
    }


    public function consultaconsecutivo($numero) {
        $data = array();
        $this->db->select('numero_consecutivo');
        $this->db->where('cod_consecutivo', $numero);
        $query = $this->db->get('consecutivos');

        if ($query->num_rows() > 0) {
            $n    = $query->result();
            $data = (int) $n[0]->numero_consecutivo + 1;
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    public function insertExa($data, $n_conexamen) {
        // ACTUALIZA EL EXAMEN EN CONSECUTIVOS
        $cexamen = array(
            'numero_consecutivo' => $n_conexamen,
        );
        $this->db->where('cod_consecutivo', 7);
        $this->db->update('consecutivos', $cexamen);
        return $this->db->insert('pacientes_exa', $data);
    }

    public function insertCieCups($data) {
        return $this->db->insert('ciecups', $data);
    }

    // INSERTAR ENCABEZADO GN
    public function insertarencabezado($datencabezadon)
    {
        return $this->db->insert('encabezado', $datencabezadon);
    }

    public function consultagn($id_paciente)
    {
        $this->db->select();
        $this->db->from('encabezado');        
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('ref_procesos', 'GN');
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();   
    }

    public function updateEncabezadoGN($datencabezadogn, $tipo_docu, $identificacion)
    {                            
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion_paci', $identificacion);
        $this->db->update('encabezado', $datencabezadogn); 
    }

    public function id_paciente($tipo_docu, $identificacion) {
        $data = [];
        $this->db->select('id_paciente');
        $this->db->where('tipo_docu', $tipo_docu);
        $this->db->where('identificacion', $identificacion);
        $query = $this->db->get('pacientes');

        if ($query->num_rows() > 0) {
            $data = $query->row()->id_paciente;
        } else {
            $data = false;
        }

        $query->free_result();
        $this->db->close();
        return $data;
    }

    // CONSULTA CONTROLES
    public function ciexamenn($id_paciente) 
    {

        $this->db->select();
        $this->db->from('pacientes_exa');    
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function resumenagenda($id_paciente)
    {
        $this->db->select();
        $this->db->from('agenda');
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function ingresoencmed($m_enc_medicamentos, $num_formula)
    {
        $nformula = array(
        'numero_consecutivo'    => $num_formula
        );
        $this->db->where('cod_consecutivo', 16);
        $this->db->update('consecutivos', $nformula); 

        // INSERTAR DATOS ENCABEZADO               
        return $this->db->insert('medicamentos_form', $m_enc_medicamentos);   
    }

    public function ingresodetmed($m_det_medicamentos)
    {
        // INSERTAR DATOS ENCABEZADO               
        return $this->db->insert('medicamentos_pac', $m_det_medicamentos);
    }

    public function insertaresencia($nombre, $sintomas, $cualidades, $usos, $afirmacion, $valor)
    {
        if($this->input->post())
        {
            $data = array(
            'nombre'        =>  $nombre,                                
            'sintomas'      =>  $sintomas,
            'cualidades'    =>  $cualidades,
            'usos'          =>  $usos,
            'afirmacion'    =>  $afirmacion,
            'valor'         =>  $valor
            );
            
           // INSERTAR DATOS                
            $this->db->insert('esencias', $data);                       
        }
    }   

    public function modificaresencia($id_esencia, $nombre, $sintomas, $cualidades, $usos, $afirmacion, $valor)
    {
        if($this->input->post())
        {
            $data = array(
            'nombre'        =>  $nombre,                                
            'sintomas'      =>  $sintomas,
            'cualidades'    =>  $cualidades,
            'afirmacion'    =>  $afirmacion,
            'usos'          =>  $usos,
            'valor'         =>  $valor
            );
            
            // MODIFICAR MEDICAMENTOS
            $this->db->where('id_esencia', $id_esencia);
            $this->db->update('esencias', $data);
        }
    }     


    // consulta de pacientes
    public function cmedicopers($cod_medi) {
        $this->db->select();
        $this->db->from('personal');
        $this->db->where('codigo', $cod_medi);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }   

    // consulta historico oftalmologia
    public function cons_hist_oft($id_paciente)
    {
        $this->db->select('id_paciente, fechaactual, num_oftalmologia, cons_examen');
        $this->db->from('pacientes_exa');
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    // consulta historico optometria
    public function cons_hist_opt($id_paciente)
    {
        $this->db->select('id_paciente, fechaactual, num_optometria, cons_examen');
        $this->db->from('pacientes_opt');
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }
    
    
    // consulta historico retinologia
    public function cons_hist_optret($id_paciente)
    {
        $this->db->select('id_paciente, fechaactual, num_retinologia, cons_examen');
        $this->db->from('pacientes_ret');
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    // consulta consentimiento anestesia
    public function cons_cons_ane($id_paciente)
    {
        $this->db->select();
        $this->db->from('consentimientos_asignados');
        $this->db->where('id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function c_cod_medi($id_usuario)
    {
        $this->db->select();
        $this->db->from('medicos');
        $this->db->where('id_usuario', $id_usuario);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();        
    }

    public function lateralidad()
    {
        $this->db->select();
        $this->db->from('tipo_lateralidad');

        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();  
    }    

    // consulta abierta oftalmologia
    public function cons_abierta($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes_exa');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('abierta', 'SI');

        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();           
    }

    // consulta abierta optometria
    public function cons_abierta_optometria($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes_opt');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('abierta', 'SI');

        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();           
    }

    // consulta especialidades de la bd con el tipo_ CONSULTA
    public function especialidad_bd() 
    {
        $this->db->select();
        $this->db->from('listaprecios');
        $this->db->where('cod_lptipo', '2');
        $this->db->order_by('nombre_listap', 'asc');                
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();
    }

    public function permisos($id_usuario, $codprograma)
    {
        $this->db->select();
        $this->db->from('tipo_permisos');   
        $this->db->where('id_usuario',$id_usuario);
        $this->db->where('id_programa', $codprograma);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();  
    }

    // retinologia abierta
    // consulta abierta optometria
    public function cons_abierta_retinologia($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes_ret');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('abierta', 'SI');

        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return $query = array();
        }
        $query->free_result();           
    }


}