<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Imagenes {

	protected $ci;

	public function __construct() {
		$this->ci = &get_instance();
		$this->ci->load->library('s3');
	}

	/**
	 * Codigo de prestador
	 * @return string Codigo de prestador
	 */
	public function prestador() {

		$data = [];
		$this->ci->db->select('codigoprestador');
		$query = $this->ci->db->get('global');
		$data  = $query->row();
		$query->free_result();
		$this->ci->db->close();
		return $data->codigoprestador;

	}

	/**
	 * Upload a amazon s3
	 * @param  string $org_name nombre original del archivo
	 * @param  string $name     nombre final del archivo
	 * @return bool   Subida correcta o erronea
	 */
	public function uploads3($org_name, $name) {

		$path      = "files_tmp/";
		$path_file = $path . $org_name;

		if (isset($org_name) && empty($org_name)) {
			return false;

		} else {

			if (!file_exists($path_file)) {
				return false;
			}

		}

		$input = $this->ci->s3->inputFile($path_file);

		$bucket    = 'histocol';
		$sepext    = explode('.', $org_name);
		$ext       = end($sepext);
		$prestador = $this->prestador();
		$uri       = "{$prestador}/{$name}.{$ext}";

		if ($this->ci->s3->putObject($input, $bucket, $uri, 'private')) {

			if (file_exists($path_file)) {
				unlink($path_file);
			}

			return $uri;
		}

		return false;
	}

	/**
	 * Upload directorio temporal
	 * @param string $name_input Nombre del input file
	 */

	public function Upload($name_input, $path = 'files_tmp/', $name = '') {

		if (!file_exists($path)) {
			mkdir($path, 0777);
		}

		$config['upload_path']   = $path;
		$config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';

		if ($name === '') {
			$config['encrypt_name'] = true;
		} else

		if ($name !== 'original') {
			$config['file_name'] = $name;
		}

		/**
		 * $config['max_size']      = '100';
		 * $config['max_width']     = '1024';
		 * $config['max_height']    = '768';
		 */

		$this->ci->load->library('upload', $config);

		if (!$this->ci->upload->do_upload($name_input)) {
			$erros = [
				'error'         => true,
				'display_error' => $this->ci->upload->display_errors('', ''),
			];
			return $erros;
		} else {

			$data = $this->ci->upload->data();

			if ($data['is_image']) {
				$compressimg = $this->compressImage($data['file_name'], 50, $path);
				$result      = [
					'error'  => false,
					'urlimg' => base_url($path . $compressimg),
				];
				return $result;
			} else {
				$urlimg = $data['file_name'];
				$result = [
					'error'  => false,
					'urlimg' => base_url($path . $urlimg),
				];
				return $result;
			}

		}

	}
	
	public function Upload_firma($name_input, $nombre_archivo, $cp) {

		$config['upload_path']   	= 	$cp;
		$config['allowed_types'] 	= 	'jpg|png|gif|pdf';
		$config['encrypt_name']  	= 	true;
		$config['file_name'] 		= 	$nombre_archivo;

		/**
		 * $config['max_size']      = '100';
		 * $config['max_width']     = '1024';
		 * $config['max_height']    = '768';
		 */

		$this->ci->load->library('upload', $config);

		if (!$this->ci->upload->do_upload($name_input)) {
			return $this->ci->upload->display_errors();
		} else {

			$data = $this->ci->upload->data();

			if ($data['is_image']) {
				return $this->compressImage($data['file_name'], 50);
			} else {
				return $data['file_name'];
			}

		}

	}

	public function Upload_copia($name_input) {

		$config['upload_path']   = 'files_tmp/';
		$config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
		$config['encrypt_name']  = true;

		/**
		 * $config['max_size']      = '100';
		 * $config['max_width']     = '1024';
		 * $config['max_height']    = '768';
		 */

		$this->ci->load->library('upload', $config);

		if (!$this->ci->upload->do_upload($name_input)) {
			return $this->ci->upload->display_errors();
		} else {

			$data = $this->ci->upload->data();

			if ($data['is_image']) {
				return $this->compressImage($data['file_name'], 50);
			} else {
				return $data['file_name'];
			}

		}

	}

	/**
	 * Edwin Palacios @_EdwinPalacios
	 * Base64 a imagen
	 * @param  string $base64 cadena en base 64
	 * @return string url imagen almacenada
	 */
	public function base64_img($base64,$nombre_img, $cp) {

		if (isset($base64) && empty($base64)) {
			return false;
		}

		$path     = $cp;
		$name     = $nombre_img.uniqid() . ".jpg";
		$path_tmp = $path . $name;

		$data = base64_decode($base64);
		file_put_contents($path_tmp, $data);

		return $this->compressImage($name, 50, $cp);

	}

	public function base64_img_copia($base64) {

		if (isset($base64) && empty($base64)) {
			return false;
		}

		$path     = 'files_tmp/';
		$name     = uniqid() . ".jpg";
		$path_tmp = $path . $name;

		$data = base64_decode($base64);
		file_put_contents($path_tmp, $data);

		return $this->compressImage($name, 50);

	}

	/**
	 * Edwin Palacios @_EdwinPalacios
	 * Comprimir imagenes Jpg / Png
	 * @param  string  $name_org  Nombre de la imagen
	 * @param  string  $name_dest Nombre como se va a guardar
	 * @param  integer $quality   Calidad de la imagen
	 * @return string  url donde fue almacenada la imagen optimizada
	 */
	function compressImage($name_org, $quality = 90, $cp) {

		$path       = $cp;
		$source_url = $path . $name_org;

		$info = getimagesize($source_url);

		if ($info['mime'] === 'image/jpeg') {

			$image = imagecreatefromjpeg($source_url);
			imagejpeg($image, $source_url, $quality);
			imagedestroy($image);

		} else

		if ($info['mime'] === 'image/png') {

			$image = imagecreatefrompng($source_url);
			imageAlphaBlending($image, true);
			imageSaveAlpha($image, true);
			$png_quality = 9 - (($quality * 9) / 100);
			imagePng($image, $source_url, $png_quality);
			imagedestroy($image);

		}

		return $name_org;
	}

	function compressImage_copia($name_org, $quality = 90) {

		$path       = 'files_tmp/';
		$source_url = $path . $name_org;

		$info = getimagesize($source_url);

		if ($info['mime'] === 'image/jpeg') {

			$image = imagecreatefromjpeg($source_url);
			imagejpeg($image, $source_url, $quality);
			imagedestroy($image);

		} else

		if ($info['mime'] === 'image/png') {

			$image = imagecreatefrompng($source_url);
			imageAlphaBlending($image, true);
			imageSaveAlpha($image, true);
			$png_quality = 9 - (($quality * 9) / 100);
			imagePng($image, $source_url, $png_quality);
			imagedestroy($image);

		}

		return $name_org;
	}

}
