<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    // Incluimos el archivo fpdf
    require_once APPPATH."/third_party/fpdf/fpdf.php";
 
    //Extendemos la clase Pdf de la clase fpdf para que herede todas sus variables y funciones
    class Pdf extends FPDF {
        public function __construct() {
            parent::__construct();
            
        }
        // El encabezado del PDF
        
        public function Header()
        {    
            $logoempresa    =   base_url('img/logoempresa.png');
            $this->Image($logoempresa,5,5,0,25);
            
            // DATOS DE TEXTO
            $this->SetXY(110,5);
            $this->SetX(120);
            $this->Cell(10,4,'Paciente:',0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->npaciente),0,0,'L');
            
            
            $this->SetX(190);
            $this->Cell(10,4,'CT',0,0,'L');
            $this->SetX(201);
            $this->Cell(10,4,$this->numero_docu,0,0,'L');
            
            $this->Ln(4);
           
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('Dir.:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->cdireccion_paci),0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('Tel.:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->ctelefonop),0,0,'L');
            $this->SetX(175);
            //$this->Cell(10,4,'Fecha:',0,0,'L');
            $this->SetX(186);
            $this->Cell(10,4,$this->cfechaingreso,0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('email:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->cemail_paciente),0,0,'L');
            $this->SetX(175);
            //$this->Cell(10,4,'Hora:',0,0,'L');
            $this->SetX(186);
            $this->Cell(10,4,$this->choraingreso,0,0,'L');
            $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'C');
            $this->Ln(4);
        
            $this->SetX(180);
    
            $this->SetXY(110,30);
            $this->SetX(5);
            $this->Cell(10,4,utf8_decode('Datos del recibo de caja'),0,0,'L');
            
            $this->Ln(5);
            
            $this->Cell(30, 5, 'Tipo Abono', 1, 0, 'C', 0);
            $this->Cell(60, 5, 'Banco', 1, 0, 'C', 1);        
            $this->Cell(20, 5, '# Cheque', 1, 0, 'C', 1);
            $this->Cell(30, 5, 'Fecha Cons', 1, 0, 'C', 1);
            $this->Cell(30, 5, utf8_decode('Autorización'), 1, 0, 'C', 1);
            $this->Cell(20, 5, 'Monto', 1, 0, 'C', 0);
            
            $this->SetFillColor(255, 255, 255);
            $this->Ln(5);
       }
       
       public function datospaciente($cpaciente, $numero_docu, $cdireccion_paci, $ctelefonop, $cfechaingreso, $cemail_paciente, $choraingreso, $cdetarc)
       {
        $y  =   5;
        $this->SetY($y);
        
        $this->SetX(120);
            
            
            
        $this->SetX(120);
        $this->Cell(10,4,'Paciente:',0,0,'L');
        $this->SetX(135);
        $this->Cell(20,4,utf8_decode($cpaciente),0,0,'L');
        $this->SetX(190);
        $this->Cell(10,4,'RC',0,0,'L');
        $this->SetX(201);
        $this->Cell(10,4,$numero_docu,0,0,'L');
        
        $this->Ln(4);
       
        
        $this->SetX(120);
        $this->Cell(10,4,utf8_decode('Dir.:'),0,0,'L');
        $this->SetX(135);
        $this->Cell(20,4,utf8_decode($cdireccion_paci),0,0,'L');
        
        $this->Ln(4);
        
        $this->SetX(120);
        $this->Cell(10,4,utf8_decode('Tel.:'),0,0,'L');
        $this->SetX(135);
        $this->Cell(20,4,utf8_decode($ctelefonop),0,0,'L');
        $this->SetX(175);
        //$this->Cell(10,4,'Fecha:',0,0,'L');
        $this->SetX(186);
        $this->Cell(10,4,$cfechaingreso,0,0,'L');
        
        $this->Ln(4);
        
        $this->SetX(120);
        $this->Cell(10,4,utf8_decode('email:'),0,0,'L');
        $this->SetX(135);
        $this->Cell(20,4,utf8_decode($cemail_paciente),0,0,'L');
        $this->SetX(175);
        //$this->Cell(10,4,'Hora:',0,0,'L');
        $this->SetX(186);
        $this->Cell(10,4,$choraingreso,0,0,'L');
        $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'C');
        $this->Ln(4);
    
        $this->SetX(175);

        $this->SetXY(110,30);
        $this->SetX(5);
        $this->Cell(10,4,utf8_decode('Datos del recibo de caja'),0,0,'L');
        //$this->SetX(5);
        $this->Ln(5);
        $this->Cell(30, 5, 'Tipo Abono', 1, 0, 'C', 1);
        $this->Cell(60, 5, 'Banco', 1, 0, 'C', 1);        
        $this->Cell(20, 5, '# Cheque', 1, 0, 'C', 1);
        $this->Cell(30, 5, 'Fecha Cons', 1, 0, 'C', 1);
        $this->Cell(30, 5, utf8_decode('Autorización'), 1, 0, 'C', 1);
        $this->Cell(20, 5, 'Monto', 1, 0, 'C', 1);
        
        $this->SetFillColor(255, 255, 255);
        
        
      
        foreach ($cdetarc as $row) 
            {
                
                $this->Ln(4);            
                $this->Cell(30, 4, utf8_decode($row['tipo_abono']), 1, 0, 'L', 1);
                $this->Cell(60, 4, utf8_decode($row['banco']), 1, 0, 'L', 1);            
                $this->Cell(20, 4, $row['num_cheque'], 1, 0, 'R', 1);
                $fechacons  =   $row['fec_consignacion'];
                if( $fechacons == '0000-00-00')
                {
                    $fechacons  =   '';
                }
                else
                {
                    $fechacons  =   $fechacons;
                }
                $this->Cell(30, 4, $fechacons, 1, 0, 'R', 1);
                $this->Cell(30, 4, $row['autorizacion'], 1, 0, 'R', 1);
                $this->Cell(20, 4, number_format($row['valor_abono']), 1, 0, 'R', 1);
                
                
            }
         $this->Ln(5);   
        
       }
       
        
       // El pie del pdf
       public function Footer(){
        //   $this->SetY(-15);
//           $this->SetFont('Arial','I',8);
//           $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
      }
      
      
    }
?>