<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    // Incluimos el archivo fpdf
    require_once APPPATH."/third_party/fpdf/fpdf.php";
 
    //Extendemos la clase Pdf de la clase fpdf para que herede todas sus variables y funciones
    class Pdfcotizacion extends FPDF {
        public function __construct() {
            parent::__construct();
        }
        
        public function Header()
        {    
            $logoempresa    =   base_url('img/logoempresa.png');
            $this->Image($logoempresa,5,5,0,25);
            
            $this->SetXY(110,5);
            $this->SetX(120);
            $this->Cell(10,4,'Paciente:',0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->npaciente),0,0,'L');
            
            
            $this->SetX(184);
            $this->Cell(10,4,utf8_decode('Historia:'),0,0,'L');
            $this->SetX(198);
            $this->Cell(10,4,$this->idhistoria,0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('Dir.:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->cdireccion_paci),0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('Tel.:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->ctelefonop),0,0,'L');
            $this->SetX(175);
    
            $this->SetX(184);
            $this->Cell(10,4,$this->fecha,0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('email:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->cemail_paciente),0,0,'L');
            $this->SetX(175);
    
            $this->SetX(184);
            $this->Cell(10,4,$this->hora,0,0,'L');
            $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'C');
            $this->Ln(4);
        
    
    
            $this->SetXY(110,30);
            $this->SetX(5);
            $this->Cell(35,4,utf8_decode('Cotización del tratamiento'),0,0,'L');

            $this->Ln(5);
       }
       
       public function datospaciente($npaciente, $num_odon, $pacdireccion, $pactelefono,  $email,  $idhistoria, $codetalles, $ccotros, $ccprocesos, $ccunificar, $ccremisiones)
       {
            $this->SetXY(110,5);
            $this->SetX(120);
            $this->Cell(10,4,'Paciente:',0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->npaciente),0,0,'L');
            
            
            $this->SetX(184);
            $this->Cell(10,4,utf8_decode('Historia:'),0,0,'L');
            $this->SetX(198);
            $this->Cell(10,4,$this->idhistoria,0,0,'L');
            
            $this->Ln(4);
           
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('Dir.:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->cdireccion_paci),0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('Tel.:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->ctelefonop),0,0,'L');
            $this->SetX(175);
            //$this->Cell(10,4,'Fecha:',0,0,'L');
            $this->SetX(184);
            $this->Cell(10,4,$this->fecha,0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('email:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->cemail_paciente),0,0,'L');
            $this->SetX(175);

            $this->SetX(184);
            $this->Cell(10,4,$this->hora,0,0,'L');
            $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'C');
            $this->Ln(4);
        

    
            $this->SetXY(110,30);
            $this->SetX(5);
            $this->Cell(35,4,utf8_decode('Cotización del tratamiento'),0,0,'L');

            $this->Ln(5);

        if($codetalles)
        {
            foreach ($codetalles as $row) 
            {
                $this->Cell(10, 5, 'Diente', 1, 0, 'C', 1);
                $this->Cell(50, 5, 'Superficies', 1, 0, 'C', 1);
                $this->Cell(133, 5, utf8_decode('Valoración'), 1, 0, 'C', 1);
                
                $this->SetWidths(array(10,50,133));
                srand(microtime()*1000000);   
                $this->SetAligns(array('C','L','J'));
                //$this->SetX(10); 
                
                $diente         =   utf8_decode($row['cod_pieza']);
                $superficie     =   trim(utf8_decode($row['cod_cara']));
                $conteocop      =   trim($row['conteocop']);
                $valoracion     =   utf8_decode($row['valoracioncop']);
                $y = $this->GetY();
                $this->Ln();  
                
                // OTROS SUPERFICIES
                $this->Row(array($diente, $superficie, $valoracion));  
//                
                
                // PROCESOS LISTA DE PRECIOS   
                if($ccprocesos)
                {
                    foreach($ccprocesos as $ccpro)
                    {
                        $copdiente  =   $ccpro['copdiente'];
                        $copconteo  =   $ccpro['copconteo'];
                        if($copdiente == $diente && $copconteo == $conteocop)
                        {
                            $copconvnom =   $ccpro['copconvnom'];
                            $copconvobs =   $ccpro['copconvobs'];
                             
                            $this->SetAligns(array('J','J'));
                            $this->Cell(60, 5, 'Tratamiento', 1, 0, 'C', 1);
                            $this->Cell(133, 5, utf8_decode('Observaciones tratamiento'), 1, 0, 'C', 1);  
                            
                            $this->SetWidths(array(60,133));
                            srand(microtime()*1000000);          
                            $y = $this->GetY();
                            $this->Ln();       
                            $this->Row(array($copconvnom, $copconvobs));
                        }
                        
                    }
                }  
                
                // UNIFICACION
                if($ccunificar)
                {
                    foreach($ccunificar as $ccuni)
                    {
                        $udiente    =   $ccuni['udiente'];
                        $uconteo    =   $ccuni['uconteo'];
                        if($udiente == $diente && $uconteo == $conteocop)
                        {
                            $udientecon     =   $ccuni['udientecon'];
                            $uobservaciones =   $ccuni['uobservaciones'];
                            
                            $this->SetAligns(array('C','J'));
                            $this->Cell(30, 5, 'Diente unificado', 1, 0, 'C', 1);
                            $this->Cell(163, 5, utf8_decode('Observaciones unificación'), 1, 0, 'C', 1);                

                            $this->SetWidths(array(30,163));
                            srand(microtime()*1000000);   
                            $y = $this->GetY();
                            $this->Ln();   
                            $this->Row(array($udientecon, $uobservaciones));
                        }
                    }
                }   
                
                // REMISIONES
                if($ccremisiones)
                {
                    foreach($ccremisiones as $ccrem)
                    {
                        $rdiente    =   $ccrem['rdiente'];
                        $rconteo    =   $ccrem['rconteo'];
                        if($rdiente == $diente && $rconteo == $conteocop)
                        {
                            $rendodoncia    =   $ccrem['rendodoncia'];
                            $rortodoncia    =   $ccrem['rortodoncia'];
                            $rperiodoncia   =   $ccrem['rperiodoncia'];
                            $rcirugia       =   $ccrem['rcirugia'];
                            $robservaciones =   $ccrem['robservaciones'];
                            
                            $this->SetAligns(array('J','J'));
                            $this->Cell(60, 5, utf8_decode('Proceso remisión'), 1, 0, 'C', 1);
                            $this->Cell(133, 5, utf8_decode('Observaciones remisión'), 1, 0, 'C', 1);
                                                        
                            $this->SetWidths(array(60,133));
                            srand(microtime()*1000000);   
                            $y = $this->GetY();
                            $this->Ln();                
                            $this->Row(array(trim($rendodoncia.' '.$rortodoncia.' '.$rperiodoncia.' '.$rcirugia), $robservaciones));
                        }
                        
                    }
                }  
                
                    $this->Ln();         
            }
        }            
        
       }
       
       public function cuerpo2($npaciente, $num_odon, $pacdireccion, $pactelefono,  $email,  $idhistoria, $idetalles)
       {
            $this->SetXY(110,5);
            $this->SetX(120);
            $this->Cell(10,4,'Paciente:',0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->npaciente),0,0,'L');
            
            
            $this->SetX(184);
            $this->Cell(10,4,utf8_decode('Historia:'),0,0,'L');
            $this->SetX(198);
            $this->Cell(10,4,$this->idhistoria,0,0,'L');
            
            $this->Ln(4);
           
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('Dir.:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->cdireccion_paci),0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('Tel.:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->ctelefonop),0,0,'L');
            $this->SetX(175);
            //$this->Cell(10,4,'Fecha:',0,0,'L');
            $this->SetX(184);
            $this->Cell(10,4,$this->fecha,0,0,'L');
            
            $this->Ln(4);
            
            $this->SetX(120);
            $this->Cell(10,4,utf8_decode('email:'),0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->cemail_paciente),0,0,'L');
            $this->SetX(175);

            $this->SetX(184);
            $this->Cell(10,4,$this->hora,0,0,'L');
            $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'C');
            $this->Ln(4);
        

    
            $this->SetXY(110,30);
            $this->SetX(5);
            $this->Cell(35,4,utf8_decode('Cotización del tratamiento'),0,0,'L');

            $this->Ln(5);
            $this->Cell(8, 5, 'Die.', 1, 0, 'C', 1);
            $this->Cell(25, 5, 'Superficies', 1, 0, 'C', 1);
            $this->Cell(28, 5, utf8_decode('Valoración'), 1, 0, 'C', 1);
            $this->Cell(28, 5, utf8_decode('Procedimiento'), 1, 0, 'C', 1);
            $this->Cell(28, 5, utf8_decode('Ob Procedimiento'), 1, 0, 'C', 1);
            $this->Cell(28, 5, utf8_decode('Unificar'), 1, 0, 'C', 1);
            $this->Cell(28, 5, utf8_decode('Remisión'), 1, 0, 'C', 1);
            $this->Cell(20, 5, utf8_decode('Valor'), 1, 0, 'C', 1);
            $this->Ln();
        if($idetalles)
        {
            foreach ($idetalles as $row) 
            {
                
                
                $this->SetWidths(array(8,25,28,28,28,28,28,20));
                srand(microtime()*1000000);   
                $this->SetAligns(array('C','L','J','J','J','J','J','R'));
                //$this->SetX(10); 
                
                $diente             =   utf8_decode($row['cod_pieza']);
                $superficie         =   trim(utf8_decode($row['cod_cara']));                
                $valoracion         =   utf8_decode($row['valoracioncop']);
                $procedimiento      =   utf8_decode($row['copconvnom']);
                $obprocedimiento    =   utf8_decode($row['copconvobs']);
                $unificar           =   utf8_decode($row['udientecon'].' '.$row['uobservaciones']);
                $remision           =   utf8_decode($row['rendodoncia'].' '.$row['rortodoncia'].' '.$row['rperiodoncia'].' '.$row['rcirugia'].' '.$row['robservaciones']);
                $valor              =   number_format($row['valorcop']);
                
                $y = $this->GetY();
                  
                $this->Row(array($diente,$superficie,$valoracion,$procedimiento,$obprocedimiento,$unificar,$remision,$valor));
                //$this->Ln();         
            }
        }            
        
       }
       // El pie del pdf
       public function Footer(){
        //   $this->SetY(-15);
//           $this->SetFont('Arial','I',8);
//           $this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
      }
      
      
    }
?>