<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
    // Incluimos el archivo fpdf
    require_once APPPATH."/third_party/fpdf/fpdf.php";
 
    //Extendemos la clase Pdf de la clase fpdf para que herede todas sus variables y funciones
    class Pdfformula extends FPDF {
        public function __construct() {
            parent::__construct();
            
        }
        // El encabezado del PDF
        
        public function Header()
        {    
            $logoempresa    =   base_url('img/logoempresa.png');
            $this->Image($logoempresa,5,5,0,25);
            
            $this->SetXY(110,5);
            $this->SetX(120);
            $this->Cell(10,4,'Paciente:',0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->paciente),0,0,'L');
            
            
            $this->SetX(184);
            $this->Cell(10,4,utf8_decode('Formula:'),0,0,'L');
            $this->SetX(198);
            $this->Cell(10,4,$this->formula,0,0,'L');
            
            $this->Ln(4);           
            $this->SetX(184);
            $this->Cell(10,4,$this->fecha,0,0,'L');
            
            $this->Ln(4);
            $this->SetX(184);
            $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'C');
            
            $this->Ln(4);
            $this->SetXY(110,30);
            $this->SetX(5);
            $this->Cell(35,4,utf8_decode('Medicamentos'),0,0,'L');

            $this->Ln(5);
            $this->Cell(45, 5, 'Medicamento.', 1, 0, 'C', 1);
            $this->Cell(5, 5, 'Cantidad', 1, 0, 'C', 1);
            $this->Cell(45, 5, utf8_decode('Prescripción'), 1, 0, 'C', 1);
            
            $this->Ln();
       }
       
       public function cuerpo($detalles)
       {
            $this->SetXY(110,5);
            $this->SetX(120);
            $this->Cell(10,4,'Paciente:',0,0,'L');
            $this->SetX(135);
            $this->Cell(20,4,utf8_decode($this->paciente),0,0,'L');
            
            
            $this->SetX(184);
            $this->Cell(10,4,utf8_decode('Formula:'),0,0,'L');
            $this->SetX(198);
            $this->Cell(10,4,$this->formula,0,0,'L');
            
            $this->Ln(4);           
            $this->SetX(184);
            $this->Cell(10,4,$this->fecha,0,0,'L');
            
            $this->Ln(4);
            $this->SetX(184);            
            $this->Cell(0,10,utf8_decode('Página ').$this->PageNo().'/{nb}',0,0,'C');
            
            $this->Ln(4);
            $this->SetXY(110,30);
            $this->SetX(5);
            $this->Cell(35,4,utf8_decode('Medicamentos'),0,0,'L');

            $this->Ln(5);
            $this->Cell(85, 5, 'Medicamento.', 1, 0, 'C', 1);
            $this->Cell(15, 5, 'Cantidad', 1, 0, 'C', 1);
            $this->Cell(90, 5, utf8_decode('Prescripción'), 1, 0, 'C', 1);
            
            $this->Ln();
        if($detalles)
        {
            foreach ($detalles as $row) 
            {   
                $this->SetWidths(array(85,15,90));
                srand(microtime()*1000000);   
                $this->SetAligns(array('J','R','J'));
                
                
                $medicamento    =   utf8_decode($row['medicamento']);
                $cantidad       =   number_format($row['cantidad']);                
                $prescripcion   =   utf8_decode($row['prescripcion']);
                
                
                $y = $this->GetY();
                  
                $this->Row(array($medicamento,$cantidad,$prescripcion));
                       
            }
        }            
    }       
       
       
      
       
    public function Footer()
    {
      
    }
      
      
    }
?>