<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Contratista_model extends CI_Model
{    
	public function __construct()
    {
        parent::__construct();        
        $this->load->library('consecutivo'); 	        
    }

    public function administradoras()
    {
        $this->db->select();
        $this->db->from('administradoras');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function contratistas()
    {
        $this->db->select();
        $this->db->from('contratistas');  
        $this->db->order_by('nombre_admi');  
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();   
    }

    public function convenio()
    {
        $this->db->select();
        $this->db->from('contratistas_convenio');        
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }

    public function ingresocontratista($contratista)
    {
        return $this->db->insert('contratistas', $contratista);
        $this->db->close();
    }

    public function  actualizarcontratista($id_contratistas, $contratista)
    {
        $this->db->where('id_contratistas', $id_contratistas);
        $this->db->update('contratistas', $contratista);
        $this->db->close();
    }

    public function con_cups($id_contratistas)
    {
        $this->db->select();
        $this->db->from('contratistas_cups');        
        $this->db->where('id_contratistas', $id_contratistas);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();      
    }

    public function eliminarDetalles($id_contratistas)
    {
        // BORRADO DE LOS CUPS X CONTRATO DEPENDEN DE ID
        $this->db->where('id_contratistas', $id_contratistas);
        $this->db->delete('contratistas_cups');
    }

    public function insertDetalles($o_detalles)
    {
        // INGRESO DE LOS NUEVOS ITEMS AL CONTRATO
        return $this->db->insert('contratistas_cups', $o_detalles); 
        $this->db->close();
    }

    public function updateDetalles($o_detalles, $id_cups)
    {
        // actualizar cups del contratista o eps
        $this->db->where('id_cups', $id_cups);
        $this->db->update('contratistas_cups', $o_detalles);
        $this->db->close();
    }

    public function insertNewCups($m_nuevo_cups)
    {
        // ingreso nuevo cups a la bd de cups
        return $this->db->insert('cups', $m_nuevo_cups);
        $this->db->close();
    }

    public function cons_cups($cod_cups, $id_contratista)
    {
        $this->db->select();
        $this->db->from('contratistas_cups');        
        $this->db->where('id_contratistas', $id_contratista);
        $this->db->where('cod_cups', $cod_cups);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return false;
        }
        $query->free_result();      
    }

    public function cons_cups_general($cod_cups)
    {
        $this->db->select();
        $this->db->from('cups');        
        $this->db->where('cod_cups', $cod_cups);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return true;
        }else
        {
            return false;
        }
        $query->free_result();      
    }

    public function cons_id($cod_cups)
    {
        $this->db->select('id_cups');
        $this->db->from('cups');        
        $this->db->where('cod_cups', $cod_cups);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            $row = $query->row();
            return $row->id_cups;
        }else
        {
            return false;
        }
        $query->free_result();
    }
}