<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Modulos_model extends CI_Model
{
	public function __construct()
    {
        parent::__construct();	
        $this->load->library('Session');	        
    }
	
	public function consultamodulo($ruta)
    {
        $ruta = trim($ruta);
        $this->db->select();
        $this->db->from('modulos');
        $this->db->where('ruta', $ruta);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
    
    public function msecciones($nivel_usuario, $modelo)
	{      
        $this->db->distinct();
        $this->db->select('s.nombre as nsecciones, s.codseccion');
        $this->db->from('nuxprograma u');
        $this->db->join('secciones s', 's.codseccion = u.codseccion AND u.codmodulos = s.codmodulos');        
        $this->db->where('u.nivel_usuario', $nivel_usuario);
        $this->db->where('u.codmodulos', $modelo);   
        $this->db->order_by('s.codseccion');         
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();		            		
	}   
    
    public function menumodelo($nivel_usuario, $modelo)
	{      
        $this->db->select('u.*, p.programa as nprograma, p.nombre as nprogramas, p.descripcion as dprogramas, m.descripcion as dmodulos, s.nombre as nsecciones,p.ruta, p.vistav, p.vistafv, p.vistatablav, p.imagen');
        $this->db->from('nuxprograma u');
        //$this->db->join('nivelusuario n', 'n.nivel_usuario = u.nivel_usuario');
        $this->db->join('programas p', 'p.id = u.codprograma');
        $this->db->join('modulos m', 'm.codmodulos = u.codmodulos');
        $this->db->join('secciones s', 's.codseccion = u.codseccion AND m.codmodulos = s.codmodulos ');        
        $this->db->where('u.nivel_usuario', $nivel_usuario);
        $this->db->where('u.codmodulos', $modelo);
        $this->db->order_by('u.orden');            
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();		            		
	}    
 }