<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Reportes_model extends CI_Model
{    
	public function __construct()
    {
        parent::__construct();       
    }

    // resumen general
    // reportes de oftalmologia
    public function c_oftalmologia($id_paciente) 
    {

        $this->db->select('e.*, co.nombre_cons, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi, con.nom_consultorio, ct.nombre_admi, lp.nombre_listap');
        $this->db->from('pacientes_exa e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons', 'left outer');   
        $this->db->join('medicos m', 'm.cod_medi = e.cod_medi', 'left outer');         
        $this->db->join('consultorios con', 'con.cod_consultorio = e.cod_consultorio', 'left outer');  
        $this->db->join('contratistas ct', 'ct.id_contratistas = e.id_admi', 'left outer');  
        $this->db->join('listaprecios lp', 'lp.cod_listap = e.tipo_co', 'left outer');  
        $this->db->where('e.id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    // historia clinica optometria
    public function c_optometria($id_paciente) 
    {

        $this->db->select('e.*, co.nombre_cons, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi, con.nom_consultorio, ct.nombre_admi, lp.nombre_listap');
        $this->db->from('pacientes_opt e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons', 'left outer');   
        $this->db->join('medicos m', 'm.cod_medi = e.cod_medi', 'left outer');         
        $this->db->join('consultorios con', 'con.cod_consultorio = e.cod_consultorio', 'left outer');  
        $this->db->join('contratistas ct', 'ct.id_contratistas = e.id_admi', 'left outer');  
        $this->db->join('listaprecios lp', 'lp.cod_listap = e.tipo_co', 'left outer');  
        $this->db->where('e.id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    // historia clinica retinologia
    public function c_retinologia($id_paciente) 
    {

        $this->db->select('e.*, co.nombre_cons, m.primer_nombre_medi, m.segundo_nombre_medi, m.primer_apellido_medi, m.segundo_apellido_medi, con.nom_consultorio, ct.nombre_admi, lp.nombre_listap');
        $this->db->from('pacientes_ret e');    
        $this->db->join('consulta co', 'co.cod_cons = e.cod_cons', 'left outer');   
        $this->db->join('medicos m', 'm.cod_medi = e.cod_medi', 'left outer');         
        $this->db->join('consultorios con', 'con.cod_consultorio = e.cod_consultorio', 'left outer');  
        $this->db->join('contratistas ct', 'ct.id_contratistas = e.id_admi', 'left outer');  
        $this->db->join('listaprecios lp', 'lp.cod_listap = e.tipo_co', 'left outer');  
        $this->db->where('e.id_paciente', $id_paciente);
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function cicups($id_paciente) 
    {
        $this->db->select('c.*, c.nombre_cups, ac.nombre_actoq, fi.nombre_fina, am.nombre_ambi, tl.nombre_lateralidad');
        $this->db->from('ciecups c');
        //$this->db->join('cups cu', 'cu.cod_cups = c.cod_cups');
        $this->db->join('actoquirurgico ac', 'ac.cod_actoq = c.cod_actoq', 'left outer');
        $this->db->join('finalidad fi', 'fi.id_finalidad = c.id_finalidad and fi.cod_tipo_fina = "2"');
        $this->db->join('tipo_lateralidad tl', 'tl.id_lateralidad = c.lateralidad');
        $this->db->join('ambito am', 'am.cod_ambi = c.cod_ambi');
        $this->db->where('c.id_paciente', $id_paciente);
        $this->db->where('c.activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function ciexamenciemas($id_paciente) 
    {
        $this->db->select('c.*, cie.nombre_cie as nombre_ciemas');
        $this->db->from('ciecups c');
        $this->db->join('cie10 cie', 'cie.cod_cie = c.cod_ciemas');
        $this->db->join('causa_diagnostico cd', 'cd.cod_causa_dia = c.cod_causa_dia');
        $this->db->join('finalidad  fi', 'fi.cod_fina = c.cod_fina_cie AND fi.cod_tipo_fina = "1" ');
        $this->db->join('consulta co', 'co.cod_cons = c.cod_cons');
        $this->db->join('tipo ti', 'ti.cod_tipo = c.cod_tipo');
        $this->db->where('c.id_paciente', $id_paciente);
        $this->db->where('c.activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    // paraclinicos
    public function paraclinicos($id_paciente)
    {
        $this->db->select();
        $this->db->from('pacientes_para');    
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    // medicamentos
    public function cimedicamentos($id_paciente) 
    {
        $this->db->select();
        $this->db->from('pacientes_med');
        $this->db->where('id_paciente', $id_paciente);
        $this->db->where('activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    // consulta firma del medico
    public function c_f_medico()
    {
        $this->db->select();
        $this->db->from('medicos');    
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }
    
    public function ciexamencie($id_paciente) 
    {
        $this->db->select('c.*, cie.nombre_cie, cd.nombre_causa_dia, fi.nombre_fina, co.nombre_cons, ti.nombre_tipo, cier.nombre_cie as nombre_cier, ciers.nombre_cie as nombre_ciers, cierr.nombre_cie as nombre_cierr');
        $this->db->from('ciecups c');
        $this->db->join('cie10 cie', 'cie.cod_cie = c.cod_cie ');
        $this->db->join('cie10 cier', 'cier.cod_cie = c.cod_cier', 'left outer');
        $this->db->join('cie10 ciers', 'ciers.cod_cie = c.cod_ciers', 'left outer');
        $this->db->join('cie10 cierr', 'cierr.cod_cie = c.cod_cierr', 'left outer');
        $this->db->join('causa_diagnostico cd', 'cd.cod_causa_dia = c.cod_causa_dia');
        $this->db->join('finalidad  fi', 'fi.cod_fina = c.cod_fina_cie AND fi.cod_tipo_fina = "1" ');
        $this->db->join('consulta co', 'co.cod_cons = c.cod_cons', 'left outer');
        $this->db->join('tipo ti', 'ti.cod_tipo = c.cod_tipo', 'left outer');
        $this->db->where('c.id_paciente', $id_paciente);
        $this->db->where('c.activo', 'SI');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function prestador() {
        $this->db->select();
        $this->db->from('global');
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }

    public function cipaciente_v($id_paciente)
    {
        $this->db->select('p.*, td.nombre_tipo_docu, sx.nombre_sexo, pa.nombre_pais, de.nombre_depa, mu.nombre_muni,  
        ec.nombre_estado_civi, zr.nombre_zona_resi, tu.nombre_tipo_usua');
        $this->db->from('pacientes p');
        $this->db->join('tipo_documento td', 'td.tipo_docu = p.tipo_docu');  
        $this->db->join('sexo sx', 'sx.sigla_sexo = p.sigla_sexo');
        $this->db->join('paises pa', 'pa.cod_pais = p.cod_pais');
        $this->db->join('departamento de', ' de.id_depa = p.id_depa');
        $this->db->join('municipio mu', 'mu.id_depa = p.id_depa AND mu.id_muni = p.id_muni');
        $this->db->join('estadocivil ec', 'ec.cod_estado_civi = p.cod_estado_civi');
        $this->db->join('zona_residencia zr', 'zr.cod_zona_resi = p.cod_zona_resi');
        $this->db->join('tipo_usuario tu', 'tu.cod_tipo_usua = p.cod_tipo_usua');
        
        $this->db->where('p.id_paciente', $id_paciente);              
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result();
        }else
        {
            return false;
        }
        $query->free_result(); 
    }

    public function consulta_global()
    {
        $this->db->select();
        $this->db->from('global');    
        $query = $this->db->get();

        if ($query->num_rows() > 0) {
            return $query->result_array();
        } else {
            return false;
        }

        $query->free_result();
    }   

    //// fin ////

    
}