<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');
 
class Rips_model extends CI_Model
{    
	public function __construct()
    {
        parent::__construct();        	        
    }
    
    public function consulta($fechainicial, $fechafinal)
    {
        $this->db->select('cc.*, p.tipo_docu, p.identificacion, p.cod_tipo_usua, p.primer_apellido, p.segundo_apellido, p.primer_nombre, p.segundo_nombre, p.sigla_sexo, p.id_depa, p.id_muni, p.id_muni, p.cod_zona_resi, m.tipo_docu as tipo_docu_medi, m.identificacion_medi, m.primer_apellido_medi, m.segundo_apellido_medi, m.primer_nombre_medi, m.segundo_nombre_medi, a.nombre_admi, f.cod_fina');
        $this->db->from('odontograma_ciecupsdef cc'); 
        $this->db->join('medicos m', 'm.cod_medi = cc.cod_medi'); 
        $this->db->join('pacientes p', 'p.id_paciente = cc.id_paciente');
        $this->db->join('administradoras a','a.id_admi = cc.id_admi');
        $this->db->join('finalidad f','f.id_finalidad = cc.id_finalidad');      
        $this->db->where('cc.fechaactual >=', $fechainicial);
        $this->db->where('cc.fechaactual <=', $fechafinal);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }

    public function cons_consulta($fechainicial, $fechafinal)
    {
        $this->db->select('cc.*, p.tipo_docu, p.identificacion, p.cod_tipo_usua, p.primer_apellido, p.segundo_apellido, p.primer_nombre, p.segundo_nombre, p.sigla_sexo, p.id_depa, p.id_muni, p.id_muni, p.cod_zona_resi, m.tipo_docu as tipo_docu_medi, m.identificacion_medi, m.primer_apellido_medi, m.segundo_apellido_medi, m.primer_nombre_medi, m.segundo_nombre_medi, a.nombre_admi');
        $this->db->from('odontograma_ciecupsdef cc'); 
        $this->db->join('medicos m', 'm.cod_medi = cc.cod_medi'); 
        $this->db->join('pacientes p', 'p.id_paciente = cc.id_paciente');
        $this->db->join('administradoras a','a.id_admi = cc.id_admi');
        //$this->db->join('finalidad f','f.id_finalidad = cc.id_finalidad');      
        $this->db->where('cc.fechaactual >=', $fechainicial);
        $this->db->where('cc.fechaactual <=', $fechafinal);
        $this->db->where('cc.cod_fina_cie >', 0);
        $query = $this->db->get();
        if($query->num_rows() > 0)
        {
            return $query->result_array();
        }else
        {
            return false;
        }
        $query->free_result();
    }
}