<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
    <div class="well well-sm text-center">
        <h4><strong class="text-info" id="titulo1">Arqueo de Caja</strong></h4>
    </div>
</div>

<div class="col-xs-12 col-sm-12 col-md-12 col-lg-12">
    <!-- REPORTE  -->
    <fieldset class="well scheduler-border">
        <legend class="scheduler-border btn btn-success btn-sm" align="left"><span>Arqueo de Caja</span></legend>
        <form role = "form" class="form-horizontal" name="" action="" method="post" target="_blank">
            
        
        <!-- FECHA A BUSCAR INICIAL -->
        <div class="col-xs-12 col-sm-4 col-md-4 col-lg-4 seleccionadorfecha">            
            <div id="datetimepicker1" class="input-append date">
                <h5>Fecha inicial (AAAA-MM-DD)
                    <input  size="10" data-format="yyyy-MM-dd" type="text" class="input-sm fechainicial" id="fechainicial" name="fechainicial" value="" />
                </h5>
            </div> 
        </div>
        <!-- FECHA A BUSCAR FINAL -->
        <div class="col-xs-12 col-sm-4 col-md-4 col-lg-4 seleccionadorfecha">            
            <div id="datetimepicker2" class="input-append date">
                <h5>Fecha final (AAAA-MM-DD)                
                    <input  size="10" data-format="yyyy-MM-dd" type="text" class="input-sm fechafinal" id="fechafinal" name="fechafinal" value=""  />
                </h5>
            </div> 
        </div>
        <!-- BOTON GENERAR CONSULTA -->
        <div class="col-xs-12 col-sm-2 col-md-2 col-lg-2">  
            <input type="button" class="form-control btn btn-info btnconsultar" value="Consultar" />
        </div>
        <!-- BOTON IMPRIMIR CONSULTA -->
        <div class="col-xs-12 col-sm-2 col-md-2 col-lg-2 botonimprimir" id="botonimprimir">  
            
        </div>
        
        <div class="clearfix"></div>
        <!-- ERRORES -->
        <div class="errorconsulta"></div>
        
        <div class="col-xs-12 col-sm-6 col-md-6 col-lg-6 consultagenerada">
            
        </div>
        </form>
    </fieldset>
</div>

<script type = "text/javascript">
$(function() 
{ 
    // CAMPOS OCULTOS
    $('.mensajeespera').hide();
    
    // FECHA INCIAL
    jQuery.datetimepicker.setLocale('es');
    $('#fechainicial').datetimepicker(
    {
    	timepicker:false,
    	format:'Y-m-d',
    	formatDate:'Y-m-d',
    	formatDate:'d.m.Y',	
    	defaultDate:'+01.01.1970',
        i18n: {es: { // Spanish
				months: [
					"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
				],
				dayOfWeekShort: [
					"Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"
				],
				dayOfWeek: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"]
			}}
    })
    
    // FECHA FINAL
    jQuery.datetimepicker.setLocale('es');
    $('#fechafinal').datetimepicker(
    {
    	timepicker:false,
    	format:'Y-m-d',
    	formatDate:'Y-m-d',
    	formatDate:'d.m.Y',	
    	defaultDate:'+01.01.1970',
        i18n: {es: { // Spanish
				months: [
					"Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"
				],
				dayOfWeekShort: [
					"Dom", "Lun", "Mar", "Mié", "Jue", "Vie", "Sáb"
				],
				dayOfWeek: ["Domingo", "Lunes", "Martes", "Miércoles", "Jueves", "Viernes", "Sábado"]
			}}
    })
    
    // GENERAR CONSULTA DE ESTERILIZACION
    $('.btnconsultar').on('click', function()
    {
        var fechainicial    =   $('.fechainicial').val()
        var fechafinal      =   $('.fechafinal').val()
        if(!fechainicial)
        {
            $('.errorconsulta').html('<div class="alert alert-danger" id="alerta" role="alert"><img src="<?php echo base_url('img/mensaje_error_dato.png');?>" /> <strong>Error en campo fecha inicial</strong><p>no puede estar vacio, por favor verifique</p></div>');
            return false;
        }else
        {
            $('.errorconsulta').html('');
            if(!fechafinal)
            {
                $('.errorconsulta').html('<div class="alert alert-danger" id="alerta" role="alert"><img src="<?php echo base_url('img/mensaje_error_dato.png');?>" /> <strong>Error en campo fecha final</strong><p>no puede estar vacio, por favor verifique</p></div>');
                return false;
            }else
            {
                $('.errorconsulta').html('');
                cargaconsulta(fechainicial, fechafinal)                
            }
        }    
    });
    
})

function cargaconsulta(fechainicial, fechafinal)
{   
    $.ajax(
    {
        url: '<?php echo base_url();?>1historias/hmconsulta/tconarqueo',
        type: 'POST',                    
        data:{fechainicial:fechainicial, fechafinal:fechafinal},                                       
        success: function(data)
        {   
            $('.consultagenerada').html(data);                            
        } 
    });
}
</script>
