/*! jQuery imgNotes - v0.9.0 - 2016-08-09
 * https://github.com/waynegm/imgNotes
 * Copyright (c) 2016 Wayne Mogg; Licensed MIT
 * Editado por Edwin Palacios <epalacios13@outlook.com>
 */
(function($) {
    $.widget("wgm.imgNotes", {
        options: {
            zoom: 1,
            zoomStep: 0.1,
            zoomable: false,
            dragable: false,
            canEdit: true,
            vAll: "middle",
            hAll: "middle",
            /*
             * Default callback to create a marker indicating a note location
             *  See the examples for more elaborate alternatives.
             */
            onAdd: function() {
                this.options.vAll = "bottom";
                this.options.hAll = "middle";
                var elem = $(document.createElement('span')).addClass("pin tooltipc");
                return elem;
            },
            /*
             *  Default callback when the marker is clicked and the widget has canEdit = true
             *  Opens a dialog with a textarea to write a note.
             *  See the examples for a more elaborate alternative that includes a WYSIWYG editor
             */
            onEdit: function(ev, elem) {
                var $elem = $(elem);
                bootbox.hideAll();
                bootbox.dialog({
                    title: '&nbsp;',
                    message: "<input type='text' id='Note_txt' class='form-control' placeholder='Titulo' autofocus /><br><div id='cp' class='input-group colorpicker-component'><input type='text' class='form-control' id='Color_txt'/><span class='input-group-addon'><i></i></span></div>",
                    size: "small",
                    onEscape: function() {
                        if ($('#Note_txt').val() === '') {
                            $elem.trigger("remove");
                        }
                    },
                    buttons: {
                        Eliminar: {
                            label: '<i class="glyphicon glyphicon-remove"></i> Eliminar',
                            className: 'btn-danger',
                            callback: function() {
                                $elem.trigger("remove");
                            }
                        },
                        Guardar: {
                            label: '<i class="glyphicon glyphicon-ok"></i> Guardar',
                            className: 'btn-success',
                            callback: function() {
                                $elem.data("note", $('#Note_txt').val());
                                $elem.data("color", $('#Color_txt').val());
                                $elem.css("background-color", $("#Color_txt").val());
                                $elem.attr('title', $elem.data("note"));
                                $elem.html('<div>' + $elem.data("note") + '</div>');
                            }
                        }
                    }
                });
                // Funcion para cuando le den cerrar al modal verifique si hay datos
                $(".bootbox-close-button").click(function(event) {
                    if ($('#Note_txt').val() === '') {
                        $elem.trigger("remove");
                    }
                });
                // Poner los valores en los campos
                $('#Note_txt').val($elem.data("note"));
                $('#Color_txt').val($elem.data("color"));
                // Activar plugin de color picker
                $('#cp').add('#Color_txt').colorpicker({
                    format: 'rgba',
                    color: '#000'
                });
            },
            /*
             *  Default callback when the marker is clicked and the widget has canEdit = false
             *  Opens a dialog displaying the contents of the marker's note
             *  See examples for alternatives such as using tooltips.
             */
            onShow: function(ev, elem) {
                var $elem = $(elem);
                bootbox.hideAll();
                bootbox.dialog({
                    message: $elem.data("note"),
                    size: "small",
                });
            },
            /*
             *  Default callback when the markers are repainted
             */
            onUpdateMarker: function(elem) {
                var $elem = $(elem);
                var $img = $(this.img);
                var pos = $img.imgViewer("imgToView", $elem.data("relx"), $elem.data("rely"));
                if (pos) {
                    $elem.css({
                        left: (pos.x - $elem.data("xOffset")),
                        top: (pos.y - $elem.data("yOffset")),
                        position: "absolute"
                    });
                }
            },
            /*
             *  Default callback when the image view is repainted
             */
            onUpdate: function() {
                var self = this;
                $.each(this.notes, function() {
                    self.options.onUpdateMarker.call(self, this);
                });
            }
        },
        _create: function() {
            var self = this;
            if (!this.element.is("img")) {
                $.error('imgNotes plugin can only be applied to img elements');
            }
            // the note/marker elements
            self.notes = [];
            // the number of notes
            self.noteCount = 0;
            // the original img element
            self.img = self.element[0];
            var $img = $(self.img);
            // attach the imgViewer plugin for zooming and panning with a custon click and update callbacks
            $img.imgViewer({
                onClick: function(ev, imgv) {
                    if (self.options.canEdit) {
                        ev.preventDefault();
                        var rpos = imgv.cursorToImg(ev.pageX, ev.pageY);
                        if (rpos) {
                            var elem = self.addNote(rpos.x, rpos.y);
                            self._trigger("onEdit", ev, elem);
                        }
                    }
                },
                onUpdate: function(ev, imgv) {
                    self.options.zoom = imgv.options.zoom;
                    self.options.onUpdate.call(self);
                },
                zoom: self.options.zoom,
                zoomStep: self.options.zoomStep,
                zoomable: self.options.zoomable,
                dragable: self.options.dragable
            });
            $img.imgViewer("update");
        },
        /*
         *  Remove the plugin
         */
        destroy: function() {
            this.clear();
            $(this.img).imgViewer("destroy");
            $.Widget.prototype.destroy.call(this);
        },
        _setOption: function(key, value) {
            switch (key) {
                case 'vAll':
                    switch (value) {
                        case 'top':
                            break;
                        case 'bottom':
                            break;
                        default:
                            value = 'middle';
                    }
                    break;
                case 'hAll':
                    switch (value) {
                        case 'left':
                            break;
                        case 'right':
                            break;
                        default:
                            value = 'middle';
                    }
                    break;
            }
            var version = $.ui.version.split('.');
            if (version[0] > 1 || version[1] > 8) {
                this._super(key, value);
            } else {
                $.Widget.prototype._setOption.apply(this, arguments);
            }
            switch (key) {
                case 'zoom':
                    $(this.img).imgViewer("option", "zoom", value);
                    break;
                case 'zoomStep':
                    $(this.img).imgViewer("option", "zoomStep", value);
                    break;
                case 'zoomable':
                    $(this.img).imgViewer("option", "zoomable", value);
                    break;
                case 'dragable':
                    $(this.img).imgViewer("option", "dragable", value);
                    break;
            }
        },
        /*
         *  Pan the view to be centred at the given relative image location
         */
        panTo: function(relx, rely) {
            return $(this.img).imgViewer("panTo", relx, rely);
        },
        /*
         *  Add a note
         */
        addNote: function(relx, rely, text, color) {
            var self = this;
            this.noteCount++;
            var elem = this.options.onAdd.call(this);
            var $elem = $(elem);
            $(this.img).imgViewer("addElem", elem);
            $elem.data("relx", relx).data("rely", rely);
            $elem.data("note", text).data("color", color);
            $elem.attr('title', text);
            $elem.css('background-color', color);
            if (text) $elem.html('<div>' + text + '</div>');
            switch (this.options.vAll) {
                case "top":
                    $elem.data("yOffset", 0);
                    break;
                case "bottom":
                    $elem.data("yOffset", $elem.height());
                    break;
                default:
                    $elem.data("yOffset", Math.round($elem.height() / 2));
            }
            switch (this.options.hAll) {
                case "left":
                    $elem.data("xOffset", 0);
                    break;
                case "right":
                    $elem.data("xOffset", $elem.width());
                    break;
                default:
                    $elem.data("xOffset", Math.round($elem.width() / 2));
            }
            $elem.click(function(ev) {
                ev.preventDefault();
                if (self.options.canEdit) {
                    self._trigger("onEdit", ev, elem);
                } else {
                    self._trigger("onShow", ev, elem);
                }
            });
            $elem.on("remove", function() {
                self._delete(elem);
            });
            this.notes.push(elem);
            $(this.img).imgViewer("update");
            return elem;
        },
        /*
         *  Number of notes
         */
        count: function() {
            return this.noteCount;
        },
        /*
         *  Delete a note
         */
        _delete: function(elem) {
            this.noteCount--;
            this.notes = this.notes.filter(function(v) {
                return v !== elem;
            });
            $(elem).off();
            $(elem).remove();
            $(this.img).imgViewer("update");
        },
        /*
         *  Clear all notes
         */
        clear: function() {
            var self = this;
            var total = self.notes.length;
            for (var i = 0; i < total; i++) {
                var $this = self.notes[i];
                $this.off();
                $this.remove();
            }
            self.notes = [];
            self.noteCount = 0;
        },
        /*
         *  Add notes from a javascript array
         */
        import: function(notes) {
            var self = this;
            $.each(JSON.parse(notes), function() {
                self.addNote(this.x, this.y, this.note, this.color);
            });
            $(this.img).imgViewer("update");
        },
        /*
         *  Export notes to an array
         */
        export: function() {
            var notes = [];
            $.each(this.notes, function() {
                var $elem = $(this);
                notes.push({
                    x: $elem.data("relx"),
                    y: $elem.data("rely"),
                    note: $elem.data("note"),
                    color: $elem.data("color")
                });
            });
            return notes;
        }
    });
})(jQuery);